package com.bokesoft.distro.tech.yigosupport.extension.coordinate.impl;

import com.bokesoft.distro.tech.commons.basis.coordinate.SemaphoreEventBus;
import com.bokesoft.distro.tech.commons.basis.coordinate.impl.SimpleSemaphoreChannel;
import com.bokesoft.distro.tech.commons.basis.coordinate.intf.ISemaphoreChannel;
import com.bokesoft.distro.tech.commons.basis.coordinate.intf.ISemaphoreChannelFactory;
import com.bokesoft.distro.tech.yigosupport.extension.coordinate.intf.RedisFactory;
import com.bokesoft.yes.mid.redis.RedisCacheFactory;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.cache.ICacheFactory;
import com.bokesoft.yigo.mid.nosql.ConnectionFactory;

public class YigoSemaphoreChannelFactory implements ISemaphoreChannelFactory {
    @Override
    public ISemaphoreChannel createChannel(SemaphoreEventBus eventBus) throws Exception {
        ICacheFactory factory = CacheFactory.getInstance();
        if (factory instanceof RedisCacheFactory) {
            RedisFactory redisFactory = RedisFactory.from(ConnectionFactory.getInstance().getConnection());
            return new RedisSemaphoreChannel(eventBus, redisFactory);
        } else {
            return new SimpleSemaphoreChannel(eventBus);
        }
    }
}
