package com.bokesoft.distro.tech.yigosupport.extension.base.log.util;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

import com.bokesoft.yes.mid.connection.dbmanager.GeneralDBManager;

public class YigoSlf4jUtil {
	/**
	 * MDC 属性, 用于记录执行 Yigo SQL 的类和方法
	 */
	public static String MDC_KEY_SQL_EXECUTOR = "SQL_EXECUTOR";
	
	private static final Logger DEF_LOG = LoggerFactory.getLogger(YigoSlf4jUtil.class);
	private static final Map<String, Logger> LOGS = new HashMap<>();
	
	private static String SQL_LOGGER_CLASS = GeneralDBManager.class.getName();
	private static String SQL_LOGGER_METHOD = "sqlLog";
	
	private static Logger getLogger(StackTraceElement[] stacks) {
		int index = 3;	//取到调用者所在的堆栈

		int stackLen = stacks.length;
		if (stackLen <= index) {
			return DEF_LOG;
		}

		String logger = stacks[index].getClassName();
		
		Logger log = LOGS.get(logger);
		if (null==log) {
			synchronized (YigoSlf4jUtil.class) {
				log = LoggerFactory.getLogger(logger);
				LOGS.put(logger, log);
			}
		}
		
		//对于 SQL 的日志, 记录其发生地点
		if (log.isDebugEnabled()) {	//目前 Yigo 的实现, SQL 日志是 debug 打出的
			if (SQL_LOGGER_CLASS.equals(logger) && SQL_LOGGER_METHOD.equals(stacks[index].getMethodName())) {
				for (int i=index+1; i<stackLen; i++) {
					String className = stacks[i].getClassName();
					if (! SQL_LOGGER_CLASS.equals(className)) {
						MDC.put(MDC_KEY_SQL_EXECUTOR, className+"#"+stacks[i].getMethodName());
						break;
					}
				}
			}
		}

		return log;
	}
	
	public static void callLogger(LogCallback callback) {
		Logger log = getLogger(Thread.currentThread().getStackTrace());
		try {
			callback.call(log);
		}finally {
			MDC.remove(MDC_KEY_SQL_EXECUTOR);
		}
	}

	public interface LogCallback{
		void call(Logger log);
	}
}
