/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo;

import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.SessionUtils;
import com.bokesoft.yes.common.util.SerializeUtil;
import com.bokesoft.yes.tools.cache.ICacheCallback;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.mid.file.util.AttachmentUtil;
import com.bokesoft.yigo.tools.ve.VE;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheFactoryWrapUtil {
    private static final String METHOD_INSTANCE = "getInstance";
    private static final String METHOD_CREATE_CACHE = "createCache";
    private static final String CACHE_FACTORY_CLASS_NAME_2 = "com.bokesoft.yes.tools.cache.CacheFactory";
    private static final String CACHE_FACTORY_CLASS_NAME_3 = "com.bokesoft.yigo.cache.CacheFactory";
    private static final int COMMON_LIMIT_SIZE = 1024;
    private static final Map<String, ICache<?>> CACHE_MAP = new ConcurrentHashMap();
    private static final Class<?> CACHE_FACTORY_CLASS = CacheFactoryWrapUtil.getCacheFactoryClass();
    private static final String STORE_DIR_DATE_FORMAT = "yyyy/MM/dd";

    public static <V> ICache<V> getCache(String cacheKey) {
        return CACHE_MAP.computeIfAbsent(cacheKey, val -> CacheFactoryWrapUtil.buildCache(cacheKey));
    }

    public static <V> ICache<V> getBigDataCache(String cacheKey, String formKey) {
        return CacheFactoryWrapUtil.getBigDataCache(cacheKey, formKey, 1024);
    }

    public static <V> ICache<V> getBigDataCache(String cacheKey, String formKey, int limitSize) {
        if (StringUtils.isBlank((CharSequence)formKey)) {
            throw new RuntimeException("\u4f7f\u7528BigDataCache\u5fc5\u987b\u8f93\u5165\u6709\u6548Fomrkey!");
        }
        ICache<V> result = CacheFactoryWrapUtil.getCache(cacheKey);
        return new WrapperCache(result, cacheKey, formKey, limitSize);
    }

    private static <V> ICache<V> buildCache(String cacheKey) {
        try {
            Object iCacheFactoryObj = MethodUtils.invokeStaticMethod(CACHE_FACTORY_CLASS, (String)METHOD_INSTANCE, (Object[])new Object[0]);
            ICache result = (ICache)MethodUtils.invokeMethod((Object)iCacheFactoryObj, (String)METHOD_CREATE_CACHE, (Object[])new Object[]{cacheKey});
            return result;
        }
        catch (Exception e) {
            return (ICache)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private static Class<?> getCacheFactoryClass() {
        try {
            Class<?> factoryClass;
            try {
                factoryClass = Class.forName(CACHE_FACTORY_CLASS_NAME_3);
            }
            catch (ClassNotFoundException e) {
                factoryClass = Class.forName(CACHE_FACTORY_CLASS_NAME_2);
            }
            return factoryClass;
        }
        catch (ClassNotFoundException e) {
            return (Class)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public static class WrapperCache<V>
    implements ICache<V> {
        private static final String PROTOCOL_ATTACHMENT = "yigo-attachment:";
        private Logger logger = LoggerFactory.getLogger(this.getClass());
        private ICache innerCache;
        private String cacheKey;
        private String formKey;
        private int limitSize;

        public WrapperCache(ICache cache, String cacheKey, String formKey, int limitSize) {
            this.innerCache = cache;
            this.cacheKey = cacheKey;
            this.formKey = formKey;
            this.limitSize = limitSize;
        }

        public void put(String key, V value) {
            if (value.getClass().isPrimitive()) {
                this.innerCache.put(key, value);
                return;
            }
            byte[] bytes = SerializeUtil.serialize(value);
            if (bytes.length < this.limitSize) {
                this.innerCache.put(key, value);
                return;
            }
            String fileUrl = SessionUtils.processWithContext("", ctx -> {
                String dir = this.cacheKey + "/" + DateFormatUtils.format((Date)new Date(), (String)CacheFactoryWrapUtil.STORE_DIR_DATE_FORMAT);
                long oid = System.currentTimeMillis();
                String url = AttachmentUtil.newProvider((String)"", (VE)ctx.getVE()).upload(ctx, key, this.formKey, oid, "", dir, bytes, true);
                return url;
            });
            this.logger.debug("\u7f13\u5b58(name='{}',key='{}') \u5b58\u653e\u6570\u636e\u5927\u4e8e {}, \u4f7f\u7528\u9644\u4ef6\u6a21\u5f0f\u8bb0\u5f55, \u9644\u4ef6\u8def\u5f84 '{}'", new Object[]{this.cacheKey, key, this.limitSize, fileUrl});
            this.innerCache.put(key, (Object)(PROTOCOL_ATTACHMENT + fileUrl));
        }

        public V get(String key) {
            Object result = this.innerCache.get(key);
            if (result instanceof String && result.toString().startsWith(PROTOCOL_ATTACHMENT)) {
                String fileUrl = result.toString().substring(PROTOCOL_ATTACHMENT.length());
                byte[] data = SessionUtils.processWithContext("", ctx -> {
                    byte[] bytes = (byte[])AttachmentUtil.newProvider((String)"", (VE)ctx.getVE()).download(ctx, this.formKey, fileUrl);
                    return bytes;
                });
                this.logger.debug("\u7f13\u5b58(name='{}',key='{}') \u5b58\u653e\u5185\u5bb9\u4e3a\u5927\u6570\u636e, \u9644\u4ef6\u8def\u5f84\u4e3a '{}'", new Object[]{this.cacheKey, key, result});
                return (V)SerializeUtil.unSerialize((byte[])data);
            }
            return (V)result;
        }

        public boolean contains(String key) {
            return this.innerCache.contains(key);
        }

        public void remove(String key) {
            this.innerCache.remove(key);
        }

        public void removeAll(List<String> keyList) {
            this.innerCache.removeAll(keyList);
        }

        public Set<String> getKeys() {
            return this.innerCache.getKeys();
        }

        public void clear() {
            this.innerCache.clear();
        }

        public long size() {
            return this.innerCache.size();
        }

        public boolean isEmpty() {
            return this.innerCache.isEmpty();
        }

        public Map<String, V> getAll(List<String> keyList) {
            HashMap<String, V> result = new HashMap<String, V>();
            if (null != keyList && !keyList.isEmpty()) {
                for (String key : keyList) {
                    result.put(key, this.get(key));
                }
            }
            return result;
        }

        public Long[] findGroupIds(Object[][] objects) {
            return this.innerCache.findGroupIds(objects);
        }

        public Boolean insertGroupIds(Object[][] objects, Long[] longs) {
            return this.innerCache.insertGroupIds(objects, longs);
        }

        public long incr(String s, long l, ICacheCallback iCacheCallback) {
            return this.innerCache.incr(s, l, iCacheCallback);
        }

        public Object getOriginalValue(String key) {
            Object result = this.innerCache.get(key);
            return result;
        }
    }
}

