/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.filter;

import com.bokesoft.yes.common.trace.TraceTools;
import com.bokesoft.yigo.common.trace.OverflowStrategy;
import com.bokesoft.yigo.common.trace.TraceSystemManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.util.Wildcard;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TracePrepareFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TracePrepareFilter.class);
    private static final String YES_HEADINFOS = "headinfos";
    private static final String YES_SYS_OPT_ID = "Sys_Opt_ID";
    public static final String PARA_OVERFLOW_LIMIT = "PARA_OVERFLOW_LIMIT";
    public static final String PARA_OVERFLOW_STRATEGY = "PARA_OVERFLOW_STRATEGY";
    private int overflowLimit = 30;
    private OverflowStrategy overflowStrategy = OverflowStrategy.LOG_AND_DROP;
    private final List<String> STATIC_RESOURCE_URLS = Arrays.asList("*.jpg", "*.png", "*.git", "*.woff2", "*.js", "*.css", "*.less", "*.js.map");

    public void init(FilterConfig filterConfig) throws ServletException {
        String overflowStrategyStr;
        String limitStr = filterConfig.getInitParameter(PARA_OVERFLOW_LIMIT);
        if (StringUtils.isNotBlank((CharSequence)limitStr)) {
            try {
                this.overflowLimit = Integer.parseInt(limitStr);
            }
            catch (NumberFormatException e) {
                this.overflowLimit = 30;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(overflowStrategyStr = filterConfig.getInitParameter(PARA_OVERFLOW_STRATEGY)))) {
            switch (overflowStrategyStr) {
                case "DROP": {
                    this.overflowStrategy = OverflowStrategy.DROP;
                }
                case "LOG_AND_DROP": {
                    this.overflowStrategy = OverflowStrategy.LOG_AND_DROP;
                }
                case "LOG_AND_RESET": {
                    this.overflowStrategy = OverflowStrategy.LOG_AND_RESET;
                }
            }
            this.overflowStrategy = OverflowStrategy.LOG_AND_DROP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String url = req.getServletPath();
        if (this.isStaticResourceUrl(url)) {
            chain.doFilter(request, response);
        } else {
            String parentSpanId;
            JSONObject headInfos;
            String headinfoStr;
            String spanId = TraceTools.createNanoId();
            String traceId = null;
            traceId = req.getHeader("x-b3-traceid");
            if (StringUtils.isBlank((CharSequence)traceId) && StringUtils.isNotBlank((CharSequence)(headinfoStr = request.getParameter(YES_HEADINFOS))) && !(headInfos = new JSONObject(headinfoStr)).isNull(YES_SYS_OPT_ID)) {
                traceId = headInfos.getString(YES_SYS_OPT_ID);
            }
            if (StringUtils.isBlank((CharSequence)traceId)) {
                traceId = TraceTools.createNanoId();
            }
            if (StringUtils.isBlank((CharSequence)(parentSpanId = req.getHeader("x-b3-spanid")))) {
                parentSpanId = "";
            }
            TraceSystemManager.initializeTraceContext((String)traceId, (String)spanId, (String)parentSpanId);
            TraceSystemManager.initializeDataTrace((int)this.overflowLimit, (OverflowStrategy)this.overflowStrategy);
            try {
                TraceSystemManager.withTraceLog(() -> {
                    chain.doFilter(request, response);
                    return null;
                }, (Object)req.getRequestURI(), (boolean)false, (Logger)LOGGER, (Level)Level.INFO);
            }
            catch (Throwable te) {
                TraceSystemManager.setEnforceError();
                ExceptionUtils.rethrow((Throwable)te);
            }
            finally {
                TraceSystemManager.printDataRecord();
                TraceSystemManager.clearTraceContext();
                TraceSystemManager.clearDataTrace();
            }
        }
    }

    private boolean isStaticResourceUrl(String url) {
        for (String urlPattern : this.STATIC_RESOURCE_URLS) {
            if (!Wildcard.match((CharSequence)url, (CharSequence)urlPattern)) continue;
            return true;
        }
        return false;
    }
}

