/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.extension.cache;

import com.bokesoft.distro.tech.yigosupport.extension.cache.SqlQueryCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlQueryCacheManager {
    private static final Logger log = LoggerFactory.getLogger(SqlQueryCacheManager.class);
    private static final Map<String, SqlQueryCache> caches = new ConcurrentHashMap<String, SqlQueryCache>();

    public static SqlQueryCache getCache(Class<?> clazz) {
        return SqlQueryCacheManager.getCache(clazz.getName());
    }

    public static SqlQueryCache getCache(String name) {
        log.debug("get SqlQueryCache [{}]", (Object)name);
        return caches.computeIfAbsent(name, key -> {
            log.debug("create SqlQueryCache [{}]", key);
            return new SqlQueryCache((String)key);
        });
    }
}

