package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.struct;

import jodd.util.Wildcard;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Yigo serviceId 的各个部分的结构化拆分
 */
public class ServiceIdParts {
	private static final String PART_BLANK_HOLDER= "-";
	private String service;
	private String cmd;
	private String project;
	private String object;
	private List<String> arguments;
	
	private ServiceIdParts() {
		this.arguments = new ArrayList<>();
	}
	
	public String getService() {
		return service;
	}
	public void setService(String service) {
		this.service = service;
	}

	public String getCmd() {
		return cmd;
	}
	public void setCmd(String cmd) {
		this.cmd = cmd;
	}

	public String getProject() {
		return project;
	}
	public void setProject(String project) {
		this.project = project;
	}

	public String getObject() {
		return object;
	}
	public void setObject(String object) {
		this.object = object;
	}

	public List<String> getArguments() {
		return arguments;
	}

	public void setArguments(List<String> arguments) {
		this.arguments = arguments;
	}

	public static ServiceIdParts build(String serviceId) {
		if (null==serviceId) {
			serviceId = "";
		}
		while (serviceId.startsWith("/")) {
			serviceId = serviceId.substring(1);
		}
		
		ServiceIdParts result = new ServiceIdParts();
		//首先使用 "/" 切分
		String[] parts = serviceId.split("\\/");
		if ( parts.length > 0 ) {
			result.service = read(parts[0]);
		}
		if ( parts.length > 1 ) {
			result.cmd = read(parts[1]);
		}
		if ( parts.length > 2 ) {
			result.project = read(parts[2]);
		}
		if ( parts.length > 3 ) {
			result.object = read(parts[3]);
		}
		if ( parts.length > 4 ) {
			String args = read(parts[4]);
			//多个参数使用 "|" 切分
			String[] argArr = args.split("\\|");
			if ( argArr.length > 0 ) {
				result.arguments.addAll(Arrays.asList(argArr));
			}
		}
		return result;
	}
	
	public static ServiceIdParts build(String service, String cmd, String project, String object, String args) {
		String serviceId = read(service)+"/"+ read(cmd)+"/"+ read(project)+"/"+ read(object)+"/"+ read(args);
		return build(serviceId);
	}

	private static String read(String val) {
		if (StringUtils.isBlank(val)) {
			return "";
		}
		val = val.trim();
		if (PART_BLANK_HOLDER.equals(val)) {
			return "";
		}
		return val;
	}
	
	public String toServiceId() {
		List<String> parts = new ArrayList<>();
		parts.add(write(service));
		parts.add(write(cmd));
		parts.add(write(project));
		parts.add(write(object));
		
		if (null!=arguments && arguments.size()>0) {
			String args = StringUtils.join(arguments, "|");
			parts.add(args);
		}
		
		return StringUtils.join(parts, "/");
	}
	
	private static String write(String val) {
		if (StringUtils.isBlank(val)) {
			return PART_BLANK_HOLDER;
		}else {
			return val.trim();
		}
	}
	
	public boolean match(String serviceIdPattern) {
		String serviceId = this.toServiceId();
		return Wildcard.matchPath(serviceId, serviceIdPattern);
	}
}