package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.struct.YigoMetaFiled;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.form.MetaForm;

public class MetaUtils {
	/**
	 * 封装单据的meta信息
	 * 
	 * @param document
	 * @param ignoreTables
	 * @return
	 */
	public static Map<String,Object> wrapDocumentMetaStruct(MetaForm metaForm, List<String> ignoreTables) {
		 Map<String,Object> result = new  HashMap<String,Object>();
		String mainTableKey = metaForm.getDataSource().getDataObject().getMainTableKey();
		result.put("mainTable",mainTableKey);
		// 处理明细表
		Map<String, Map<String, YigoMetaFiled>> dtlData = _wrapTableMetaCollection(metaForm, ignoreTables);
		result.put("tables",dtlData);
		return result;
	}

	/**
	 * 封装明细表meta信息
	 * 
	 * @param document
	 * @param ignoreTables
	 * @return
	 */
	private static Map<String, Map<String, YigoMetaFiled>> _wrapTableMetaCollection(MetaForm metaForm,
			List<String> ignoreTables) {
		Map<String, Map<String, YigoMetaFiled>> result = new HashMap<String, Map<String, YigoMetaFiled>>();
		MetaTableCollection tableCollection = metaForm.getDataSource().getDataObject().getTableCollection();
		Iterator<MetaTable> iterator = tableCollection.iterator();
		while (iterator.hasNext()) {
			MetaTable metaTable = iterator.next();
			Map<String, YigoMetaFiled> dtlTableStruc = new LinkedHashMap<String, YigoMetaFiled>();
			for (MetaColumn col : metaTable) {
				dtlTableStruc.put(col.getKey(),
						new YigoMetaFiled(col.getCaption(), DataType.toString(col.getDataType())));
			}
			result.put(metaTable.getKey(), dtlTableStruc);
		}
		return result;
	}
}
