package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.bokesoft.yes.tools.preparesql.PrepareSQL;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.document.DataTableUtil;

/**
 * 和 Yigo 数据处理相关的函数
 */
public class DataUtils {
    /**
     * 将 {@link DataTable} 转换为 List[Map], 每个 Map 对应其中一行, Map 的 Key 调整为大写
     *
     * @param dt                 待处理的 DataTable
     * @param upperCaseFieldName 是否强制使用大些的字段名
     * @return
     */
    public static final List<Map<String, Object>> wrapDataTable(DataTable dt, boolean upperCaseFieldName) {
        DataTableMetaData md = dt.getMetaData();
        int colCount = md.getColumnCount();
        List<String> colNames = new ArrayList<String>();
        for (int i = 0; i < colCount; i++) {
            colNames.add(md.getColumnInfo(i).getColumnKey());
        }

        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        dt.beforeFirst();
        while (dt.next()) {
            Map<String, Object> line = new HashMap<String, Object>();
            for (String col : colNames) {
                Object val = dt.getObject(col);
                if (upperCaseFieldName) {
                    line.put(col.toUpperCase(), val);
                } else {
                    line.put(col, val);
                }
            }
            result.add(line);
        }
        return result;
    }

    /**
     * 封装整个单据JSON化
     *
     * @param document
     * @param upperCaseFieldName
     * @param ignoreTables
     * @return
     */
    public static final Map<String, Object> wrapDocument(Document document, List<String> ignoreTables) {
        Map<String, Object> result = new HashMap<String, Object>();
        // 处理主表
        String mainTable = document.getMetaDataObject().getMainTableKey();
        DataTable mainDt = document.get(mainTable);
        DataTableMetaData md = mainDt.getMetaData();
        int colCount = md.getColumnCount();
        List<String> colNames = new ArrayList<String>();
        for (int i = 0; i < colCount; i++) {
            colNames.add(md.getColumnInfo(i).getColumnKey());
        }
        mainDt.first();
        for (String colName : colNames) {
            result.put(colName, mainDt.getObject(colName));
        }

        // 处理明细表
        MetaTableCollection tableCollection = document.getMetaDataObject().getTableCollection();
        Iterator<MetaTable> iterator = tableCollection.iterator();
        while (iterator.hasNext()) {
            MetaTable metaTable = iterator.next();
            if (metaTable.getKey().equals(mainTable)
                    || (null != ignoreTables && ignoreTables.contains(metaTable.getKey()))) {
                continue;
            }
            DataTable dt = document.get(metaTable.getKey());
            result.put(metaTable.getKey(), wrapDataTable(dt, false));
        }
        return result;
    }

    /**
     * 初始化DataTable数据对象
     *
     * @param ctx
     * @param formKey
     * @param tableKey
     * @return
     * @throws Throwable
     */
    public static DataTable createEmptyDataTable(DefaultContext ctx, String formKey, String tableKey) {
        try {
            MetaForm metaForm = ctx.getVE().getMetaFactory().getMetaForm(formKey);
            MetaTable metaTable = metaForm.getMetaTable(tableKey);
            return DataTableUtil.newEmptyDataTable(metaTable);
        } catch (Throwable throwable) {
            throw new RuntimeException(
                    "formeky:" + formKey + ",tableKey:" + tableKey + " init datatable error!" + throwable.getMessage(),
                    throwable);
        }
    }

    /**
     * 分页查询表
     *
     * @param ctx
     * @param sql
     * @param orderSql
     * @param isBeetween
     * @param startPos
     * @param endPos
     * @param args
     * @return
     * @throws Throwable
     */
    public static DataTable pageQuery(DefaultContext ctx, String sql, String orderSql, boolean isBeetween, int startPos,
                                      int endPos, List<Object> args) throws Throwable {
        IDBManager dbManager = ctx.getDBManager();
        PrepareSQL prepareSQL = dbManager.getLimitString(sql, orderSql, isBeetween, startPos, endPos);
        if (null == args) {
            args = prepareSQL.getPrepareValues();
        } else {
            args.addAll(prepareSQL.getPrepareValues());
        }
        return dbManager.execPrepareQuery(prepareSQL.getSQL(), args);
    }

}
