package com.bokesoft.distro.tech.yigosupport.extension.utils.yigo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.*;

public class AsyncExecuteUtil {
    private static final Logger logger = LoggerFactory.getLogger(AsyncExecuteUtil.class);
    /**
     * 线程池
     */
    private static final Map<String, ThreadPoolExecutor> THREAD_POOL_EXECUTOR_MAP = new HashMap<>();
    /**
     * 缓存任务
     */
    private static final Map<String, Runnable> RUNNABLE_MAP = new HashMap<>();

    /**
     * 构建线程池
     *
     * @return
     */
    private static ThreadPoolExecutor buildThreadPoolExecutor() {
        return new ThreadPoolExecutor(1, 1,
                60L, TimeUnit.SECONDS,
                new ArrayBlockingQueue<>(1), new RejectedExecutionHandler() {
            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                //do nothing
            }
        });
    }

    /**
     * 提交任务
     *
     * @param taskName 任务名称
     * @param task 任务实现
     */
    public static void submit(String taskName, Runnable task) {
        ThreadPoolExecutor threadPoolExecutor = THREAD_POOL_EXECUTOR_MAP.computeIfAbsent(taskName, key -> buildThreadPoolExecutor());
        RUNNABLE_MAP.computeIfAbsent(taskName, key -> task);
        threadPoolExecutor.submit(task);
    }


    /**
     * 心跳检测
     */
    public static void heartCheck() {
        for (String taskName : THREAD_POOL_EXECUTOR_MAP.keySet()) {
            ThreadPoolExecutor threadPoolExecutor = THREAD_POOL_EXECUTOR_MAP.get(taskName);
            if (threadPoolExecutor.isShutdown()) {
                threadPoolExecutor = buildThreadPoolExecutor();
                THREAD_POOL_EXECUTOR_MAP.put(taskName, threadPoolExecutor);
            }
            if (null == RUNNABLE_MAP.get(taskName)) {
                logger.warn("taskName:{}不存在相应的Runnable实现,该任务将无法被执行", taskName);
            } else {
                threadPoolExecutor.submit(RUNNABLE_MAP.get(taskName));
            }
        }
    }
}
