package com.bokesoft.distro.tech.yigosupport.extension.redisdescr;

import com.bokesoft.base.bokebase.rediscache.CacheDescription;
import com.bokesoft.base.bokebase.rediscache.ICacheDescriptionProvider;
import com.bokesoft.base.bokebase.rediscache.struct.DataType;
import com.bokesoft.base.bokebase.rediscache.struct.KeyType;
import com.bokesoft.base.bokebase.rediscache.struct.StoreType;
import com.bokesoft.distro.tech.yigosupport.extension.cache.SqlQueryCache;
import com.bokesoft.distro.tech.yigosupport.extension.exttools.funs.MaskExp;
import com.bokesoft.distro.tech.yigosupport.extension.redisdescr.impl.yee.MaskCacheDataDescriptor;
import com.bokesoft.distro.tech.yigosupport.extension.redisdescr.impl.yee.SqlQueryCacheDataDescriptor;

import java.util.Arrays;
import java.util.List;

public class YeeRedisDescriptionProvider implements ICacheDescriptionProvider{
    @Override
    public List<CacheDescription<?>> getCacheDescriptions() {
        return Arrays.asList(
            buildSqlQueryCacheDescr(), buildMaskCacheDescr()
        );
    }

    /**
     * 构造SqlQueryCache的缓存描述
     * @return
     */
    private CacheDescription<Long> buildSqlQueryCacheDescr(){
       CacheDescription<Long> pcSessionCacheDesc = CacheDescription.Builder.
               newBuilder(SqlQueryCache.SQL_CACHE_KEY_PREFIX, KeyType.PREFIX,"Sql查询结果版本缓存",Long.class)
               .storeType(StoreType.HASH)
               .valueDescriber(new SqlQueryCacheDataDescriptor())
               .build();
        return pcSessionCacheDesc;
    }

    /**
     * 构造掩码的缓存描述
     * @return
     */
    private CacheDescription<String> buildMaskCacheDescr(){
        CacheDescription<String> maskCacheDesc = CacheDescription.Builder.
                newBuilder(MaskExp.MASK_CACHE_KEY, KeyType.FULL_KEY,"掩码原值缓存",String.class)
                .storeType(StoreType.HASH)
                .dataType(DataType.STR)
                .valueDescriber(new MaskCacheDataDescriptor())
                .build();
        return maskCacheDesc;
    }
}
