package com.bokesoft.distro.tech.yigosupport.extension.intf;

import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.struct.ServiceIdParts;

import java.util.Map;

/**
 * 定义 Yigo 服务的 serviceId 计算程序, 作为  IServiceMatcher 的补充, 用于规范化 serviceId 组成, 方便进行分发目标计算.
 */
public interface IServiceIdCalculator {

	public static final String ARGUMENT_NAME_SERVICE = "service";

	public static final String ARGUMENT_NAME_CMD = "cmd";

	public static final String ARGUMENT_NAME_ITEM_KEY = "itemKey";

	public static final String ARGUMENT_NAME_FORM_KEY = "formKey";

	public static final String ARGUMENT_NAME_METAFORM_KEY = "metaFormKey";

	public static final String ARGUMENT_NAME_DATAOBJECT_KEY = "dataObjectKey";

	public static final String ARGUMENT_NAME_EXT_SVR_NAME = "extSvrName";

	/**
	 * 计算 serviceId
	 * @param serviceIdParts serviceId 各部分对象, 在多个 {@link IServiceIdCalculator} 处理过程中被修改
	 * @param originalServiceId Yigo 平台默认计算得出的 serviceId
	 * @param arguments Yigo 服务参数
	 * @return 计算得到的 serviceId 各部分对象, 返回 null 代表不处理当前服务
	 */
	public void calculate(ServiceIdParts serviceIdParts, String originalServiceId, Map<String, Object> arguments);
}
