package com.bokesoft.distro.tech.yigosupport.extension.impl;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.bokesoft.distro.tech.commons.basis.MiscUtil;
import com.bokesoft.distro.tech.yigosupport.extension.BaseStaticWrapperMidFuncRegistryService.FunctionBuildOptions;
import com.bokesoft.distro.tech.yigosupport.extension.exception.Misc;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.parser.BaseMidFunctionImpl;
import com.bokesoft.yigo.parser.IExecutor;

public class BaseStaticWrapperMidFuncRunner extends BaseMidFunctionImpl {

	private static final Logger log = LoggerFactory.getLogger(BaseStaticWrapperMidFuncRunner.class);
	
	private String formulaPrefix;
	private Class<?> clazz;
	private FunctionBuildOptions options;
	private String method;

	public BaseStaticWrapperMidFuncRunner(String formulaPrefix, Class<?> clazz, FunctionBuildOptions options, String method){
		this.formulaPrefix = formulaPrefix;
		this.clazz = clazz;
		this.options = options;
		this.method = method;
	}
	
	public String getWrapperInfo() {
		return "formulaPrefix=" + formulaPrefix + ", clazz=" + clazz.getName() + ", method=" + method;
	}

	@Override
	public Object evalImpl(String name, DefaultContext ctx, Object[] args, IExecutor executor) {
		try {
			return _doEval(name, ctx, args);
		} catch (Exception e) {
			throw Misc.convertToYigoException(e, log);
		}
	}

	private Object _doEval(String name, DefaultContext ctx, Object[] args) throws ReflectiveOperationException {
		MiscUtil.$assert(
			( (! method.equals(name) )
					&& (! getNarrowFormulaName(this.formulaPrefix, clazz, method, options.isWithClassName()).equals(name) )
					&& (! getUnderlineFormulaName(this.formulaPrefix, clazz, method, options.isWithClassName()).equals(name) )),
			"公式名 '"+name+"' 与当前实现(class='"+clazz.getSimpleName()+"', method='"+method+"')不匹配"
		);
		if (null==args){
			args = new Object[0];
		}
		
		Class<?> _class = clazz;
		String _method = method;
		WrapperUtils.findStaticMethod(ctx, _class, args, _method);
		return WrapperUtils.tryRunStaticMethod(ctx, _class, _method, args);
	}

	protected static String getDottedFormulaName(String prefix, Class<?> formulaClass, String methodName, boolean withClassName) {
		return getFormulaName(prefix, formulaClass, methodName, '.', withClassName);
	}
	
	protected static String getUnderlineFormulaName(String prefix, Class<?> formulaClass, String methodName, boolean withClassName) {
		return getFormulaName(prefix, formulaClass, methodName, '_', withClassName);
	}

	protected static String getNarrowFormulaName(String prefix, Class<?> formulaClass, String methodName, boolean withClassName) {
		String f = getDottedFormulaName(prefix, formulaClass, methodName, withClassName);
		//把 "." 后面的字母强制变成大写
		String[] tmp = f.split("\\.");
		for (int i=1/*=1 忽略开始的第一段*/; i < tmp.length; i++) {
			tmp[i] = StringUtils.capitalize(tmp[i]);
		}
		return StringUtils.join(tmp);
	}

	private static String getFormulaName(String prefix, Class<?> formulaClass, String methodName, char splitter, boolean withClassName) {
		//考虑到 prefix 中也会有 "." 或者 "_", 所以这里先把它们统一到 splitter
		if (null==prefix) { prefix = ""; }
		prefix = prefix.replace('.', splitter);
		prefix = prefix.replace('_', splitter);
		
		if (withClassName){
			return prefix + splitter + formulaClass.getSimpleName() + splitter + methodName;
		}else{
			return prefix + splitter + methodName;
		}
	}

}