package com.bokesoft.distro.tech.yigosupport.extension.coordinate.impl;

import com.bokesoft.distro.tech.yigosupport.extension.coordinate.intf.RedisCommands;
import com.bokesoft.distro.tech.yigosupport.extension.coordinate.intf.RedisFactory;
import com.bokesoft.yes.mid.redis.RedisSimpleConnection;
import redis.clients.jedis.Jedis;

import java.util.function.Supplier;

public class SimpleRedisFactory implements RedisFactory {
    final RedisSimpleConnection connection;

    final Supplier<Jedis> supplier;

    public SimpleRedisFactory(RedisSimpleConnection connection) {
        this.connection = connection;
        this.supplier = connection::getJedis;
    }

    public SimpleRedisFactory(Supplier<Jedis> supplier) {
        this.supplier = supplier;
        this.connection = null;
    }

    @Override
    public RedisCommands getRedis() {
        return new SimpleRedisCommands(supplier.get());
    }

}
