package com.bokesoft.distro.tech.yigosupport.extension.coordinate.impl;

import com.bokesoft.distro.tech.yigosupport.extension.coordinate.intf.RedisCommands;
import com.bokesoft.distro.tech.yigosupport.extension.coordinate.intf.RedisFactory;
import com.bokesoft.yes.mid.redis.RedisClusterConnection;
import org.apache.commons.lang3.reflect.FieldUtils;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.params.SetParams;

public class RedisClusterFactory implements RedisFactory, RedisCommands {
    final JedisCluster cluster;

    public RedisClusterFactory(RedisClusterConnection cnn) throws IllegalAccessException {
        this((JedisCluster) FieldUtils.readDeclaredField(cnn, "cluster", true));
    }

    private RedisClusterFactory(JedisCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public boolean remove(String key){
       return cluster.del(key)!=0;
    }

    @Override
    public long ttl(String key) {
        return cluster.ttl(key);
    }

    @Override
    public String get(String key) {
        return cluster.get(key);
    }

    @Override
    public void setNxEx(String key, String value, long expire) {
        cluster.set(key, value, SetParams.setParams().nx().ex(expire));
    }

    @Override
    public long expire(String key, long seconds) {
        return cluster.expire(key, seconds);
    }

    @Override
    public boolean publish(String channel, String message) {
        return cluster.publish(channel, message) != 0;
    }

    @Override
    public void psubscribe(JedisPubSub jedisPubSub, String channel) {
        cluster.psubscribe(jedisPubSub, channel);
    }

    @Override
    public RedisCommands getRedis() {
        return this;
    }

    @Override
    public void close() throws Exception {

    }
}
