package com.bokesoft.distro.tech.yigosupport.extension.condition;

import java.util.List;

import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.condition.AbstractConditionBuilder;

/**
 * 用于实现 IN 子句的定制查询(来自 物流仓储云平台项目 AbstractConditonMutilSel)
 */
public abstract class AbstractMutilInSelectionConditonBuilder extends AbstractConditionBuilder {

	@Override
	public String getFilter() {
		String value =TypeConvertor.toString(paraTable.getValue(getFieldKey()));
		value=value.substring(1, value.length()-1);
		String[] srcStr=value.split(",");
		if(srcStr.length<=0){
			return " 1=1";
		}
		StringBuilder newValue= new StringBuilder();
		for (String s : srcStr) {
			String[] colIdStr = s.split("_");
			newValue.append(colIdStr[colIdStr.length - 1]).append(",");
		}
		newValue = new StringBuilder(newValue.substring(0, newValue.lastIndexOf(",")));
		String where = getFieldColName() +" in("+newValue+")";
		return where;
	}

	@Override
	public List<Object> getParas() {
		return null;
	}

	/**
	 * 用于查询的字段名称
	 * @return 获取字段key
	 */
	public abstract String getFieldKey();
	
	/**
	 * 用于查询的数据库字段名
	 * @return 获取字段显示名称
	 */
	public abstract String getFieldColName();
}
