package com.bokesoft.distro.tech.yigosupport.extension.base.log;

import com.bokesoft.distro.tech.yigosupport.extension.base.log.util.YigoSlf4jUtil;
import com.bokesoft.yigo.log.ILogSvr;
import com.bokesoft.yigo.struct.env.Env;

public class LogSvrSlf4j implements ILogSvr {
	@Override
	public String getFile() {
		throw new UnsupportedOperationException("不支持 getFile() 方法");
	}

	@Override
	public void info(String message) {
		YigoSlf4jUtil.callLogger(log -> {log.info(message);});
	}

	@Override
	public void debug(String message) {
		YigoSlf4jUtil.callLogger(log -> {log.debug(message);});
	}

	@Override
	public void debug(String message, Throwable err) {
		YigoSlf4jUtil.callLogger(log -> {log.debug(message, err);});
	}

	@Override
	public void error(String message, Throwable err) {
		YigoSlf4jUtil.callLogger(log -> {log.error(message, err);});
	}

	@Override
	public void warn(String message) {
		YigoSlf4jUtil.callLogger(log -> {log.warn(message);});
	}

	private static String getEnvInfo(Env env) {
		return "OperatorID=" + env.getUserID();
	}
	
	@Override
	public void info(Env env, String message) throws Throwable {
		info(getEnvInfo(env) + " " + message);
	}

	@Override
	public void error(Env env, Throwable err) throws Throwable {
		error(getEnvInfo(env), err);
	}
}
