package com.bokesoft.distro.tech.yigosupport.extension.base;

import com.bokesoft.yigo.mid.service.IExtService;

/**
 * 支持自动注册的 Yigo 扩展服务({@link IExtService}).
 */
public interface IExtServiceWrapper extends IExtService {
	/**
	 * 获取拓展开发类的短名称
	 * @return 拓展开发类的短名称
	 */
	default String getName() {
		return this.getClass().getSimpleName();
	}

	/**
	 * 获取拓展开发类的全名
	 * @return 拓展开发类的全名
	 */
	default String getImpl() {
		return this.getClass().getName();
	}

	/**
	 * 二开作用描述
	 * @return 拓展开发类的作用描述
	 */
	default String getDescription() {
		return this.getClass().getName();
	}
}
