/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.deployment.resource;

import com.bokesoft.distro.tech.commons.basis.MiscUtil;
import com.bokesoft.distro.tech.yigosupport.deployment.resource.intf.IResourceIO;
import com.bokesoft.distro.tech.yigosupport.deployment.resource.utils.ResourcePaths;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceMultiSolutionResolver
implements IMetaResolver {
    private static final Logger log = LoggerFactory.getLogger(ResourceMultiSolutionResolver.class);
    private static final String SP = "/";
    private static final char SP_C = "/".charAt(0);
    private String prefix;
    private ResourcePaths resources;
    private IResourceIO resourceIO;

    public ResourceMultiSolutionResolver(List<String> resourceList, IResourceIO resourceIO, String prefix) {
        this.resources = new ResourcePaths(resourceList);
        this.resourceIO = resourceIO;
        if (!prefix.endsWith(SP)) {
            prefix = prefix + SP;
        }
        this.prefix = prefix;
    }

    public boolean isListAbsolutePath() {
        return false;
    }

    public InputStream read(String resource, int type) throws Exception {
        String fullPath = this._fullPath(resource);
        log.debug("[{}] read, resource='{}', type={}", new Object[]{Integer.toHexString(this.hashCode()), fullPath, type});
        byte[] data = this.resourceIO.read(fullPath);
        if (null != data) {
            return new ByteArrayInputStream(data);
        }
        return null;
    }

    public URI getURI(String resource, int type) throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean write(String resource, byte[] data) throws Exception {
        String fullPath = this._fullPath(resource);
        log.debug("[{}] write, resource='{}'", (Object)Integer.toHexString(this.hashCode()), (Object)fullPath);
        this.resourceIO.write(fullPath, data);
        return true;
    }

    public String getPath(String resource) {
        throw new UnsupportedOperationException();
    }

    public int listResource(String resource, String flag, List<String> resources, List<String> names, List<Boolean> flags) throws Exception {
        String fullPath = this._fullPath(resource);
        log.info("[{}] listResource: '{}', flag={}", new Object[]{Integer.toHexString(this.hashCode()), fullPath, flag});
        int count = 0;
        List<String> files = this.resources.listFiles(fullPath);
        for (String file : files) {
            String name = this._getName(file);
            resources.add(name);
            names.add(name);
            flags.add(false);
            ++count;
        }
        List<String> dirs = this.resources.listDirs(fullPath);
        for (String dir : dirs) {
            String name = this._getName(dir);
            resources.add(name);
            names.add(name);
            flags.add(true);
            ++count;
        }
        return count;
    }

    private String _getName(String path) {
        int lastSp = path.lastIndexOf(SP_C);
        if (lastSp < 0) {
            return path;
        }
        MiscUtil.$assert((lastSp >= path.length() - 1 ? 1 : 0) != 0, (String)("\u65e0\u6cd5\u83b7\u53d6\u8def\u5f84\u4e2d\u7684\u6587\u4ef6\u6216\u76ee\u5f55\u540d\u79f0: " + path));
        String name = path.substring(lastSp + 1);
        return name;
    }

    private String _fullPath(String resource) {
        if (resource.startsWith(SP)) {
            resource = resource.substring(1);
        }
        resource = resource.replaceAll("\\\\", SP);
        return this.prefix + resource;
    }

    public char getSeparator() {
        return SP_C;
    }
}

