package com.bokesoft.distro.tech.yigosupport.deployment.resource.intf;

import java.io.IOException;
import java.net.URI;
import java.util.List;

/**
 * 对资源读写能力的定义
 */
public interface IResourceIO {
	/** 固定使用 '/' 作为路径分隔符 */
	public static final String SEPARATOR = "/";

	/**
	 * 列出所有的资源路径(注意: 只包括文件, 不包括目录)
	 * @return
	 * @throws IOException
	 */
	public List<String> list() throws IOException;

	/**
	 * 获取指定资源的 URI
	 * @param resource
	 * @return 如果资源不存在, 返回 null
	 * @throws IOException
	 */
	public default URI getURI(String resource) throws IOException{
		throw new UnsupportedOperationException("Getting the URI for resource '" + resource + "' is not supported");
	}
	
	/**
	 * 读取指定的资源
	 * @param resource
	 * @return 如果资源不存在, 返回 null
	 * @throws IOException
	 */
	public byte[] read(String resource) throws IOException;
	
	/**
	 * 写入指定的资源
	 * @param resource
	 * @param data
	 * @throws IOException
	 */
	public void write(String resource, byte[] data) throws IOException;

	/**
	 * 返回当前资源的实例 ID. 比如: 如果是对应一个根目录的一系列资源, 可以使用根目录路径作为资源实例 ID.
	 * @return 必须有合理的返回值, 不能返回 null
	 */
	public default String getInstanceId() {
		return Integer.toHexString(this.hashCode());
	}
}
