package com.bokesoft.distro.tech.yigosupport.deployment.local;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.bokesoft.distro.tech.commons.basis.MiscUtil;
import com.bokesoft.yigo.meta.base.IMetaResolver;

/**
 * 支持本地多 solution 部署的 MetaResolver, 相关使用方法参考 {@link LocalMultiSolutionMetaResolverFactory}
 */
public class LocalMultiSolutionMetaResolver implements IMetaResolver {
	private static final Logger log = LoggerFactory.getLogger(LocalMultiSolutionMetaResolver.class);
	private static final String FILE_SPILTER = "/";
	
	private String prefix;
	private String fullBasePath;

	public LocalMultiSolutionMetaResolver(String baseDir, String prefix) {
		MiscUtil.$assert(null==baseDir, "构造 IMetaResolver 失败 - baseDir 为空");
		MiscUtil.$assert(null==prefix, "构造 IMetaResolver 失败 - prefix 为空");
		this.prefix = prefix;
		this.fullBasePath = buildFullPath(baseDir, prefix);
	}

	@Override
	public boolean isListAbsolutePath() {
		return false;
	}

	/**
	 * 读取资源;
	 * FIXME 目前 type 没有作用
	 */
	@Override
	public InputStream read(String resource, int type) throws Exception {
		log.debug("[{}] read, prefix|resource='{}|{}', type={}", Integer.toHexString(this.hashCode()), prefix, resource, type);
		File f = getAbsPath4Resource(resource);
		
		if (f.isDirectory() || !f.exists()) {
			return null;
		}
		
		return FileUtils.openInputStream(f);
	}

	/**
	 * 获取资源的地址;
	 * FIXME 目前 type 没有作用
	 */
	@Override
	public URI getURI(String resource, int type) throws Exception {
		log.debug("[{}] getURI, prefix|resource='{}|{}', type={}", Integer.toHexString(this.hashCode()), prefix, resource, type);
		File f = getAbsPath4Resource(resource);
		
		if (f.isDirectory() || !f.exists()) {
			return null;
		}
		
		return f.toURI();
	}

	/**
	 * 写入指定资源;
	 */
	@Override
	public boolean write(String resource, byte[] data) throws Exception {
		log.debug("[{}] write, prefix|resource='{}|{}'", Integer.toHexString(this.hashCode()), prefix, resource);
		File f = getAbsPath4Resource(resource);
		
		FileUtils.writeByteArrayToFile(f, data);
		return true;
	}

	/**
	 * 获取资源的绝对路径;
	 */
	@Override
	public String getPath(String resource) {
		log.debug("[{}] getPath, prefix|resource='{}|{}'", Integer.toHexString(this.hashCode()), prefix, resource);

		File f = getAbsPath4Resource(resource);
		try {
			return f.getCanonicalPath()+ File.separatorChar;
		} catch (IOException e) {
			throw MiscUtil.toRuntimeException(e);
		}
	}

	/**
	 * 获取目录下的资源列表;
	 * FIXME 目前 flag 没有作用.
	 */
	@Override
	public int listResource(
			String resource, String flag, List<String> resources, List<String> names,
			List<Boolean> flags) throws Exception {
		log.info("[{}] listResource: prefix|resource='{}|{}', flag={}", Integer.toHexString(this.hashCode()), prefix, resource, flag);
		
		File f = getAbsPath4Resource(resource);
		File[] files = f.listFiles();
		if (files != null) {
			int length = files.length;
			File childFile = null;
			for (int i = 0; i < length; ++i) {
				childFile = files[i];
				resources.add(childFile.getName());
				names.add(childFile.getName());
				if (childFile.isDirectory()) {
					flags.add(true);
				} else {
					flags.add(false);
				}
			}
		}
		return resources.size();
	}

	@Override
	public char getSeparator() {
		return '/';
	}

	private File getAbsPath4Resource(String resource) {
		String base = this.fullBasePath;
		
		MiscUtil.$assert(null==resource, "指定资源为空");
		
		String fullPath = buildFullPath(base, resource);
		return new File(fullPath);
	}

	private static String buildFullPath(String base, String path) {
		if (! base.endsWith(FILE_SPILTER)) {
			base = base + FILE_SPILTER;
		}
		if (path.startsWith(FILE_SPILTER)) {
			path = path.substring(1);
		}
		String fullPath = base + path;
		return fullPath;
	}
	
	/**
	 * 获取 XML 文件的根元素信息.
	 */
	@Override
	public JSONObject readProfile(String resource, int type) throws Exception {
		log.debug("[{}] readProfile, prefix|resource='{}|{}', type={}", Integer.toHexString(this.hashCode()), prefix, resource, type);
		
		return IMetaResolver.super.readProfile(resource, type);
	}

}
