/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.runtime;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoAdditionalInitiator;
import com.bokesoft.distro.tech.bootsupport.starter.api.YigoBootPreparator;
import com.bokesoft.distro.tech.bootsupport.starter.i18n.StringTable;
import com.bokesoft.distro.tech.bootsupport.starter.runtime.model.InstanceStatus;
import com.bokesoft.distro.tech.bootsupport.starter.utils.YigoPropPreparation;
import com.bokesoft.distro.tech.bootsupport.starter.utils.YigoPropPreparationHelper;
import com.bokesoft.distro.tech.bootsupport.starter.utils.YigoServiceInitHelper;
import com.bokesoft.distro.tech.commons.basis.dependency.DependencySortCore;
import com.bokesoft.distro.tech.yigosupport.extension.ServiceLoaderRegisteringStartListener;
import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.ServiceLoaderRegisteringUtil;
import com.bokesoft.distro.tech.yigosupport.extension.utils.yigo.SessionUtils;
import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.enhance.MetaExtStartListener;
import com.bokesoft.yigo.meta.enhance.MetaStartListener;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class YigoInstanceManager {
    private static final Logger log = LoggerFactory.getLogger(YigoInstanceManager.class);
    public static boolean BOOTING_WITH_SPRING_BOOT = true;
    private static long initStartTime = System.currentTimeMillis();
    private InstanceStatus instanceStatus;
    private Map<String, YigoAdditionalInitiator> additionalInitiators;
    private boolean initializationComplete = false;
    private final Map<Class, String> UNAVALIABLE_REASONS = new ConcurrentHashMap<Class, String>();
    private String initWorkPath;

    public YigoInstanceManager() {
        this.instanceStatus = new InstanceStatus(InstanceStatus.Status.UNAVALIABLE, "Yigo \u73af\u5883\u4e0d\u53ef\u7528", initStartTime);
    }

    public InstanceStatus getInstanceStatus() {
        if (this.UNAVALIABLE_REASONS.isEmpty()) {
            return this.instanceStatus;
        }
        String reason = StringUtils.join(this.UNAVALIABLE_REASONS.values(), (String)";\n");
        log.warn("Yigo\u670d\u52a1\u51fa\u4e0d\u53ef\u7528\u72b6\u6001,\u4e0d\u53ef\u7528\u539f\u56e0\u6709\u4ee5\u4e0b\u8fd9\u4e9b:\n" + reason);
        return new InstanceStatus(InstanceStatus.Status.UNAVALIABLE, reason, initStartTime);
    }

    public boolean isInitializationComplete() {
        return this.initializationComplete;
    }

    public boolean bootPrepare(ApplicationContext ctx, boolean reload) {
        boolean[] result = new boolean[]{false};
        this.trans(InstanceStatus.Status.PREPARING, "Yigo \u73af\u5883\u521d\u59cb\u5316", InstanceStatus.Status.WAITING, () -> {
            log.info("\u51c6\u5907 Yigo \u73af\u5883\u521d\u59cb\u5316 ...");
            YigoPropPreparationHelper.PrepareResult prepareResult = YigoPropPreparation.doPrepare((ApplicationContext)((ConfigurableApplicationContext)ctx));
            log.info("Yigo \u73af\u5883\u521d\u59cb\u5316: workPath={} .", (Object)prepareResult.getWorkPath());
            this.initWorkPath = prepareResult.getWorkPath();
            result[0] = prepareResult.isSilentStart();
            this.doBootPrepare(ctx, prepareResult);
            try {
                YigoServiceInitHelper.initYigoService(prepareResult, reload);
            }
            catch (Exception e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
            Map addInits = ctx.getBeansOfType(YigoAdditionalInitiator.class);
            log.info("Yigo \u73af\u5883\u521d\u59cb\u5316: \u52a0\u8f7d\u9644\u52a0\u521d\u59cb\u5316\u7a0b\u5e8f {} \u4e2a - [{}] .", (Object)addInits.size(), (Object)addInits.keySet().toString());
            this.additionalInitiators = addInits;
            return "Yigo \u73af\u5883\u521d\u59cb\u5316\u5b8c\u6210, \u5305\u62ec " + this.additionalInitiators.size() + " \u4e2a\u9644\u52a0\u521d\u59cb\u5316\u7a0b\u5e8f";
        });
        return result[0];
    }

    private void doBootPrepare(ApplicationContext ctx, YigoPropPreparationHelper.PrepareResult prepareResult) {
        Map bootPreparatorMaps = ctx.getBeansOfType(YigoBootPreparator.class);
        if (null == bootPreparatorMaps || bootPreparatorMaps.isEmpty()) {
            return;
        }
        log.info("Yigo \u73af\u5883\u521d\u59cb\u524d: \u52a0\u8f7d\u9644\u52a0\u51c6\u5907\u7a0b\u5e8f {} \u4e2a - [{}] .", (Object)bootPreparatorMaps.size(), (Object)bootPreparatorMaps.keySet().toString());
        List<Object> bootPreparators = new ArrayList(bootPreparatorMaps.values());
        bootPreparators = DependencySortCore.sort(bootPreparators);
        for (YigoBootPreparator yigoBootPreparator : bootPreparators) {
            yigoBootPreparator.prepare(prepareResult);
        }
    }

    public void bootLoad() {
        this.trans(InstanceStatus.Status.LOADING, "\u52a0\u8f7d Yigo \u7a0b\u5e8f", InstanceStatus.Status.READY, () -> {
            log.info("\u51c6\u5907\u52a0\u8f7d Yigo \u7a0b\u5e8f ...");
            SessionUtils.processWithContext(null, yigoCtx -> {
                this.enabledServiceLoaderRegister(yigoCtx);
                log.info("\u52a0\u8f7d Yigo \u7a0b\u5e8f: \u6ce8\u518c ServiceLoader \u6269\u5c55\u7a0b\u5e8f\u5b8c\u6210 .");
                return null;
            });
            for (Map.Entry<String, YigoAdditionalInitiator> en : this.additionalInitiators.entrySet()) {
                SessionUtils.processWithContext(null, yigoCtx -> {
                    log.debug("\u52a0\u8f7d Yigo \u7a0b\u5e8f: YigoAdditionalInitiator '{}' starting ...", en.getKey());
                    YigoAdditionalInitiator init = (YigoAdditionalInitiator)en.getValue();
                    init.init(yigoCtx);
                    log.info("\u52a0\u8f7d Yigo \u7a0b\u5e8f: YigoAdditionalInitiator '{}' started.", en.getKey());
                    return true;
                });
            }
            this.resetWorkPath();
            log.info("\u52a0\u8f7d Yigo \u7a0b\u5e8f\u5b8c\u6210 .");
            this.initializationComplete = true;
            return "\u52a0\u8f7d Yigo \u7a0b\u5e8f\u5b8c\u6210";
        });
    }

    public void resetWorkPath() {
        SvrInfo.setWorkDir((String)(this.initWorkPath + File.separator));
        log.info("\u91cd\u65b0\u8bbe\u7f6e WorkDir='{}' .", (Object)this.initWorkPath);
    }

    public void trans(InstanceStatus.Status begin, String transDescr, InstanceStatus.Status end, Supplier<String> callback) {
        try {
            log.info("\u5f00\u59cb\u6267\u884c '{}'({}->{}) ...", new Object[]{transDescr, begin, end});
            this.instanceStatus = new InstanceStatus(begin, transDescr, initStartTime);
            String msg = callback.get();
            log.info("\u6267\u884c '{}'({}->{}) \u6210\u529f: {}.", new Object[]{transDescr, begin, end, msg});
            this.instanceStatus = new InstanceStatus(end, msg, initStartTime);
        }
        catch (Exception ex) {
            String errMsg = "\u6267\u884c '" + transDescr + "' \u5931\u8d25: " + ex.getMessage();
            log.error(errMsg + " .", (Throwable)ex);
            this.instanceStatus = new InstanceStatus(InstanceStatus.Status.ERROR, errMsg, initStartTime);
            ExceptionUtils.rethrow((Throwable)ex);
        }
    }

    public void markUnavaliableReason(Class source, String reason) {
        this.UNAVALIABLE_REASONS.put(source, reason);
    }

    public void markUnavaliableReason(Class source, Exception exception) {
        this.markUnavaliableReason(source, this.errorI18N(exception));
    }

    private String errorI18N(Exception exception) {
        return StringTable.i18N(null, "SystemExecError", exception.getClass(), exception.getMessage());
    }

    public void cleanUnavaliableEvent(Class source) {
        this.UNAVALIABLE_REASONS.remove(source);
    }

    private void enabledServiceLoaderRegister(DefaultContext yigoCtx) throws Throwable {
        MetaExtStartListener extStartListener;
        IMetaFactory mf = yigoCtx.getVE().getMetaFactory();
        MetaEnhance enhance = mf.getEnhance("");
        if (null == enhance) {
            enhance = new MetaEnhance();
            FieldUtils.writeField((Object)mf, (String)"solutionEnhance", (Object)enhance, (boolean)true);
        }
        if (null != (extStartListener = enhance.getStartListener())) {
            for (MetaStartListener startListener : extStartListener) {
                if (!startListener.getImpl().equals(ServiceLoaderRegisteringStartListener.class.getName())) continue;
                return;
            }
        }
        ServiceLoaderRegisteringUtil.invoke((DefaultContext)yigoCtx);
    }
}

