package com.bokesoft.distro.tech.bootsupport.starter.runtime.model;

/**
 * Yigo 实例运行状态定义
 */
public class InstanceStatus {
    private long systemInitTime;
    private Status status;
    private String message;

    public InstanceStatus() {
    }
    public InstanceStatus(Status status, String message, long systemInitTime) {
        this.status = status;
        this.message = message;
        this.systemInitTime = systemInitTime;
    }

    public void setStatus(Status status) {
        this.status = status;
    }
    public Status getStatus() {
        return status;
    }
    public void setMessage(String message) {
        this.message = message;
    }
    public String getMessage() {
        return message;
    }

    public long getUptimeMs(){
        return System.currentTimeMillis()- systemInitTime;
    }

    public enum Status {
        /** 不可用状态 */
        UNAVALIABLE,
        /** 环境准备阶段 */
        PREPARING,
        /** 等待阶段 - 环境准备完毕, 等待加载 Yigo 程序 */
        WAITING,
        /** Yigo 程序加载阶段 */
        LOADING,
        /** 可用状态 */
        READY,
        /** Yigo 程序卸载阶段 */
        UNLOADING,
        /** 系统错误状态 */
        ERROR
    }
}
