package com.bokesoft.distro.tech.bootsupport.starter.readonly.impl;

import com.bokesoft.distro.tech.bootsupport.starter.config.ReadOnlyDbCheckConfig;
import com.bokesoft.distro.tech.bootsupport.starter.i18n.StringTable;
import com.bokesoft.distro.tech.bootsupport.starter.readonly.struc.DBReadOnlyStatus;
import com.bokesoft.distro.tech.bootsupport.starter.readonly.struc.DBWatchData;
import com.bokesoft.distro.tech.bootsupport.starter.readonly.intf.IDBWatcher;
import com.bokesoft.distro.tech.commons.basis.trace.TraceUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.DBType;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;


public class SqlServerDBWatcher implements IDBWatcher {

    private static final Logger logger= LoggerFactory.getLogger(SqlServerDBWatcher.class);

    private static String currentDBName = null;

    @Override
    public DBWatchData doCheck(DefaultContext context, ReadOnlyDbCheckConfig config) throws Throwable {
        IDBManager dbManager = context.getDBManager();
        if (StringUtils.isEmpty(currentDBName)) {
            currentDBName = dbManager.execQuery("select db_name() as dbname").getString(0);
        }
        String sql1 = "select id  as agent_id from distribution.dbo.MSdistribution_agents where subscriber_db= ?";

        DataTable dataTable = dbManager.execPrepareQuery(sql1, currentDBName);
        List<Integer> arrayList = new ArrayList<Integer>();
        int size = dataTable.size();
        for (int i = 0; i < size; i++) {
            arrayList.add((Integer) dataTable.getRowByIndex(i).getObject("agent_id"));
        }
        SqlServerDBWatchData sqlServerDBWatchData = null;
        if (!arrayList.isEmpty()) {
            String errLogSql = "select agent_id,runstatus,start_time,error_id,comments from distribution.dbo.MSdistribution_history " +
                    "WHERE error_id!=0 and  start_time =(SELECT max(start_time) from distribution.dbo.MSdistribution_history " +
                    "where agent_id in (?)) " +
                    "and agent_id in (?)";
            DataTable dataTable1 = dbManager.execPrepareQuery(errLogSql, StringUtils.join(arrayList, ","), StringUtils.join(arrayList, ","));
            if (dataTable1.size() != 0) {
                new SqlServerDBWatchData(dataTable1);
            } else {
                SqlServerDBWatchData.OK();
            }
        } else {
            SqlServerDBWatchData.ERROR(dbAgentErrI18N());
        }
        return new DBWatchData(sqlServerDBWatchData.getReason(), sqlServerDBWatchData.getDescription(),
                sqlServerDBWatchData.getStatus());
    }

    @Override
    public boolean support(int dbType) {
        return DBType.SqlServer == dbType;
    }

    private String dbAgentErrI18N(){
        return StringTable.i18N(null,StringTable.MSG_DB_READONLY_CHECK_FAILD, currentDBName, TraceUtil.getTraceId());
    }

    static class SqlServerDBWatchData {
        private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss");
        /** 事务复制中订阅的节点id */
        private int agentId = -1;
        /** 错误发生时间 */
        private String startTime = "unkown";
        /** 错误记录id */
        private Integer errorId = -1;
        /** 完整错误信息 */
        private String comments = "unkown";
        /** 主从同步异常的原因 */
        private String reason;
        /** 主从同步健康状态 */
        private DBReadOnlyStatus status = DBReadOnlyStatus.ERROR;

        private SqlServerDBWatchData(){

        }
        public SqlServerDBWatchData(DataTable dt) {
            this.agentId = dt.getInt("agent_id");
            this.startTime =  formatter.format(dt.getDateTime("start_time"));
            this.errorId = dt.getInt("error_id");
            this.comments =  dt.getString("comments");
            this.reason = i18NSyncError();
            this.status = DBReadOnlyStatus.ERROR;
        }

        public static SqlServerDBWatchData OK() {
            SqlServerDBWatchData data = new SqlServerDBWatchData();
            data.status = DBReadOnlyStatus.OK;
            return data;
        }

        public static SqlServerDBWatchData ERROR(String reason) {
            SqlServerDBWatchData data = new SqlServerDBWatchData();
            data.reason = reason;
            return data;
        }
        public String getDescription() {
            String result = "\n=====================================================\n";
            result += "任务编号为: " +agentId+"\n";
            result += "执行时间为: "+ startTime +" \n";
            result += "错误id: "+errorId+" \n";
            result += "完整错误信息为: "+comments+ "\n";
            result += "=====================================================";
            return  result;
        }

        public String getReason() {
            return reason;
        }

        public DBReadOnlyStatus getStatus() {
            return this.status;
        }

        private String i18NSyncError(){
            return StringTable.i18N(null, StringTable.MSG_SQLSERVER_RSYNC_ERROR, errorId, startTime,
                    TraceUtil.getSpanId());
        }
    }
}
