package com.bokesoft.distro.tech.bootsupport.starter.jsmodule;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoExtendJavascriptProvider;
import com.bokesoft.distro.tech.bootsupport.starter.utils.URLPathUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;


/**
 * 扫描资源所在子目录, 自动获取所有 js 文件资源
 */
public class AutoScanYigoExtendJavascriptProvider implements YigoExtendJavascriptProvider {

    private final ResourceLoader resourceLoader;
    private  String rootUrl;

    public AutoScanYigoExtendJavascriptProvider(ResourceLoader resourceLoader, String rootUrl) {
        this.resourceLoader = resourceLoader;
        this.rootUrl = rootUrl;
    }

    @Override
    public List<Resource> getResources() {
        try {
            return _listResources();
        } catch (IOException e) {
            return ExceptionUtils.rethrow(e);
        }
    }

    private List<Resource> _listResources() throws IOException {
        Resource root = resourceLoader.getResource(rootUrl);
        String rootPath=root.getURL().getPath();
        String pattern = URLPathUtils.get(rootUrl,"**","*.*");
        ResourcePatternResolver patternResolver = ResourcePatternUtils.getResourcePatternResolver(resourceLoader);
        Resource[] resources = patternResolver.getResources(pattern);

        List<String> pathList = new ArrayList<>();
        for (Resource r: resources) {
            String path = r.getURL().getPath();
            path = URLPathUtils.relativizeOf(path,rootPath);
            if (path.endsWith(".js")) {
                pathList.add(path);
            }
        }
        pathList.sort(null);

        List<Resource> result = new ArrayList<>();
        for(String path: pathList) {
            String resPath = URLPathUtils.get(rootUrl, path);
            Resource res = resourceLoader.getResource(resPath);
            result.add(res);
        }
        return result;
    }

}
