package com.bokesoft.distro.tech.bootsupport.starter.configurer;

import com.bokesoft.distro.tech.commons.basis.auth.CrossAuthUtil;
import com.bokesoft.distro.tech.commons.basis.auth.crossauth.ICrossAuthTokenSettingProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Configuration
public class CrossAuthConfigurer implements ApplicationContextAware {

    /**
     * 初始化注册{@link ICrossAuthTokenSettingProvider}默认实现实例
     * @return
     */
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map<String,ICrossAuthTokenSettingProvider> providers
            = applicationContext.getBeansOfType(ICrossAuthTokenSettingProvider.class);
        if(null != providers) {
            List<ICrossAuthTokenSettingProvider> providerList = new ArrayList<>(providers.values());
            CrossAuthUtil.setup(providerList);
        }
    }
}
