/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.utils;

import com.alibaba.fastjson.JSONObject;
import com.bokesoft.distro.tech.yigosupport.extension.exception.Misc;
import com.bokesoft.yigo.common.trace.TraceRecorder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalExceptionUtil {
    private static Logger log = LoggerFactory.getLogger(GlobalExceptionUtil.class);
    private static final String[] exceptionBlockedList = new String[]{"java.sql", "oracle.jdbc", "com.mysql.cj.jdbc.exceptions", "org.springframework.jdbc"};

    public static Throwable handleException(Throwable e) {
        Throwable rootEx = ExceptionUtils.getRootCause((Throwable)e);
        if (null == rootEx) {
            rootEx = e;
        }
        String message = GlobalExceptionUtil.checkAndReplaceExceptionMessage(rootEx);
        return Misc.convertToYigoException((Throwable)e, (String)message);
    }

    public static String checkAndReplaceExceptionMessage(Throwable rootEx) {
        String exName = rootEx.getClass().getName();
        String message = rootEx.getMessage();
        if (StringUtils.isBlank((CharSequence)message)) {
            return "\u6280\u672f\u6545\u969c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
        }
        if (message.startsWith("{") && message.endsWith("}")) {
            JSONObject json = JSONObject.parseObject((String)message);
            for (String keyWords : exceptionBlockedList) {
                if (!exName.contains(keyWords)) continue;
                log.error(rootEx.getMessage(), rootEx);
                json.put("message", (Object)"\u6280\u672f\u6545\u969c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                break;
            }
            String jsonOrgDetail = json.getString("detail");
            json.put("detail", (Object)(" [\u9519\u8bef\u4ee3\u7801: " + TraceRecorder.getTraceId() + "]\n" + jsonOrgDetail));
            message = json.toJSONString();
            return message;
        }
        for (String keyWords : exceptionBlockedList) {
            if (!exName.contains(keyWords)) continue;
            log.error(rootEx.getMessage(), rootEx);
            message = "\u6280\u672f\u6545\u969c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
            break;
        }
        message = message + " [\u9519\u8bef\u4ee3\u7801: " + TraceRecorder.getTraceId() + "]";
        return message;
    }
}

