/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.execctl.impl.recoverers;

import com.bokesoft.distro.tech.bootsupport.starter.execctl.recovery.IConnectionRecoverer;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlStatementTimeoutRecoverer
implements IConnectionRecoverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySqlStatementTimeoutRecoverer.class);
    private int connId = -1;

    @Override
    public void prepare(Connection connection) {
        try {
            this.connId = MySqlStatementTimeoutRecoverer.getConnectionId(connection);
        }
        catch (SQLException e) {
            this.connId = -1;
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    @Override
    public void recover(Connection newConn) {
        String killCmd = "kill " + this.connId;
        try {
            if (!newConn.isClosed()) {
                QueryRunner runner = new QueryRunner();
                runner.execute(newConn, killCmd, new Object[0]);
                LOGGER.warn("MySQL \u95ee\u9898\u6062\u590d - \u6267\u884c '{}' \u6210\u529f .", (Object)killCmd);
            }
        }
        catch (SQLException e) {
            LOGGER.error("MySQL \u95ee\u9898\u6062\u590d - \u6267\u884c '" + killCmd + "' \u51fa\u73b0\u9519\u8bef: " + e.getMessage(), (Throwable)e);
        }
    }

    private static int getConnectionId(Connection connection) throws SQLException {
        String sql = "select connection_id()";
        LOGGER.warn("MySQL \u95ee\u9898\u6062\u590d - \u83b7\u53d6\u95ee\u9898 Connection \u7684 ID: {} ...", (Object)sql);
        QueryRunner runner = new QueryRunner();
        int result = (Integer)runner.query(connection, sql, resultSet -> {
            resultSet.next();
            int connId = resultSet.getInt(1);
            return connId;
        });
        LOGGER.warn("MySQL \u95ee\u9898\u6062\u590d - \u6267\u884c '{}' \u5f97\u5230 Connection ID \u4e3a {} .", (Object)sql, (Object)result);
        return result;
    }
}

