/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.bootsupport.starter.configurer;

import com.bokesoft.distro.tech.bootsupport.starter.config.TraceConfig;
import com.bokesoft.distro.tech.bootsupport.starter.config.YigoInstanceReadyConfig;
import com.bokesoft.distro.tech.bootsupport.starter.filter.DefaultSecurityFilter;
import com.bokesoft.distro.tech.bootsupport.starter.filter.ExecutionTimeoutPrepareFilter;
import com.bokesoft.distro.tech.bootsupport.starter.filter.YigoInstanceReadyFilter;
import com.bokesoft.distro.tech.bootsupport.starter.patch.LoginFilter4SpringBoot;
import com.bokesoft.distro.tech.bootsupport.starter.runtime.YigoInstanceManager;
import com.bokesoft.distro.tech.bootsupport.starter.servlet.ExceptionHandlerAttachmentServlet;
import com.bokesoft.distro.tech.bootsupport.starter.servlet.ExceptionHandlerServiceDispatch;
import com.bokesoft.distro.tech.yigosupport.extension.filter.RequestTrackingFilter;
import com.bokesoft.distro.tech.yigosupport.extension.filter.TracePrepareFilter;
import com.bokesoft.distro.tech.yigosupport.extension.filter.YigoServiceInfoClearFilter;
import com.bokesoft.yes.mid.filter.GZIPFilter;
import com.bokesoft.yes.mid.servlet.AttachmentServlet;
import com.bokesoft.yes.mid.servlet.ServiceServlet;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@ComponentScan
public class ServletContextConfigurer {
    private static final int FILTER_ORDER_BEFORE_GZIP = 1000;
    private static final int FILTER_ORDER_GZIP = 2000;
    private static final int FILTER_ORDER_AFTER_GZIP = 3000;
    private static final String BEAN_NAME_EX_YIGO_SERVLET = "com.bokesoft.distro.tech.bootsupport.starter.servlet.ExceptionHandlerServiceDispatch";
    private static final String BEAN_NAME_EX_YIGO_ATTACH = "com.bokesoft.distro.tech.bootsupport.starter.servlet.ExceptionHandlerAttachmentServlet";
    private static final String BEAN_NAME_BUILD_YIGO_INSTANCE_READY_CONFIG = "buildYigoInstanceReadyConfig";
    @Value(value="${distro.tech.bootsupport.login-filter.login-page}")
    private String loginFilter_loginPage;
    @Value(value="${distro.tech.bootsupport.login-filter.style}")
    private String loginFilter_style;
    @Value(value="${distro.tech.bootsupport.login-filter.main-page}")
    private String loginFilter_mainPage;
    @Value(value="${distro.tech.bootsupport.login-filter.waiting-page}")
    private String loginFilter_waitingPage;
    @Value(value="${distro.tech.bootsupport.login-filter.mobile-login-page}")
    private String loginFilter_mobileLoginPage;
    @Value(value="${distro.tech.bootsupport.login-filter.mobile-waiting-page}")
    private String loginFilter_mobileWaitingPage;
    @Value(value="${distro.tech.bootsupport.login-filter.mobile-main-page}")
    private String loginFilter_mobileMainPage;
    @Autowired
    private YigoInstanceManager yigoInstanceManager;
    @Autowired
    private TraceConfig traceConfig;

    @Bean(value={"buildYigoInstanceReadyConfig"})
    @ConfigurationProperties(prefix="yigoee.tech.bootsupport.instance-ready")
    public YigoInstanceReadyConfig buildYigoInstanceReadyConfig() {
        return new YigoInstanceReadyConfig(new String[]{this.loginFilter_loginPage, this.loginFilter_mainPage, this.loginFilter_waitingPage}, new String[]{this.loginFilter_mobileLoginPage, this.loginFilter_mobileWaitingPage, this.loginFilter_mobileMainPage});
    }

    @Bean
    @Autowired
    @DependsOn(value={"buildYigoInstanceReadyConfig"})
    public FilterRegistrationBean<YigoInstanceReadyFilter> yigoInstanceReadyFilter(YigoInstanceReadyConfig yigoInstanceReadyConfig) {
        FilterRegistrationBean filter = new FilterRegistrationBean((Filter)new YigoInstanceReadyFilter(this.yigoInstanceManager, this.loginFilter_waitingPage, this.loginFilter_mobileWaitingPage, yigoInstanceReadyConfig), new ServletRegistrationBean[0]);
        filter.setUrlPatterns(Collections.singletonList("/*"));
        filter.setOrder(1000);
        return filter;
    }

    @Bean
    public FilterRegistrationBean<TracePrepareFilter> registerTracePrepareFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean((Filter)new TracePrepareFilter(), new ServletRegistrationBean[0]);
        LinkedHashMap<String, String> initParameters = new LinkedHashMap<String, String>();
        initParameters.put("PARA_OVERFLOW_LIMIT", "" + this.traceConfig.getDrConfig().getLimit());
        initParameters.put("PARA_OVERFLOW_STRATEGY", this.traceConfig.getDrConfig().getOverflowStrategy());
        filter.setInitParameters(initParameters);
        filter.setUrlPatterns(Collections.singletonList("/*"));
        filter.setOrder(1000);
        return filter;
    }

    @Bean
    public FilterRegistrationBean<YigoServiceInfoClearFilter> registerYigoServiceInfoClearFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean((Filter)new YigoServiceInfoClearFilter(), new ServletRegistrationBean[0]);
        filter.setUrlPatterns(Collections.singletonList("/*"));
        filter.setOrder(3000);
        return filter;
    }

    @Bean
    public FilterRegistrationBean<ExecutionTimeoutPrepareFilter> executionTImeoutFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean((Filter)new ExecutionTimeoutPrepareFilter(), new ServletRegistrationBean[0]);
        filter.setUrlPatterns(Collections.singletonList("/*"));
        filter.setOrder(1000);
        return filter;
    }

    @Bean
    @ConditionalOnProperty(name={"distro.tech.bootsupport.gzip-filter.enabled"}, havingValue="true", matchIfMissing=true)
    public FilterRegistrationBean<GZIPFilter> gzipFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean((Filter)new GZIPFilter(), new ServletRegistrationBean[0]);
        filter.setUrlPatterns(Collections.singletonList("/*"));
        filter.setOrder(2000);
        return filter;
    }

    @Bean
    @ConditionalOnProperty(name={"distro.tech.bootsupport.buildin-loginfilter.enabled"}, havingValue="true", matchIfMissing=true)
    public FilterRegistrationBean<LoginFilter4SpringBoot> loginFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean((Filter)new LoginFilter4SpringBoot(), new ServletRegistrationBean[0]);
        LinkedHashMap<String, String> initParameters = new LinkedHashMap<String, String>();
        initParameters.put("encoding", "UTF-8");
        initParameters.put("loginpage", this.loginFilter_loginPage);
        initParameters.put("style", this.loginFilter_style);
        filter.setInitParameters(initParameters);
        filter.setUrlPatterns(Arrays.asList(this.loginFilter_mainPage, "/"));
        filter.setOrder(3000);
        return filter;
    }

    @Bean
    public FilterRegistrationBean<DefaultSecurityFilter> defaultSecurityFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean((Filter)new DefaultSecurityFilter(), new ServletRegistrationBean[0]);
        filter.setUrlPatterns(Collections.singletonList("/*"));
        filter.setOrder(3000);
        return filter;
    }

    @Bean
    public FilterRegistrationBean<RequestTrackingFilter> requestTrackingFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean((Filter)new RequestTrackingFilter(), new ServletRegistrationBean[0]);
        filter.setUrlPatterns(Collections.singletonList("/*"));
        filter.setOrder(3000);
        return filter;
    }

    @Bean(name={"com.bokesoft.distro.tech.bootsupport.starter.servlet.ExceptionHandlerServiceDispatch"})
    @ConditionalOnProperty(name={"yigoee.tech.bootsupport.global-exception.enabled"}, havingValue="true", matchIfMissing=true)
    public ServletRegistrationBean<ServiceServlet> serviceDispatchWithWrapTraceIdException() {
        return new ServletRegistrationBean((Servlet)new ExceptionHandlerServiceDispatch(this.yigoInstanceManager), new String[]{"/servlet", "/servlet/*"});
    }

    @Bean(name={"com.bokesoft.distro.tech.bootsupport.starter.servlet.ExceptionHandlerAttachmentServlet"})
    @ConditionalOnProperty(name={"yigoee.tech.bootsupport.global-exception.enabled"}, havingValue="true", matchIfMissing=true)
    public ServletRegistrationBean<AttachmentServlet> attachmentServletWithWrapTraceIdException() {
        return new ServletRegistrationBean((Servlet)new ExceptionHandlerAttachmentServlet(), new String[]{"/attach", "/attach/*"});
    }

    @Bean
    @ConditionalOnMissingBean(name={"com.bokesoft.distro.tech.bootsupport.starter.servlet.ExceptionHandlerServiceDispatch"})
    public ServletRegistrationBean<ServiceServlet> serviceDispatch() {
        return new ServletRegistrationBean((Servlet)new ServiceServlet(), new String[]{"/servlet", "/servlet/*"});
    }

    @Bean
    @ConditionalOnMissingBean(name={"com.bokesoft.distro.tech.bootsupport.starter.servlet.ExceptionHandlerAttachmentServlet"})
    public ServletRegistrationBean<AttachmentServlet> attachmentServlet() {
        return new ServletRegistrationBean((Servlet)new AttachmentServlet(), new String[]{"/attach", "/attach/*"});
    }
}

