package com.bokesoft.distro.tech.bootsupport.starter.configurer;

import com.bokesoft.distro.tech.bootsupport.starter.filter.YigoProjectExtendJSFilter;
import com.bokesoft.distro.tech.bootsupport.starter.api.YigoExtendJavascriptProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Arrays;
import java.util.List;

@Configuration
public class YigoExtendJSSupportConfiguration {

    @Autowired(required = false)
    private List<YigoExtendJavascriptProvider> providers;

    @Bean
    public FilterRegistrationBean<YigoProjectExtendJSFilter> registerYigoProjectExtendJSFilter() {
        YigoProjectExtendJSFilter filter = new YigoProjectExtendJSFilter(providers);
        FilterRegistrationBean<YigoProjectExtendJSFilter> reg = new FilterRegistrationBean<YigoProjectExtendJSFilter>();
        reg.setFilter(filter);
        reg.setUrlPatterns(Arrays.asList("/project/extend.js"));
        reg.setOrder(0);
        return reg;
    }
}
