package com.bokesoft.distro.tech.bootsupport.starter.configurer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoAdditionalInitiator;
import com.bokesoft.distro.tech.bootsupport.starter.config.ExecTimeoutCtrlConfig;
import com.bokesoft.distro.tech.bootsupport.starter.datasource.DataSourceAwareDBManagerFactory;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.ExecutionTimeoutManager;
import com.bokesoft.distro.tech.bootsupport.starter.execctl.utils.ExecutionControlUtils;
import com.bokesoft.distro.tech.bootsupport.starter.mid.filter.ExecutionTimeoutServiceFilter;
import com.bokesoft.distro.tech.bootsupport.starter.mid.process.PostExecutionTimeoutProcessFactory;
import com.bokesoft.distro.tech.bootsupport.starter.mid.process.PreExecutionTimeoutProcessFactory;
import com.bokesoft.yes.mid.service.MidProcessFlowHandler;
import com.bokesoft.yes.mid.service.filter.IFilterMatcher;
import com.bokesoft.yes.mid.service.filter.ServiceFilterFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceFilter;

@Configuration
@ConditionalOnProperty(prefix = "yigoee.tech.bootsupport.execution-control", name="enabled",havingValue = "true")
public class ExecutionTimeoutConfigurer {

    @Bean
    public YigoAdditionalInitiator registerExecutionTimeoutServiceListener() {
        return new YigoAdditionalInitiator() {
            @Override
            public void init(DefaultContext context) throws Throwable {
                ServiceFilterFactory.getInstance().setMatcher(new IFilterMatcher() {
                    @Override
                    public List<IServiceFilter> find(String s, Map<String, Object> map) throws Throwable {
                        List<IServiceFilter> result = new ArrayList<>();
                        result.add(new ExecutionTimeoutServiceFilter());
                        return result;
                    }
                });
            }
        };
    }

    @Bean
    public YigoAdditionalInitiator registerExcCtrlTimeOutSaveDataServiceListener() {
        return new YigoAdditionalInitiator() {
            @Override
            public void init(DefaultContext context) throws Throwable {
                MidProcessFlowHandler.addProcessFactory("SaveData", "Pre", new PreExecutionTimeoutProcessFactory());
                MidProcessFlowHandler.addProcessFactory("SaveData", "Post", new PostExecutionTimeoutProcessFactory());
            }
        };
    }

    @Bean
    public YigoAdditionalInitiator registerExcCtrlTimeOutDeleteDataServiceListener() {
        return new YigoAdditionalInitiator() {
            @Override
            public void init(DefaultContext context) throws Throwable {
                MidProcessFlowHandler.addProcessFactory("DeleteData", "Pre", new PreExecutionTimeoutProcessFactory());
                MidProcessFlowHandler.addProcessFactory("DeleteData", "Post", new PostExecutionTimeoutProcessFactory());
            }
        };
    }

    @Bean
    public YigoAdditionalInitiator registerExcCtrlTimeOutLoadDataServiceListener() {
        return new YigoAdditionalInitiator() {
            @Override
            public void init(DefaultContext context) throws Throwable {
                MidProcessFlowHandler.addProcessFactory("LoadData", "Pre", new PreExecutionTimeoutProcessFactory());
                MidProcessFlowHandler.addProcessFactory("LoadData", "Post", new PostExecutionTimeoutProcessFactory());
            }
        };
    }

    @Autowired
    public void setExecutionTimeoutControl(ExecTimeoutCtrlConfig timeoutControl){
        ExecutionTimeoutManager.setExecutionTimeoutControl(timeoutControl);
        ExecutionControlUtils.setDefaultDbSqlTimeout(timeoutControl.getSqlTimeoutMs());
    }

    @Value("${yigoee.tech.bootsupport.execution-control.enabled:false}")
    private  void setExecTimeoutControlEnabled(String execTimeoutControlEnabled){
        DataSourceAwareDBManagerFactory.setExecTimeoutControlEnabled(Boolean.parseBoolean(execTimeoutControlEnabled));
    }

}
