package com.bokesoft.distro.tech.bootsupport.starter.beans;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoClientPageVariableProvider;
import com.bokesoft.distro.tech.bootsupport.starter.api.ctx.PageBuildContext;
import com.bokesoft.distro.tech.bootsupport.starter.runtime.YigoInstanceManager;
import com.bokesoft.distro.tech.bootsupport.starter.runtime.model.InstanceStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 用于给 waiting 页面提供系统启动状态
 */
@Component
public class WaitingInstanceStatusPageVariableProvider implements YigoClientPageVariableProvider {

    @Autowired
    private YigoInstanceManager yigoInstanceManager;

    @Override
    public boolean support(PageBuildContext ctx) {
        return PageBuildContext.PageClass.WAITING == ctx.getPageClass()
                || PageBuildContext.PageClass.MOBILEWAITING == ctx.getPageClass();
    }

    @Override
    public Map<String, Object> getVariables(PageBuildContext pageBuildContext) {
        Map<String, Object> result = new HashMap<>();
        result.put(InstanceStatus.class.getSimpleName(), yigoInstanceManager.getInstanceStatus());
        return result;
    }
}
