package com.bokesoft.distro.tech.bootsupport.starter.beans;

import com.bokesoft.distro.tech.bootsupport.starter.api.ctx.PageBuildContext;
import com.bokesoft.distro.tech.bootsupport.starter.config.YigoPagesConfig;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;

/**
 * 在使用 SpringBoot 启动 WebApp 的情况下, 由于不建议直接集成 JSP, 所以直接读取资源中的 jsp 文件然后转为 HTML 返回给浏览器.
 */
@Controller
public class PagesController {

	private final HttpServletRequest request;
	private final YigoPagesConfig pagesConfig;
	private final PagesBuildService pagesBuildService;

	public PagesController(
			HttpServletRequest request, YigoPagesConfig pagesConfig, PagesBuildService pagesBuildService) {
		// spring-boot 支持 request 注入有特殊支持,参考 RequestObjectFactory
		this.request = request;

		this.pagesConfig = pagesConfig;
		this.pagesBuildService = pagesBuildService;
	}

	@RequestMapping("/")
	public ResponseEntity<String> welcomeFile(
		    @CookieValue(value = "clientID", defaultValue = "") String clientID,
			@CookieValue(value = "locale", defaultValue = "") String locale){
		return pagesBuildService.buildPage(
				pagesConfig.getDefaultPageResourceLocations().getMainframe(),
				PageBuildContext.build(request, PageBuildContext.PageClass.MAINFRAME), clientID, locale);
	}

	@RequestMapping("${distro.tech.bootsupport.login-filter.main-page}")
	public ResponseEntity<String> mainPureJsp(
		    @CookieValue(value = "clientID", defaultValue = "") String clientID,
			@CookieValue(value = "locale", defaultValue = "") String locale){
		return pagesBuildService.buildPage(
				pagesConfig.getDefaultPageResourceLocations().getMainframe(),
				PageBuildContext.build(request, PageBuildContext.PageClass.MAINFRAME), clientID, locale);

	}

	@RequestMapping("${distro.tech.bootsupport.login-filter.mobile-main-page}")
	public ResponseEntity<String> mobileHome(
			@CookieValue(value = "clientID", defaultValue = "") String clientID,
			@CookieValue(value = "locale", defaultValue = "") String locale){
		return pagesBuildService.buildPage(
				pagesConfig.getDefaultPageResourceLocations().getMobileHome(),
				PageBuildContext.build(request, PageBuildContext.PageClass.MOBILEHOME), clientID, locale);

	}

	@RequestMapping("${distro.tech.bootsupport.login-filter.login-page}")
	public ResponseEntity<String> loginJsp(
		    @CookieValue(value = "clientID", defaultValue = "") String clientID,
			@CookieValue(value = "locale", defaultValue = "") String locale) {
		return pagesBuildService.buildPage(
				pagesConfig.getDefaultPageResourceLocations().getLogin(),
				PageBuildContext.build(request, PageBuildContext.PageClass.LOGIN), clientID, locale);
	}

	@RequestMapping("${distro.tech.bootsupport.login-filter.mobile-login-page}")
	public ResponseEntity<String> appLogin(
			@CookieValue(value = "clientID", defaultValue = "") String clientID,
			@CookieValue(value = "locale", defaultValue = "") String locale){
		return pagesBuildService.buildPage(
				pagesConfig.getDefaultPageResourceLocations().getMobileLogin(),
				PageBuildContext.build(request, PageBuildContext.PageClass.MOBILELOGIN), clientID, locale);

	}

	@RequestMapping("${distro.tech.bootsupport.login-filter.waiting-page}")
	public ResponseEntity<String> pcWaitingPage(
			@CookieValue(value = "clientID", defaultValue = "") String clientID,
			@CookieValue(value = "locale", defaultValue = "") String locale) {
		return pagesBuildService.buildPage(
				pagesConfig.getDefaultPageResourceLocations().getWaiting(),
				PageBuildContext.build(request, PageBuildContext.PageClass.WAITING), clientID, locale);
	}

	@RequestMapping("${distro.tech.bootsupport.login-filter.mobile-waiting-page}")
	public ResponseEntity<String> mobileWaitingPage(
			@CookieValue(value = "clientID", defaultValue = "") String clientID,
			@CookieValue(value = "locale", defaultValue = "") String locale) {
		return pagesBuildService.buildPage(
				pagesConfig.getDefaultPageResourceLocations().getMobileWaiting(),
				PageBuildContext.build(request, PageBuildContext.PageClass.MOBILEWAITING), clientID, locale);
	}

}
