package com.bokesoft.distro.tech.bootsupport.yigoconfig.configurer;

import com.bokesoft.distro.tech.bootsupport.starter.api.YigoAdditionalInitiator;
import com.bokesoft.distro.tech.bootsupport.yigoconfig.config.YigoConfigBean;
import com.bokesoft.distro.tech.bootsupport.yigoconfig.config.struc.LoginConfig;
import com.bokesoft.distro.tech.bootsupport.yigoconfig.config.struc.SessionConfig;
import com.bokesoft.distro.tech.bootsupport.yigoconfig.config.struc.SettingConfig;
import com.bokesoft.yes.mid.session.AccountLockoutInfoProvider;
import com.bokesoft.yes.mid.session.IAccountLockoutInfoMap;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.setting.MetaLoginSetting;
import com.bokesoft.yigo.meta.setting.MetaSession;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Yigo 启动后设置相关配置属性
 */
@Configuration
public class YigoConfigConfigurer {

    private static Logger log = LoggerFactory.getLogger(YigoConfigConfigurer.class);

    @Autowired
    private YigoConfigBean yigoConfig;

    @Bean
    public YigoAdditionalInitiator initYigoConfig() {
        return new YigoAdditionalInitiator() {
            @Override
            public void init(DefaultContext yigoCtx) {
                if (null != yigoConfig) {
                    SettingConfig settingConfig = yigoConfig.getSetting();
                    setSettingInfo(yigoCtx, settingConfig);
                }
            }
        };
    }

    /**
     * 设置 setting 相关的信息(session、login) 帐户锁定信息(session.account-lockout)、sso 登录信息等
     */
    private void setSettingInfo(DefaultContext yigoCtx, SettingConfig settingConfig) {
        if (null != settingConfig) {
            SessionConfig sessionConfig = settingConfig.getSession();
            if (null != sessionConfig) {
                MetaSession metaSession = getMetaSession(yigoCtx);

                Integer accountLockoutThreshold = sessionConfig.getAccountLockoutThreshold();
                if (null != accountLockoutThreshold) {
                    metaSession.setAccountLockoutThreshold(accountLockoutThreshold);
                    log.info("加载 Yigo 程序: 强制设置 AccountLockoutThreshold='{}' .", accountLockoutThreshold);
                }

                Integer accountLockoutDuration = sessionConfig.getAccountLockoutDuration();
                if (null != accountLockoutDuration) {
                    metaSession.setAccountLockoutDuration(accountLockoutDuration);
                    log.info("加载 Yigo 程序: 强制设置 AccountLockoutDuration='{}' .", accountLockoutDuration);
                }

                initAccountLockoutInfoMap(metaSession);
            }

            LoginConfig loginConfig = settingConfig.getLogin();
            if (null != loginConfig) {
                String ssoProviderClassName = loginConfig.getSsoProvider();
                if (StringUtils.isNotBlank(ssoProviderClassName)) {
                    MetaSetting settings = MetaFactory.getGlobalInstance().getSetting();
                    MetaLoginSetting loginSetting = settings.getLogin();
                    if (null == loginSetting) {
                        loginSetting = new MetaLoginSetting();
                        settings.setLogin(loginSetting);
                    }
                    loginSetting.setSSOProvider(ssoProviderClassName);
                    log.info("加载 Yigo 程序: 设置 ssoProvider='{}' .", ssoProviderClassName);
                }
            }
        }
    }

    /**
     * 获取MetaSession对象
     */
    private MetaSession getMetaSession(DefaultContext yigoCtx) {
        MetaSession metaSession = yigoCtx.getVE().getMetaFactory().getSetting().getSession();
        if (null == metaSession) {
            metaSession = new MetaSession();
            yigoCtx.getVE().getMetaFactory().getSetting().setSession(metaSession);
        }
        return metaSession;
    }

    /**
     * 初始化账号锁定信息
     * 参考MidSystemInit#initAccountLockoutInfo
     */
    private void initAccountLockoutInfoMap(MetaSession metaSession) {
        IAccountLockoutInfoMap lockInfo = AccountLockoutInfoProvider.getInstance().getAccountLockoutInfoMap();
        lockInfo.setAccountLockoutDuration(metaSession == null ? 0 : metaSession.getAccountLockoutDuration());
        lockInfo.setAccountLockoutThreshold(metaSession == null ? 0 : metaSession.getAccountLockoutThreshold());
    }
}