/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.handler;

import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.handler.impl.DefaultRowWriteHandler;
import com.alibaba.excel.write.handler.impl.DimensionWorkbookWriteHandler;
import com.alibaba.excel.write.handler.impl.FillStyleCellWriteHandler;
import com.alibaba.excel.write.style.DefaultStyle;
import java.util.ArrayList;
import java.util.List;

public class DefaultWriteHandlerLoader {
    public static final List<WriteHandler> DEFAULT_WRITE_HANDLER_LIST = new ArrayList<WriteHandler>();

    public static List<WriteHandler> loadDefaultHandler(Boolean useDefaultStyle, ExcelTypeEnum excelType) {
        ArrayList<WriteHandler> handlerList = new ArrayList<WriteHandler>();
        switch (excelType) {
            case XLSX: {
                handlerList.add(new DimensionWorkbookWriteHandler());
                handlerList.add(new DefaultRowWriteHandler());
                handlerList.add(new FillStyleCellWriteHandler());
                if (!useDefaultStyle.booleanValue()) break;
                handlerList.add(new DefaultStyle());
                break;
            }
            case XLS: {
                handlerList.add(new DefaultRowWriteHandler());
                handlerList.add(new FillStyleCellWriteHandler());
                if (!useDefaultStyle.booleanValue()) break;
                handlerList.add(new DefaultStyle());
                break;
            }
            case CSV: {
                handlerList.add(new DefaultRowWriteHandler());
                handlerList.add(new FillStyleCellWriteHandler());
                break;
            }
        }
        return handlerList;
    }

    static {
        DEFAULT_WRITE_HANDLER_LIST.add(new DimensionWorkbookWriteHandler());
        DEFAULT_WRITE_HANDLER_LIST.add(new DefaultRowWriteHandler());
        DEFAULT_WRITE_HANDLER_LIST.add(new FillStyleCellWriteHandler());
    }
}

