/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import org.apache.maven.api.JavaPathType;
import org.apache.maven.api.PathType;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.plugin.compiler.AbstractCompilerMojo;
import org.apache.maven.plugin.compiler.CompilationTaskSources;
import org.apache.maven.plugin.compiler.ModuleDirectoryRemover;
import org.apache.maven.plugin.compiler.ModuleInfoPatch;
import org.apache.maven.plugin.compiler.ModuleInfoPatchException;
import org.apache.maven.plugin.compiler.Options;
import org.apache.maven.plugin.compiler.SourceDirectory;
import org.apache.maven.plugin.compiler.SourcesForRelease;
import org.apache.maven.plugin.compiler.TestCompilerMojo;
import org.apache.maven.plugin.compiler.ToolExecutor;

class ToolExecutorForTest
extends ToolExecutor {
    protected final Path mainOutputDirectory;
    private final Path mainModulePath;
    @Deprecated(since="4.0.0")
    private final boolean useModulePath;
    @Deprecated(since="4.0.0")
    private final boolean hasTestModuleInfo;
    private boolean testInItsOwnModule;
    private boolean overwriteMainModuleInfo;
    private String moduleName;
    private boolean addedModuleOptions;
    @Deprecated(since="4.0.0")
    private String directoryLevelToRemove;

    ToolExecutorForTest(TestCompilerMojo mojo, DiagnosticListener<? super JavaFileObject> listener) throws IOException {
        super(mojo, listener);
        this.mainOutputDirectory = mojo.mainOutputDirectory;
        this.mainModulePath = mojo.mainModulePath;
        this.useModulePath = mojo.useModulePath;
        this.hasTestModuleInfo = mojo.hasTestModuleInfo;
        LinkedHashMap<String, Set> patchedModules = new LinkedHashMap<String, Set>();
        for (SourceDirectory dir : this.sourceDirectories) {
            String moduleToPatch2 = dir.moduleName;
            if (moduleToPatch2 == null) {
                moduleToPatch2 = this.getMainModuleName();
                if (moduleToPatch2.isEmpty()) continue;
                String testModuleName = mojo.getTestModuleName(this.sourceDirectories);
                if (testModuleName != null) {
                    this.overwriteMainModuleInfo = testModuleName.equals(this.getMainModuleName());
                    if (!this.overwriteMainModuleInfo) {
                        this.testInItsOwnModule = true;
                        continue;
                    }
                }
                this.directoryLevelToRemove = moduleToPatch2;
            }
            patchedModules.put(moduleToPatch2, new LinkedHashSet());
        }
        mojo.getSourceRoots(ProjectScope.MAIN).forEach(root -> root.module().ifPresent(moduleToPatch -> {
            Set paths = (Set)patchedModules.get(moduleToPatch);
            if (paths != null) {
                Path path = root.targetPath().orElseGet(() -> Path.of(moduleToPatch, new String[0]));
                path = this.mainOutputDirectory.resolve(path);
                paths.add(path);
            }
        }));
        patchedModules.values().removeIf(Set::isEmpty);
        patchedModules.forEach((moduleToPatch, paths) -> this.dependencies((PathType)JavaPathType.patchModule((String)moduleToPatch)).addAll((Collection<Path>)paths));
        if (patchedModules.isEmpty() && Files.exists(this.mainOutputDirectory, new LinkOption[0])) {
            JavaPathType pathType = JavaPathType.CLASSES;
            if (this.hasModuleDeclaration) {
                String moduleToPatch3;
                pathType = JavaPathType.MODULES;
                if (!this.testInItsOwnModule && !(moduleToPatch3 = this.getMainModuleName()).isEmpty()) {
                    pathType = JavaPathType.patchModule((String)moduleToPatch3);
                    this.directoryLevelToRemove = moduleToPatch3;
                }
            }
            this.prependDependency((PathType)pathType, this.mainOutputDirectory);
        }
    }

    private String getMainModuleName() throws IOException {
        if (this.moduleName == null) {
            if (this.mainModulePath != null) {
                try (InputStream in = Files.newInputStream(this.mainModulePath, new OpenOption[0]);){
                    this.moduleName = ModuleDescriptor.read(in).name();
                }
            } else {
                this.moduleName = "";
            }
        }
        return this.moduleName;
    }

    @Override
    final String inferModuleNameIfMissing(String moduleName) throws IOException {
        return !this.testInItsOwnModule && moduleName.isEmpty() ? this.getMainModuleName() : moduleName;
    }

    private void addModuleOptions(Options configuration) throws IOException {
        if (this.addedModuleOptions) {
            return;
        }
        this.addedModuleOptions = true;
        ModuleInfoPatch info = null;
        ModuleInfoPatch defaultInfo = null;
        LinkedHashMap<String, ModuleInfoPatch> patches = new LinkedHashMap<String, ModuleInfoPatch>();
        for (SourceDirectory sourceDirectory : this.sourceDirectories) {
            String module;
            Path file = sourceDirectory.root.resolve("module-info-patch.maven");
            if (Files.notExists(file, new LinkOption[0])) {
                if (this.useModulePath && this.hasTestModuleInfo && this.hasModuleDeclaration || (module = sourceDirectory.moduleName) == null && (module = this.getMainModuleName()).isEmpty()) continue;
                if (defaultInfo != null) {
                    patches.putIfAbsent(module, null);
                    continue;
                }
                defaultInfo = new ModuleInfoPatch(module, info);
                defaultInfo.setToDefaults();
                info = defaultInfo;
            } else {
                info = new ModuleInfoPatch(this.getMainModuleName(), info);
                try (BufferedReader reader = Files.newBufferedReader(file);){
                    info.load(reader);
                }
                module = info.getModuleName();
            }
            if (patches.put(module, info) == null) continue;
            throw new ModuleInfoPatchException("\"module-info-patch " + module + "\" is defined more than once.");
        }
        for (Map.Entry entry : patches.entrySet()) {
            info = (ModuleInfoPatch)entry.getValue();
            if (info != null) {
                info.replaceProjectModules(this.sourceDirectories);
                info.replaceTestModulePath(this.dependencyResolution);
                continue;
            }
            entry.setValue(defaultInfo.patchWithSameReads((String)entry.getKey()));
        }
        if (!patches.isEmpty()) {
            Path directory = Files.createDirectories(this.outputDirectory.resolve("META-INF").resolve("maven"), new FileAttribute[0]);
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(directory.resolve("module-info-patch.args"), new OpenOption[0]);){
                for (ModuleInfoPatch m : patches.values()) {
                    m.writeTo(configuration, bufferedWriter);
                }
            }
        }
    }

    @Override
    public boolean applyIncrementalBuild(AbstractCompilerMojo mojo, Options configuration) throws IOException {
        this.addModuleOptions(configuration);
        return super.applyIncrementalBuild(mojo, configuration);
    }

    @Override
    public boolean compile(JavaCompiler compiler, Options configuration, Writer otherOutput) throws IOException {
        this.addModuleOptions(configuration);
        try (ModuleDirectoryRemover r = ModuleDirectoryRemover.create(this.outputDirectory, this.directoryLevelToRemove);){
            boolean bl = super.compile(compiler, configuration, otherOutput);
            return bl;
        }
    }

    @Override
    final CompilationTaskSources[] toCompilationTasks(final SourcesForRelease unit) {
        if (!(this.useModulePath && this.hasTestModuleInfo && this.overwriteMainModuleInfo)) {
            return super.toCompilationTasks(unit);
        }
        CompilationTaskSources moduleInfo = null;
        List<Path> files = unit.files;
        int i = files.size();
        while (--i >= 0) {
            if (!SourceDirectory.isModuleInfoSource(files.get(i))) continue;
            moduleInfo = new CompilationTaskSources(List.of(files.remove(i)));
            if (!files.isEmpty()) break;
            return new CompilationTaskSources[]{moduleInfo};
        }
        if (files.isEmpty()) {
            return new CompilationTaskSources[0];
        }
        CompilationTaskSources task = new CompilationTaskSources(files){

            @Override
            boolean compile(JavaCompiler.CompilationTask task) throws IOException {
                try (SourcesForRelease sourcesForRelease = unit;){
                    unit.substituteModuleInfos(ToolExecutorForTest.this.mainOutputDirectory, ToolExecutorForTest.this.outputDirectory);
                    boolean bl = super.compile(task);
                    return bl;
                }
            }
        };
        if (moduleInfo != null) {
            return new CompilationTaskSources[]{moduleInfo, task};
        }
        return new CompilationTaskSources[]{task};
    }
}

