/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import java.util.Arrays;

public class ListUtils {
    public static UnsafeArrayListClosable<AnalysisObject> getTLArrayList(ThreadLocal<UnsafeArrayListClosable<AnalysisObject>> tl, int initialCapacity) {
        UnsafeArrayListClosable<AnalysisObject> result = tl.get();
        if (result == null) {
            result = new UnsafeArrayListClosable<AnalysisObject>(new UnsafeArrayList<AnalysisObject>(new AnalysisObject[initialCapacity]));
            tl.set(result);
        }
        if (result.closed) {
            result.closed = false;
            return result;
        }
        return new UnsafeArrayListClosable<AnalysisObject>(new UnsafeArrayList<AnalysisObject>(new AnalysisObject[initialCapacity]));
    }

    public static class UnsafeArrayList<E> {
        static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
        E[] elementData;
        int size;

        UnsafeArrayList(E[] initial) {
            this.elementData = initial;
        }

        public <T> T[] copyToArray(T[] a) {
            System.arraycopy(this.elementData, 0, a, 0, this.size);
            return a;
        }

        public <T> T[] copyToArray(T[] a, int dstPos) {
            System.arraycopy(this.elementData, 0, a, dstPos, this.size);
            return a;
        }

        public <E1 extends E> void addAll(E1[] c, int startIndex, int endIndex) {
            assert (startIndex <= endIndex) : "start index can't be smaller than the end index.";
            int newElements = endIndex - startIndex;
            this.ensureCapacity(this.size() + newElements);
            System.arraycopy(c, startIndex, this.elementData, this.size, newElements);
            this.size += newElements;
        }

        public int size() {
            return this.size;
        }

        public E[] elementData() {
            return this.elementData;
        }

        public void add(E e) {
            this.ensureCapacity(this.size + 1);
            this.elementData[this.size] = e;
            ++this.size;
        }

        public void clear() {
            for (int i = 0; i < this.size; ++i) {
                this.elementData[i] = null;
            }
            this.size = 0;
        }

        public E get(int i) {
            assert (i < this.size && i >= 0);
            return this.elementData[i];
        }

        private void ensureCapacity(int minCapacity) {
            if (minCapacity - this.elementData.length > 0) {
                this.grow(minCapacity);
            }
        }

        private void grow(int minCapacity) {
            int oldCapacity = this.elementData.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - 0x7FFFFFF7 > 0) {
                if (minCapacity < 0) {
                    throw new OutOfMemoryError();
                }
                newCapacity = minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
            }
            this.elementData = Arrays.copyOf(this.elementData, newCapacity);
        }
    }

    public static final class UnsafeArrayListClosable<E>
    implements AutoCloseable {
        private UnsafeArrayList<E> list;
        private boolean closed = true;

        private UnsafeArrayListClosable(UnsafeArrayList<E> list) {
            this.list = list;
        }

        public UnsafeArrayList<E> list() {
            return this.list;
        }

        @Override
        public void close() {
            this.list.clear();
            this.closed = true;
        }
    }
}

