/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestore;

import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.typestore.FieldTypeStore;

public class UnifiedFieldTypeStore
extends FieldTypeStore {
    private final FieldTypeFlow readWriteFlow;

    public UnifiedFieldTypeStore(AnalysisField field, AnalysisObject object) {
        this(field, object, new FieldTypeFlow(field, field.getType(), object));
    }

    public UnifiedFieldTypeStore(AnalysisField field, AnalysisObject object, FieldTypeFlow fieldFlow) {
        super(field, object);
        this.readWriteFlow = fieldFlow;
    }

    @Override
    public FieldTypeFlow readFlow() {
        return this.readWriteFlow;
    }

    @Override
    public FieldTypeFlow writeFlow() {
        return this.readWriteFlow;
    }

    public FieldTypeFlow readWriteFlow() {
        return this.readWriteFlow;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("UnifiedFieldStore<").append(this.field.format("%h.%n")).append("\n").append(this.object).append(">");
        return str.toString();
    }
}

