/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalMethodProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaType;
import com.oracle.graal.pointsto.infrastructure.WrappedSignature;
import com.oracle.graal.pointsto.meta.AnalysisElement;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import com.oracle.graal.pointsto.results.StaticAnalysisResults;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.AtomicUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.GraphDecoder;
import org.graalvm.compiler.nodes.StructuredGraph;

public abstract class AnalysisMethod
extends AnalysisElement
implements WrappedJavaMethod,
GraphProvider,
OriginalMethodProvider {
    private static final AtomicIntegerFieldUpdater<AnalysisMethod> isVirtualRootMethodUpdater = AtomicIntegerFieldUpdater.newUpdater(AnalysisMethod.class, "isVirtualRootMethod");
    private static final AtomicIntegerFieldUpdater<AnalysisMethod> isDirectRootMethodUpdater = AtomicIntegerFieldUpdater.newUpdater(AnalysisMethod.class, "isDirectRootMethod");
    private static final AtomicIntegerFieldUpdater<AnalysisMethod> isInvokedUpdater = AtomicIntegerFieldUpdater.newUpdater(AnalysisMethod.class, "isInvoked");
    private static final AtomicIntegerFieldUpdater<AnalysisMethod> isImplementationInvokedUpdater = AtomicIntegerFieldUpdater.newUpdater(AnalysisMethod.class, "isImplementationInvoked");
    private static final AtomicIntegerFieldUpdater<AnalysisMethod> isIntrinsicMethodUpdater = AtomicIntegerFieldUpdater.newUpdater(AnalysisMethod.class, "isIntrinsicMethod");
    private static final AtomicIntegerFieldUpdater<AnalysisMethod> isInlinedUpdater = AtomicIntegerFieldUpdater.newUpdater(AnalysisMethod.class, "isInlined");
    public final ResolvedJavaMethod wrapped;
    private final int id;
    private final boolean hasNeverInlineDirective;
    private final ExceptionHandler[] exceptionHandlers;
    private final LocalVariableTable localVariableTable;
    private final String qualifiedName;
    private final AnalysisType declaringClass;
    private volatile int isVirtualRootMethod;
    private volatile int isDirectRootMethod;
    private Object entryPointData;
    private volatile int isInvoked;
    private volatile int isImplementationInvoked;
    private volatile int isIntrinsicMethod;
    private volatile int isInlined;
    private final AtomicReference<Object> parsedGraphCacheState = new AtomicReference<Object>(GRAPH_CACHE_UNPARSED);
    private static final Object GRAPH_CACHE_UNPARSED = "unparsed";
    private static final Object GRAPH_CACHE_CLEARED = "cleared by cleanupAfterAnalysis";
    private EncodedGraph analyzedGraph;
    protected AnalysisMethod[] implementations;

    public AnalysisMethod(AnalysisUniverse universe, ResolvedJavaMethod wrapped) {
        this.wrapped = wrapped;
        this.id = universe.nextMethodId.getAndIncrement();
        this.declaringClass = universe.lookup((JavaType)wrapped.getDeclaringClass());
        this.hasNeverInlineDirective = universe.hostVM().hasNeverInlineDirective(wrapped);
        if (((Boolean)PointstoOptions.TrackAccessChain.getValue(universe.hostVM().options())).booleanValue()) {
            this.startTrackInvocations();
        }
        ExceptionHandler[] original = wrapped.getExceptionHandlers();
        this.exceptionHandlers = new ExceptionHandler[original.length];
        for (int i = 0; i < original.length; ++i) {
            ExceptionHandler h = original[i];
            JavaType catchType = this.getCatchType(universe, h);
            this.exceptionHandlers[i] = new ExceptionHandler(h.getStartBCI(), h.getEndBCI(), h.getHandlerBCI(), h.catchTypeCPI(), catchType);
        }
        LocalVariableTable newLocalVariableTable = null;
        if (wrapped.getLocalVariableTable() != null) {
            try {
                Local[] origLocals = wrapped.getLocalVariableTable().getLocals();
                Local[] newLocals = new Local[origLocals.length];
                ResolvedJavaType accessingClass = this.getDeclaringClass().getWrapped();
                for (int i = 0; i < newLocals.length; ++i) {
                    Local origLocal = origLocals[i];
                    ResolvedJavaType origLocalType = origLocal.getType() instanceof ResolvedJavaType ? (ResolvedJavaType)origLocal.getType() : origLocal.getType().resolve(accessingClass);
                    AnalysisType type = universe.lookup((JavaType)origLocalType);
                    newLocals[i] = new Local(origLocal.getName(), (JavaType)type, origLocal.getStartBCI(), origLocal.getEndBCI(), origLocal.getSlot());
                }
                newLocalVariableTable = new LocalVariableTable(newLocals);
            }
            catch (UnsupportedFeatureException | LinkageError | BytecodeParser.BytecodeParserError e) {
                newLocalVariableTable = null;
            }
        }
        this.localVariableTable = newLocalVariableTable;
        this.qualifiedName = this.format("%H.%n(%P)");
        this.registerSignatureTypes();
    }

    private void registerSignatureTypes() {
        int offset;
        boolean isStatic = Modifier.isStatic(this.getModifiers());
        int parameterCount = this.getSignature().getParameterCount(!isStatic);
        for (int i = offset = isStatic ? 0 : 1; i < parameterCount; ++i) {
            this.getSignature().getParameterType(i - offset, this.getDeclaringClass());
        }
        this.getSignature().getReturnType(this.getDeclaringClass());
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    private JavaType getCatchType(AnalysisUniverse universe, ExceptionHandler handler) {
        ResolvedJavaType resolvedCatchType;
        JavaType catchType = handler.getCatchType();
        if (catchType == null) {
            return null;
        }
        try {
            resolvedCatchType = catchType.resolve(this.wrapped.getDeclaringClass());
        }
        catch (LinkageError e) {
            return catchType;
        }
        return universe.lookup((JavaType)resolvedCatchType);
    }

    private AnalysisUniverse getUniverse() {
        return this.declaringClass.getUniverse();
    }

    public void cleanupAfterAnalysis() {
        if (this.parsedGraphCacheState.get() instanceof AnalysisParsedGraph) {
            this.parsedGraphCacheState.set(GRAPH_CACHE_CLEARED);
        }
    }

    public abstract void startTrackInvocations();

    public abstract Iterable<? extends InvokeInfo> getInvokes();

    public abstract StackTraceElement[] getParsingContext();

    public int getId() {
        return this.id;
    }

    public void registerAsIntrinsicMethod() {
        AtomicUtils.atomicMarkAndRun(this, isIntrinsicMethodUpdater, this::onReachable);
    }

    public void registerAsEntryPoint(Object newEntryPointData) {
        assert (newEntryPointData != null);
        if (this.entryPointData != null && !this.entryPointData.equals(newEntryPointData)) {
            throw new UnsupportedFeatureException("Method is registered as entry point with conflicting entry point data: " + this.entryPointData + ", " + newEntryPointData);
        }
        this.entryPointData = newEntryPointData;
        this.startTrackInvocations();
    }

    public boolean registerAsInvoked() {
        return AtomicUtils.atomicMark(this, isInvokedUpdater);
    }

    public boolean registerAsImplementationInvoked() {
        assert (!Modifier.isAbstract(this.getModifiers()));
        this.getDeclaringClass().registerAsReachable();
        return AtomicUtils.atomicMarkAndRun(this, isImplementationInvokedUpdater, this::onReachable);
    }

    public void registerAsInlined() {
        AtomicUtils.atomicMarkAndRun(this, isInlinedUpdater, this::onReachable);
    }

    public Set<AnalysisMethod> getCallers() {
        return this.getInvokeLocations().stream().map(location -> (AnalysisMethod)location.getMethod()).collect(Collectors.toSet());
    }

    public abstract List<BytecodePosition> getInvokeLocations();

    public boolean isEntryPoint() {
        return this.entryPointData != null;
    }

    public Object getEntryPointData() {
        return this.entryPointData;
    }

    public boolean isIntrinsicMethod() {
        return AtomicUtils.isSet(this, isIntrinsicMethodUpdater);
    }

    public boolean registerAsVirtualRootMethod() {
        this.getDeclaringClass().registerAsReachable();
        return AtomicUtils.atomicMark(this, isVirtualRootMethodUpdater);
    }

    public boolean registerAsDirectRootMethod() {
        this.getDeclaringClass().registerAsReachable();
        return AtomicUtils.atomicMark(this, isDirectRootMethodUpdater);
    }

    public boolean isVirtualRootMethod() {
        return AtomicUtils.isSet(this, isVirtualRootMethodUpdater);
    }

    public boolean isDirectRootMethod() {
        return AtomicUtils.isSet(this, isDirectRootMethodUpdater);
    }

    public boolean isSimplyInvoked() {
        return AtomicUtils.isSet(this, isInvokedUpdater);
    }

    public boolean isSimplyImplementationInvoked() {
        return AtomicUtils.isSet(this, isImplementationInvokedUpdater);
    }

    public boolean isInvoked() {
        return this.isIntrinsicMethod() || this.isVirtualRootMethod() || this.isDirectRootMethod() || AtomicUtils.isSet(this, isInvokedUpdater);
    }

    public boolean isImplementationInvoked() {
        return !Modifier.isAbstract(this.getModifiers()) && (this.isIntrinsicMethod() || AtomicUtils.isSet(this, isImplementationInvokedUpdater));
    }

    @Override
    public boolean isReachable() {
        return this.isImplementationInvoked() || AtomicUtils.isSet(this, isInlinedUpdater);
    }

    @Override
    public boolean isTriggered() {
        if (this.isReachable()) {
            return true;
        }
        return this.isClassInitializer() && this.getDeclaringClass().isInitialized();
    }

    @Override
    public void onReachable() {
        this.notifyReachabilityCallbacks(this.declaringClass.getUniverse(), new ArrayList<AnalysisFuture<Void>>());
        this.processMethodOverrides();
    }

    private void processMethodOverrides() {
        if (this.wrapped.canBeStaticallyBound() || this.isConstructor()) {
            this.notifyMethodOverride(this);
        } else if (this.declaringClass.isAnySubtypeInstantiated()) {
            this.declaringClass.forAllSuperTypes(superType -> {
                AnalysisMethod superMethod = this.findInType((AnalysisType)superType);
                if (superMethod != null) {
                    superMethod.notifyMethodOverride(this);
                }
            });
        }
    }

    private AnalysisMethod findInType(AnalysisType type) {
        try {
            return type.findMethod(this.wrapped.getName(), this.getSignature());
        }
        catch (UnsupportedFeatureException | LinkageError e) {
            return null;
        }
    }

    protected void notifyMethodOverride(AnalysisMethod override) {
        this.declaringClass.getOverrideReachabilityNotifications(this).forEach(n -> n.notifyCallback(this.getUniverse(), override));
    }

    public void registerOverrideReachabilityNotification(AnalysisElement.MethodOverrideReachableNotification notification) {
        this.declaringClass.registerOverrideReachabilityNotification(this, notification);
    }

    protected AnalysisMethod resolveInType(AnalysisType holder) {
        return this.resolveInType(holder, holder.isAnySubtypeInstantiated());
    }

    protected AnalysisMethod resolveInType(AnalysisType holder, boolean holderOrSubtypeInstantiated) {
        if (holderOrSubtypeInstantiated || this.isIntrinsicMethod()) {
            AnalysisMethod resolved;
            try {
                resolved = holder.resolveConcreteMethod(this, null);
            }
            catch (UnsupportedFeatureException e) {
                resolved = null;
            }
            return resolved;
        }
        return null;
    }

    @Override
    public ResolvedJavaMethod getWrapped() {
        return this.wrapped;
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public WrappedSignature getSignature() {
        return this.getUniverse().lookup(this.wrapped.getSignature(), (WrappedJavaType)this.getDeclaringClass());
    }

    @Override
    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        if (this.wrapped instanceof GraphProvider) {
            return ((GraphProvider)this.wrapped).buildGraph(debug, method, providers, purpose);
        }
        return null;
    }

    @Override
    public boolean allowRuntimeCompilation() {
        if (this.wrapped instanceof GraphProvider) {
            return ((GraphProvider)this.wrapped).allowRuntimeCompilation();
        }
        return true;
    }

    public byte[] getCode() {
        return this.wrapped.getCode();
    }

    public int getCodeSize() {
        return this.wrapped.getCodeSize();
    }

    public AnalysisType getDeclaringClass() {
        return this.declaringClass;
    }

    public int getMaxLocals() {
        return this.wrapped.getMaxLocals();
    }

    public int getMaxStackSize() {
        return this.wrapped.getMaxStackSize();
    }

    public ResolvedJavaMethod.Parameter[] getParameters() {
        return this.wrapped.getParameters();
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public boolean isSynthetic() {
        return this.wrapped.isSynthetic();
    }

    public boolean isVarArgs() {
        return this.wrapped.isVarArgs();
    }

    public boolean isBridge() {
        return this.wrapped.isBridge();
    }

    public boolean isClassInitializer() {
        return this.wrapped.isClassInitializer();
    }

    public boolean isConstructor() {
        return this.wrapped.isConstructor();
    }

    public boolean canBeStaticallyBound() {
        boolean result = this.wrapped.canBeStaticallyBound();
        assert (!this.isStatic() || result) : "static methods must always be statically bindable: " + this.format("%H.%n");
        return result;
    }

    public AnalysisMethod[] getImplementations() {
        assert (this.getUniverse().analysisDataValid);
        if (this.implementations == null) {
            return new AnalysisMethod[0];
        }
        return this.implementations;
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public StackTraceElement asStackTraceElement(int bci) {
        return this.wrapped.asStackTraceElement(bci);
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        return StaticAnalysisResults.NO_RESULTS;
    }

    public ConstantPool getConstantPool() {
        return this.getUniverse().lookup(this.wrapped.getConstantPool(), (WrappedJavaType)this.getDeclaringClass());
    }

    public Annotation[][] getParameterAnnotations() {
        return this.wrapped.getParameterAnnotations();
    }

    public Type[] getGenericParameterTypes() {
        return this.wrapped.getGenericParameterTypes();
    }

    public boolean canBeInlined() {
        return !this.hasNeverInlineDirective();
    }

    public boolean hasNeverInlineDirective() {
        return this.hasNeverInlineDirective;
    }

    public boolean shouldBeInlined() {
        throw JVMCIError.unimplemented();
    }

    public LineNumberTable getLineNumberTable() {
        return this.wrapped.getLineNumberTable();
    }

    public String toString() {
        return "AnalysisMethod<" + this.format("%H.%n") + " -> " + this.wrapped.toString() + ">";
    }

    public LocalVariableTable getLocalVariableTable() {
        return this.localVariableTable;
    }

    public void reprofile() {
        throw JVMCIError.unimplemented();
    }

    public Constant getEncoding() {
        throw JVMCIError.unimplemented();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        return false;
    }

    public boolean isDefault() {
        return this.wrapped.isDefault();
    }

    public SpeculationLog getSpeculationLog() {
        throw JVMCIError.shouldNotReachHere();
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public Executable getJavaMethod() {
        return OriginalMethodProvider.getJavaMethod(this.getUniverse().getOriginalSnippetReflection(), this.wrapped);
    }

    /*
     * Unable to fully structure code
     */
    public AnalysisParsedGraph ensureGraphParsed(BigBang bb) {
        while (true) lbl-1000:
        // 4 sources

        {
            if ((curState = this.parsedGraphCacheState.get()) == AnalysisMethod.GRAPH_CACHE_UNPARSED) {
                lock = new ReentrantLock();
                lock.lock();
                try {
                    if (!this.parsedGraphCacheState.compareAndSet(AnalysisMethod.GRAPH_CACHE_UNPARSED, lock)) ** GOTO lbl-1000
                    graph = AnalysisParsedGraph.parseBytecode(bb, this);
                    result = this.parsedGraphCacheState.compareAndSet(lock, graph);
                    AnalysisError.guarantee(result, "State transition failed", new Object[0]);
                    var6_7 = graph;
                    return var6_7;
                }
                catch (Throwable ex) {
                    this.parsedGraphCacheState.set(ex);
                    throw ex;
                }
                finally {
                    lock.unlock();
                }
                continue;
            }
            if (!(curState instanceof ReentrantLock)) break;
            lock = (ReentrantLock)curState;
            AnalysisError.guarantee(lock.isHeldByCurrentThread() == false, "Recursive parsing request, would lead to endless waiting loop", new Object[0]);
            lock.lock();
            AnalysisError.guarantee(this.parsedGraphCacheState.get() != lock, "Parsing must have finished in the thread that installed the lock", new Object[0]);
            lock.unlock();
        }
        if (curState instanceof AnalysisParsedGraph) {
            return (AnalysisParsedGraph)curState;
        }
        if (curState instanceof Throwable) {
            throw AnalysisError.shouldNotReachHere("parsing had failed in another thread", (Throwable)curState);
        }
        if (curState == AnalysisMethod.GRAPH_CACHE_CLEARED) {
            return null;
        }
        throw AnalysisError.shouldNotReachHere("Unknown state: " + curState);
    }

    public StructuredGraph decodeAnalyzedGraph(DebugContext debug, Iterable<EncodedGraph.EncodedNodeReference> nodeReferences) {
        if (this.analyzedGraph == null) {
            return null;
        }
        StructuredGraph result = new StructuredGraph.Builder(debug.getOptions(), debug).method((ResolvedJavaMethod)this).recordInlinedMethods(false).trackNodeSourcePosition(this.analyzedGraph.trackNodeSourcePosition()).build();
        GraphDecoder decoder = new GraphDecoder(AnalysisParsedGraph.HOST_ARCHITECTURE, result);
        decoder.decode(this.analyzedGraph, nodeReferences);
        return result;
    }

    public void setAnalyzedGraph(EncodedGraph analyzedGraph) {
        this.analyzedGraph = analyzedGraph;
    }
}

