/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.sl.draw.DrawPaint;
import org.apache.poi.sl.usermodel.AutoNumberingScheme;
import org.apache.poi.sl.usermodel.ColorStyle;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.sl.usermodel.TextParagraph;
import org.apache.poi.util.Internal;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.model.ParagraphPropertyFetcher;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFColor;
import org.apache.poi.xslf.usermodel.XSLFLineBreak;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFTextRun;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTRegularTextRun;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextAutonumberBullet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBulletSizePercent;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBulletSizePoint;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharBullet;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextField;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextFont;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextLineBreak;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextNormalAutofit;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextSpacing;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextTabStop;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextTabStopList;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAlignType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAutonumberScheme;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextFontAlignType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;

public class XSLFTextParagraph
implements TextParagraph<XSLFShape, XSLFTextParagraph, XSLFTextRun> {
    private final CTTextParagraph _p;
    private final List<XSLFTextRun> _runs;
    private final XSLFTextShape _shape;

    XSLFTextParagraph(CTTextParagraph p, XSLFTextShape shape) {
        this._p = p;
        this._runs = new ArrayList<XSLFTextRun>();
        this._shape = shape;
        for (XmlObject ch : this._p.selectPath("*")) {
            CTRegularTextRun r;
            if (ch instanceof CTRegularTextRun) {
                CTRegularTextRun r2 = (CTRegularTextRun)ch;
                this._runs.add(this.newTextRun(r2));
                continue;
            }
            if (ch instanceof CTTextLineBreak) {
                CTTextLineBreak br = (CTTextLineBreak)ch;
                r = CTRegularTextRun.Factory.newInstance();
                r.setRPr(br.getRPr());
                r.setT("\n");
                this._runs.add(this.newTextRun(r));
                continue;
            }
            if (!(ch instanceof CTTextField)) continue;
            CTTextField f = (CTTextField)ch;
            r = CTRegularTextRun.Factory.newInstance();
            r.setRPr(f.getRPr());
            r.setT(f.getT());
            this._runs.add(this.newTextRun(r));
        }
    }

    public String getText() {
        StringBuilder out = new StringBuilder();
        for (XSLFTextRun r : this._runs) {
            out.append(r.getRawText());
        }
        return out.toString();
    }

    String getRenderableText() {
        StringBuilder out = new StringBuilder();
        for (XSLFTextRun r : this._runs) {
            out.append(r.getRenderableText());
        }
        return out.toString();
    }

    @Internal
    public CTTextParagraph getXmlObject() {
        return this._p;
    }

    public XSLFTextShape getParentShape() {
        return this._shape;
    }

    public List<XSLFTextRun> getTextRuns() {
        return this._runs;
    }

    public Iterator<XSLFTextRun> iterator() {
        return this._runs.iterator();
    }

    public XSLFTextRun addNewTextRun() {
        CTRegularTextRun r = this._p.addNewR();
        CTTextCharacterProperties rPr = r.addNewRPr();
        rPr.setLang("en-US");
        XSLFTextRun run = this.newTextRun(r);
        this._runs.add(run);
        return run;
    }

    public XSLFTextRun addLineBreak() {
        CTTextLineBreak br = this._p.addNewBr();
        CTTextCharacterProperties brProps = br.addNewRPr();
        if (this._runs.size() > 0) {
            CTTextCharacterProperties prevRun = this._runs.get(this._runs.size() - 1).getRPr(true);
            brProps.set((XmlObject)prevRun);
        }
        CTRegularTextRun r = CTRegularTextRun.Factory.newInstance();
        r.setRPr(brProps);
        r.setT("\n");
        XSLFLineBreak run = new XSLFLineBreak(r, this, brProps);
        this._runs.add(run);
        return run;
    }

    public TextParagraph.TextAlign getTextAlign() {
        ParagraphPropertyFetcher<TextParagraph.TextAlign> fetcher = new ParagraphPropertyFetcher<TextParagraph.TextAlign>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetAlgn()) {
                    TextParagraph.TextAlign val = TextParagraph.TextAlign.values()[props.getAlgn().intValue() - 1];
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (TextParagraph.TextAlign)fetcher.getValue();
    }

    public void setTextAlign(TextParagraph.TextAlign align) {
        CTTextParagraphProperties pr;
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (align == null) {
            if (pr.isSetAlgn()) {
                pr.unsetAlgn();
            }
        } else {
            pr.setAlgn(STTextAlignType.Enum.forInt((int)(align.ordinal() + 1)));
        }
    }

    public TextParagraph.FontAlign getFontAlign() {
        ParagraphPropertyFetcher<TextParagraph.FontAlign> fetcher = new ParagraphPropertyFetcher<TextParagraph.FontAlign>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetFontAlgn()) {
                    TextParagraph.FontAlign val = TextParagraph.FontAlign.values()[props.getFontAlgn().intValue() - 1];
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (TextParagraph.FontAlign)fetcher.getValue();
    }

    public void setFontAlign(TextParagraph.FontAlign align) {
        CTTextParagraphProperties pr;
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (align == null) {
            if (pr.isSetFontAlgn()) {
                pr.unsetFontAlgn();
            }
        } else {
            pr.setFontAlgn(STTextFontAlignType.Enum.forInt((int)(align.ordinal() + 1)));
        }
    }

    public String getBulletFont() {
        ParagraphPropertyFetcher<String> fetcher = new ParagraphPropertyFetcher<String>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetBuFont()) {
                    this.setValue(props.getBuFont().getTypeface());
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (String)fetcher.getValue();
    }

    public void setBulletFont(String typeface) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextFont font = pr.isSetBuFont() ? pr.getBuFont() : pr.addNewBuFont();
        font.setTypeface(typeface);
    }

    public String getBulletCharacter() {
        ParagraphPropertyFetcher<String> fetcher = new ParagraphPropertyFetcher<String>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetBuChar()) {
                    this.setValue(props.getBuChar().getChar());
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (String)fetcher.getValue();
    }

    public void setBulletCharacter(String str) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextCharBullet c = pr.isSetBuChar() ? pr.getBuChar() : pr.addNewBuChar();
        c.setChar(str);
    }

    public PaintStyle getBulletFontColor() {
        final XSLFTheme theme = this.getParentShape().getSheet().getTheme();
        ParagraphPropertyFetcher<Color> fetcher = new ParagraphPropertyFetcher<Color>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetBuClr()) {
                    XSLFColor c = new XSLFColor((XmlObject)props.getBuClr(), theme, null);
                    this.setValue(c.getColor());
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        Color col = (Color)fetcher.getValue();
        return col == null ? null : DrawPaint.createSolidPaint((Color)col);
    }

    public void setBulletFontColor(Color color) {
        this.setBulletFontColor((PaintStyle)DrawPaint.createSolidPaint((Color)color));
    }

    public void setBulletFontColor(PaintStyle color) {
        if (!(color instanceof PaintStyle.SolidPaint)) {
            throw new IllegalArgumentException("Currently XSLF only supports SolidPaint");
        }
        PaintStyle.SolidPaint sp = (PaintStyle.SolidPaint)color;
        Color col = DrawPaint.applyColorTransform((ColorStyle)sp.getSolidColor());
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTColor c = pr.isSetBuClr() ? pr.getBuClr() : pr.addNewBuClr();
        CTSRgbColor clr = c.isSetSrgbClr() ? c.getSrgbClr() : c.addNewSrgbClr();
        clr.setVal(new byte[]{(byte)col.getRed(), (byte)col.getGreen(), (byte)col.getBlue()});
    }

    public Double getBulletFontSize() {
        ParagraphPropertyFetcher<Double> fetcher = new ParagraphPropertyFetcher<Double>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetBuSzPct()) {
                    this.setValue((double)props.getBuSzPct().getVal() * 0.001);
                    return true;
                }
                if (props.isSetBuSzPts()) {
                    this.setValue((double)(-props.getBuSzPts().getVal()) * 0.01);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (Double)fetcher.getValue();
    }

    public void setBulletFontSize(double bulletSize) {
        CTTextParagraphProperties pr;
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (bulletSize >= 0.0) {
            CTTextBulletSizePercent pt = pr.isSetBuSzPct() ? pr.getBuSzPct() : pr.addNewBuSzPct();
            pt.setVal((int)(bulletSize * 1000.0));
            if (pr.isSetBuSzPts()) {
                pr.unsetBuSzPts();
            }
        } else {
            CTTextBulletSizePoint pt = pr.isSetBuSzPts() ? pr.getBuSzPts() : pr.addNewBuSzPts();
            pt.setVal((int)(-bulletSize * 100.0));
            if (pr.isSetBuSzPct()) {
                pr.unsetBuSzPct();
            }
        }
    }

    public AutoNumberingScheme getAutoNumberingScheme() {
        ParagraphPropertyFetcher<AutoNumberingScheme> fetcher = new ParagraphPropertyFetcher<AutoNumberingScheme>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                AutoNumberingScheme ans;
                if (props.isSetBuAutoNum() && (ans = AutoNumberingScheme.forOoxmlID((int)props.getBuAutoNum().getType().intValue())) != null) {
                    this.setValue(ans);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (AutoNumberingScheme)fetcher.getValue();
    }

    public Integer getAutoNumberingStartAt() {
        ParagraphPropertyFetcher<Integer> fetcher = new ParagraphPropertyFetcher<Integer>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetBuAutoNum() && props.getBuAutoNum().isSetStartAt()) {
                    this.setValue(props.getBuAutoNum().getStartAt());
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (Integer)fetcher.getValue();
    }

    public void setIndent(Double indent) {
        CTTextParagraphProperties pr;
        if (indent == null && !this._p.isSetPPr()) {
            return;
        }
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (indent == null) {
            if (pr.isSetIndent()) {
                pr.unsetIndent();
            }
        } else {
            pr.setIndent(Units.toEMU((double)indent));
        }
    }

    public Double getIndent() {
        ParagraphPropertyFetcher<Double> fetcher = new ParagraphPropertyFetcher<Double>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetIndent()) {
                    this.setValue(Units.toPoints((long)props.getIndent()));
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (Double)fetcher.getValue();
    }

    public void setLeftMargin(Double leftMargin) {
        CTTextParagraphProperties pr;
        if (leftMargin == null && !this._p.isSetPPr()) {
            return;
        }
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (leftMargin == null) {
            if (pr.isSetMarL()) {
                pr.unsetMarL();
            }
        } else {
            pr.setMarL(Units.toEMU((double)leftMargin));
        }
    }

    public Double getLeftMargin() {
        ParagraphPropertyFetcher<Double> fetcher = new ParagraphPropertyFetcher<Double>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetMarL()) {
                    double val = Units.toPoints((long)props.getMarL());
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (Double)fetcher.getValue();
    }

    public void setRightMargin(Double rightMargin) {
        CTTextParagraphProperties pr;
        if (rightMargin == null && !this._p.isSetPPr()) {
            return;
        }
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (rightMargin == null) {
            if (pr.isSetMarR()) {
                pr.unsetMarR();
            }
        } else {
            pr.setMarR(Units.toEMU((double)rightMargin));
        }
    }

    public Double getRightMargin() {
        ParagraphPropertyFetcher<Double> fetcher = new ParagraphPropertyFetcher<Double>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetMarR()) {
                    double val = Units.toPoints((long)props.getMarR());
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (Double)fetcher.getValue();
    }

    public Double getDefaultTabSize() {
        ParagraphPropertyFetcher<Double> fetcher = new ParagraphPropertyFetcher<Double>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetDefTabSz()) {
                    double val = Units.toPoints((long)props.getDefTabSz());
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (Double)fetcher.getValue();
    }

    public double getTabStop(final int idx) {
        ParagraphPropertyFetcher<Double> fetcher = new ParagraphPropertyFetcher<Double>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                CTTextTabStopList tabStops;
                if (props.isSetTabLst() && idx < (tabStops = props.getTabLst()).sizeOfTabArray()) {
                    CTTextTabStop ts = tabStops.getTabArray(idx);
                    double val = Units.toPoints((long)ts.getPos());
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return fetcher.getValue() == null ? 0.0 : (Double)fetcher.getValue();
    }

    public void addTabStop(double value) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextTabStopList tabStops = pr.isSetTabLst() ? pr.getTabLst() : pr.addNewTabLst();
        tabStops.addNewTab().setPos(Units.toEMU((double)value));
    }

    public void setLineSpacing(Double lineSpacing) {
        CTTextParagraphProperties pr;
        if (lineSpacing == null && !this._p.isSetPPr()) {
            return;
        }
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (lineSpacing == null) {
            if (pr.isSetLnSpc()) {
                pr.unsetLnSpc();
            }
        } else {
            CTTextSpacing spc;
            CTTextSpacing cTTextSpacing = spc = pr.isSetLnSpc() ? pr.getLnSpc() : pr.addNewLnSpc();
            if (lineSpacing >= 0.0) {
                (spc.isSetSpcPct() ? spc.getSpcPct() : spc.addNewSpcPct()).setVal((int)(lineSpacing * 1000.0));
                if (spc.isSetSpcPts()) {
                    spc.unsetSpcPts();
                }
            } else {
                (spc.isSetSpcPts() ? spc.getSpcPts() : spc.addNewSpcPts()).setVal((int)(-lineSpacing.doubleValue() * 100.0));
                if (spc.isSetSpcPct()) {
                    spc.unsetSpcPct();
                }
            }
        }
    }

    public Double getLineSpacing() {
        CTTextNormalAutofit normAutofit;
        ParagraphPropertyFetcher<Double> fetcher = new ParagraphPropertyFetcher<Double>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetLnSpc()) {
                    CTTextSpacing spc = props.getLnSpc();
                    if (spc.isSetSpcPct()) {
                        this.setValue((double)spc.getSpcPct().getVal() * 0.001);
                    } else if (spc.isSetSpcPts()) {
                        this.setValue((double)(-spc.getSpcPts().getVal()) * 0.01);
                    }
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        Double lnSpc = (Double)fetcher.getValue();
        if (lnSpc != null && lnSpc > 0.0 && (normAutofit = this.getParentShape().getTextBodyPr().getNormAutofit()) != null) {
            double scale = 1.0 - (double)normAutofit.getLnSpcReduction() / 100000.0;
            lnSpc = lnSpc * scale;
        }
        return lnSpc;
    }

    public void setSpaceBefore(Double spaceBefore) {
        if (spaceBefore == null && !this._p.isSetPPr()) {
            return;
        }
        if (spaceBefore == null) {
            if (this._p.getPPr().isSetSpcBef()) {
                this._p.getPPr().unsetSpcBef();
            }
            return;
        }
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextSpacing spc = CTTextSpacing.Factory.newInstance();
        if (spaceBefore >= 0.0) {
            spc.addNewSpcPct().setVal((int)(spaceBefore * 1000.0));
        } else {
            spc.addNewSpcPts().setVal((int)(-spaceBefore.doubleValue() * 100.0));
        }
        pr.setSpcBef(spc);
    }

    public Double getSpaceBefore() {
        ParagraphPropertyFetcher<Double> fetcher = new ParagraphPropertyFetcher<Double>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetSpcBef()) {
                    CTTextSpacing spc = props.getSpcBef();
                    if (spc.isSetSpcPct()) {
                        this.setValue((double)spc.getSpcPct().getVal() * 0.001);
                    } else if (spc.isSetSpcPts()) {
                        this.setValue((double)(-spc.getSpcPts().getVal()) * 0.01);
                    }
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (Double)fetcher.getValue();
    }

    public void setSpaceAfter(Double spaceAfter) {
        if (spaceAfter == null && !this._p.isSetPPr()) {
            return;
        }
        if (spaceAfter == null) {
            if (this._p.getPPr().isSetSpcAft()) {
                this._p.getPPr().unsetSpcAft();
            }
            return;
        }
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextSpacing spc = CTTextSpacing.Factory.newInstance();
        if (spaceAfter >= 0.0) {
            spc.addNewSpcPct().setVal((int)(spaceAfter * 1000.0));
        } else {
            spc.addNewSpcPts().setVal((int)(-spaceAfter.doubleValue() * 100.0));
        }
        pr.setSpcAft(spc);
    }

    public Double getSpaceAfter() {
        ParagraphPropertyFetcher<Double> fetcher = new ParagraphPropertyFetcher<Double>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetSpcAft()) {
                    CTTextSpacing spc = props.getSpcAft();
                    if (spc.isSetSpcPct()) {
                        this.setValue((double)spc.getSpcPct().getVal() * 0.001);
                    } else if (spc.isSetSpcPts()) {
                        this.setValue((double)(-spc.getSpcPts().getVal()) * 0.01);
                    }
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return (Double)fetcher.getValue();
    }

    public void setIndentLevel(int level) {
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        pr.setLvl(level);
    }

    public int getIndentLevel() {
        CTTextParagraphProperties pr = this._p.getPPr();
        return pr == null || !pr.isSetLvl() ? 0 : pr.getLvl();
    }

    public boolean isBullet() {
        ParagraphPropertyFetcher<Boolean> fetcher = new ParagraphPropertyFetcher<Boolean>(this.getIndentLevel()){

            @Override
            public boolean fetch(CTTextParagraphProperties props) {
                if (props.isSetBuNone()) {
                    this.setValue(false);
                    return true;
                }
                if (props.isSetBuFont() || props.isSetBuChar()) {
                    this.setValue(true);
                    return true;
                }
                return false;
            }
        };
        this.fetchParagraphProperty(fetcher);
        return fetcher.getValue() == null ? false : (Boolean)fetcher.getValue();
    }

    public void setBullet(boolean flag) {
        CTTextParagraphProperties pr;
        if (this.isBullet() == flag) {
            return;
        }
        CTTextParagraphProperties cTTextParagraphProperties = pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        if (flag) {
            pr.addNewBuFont().setTypeface("Arial");
            pr.addNewBuChar().setChar("\u2022");
        } else {
            if (pr.isSetBuFont()) {
                pr.unsetBuFont();
            }
            if (pr.isSetBuChar()) {
                pr.unsetBuChar();
            }
            if (pr.isSetBuAutoNum()) {
                pr.unsetBuAutoNum();
            }
            if (pr.isSetBuBlip()) {
                pr.unsetBuBlip();
            }
            if (pr.isSetBuClr()) {
                pr.unsetBuClr();
            }
            if (pr.isSetBuClrTx()) {
                pr.unsetBuClrTx();
            }
            if (pr.isSetBuFont()) {
                pr.unsetBuFont();
            }
            if (pr.isSetBuFontTx()) {
                pr.unsetBuFontTx();
            }
            if (pr.isSetBuSzPct()) {
                pr.unsetBuSzPct();
            }
            if (pr.isSetBuSzPts()) {
                pr.unsetBuSzPts();
            }
            if (pr.isSetBuSzTx()) {
                pr.unsetBuSzTx();
            }
            pr.addNewBuNone();
        }
    }

    public void setBulletAutoNumber(AutoNumberingScheme scheme, int startAt) {
        if (startAt < 1) {
            throw new IllegalArgumentException("Start Number must be greater or equal that 1");
        }
        CTTextParagraphProperties pr = this._p.isSetPPr() ? this._p.getPPr() : this._p.addNewPPr();
        CTTextAutonumberBullet lst = pr.isSetBuAutoNum() ? pr.getBuAutoNum() : pr.addNewBuAutoNum();
        lst.setType(STTextAutonumberScheme.Enum.forInt((int)scheme.ooxmlId));
        lst.setStartAt(startAt);
    }

    public String toString() {
        return "[" + this.getClass() + "]" + this.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CTTextParagraphProperties getDefaultMasterStyle() {
        XSLFSheet masterSheet;
        String defaultStyleSelector;
        CTPlaceholder ph = this._shape.getCTPlaceholder();
        switch (ph == null ? -1 : ph.getType().intValue()) {
            case 1: 
            case 3: {
                defaultStyleSelector = "titleStyle";
                break;
            }
            case -1: 
            case 5: 
            case 6: 
            case 7: {
                defaultStyleSelector = "otherStyle";
                break;
            }
            default: {
                defaultStyleSelector = "bodyStyle";
            }
        }
        int level = this.getIndentLevel();
        String nsPML = "http://schemas.openxmlformats.org/presentationml/2006/main";
        String nsDML = "http://schemas.openxmlformats.org/drawingml/2006/main";
        for (XSLFSheet m = masterSheet = this._shape.getSheet(); m != null; m = (XSLFSheet)m.getMasterSheet()) {
            masterSheet = m;
            XmlObject xo = masterSheet.getXmlObject();
            XmlCursor cur = xo.newCursor();
            try {
                cur.push();
                if ((!cur.toChild("http://schemas.openxmlformats.org/presentationml/2006/main", "txStyles") || !cur.toChild("http://schemas.openxmlformats.org/presentationml/2006/main", defaultStyleSelector)) && (!cur.pop() || !cur.toChild("http://schemas.openxmlformats.org/presentationml/2006/main", "notesStyle"))) continue;
                while (level >= 0) {
                    cur.push();
                    if (cur.toChild("http://schemas.openxmlformats.org/drawingml/2006/main", "lvl" + (level + 1) + "pPr")) {
                        CTTextParagraphProperties cTTextParagraphProperties = (CTTextParagraphProperties)cur.getObject();
                        return cTTextParagraphProperties;
                    }
                    cur.pop();
                    --level;
                }
                continue;
            }
            finally {
                cur.dispose();
            }
        }
        return null;
    }

    private <T> boolean fetchParagraphProperty(ParagraphPropertyFetcher<T> visitor) {
        XMLSlideShow ppt;
        CTTextParagraphProperties themeProps;
        boolean ok = false;
        XSLFTextShape shape = this.getParentShape();
        XSLFSheet sheet = shape.getSheet();
        if (this._p.isSetPPr()) {
            ok = visitor.fetch(this._p.getPPr());
        }
        if (ok) {
            return true;
        }
        ok = shape.fetchShapeProperty(visitor);
        if (ok) {
            return true;
        }
        CTPlaceholder ph = shape.getCTPlaceholder();
        if (ph == null && (themeProps = (ppt = sheet.getSlideShow()).getDefaultParagraphStyle(this.getIndentLevel())) != null) {
            ok = visitor.fetch(themeProps);
        }
        if (ok) {
            return true;
        }
        CTTextParagraphProperties defaultProps = this.getDefaultMasterStyle();
        if (defaultProps != null) {
            ok = visitor.fetch(defaultProps);
        }
        return ok;
    }

    void copy(XSLFTextParagraph other) {
        Double lineSpacing;
        Double spaceBefore;
        Double spaceAfter;
        Double indent;
        Double leftMargin;
        boolean isBullet;
        int i;
        if (other == this) {
            return;
        }
        CTTextParagraph thisP = this.getXmlObject();
        CTTextParagraph otherP = other.getXmlObject();
        if (thisP.isSetPPr()) {
            thisP.unsetPPr();
        }
        if (thisP.isSetEndParaRPr()) {
            thisP.unsetEndParaRPr();
        }
        this._runs.clear();
        for (i = thisP.sizeOfBrArray(); i > 0; --i) {
            thisP.removeBr(i - 1);
        }
        for (i = thisP.sizeOfRArray(); i > 0; --i) {
            thisP.removeR(i - 1);
        }
        for (i = thisP.sizeOfFldArray(); i > 0; --i) {
            thisP.removeFld(i - 1);
        }
        XmlCursor thisC = thisP.newCursor();
        thisC.toEndToken();
        XmlCursor otherC = otherP.newCursor();
        otherC.copyXmlContents(thisC);
        otherC.dispose();
        thisC.dispose();
        List<XSLFTextRun> otherRs = other.getTextRuns();
        int i2 = 0;
        for (CTRegularTextRun rtr : thisP.getRArray()) {
            XSLFTextRun run = this.newTextRun(rtr);
            run.copy(otherRs.get(i2++));
            this._runs.add(run);
        }
        TextParagraph.TextAlign srcAlign = other.getTextAlign();
        if (srcAlign != this.getTextAlign()) {
            this.setTextAlign(srcAlign);
        }
        if ((isBullet = other.isBullet()) != this.isBullet()) {
            this.setBullet(isBullet);
            if (isBullet) {
                Double buSize;
                PaintStyle buColor;
                String buChar;
                String buFont = other.getBulletFont();
                if (buFont != null && !buFont.equals(this.getBulletFont())) {
                    this.setBulletFont(buFont);
                }
                if ((buChar = other.getBulletCharacter()) != null && !buChar.equals(this.getBulletCharacter())) {
                    this.setBulletCharacter(buChar);
                }
                if ((buColor = other.getBulletFontColor()) != null && !buColor.equals(this.getBulletFontColor())) {
                    this.setBulletFontColor(buColor);
                }
                if (!XSLFTextParagraph.doubleEquals(buSize = other.getBulletFontSize(), this.getBulletFontSize())) {
                    this.setBulletFontSize(buSize);
                }
            }
        }
        if (!XSLFTextParagraph.doubleEquals(leftMargin = other.getLeftMargin(), this.getLeftMargin())) {
            this.setLeftMargin(leftMargin);
        }
        if (!XSLFTextParagraph.doubleEquals(indent = other.getIndent(), this.getIndent())) {
            this.setIndent(indent);
        }
        if (!XSLFTextParagraph.doubleEquals(spaceAfter = other.getSpaceAfter(), this.getSpaceAfter())) {
            this.setSpaceAfter(spaceAfter);
        }
        if (!XSLFTextParagraph.doubleEquals(spaceBefore = other.getSpaceBefore(), this.getSpaceBefore())) {
            this.setSpaceBefore(spaceBefore);
        }
        if (!XSLFTextParagraph.doubleEquals(lineSpacing = other.getLineSpacing(), this.getLineSpacing())) {
            this.setLineSpacing(lineSpacing);
        }
    }

    private static boolean doubleEquals(Double d1, Double d2) {
        return d1 == d2 || d1 != null && d1.equals(d2);
    }

    public Double getDefaultFontSize() {
        CTTextCharacterProperties endPr = this._p.getEndParaRPr();
        if (endPr == null || !endPr.isSetSz()) {
            endPr = this.getDefaultMasterStyle().getDefRPr();
        }
        return endPr == null || !endPr.isSetSz() ? 12.0 : (double)endPr.getSz() / 100.0;
    }

    public String getDefaultFontFamily() {
        return this._runs.isEmpty() ? "Arial" : this._runs.get(0).getFontFamily();
    }

    public TextParagraph.BulletStyle getBulletStyle() {
        if (!this.isBullet()) {
            return null;
        }
        return new TextParagraph.BulletStyle(){

            public String getBulletCharacter() {
                return XSLFTextParagraph.this.getBulletCharacter();
            }

            public String getBulletFont() {
                return XSLFTextParagraph.this.getBulletFont();
            }

            public Double getBulletFontSize() {
                return XSLFTextParagraph.this.getBulletFontSize();
            }

            public PaintStyle getBulletFontColor() {
                return XSLFTextParagraph.this.getBulletFontColor();
            }

            public void setBulletFontColor(Color color) {
                this.setBulletFontColor((PaintStyle)DrawPaint.createSolidPaint((Color)color));
            }

            public void setBulletFontColor(PaintStyle color) {
                XSLFTextParagraph.this.setBulletFontColor(color);
            }

            public AutoNumberingScheme getAutoNumberingScheme() {
                return XSLFTextParagraph.this.getAutoNumberingScheme();
            }

            public Integer getAutoNumberingStartAt() {
                return XSLFTextParagraph.this.getAutoNumberingStartAt();
            }
        };
    }

    public void setBulletStyle(Object ... styles) {
        if (styles.length == 0) {
            this.setBullet(false);
        } else {
            this.setBullet(true);
            for (Object ostyle : styles) {
                if (ostyle instanceof Number) {
                    this.setBulletFontSize(((Number)ostyle).doubleValue());
                    continue;
                }
                if (ostyle instanceof Color) {
                    this.setBulletFontColor((Color)ostyle);
                    continue;
                }
                if (ostyle instanceof Character) {
                    this.setBulletCharacter(ostyle.toString());
                    continue;
                }
                if (ostyle instanceof String) {
                    this.setBulletFont((String)ostyle);
                    continue;
                }
                if (!(ostyle instanceof AutoNumberingScheme)) continue;
                this.setBulletAutoNumber((AutoNumberingScheme)ostyle, 0);
            }
        }
    }

    void clearButKeepProperties() {
        int i;
        CTTextParagraph thisP = this.getXmlObject();
        for (i = thisP.sizeOfBrArray(); i > 0; --i) {
            thisP.removeBr(i - 1);
        }
        for (i = thisP.sizeOfFldArray(); i > 0; --i) {
            thisP.removeFld(i - 1);
        }
        if (!this._runs.isEmpty()) {
            int size = this._runs.size();
            XSLFTextRun lastRun = this._runs.get(size - 1);
            CTTextCharacterProperties cpOther = lastRun.getRPr(false);
            if (cpOther != null) {
                if (thisP.isSetEndParaRPr()) {
                    thisP.unsetEndParaRPr();
                }
                CTTextCharacterProperties cp = thisP.addNewEndParaRPr();
                cp.set((XmlObject)cpOther);
            }
            for (int i2 = size; i2 > 0; --i2) {
                thisP.removeR(i2 - 1);
            }
            this._runs.clear();
        }
    }

    public boolean isHeaderOrFooter() {
        CTPlaceholder ph = this._shape.getCTPlaceholder();
        int phId = ph == null ? -1 : ph.getType().intValue();
        switch (phId) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    protected XSLFTextRun newTextRun(CTRegularTextRun r) {
        return new XSLFTextRun(r, this);
    }
}

