/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigoee.tech.bootsupport.web.enhancements.resver.impl;

import com.bokesoft.yigoee.tech.bootsupport.web.enhancements.resver.intf.IStaticResourceVersionContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticUrlVersionUtils {
    private static final Logger log = LoggerFactory.getLogger(StaticUrlVersionUtils.class);

    public static String process(String rawContent, IStaticResourceVersionContext context) throws IOException {
        return StaticUrlVersionUtils.processContent(rawContent, context, new Stack<String>(), new AtomicInteger(0));
    }

    protected static String processContent(String rawContent, IStaticResourceVersionContext context, Stack<String> refStack, AtomicInteger traceIdBuilder) throws IOException {
        if (StringUtils.isBlank((CharSequence)rawContent)) {
            return rawContent;
        }
        List<String> references = StaticUrlVersionUtils.getReferences(rawContent);
        if (references == null || references.size() == 0) {
            return rawContent;
        }
        HashMap<String, String> versions = new HashMap<String, String>();
        int parentTraceId = traceIdBuilder.intValue();
        for (String url : references) {
            int childTraceId = traceIdBuilder.incrementAndGet();
            String version = StaticUrlVersionUtils.processVersion(url, context, refStack, traceIdBuilder);
            if (context instanceof IStaticResourceVersionContext.Traceable) {
                IStaticResourceVersionContext.Traceable tracer = (IStaticResourceVersionContext.Traceable)((Object)context);
                tracer.appendChild(parentTraceId, childTraceId);
            }
            if (StringUtils.isBlank((CharSequence)version)) continue;
            versions.put(url, version);
        }
        String contentProcessed = StaticUrlVersionUtils.processResult(rawContent, versions);
        return contentProcessed;
    }

    protected static List<String> getReferences(String content) {
        Pattern URL_PATTERN = Pattern.compile("\"[^ \\f\\n\\r\\t\\v\"'*]+\\.(js|css|less)\"");
        Matcher matcher = URL_PATTERN.matcher(content);
        ArrayList<String> result = new ArrayList<String>();
        while (matcher.find()) {
            String matchItem = matcher.group();
            String url = matchItem.substring(1, matchItem.length() - 1);
            if (result.contains(url)) continue;
            result.add(url);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String processVersion(String url, IStaticResourceVersionContext context, Stack<String> refStack, AtomicInteger traceIdBuilder) {
        String ver;
        String filename = StaticUrlVersionUtils.getFilename(url);
        if (filename == null || filename.trim().length() == 0) {
            return null;
        }
        int traceId = traceIdBuilder.intValue();
        IStaticResourceVersionContext.Traceable tracer = null;
        if (context instanceof IStaticResourceVersionContext.Traceable) {
            tracer = (IStaticResourceVersionContext.Traceable)((Object)context);
            tracer.nodeCreated(traceId, filename);
        }
        if (StringUtils.isNotBlank((CharSequence)(ver = context.getCachedVersion(filename)))) {
            if (null != tracer) {
                tracer.versionCreated(traceId, ver);
            }
            return ver;
        }
        if (refStack.contains(filename)) {
            String dummyVer = "circular-references-" + filename;
            log.warn("Circular reference found: file={}, url={} .", (Object)filename, (Object)url);
            if (null != tracer) {
                tracer.versionCreated(traceId, dummyVer);
            }
            return dummyVer;
        }
        refStack.push(filename);
        try {
            List<String> contents = context.getContents(filename);
            if (null == contents || contents.isEmpty()) {
                if (null != tracer) {
                    tracer.updateInstanceCount(traceId, 0);
                }
                String string = null;
                return string;
            }
            if (null != tracer) {
                tracer.updateInstanceCount(traceId, contents.size());
            }
            String content = StringUtils.join(contents, (String)"\n");
            String contentProcessed = StaticUrlVersionUtils.processContent(content, context, refStack, traceIdBuilder);
            ver = DigestUtils.md5Hex((String)contentProcessed);
            log.debug("Version of '{}': {} .", (Object)url, (Object)ver);
            if (null != tracer) {
                tracer.versionCreated(traceId, ver);
            }
            context.cacheVersion(filename, ver);
            String string = ver;
            return string;
        }
        catch (IOException ex) {
            String string = (String)ExceptionUtils.rethrow((Throwable)ex);
            return string;
        }
        finally {
            refStack.pop();
        }
    }

    protected static String processResult(String rawContent, Map<String, String> versions) {
        String result = rawContent;
        for (String url : versions.keySet()) {
            String version = versions.get(url);
            String pattern = "\"" + url + "\"";
            result = result.replaceAll(pattern, "\"" + url + "?v=" + version + "\"");
        }
        return result;
    }

    private static String getFilename(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        int startPos = url.lastIndexOf("/");
        if (startPos == -1) {
            return url;
        }
        if (startPos == url.length() - 1) {
            return null;
        }
        return url.substring(startPos + 1);
    }
}

