import elmUtils from "../util/elmUtils.js";
var index = -1; // 搜索区 搜索结果中 当前选中的索引号？
var mainTree;

const searchContainer = document.createElement("div");
searchContainer.classList.add("searchContainer");
searchContainer.innerHTML =  `
        <div class='searchBox'>
            <input type='text' class='searchInput' autocomplete='off' />
            <button class='searchBtn'></button>
        </div>
        <div class='searchResult'>
            <ul></ul>
        </div>`;

var searchBox = searchContainer.querySelector(".searchBox");
searchBox.addEventListener("click", (e) => e.stopPropagation());

var searchInput = searchBox.querySelector(".searchInput");
const reloadMetaForm = function () {
    var metaFormKeys = searchInput.value;
    if (!metaFormKeys || YIUI.Utils.trim(metaFormKeys) === "") {
        return;
    }
    var list = metaFormKeys.split(",");
    for (var i = 0, len = list.length; i < len; i++) {
        YIUI.UIScopeTrees.clear(list[i]);
    }
    new YIUI.DocService()
        .reloadMetaForm(metaFormKeys)
        .then(function (result) {
            const dialog = new YIUI.Dialog({
                headerTitle: YIUI.I18N.getString(
                    "DIALOG_MESSAGE",
                    "消息"
                ),
                msg: result,
                msgType: 0,
            });
            dialog.show();
        });
};

const clearSearchResult = () => {
    searchResult.querySelector("ul").innerHTML = "";
    searchResult.classList.remove("open");
}
var searchItems = function () {
    var searchValue = searchInput.value;
    mainTree = YIUI.MainTree.mainTree;
    if (searchValue) {
        searchValue = searchValue.toLowerCase();
        var searchValues = searchValue.split(/[ ;]/g);
        var _searchResult =  mainTree._data.filter((item) => {
            var hasMatch = true;
            var fullName = item.fullName.toLowerCase();
            for (var index = 0; index < searchValues.length; index++) {
                if (
                    !(
                        item._visible &&
                        fullName.indexOf(searchValues[index]) >
                            -1 &&
                        !item.children
                    )
                ) {
                    hasMatch = false;
                    break;
                }
            }
            return hasMatch && item._visible && !item.children;
        });

        clearSearchResult();

        index = -1;
        for (var i = 0, len = _searchResult.length; i < len; i++) {
            var _li = document.createElement("li"),
                parentID = _searchResult[i].parentID,
                parentNode,
                pName = "",
                hasParent = !!parentID;
            while (parentID) {
                parentNode =  mainTree.getTreeNode(parentID);
                if (pName) {
                    pName = "/" + pName;
                }
                pName = parentNode.name + pName;

                parentID = parentNode.parentID;
            }
            if (hasParent) {
                pName = "(" + pName + ")";
            }

            var _a = document.createElement("a");
            _a.classList.add("item");
            _a.setAttribute("matchedId", _searchResult[i].id);
            _a.innerHTML = _searchResult[i].name + pName;
            _li.appendChild(_a);
            searchResult.querySelector("ul").appendChild(_li);
        }
        if (_searchResult.length > 0) {
            searchResult.classList.add("open");
            elmUtils.onceEventHandler(document, "mousedown", clearSearchResult);
        } else {
            searchResult.classList.remove("open");
        }
    } else {
        clearSearchResult();
    }
};

// 给搜索框添加一系列事件
searchInput.addEventListener("focus", searchItems);
searchInput.addEventListener("input", searchItems);
searchInput.addEventListener("keydown", e => {
    var keyCode = e.keyCode;

    var lis = searchResult.querySelectorAll("li");

    var maxLen = lis.length;

    if (maxLen == 0) return;
    if (keyCode == 38) {
        index--;
        if (index < 0) index = maxLen - 1;
    } else if (keyCode == 40) {
        index++;
        if (index == maxLen) index = 0;
    } else if (keyCode == 9 || keyCode === 13 || keyCode === 108) {
        if (keyCode == 9) {
            document.dispatchEvent(new Event("mousedown"));
        } else if (keyCode === 13) {
            var a = searchResult.querySelector("li.hover a");
            if (a) {
                a.click();
            }
            e.stopPropagation();
        }
        e.preventDefault();
    } else {
        return;
    }
    if (index < 0) return;

    var hLi = searchResult.querySelector("li.hover");
    if (hLi) {
        hLi.classList.remove("hover");
    }

    lis[index].classList.add("hover");
});

// 给搜索按钮添加事件
searchBox.querySelector(".searchBtn").addEventListener("click", e => {
    var host = window.location.host;
    if (
        host.indexOf("localhost") != -1 ||
        host.indexOf("127.0.0.1") != -1
    ) {
        reloadMetaForm();
    } else {
        searchItems();
    }
});

var searchResult = searchContainer.querySelector(".searchResult");
searchResult.addEventListener("click", e => {
    var target = e.target.closest(".item");
    e.stopPropagation();
    e.preventDefault();
    if (!target) return;
    var id = target.getAttribute("matchedId");
    var a = document.querySelector("#" + id);
    mainTree.clickEvent.selectNode.call(a,  mainTree);
    mainTree.expandNode(a);
    searchResult.classList.remove("open");
});
searchResult.addEventListener("mousedown", (e) => e.stopPropagation());
window.addEventListener("YIUI-loaded", e => {
    searchInput.setAttribute("placeholder", `${YIUI.I18N.getString("MENUTREE_INPUTKEYWORDS","请输入关键词...")}`);
});
export { searchContainer };
