/**
 * entry数据同级节点根据key合并并去重
 * @param {Object} entryData entry数据
 * @returns {Object} entryData 合并并去重后的entry数据 合并时后者覆盖前者 仅合并都有children的节点
 */
export default function mergeEntryBySameKey(entryData) {
  const nodes = entryData.children || [];
  const mergedNodes = [];
  const processedKeys = new Set();
  /**
   * 合并单个节点
   * @param node 需要被合并的节点
   */
  function mergeNode(node) {
    if (!processedKeys.has(node.key)) {
      processedKeys.add(node.key);
      let mergedNode;
      // 如果节点有子节点,递归合并子节点
      if (node.children) {
        mergedNode = {
          ...node,
          children: mergeEntryBySameKey(node).children,
        };
      } else {
        mergedNode = node;
      }
      mergedNodes.push(mergedNode);
    } else {
      const existingNode = mergedNodes.find((n) => {
        if (node.children && n.children && n.key === node.key) {
          return n;
        }
      });
      if (existingNode) {
        // 除children之外的key 后者覆盖前者
        for (let key in node) {
          key !== "children" && (existingNode[key] = node[key]);
        }
        // 如果节点有子节点,将它们与现有节点的子节点合并
        if (node.children) {
          node.children = [...existingNode.children, ...node.children];
          existingNode.children = mergeEntryBySameKey(node).children;
        }
      } else {
        let mergedNode;
        if (node.children) {
          mergedNode = {
            ...node,
            children: mergeEntryBySameKey(node).children,
          };
        } else {
          mergedNode = node;
        }
        mergedNodes.push(mergedNode);
      }
    }
  }

  nodes.forEach((node) => {
    mergeNode(node);
  });

  entryData.children = mergedNodes;
  return entryData;
}
