(() => {
    // 火狐浏览器滚动条特殊处理
    if (navigator.userAgent.toLowerCase().indexOf("firefox") > -1) {
        const style = `
            /* 此处css仅firefox能识别 */
            * {
                scrollbar-width: thin; /* 设置滚动条宽度 */
                scrollbar-color: rgba(144, 147, 153, 0.3) transparent; /* 滑块颜色和轨道颜色 */
            }
            /* 当menu维持sm状态时 tm宽度 = listBox宽度 - scrollBar宽度 */
            .mainLeft #listBox .tm {
                width: calc(100% - 8px)
            }
        `;
        const styleSheet = document.createElement("style");
        styleSheet.type = "text/css";
        styleSheet.appendChild(document.createTextNode(style));
        document.head.appendChild(styleSheet);
    }

    window.addEventListener("YIUI-loaded", e => {
        if(YIUI.AppSetting.isMobileDevice()){
            document.body.classList.add('mobile-device');
        }
        YIUI.SvrMgr.checkSession().then((data) => {
            if (!data) {
                jumpToLogin();
            } else {
                document.querySelector("#login-mask").remove();
                homeInit();
            }
        }, jumpToLogin);
    });

    var jumpToLogin = function () {
        if (YIUI.AppSetting.isDev) {
            location.href = location.origin + "/login.html" + location.search + location.hash;
        }
    };

    function homeInit() {
        var mainLeft = document.querySelector(".mainLeft");
        //侧边栏切换 sm状态
        (async function () {
            var toggleBtn = document.querySelector(".menutoggle");
            var listBox = document.querySelector("#listBox");
            toggleBtn.addEventListener("click", function (e) {
                mainLeft.classList.toggle("mainLeft-sm");
                collapse();
                const isSm = mainLeft.classList.contains("mainLeft-sm");
                if (isSm) {
                    document.addEventListener("click", collapse);
                } else {
                    document.removeEventListener("click", collapse);
                }
                window.dispatchEvent(new CustomEvent('YES-MainFrame-leftSideToggle', {
                    detail: {
                        leftSideStatus: isSm ? "sm" : "normal"
                    }
                }));
            });

            function collapse() {
                var tmAnchor = document.querySelectorAll(
                    ".tm-anchor.open.expand"
                );
                var tmWrap = document.querySelectorAll(".tm-ul-wrap");
                tmAnchor.forEach((node) => {
                    node.classList.remove("open", "expand");
                    node.classList.add("close", "collapse");
                });
                tmWrap.forEach((node) => {
                    node.style.display = "none";
                });
            }
        })();

        //移动条
        (function () {
            var minWidth = 175,
                spl = document.querySelector(".drag-spl"),
                mask;

            if(!spl) return;

            spl.addEventListener("mousedown", function () {
                mask = createMask();
                document.addEventListener("mouseup", mouseupHandle);
                document.addEventListener("mousemove", moveHandle);
            });

            function moveHandle(e) {
                var w = e.pageX <= minWidth ? minWidth : e.pageX;

                mainLeft.style.width = w + "px";
                window.dispatchEvent(new CustomEvent('YES-MainFrame-leftSideResize', {
                    detail: {
                        leftSideWidth: w
                    }
                }));
            }

            function mouseupHandle() {
                mask.remove();
                document.removeEventListener("mouseup", mouseupHandle);
                document.removeEventListener("mousemove", moveHandle);
            }
        })();
        //添加遮罩解决iframe情况下拖动卡顿
        function createMask() {
            var mask = document.createElement("div");
            mask.classList.add("mask-drag");
            document.body.appendChild(mask);
            return mask;
        }

        (function () {
            if (!!window.ActiveXObject || "ActiveXObject" in window) {
                window.onbeforeunload = function (e) {
                    console.log('home onbeforeunload');
                    var e = e || window.event;

                    var n = e.screenX - window.screenLeft;
                    var b = n > document.documentElement.scrollWidth - 20;
                    if ((b && e.clientY < 0) || e.altKey) {
                        // IE专用判断
                        logout();
                    }
                };
            } else {
                var _beforeUnload_time = 0,
                    _gap_time = 0;

                window.onbeforeunload = function () {
                    console.log('home onbeforeunload');
                    _beforeUnload_time = new Date().getTime();
                };

                window.onunload = function () {
                    _gap_time = new Date().getTime() - _beforeUnload_time;

                    if (_gap_time < 3) {
                        // Chrome判断方法,关闭时不访问服务,事件间隔很小
                        logout();
                    } else {
                        console.log("浏览器刷新...");
                    }
                };
            }

            function logout() {
                var paras = {
                    async: false,
                };
                YIUI.SvrMgr.doLogout(paras, function () {
                    YIUI.CookiesUtil.remove("clientID");
                    YIUI.CookiesUtil.remove("oldURL");
                });
            }
        })();
    }
})();
