import { h as hooks, n as nanoid, D as Decimal, a as api, p as pako, b as axios, J as JSEncrypt, C as CryptoJS, r as readSync, u as utils, c as JSZip, f as fetchEventSource } from "./vendor-e1ca6068.js";
class ArrayUtil {
  static indexOf(arr, obj) {
    for (var i2 = 0; i2 < arr.length; i2++) {
      if (arr[i2] == obj)
        return i2;
    }
    return -1;
  }
  static removeElement(arr, val) {
    var index = ArrayUtil.indexOf(arr, val);
    if (index > -1) {
      arr.splice(index, 1);
    }
  }
  static dim(dimension, initial) {
    let res = [], i2;
    for (i2 = 0; i2 < dimension; i2++) {
      res[i2] = initial;
    }
    return res;
  }
}
const _keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
const decode = function(input2) {
  var string = "";
  var i2 = 0, c = 0, c2 = 0, c3 = 0;
  while (i2 < input2.length) {
    c = input2.charCodeAt(i2);
    if (c < 128) {
      string += String.fromCharCode(c);
      i2++;
    } else if (c > 191 && c < 224) {
      c2 = input2.charCodeAt(i2 + 1);
      string += String.fromCharCode((c & 31) << 6 | c2 & 63);
      i2 += 2;
    } else {
      c2 = input2.charCodeAt(i2 + 1);
      c3 = input2.charCodeAt(i2 + 2);
      string += String.fromCharCode((c & 15) << 12 | (c2 & 63) << 6 | c3 & 63);
      i2 += 3;
    }
  }
  return string;
};
const encode = function(e) {
  e = e.replace(/rn/g, "n");
  var t = "";
  for (var n = 0; n < e.length; n++) {
    var r = e.charCodeAt(n);
    if (r < 128) {
      t += String.fromCharCode(r);
    } else if (r > 127 && r < 2048) {
      t += String.fromCharCode(r >> 6 | 192);
      t += String.fromCharCode(r & 63 | 128);
    } else {
      t += String.fromCharCode(r >> 12 | 224);
      t += String.fromCharCode(r >> 6 & 63 | 128);
      t += String.fromCharCode(r & 63 | 128);
    }
  }
  return t;
};
class Base64 {
  static encode64(input2) {
    var output = "";
    var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
    var i2 = 0;
    while (i2 < input2.length) {
      chr1 = input2[i2++];
      chr2 = input2[i2++];
      chr3 = input2[i2++];
      enc1 = chr1 >> 2;
      enc2 = (chr1 & 3) << 4 | chr2 >> 4;
      enc3 = (chr2 & 15) << 2 | chr3 >> 6;
      enc4 = chr3 & 63;
      if (isNaN(chr2)) {
        enc3 = enc4 = 64;
      } else if (isNaN(chr3)) {
        enc4 = 64;
      }
      output = output + _keyStr.charAt(enc1) + _keyStr.charAt(enc2) + _keyStr.charAt(enc3) + _keyStr.charAt(enc4);
    }
    return output;
  }
  static encode64ByStr(e) {
    var t = "";
    var n, r, i2, s, o, u, a;
    var f = 0;
    e = encode(e);
    while (f < e.length) {
      n = e.charCodeAt(f++);
      r = e.charCodeAt(f++);
      i2 = e.charCodeAt(f++);
      s = n >> 2;
      o = (n & 3) << 4 | r >> 4;
      u = (r & 15) << 2 | i2 >> 6;
      a = i2 & 63;
      if (isNaN(r)) {
        u = a = 64;
      } else if (isNaN(i2)) {
        a = 64;
      }
      t = t + _keyStr.charAt(s) + _keyStr.charAt(o) + _keyStr.charAt(u) + _keyStr.charAt(a);
    }
    return t;
  }
  static decode64ByStr(input2) {
    var output = "";
    var chr1, chr2, chr3;
    var enc1, enc2, enc3, enc4;
    var i2 = 0;
    input2 = input2.replace(/[^A-Za-z0-9\+\/\=]/g, "");
    while (i2 < input2.length) {
      enc1 = _keyStr.indexOf(input2.charAt(i2++));
      enc2 = _keyStr.indexOf(input2.charAt(i2++));
      enc3 = _keyStr.indexOf(input2.charAt(i2++));
      enc4 = _keyStr.indexOf(input2.charAt(i2++));
      chr1 = enc1 << 2 | enc2 >> 4;
      chr2 = (enc2 & 15) << 4 | enc3 >> 2;
      chr3 = (enc3 & 3) << 6 | enc4;
      output = output + String.fromCharCode(chr1);
      if (enc3 != 64) {
        output = output + String.fromCharCode(chr2);
      }
      if (enc4 != 64) {
        output = output + String.fromCharCode(chr3);
      }
    }
    return decode(output);
  }
}
const _SystemField = class _SystemField2 {
  static isSystemField(field) {
    for (var o in _SystemField2) {
      if (field && _SystemField2[o] === field)
        return true;
    }
    return false;
  }
};
_SystemField.ROWCOUNT_SUFFIX = "_RowCount";
_SystemField.OID_SYS_KEY = "OID";
_SystemField.SOID_SYS_KEY = "SOID";
_SystemField.POID_SYS_KEY = "POID";
_SystemField.VERID_SYS_KEY = "VERID";
_SystemField.DVERID_SYS_KEY = "DVERID";
_SystemField.NO_SYS_KEY = "NO";
_SystemField.STATUS_SYS_KEY = "Status";
_SystemField.MAPCOUNT_SYS_KEY = "MapCount";
_SystemField.SELECT_FIELD_KEY = "SelectField";
_SystemField.SEQUENCE_FIELD_KEY = "Sequence";
_SystemField.LANG_SYS_KEY = "Lang";
_SystemField.SrcLangOID_SYS_KEY = "SrcLangOID";
_SystemField.PATH = "Path";
_SystemField.NAME = "Name";
_SystemField.UPLOAD_TIME = "UploadTime";
_SystemField.UPLOAD_OPERATOR = "UploadOperator";
let SystemField = _SystemField;
class DataType {
}
DataType.INT = 1001;
DataType.STR_INT = "Integer";
DataType.STRING = 1002;
DataType.STR_STRING = "Varchar";
DataType.DATE = 1003;
DataType.STR_DATE = "Date";
DataType.DATETIME = 1004;
DataType.STR_DATETIME = "DateTime";
DataType.NUMERIC = 1005;
DataType.STR_NUMERIC = "Numeric";
DataType.DOUBLE = 1006;
DataType.STR_DOUBLE = "Double";
DataType.FLOAT = 1007;
DataType.STR_FLOAT = "Float";
DataType.BINARY = 1008;
DataType.STR_BINARY = "Binary";
DataType.BOOLEAN = 1009;
DataType.STR_BOOLEAN = "Boolean";
DataType.LONG = 1010;
DataType.STR_LONG = "Long";
DataType.TEXT = 1011;
DataType.STR_TEXT = "Text";
DataType.FIXED_STRING = 1012;
DataType.STR_FIXED_STRING = "Char";
const SHORT_FORMAT = "YYYY-MM-DD";
const LONG_FORMAT = "YYYY-MM-DD HH:mm:ss";
const YEARS_FORMAT = "YYYY-MM";
class DefaultMask {
  format(text, onlyDate) {
    let str = "";
    if (text) {
      let len = text.length;
      let m;
      if (len == 14) {
        m = hooks(text, "YYYYMMDDHHmmss");
      } else if (len == 18) {
        m = hooks(text, "YYYY-MM-DDHH:mm:ss");
      } else if (len == 17) {
        if (text.indexOf(":") < 0) {
          m = hooks(text, "YYYY-MM-DD HHmmss");
        } else {
          m = hooks(text, "YYYYMMDD HH:mm:ss");
        }
      } else if (len == 16) {
        if (text.indexOf(":") < 0) {
          m = hooks(text, "YYYY-MM-DDHHmmss");
        } else {
          m = hooks(text, "YYYYMMDDHH:mm:ss");
        }
      } else {
        m = hooks(text);
      }
      if (!m.isValid()) {
        console.error("error date:" + text);
        m = hooks();
      }
      let fmt = onlyDate ? SHORT_FORMAT : LONG_FORMAT;
      str = m.format(fmt);
    }
    return str;
  }
  convertToUpper(format) {
    return format.replace(/[yd]/g, function(match) {
      return match.toUpperCase();
    });
  }
  dateFormat(date, fmt) {
    fmt = this.convertToUpper(fmt);
    let m = hooks(date, fmt);
    return m.format(fmt);
  }
  yearsFormat(text) {
    let str = "";
    if (text) {
      let m = hooks(text);
      let fmt = YEARS_FORMAT;
      if (!m.isValid())
        m = hooks();
      str = m.format(fmt);
    }
    return str;
  }
  parse(text, format) {
    format = this.convertToUpper(format);
    return hooks(text, format).toDate();
  }
}
class DateTimeMaskFactory {
  static setInstance(i2) {
    this.instance = i2;
  }
  static format(text, onlyDate) {
    return this.instance.format(text, onlyDate);
  }
  static dateFormat(date, fmt) {
    return this.instance.dateFormat(date, fmt);
  }
  static yearsFormat(text) {
    return this.instance.yearsFormat(text);
  }
  static parse(text, fmt) {
    return this.instance.parse(text, fmt);
  }
}
DateTimeMaskFactory.instance = new DefaultMask();
const _Utils = class _Utils2 {
  static isNumeric(obj) {
    var type;
    if (obj == null) {
      type = obj + "";
    } else {
      type = typeof obj;
    }
    return (type === "number" || type === "string") && // parseFloat NaNs numeric-cast false positives ("")
    // ...but misinterprets leading-number strings, particularly hex literals ("0x...")
    // subtraction forces infinities to NaN
    !isNaN(obj - parseFloat(obj));
  }
  static each(obj, callback) {
    var length2, i2 = 0;
    if (_Utils2.isArray(obj)) {
      length2 = obj.length;
      for (; i2 < length2; i2++) {
        if (callback.call(obj[i2], i2, obj[i2]) === false) {
          break;
        }
      }
    } else {
      for (let i22 in obj) {
        if (callback.call(obj[i22], i22, obj[i22]) === false) {
          break;
        }
      }
    }
    return obj;
  }
  static trim(str) {
    return str.trim();
  }
  static isPercentage(v) {
    return v && /^(\d{1,2}%)$|^(100%)$/.test(v);
  }
  static isDefined(v) {
    return typeof v !== "undefined";
  }
  static isUndefined(v) {
    return typeof v === "undefined";
  }
  static isObject(v) {
    return v && typeof v === "object";
  }
  static isArray(v) {
    return Array.isArray(v);
  }
  static inArray(elem, arr, i2) {
    return arr == null ? -1 : ArrayUtil.indexOf(arr, elem);
  }
  static isBoolean(o) {
    return typeof o === "boolean";
  }
  static isString(v) {
    return v && typeof v == "string";
  }
  static isEmptyObject(obj) {
    var name2;
    for (name2 in obj) {
      return false;
    }
    return true;
  }
  /**
   * 获取真实高度、宽度等值。
   * @param value 可能形如：10、'10px'、'10%'、其他。
   * @param parentValue Number类型。父节点的高度、宽度等值。
   * @return 如果算出真实值，返回Number类型值；否则，返回'auto'。
   */
  static getReal(value, parentValue) {
    if (!_Utils2.isDefined(value) || value == null || value <= 0 || value == "pref")
      return "auto";
    var real;
    if (_Utils2.isNumeric(value) && value > 1) {
      real = value;
    } else if (_Utils2.isNumeric(value) && value <= 1) {
      var percent = parseFloat(value);
      real = parentValue * percent;
    } else if (_Utils2.isPercentage(value)) {
      var percent = parseFloat(value) / 100;
      real = parentValue * percent;
    } else {
      real = parseInt(value, 10);
    }
    return Math.floor(real);
  }
  static htmlEncode(value) {
    return !value ? value : String(value).replace(/&/g, "&amp;").replace(/\"/g, "&quot;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
  }
  /**
   * 过滤固定长度的单位
   */
  static getSize(size2) {
    var v = size2;
    if (_Utils2.isPercentage(size2))
      ;
    else if (_Utils2.isNumeric(size2))
      ;
    else if (size2 == "auto")
      ;
    else if (size2 == "pref")
      ;
    else {
      v = parseInt(size2);
    }
    return v;
  }
  // 实现多继承
  static mix(...mixins) {
    function copyProperties(target, source) {
      for (let key of Reflect.ownKeys(source)) {
        if (key !== "constructor" && key !== "prototype" && key !== "name") {
          let desc = Object.getOwnPropertyDescriptor(source, key);
          Object.defineProperty(target, key, desc || {});
        }
      }
    }
    class Mix {
    }
    for (let mixin of mixins) {
      copyProperties(Mix, mixin);
      copyProperties(Mix.prototype, mixin.prototype);
    }
    return Mix;
  }
  static getCookie(cookieName) {
    var strCookie = document.cookie;
    var arrCookie = strCookie.split("; ");
    for (var i2 = 0; i2 < arrCookie.length; i2++) {
      var arr = arrCookie[i2].split("=");
      if (cookieName == arr[0]) {
        return arr[1];
      }
    }
    return "";
  }
  static setCookie(name2, value) {
    document.cookie = name2 + "=" + value;
  }
  static format(format, args) {
    var isLetterOrDigit = function(c) {
      if (_Utils2.isNumeric(c))
        return true;
      if (c.charCodeAt() > 65 && c.charCodeAt() < 90 || c.charCodeAt() > 97 && c.charCodeAt() < 122)
        return true;
    };
    var split = function(format2) {
      var v2 = new Array();
      if (format2 == null) {
        return v2;
      }
      var length2 = format2.length;
      var l_i = 0;
      var i22 = 0;
      while (i22 < length2) {
        var c = format2.charAt(i22);
        if (c == "{") {
          var s_b = i22;
          var s_e = -1;
          ++i22;
          if (i22 < length2) {
            c = format2.charAt(i22);
            if (isLetterOrDigit(c)) {
              while ((isLetterOrDigit(c) || c == "_") && i22 < length2) {
                ++i22;
                c = format2.charAt(i22);
              }
              if (i22 < length2) {
                if (c == "}") {
                  s_e = i22;
                }
                ++i22;
              }
            } else {
              ++i22;
            }
          }
          if (s_e != -1) {
            if (l_i < s_b) {
              v2.push(format2.substring(l_i, s_b));
            }
            var s = format2.substring(s_b + 1, s_e);
            var p2 = { tag: s };
            v2.push(p2);
            l_i = s_e + 1;
          }
        } else {
          ++i22;
        }
      }
      if (l_i < i22) {
        v2.push(format2.substring(l_i));
      }
      return v2;
    };
    var v = split(format);
    var temp = new Array();
    var index = 1;
    for (var i2 = 0, len = v.length; i2 < len; i2++) {
      var obj = v[i2];
      if (typeof obj == "object") {
        index = parseInt(obj.tag) - 1;
        if (index < args.length) {
          temp.push(args[index]);
        }
      } else {
        temp.push(obj);
      }
    }
    var result = temp.join("");
    return result;
  }
  //使用递归的方式实现数组、对象的深拷贝
  static deepClone(obj) {
    var objClone = Array.isArray(obj) ? [] : {};
    if (obj && typeof obj === "object") {
      for (let key in obj) {
        if (obj.hasOwnProperty(key)) {
          if (obj[key] && typeof obj[key] === "object") {
            objClone[key] = this.deepClone(obj[key]);
          } else {
            objClone[key] = obj[key];
          }
        }
      }
    }
    return objClone;
  }
  static getZindex(elem) {
    var position, value;
    while (elem.length && elem[0] !== document) {
      position = getComputedStyle(elem)["position"];
      if (position === "absolute" || position === "relative" || position === "fixed") {
        value = parseInt(getComputedStyle(elem)["zIndex"], 10);
        if (!isNaN(value) && value !== 0) {
          return value;
        }
      }
      elem = elem.parentNode;
    }
    return 0;
  }
  static splitStr(obj, key, className) {
    var str = obj[key];
    if (str) {
      obj[key] = str + className;
    } else {
      obj[key] = className;
    }
  }
  static guid() {
    return nanoid().replace(/l/g, "L").replace(/0/g, "O");
  }
  static isBase64Image(url) {
    var regex = /^data:image\/[a-z]+;base64,/;
    return regex.test(url);
  }
  static getTimeFormat(second) {
    return second ? "HH:mm:ss" : "HH:mm";
  }
  static getMonthFormat() {
    return "yyyy-MM";
  }
  /**
   * 在树形数据结构 TreeNode 中,找到符合条件的节点数据
  */
  static findMatchingNodes(treeData, matchFn) {
    let result = [];
    const traverse = (node) => {
      if (matchFn(node)) {
        result.push(node);
      }
      if (node.children) {
        for (let child of node.children) {
          traverse(child);
        }
      }
    };
    treeData && traverse(treeData);
    return result;
  }
};
_Utils.dateFormat = function(date, fmt) {
  return DateTimeMaskFactory.dateFormat(date, fmt);
};
_Utils.parse = function(date, fmt) {
  return DateTimeMaskFactory.parse(date, fmt);
};
let Utils = _Utils;
class ItemData {
  constructor(options2) {
    this.oid = 0;
    this.itemKey = "";
    this.dataElementKey = "";
    this.code = "";
    this.name = "";
    this.editValue = "";
    this.useCode = "";
    this.fromJSON(options2);
  }
  getOID() {
    return this.oid;
  }
  getItemKey() {
    return this.itemKey;
  }
  hasCaption() {
    return "caption" in this;
  }
  getCaption() {
    return this.caption;
  }
  getCode() {
    return this.code;
  }
  getUseCode() {
    return this.useCode;
  }
  getName() {
    return this.name;
  }
  getEditValue() {
    return this.editValue;
  }
  equals(o) {
    if (o == null) {
      return false;
    }
    return this.toString() == o.toString();
  }
  toString() {
    return this.itemKey + "_" + this.oid;
  }
  toJSON() {
    var jsonObj = {
      oid: this.oid,
      itemKey: this.itemKey,
      dataElementKey: this.dataElementKey,
      code: this.code,
      name: this.name,
      editValue: this.editValue,
      useCode: this.useCode,
      caption: this.caption
    };
    return jsonObj;
  }
  fromJSON(jsonObj) {
    if (jsonObj.oid) {
      this.oid = jsonObj.oid;
    }
    if (jsonObj.itemKey) {
      this.itemKey = jsonObj.itemKey;
    }
    if (jsonObj.dataElementKey) {
      this.dataElementKey = jsonObj.dataElementKey;
    }
    if (jsonObj.caption) {
      this.caption = jsonObj.caption;
    }
    if (jsonObj.Code) {
      this.code = jsonObj.Code;
    }
    if (jsonObj.Name) {
      this.name = jsonObj.Name;
    }
    if (jsonObj.editValue) {
      this.editValue = jsonObj.editValue;
    }
    if (jsonObj.UseCode) {
      this.useCode = jsonObj.UseCode;
    }
    if (jsonObj.AttributeType) {
      this.attributeType = jsonObj.AttributeType;
    }
  }
  clone() {
    return new ItemData({
      oid: this.oid,
      itemKey: this.itemKey,
      dataElementKey: this.dataElementKey,
      code: this.code,
      name: this.name,
      editValue: this.editValue,
      useCode: this.useCode,
      caption: this.caption
    });
  }
}
const toString$2 = (v) => {
  return v != null ? v.toString() : "";
};
const toInt = (v) => {
  var r;
  if (v == null || v == "") {
    r = 0;
  } else if (Utils.isNumeric(v)) {
    r = parseInt(v);
  } else if (typeof v == "boolean") {
    r = v ? 1 : 0;
  } else if (v instanceof Decimal) {
    if (v.toString().length > 9) {
      r = v;
    } else {
      r = parseInt(v.toString());
    }
  } else if (typeof v == "string") {
    if (v.length == 0 || v.toLowerCase() == "false") {
      r = 0;
    } else if (v.toLowerCase() == "true") {
      r = 1;
    } else {
      throw Error("For input string: " + v);
    }
  }
  return r;
};
const toFloat = (v) => {
  var r;
  if (v == null || v == "") {
    r = 0;
  } else if (Utils.isNumeric(v)) {
    r = parseFloat(v);
  } else if (typeof v == "boolean") {
    r = v ? 1 : 0;
  } else if (v instanceof Decimal) {
    if (v.toString().length > 9) {
      r = v;
    } else {
      r = parseFloat(v.toString());
    }
  } else if (typeof v == "string") {
    if (v.length == 0 || v.toLowerCase() == "false") {
      r = 0;
    } else if (v.toLowerCase() == "true") {
      r = 1;
    } else {
      throw Error("For input string: " + v);
    }
  }
  return r;
};
const toLong = (v) => {
  var r;
  if (v == null || v == "") {
    r = 0;
  } else if (v instanceof Date) {
    r = v.getTime();
  } else if (Utils.isNumeric(v)) {
    r = parseInt(v);
  } else if (typeof v == "boolean") {
    r = v ? 1 : 0;
  } else if (v instanceof Decimal) {
    if (v.toString().length > 16) {
      r = v;
    } else {
      r = parseInt(v.toString());
    }
  } else if (typeof v == "string") {
    if (v.length == 0 || v.toLowerCase() == "false") {
      r = 0;
    } else if (v.toLowerCase() == "true") {
      r = 1;
    } else {
      throw Error("For input string: " + v);
    }
  }
  return r;
};
const toDecimal = (v) => {
  var r;
  if (v == null) {
    r = new Decimal(0);
  } else if (typeof v === "number") {
    r = new Decimal(v);
  } else if (Utils.isNumeric(v)) {
    r = new Decimal(v);
  } else if (typeof v == "boolean") {
    r = new Decimal(v ? 1 : 0);
  } else if (Decimal.isDecimal(v)) {
    r = v;
  } else if (typeof v == "string") {
    var isNum = !isNaN(Number(v));
    if (v != "" && !isNum) {
      r = v == "" ? new Decimal(0) : isNum ? new Decimal(v) : new Decimal(0);
    }
    r = v == "" ? new Decimal(0) : isNum ? new Decimal(v) : new Decimal(0);
  }
  return r;
};
const toBoolean = (v) => {
  var bl = false;
  if (v != null) {
    if (typeof v == "boolean") {
      bl = v;
    } else if (typeof v == "string") {
      if (v.toLowerCase() == "true") {
        bl = true;
      } else if (v.toLowerCase() == "false" || v == "0") {
        bl = false;
      } else {
        bl = v.length != 0;
      }
    } else if (v instanceof Decimal) {
      bl = Boolean(v.toNumber());
    } else {
      bl = Boolean(v);
    }
  }
  return bl;
};
const toDate = (v) => {
  var d = null;
  if (v != null) {
    if (v instanceof Date) {
      d = v;
    } else if (Utils.isNumeric(v)) {
      d = new Date(parseFloat(v));
    } else if (typeof v == "string") {
      v = v.replace(/-/g, "/");
      if (v.length > 0) {
        d = new Date(v);
      }
    }
  }
  return d;
};
const toDataType = (dataType, val) => {
  switch (dataType) {
    case DataType.INT:
      return toInt(val);
    case DataType.LONG:
      return toLong(val);
    case DataType.STRING:
      return toString$2(val);
    case DataType.DATE:
    case DataType.DATETIME:
      return toDate(val);
    case DataType.NUMERIC:
      return toDecimal(val);
    case DataType.BOOLEAN:
      return toBoolean(val);
  }
  return val;
};
const toSafeDataType = (dataType, val) => {
  switch (dataType) {
    case DataType.INT:
      return toInt(val);
    case DataType.LONG:
      if (val instanceof ItemData) {
        return toLong(val.getOID());
      }
      return toLong(val);
    case DataType.STRING:
      if (val instanceof ItemData) {
        return toString$2(val.getOID());
      } else if (Utils.isArray(val) && val.length > 0 && val[0] instanceof ItemData) {
        const result = [];
        for (let index = 0; index < val.length; index++) {
          const itemData = val[index];
          result.push(itemData.getOID());
        }
        return result.join(",");
      }
      return toString$2(val);
    case DataType.DATE:
    case DataType.DATETIME:
      return toDate(val);
    case DataType.NUMERIC:
      return toDecimal(val);
    case DataType.BOOLEAN:
      return toBoolean(val);
    case DataType.TEXT:
      return toString$2(val);
  }
  return val;
};
const TypeConvertor = {
  toString: toString$2,
  toInt,
  toFloat,
  toLong,
  toDecimal,
  toBoolean,
  toDate,
  toDataType,
  toSafeDataType
};
class BatchUtil {
  // 获取叙事簿选中行的OID
  static getViewSelectOIDs(viewForm, defaultValue) {
    var mTblKey = viewForm.mainTableKey, listView, grid;
    var OIDFieldKey = SystemField.OID_SYS_KEY;
    if (mTblKey) {
      listView = viewForm.getListView(mTblKey);
    } else {
      listView = viewForm.getListView(0);
    }
    if (listView) {
      return BatchUtil.getSelectOIDs(viewForm, listView.tableKey, OIDFieldKey, defaultValue);
    }
    if (mTblKey) {
      grid = viewForm.getGrid(mTblKey);
    } else {
      grid = viewForm.getGrid(0);
    }
    if (grid) {
      return BatchUtil.getSelectOIDs(viewForm, grid.tableKey, OIDFieldKey, defaultValue);
    }
    return [];
  }
  // 从数据源中取得选中行的OID,defaultValue指无选择字段时,是否默认选中
  static getSelectOIDs(form, tblKey, oidKey, defaultValue) {
    var oids = [], doc = form.getDocument();
    var table = doc.getByKey(tblKey);
    var s_Tbl = doc.getShadow(tblKey);
    if (s_Tbl != null) {
      s_Tbl.beforeFirst();
      while (s_Tbl.next()) {
        var OID = s_Tbl.getByKey(oidKey);
        oids.push(OID);
      }
    } else {
      var s_key = SystemField.SELECT_FIELD_KEY;
      if (table.indexByKey(s_key) != null) {
        table.beforeFirst();
        while (table.next()) {
          if (TypeConvertor.toBoolean(table.getByKey(s_key))) {
            oids.push(table.getByKey(oidKey));
          }
        }
      } else {
        if (defaultValue) {
          table.beforeFirst();
          while (table.next()) {
            oids.push(table.getByKey(oidKey));
          }
        }
      }
    }
    return oids;
  }
}
const sqr = (a, b) => {
  if (b == 0) {
    return 1;
  }
  var r = a;
  for (var i2 = 0; i2 < b - 1; i2++) {
    r *= a;
  }
  return r;
};
class ColumnIDUtil {
  static getSeparatorPos(s) {
    for (var i2 = 0, length2 = s.length; i2 < length2; i2++) {
      if (Utils.isNumeric(s.charAt(i2))) {
        return i2 - 1;
      }
    }
    return -1;
  }
  static toColumnIndex(columnID) {
    var begin = "A".charCodeAt(0), end = "Z".charCodeAt(0), count = end - begin + 1, length2 = columnID.length, c = "", index = 0;
    for (var i2 = length2 - 1; i2 >= 0; --i2) {
      c = columnID.charAt(length2 - i2 - 1);
      if (i2 == 0) {
        index += c.charCodeAt(0) - begin;
      } else {
        index += (c.charCodeAt(0) - begin + 1) * sqr(count, i2);
      }
    }
    return index;
  }
  static toColumnID(columnIndex) {
    var begin = "A".charCodeAt(0);
    var end = "Z".charCodeAt(0);
    var count = end - begin + 1;
    var multiple = 0;
    var remainder = 0;
    multiple = Math.floor(columnIndex / count);
    remainder = columnIndex % count;
    columnIndex = multiple;
    var colID = "";
    var ch = String.fromCharCode(begin + remainder);
    colID = ch + colID;
    while (multiple != 0) {
      multiple = Math.floor(columnIndex / count);
      remainder = columnIndex % count;
      columnIndex = multiple;
      ch = String.fromCharCode(begin + remainder - 1);
      colID = ch + colID;
    }
    return colID;
  }
}
class CookiesUtil {
  static set(key, value, url = "/", date) {
    if (!url) {
      {
        url = "";
      }
    }
    var options2 = {};
    options2 = { path: url };
    date && (options2["expires"] = date);
    api.set(key, value, options2);
  }
  static get(key) {
    return api.get(key);
  }
  static remove(key) {
    api.remove(key);
  }
}
const isNull = (val) => {
  return typeof val == "undefined" || !val;
};
const getVal = (val1, val2) => {
  if (!isNull(val1)) {
    return val1;
  } else if (!isNull(val2)) {
    return val2;
  } else {
    return "";
  }
};
const getGtVal = (value) => {
  if (value) {
    var v = parseFloat(value);
    return v >= 0 ? v : "";
  } else {
    return value;
  }
};
class CssUtil {
  static getStyle(meta, comp) {
    var style = {};
    var org = comp || {};
    style.position = getVal(org.position, meta.position);
    style.left = getGtVal(getVal(org.left, meta.left));
    style.right = getGtVal(getVal(org.right, meta.right));
    style.top = getGtVal(getVal(org.top, meta.top));
    style.bottom = getGtVal(getVal(org.bottom, meta.bottom));
    style.padding = getVal(org.padding, meta.padding);
    style.leftPadding = getVal(org.leftPadding, meta.leftPadding);
    style.rightPadding = getVal(org.rightPadding, meta.rightPadding);
    style.topPadding = getVal(org.topPadding, meta.topPadding);
    style.bottomPadding = getVal(org.bottomPadding, meta.bottomPadding);
    style.margin = getVal(org.margin, meta.margin);
    style.leftMargin = getVal(org.marginLeft, meta.leftMargin);
    style.rightMargin = getVal(org.marginRight, meta.rightMargin);
    style.topMargin = getVal(org.marginTop, meta.topMargin);
    style.bottomMargin = getVal(org.marginBottom, meta.bottomMargin);
    style.borderColor = getVal(org.borderColor, meta.borderColor);
    style.borderRadius = getVal(org.borderRadius, meta.borderRadius);
    style.borderStyle = getVal(org.borderStyle, meta.borderStyle);
    style.borderWidth = getVal(org.borderWidth, meta.borderWidth);
    style.overflowX = getVal(org.overflowX, meta.overflowX);
    style.overflowY = getVal(org.overflowY, meta.overflowY);
    var format = meta.format || {};
    style.format = format;
    style.backColor = org.backColor || format.backColor || meta.backColor || "";
    style.foreColor = org.foreColor || format.foreColor || meta.foreColor || "";
    return style;
  }
  static setHighlightBackColor(view, highlightColor) {
    view.$addClass("highlight");
    view.$addStyle("--highlightColor--", highlightColor);
  }
  static getWHByFontStyle(el, text, type) {
    var whobj = {};
    var span = document.createElement("span");
    span.classList.add("whbyfontsize");
    span.innerHTML = text;
    el.appendChild(span);
    if (type == "pref") {
      span.classList.add("auto");
    }
    whobj["width"] = span.offsetWidth;
    whobj["height"] = span.offsetHeight;
    span.remove();
    return whobj;
  }
  // 读写 transform 二合一
  static transformEle(ele, attr, val, type) {
    if (!ele.transform) {
      ele.transform = {};
    }
    var result = "";
    if (arguments.length > 2) {
      ele.transform[attr] = val;
      for (var attrStr in ele.transform) {
        switch (attrStr) {
          case "translate":
          case "translateX":
          case "translateY":
          case "translateZ":
            if (type) {
              result += attrStr + "(" + ele.transform[attrStr] + "%) ";
              break;
            } else {
              result += attrStr + "(" + ele.transform[attrStr] + "px) ";
              break;
            }
          case "rotate":
          case "rotateX":
          case "rotateY":
          case "rotateZ":
          case "skew":
          case "skewX":
          case "skewY": {
            result += attrStr + "(" + ele.transform[attrStr] + "deg) ";
            break;
          }
          case "scale":
          case "scaleX":
          case "scaleY": {
            result += attrStr + "(" + ele.transform[attrStr] + ") ";
            break;
          }
        }
      }
      ele.style.transform = result;
    } else {
      if (ele.transform[attr]) {
        result = ele.transform[attr];
      } else {
        if (attr == "scale" || attr == "scaleX" || attr == "scaleY") {
          result = 1;
        } else {
          result = 0;
        }
      }
    }
    return result;
  }
  // pc
  static doScrollbar() {
  }
  /**
   * 获取:root下定义的css变量
   * @param key 
   */
  static getPropertyValue(key) {
    return window.getComputedStyle(document.documentElement).getPropertyValue(key);
  }
}
CssUtil.getHeight = (elm) => {
  if (getComputedStyle(elm).display !== "none") {
    return elm.offsetHeight;
  }
  let cssText = elm.style.cssText;
  elm.style.cssText += "position:fixed;left:-9999px;display:block;visibility:hidden";
  let height = elm.offsetHeight;
  elm.style.cssText = cssText;
  return height;
};
CssUtil.getWidth = (elm) => {
  if (getComputedStyle(elm).display !== "none") {
    return elm.offsetWidth;
  }
  let cssText = elm.style.cssText;
  elm.style.cssText += "position:fixed;left:-9999px;display:block;visibility:hidden";
  let width = elm.offsetWidth;
  elm.style.cssText = cssText;
  return width;
};
class RowMap {
  constructor() {
    this.map = [];
  }
  put(key, rowBkmk) {
    var isMatch = false;
    for (var i2 = 0, len = this.map.length; i2 < len; i2++) {
      if (this.map[i2].key.equals(key)) {
        this.map[i2].row = rowBkmk;
        isMatch = true;
        break;
      }
    }
    if (!isMatch) {
      this.map.push({ key, row: rowBkmk });
    }
  }
  get(key) {
    for (var i2 = 0, len = this.map.length; i2 < len; i2++) {
      if (this.map[i2].key.equals(key)) {
        return this.map[i2].row;
      }
    }
    return null;
  }
  getAt(index) {
    return this.map[index];
  }
  size() {
    return this.map.length;
  }
}
const BkmkType = {
  Fix: 0,
  Detail: 1,
  Group: 2,
  Total: 3,
  Expand: 4,
  CustomDetail: 5,
  CustomExpand: 6,
  Multiple: 7
};
const RowObjectType = {
  ROW: 0,
  GROUP: 1,
  AREA: 2
};
const TreeType = {
  NONE: -1,
  DICT: 0,
  COMMON: 1
};
const RowExpandType = {
  DICT: 0,
  FORMULA: 1
};
const ColumnExpandType = {
  TITLE: 0,
  DATA: 1,
  NONE: -1
};
const CellExpandObjectType = {
  Cells: 0,
  Group: 1
};
const ColumnExpandObjectType = {
  Column: 0,
  Group: 1
};
const ExpandSourceType = {
  DATA: 0,
  CUSTOM: 1,
  DICT: 2
};
const GridOpt = {
  insert: "insert",
  delete: "delete",
  shift: "shift",
  zoom: "zoom",
  export: "export",
  search: "search",
  bestWidth: "bestWidth",
  frozenRow: "frozenRow",
  frozenColumn: "frozenColumn",
  frozenRowColumn: "frozenRowColumn",
  sum: "sum",
  filter: "filter",
  groupSum: "groupSum",
  variantSet: "variantSet"
};
class JavaDataType {
}
JavaDataType.USER_INT = 1;
JavaDataType.STR_USER_INT = "Integer";
JavaDataType.USER_STRING = 2;
JavaDataType.STR_USER_STRING = "String";
JavaDataType.USER_DATETIME = 3;
JavaDataType.STR_USER_DATETIME = "Date";
JavaDataType.USER_NUMERIC = 4;
JavaDataType.STR_USER_NEMERIC = "Numeric";
JavaDataType.USER_BINARY = 5;
JavaDataType.STR_USER_BINARY = "Binary";
JavaDataType.USER_BOOLEAN = 6;
JavaDataType.STR_USER_BOOLEAN = "Boolean";
JavaDataType.USER_LONG = 7;
JavaDataType.STR_USER_LONG = "Long";
JavaDataType.USER_DOCUMENT = 8;
JavaDataType.STR_USER_DOCUMENT = "Document";
JavaDataType.USER_DATATABLE = 9;
JavaDataType.STR_USER_DATATABLE = "DataTable";
JavaDataType.USER_JSONOBJECT = 10;
JavaDataType.STR_USER_JSONOBJECT = "JSONObject";
JavaDataType.USER_JSONARRAY = 11;
JavaDataType.STR_USER_JSONARRAY = "JSONArray";
JavaDataType.USER_ITEMDATA = 12;
JavaDataType.STR_USER_ITEMDATA = "ItemData";
var equals = function(o1, o2) {
  if (o1 != null && o2 == null)
    return false;
  if (o1 instanceof Decimal) {
    return o1.equals(o2);
  } else if (o1 instanceof Date) {
    return o1.getTime() == o2.getTime();
  } else if (o1 instanceof ItemData) {
    return o1.getOID() == o2.getOID();
  }
  return o1 == o2;
};
class MultiDimNode {
  constructor(options2) {
    this.columnKey = options2.columnKey;
    this.dataType = options2.dataType;
    this.value = options2.value;
  }
  getColumnKey() {
    return this.columnKey;
  }
  getDataType() {
    return this.dataType;
  }
  getValue() {
    return this.value;
  }
  equals(obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (typeof obj != typeof this)
      return false;
    if (this.columnKey != obj.columnKey)
      return false;
    if (this.dataType != obj.dataType)
      return false;
    if (this.value == null) {
      if (obj.value != null)
        return false;
    } else if (!equals(this.value, obj.value)) {
      return false;
    }
    return true;
  }
  clone() {
    return new MultiDimNode({
      columnKey: this.columnKey,
      dataType: this.dataType,
      value: this.value
    });
  }
}
class MultiDimValue {
  constructor(json) {
    this.values = [];
    if (json) {
      for (var i2 = 0, length2 = json.length; i2 < length2; i2++) {
        this.addValue(new MultiDimNode(json[i2]));
      }
    }
  }
  setValues(values) {
    this.values = values;
  }
  addValue(value) {
    this.values.push(value);
  }
  addAll(values) {
    for (var i2 = 0, v; v = values[i2]; i2++) {
      this.values.push(v);
    }
  }
  size() {
    return this.values.length;
  }
  getValue(index) {
    return this.values[index];
  }
  clone() {
    var newObj = new MultiDimValue();
    for (var i2 = 0, value; value = this.values[i2]; i2++) {
      newObj.addValue(value.clone());
    }
    return newObj;
  }
  equals(obj) {
    if (obj == this)
      return true;
    if (obj == null)
      return false;
    if (typeof obj != typeof this)
      return false;
    if (this.size() != obj.size())
      return false;
    for (var i2 = 0, len = this.size(); i2 < len; i2++) {
      var node_A = this.getValue(i2);
      var node_B = obj.getValue(i2);
      if (!node_A.equals(node_B)) {
        return false;
      }
    }
    return true;
  }
}
class MultiKeyNode {
  constructor(dataType, value) {
    this.dataType = dataType;
    this.value = value;
  }
  getDataType() {
    return this.dataType;
  }
  getValue() {
    return this.value;
  }
  equals(obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (typeof obj != typeof this)
      return false;
    if (this.dataType != obj.dataType)
      return false;
    if (this.value == null) {
      if (obj.value != null) {
        return false;
      }
    } else if (!equals(this.value, obj.value)) {
      return false;
    }
    return true;
  }
  toString() {
    return (this.value == null ? "" : this.value.toString()) + "_" + this.dataType;
  }
  clone() {
    return new MultiKeyNode(this.dataType, this.value);
  }
}
class MultiKey {
  constructor() {
    this.values = [];
  }
  clear() {
    this.values.length = 0;
  }
  setValues(values) {
    this.values = values;
  }
  addValue(value) {
    this.values.push(value);
  }
  addAll(valueList) {
    for (var i2 = 0, v; v = valueList[i2]; i2++) {
      this.values.push(v);
    }
  }
  getValueCount() {
    return this.values.length;
  }
  getValue(index) {
    return this.values[index];
  }
  setUserObject(userObj) {
    this.userObject = userObj;
  }
  getUserObject() {
    return this.userObject;
  }
  contains(otherValue) {
    var count = this.getValueCount(), otherCount = otherValue.getValueCount(), v1, v2;
    if (count < otherCount) {
      return false;
    }
    for (var i2 = 0; i2 < otherCount; i2++) {
      v1 = this.getValue(i2);
      v2 = otherValue.getValue(i2);
      if (!v1.equals(v2)) {
        return false;
      }
    }
    return true;
  }
  clone() {
    var newObj = new MultiKey();
    for (var i2 = 0, value; value = this.values[i2]; i2++) {
      newObj.addValue(value.clone());
    }
    return newObj;
  }
  shallowClone() {
    var newObj = new MultiKey();
    newObj.addAll(this.values);
    return newObj;
  }
  newInstance() {
    return new MultiKey();
  }
  toString() {
    var sValue = "";
    for (var i2 = 0, value; value = this.values[i2]; i2++) {
      sValue += value.toString() + "_";
    }
    return sValue.substring(0, sValue.length - 1);
  }
  equals(obj) {
    if (obj == this)
      return true;
    if (obj == null)
      return false;
    if (typeof obj != typeof this)
      return false;
    if (this.getValueCount() != obj.getValueCount())
      return false;
    for (var i2 = 0, len = this.getValueCount(); i2 < len; i2++) {
      var node_A = this.getValue(i2);
      var node_B = obj.getValue(i2);
      if (!node_A.equals(node_B)) {
        return false;
      }
    }
    return true;
  }
  compare(other) {
    var count = this.getValueCount(), result = 0;
    for (var i2 = 0; i2 < count; i2++) {
      var node1 = this.getValue(i2), node2 = other.getValue(i2), value1 = node1.getValue(), value2 = node2.getValue();
      if (value1 == null && value2 != null) {
        return -1;
      } else if (value1 != null && value2 == null) {
        return -1;
      } else if (value1 == null && value2 == null) {
        continue;
      }
      switch (node1.getDataType()) {
        case JavaDataType.USER_INT:
        case JavaDataType.USER_LONG:
        case JavaDataType.USER_NUMERIC:
          result = TypeConvertor.toDecimal(value1).comparedTo(TypeConvertor.toDecimal(value2));
          break;
        case JavaDataType.USER_DATETIME:
          var date1 = TypeConvertor.toDate(value1).getTime(), date2 = TypeConvertor.toDate(value2).getTime();
          result = date1 - date2 > 0 ? 1 : date1 == date2 ? 0 : -1;
          break;
        case JavaDataType.USER_STRING:
          result = TypeConvertor.toString(value1).localeCompare(TypeConvertor.toString(value2));
          break;
      }
      if (result != 0) {
        break;
      }
    }
    return result;
  }
}
class BaseRowBkmk {
  constructor(bkmk) {
    this.bookmark = bkmk != void 0 ? bkmk : -1;
  }
  setBookmark(bkmk) {
    this.bookmark = bkmk;
  }
  getBookmark() {
    return this.bookmark;
  }
}
class DetailRowBkmk extends BaseRowBkmk {
  getRowType() {
    return BkmkType.Detail;
  }
  toString() {
    return "Detail_" + this.bookmark;
  }
  equals(obj) {
    if (obj == null) {
      return false;
    }
    if (!(obj instanceof DetailRowBkmk)) {
      return false;
    }
    return this.bookmark == obj.bookmark;
  }
}
class GroupRowBkmk extends BaseRowBkmk {
  constructor(groupValue) {
    super();
    this.groupValue = groupValue;
    this.rowArray = [];
  }
  getRowType() {
    return BkmkType.Group;
  }
  addRow(bkmk) {
    this.rowArray.push(bkmk);
  }
  setLeaf(isLeaf) {
    this.isLeaf = isLeaf;
  }
  getRowCount() {
    return this.rowArray.length;
  }
  getRowAt(rowIndex) {
    if (rowIndex < 0 || rowIndex >= this.rowArray.length)
      return null;
    return this.rowArray[rowIndex];
  }
  setMetaGroup(metaGroup) {
    this.metaGroup = metaGroup;
  }
  getMetaGroup() {
    return this.metaGroup;
  }
}
class MultiRowBkmk extends BaseRowBkmk {
  constructor() {
    super();
    this.rowMap = [];
  }
  put(dimValue, bkmk) {
    var isMatch = false;
    for (var i2 = 0, e; e = this.rowMap[i2]; i2++) {
      if (e.key.equals(dimValue)) {
        e.rows.push(bkmk);
        isMatch = true;
        break;
      }
    }
    if (!isMatch) {
      this.rowMap.push({ key: dimValue, rows: [bkmk] });
    }
  }
  get(dimValue) {
    for (var i2 = 0, e; e = this.rowMap[i2]; i2++) {
      if (e.key.equals(dimValue)) {
        return e.rows;
      }
    }
    return null;
  }
  getRowType() {
    return BkmkType.Multiple;
  }
}
class ExpandRowBkmk extends BaseRowBkmk {
  constructor(count) {
    super();
    this.rowArray = [];
    this.expandRowMapList = [];
    for (var i2 = 0; i2 < count; i2++) {
      this.expandRowMapList.push(new RowMap());
    }
  }
  getRowType() {
    return BkmkType.Expand;
  }
  size() {
    return this.rowArray.length;
  }
  add(areaIndex, key, row) {
    if (this.rowArray.indexOf(row) < 0) {
      this.rowArray.push(row);
    }
    var map2 = this.expandRowMapList[areaIndex], isMatch = false;
    for (var i2 = 0, len = map2.size(); i2 < len; i2++) {
      if (map2.getAt(i2).key.equals(key)) {
        map2.getAt(i2).row = row;
        isMatch = true;
        break;
      }
    }
    if (!isMatch) {
      map2.put(key, row);
    }
  }
  getAt(index) {
    return this.rowArray[index];
  }
  getRowArray() {
    return this.rowArray;
  }
  getAtArea(areaIndex, key) {
    var map2 = this.expandRowMapList[areaIndex];
    for (var i2 = 0, len = map2.size(); i2 < len; i2++) {
      if (map2.getAt(i2).key.equals(key)) {
        return map2.getAt(i2).row;
      }
    }
    return null;
  }
}
class ExpandItem {
  constructor(value, caption, dataType) {
    this.value = value;
    this.caption = caption;
    this.dataType = dataType;
  }
}
class BPMKeys {
}
BPMKeys.SAVEBPMMAP_KEY = "SaveBPMMap";
BPMKeys.LOADBPM_KEY = "BPM";
BPMKeys.STATE_MACHINE = "StateMachine";
BPMKeys.WORKITEM_INFO = "WorkitemInfo";
BPMKeys.LOAD_WORKITEM_INFO = "LoadWorkItemInfo";
BPMKeys.REGISTER_ATTACHMENT = "RegisterAttachment";
BPMKeys.RETREAT_CAPTION = "RetreatCaption";
BPMKeys.CHOOSE_ROLLBACK = "ChooseRollback";
class DataDef {
}
DataDef.R_Normal = 0;
DataDef.R_New = 1;
DataDef.R_Modified = 2;
DataDef.R_Deleted = 3;
DataDef.D_Normal = 0;
DataDef.D_New = 1;
DataDef.D_Modified = 2;
DataDef.D_Deleted = 3;
DataDef.D_Obj = 1;
DataDef.D_ObjDtl = 2;
class Stack {
  constructor() {
    this.table = new Array();
  }
  push(value) {
    this.table.push(value);
  }
  pop() {
    return this.table.pop();
  }
  peek() {
    return this.table[this.table.length - 1];
  }
  empty() {
    return this.table.length == 0;
  }
  values() {
    return this.table;
  }
  size() {
    return this.table.length;
  }
}
const eq = (s1, s2) => {
  if (s1 === null) {
    return s1 === s2;
  } else {
    if (!Utils.isString(s1)) {
      s1 = s1.toString();
    }
    if (!Utils.isString(s2)) {
      s2 = s2.toString();
    }
    return s1.toLowerCase() === s2.toLowerCase();
  }
};
const ADD = 0;
const STRCAT = 1;
const SUB = 2;
const MUL = 3;
const DIV = 4;
const OR = 5;
const AND = 6;
const EQ = 7;
const ASSIGN = 8;
const NEQ = 9;
const GT = 10;
const GT_EQ = 11;
const LT = 12;
const LT_EQ = 13;
const ID = 15;
const RB = 18;
const COMMA = 19;
const ELSE = 22;
const SEMI = 26;
const R_BR = 28;
const RANGE = 32;
const SL = 50;
const E = 51;
const IF_H = 52;
const IF_T = 53;
const FUN_H = 54;
const FUN_T = 55;
const PL = 56;
const CASE_S = 58;
const MAX = 60;
const T_INT = 0;
const T_NUM = 1;
const T_STR = 2;
const T_BOOL = 3;
const IIF$1 = "iif";
const IIFS$1 = "iifs";
const S_SELF = "self";
const S_PARENT = "parent";
const F_RETURN = 0;
const F_BREAK = 1;
class Evaluator {
  constructor(implMap, evalEnv, tree, scope) {
    this.implMap = implMap;
    this.evalEnv = evalEnv;
    this.tree = tree;
    this.scope = scope;
    this.ctrlFlow = -1;
  }
  eval(cxt) {
    var v = null;
    this.exec(cxt, this.tree.get());
    v = this.tree.get().get();
    return v;
  }
  exec(cxt, p2) {
    var r = p2.rule();
    var rIdx = -1;
    if (r != null) {
      rIdx = r.index();
      switch (rIdx) {
        case 0:
          this.exec0(cxt, p2);
          break;
        case 1:
          this.exec1(cxt, p2);
          break;
        case 2:
          this.exec2(cxt, p2);
          break;
        case 3:
          this.exec3(cxt, p2);
          break;
        case 4:
          this.exec4(cxt, p2);
          break;
        case 5:
          this.exec5(cxt, p2);
          break;
        case 6:
          this.exec6(cxt, p2);
          break;
        case 7:
          this.exec7(cxt, p2);
          break;
        case 8:
          this.exec8(cxt, p2);
          break;
        case 9:
          this.exec9(cxt, p2);
          break;
        case 10:
          this.exec10(cxt, p2);
          break;
        case 11:
          this.exec11(cxt, p2);
          break;
        case 12:
          this.exec12(cxt, p2);
          break;
        case 13:
          this.exec13(cxt, p2);
          break;
        case 14:
          this.exec14(cxt, p2);
          break;
        case 15:
          this.exec15(cxt, p2);
          break;
        case 16:
          this.exec16(cxt, p2);
          break;
        case 17:
          this.exec17(cxt, p2);
          break;
        case 18:
          this.exec18(cxt, p2);
          break;
        case 19:
          this.exec19(cxt, p2);
          break;
        case 20:
          this.exec20(cxt, p2);
          break;
        case 21:
          this.exec21(cxt, p2);
          break;
        case 22:
          this.exec22(cxt, p2);
          break;
        case 23:
          this.exec23(cxt, p2);
          break;
        case 24:
          this.exec24(cxt, p2);
          break;
        case 25:
          this.exec25(cxt, p2);
          break;
        case 26:
          this.exec26(cxt, p2);
          break;
        case 27:
          this.exec27(cxt, p2);
          break;
        case 28:
          this.exec28(cxt, p2);
          break;
        case 29:
          this.exec29(cxt, p2);
          break;
        case 30:
          this.exec30(cxt, p2);
          break;
        case 31:
          this.exec31(cxt, p2);
          break;
        case 32:
          this.exec32(cxt, p2);
          break;
        case 33:
          this.exec33(cxt, p2);
          break;
        case 34:
          this.exec34(cxt, p2);
          break;
        case 35:
          this.exec35(cxt, p2);
          break;
        case 36:
          this.exec36(cxt, p2);
          break;
        case 37:
          this.exec37(cxt, p2);
          break;
        case 38:
          this.exec38(cxt, p2);
          break;
        case 39:
          this.exec39(cxt, p2);
          break;
        case 40:
          this.exec40(cxt, p2);
          break;
      }
    }
  }
  isNull(v) {
    return v == void 0 || v == null;
  }
  getCpType(v1, v2) {
    var type = -1;
    if (this.isNull(v1)) {
      var temp = v2;
      v2 = v1;
      v1 = temp;
    }
    if (typeof v1 == "string") {
      if (Utils.isNumeric(v1)) {
        type = DataType.STRING;
      } else {
        type = DataType.STRING;
      }
    } else if (typeof v1 == "number") {
      if (this.isNull(v2)) {
        type = DataType.NUMERIC;
      } else if (typeof v2 == "string") {
        type = DataType.STRING;
      } else if (typeof v2 == "number") {
        type = DataType.INT;
      } else if (v2 instanceof Decimal) {
        type = DataType.NUMERIC;
      } else if (v2 instanceof Date) {
        throw new Error("Incompatible type");
      }
    } else if (typeof v1 == "boolean") {
      if (this.isNull(v2)) {
        type = DataType.NUMERIC;
      } else if (typeof v2 == "number" || v2 instanceof Decimal) {
        type = DataType.NUMERIC;
      } else if (typeof v2 == "string") {
        type = DataType.STRING;
      } else if (typeof v2 == "boolean") {
        type = DataType.BOOLEAN;
      } else if (v2 instanceof Date) {
        throw new Error("Incompatible type");
      }
    } else if (v1 instanceof Decimal) {
      if (this.isNull(v2)) {
        type = DataType.NUMERIC;
      } else if (typeof v2 == "number" || v2 instanceof Decimal) {
        type = DataType.NUMERIC;
      } else if (typeof v2 == "string") {
        type = DataType.STRING;
      } else if (typeof v2 == "boolean") {
        type = DataType.BOOLEAN;
      } else if (v2 instanceof Date) {
        throw new Error("Incompatible type");
      }
    } else if (v1 instanceof Date) {
      if (v2 == null || v2 instanceof Date) {
        type = DataType.DATETIME;
      } else {
        throw new Error("Incompatible type");
      }
    }
    return type;
  }
  // SL -> E
  exec0(cxt, p2) {
    var E2 = p2.item(0);
    this.exec(cxt, E2);
    if (this.ctrlFlow != F_RETURN) {
      p2.set(E2.get());
    }
  }
  // SL -> E ; SL
  exec1(cxt, p2) {
    var l = (p2.size() + 1) / 2;
    var v = null;
    for (var i2 = 0; i2 < l; ++i2) {
      var E2 = p2.item(i2 * 2);
      this.exec(cxt, E2);
      if (this.ctrlFlow != -1) {
        break;
      }
      v = E2.get();
    }
    if (this.ctrlFlow != F_RETURN) {
      p2.set(v);
    }
  }
  // E -> E + E
  exec2(cxt, p2) {
    var E1 = p2.item(0);
    var E2 = p2.item(2);
    this.exec(cxt, E1);
    this.exec(cxt, E2);
    var v1 = E1.get(), v2 = E2.get(), type = this.getCpType(v1, v2), v;
    switch (type) {
      case DataType.STRING:
        v = TypeConvertor.toString(v1) + TypeConvertor.toString(v2);
        break;
      case DataType.INT:
        v = TypeConvertor.toInt(v1) + TypeConvertor.toInt(v2);
        break;
      case DataType.NUMERIC:
        v = TypeConvertor.toDecimal(v1).plus(TypeConvertor.toDecimal(v2));
        break;
    }
    p2.set(v);
  }
  // E -> E - E
  exec3(cxt, p2) {
    var E1 = p2.item(0);
    var E2 = p2.item(2);
    this.exec(cxt, E1);
    this.exec(cxt, E2);
    var v1 = E1.get(), v2 = E2.get(), type = this.getCpType(v1, v2), v;
    switch (type) {
      case DataType.INT:
        v = TypeConvertor.toInt(v1) - TypeConvertor.toInt(v2);
        break;
      case DataType.NUMERIC:
        v = TypeConvertor.toDecimal(v1).minus(TypeConvertor.toDecimal(v2));
        break;
    }
    p2.set(v);
  }
  // E -> E * E
  exec4(cxt, p2) {
    var E1 = p2.item(0);
    var E2 = p2.item(2);
    this.exec(cxt, E1);
    this.exec(cxt, E2);
    var v1 = E1.get(), v2 = E2.get(), type = this.getCpType(v1, v2), v;
    switch (type) {
      case DataType.INT:
        v = TypeConvertor.toInt(v1) * TypeConvertor.toInt(v2);
        break;
      case DataType.NUMERIC:
        v = TypeConvertor.toDecimal(v1).times(TypeConvertor.toDecimal(v2));
        break;
    }
    p2.set(v);
  }
  // E -> E / E
  exec5(cxt, p2) {
    var E1 = p2.item(0);
    var E2 = p2.item(2);
    this.exec(cxt, E1);
    this.exec(cxt, E2);
    var v1 = TypeConvertor.toDecimal(E1.get()), v2 = TypeConvertor.toDecimal(E2.get());
    p2.set(v1.dividedBy(v2));
  }
  // E -> E & E
  exec6(cxt, p2) {
    var E1 = p2.item(0);
    var E2 = p2.item(2);
    this.exec(cxt, E1);
    this.exec(cxt, E2);
    var e1 = E1.get(), e2 = E2.get();
    var type = this.getCpType(e1, e2);
    if (type == DataType.STRING) {
      var v1 = TypeConvertor.toString(e1), v2 = TypeConvertor.toString(e2);
      p2.set(v1 + v2);
    }
  }
  // E -> ( E )
  exec7(cxt, p2) {
    var E2 = p2.item(1);
    this.exec(cxt, E2);
    p2.set(E2.get());
  }
  // E -> ! E
  exec8(cxt, p2) {
    var E2 = p2.item(1);
    this.exec(cxt, E2);
    var value = TypeConvertor.toBoolean(E2.get());
    p2.set(!value);
  }
  // E -> E || E
  exec9(cxt, p2) {
    var E1 = p2.item(0);
    var E2 = p2.item(2);
    this.exec(cxt, E1);
    var b1 = TypeConvertor.toBoolean(E1.get());
    var b2 = false;
    if (!b1) {
      this.exec(cxt, E2);
      b2 = TypeConvertor.toBoolean(E2.get());
    }
    p2.set(b1 || b2);
  }
  // E -> E && E
  exec10(cxt, p2) {
    var E1 = p2.item(0);
    var E2 = p2.item(2);
    this.exec(cxt, E1);
    var b1 = TypeConvertor.toBoolean(E1.get());
    var b2 = false;
    if (b1) {
      this.exec(cxt, E2);
      b2 = TypeConvertor.toBoolean(E2.get());
    }
    p2.set(b1 && b2);
  }
  // E -> E == E
  exec11(cxt, p2) {
    var E1 = p2.item(0);
    var E2 = p2.item(2);
    this.exec(cxt, E1);
    this.exec(cxt, E2);
    var v1 = E1.get(), v2 = E2.get(), type = this.getCpType(v1, v2), v;
    switch (type) {
      case DataType.NUMERIC:
        if (!Utils.isNumeric(v2)) {
          v = false;
        } else {
          v = TypeConvertor.toDecimal(v1).equals(TypeConvertor.toDecimal(v2));
        }
        break;
      case DataType.STRING:
        var s1 = TypeConvertor.toString(v1);
        var s2 = TypeConvertor.toString(v2);
        v = eq(s1, s2);
        break;
      case DataType.DATETIME:
        var d1 = TypeConvertor.toDate(v1);
        var d2 = TypeConvertor.toDate(v2);
        if (d1 == null) {
          v = d2 == null ? true : false;
        } else if (d2 == null) {
          v = false;
        } else {
          v = d1.getTime() == d2.getTime();
        }
        break;
      default:
        v = v1 == v2;
        break;
    }
    p2.set(v);
  }
  // E -> E <> E
  exec12(cxt, p2) {
    var E1 = p2.item(0);
    var E2 = p2.item(2);
    this.exec(cxt, E1);
    this.exec(cxt, E2);
    var v1 = E1.get(), v2 = E2.get(), type = this.getCpType(v1, v2), v;
    switch (type) {
      case DataType.NUMERIC:
        v = !TypeConvertor.toDecimal(v1).equals(TypeConvertor.toDecimal(v2));
        break;
      case DataType.STRING:
        var s1 = TypeConvertor.toString(v1);
        var s2 = TypeConvertor.toString(v2);
        v = !eq(s1, s2);
        break;
      default:
        v = v1 != v2;
        break;
    }
    p2.set(v);
  }
  // E -> E > E
  exec13(cxt, p2) {
    var E1 = p2.item(0);
    var E2 = p2.item(2);
    this.exec(cxt, E1);
    this.exec(cxt, E2);
    var v1 = E1.get(), v2 = E2.get(), type = this.getCpType(v1, v2), v;
    switch (type) {
      case DataType.NUMERIC:
        v = TypeConvertor.toDecimal(v1).greaterThan(TypeConvertor.toDecimal(v2));
        break;
      case DataType.STRING:
        var s1 = TypeConvertor.toString(v1).toLowerCase();
        var s2 = TypeConvertor.toString(v2).toLowerCase();
        v = s1.localeCompare(s2) == 1;
        break;
      case DataType.DATETIME:
        var d1 = TypeConvertor.toDate(v1);
        var d2 = TypeConvertor.toDate(v2);
        if (d1 == null) {
          v = false;
        } else if (d2 == null) {
          v = true;
        } else {
          v = d1.getTime() > d2.getTime();
        }
        break;
      default:
        v = v1 > v2;
        break;
    }
    p2.set(v);
  }
  // E -> E >= E
  exec14(cxt, p2) {
    var E1 = p2.item(0);
    var E2 = p2.item(2);
    this.exec(cxt, E1);
    this.exec(cxt, E2);
    var v1 = E1.get(), v2 = E2.get(), type = this.getCpType(v1, v2), v;
    switch (type) {
      case DataType.NUMERIC:
        v = TypeConvertor.toDecimal(v1).greaterThanOrEqualTo(TypeConvertor.toDecimal(v2));
        break;
      case DataType.STRING:
        var s1 = TypeConvertor.toString(v1).toLowerCase();
        var s2 = TypeConvertor.toString(v2).toLowerCase();
        v = s1.localeCompare(s2) == 0 || s1.localeCompare(s2) == 1;
        break;
      case DataType.DATETIME:
        var d1 = TypeConvertor.toDate(v1);
        var d2 = TypeConvertor.toDate(v2);
        if (d1 == null) {
          v = d2 == null ? true : false;
        } else if (d2 == null) {
          v = true;
        } else {
          v = d1.getTime() >= d2.getTime();
        }
        break;
      default:
        v = v1 >= v2;
        break;
    }
    p2.set(v);
  }
  // E -> E < E
  exec15(cxt, p2) {
    var E1 = p2.item(0);
    var E2 = p2.item(2);
    this.exec(cxt, E1);
    this.exec(cxt, E2);
    var v1 = E1.get(), v2 = E2.get(), type = this.getCpType(v1, v2), v;
    switch (type) {
      case DataType.NUMERIC:
        v = TypeConvertor.toDecimal(v1).lessThan(TypeConvertor.toDecimal(v2));
        break;
      case DataType.STRING:
        var s1 = TypeConvertor.toString(v1).toLowerCase();
        var s2 = TypeConvertor.toString(v2).toLowerCase();
        v = s1.localeCompare(s2) == -1;
        break;
      case DataType.DATETIME:
        var d1 = TypeConvertor.toDate(v1);
        var d2 = TypeConvertor.toDate(v2);
        if (d1 == null)
          ;
        else if (d2 == null) {
          v = false;
        } else {
          v = d1.getTime() < d2.getTime();
        }
        break;
      default:
        v = v1 < v2;
        break;
    }
    p2.set(v);
  }
  // E -> E <= E
  exec16(cxt, p2) {
    var E1 = p2.item(0);
    var E2 = p2.item(2);
    this.exec(cxt, E1);
    this.exec(cxt, E2);
    var v1 = E1.get(), v2 = E2.get(), type = this.getCpType(v1, v2), v;
    switch (type) {
      case DataType.NUMERIC:
        v = TypeConvertor.toDecimal(v1).lessThanOrEqualTo(TypeConvertor.toDecimal(v2));
        break;
      case DataType.STRING:
        var s1 = TypeConvertor.toString(v1).toLowerCase();
        var s2 = TypeConvertor.toString(v2).toLowerCase();
        v = s1.localeCompare(s2) == 0 || s1.localeCompare(s2) == -1;
        break;
      case DataType.DATETIME:
        var d1 = TypeConvertor.toDate(v1);
        var d2 = TypeConvertor.toDate(v2);
        if (d1 == null) {
          v = true;
        } else if (d2 == null) {
          v = false;
        } else {
          v = d1.getTime() <= d2.getTime();
        }
        break;
      default:
        v = v1 <= v2;
        break;
    }
    p2.set(v);
  }
  // E -> const
  exec17(cxt, p2) {
    var cf = p2.item(0);
    p2.set(cf.get());
  }
  // E -> id
  exec18(cxt, p2) {
    var idf = p2.item(0);
    var id = idf.getLex();
    var obj = idf.getObj();
    var found = false;
    var value = null;
    var heap = this.scope.getHeap();
    if (heap.contains(id)) {
      value = heap.get(id);
      found = true;
    }
    if (!found) {
      if (!heap.contains(obj)) {
        let newCxt = cxt;
        if (obj != null) {
          newCxt = this.evalEnv.resolveObject(cxt, this.scope, obj);
        }
        value = this.evalEnv.get(newCxt, id, this.scope);
      } else {
        value = this.evalEnv.get(cxt, id, this.scope, obj);
      }
    }
    p2.set(value);
  }
  // E -> FUNC_HEAD FUNC_TAIL
  exec19(cxt, p2) {
    this.execFun(cxt, p2, 0, null);
  }
  // FUNC_HEAD -> function (
  exec20(cxt, p2) {
  }
  // FUNC_TAIL -> )
  exec21(cxt, p2) {
  }
  // FUNC_TAIL -> PL )
  exec22(cxt, p2) {
  }
  // PL -> E
  exec23(cxt, p2) {
  }
  // PL -> E , PL
  exec24(cxt, p2) {
  }
  // E -> var id = E
  exec25(cxt, p2) {
    var id = p2.item(1);
    var E2 = p2.item(3);
    this.exec(cxt, E2);
    this.scope.getHeap().put(id.getLex(), E2.get());
  }
  // E -> IF_HEAD
  exec26(cxt, p2) {
    var E2 = p2.item(2);
    this.exec(cxt, E2);
    if (E2.get()) {
      var SL2 = p2.item(5);
      this.exec(cxt, SL2);
      if (this.ctrlFlow != F_RETURN) {
        p2.set(SL2.get());
      }
    }
  }
  // E -> IF_HEAD IF_TAIL
  exec27(cxt, p2) {
    var E2 = p2.item(2);
    this.exec(cxt, E2);
    if (E2.get()) {
      var SL1 = p2.item(5);
      this.exec(cxt, SL1);
      if (this.ctrlFlow != F_RETURN) {
        p2.set(SL1.get());
      }
    } else {
      var SL2 = p2.item(9);
      this.exec(cxt, SL2);
      if (this.ctrlFlow != F_RETURN) {
        p2.set(SL2.get());
      }
    }
  }
  // IF_HEAD -> if ( E ) { SL }
  exec28(cxt, p2) {
    var E2 = p2.item(2);
    this.exec(cxt, E2);
    if (E2.get()) {
      var SL2 = p2.item(5);
      this.exec(cxt, SL2);
      if (this.ctrlFlow != F_RETURN) {
        p2.set(SL2.get());
      }
    }
  }
  // IF_TAIL -> else { SL }
  exec29(cxt, p2) {
  }
  // E -> while ( E ) { SL }
  exec30(cxt, p2) {
    var E2 = p2.item(2);
    var SL2 = p2.item(5);
    this.exec(cxt, E2);
    while (E2.get()) {
      this.exec(cxt, SL2);
      if (this.ctrlFlow != -1) {
        break;
      }
      this.exec(cxt, E2);
    }
    if (this.ctrlFlow == F_BREAK) {
      this.ctrlFlow = -1;
    }
  }
  // E -> E = E
  exec31(cxt, p2) {
    var E1 = p2.item(0);
    var E2 = p2.item(2);
    var idf = E1.item(0);
    var id = "";
    if (idf.factor().get() == 15) {
      id = idf.getLex();
    } else {
      this.exec(cxt, E1);
      id = E1.get();
    }
    var obj = idf.getObj();
    this.exec(cxt, E2);
    var heap = this.scope.getHeap();
    if (heap.contains(id)) {
      heap.put(id, E2.get());
    } else {
      this.evalEnv.set(cxt, id, E2.get(), this.scope, obj);
    }
  }
  // E -> return E
  exec32(cxt, p2) {
    var E2 = p2.item(1);
    this.exec(cxt, E2);
    this.tree.get().set(E2.get());
    this.ctrlFlow = F_RETURN;
  }
  // E -> break
  exec33(cxt, p2) {
    this.ctrlFlow = F_BREAK;
  }
  // E -> loop E ( E ) { SL }
  exec34(cxt, p2) {
    var fun = p2.item(0);
    var name2 = fun.getLex();
    var OE = p2.item(1);
    this.exec(cxt, OE);
    var CE = p2.item(3);
    var SL2 = p2.item(6);
    var obj = OE.get();
    var loopObject = this.evalEnv.getLoop(cxt, name2, 0, obj);
    while (loopObject.hasNext()) {
      loopObject.next();
      this.exec(cxt, CE);
      if (CE.get()) {
        this.exec(cxt, SL2);
      }
      if (this.ctrlFlow != -1) {
        break;
      }
    }
    loopObject.clean();
    if (this.ctrlFlow == 1) {
      this.ctrlFlow = -1;
    }
  }
  // E -> RANGE
  exec35(cxt, p2) {
    var r = p2.item(0);
    p2.set(r.get());
  }
  // E -> switch ( E ) { CASE_SL }
  exec36(cxt, p2) {
    var E2 = p2.item(2);
    this.exec(cxt, E2);
    var condition = E2.get();
    var childCount = p2.size();
    childCount -= 5;
    var length2 = childCount / 2;
    for (var i2 = 0; i2 < length2; ++i2) {
      var caseIndex = 5 + i2 * 2;
      var CASE_S2 = p2.item(caseIndex);
      if (this.execCase(cxt, condition, CASE_S2)) {
        p2.set(CASE_S2.get());
        break;
      }
    }
  }
  execCase(cxt, condition, factor) {
    var E2 = factor.item(1);
    this.exec(cxt, E2);
    var value = E2.get();
    var matched = false;
    var type = this.getCpType(condition, value);
    switch (type) {
      case DataType.NUMERIC:
        matched = TypeConvertor.toDecimal(condition).equals(TypeConvertor.toDecimal(value));
        break;
      case DataType.STRING:
        matched = eq(condition.toString(), value.toString());
        break;
      default:
        matched = condition == value;
        break;
    }
    if (matched) {
      var SL2 = factor.item(4);
      this.exec(cxt, SL2);
      factor.set(SL2.get());
    }
    return matched;
  }
  // CASE_SL -> CASE_S
  exec37(cxt, p2) {
  }
  // CASE_SL -> CASE_S ; CASE_SL
  exec38(cxt, p2) {
  }
  // CASE_S -> case E : { SL }
  exec39(cxt, p2) {
  }
  // E -> null
  exec40(cxt, p2) {
    var idf = p2.item(0);
    var id = idf.getLex();
    var obj = idf.getObj();
    var found = false;
    var value = null;
    var heap = this.scope.getHeap();
    if (heap.contains(id)) {
      value = heap.get(id);
      found = true;
    }
    if (!found) {
      value = this.evalEnv.get(cxt, id, this.scope, obj);
    }
    p2.set(value);
  }
  execFun(cxt, p2, postfixCount, extInfo) {
    var fun = p2.item(0);
    var name2 = fun.getLex();
    var obj = fun.getObj();
    var cv = false;
    var impl = null;
    var newCxt = null;
    if (obj != null) {
      newCxt = this.evalEnv.resolveObject(cxt, this.scope, obj);
      impl = this.evalEnv.evalFuncImpl(cxt, this.scope, obj, name2);
      if (impl == null) {
        impl = this.implMap.get(name2);
      }
    } else {
      newCxt = cxt;
      impl = this.implMap.get(name2);
    }
    var l = (p2.size() - 2) / 2;
    l = Math.floor(l);
    var args = new Array(l);
    for (var i2 = 0; i2 < l; ++i2) {
      var P = p2.item(2 + i2 * 2);
      if (fun.isCtrl()) {
        if (eq(IIF$1, name2)) {
          if (i2 == 0) {
            this.exec(cxt, P);
            cv = P.get();
            args[i2] = cv;
          } else if (cv) {
            if (i2 == 1) {
              this.exec(cxt, P);
              args[i2] = P.get();
            }
          } else {
            if (i2 == 2) {
              this.exec(cxt, P);
              args[i2] = P.get();
            }
          }
        } else {
          if (i2 % 2 == 0) {
            this.exec(cxt, P);
            cv = TypeConvertor.toBoolean(P.get());
            args[i2] = cv;
          } else {
            if (cv) {
              this.exec(cxt, P);
              args[i2] = P.get();
              break;
            }
          }
        }
      } else {
        this.exec(cxt, P);
        args[i2] = P.get();
      }
    }
    var r = null;
    if (impl != null) {
      if (impl.length == 3) {
        r = impl(name2, newCxt, args);
      } else {
        r = impl(this, name2, newCxt, args);
      }
    } else {
      var macroCxt = newCxt;
      if (macroCxt == null) {
        macroCxt = cxt;
      }
      r = this.evalEnv.checkAndEvalMacro(macroCxt, this.scope, name2, args, cxt, obj);
    }
    p2.set(r);
  }
}
class Lexer {
  constructor(s) {
    this.s = s;
    this.len = s ? s.length : 0;
    this.li = null;
    this.lv = null;
    this.flv = null;
    this.type = -1;
    this.start = -1;
    this.pos = 0;
    this.b_skip = false;
    this.c_skip = false;
    this.obj = -1;
    this.err = -1;
    this.lastID = -1;
  }
  setContent(s) {
    this.s = s;
    this.pos = 0;
    this.len = s.length;
  }
  skipB(c) {
    var r = c;
    this.b_skip = false;
    while (c == " " || c == "	" || c == "\n" || c == "\r") {
      this.b_skip = true;
      if (this.pos < this.len) {
        c = this.s.charAt(this.pos);
      } else {
        this.err = -1;
        return r;
      }
      r = c;
      ++this.pos;
      ++this.start;
    }
    return r;
  }
  skipC(c) {
    var r = c;
    this.c_skip = false;
    if (this.pos < this.len) {
      var oldPos = this.pos;
      var oldStart = this.start;
      var found = false;
      if (c == "/") {
        if (this.pos < this.len) {
          c = this.s.charAt(this.pos);
          ++this.pos;
          ++this.start;
          if (c == "/") {
            if (this.pos < this.len) {
              c = this.s.charAt(this.pos);
              ++this.pos;
              ++this.start;
              while (c != "\n" && this.pos < this.len) {
                if (this.pos < this.len) {
                  c = this.s.charAt(this.pos);
                  ++this.pos;
                  ++this.start;
                }
              }
              if (this.pos < this.len) {
                c = this.s.charAt(this.pos);
                ++this.pos;
                ++this.start;
                r = c;
              } else {
                r = "$";
              }
              found = true;
            }
          } else if (c == "*") {
            if (this.pos < this.len) {
              c = this.s.charAt(this.pos);
              ++this.pos;
              ++this.start;
              while (true) {
                if (c == "*") {
                  if (this.pos < this.len && this.s.charAt(this.pos) == "/") {
                    ++this.pos;
                    ++this.start;
                    found = true;
                    break;
                  }
                }
                if (this.pos < this.len) {
                  c = this.s.charAt(this.pos);
                  ++this.pos;
                  ++this.start;
                } else {
                  break;
                }
              }
              if (found) {
                if (this.pos < this.len) {
                  c = this.s.charAt(this.pos);
                  ++this.pos;
                  ++this.start;
                  r = c;
                } else {
                  r = "$";
                }
              }
            }
          }
        }
      }
      if (!found) {
        this.pos = oldPos;
        this.start = oldStart;
      } else {
        this.c_skip = true;
      }
    }
    return r;
  }
  lookSemi() {
    var id = 26;
    var oldPos = this.pos;
    var c = " ";
    if (this.pos < this.len) {
      c = this.s.charAt(this.pos);
      ++this.pos;
      do {
        c = this.skipB(c);
        if (this.err == -1) {
          return -1;
        }
        c = this.skipC(c);
        c = this.skipB(c);
        if (this.err == -1) {
          return -1;
        }
      } while (this.b_skip || this.c_skip);
      if (c == "}") {
        id = 28;
        this.li = "}";
        this.lv = "}";
        return id;
      } else {
        this.pos = oldPos;
      }
    } else {
      id = -1;
    }
    return id;
  }
  lookahead(ahc) {
    var oldPos = this.pos;
    var c = " ";
    if (this.pos < this.len) {
      c = this.s.charAt(this.pos);
      ++this.pos;
      do {
        c = this.skipB(c);
        if (this.err == -1) {
          return false;
        }
        c = this.skipC(c);
        c = this.skipB(c);
        if (this.err == -1) {
          return false;
        }
      } while (this.b_skip || this.c_skip);
      if (c == ahc) {
        this.pos = oldPos;
        return true;
      } else {
        this.pos = oldPos;
      }
    }
    this.pos = oldPos;
    return false;
  }
  neg() {
    return this.lastID === -1 || this.lastID >= 0 && this.lastID <= 13 || this.lastID === 17 || this.lastID === 19;
  }
  resolveConst(t) {
    if (eq(t.toLowerCase(), "true")) {
      this.lv = "true";
      this.type = T_BOOL;
      return 16;
    } else if (eq(t.toLowerCase(), "false")) {
      this.lv = "false";
      this.type = T_BOOL;
      return 16;
    }
    return -1;
  }
  resolveID(t) {
    var idx = t.indexOf(".");
    if (idx > 0) {
      var first = t.substring(0, idx);
      var second = t.substring(idx + 1);
      this.flv = t;
      t = second;
      this.obj = first;
      this.lv = second;
    } else {
      this.obj = null;
      this.lv = t;
      this.flv = t;
    }
    var id = -1;
    if (eq(t, "if")) {
      id = 21;
    } else if (eq(t, "else")) {
      id = 22;
    } else if (eq(t, "while")) {
      id = 23;
    } else if (eq(t, "var")) {
      id = 24;
    } else if (eq(t, "return")) {
      id = 29;
    } else if (eq(t, "break")) {
      id = 30;
    } else if (eq(t, "loop")) {
      id = 31;
    } else if (eq(t, "switch")) {
      id = 33;
    } else if (eq(t, "case")) {
      id = 34;
    } else if (eq(t, "null")) {
      id = 40;
    }
    return id;
  }
  next(slAsString) {
    this.err = 0;
    this.obj = null;
    this.flv = null;
    var oldPos = this.pos;
    var id = -1;
    var c;
    this.start = this.pos;
    if (this.pos >= this.len)
      return -1;
    c = this.s.charAt(this.pos);
    ++this.pos;
    do {
      c = this.skipB(c);
      if (this.err == -1) {
        return -1;
      }
      c = this.skipC(c);
      c = this.skipB(c);
      if (this.err == -1) {
        return -1;
      }
    } while (this.b_skip || this.c_skip);
    var cnt = 1;
    switch (c) {
      case "+":
        id = 0;
        this.li = "+";
        this.lv = "+";
        break;
      case "-":
        if (this.neg()) {
          var tmpC = " ";
          if (this.pos < this.len) {
            tmpC = this.s.charAt(this.pos);
          }
          if (tmpC >= "0" && tmpC <= "9") {
            var isInt = true;
            if (this.pos < this.len) {
              c = this.s.charAt(this.pos);
            }
            while (c >= "0" && c <= "9" || c == ".") {
              if (c == ".")
                isInt = false;
              ++cnt;
              ++this.pos;
              if (this.pos >= this.len) {
                break;
              }
              c = this.s.charAt(this.pos);
            }
            id = 16;
            this.li = "const";
            this.lv = this.s.substring(this.start, this.start + cnt);
            if (isInt)
              if (this.lv.length > 10) {
                this.type = T_NUM;
              } else {
                this.type = T_INT;
              }
            else
              this.type = T_NUM;
          } else {
            id = 2;
            this.li = "-";
            this.lv = "-";
          }
        } else {
          id = 2;
          this.li = "-";
          this.lv = "-";
        }
        break;
      case "*":
        id = 3;
        this.li = "*";
        this.lv = "*";
        break;
      case "/":
        id = 4;
        this.li = "/";
        this.lv = "/";
        break;
      case "(":
        id = 17;
        this.li = "(";
        this.lv = "(";
        break;
      case "{":
        if (slAsString) {
          var deep = 1;
          do {
            if (this.pos < this.len) {
              c = this.s.charAt(this.pos);
              if (c == "{") {
                ++deep;
              } else if (c == "}") {
                --deep;
              }
              ++this.pos;
              ++cnt;
            } else {
              this.err = 1;
              return -1;
            }
          } while (c != "}" || deep != 0);
          id = 16;
          this.type = T_STR;
          this.li = "const";
          this.lv = this.s.substring(this.start + 1, this.start + cnt - 1);
        } else {
          id = 27;
          this.li = "{";
          this.lv = "{";
        }
        break;
      case ")":
        id = 18;
        this.li = ")";
        this.lv = ")";
        break;
      case "}":
        id = 28;
        this.li = "}";
        this.lv = "}";
        break;
      case ",":
        id = 19;
        this.li = ",";
        this.lv = ",";
        break;
      case ";":
        id = 26;
        this.li = ";";
        this.lv = ";";
        id = this.lookSemi();
        break;
      case "!":
        if (this.pos < this.len) {
          c = this.s.charAt(this.pos);
          if (c == "=") {
            id = 9;
            this.li = "<>";
            this.lv = "<>";
            ++this.pos;
          } else {
            id = 25;
            this.li = "!";
            this.lv = "!";
          }
        } else {
          id = 25;
          this.li = "!";
          this.lv = "!";
        }
        break;
      case "=":
        if (this.pos < this.len) {
          c = this.s.charAt(this.pos);
          if (c == "=") {
            id = 7;
            this.li = "==";
            this.lv = "==";
            ++this.pos;
          } else {
            id = 8;
            this.li = "=";
            this.lv = "=";
          }
        } else {
          id = 8;
          this.li = "=";
          this.lv = "=";
        }
        break;
      case "&":
        if (this.pos < this.len) {
          c = this.s.charAt(this.pos);
          if (c == "&") {
            id = 6;
            this.li = "&&";
            this.lv = "&&";
            ++this.pos;
          } else {
            id = 1;
            this.li = "&";
            this.lv = "&";
          }
        } else {
          id = 1;
          this.li = "&";
          this.lv = "&";
        }
        break;
      case "|":
        id = -1;
        if (this.pos < this.len) {
          c = this.s.charAt(this.pos);
          if (c == "|") {
            id = 5;
            this.li = "||";
            this.lv = "||";
            ++this.pos;
          }
        }
        break;
      case ">":
        if (this.pos < this.len) {
          c = this.s.charAt(this.pos);
          if (c == "=") {
            id = 11;
            this.li = ">=";
            this.lv = ">=";
            ++this.pos;
          } else {
            id = 10;
            this.li = ">";
            this.lv = ">";
          }
        } else {
          id = 10;
          this.li = ">";
          this.lv = ">";
        }
        break;
      case "<":
        if (this.pos < this.len) {
          c = this.s.charAt(this.pos);
          if (c == "=") {
            id = 13;
            this.li = "<=";
            this.lv = "<=";
            ++this.pos;
          } else if (c == ">") {
            id = 9;
            this.li = "<>";
            this.lv = "<>";
            ++this.pos;
          } else {
            id = 12;
            this.li = "<";
            this.lv = "<";
          }
        } else {
          id = 12;
          this.li = "<";
          this.lv = "<";
        }
        break;
      case "'":
        do {
          if (this.pos < this.len) {
            c = this.s.charAt(this.pos);
            ++this.pos;
            ++cnt;
          } else {
            this.err = 1;
            return -1;
          }
        } while (c != "'");
        id = 16;
        this.li = "const";
        this.type = T_STR;
        this.lv = this.s.substring(this.start + 1, this.start + cnt - 1);
        break;
      case '"':
        do {
          if (this.pos < this.len) {
            c = this.s.charAt(this.pos);
            ++this.pos;
            ++cnt;
          } else {
            this.err = 1;
            return -1;
          }
        } while (c != '"');
        id = 16;
        this.type = T_STR;
        this.li = "const";
        this.lv = this.s.substring(this.start + 1, this.start + cnt - 1);
        break;
      case ":":
        id = 35;
        this.li = ":";
        this.lv = ":";
        break;
      default:
        if (c >= "A" && c <= "Z" || c >= "a" && c <= "z" || c == "_") {
          var hasColon = false;
          if (this.pos < this.len) {
            c = this.s.charAt(this.pos);
            while (c >= "A" && c <= "Z" || c >= "a" && c <= "z" || c >= "0" && c <= "9" || c == "." || c == "_" || c == ":") {
              if (c == ":") {
                hasColon = true;
              }
              ++cnt;
              ++this.pos;
              if (this.pos >= this.len) {
                break;
              }
              c = this.s.charAt(this.pos);
            }
          }
          if (hasColon) {
            id = 32;
            this.li = "range";
            this.lv = this.s.substring(this.start, this.start + cnt);
          } else {
            id = 15;
            this.li = "id";
            this.lv = this.s.substring(this.start, this.start + cnt);
            var nID = -1;
            nID = this.resolveConst(this.lv);
            if (nID != -1) {
              id = nID;
              this.li = "const";
            } else {
              nID = this.resolveID(this.lv);
              if (nID != -1) {
                id = nID;
                this.li = this.lv;
              } else {
                if (this.lookahead("(")) {
                  id = 14;
                  this.li = "fun";
                }
              }
            }
          }
        } else if (c >= "0" && c <= "9") {
          var isInteger = true;
          if (this.pos < this.len) {
            c = this.s.charAt(this.pos);
            while (c >= "0" && c <= "9" || c == ".") {
              if (c == ".")
                isInteger = false;
              ++cnt;
              ++this.pos;
              if (this.pos >= this.len) {
                break;
              }
              c = this.s.charAt(this.pos);
            }
          }
          id = 16;
          if (isInteger) {
            this.type = T_INT;
          } else {
            this.type = T_NUM;
          }
          this.li = "const";
          this.lv = this.s.substring(this.start, this.start + cnt);
        }
        break;
    }
    if (this.lastID == R_BR) {
      if (id != -1 && id != SEMI && id != ELSE && id != R_BR) {
        id = SEMI;
        this.li = ";";
        this.lv = ";";
        this.pos = oldPos;
      }
    }
    this.lastID = id;
    return id;
  }
  getLexID() {
    return this.li;
  }
  getLexValue() {
    return this.lv;
  }
  getFullLexValue() {
    return this.flv;
  }
  getType() {
    return this.type;
  }
  getErr() {
    return this.err;
  }
  getObj() {
    return this.obj;
  }
}
class RefInt {
  constructor(v) {
    this.v = v;
  }
  set(v) {
    this.v = v;
  }
  get() {
    return this.v;
  }
  inc() {
    ++this.v;
  }
  dec() {
    --this.v;
  }
}
class Factor {
  constructor(id, name2, ter) {
    this.id = id;
    this.name = name2;
    this.ter = ter;
  }
  get() {
    return this.id;
  }
  isTer() {
    return this.ter;
  }
  getName() {
    return this.name;
  }
}
class ExprRule {
  constructor(idx, l, rs, closeRule) {
    this.idx = idx;
    this.l = l;
    this.rs = rs;
    this.closeRule = closeRule;
    this.flag = 0;
    this.slAsString = true;
  }
  index() {
    return this.idx;
  }
  left() {
    return this.l;
  }
  right() {
    return this.rs;
  }
  rightAt(idx) {
    return this.rs[idx];
  }
  rightLen() {
    return this.rs.length;
  }
  isClose() {
    return this.closeRule;
  }
  setFlag(flag) {
    this.flag = flag;
  }
  getFlag() {
    return this.flag;
  }
  setSLAsString(slAsString) {
    this.slAsString = slAsString;
  }
  isSLAsString() {
    return this.slAsString;
  }
}
class ParserRules {
  constructor() {
    this.SL = new Factor(SL, "SL", false);
    this.E = new Factor(E, "E", false);
    this.IF_HEAD = new Factor(IF_H, "IF_HEAD", false);
    this.IF_TAIL = new Factor(IF_T, "IF_TAIL", false);
    this.FUN_H = new Factor(FUN_H, "FUNC_HEAD", false);
    this.FUN_T = new Factor(FUN_T, "FUNC_TAIL", false);
    this.PL = new Factor(PL, "PL", false);
    this.ADD = new Factor(0, "+", true);
    this.STRCAT = new Factor(1, "&", true);
    this.SUB = new Factor(2, "-", true);
    this.MUL = new Factor(3, "*", true);
    this.DIV = new Factor(4, "/", true);
    this.OR = new Factor(5, "||", true);
    this.AND = new Factor(6, "&&", true);
    this.EQ = new Factor(7, "==", true);
    this.ASSIGN = new Factor(8, "=", true);
    this.NEQ = new Factor(9, "<>", true);
    this.GT = new Factor(10, ">", true);
    this.GT_EQ = new Factor(11, ">=", true);
    this.LT = new Factor(12, "<", true);
    this.LT_EQ = new Factor(13, "<=", true);
    this.FUN = new Factor(14, "fun", true);
    this.ID = new Factor(15, "id", true);
    this.CONST = new Factor(16, "const", true);
    this.LB = new Factor(17, "(", true);
    this.RB = new Factor(18, ")", true);
    this.COMMA = new Factor(19, ",", true);
    this.IF = new Factor(21, "if", true);
    this.ELSE = new Factor(22, "else", true);
    this.WHILE = new Factor(23, "while", true);
    this.VAR = new Factor(24, "var", true);
    this.NOT = new Factor(25, "!", true);
    this.SEMI = new Factor(26, ";", true);
    this.L_BRACE = new Factor(27, "{", true);
    this.R_BRACE = new Factor(28, "}", true);
    this.RETURN = new Factor(29, "return", true);
    this.BREAK = new Factor(30, "break", true);
    this.LOOP = new Factor(31, "loop", true);
    this.RANGE = new Factor(32, "range", true);
    this.SWITCH = new Factor(33, "switch", true);
    this.CASE = new Factor(34, "case", true);
    this.COLON = new Factor(35, ":", true);
    this.NULL = new Factor(40, "null", true);
    this.CASE_S = new Factor(58, "CASE_S", false);
    this.CASE_SL = new Factor(59, "CASE_SL", false);
    this.fMap = new Array(MAX);
    this.rs = new Array(
      // SL -> E
      this.RULE(0, true, true, this.SL, [this.E]),
      // SL -> E ; SL
      this.RULE(1, false, true, this.SL, [this.E, this.SEMI, this.SL]),
      // E -> E + E
      this.RULE(2, false, true, this.E, [this.E, this.ADD, this.E]),
      // E -> E - E
      this.RULE(3, false, true, this.E, [this.E, this.SUB, this.E]),
      // E -> E * E
      this.RULE(4, false, true, this.E, [this.E, this.MUL, this.E]),
      // E -> E / E
      this.RULE(5, false, true, this.E, [this.E, this.DIV, this.E]),
      // E -> E & E
      this.RULE(6, false, true, this.E, [this.E, this.STRCAT, this.E]),
      // E -> ( E )
      this.RULE(7, false, true, this.E, [this.LB, this.E, this.RB]),
      // E -> ! E
      this.RULE(8, false, true, this.E, [this.NOT, this.E]),
      // E -> E || E
      this.RULE(9, false, true, this.E, [this.E, this.OR, this.E]),
      // E -> E && E
      this.RULE(10, false, true, this.E, [this.E, this.AND, this.E]),
      // E -> E == E
      this.RULE(11, false, true, this.E, [this.E, this.EQ, this.E]),
      // E -> E <> E
      this.RULE(12, false, true, this.E, [this.E, this.NEQ, this.E]),
      // E -> E > E
      this.RULE(13, false, true, this.E, [this.E, this.GT, this.E]),
      // E -> E >= E
      this.RULE(14, false, true, this.E, [this.E, this.GT_EQ, this.E]),
      // E -> E < E
      this.RULE(15, false, true, this.E, [this.E, this.LT, this.E]),
      // E -> E <= E
      this.RULE(16, false, true, this.E, [this.E, this.LT_EQ, this.E]),
      // E -> const
      this.RULE(17, false, true, this.E, [this.CONST]),
      // E -> id
      this.RULE(18, false, true, this.E, [this.ID]),
      // E -> FUNC_HEAD FUNC_TAIL
      this.RULE(19, false, true, this.E, [this.FUN_H, this.FUN_T]),
      // FUNC_HEAD -> function (
      this.RULE(20, false, true, this.FUN_H, [this.FUN, this.LB]),
      // FUNC_TAIL -> )
      this.RULE(21, false, true, this.FUN_T, [this.RB]),
      // FUNC_TAIL -> PL )
      this.RULE(22, false, true, this.FUN_T, [this.PL, this.RB]),
      // PL -> E
      this.RULE(23, true, true, this.PL, [this.E]),
      // PL -> E , PL
      this.RULE(24, false, true, this.PL, [this.E, this.COMMA, this.PL]),
      // E -> var id = E
      this.RULE(25, false, true, this.E, [this.VAR, this.ID, this.ASSIGN, this.E]),
      // E -> IF_HEAD
      this.RULE(26, false, true, this.E, [this.IF_HEAD]),
      // E -> IF_HEAD IF_TAIL
      this.RULE(27, false, true, this.E, [this.IF_HEAD, this.IF_TAIL]),
      // IF_HEAD -> if ( E ) { SL }
      this.RULE(28, false, false, this.IF_HEAD, [this.IF, this.LB, this.E, this.RB, this.L_BRACE, this.SL, this.R_BRACE]),
      // IF_TAIL -> else { SL }
      this.RULE(29, false, false, this.IF_TAIL, [this.ELSE, this.L_BRACE, this.SL, this.R_BRACE]),
      // E -> while ( E ) { SL }
      this.RULE(30, false, false, this.E, [this.WHILE, this.LB, this.E, this.RB, this.L_BRACE, this.SL, this.R_BRACE]),
      // E -> E = E
      this.RULE(31, false, true, this.E, [this.E, this.ASSIGN, this.E]),
      // E -> return E
      this.RULE(32, false, true, this.E, [this.RETURN, this.E]),
      // E -> break
      this.RULE(33, false, true, this.E, [this.BREAK]),
      // E -> loop E ( E ) { SL }
      this.RULE(34, false, false, this.E, [this.LOOP, this.E, this.LB, this.E, this.RB, this.L_BRACE, this.SL, this.R_BRACE]),
      // E -> RANGE
      this.RULE(35, false, true, this.E, [this.RANGE]),
      // E -> switch ( E ) { CASE_SL }
      this.RULE(36, false, false, this.E, [this.SWITCH, this.LB, this.E, this.RB, this.L_BRACE, this.CASE_SL, this.R_BRACE]),
      // CASE_SL -> CASE_S
      this.RULE(37, false, true, this.CASE_SL, [this.CASE_S]),
      // CASE_SL -> CASE_S ; CASE_SL
      this.RULE(38, false, true, this.CASE_SL, [this.CASE_S, this.SEMI, this.CASE_SL]),
      // CASE_S -> case E : { SL }
      this.RULE(39, false, false, this.CASE_S, [this.CASE, this.E, this.COLON, this.L_BRACE, this.SL, this.R_BRACE]),
      // E -> null
      this.RULE(40, false, true, this.E, [this.NULL])
    );
  }
  first(id) {
    return this.fMap[id];
  }
  at(idx) {
    return this.rs[idx];
  }
  RULE(idx, closeRule, slAsString, l, rs) {
    var r = new ExprRule(idx, l, rs, closeRule);
    r.setSLAsString(slAsString);
    var len = rs.length;
    for (var i2 = 0; i2 < len; ++i2) {
      var rrf = rs[i2];
      if (i2 == 0 && rrf.isTer()) {
        this.fMap[rrf.get()] = r;
      }
    }
    return r;
  }
}
const ExprRules = new ParserRules();
class ExprItem {
  // 父节点
  constructor(f, r) {
    this.cl = null;
    this.obj = null;
    this.lv = null;
    this.value = null;
    this.ctrl = false;
    this.prepared = false;
    this.ah = 0;
    this.bh = 0;
    this.as = 0;
    this.bs = 0;
    this.indexInParent = 0;
    this.parent = null;
    this.f = f;
    this.r = r;
  }
  rule() {
    return this.r;
  }
  factor() {
    return this.f;
  }
  add(factor) {
    this.cl = this.cl || new Array();
    this.cl.push(factor);
    factor.setParent(this);
  }
  all() {
    return this.cl;
  }
  size() {
    return this.cl == null ? 0 : this.cl.length;
  }
  item(idx) {
    return this.cl[idx];
  }
  set(value) {
    this.value = value;
  }
  get() {
    return this.value;
  }
  setLex(lv) {
    this.lv = lv;
  }
  getLex() {
    return this.lv;
  }
  setCtrl(ctrl) {
    this.ctrl = ctrl;
  }
  isCtrl() {
    return this.ctrl;
  }
  setObj(obj) {
    this.obj = obj;
  }
  getObj() {
    return this.obj;
  }
  setChild(idx, value) {
    this.cl[idx].set(value);
  }
  setChildLex(idx, obj, lv) {
    var child = this.cl[idx];
    child.setObj(obj);
    child.setLex(lv);
  }
  setChildCtrl(idx, ctrl) {
    this.cl[idx].setCtrl(ctrl);
  }
  merge(childFactor) {
    this.r = childFactor.rule();
    this.cl = childFactor.all();
    for (var i2 = 0, size2 = this.cl.length; i2 < size2; ++i2) {
      var child = this.cl[i2];
      child.setParent(this);
    }
  }
  replace(idx, factorList) {
    this.cl.splice(idx, 1);
    var len = factorList.length;
    for (var i2 = 0; i2 < len; ++i2) {
      var child = factorList[i2];
      this.cl.splice(idx + i2, 0, child);
      child.setParent(this);
    }
  }
  setPrepared(prepared) {
    this.prepared = prepared;
  }
  isPrepared() {
    return this.prepared;
  }
  setAh(ah) {
    this.ah = ah;
  }
  getAh() {
    return this.ah;
  }
  setBh(bh) {
    this.bh = bh;
  }
  getBh() {
    return this.bh;
  }
  setAs(as) {
    this.as = as;
  }
  getAs() {
    return this.as;
  }
  setBs(bs) {
    this.bs = bs;
  }
  getBs() {
    return this.bs;
  }
  setIndexInParent(indexInParent) {
    this.indexInParent = indexInParent;
  }
  getIndexInParent() {
    return this.indexInParent;
  }
  setParent(parent2) {
    this.parent = parent2;
  }
  getParent() {
    return this.parent;
  }
  /**
   * 此函数的目的是为了建立子节点在父节点中的次序,用于在子节点向上回溯时快速获取位置.
   */
  prepare() {
    if (!this.prepared) {
      for (var i2 = 0, size2 = this.cl.length; i2 < size2; ++i2) {
        var child = this.cl[i2];
        child.setIndexInParent(i2);
      }
      this.prepared = true;
    }
  }
  /**
   * 重置as,bs两个变量的值,是用于清除执行过程中的动态环境信息,比如函数中参数的计算位置.
   */
  reset() {
    this.as = -1;
    this.bs = -1;
  }
}
class ExprRuleTrace {
  constructor(r) {
    this.p = -1;
    this.r = r;
  }
  rule() {
    return this.r;
  }
  pos() {
    return this.p;
  }
  matched() {
    return this.p == this.r.rightLen() - 1;
  }
  consum() {
    ++this.p;
    return this.p;
  }
  match(li) {
    var rf = this.r.rightAt(this.pos() + 1);
    return rf.get() == li;
  }
  left() {
    return this.r.left().get();
  }
  isClose() {
    return this.r.isClose();
  }
  print() {
    var left = this.r.left();
    left.getName();
    var rightString = null;
    var vRight = this.r.right();
    var length2 = vRight.length;
    for (var i2 = 0; i2 < length2; ++i2) {
      if (rightString == null) {
        rightString = vRight[i2].getName();
      } else {
        rightString += " " + vRight[i2].getName();
      }
      if (this.p == i2) {
        rightString += " ^ ";
      }
    }
    if (this.p == -1)
      ;
  }
}
class Parser {
  constructor(implMap) {
    this.implMap = implMap;
  }
  eval(env, script, tree, cxt, scope) {
    var r = null;
    if (this.parse(script, tree)) {
      tree.opti();
      var evaluator = new Evaluator(this.implMap, env, tree, scope);
      evaluator.eval(cxt);
      r = tree.get().get();
    }
    return r;
  }
  evalByTree(env, tree, cxt, scope) {
    var evaluator = new Evaluator(this.implMap, env, tree, scope);
    evaluator.eval(cxt);
    return tree.get().get();
  }
  slAsString(top) {
    return top != null ? top.rule().isSLAsString() : true;
  }
  printStack(stack) {
    {
      return;
    }
  }
  parse(script, tree) {
    var lex = new Lexer(script);
    var rules = ExprRules;
    var obj = null;
    var lv = null;
    var li = lex.next(true);
    var oli = -1;
    obj = lex.getObj();
    lv = lex.getLexValue();
    var dataType = lex.getType();
    var topTrace = null;
    var delayTrace = null;
    var curTrace = null;
    var successed = false;
    var refLexID = new RefInt(-1);
    var delayID = -1;
    var consumPos = -1;
    var handled = false;
    var finish = li == -1;
    var stack = new Stack();
    while (!finish) {
      handled = false;
      if (delayTrace != null) {
        if (this.pre(rules, stack, tree, delayTrace, delayID)) {
          delayTrace = null;
          handled = true;
        }
      }
      topTrace = stack.empty() ? null : stack.peek();
      this.printStack(stack);
      refLexID.set(li);
      oli = li;
      var needPre = this.checkPre(stack, topTrace, refLexID, tree, lv);
      li = refLexID.get();
      if (li == -1) {
        li = lex.next(this.slAsString(topTrace));
        obj = lex.getObj();
        lv = lex.getLexValue();
        dataType = lex.getType();
        delayID = li;
        finish = li == -1;
        if (oli != -1 || li != -1) {
          handled = true;
        }
      }
      if (needPre) {
        var predictRule = rules.first(li);
        if (predictRule != null) {
          var preTrace = new ExprRuleTrace(predictRule);
          stack.push(preTrace);
          topTrace = preTrace;
          consumPos = preTrace.consum();
          var terFactor = this.putToTree(tree, preTrace);
          this.dealLex(li, terFactor, consumPos, dataType, obj, lv);
          li = lex.next(this.slAsString(topTrace));
          obj = lex.getObj();
          lv = lex.getLexValue();
          dataType = lex.getType();
          finish = li == -1;
          this.printStack(stack);
          delayTrace = null;
          handled = true;
        } else {
          if (topTrace != null && topTrace.matched()) {
            delayTrace = topTrace;
            delayID = li;
            this.printStack(stack);
          } else {
            throw new Error("无效输入: " + lv);
          }
        }
      }
      if (topTrace.matched()) {
        curTrace = topTrace;
        stack.pop();
        if (li != -1 && this.needMore(rules, stack, topTrace, li)) {
          stack.push(curTrace);
          delayTrace = curTrace;
          delayID = li;
          handled = true;
          this.printStack(stack);
        } else {
          var fullMatched = false;
          var consumed = false;
          if (!stack.empty()) {
            topTrace = stack.peek();
            if (!topTrace.matched() && topTrace.match(curTrace.left())) {
              consumed = true;
              this.consum(tree, topTrace, curTrace);
              curTrace = topTrace;
              stack.pop();
              this.printStack(stack);
              while (curTrace.matched()) {
                if (li != -1 && this.needMore(rules, stack, curTrace, li)) {
                  delayTrace = curTrace;
                  delayID = li;
                  handled = true;
                  this.printStack(stack);
                  break;
                }
                if (!stack.empty()) {
                  topTrace = stack.peek();
                  if (li != -1 && this.needMore(rules, stack, curTrace, li)) {
                    stack.push(curTrace);
                    break;
                  }
                  if (topTrace.match(curTrace.left())) {
                    this.consum(tree, topTrace, curTrace);
                    curTrace = topTrace;
                    stack.pop();
                    this.printStack(stack);
                  } else {
                    break;
                  }
                } else {
                  fullMatched = true;
                  stack.push(curTrace);
                  break;
                }
              }
            }
          }
          if (!consumed) {
            if (delayTrace != null && !handled) {
              throw new Error("无效输入: " + lv);
            }
            stack.push(curTrace);
            delayTrace = curTrace;
            delayID = li;
            this.printStack(stack);
          } else {
            if (!fullMatched) {
              stack.push(curTrace);
              delayTrace = curTrace;
              delayID = li;
            } else {
              successed = true;
              if (li == -1) {
                li = lex.next(this.slAsString(topTrace));
                lv = lex.getLexValue();
                dataType = lex.getType();
              }
              if (li != -1) {
                topTrace = stack.pop();
                if (this.needMore(rules, stack, topTrace, li)) {
                  stack.push(topTrace);
                  delayTrace = topTrace;
                  delayID = li;
                  this.printStack(stack);
                } else {
                  successed = false;
                  this.moreInput(rules, stack, li, lv);
                  break;
                }
              } else {
                break;
              }
            }
          }
        }
      }
      if (li == -1) {
        li = lex.next(this.slAsString(topTrace));
        obj = lex.getObj();
        lv = lex.getLexValue();
        dataType = lex.getType();
        delayID = li;
        finish = li == -1;
        if (li == -1) {
          if (!stack.empty()) {
            topTrace = stack.peek();
            if (!topTrace.matched()) {
              this.notMatch(rules, stack);
              break;
            } else {
              if (stack.size() == 1) {
                successed = true;
                break;
              } else if (delayTrace != null) {
                finish = false;
              }
            }
          }
        }
      }
    }
    if (successed) {
      tree.extract();
    }
    return successed;
  }
  dealLex(li, factor, pos, dataType, obj, lv) {
    factor.setChildLex(pos, obj, lv);
    if (li == 14) {
      if (eq(IIF$1, lv) || eq(IIFS$1, lv)) {
        factor.setChildCtrl(pos, true);
      }
    }
    switch (li) {
      case 16:
        {
          var value = null;
          switch (dataType) {
            case T_BOOL:
              {
                value = eq("true", lv);
              }
              break;
            case T_INT:
              {
                value = parseInt(lv == null ? 0 : lv);
              }
              break;
            case T_NUM:
              {
                value = new Decimal(lv == null ? 0 : lv);
              }
              break;
            case T_STR:
              {
                value = lv;
              }
              break;
          }
          factor.setChild(pos, value);
        }
        break;
      case 32:
        {
          factor.setChild(pos, lv);
        }
        break;
    }
  }
  putToTree(tree, ruleTrace) {
    var r = ruleTrace.rule();
    var factor = new ExprItem(r.left(), r);
    var rs = r.right();
    var length2 = rs.length;
    for (var i2 = 0; i2 < length2; ++i2) {
      var childFactor = new ExprItem(rs[i2]);
      factor.add(childFactor);
    }
    tree.push(factor);
    return factor;
  }
  pre(rules, stack, tree, delayTrace, fid) {
    var result = false;
    stack.pop();
    var topFactor = tree.pop();
    var delayRule = this.resolveDelay(rules, stack, delayTrace, fid);
    if (delayRule != null) {
      var ruleTrace = new ExprRuleTrace(delayRule);
      stack.push(ruleTrace);
      this.putToTree(tree, ruleTrace);
      tree.push(topFactor);
      this.consum(tree, ruleTrace, delayTrace);
      result = true;
    } else {
      stack.push(delayTrace);
      tree.push(topFactor);
      result = false;
    }
    return result;
  }
  notMatch(rules, stack) {
  }
  moreInput(rules, stack, li, lv) {
  }
  checkPre(stack, topTrace, li, tree, lv) {
    var b = true;
    if (topTrace != null) {
      if (!topTrace.matched()) {
        if (topTrace.match(li.get())) {
          var cpos = topTrace.consum(li.get());
          var ti = tree.peek();
          ti.setChildLex(cpos, null, lv);
          li.set(-1);
          b = false;
        }
      } else {
        if (topTrace.isClose() || li.get() == -1) {
          b = false;
        }
      }
    }
    return b;
  }
  resolveDelay(rules, stack, delayRule, li) {
    var factorID = delayRule.left();
    var rule = null;
    if (delayRule.matched()) {
      switch (factorID) {
        case E:
          {
            switch (li) {
              case SEMI:
                rule = rules.at(1);
                break;
              case ADD:
                rule = rules.at(2);
                break;
              case SUB:
                rule = rules.at(3);
                break;
              case MUL:
                rule = rules.at(4);
                break;
              case DIV:
                rule = rules.at(5);
                break;
              case STRCAT:
                rule = rules.at(6);
                break;
              case OR:
                rule = rules.at(9);
                break;
              case AND:
                rule = rules.at(10);
                break;
              case EQ:
                rule = rules.at(11);
                break;
              case NEQ:
                rule = rules.at(12);
                break;
              case GT:
                rule = rules.at(13);
                break;
              case GT_EQ:
                rule = rules.at(14);
                break;
              case LT:
                rule = rules.at(15);
                break;
              case LT_EQ:
                rule = rules.at(16);
                break;
              case COMMA:
                rule = rules.at(24);
                break;
              case ASSIGN:
                rule = rules.at(31);
                break;
              case RB:
                {
                  if (delayRule.rule().index() == 7) {
                    rule = null;
                  } else {
                    rule = rules.at(23);
                  }
                }
                break;
              default:
                rule = rules.at(0);
                break;
            }
          }
          break;
        case FUN_H:
          {
            rule = rules.at(19);
          }
          break;
        case PL:
          {
            if (li == RB) {
              rule = rules.at(22);
            }
          }
          break;
        case IF_H:
          if (li == ELSE) {
            rule = rules.at(27);
          } else {
            rule = rules.at(26);
          }
          break;
        case CASE_S:
          if (li == SEMI) {
            rule = rules.at(38);
          } else {
            rule = rules.at(37);
          }
          break;
      }
    }
    return rule;
  }
  needMore(rules, stack, r, li) {
    var tr = null;
    if (!stack.empty()) {
      tr = stack.peek().rule();
    }
    var has2 = false;
    switch (r.left()) {
      case E:
        switch (li) {
          case 26:
            has2 = true;
            if (tr != null) {
              switch (tr.index()) {
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 9:
                case 10:
                case 11:
                case 12:
                case 13:
                case 14:
                case 15:
                case 16:
                case 24:
                case 25:
                case 31:
                  has2 = false;
                  break;
              }
            }
            break;
          case 0:
          case 2:
            has2 = true;
            if (tr != null) {
              switch (tr.index()) {
                case 2:
                case 3:
                case 4:
                case 5:
                  has2 = false;
                  break;
              }
            }
            break;
          case 3:
          case 4:
            has2 = true;
            if (tr != null) {
              switch (tr.index()) {
                case 4:
                case 5:
                  has2 = false;
              }
            }
            break;
          case 1:
            has2 = true;
            break;
          case 5:
            has2 = true;
            if (tr != null) {
              switch (tr.index()) {
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 8:
                case 9:
                case 10:
                case 11:
                case 12:
                case 13:
                case 14:
                case 15:
                case 16:
                  has2 = false;
                  break;
              }
            }
            break;
          case 6:
            has2 = true;
            if (tr != null) {
              switch (tr.index()) {
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 8:
                case 10:
                case 11:
                case 12:
                case 13:
                case 14:
                case 15:
                case 16:
                  has2 = false;
                  break;
              }
            }
            break;
          case 7:
          case 9:
          case 10:
          case 11:
          case 12:
          case 13:
            has2 = true;
            if (tr != null) {
              switch (tr.index()) {
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                  has2 = false;
                  break;
              }
            }
            break;
          case 19:
            has2 = true;
            if (tr != null) {
              switch (tr.index()) {
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 8:
                case 9:
                case 10:
                case 11:
                case 12:
                case 13:
                case 14:
                case 15:
                case 16:
                case 31:
                  has2 = false;
                  break;
              }
            }
            break;
          case 8:
            has2 = true;
            break;
        }
        break;
    }
    return has2;
  }
  consum(tree, srt, ft) {
    srt.consum(ft.left());
    var pos = srt.pos();
    var ff = tree.pop();
    var sf = tree.peek();
    var cf = sf.item(pos);
    cf.merge(ff);
  }
}
class Expr_Tree {
  constructor() {
    this.stack = new Stack();
    this.root = null;
  }
  get() {
    return this.root;
  }
  push(factor) {
    this.stack.push(factor);
  }
  peek() {
    return this.stack.peek();
  }
  pop() {
    return this.stack.pop();
  }
  extract() {
    if (!this.stack.empty()) {
      this.root = this.stack.pop();
    }
  }
  opti1(p2) {
    var SL2 = p2.item(2);
    p2.replace(2, SL2.all());
  }
  opti19(p2) {
    var FT = p2.item(1);
    p2.replace(1, FT.all());
    var FH = p2.item(0);
    p2.replace(0, FH.all());
  }
  opti22(p2) {
    var PL2 = p2.item(0);
    p2.replace(0, PL2.all());
  }
  opti23(p2) {
    var PL2 = p2.item(2);
    p2.replace(2, PL2.all());
  }
  opti26(p2) {
    var IH = p2.item(0);
    p2.replace(0, IH.all());
  }
  opti27(p2) {
    var IT = p2.item(1);
    p2.replace(1, IT.all());
    var IH = p2.item(0);
    p2.replace(0, IH.all());
  }
  opti36(p2) {
    var CASE_SL = p2.item(5);
    p2.replace(5, CASE_SL.all());
  }
  opti38(p2) {
    var CASE_SL = p2.item(2);
    p2.replace(2, CASE_SL.all());
  }
  optiItem(p2) {
    var r = p2.rule();
    if (r == null) {
      return;
    }
    var childList = p2.all();
    if (childList != null) {
      var childFactor = null;
      var len = childList.length;
      for (var i2 = 0; i2 < len; ++i2) {
        childFactor = childList[i2];
        this.optiItem(childFactor);
      }
    }
    var ruleIndex = r.index();
    switch (ruleIndex) {
      case 1:
        this.opti1(p2);
        break;
      case 19:
        this.opti19(p2);
        break;
      case 22:
        this.opti22(p2);
        break;
      case 24:
        this.opti23(p2);
        break;
      case 26:
        this.opti26(p2);
        break;
      case 27:
        this.opti27(p2);
        break;
      case 36:
        this.opti36(p2);
        break;
      case 38:
        this.opti38(p2);
        break;
    }
  }
  opti() {
    this.optiItem(this.root);
  }
}
class HashMap {
  constructor() {
    this.size = 0;
    this.table = new Object();
  }
  put(key, value) {
    var added = false;
    if (!this.containsKey(key)) {
      ++this.size;
      added = true;
    }
    this.table[key] = value;
    return added;
  }
  get(key) {
    let ret = this.table[key];
    if (ret === void 0) {
      return null;
    }
    return ret;
  }
  remove(key) {
    if (this.containsKey(key) && delete this.table[key]) {
      --this.size;
    }
  }
  containsKey(key) {
    return this.table.hasOwnProperty(key);
  }
  keys() {
    var keys = new Array();
    for (var prop in this.table) {
      keys.push(prop);
    }
    return keys;
  }
  empty() {
    return this.size == 0;
  }
  clear() {
    this.size = 0;
    this.table = new Object();
  }
}
class Heap {
  constructor() {
    this.varMap = new HashMap();
  }
  put(name2, value) {
    this.varMap.put(name2, value);
  }
  get(name2) {
    return this.varMap.get(name2);
  }
  contains(name2) {
    return this.varMap.containsKey(name2);
  }
}
class Scope {
  constructor(parent2) {
    this.heap = new Heap();
    this.parent = parent2;
  }
  getHeap() {
    return this.heap;
  }
  getParent() {
    return this.parent;
  }
  addPara(key, value) {
    if (this.paras == null) {
      this.paras = new HashMap();
    }
    this.paras.put(key, value);
  }
  getPara(key) {
    return this.paras != null ? this.paras.get(key) : null;
  }
}
class NullEnv {
  constructor() {
  }
  get(cxt, id, scope, obj) {
    return null;
  }
  set(cxt, id, value, scope, obj) {
  }
  checkMacro(cxt, name2) {
  }
  evalMacro(cxt, scope, name2, macro, args) {
  }
  checkAndEvalMacro(macroCxt, scope, name2, args, cxt, obj) {
  }
  getLoop(cxt, name2, loop, obj) {
  }
  resolveObject(self, scope, obj) {
  }
  evalObject(cxt, obj, name2, args) {
  }
  evalFuncImpl(cxt, scope, obj, name2) {
  }
}
class HashMapIgnoreCase {
  constructor() {
    this.size = 0;
    this.table = new Object();
  }
  put(key, value) {
    key = key.toLowerCase();
    var added = false;
    if (!this.__containsKey(key)) {
      ++this.size;
      added = true;
    }
    this.table[key] = value;
    return added;
  }
  get(key) {
    if (key === null || key === void 0)
      return null;
    key = key.toLowerCase();
    let ret = this.table[key];
    if (ret === void 0) {
      return null;
    }
    return ret;
  }
  remove(key) {
    if (key === null || key === void 0)
      return;
    key = key.toLowerCase();
    if (this.__containsKey(key) && delete this.table[key]) {
      --this.size;
    }
  }
  __containsKey(key) {
    return this.table.hasOwnProperty(key);
  }
  containsKey(key) {
    if (key === null || key === void 0)
      return null;
    key = key.toLowerCase();
    return this.__containsKey(key);
  }
  keys() {
    var keys = new Array();
    for (var prop in this.table) {
      keys.push(prop);
    }
    return keys;
  }
  empty() {
    return this.size == 0;
  }
  clear() {
    this.size = 0;
    this.table = new Object();
  }
}
const NoTableData = "表{1}无关联数据";
const NoBindingTableData = "组件{1}关联的表{2}无数据";
const NoPrintTemplateDefined = "表单{1}无打印模板定义";
const CircleDependency = "表单{1}存在循环计算";
const GridExpandOrGroupInGridPage = "表格有行列拓展或者分组;不允许分页";
const ExistGroupRowInGridPage = "表格分页情况下存在分组行（汇总行）";
const DefaultFormulaValueExistBothInCellAndEmb = "表格行单元格与子表单同时定义了计算表达式";
const OuterColumnMustBeTitle = "有列拓展的列最外层的列需要定义为title类型";
const UndefinedPageLoadType = "分页类型定义错误";
const UnableToGetCellBehavior = "无法获取表格单元格的动态行为";
const CheckRuleNotPass = "组件{1}检查规则不通过";
const EmbedSubBindingError = "表格子表单定义错误";
const FormulaIdentifierError = "表达式标识符定义错误";
const DataBindingError = "组件数据绑定错误;未找到对应数据源";
const NoRowSelected = "表格未选定行";
const SequenceNoDefine = "序号列未定义";
const LayerOrHiddenNoDefine = "配置错误;表格层次数据显示时;Layer及Hidden字段必须同时存在";
const ShowLayerDataNotAllowGridExpand = "表格层次数据显示，不支持列扩展";
const RequiredError = "{1} 不能为空";
const InfinityError = "{1} 有除零错";
const NoComponentFound = "组件未定义";
const ForeignFieldsInequality = "过滤关联的源字段与目标字段个数不一致";
const NoTableFound = "未找到数据表";
const NoEmptyRowFound = "下推的目标单中的表格未找到空白行";
const GridTreeColumnDefineError = "表格树形列类型定义错误";
const UndefinedRowExpandType = "未定义的行拓展类型";
const RefOperationNotDefined = "表单{1}引用的操作{2}未定义";
const NoDetailRowDefine = "表格未定义明细行";
const ComponentNotExists = "{1} 不存在";
const NoRefDetailTableKeyDefine = "定制单元格表单的数据源未定义RefDetailTableKey";
const NoRefTableKeyDefine = "表格行的子明细表单的数据源未定义RefTableKey";
const NoExpandSourceGet = "列拓展自定义的拓展来源未计算出结果;请检查配置";
const UndefinedSubDetailLinkType = "未定义的子明细关联方式";
const NoSubDetailsInEmptyRow = "请先编辑表格数据行;再输入子明细";
const NoGridOrListViewFound = "未找到对应的表格或者ListView";
const CellMergeDefineError = "合并单元格定义的行类型不一致";
const SourceTypeDefineError = "下拉项来源定义错误";
const NoCellCannotSetValue = "非单元格无法设值";
const CannnotGetNoCellValue = "无法获取非单元格值";
const CompdictCannotSetMultidict = "复合字典{1}不能设定为多选字典.";
const DynamicdictItemkeyNull = "动态字典{1}的itemKey字段为空";
const CompdictItemkeyNull = "复合字典{1}的itemKey字段为空";
const NoComponent = "tagName为{1}的控件不存在！";
const NoWidthOrHeight = "宽度或高度未定义";
const NoKeyTargetBill = "下推的目标单据的key为空!";
const ExceedValueMaxAccuracy = "超出最大数值精度！";
const DateDiffParamError = "DateDiff公式传入参数有误;请检查配置!";
const NoComponentKey = "控件{1}未找到，请确认配置";
const PrimaryKeyError = "表格{1}数据表未定义业务关键字或者有数据重复";
const TypeFormulaNeeded = "动态单元格需要定义类型表达式";
const TypeGroupUnDefined = "表单{1}没有动态单元格相关定义";
const TypeDefUnDefined = "与{1}匹配的动态单元格定义未找到";
const TypeDefKeyColumnUndefined = "动态单元格标识列{1}未定义";
const TypeDefKeyEmpty = "数据中动态单元格标识为空";
const UnknownDetailType = "未知的明细数据类型{1}";
const ExpandSourceUndefined = "表格列{1}未定义拓展源;无法确定拓展类型";
const ExpandColumnKeyUndefined = "表格列 {1}未定义拓展数据源";
const ViewFormOnly = "方法{1}只在View类型的表单下适用";
const DeleteRowWithSubDetail = "确定删除当前行及其子明细数据?";
const DeleteRowWithChildRows = "确定删除当前行及其子行数据?";
const DeleteAllSelectRows = "确定删除所有选中行?";
const ConfirmClose = "是否确定关闭当前界面 ?";
const UnSupportRowExpandType = "不支持的行拓展类型 {1}";
const NoEntryRights = "无菜单入口权限 {1}";
const ListViewNotFound = "叙事簿未找到ListView组件";
const ItemKeyColumnUndefined = "动态字典或复合字典{1}数据源ItemKey列未定义";
const DictDataError = "字典{1}值类型错误;普通字典为long;多选字典为String";
const AttachmentExceedMaxSize = "上传的文件大小超出最大值限制{1}KB";
const ConnectFailed = "连接服务器失败;请检查网络连接;并尝试重新连接";
const FormCheckError = "{1} 有错误";
const GridRowError = "{1} 第 {2} 行有错误 {3}";
const GridCellError = "{1} 第 {2} 行 {3} 有错误 {4}";
const GridCellRequired = "{1} 第 {2} 行 {3} 必填";
const GridCellInfinity = "{1} 第 {2} 行 {3} 除零错误";
const VeCannotNull = "ve不能为空";
const NoLoadHandlerClass = "{1}没有载入处理类";
const DictRootNodeCalcError = "字典根节点计算错误";
const ItemkeyNotAgreeWithCurrent = "字典根节点itemKey{1}与当前字典itemKey{2}不一致";
const ItemkeyNoCompDict = "itemkey= {1}不是复合字典";
const NoDict = "ItemKey= {1}的字典不存在/NoDict= ";
const NoComponentBuilderClass = "{1};{2} 没有对应的组件创建类";
const UnitNotSupportType = "IUnitConverter 不支持的类型={1}";
const NotSupportType = "不支持的类型={1}/NotSupportType= ";
const DictInputValueTypeError = "字典控件传入的值类型错误={1}";
const TimeError = "错误的时间={1}/TimeError= ";
const filterDependenceUntreatedType = "filterDependence中未处理的类型={1} ";
const CompDictNotDataBinding = "多选复合字典={1} 不允许有数据绑定字段";
const UnEqualParamNum = "{1} 参数个数不一致";
const AttachmentTypeError = "附件类型 {1} 不在可以上传的类型内";
const RadioButtonNoGroupKey = "单选按钮 {1} 的所属组的标识未定义";
const BuddyKeyNotExists = "伙伴组件{1}不存在";
const UndefinedComponentType = "没有定义的控件类型{1}";
const SubDetailBindingError = "表格子表单定义错误";
const CompdictNotDataBinding = "多选复合字典不允许有数据绑定字段";
const DataRowNoPrimaryKeys = "数据表 {1} 后台分页有选择字段行需要唯一标识,OID或者数据源业务主键";
const FormSerializationError = "表单序列化错误";
const FormUndefined = "表单未定义";
const StringTable$2 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  AttachmentExceedMaxSize,
  AttachmentTypeError,
  BuddyKeyNotExists,
  CannnotGetNoCellValue,
  CellMergeDefineError,
  CheckRuleNotPass,
  CircleDependency,
  CompDictNotDataBinding,
  CompdictCannotSetMultidict,
  CompdictItemkeyNull,
  CompdictNotDataBinding,
  ComponentNotExists,
  ConfirmClose,
  ConnectFailed,
  DataBindingError,
  DataRowNoPrimaryKeys,
  DateDiffParamError,
  DefaultFormulaValueExistBothInCellAndEmb,
  DeleteAllSelectRows,
  DeleteRowWithChildRows,
  DeleteRowWithSubDetail,
  DictDataError,
  DictInputValueTypeError,
  DictRootNodeCalcError,
  DynamicdictItemkeyNull,
  EmbedSubBindingError,
  ExceedValueMaxAccuracy,
  ExistGroupRowInGridPage,
  ExpandColumnKeyUndefined,
  ExpandSourceUndefined,
  ForeignFieldsInequality,
  FormCheckError,
  FormSerializationError,
  FormUndefined,
  FormulaIdentifierError,
  GridCellError,
  GridCellInfinity,
  GridCellRequired,
  GridExpandOrGroupInGridPage,
  GridRowError,
  GridTreeColumnDefineError,
  InfinityError,
  ItemKeyColumnUndefined,
  ItemkeyNoCompDict,
  ItemkeyNotAgreeWithCurrent,
  LayerOrHiddenNoDefine,
  ListViewNotFound,
  NoBindingTableData,
  NoCellCannotSetValue,
  NoComponent,
  NoComponentBuilderClass,
  NoComponentFound,
  NoComponentKey,
  NoDetailRowDefine,
  NoDict,
  NoEmptyRowFound,
  NoEntryRights,
  NoExpandSourceGet,
  NoGridOrListViewFound,
  NoKeyTargetBill,
  NoLoadHandlerClass,
  NoPrintTemplateDefined,
  NoRefDetailTableKeyDefine,
  NoRefTableKeyDefine,
  NoRowSelected,
  NoSubDetailsInEmptyRow,
  NoTableData,
  NoTableFound,
  NoWidthOrHeight,
  NotSupportType,
  OuterColumnMustBeTitle,
  PrimaryKeyError,
  RadioButtonNoGroupKey,
  RefOperationNotDefined,
  RequiredError,
  SequenceNoDefine,
  ShowLayerDataNotAllowGridExpand,
  SourceTypeDefineError,
  SubDetailBindingError,
  TimeError,
  TypeDefKeyColumnUndefined,
  TypeDefKeyEmpty,
  TypeDefUnDefined,
  TypeFormulaNeeded,
  TypeGroupUnDefined,
  UnEqualParamNum,
  UnSupportRowExpandType,
  UnableToGetCellBehavior,
  UndefinedComponentType,
  UndefinedPageLoadType,
  UndefinedRowExpandType,
  UndefinedSubDetailLinkType,
  UnitNotSupportType,
  UnknownDetailType,
  VeCannotNull,
  ViewFormOnly,
  filterDependenceUntreatedType
}, Symbol.toStringTag, { value: "Module" }));
const NO_TABLE_DATA = 1;
const NO_BINDING_TABLE_DATA = 2;
const NO_PRINT_TEMPLATE_DEFINED = 3;
const CIRCLE_DEPENDENCY = 4;
const GRID_EXPAND_OR_GROUP_IN_GRID_PAGE = 5;
const EXIST_GROUPROW_IN_GRIDPAGE = 6;
const DATAROW_NO_PRIMARYKEYS$1 = 7;
const OUTER_COLUMN_MUSTBE_TITLE = 8;
const UNDEFINED_COMPONENT_TYPE = 9;
const UNDEFINED_PAGE_LOAD_TYPE = 10;
const UNABLE_TO_GET_CELL_BEHAVIOR = 11;
const COMPONENT_CHECK_ERROR$1 = 12;
const SUB_DETAIL_BINDING_ERROR = 13;
const FORMULA_IDENTIFIER_ERROR = 14;
const DATA_BINDING_ERROR$1 = 15;
const NO_ROW_SELECTED = 16;
const SEQUENCE_NO_DEFINE = 17;
const LAYER_OR_HIDDEN_NO_DEFINE = 18;
const SHOW_LAYERDATA_NOTALLOW_GRID_EXPAND = 19;
const COMPONENT_REQUIRED$1 = 20;
const NO_COMPONENT_FOUND = 21;
const NO_TABLE_FOUND = 22;
const FOREIGN_FIELDS_INEQUALITY = 23;
const NO_EMPTY_ROW_FOUND = 24;
const GRID_TREE_COLUMN_DEFINE_ERROR = 25;
const UNDEFINED_ROW_EXPAND_TYPE = 26;
const NO_DETAIL_ROW_DEFINE = 28;
const COMPONENT_NOT_EXISTS$1 = 29;
const NO_REFDETAILTABLEKEY_DEFINE = 30;
const NO_REFTABLEKEY_DEFINE = 31;
const NO_EXPANDSOURCE_RESULT_GET = 32;
const UNDEFINED_SUBDETAIL_LINKTYPE = 33;
const NO_SUBDETAILS_IN_EMPTYROW = 34;
const NO_GRID_OR_LISTVIEW_FOUND = 35;
const NO_CELL_CANNOT_SET_VALUE = 36;
const CANNNOT_GET_NO_CELL_VALUE = 38;
const COMPDICT_CANNOT_SET_MULTIDICT$1 = 39;
const DYNAMICDICT_ITEMKEY_NULL$1 = 50;
const COMPDICT_ITEMKEY_NULL$1 = 51;
const NO_COMPONENT = 52;
const NO_WIDTH_OR_HEIGHT = 53;
const NO_KEY_TARGET_BILL = 54;
const Exceed_Value_Max_Accuracy = 55;
const Date_Diff_Param_Error$1 = 56;
const NO_COMPONENT_KEY = 57;
const CELL_MERGE_DEFINE_ERROR = 58;
const SOURCETYPE_DEFINE_ERROR = 59;
const PRIMARYKEYS_ERROR$1 = 60;
const TYPE_FORMULA_NEEDED = 61;
const TYPE_GROUP_UNDEFINED = 62;
const TYPE_DEF_UNDEFINED = 63;
const TYPE_DEF_KEYCOLUMN_UNDEFINED = 64;
const TYPEDEFKEY_EMPTY = 65;
const UNKNOWN_DETAIL_TYPE = 66;
const EXPAND_SOURCE_UNDEFINED = 67;
const EXPAND_COLUMNKEY_UNDEFIND = 68;
const VIEW_FORM_ONLY = 80;
const UNSUPPORT_ROWEXPAND_TYPE = 81;
const LISTVIEW_NOT_FOUND_IN_VIEW = 82;
const NO_ENTRYRIGHTS = 83;
const ITEMKEY_COLUMN_UNDEFINED = 84;
const DICT_DATA_ERROR = 85;
const CONNECT_FAILED = 87;
const FORM_CHECK_ERROR$1 = 88;
const GRID_ROW_ERROR$1 = 89;
const GRID_CELL_ERROR$1 = 100;
const GRID_CELL_REQUIRED$1 = 101;
const VE_CANNOT_NULL = 102;
const NO_LOAD_HANDLER_CLASS = 103;
const DICT_ROOT_NODE_CALC_ERROR = 104;
const ITEMKEY_NOT_AGREE_WITH_CURRENT = 105;
const ITEMKEY_NO_COMPDICT = 106;
const NO_DICT = 107;
const NO_COMPONENT_BUILDER_CLASS = 108;
const NOT_SUPPORT_TYPE = 109;
const DICT_INPUT_VALUE_TYPE_ERROR = 110;
const TIME_ERROR = 111;
const FILTER_DEPEND_UNTREATED_TYPE = 112;
const COMPDICT_NOT_DATA_BINDING = 113;
const UNEQUAL_PARAM_NUM$2 = 114;
const RADIOBUTTON_NO_GROUPKEY = 117;
const BUDDYKEY_NOT_EXISTS = 118;
const MAP_MISS_FORMKEY$1 = 30;
const GRID_CELL_INFINITY$1 = 31;
const FORM_SERIALIZATION_ERROR$1 = 512;
const FORM_UNDEFINED = 513;
const COMPONENT_INFINITY$1 = 514;
const formatMessage$3 = (code, ...args) => {
  var msg = errorInfoLang$2.get(code);
  if (!msg) {
    msg = I18N.getString("key", errorInfo$3.get(code));
  }
  msg = Utils.format(msg, args);
  return msg;
};
const errorInfo$3 = new HashMap();
const errorInfoLang$2 = new HashMap();
const regErrorInfo$2 = (info, map2) => {
  info.put(NO_TABLE_DATA, map2.NoTableData);
  info.put(NO_BINDING_TABLE_DATA, map2.NoBindingTableData);
  info.put(NO_PRINT_TEMPLATE_DEFINED, map2.NoPrintTemplateDefined);
  info.put(CIRCLE_DEPENDENCY, map2.CircleDependency);
  info.put(GRID_EXPAND_OR_GROUP_IN_GRID_PAGE, map2.GridExpandOrGroupInGridPage);
  info.put(EXIST_GROUPROW_IN_GRIDPAGE, map2.ExistGroupRowInGridPage);
  info.put(OUTER_COLUMN_MUSTBE_TITLE, map2.OuterColumnMustBeTitle);
  info.put(UNDEFINED_COMPONENT_TYPE, map2.UndefinedComponentType);
  info.put(UNDEFINED_PAGE_LOAD_TYPE, map2.UndefinedPageLoadType);
  info.put(UNABLE_TO_GET_CELL_BEHAVIOR, map2.UnableToGetCellBehavior);
  info.put(COMPONENT_CHECK_ERROR$1, map2.CheckRuleNotPass);
  info.put(SUB_DETAIL_BINDING_ERROR, map2.SubDetailBindingError);
  info.put(FORMULA_IDENTIFIER_ERROR, map2.FormulaIdentifierError);
  info.put(DATA_BINDING_ERROR$1, map2.DataBindingError);
  info.put(NO_ROW_SELECTED, map2.NoRowSelected);
  info.put(SEQUENCE_NO_DEFINE, map2.SequenceNoDefine);
  info.put(LAYER_OR_HIDDEN_NO_DEFINE, map2.LayerOrHiddenNoDefine);
  info.put(SHOW_LAYERDATA_NOTALLOW_GRID_EXPAND, map2.ShowLayerDataNotAllowGridExpand);
  info.put(COMPONENT_REQUIRED$1, map2.RequiredError);
  info.put(COMPONENT_INFINITY$1, map2.InfinityError);
  info.put(NO_COMPONENT_FOUND, map2.NoComponentFound);
  info.put(NO_TABLE_FOUND, map2.NoTableFound);
  info.put(FOREIGN_FIELDS_INEQUALITY, map2.ForeignFieldsInequality);
  info.put(NO_EMPTY_ROW_FOUND, map2.NoEmptyRowFound);
  info.put(GRID_TREE_COLUMN_DEFINE_ERROR, map2.GridTreeColumnDefineError);
  info.put(UNDEFINED_ROW_EXPAND_TYPE, map2.UndefinedRowExpandType);
  info.put(NO_DETAIL_ROW_DEFINE, map2.NoDetailRowDefine);
  info.put(COMPONENT_NOT_EXISTS$1, map2.ComponentNotExists);
  info.put(NO_REFDETAILTABLEKEY_DEFINE, map2.NoRefDetailTableKeyDefine);
  info.put(NO_REFTABLEKEY_DEFINE, map2.NoRefTableKeyDefine);
  info.put(NO_EXPANDSOURCE_RESULT_GET, map2.NoExpandSourceGet);
  info.put(UNDEFINED_SUBDETAIL_LINKTYPE, map2.UndefinedSubDetailLinkType);
  info.put(NO_SUBDETAILS_IN_EMPTYROW, map2.NoSubDetailsInEmptyRow);
  info.put(NO_GRID_OR_LISTVIEW_FOUND, map2.NoGridOrListViewFound);
  info.put(NO_CELL_CANNOT_SET_VALUE, map2.NoCellCannotSetValue);
  info.put(CANNNOT_GET_NO_CELL_VALUE, map2.CannnotGetNoCellValue);
  info.put(COMPDICT_CANNOT_SET_MULTIDICT$1, map2.CompdictCannotSetMultidict);
  info.put(DYNAMICDICT_ITEMKEY_NULL$1, map2.DynamicdictItemkeyNull);
  info.put(COMPDICT_ITEMKEY_NULL$1, map2.CompdictItemkeyNull);
  info.put(NO_COMPONENT, map2.NoComponent);
  info.put(NO_WIDTH_OR_HEIGHT, map2.NoWidthOrHeight);
  info.put(NO_KEY_TARGET_BILL, map2.NoKeyTargetBill);
  info.put(Exceed_Value_Max_Accuracy, map2.ExceedValueMaxAccuracy);
  info.put(Date_Diff_Param_Error$1, map2.DateDiffParamError);
  info.put(NO_COMPONENT_KEY, map2.NoComponentKey);
  info.put(CELL_MERGE_DEFINE_ERROR, map2.CellMergeDefineError);
  info.put(SOURCETYPE_DEFINE_ERROR, map2.SourceTypeDefineError);
  info.put(PRIMARYKEYS_ERROR$1, map2.PrimaryKeyError);
  info.put(TYPE_FORMULA_NEEDED, map2.TypeFormulaNeeded);
  info.put(TYPE_GROUP_UNDEFINED, map2.TypeGroupUnDefined);
  info.put(TYPE_DEF_UNDEFINED, map2.TypeDefUnDefined);
  info.put(TYPE_DEF_KEYCOLUMN_UNDEFINED, map2.TypeDefKeyColumnUndefined);
  info.put(TYPEDEFKEY_EMPTY, map2.TypeDefKeyEmpty);
  info.put(UNKNOWN_DETAIL_TYPE, map2.UnknownDetailType);
  info.put(EXPAND_SOURCE_UNDEFINED, map2.ExpandSourceUndefined);
  info.put(EXPAND_COLUMNKEY_UNDEFIND, map2.ExpandColumnKeyUndefined);
  info.put(VIEW_FORM_ONLY, map2.ViewFormOnly);
  info.put(UNSUPPORT_ROWEXPAND_TYPE, map2.UnSupportRowExpandType);
  info.put(NO_ENTRYRIGHTS, map2.NoEntryRights);
  info.put(LISTVIEW_NOT_FOUND_IN_VIEW, map2.ListViewNotFound);
  info.put(ITEMKEY_COLUMN_UNDEFINED, map2.ItemKeyColumnUndefined);
  info.put(DICT_DATA_ERROR, map2.DictDataError);
  info.put(CONNECT_FAILED, map2.ConnectFailed);
  info.put(FORM_CHECK_ERROR$1, map2.FormCheckError);
  info.put(GRID_ROW_ERROR$1, map2.GridRowError);
  info.put(GRID_CELL_ERROR$1, map2.GridCellError);
  info.put(GRID_CELL_REQUIRED$1, map2.GridCellRequired);
  info.put(GRID_CELL_INFINITY$1, map2.GridCellInfinity);
  info.put(VE_CANNOT_NULL, map2.VeCannotNull);
  info.put(NO_LOAD_HANDLER_CLASS, map2.NoLoadHandlerClass);
  info.put(DICT_ROOT_NODE_CALC_ERROR, map2.DictRootNodeCalcError);
  info.put(ITEMKEY_NOT_AGREE_WITH_CURRENT, map2.ItemkeyNotAgreeWithCurrent);
  info.put(ITEMKEY_NO_COMPDICT, map2.ItemkeyNoCompDict);
  info.put(NO_DICT, map2.NoDict);
  info.put(NO_COMPONENT_BUILDER_CLASS, map2.NoComponentBuilderClass);
  info.put(NOT_SUPPORT_TYPE, map2.NotSupportType);
  info.put(DICT_INPUT_VALUE_TYPE_ERROR, map2.DictInputValueTypeError);
  info.put(TIME_ERROR, map2.TimeError);
  info.put(FILTER_DEPEND_UNTREATED_TYPE, map2.filterDependenceUntreatedType);
  info.put(COMPDICT_NOT_DATA_BINDING, map2.CompdictNotDataBinding);
  info.put(UNEQUAL_PARAM_NUM$2, map2.UnEqualParamNum);
  info.put(RADIOBUTTON_NO_GROUPKEY, map2.RadioButtonNoGroupKey);
  info.put(BUDDYKEY_NOT_EXISTS, map2.BuddyKeyNotExists);
  info.put(DATAROW_NO_PRIMARYKEYS$1, map2.DataRowNoPrimaryKeys);
  info.put(FORM_SERIALIZATION_ERROR$1, map2.FormSerializationError);
  info.put(FORM_UNDEFINED, map2.FormUndefined);
};
regErrorInfo$2(errorInfo$3, StringTable$2);
const reload = (map2) => {
  regErrorInfo$2(errorInfoLang$2, Object.assign(Object.assign({}, StringTable$2), map2));
};
class ServiceName {
}
ServiceName.RICH_DOCUMENT = "RichDocument";
ServiceName.WEB_META_SERVICE = "WebMetaService";
ServiceName.GET_PRE_LOAD_FORM = "GetPreLoadForm";
ServiceName.GET_APP_LIST = "GetAppList";
ServiceName.DELETE_DATA = "DeleteData";
ServiceName.SAVE_FORM_DATA = "SaveFormData";
ServiceName.COPY_NEW = "CopyNew";
ServiceName.LOAD_DATA = "LoadData";
ServiceName.DICT_SERVICE = "DictService";
ServiceName.ORG_DICT_SERVICE = "OrgDictService";
ServiceName.WEB_DICT_SERVICE = "WebDictService";
ServiceName.MAP_DATA = "MapData";
ServiceName.BPM = "BPM";
ServiceName.BPM_DEF_SERVICE = "BPMDefService";
ServiceName.BPM_EXTEND = "BPMExtend";
ServiceName.WEB_PRINT_SERVICE = "WebPrintService";
ServiceName.BASE64_IMAGE = "Base64Image";
ServiceName.SESSION_RIGHTS = "SessionRights";
ServiceName.MIGRATION = "Migration";
ServiceName.GET_RESOURCE_SERVICE = "GetResourceService";
ServiceName.APPLY_NEW_OID = "ApplyNewOID";
ServiceName.HTTP_AUTHENTICATE = "HttpAuthenticate";
ServiceName.PREFERENCE = "Preference";
ServiceName.CONVERT_STATUS = "ConvertStatus";
ServiceName.GET_PUBLIC_KEY = "GetPublicKey";
ServiceName.APPLY_NEW_SEQUENCE = "ApplyNewSequence";
ServiceName.LOCALE_STRING = "LocaleString";
ServiceName.UPLOAD_ATTACHMENT = "UploadAttachment";
ServiceName.DELETE_ATTACHMENT = "DeleteAttachment";
ServiceName.DOWNLOAD_ATTACHMENT = "DownloadAttachment";
ServiceName.GET_SYSTEM_INFO = "GetSystemInfo";
ServiceName.UPLOAD_IMAGE = "UploadImage";
ServiceName.DELETE_IMAGE = "DeleteImage";
ServiceName.MOBILE_SERVICE = "MobileService";
ServiceName.MOBILE_FILE = "MobileFile";
ServiceName.LOAD_DIM_VALUE = "LoadDimValue";
ServiceName.MENU_FAVORITE_SERVICE = "MenuFavoriteService";
ServiceName.COMBOBOX_SERVICE = "ComboBoxService";
ServiceName.DATE_SERVICE = "DateService";
ServiceName.DBUPDATE = "DBUpdate";
ServiceName.DBQUERY = "DBQuery";
ServiceName.INVOKE_SERVICE = "InvokeService";
ServiceName.INVOKE_UNSAFE_SERVICE = "InvokeUnsafeService";
ServiceName.EVAL_MID_EXP = "EvalMidExp";
ServiceName.EXPORT_FILE = "ExportFile";
ServiceName.DTS = "DTS";
ServiceName.YIGO_VARIANT = "YES_Core_GridVariant";
ServiceName.I18NINFO = "YES_Core_I18NInfo";
ServiceName.UIOPTTRACE = "YES_Core_UIOptTrace";
ServiceName.BEACON_SERVICE = "BeaconService";
class BaseCache {
  constructor() {
  }
  get(key) {
    return this.getCache().get(key);
  }
  put(key, val) {
    return this.getCache().put(key, val);
  }
  clear() {
    return this.getCache().clear();
  }
}
class ListElement {
  constructor(before, next2, key, value) {
    this.before = before;
    this.next = next2;
    this.key = key;
    this.value = value;
  }
  setKey(key) {
    this.key = key;
  }
  setValue(value) {
    this.value = value;
  }
}
class LRUCache {
  constructor(max) {
    this.maxSize = max || 1e3;
    this.reset();
  }
  reset() {
    this.size = 0;
    this.cache = {};
    this.tail = void 0;
    this.head = void 0;
  }
  contains(key) {
    return key in this.cache;
  }
  get(key) {
    var cacheVal = this.cache[key];
    if (cacheVal) {
      this.hit(cacheVal);
    } else {
      return null;
    }
    return cacheVal.value;
  }
  set(key, val) {
    var actual = this.cache[key];
    if (actual) {
      actual.value = val;
      this.hit(actual);
    } else {
      var cacheVal;
      if (this.size >= this.maxSize) {
        var tailKey = this.tail.key;
        this.detach(this.tail);
        cacheVal = this.cache[tailKey];
        delete this.cache[tailKey];
        cacheVal.next = void 0;
        cacheVal.before = void 0;
        cacheVal.setKey(key);
        cacheVal.setValue(val);
      }
      cacheVal = cacheVal ? cacheVal : new ListElement(void 0, void 0, key, val);
      this.cache[key] = cacheVal;
      this.attach(cacheVal);
    }
  }
  put(key, val) {
    return this.set(key, val);
  }
  del(key) {
    var val = this.cache[key];
    if (!val)
      return;
    this.detach(val);
    delete this.cache[key];
  }
  hit(cacheVal) {
    this.detach(cacheVal);
    this.attach(cacheVal);
  }
  attach(element) {
    if (!element)
      return;
    element.before = void 0;
    element.next = this.head;
    this.head = element;
    if (!element.next) {
      this.tail = element;
    } else {
      element.next.before = element;
    }
    this.size++;
  }
  detach(element) {
    if (!element)
      return;
    var before = element.before;
    var next2 = element.next;
    if (before) {
      before.next = next2;
    } else {
      this.head = next2;
    }
    if (next2) {
      next2.before = before;
    } else {
      this.tail = before;
    }
    this.size--;
  }
  forEach(callback) {
    var self = this;
    Object.keys(this.cache).forEach(function(key) {
      var val = self.cache[key];
      callback(val.value, key);
    });
  }
}
class ImageScaleType {
  static toString(v) {
    return v == this.CENTER && this.STR_CENTER || v == this.FIT_XY && this.STR_FIT_XY || v == this.FIT_START && this.STR_FIT_START || v == this.FIT_CENTER && this.STR_FIT_CENTER || v == this.FIT_END && this.STR_FIT_END || v == this.CENTER_CROP && this.STR_CENTER_CROP || v == this.START && this.STR_START || "";
  }
}
ImageScaleType.CENTER = 0;
ImageScaleType.STR_CENTER = "Center";
ImageScaleType.FIT_XY = 1;
ImageScaleType.STR_FIT_XY = "Fit_XY";
ImageScaleType.FIT_START = 2;
ImageScaleType.STR_FIT_START = "Fit_Start";
ImageScaleType.FIT_CENTER = 3;
ImageScaleType.STR_FIT_CENTER = "Fit_Center";
ImageScaleType.FIT_END = 4;
ImageScaleType.STR_FIT_END = "Fit_End";
ImageScaleType.CENTER_CROP = 5;
ImageScaleType.STR_CENTER_CROP = "Center_Crop";
ImageScaleType.START = 6;
ImageScaleType.STR_START = "Start";
class SelectTextFocusType {
}
SelectTextFocusType.DEFAULT = 0;
SelectTextFocusType.PROMPTTEXT = 1;
const GridSetting = {
  restoreInitStatus: true,
  // 树形表格刷新时恢复初始状态
  loseFocusOnBlankClick: true,
  // 表格点击空白区域是否失去焦点
  pageRowCount: 50,
  // 表格动态加载一页显示行数
  defaultFitWidth: false,
  // 打开默认最佳列宽
  defaultZoom: true,
  // 表格默认是否缩放
  defaultSortable: true,
  // 表格默认是否可交换列
  defaultExport: false,
  // 表格默认是否可导出
  defaultColumnSortable: false,
  // 表格列默认是否可排序
  justifySortableWidth: true,
  // 可排序的列是否加20宽度
  minColWidth: 30,
  // 表格列最小宽度
  maxColWidth: 300,
  // 表格列最大宽度
  devMode: false
  // 开发模式,用于测试
};
const DialogSetting = {
  Placement: "right"
  // dialog 默认执行按钮放在最右边
};
const DatePickerSetting = {
  SelectDropdown: true
  // 点击input显示下拉框，默认true
};
const ImgSetting = {
  // gif | icon | image | imagelist | carousel | waterfall
  imageScaleType: ImageScaleType.CENTER,
  // 收缩方式默认居中显示
  CacheNumber: 50,
  //图片缓存多少
  Size: 500,
  //图片缓存尺寸大小,计量单位kb
  DelayTime: 200
  //图片请求时间，多少时间内用一个请求
};
const CompSetting = {
  CompStyle: "innerLabel",
  // className: innerLabel | innerLabel_m, 设置为空("")可以禁用 innerLabel 方式
  DisableClick: void 0,
  PromptText: ""
};
let DesignModeSetting = {
  isDesignMode: false,
  designerProjects: {},
  setDesignMode: function(value) {
    this.isDesignMode = value;
  },
  addDesignerProjects: function(...projectKeys) {
    projectKeys.forEach((projectKey) => {
      this.designerProjects[projectKey] = true;
    });
  },
  isNotDesignerProject: function(projectKey) {
    return !!!this.designerProjects[projectKey];
  }
};
let ConfirmPanelSetting = {
  confirmPanelSize: ""
};
let LocalMenuFavoriteSetting = {
  LocalMenuFavorite: void 0
};
let MapSetting = {
  BDUrl: "",
  GDUrl: ""
};
let DictSetting = {
  ShowSearch: false,
  EditType: SelectTextFocusType.PROMPTTEXT
  // 下拉框 字典 选中样式
};
let supportTouch = "ontouchstart" in window;
const DictQueryPage = {
  MaxRows: 5,
  PageIndicatorCount: 3
};
const RequestSetting = {
  compressionThreshold: 2e4,
  // 服务请求时数据压缩的阈值
  gzipLevel: 1,
  // 1 压缩率最小 9最大
  delayTime: 200
  // loading显示时的延迟时间
};
const TabPanelSetting = {
  showFullScreen: true
};
const ComboBoxSetting = {
  PageMaxNum: 20,
  PromptSize: 10
};
const LLMChat_SizeOptions = {
  resizable: true,
  // 智能助手宽高可拖拽缩放
  size: ["50%"],
  // 智能助手设置初始宽度50% 高度未设置默认100%
  showClose: true
  // 智能助手右上角显示关闭按钮
};
let cache$k = new LRUCache(ImgSetting.CacheNumber);
class ImageCache extends BaseCache {
  getCache() {
    return cache$k;
  }
  put(key, value) {
    var size2 = this.getBase64ImageSize(value);
    if (size2 <= ImgSetting.Size) {
      cache$k.set(key, value);
    }
  }
  getBase64ImageSize(base64) {
    var indexBase64 = base64.indexOf("base64,");
    if (indexBase64 < 0)
      return -1;
    var str = base64.substr(indexBase64 + 6);
    var sizeInKB = str.length * 0.75 / 1024;
    return sizeInKB.toFixed(2);
  }
}
class CoreException extends Error {
  constructor(code, message) {
    super(message);
    this.code = (parseInt(code, 10) >>> 0).toString(16).toLocaleUpperCase();
    this.message = message;
    this.name = "YIUI.CoreException";
  }
}
class Exception extends Error {
  constructor(code, message, noThrow) {
    super(message);
    this.noThrow = false;
    this.noThrow = noThrow;
    if (code == -1 && !message) {
      this.code = -1;
    } else {
      this.code = (parseInt(code, 10) >>> 0).toString(16).toLocaleUpperCase();
      this.message = message;
    }
    this.name = "YIUI.Exception";
    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, this.constructor);
    }
  }
  //_Exception.prototype = Object.create(Error.prototype);
}
const Service = function() {
  var location_pathname = document.location.pathname;
  while (location_pathname.indexOf("/") === 0)
    location_pathname = location_pathname.substring(1);
  if (location_pathname.includes("/")) {
    location_pathname = location_pathname.substring(0, location_pathname.lastIndexOf("/"));
  } else if (location_pathname.includes(".")) {
    location_pathname = "";
  } else {
    location_pathname = location_pathname;
  }
  const basePosition = window.Yes_ENV_BasePosition;
  if (basePosition) {
    location_pathname = location_pathname + "/" + basePosition;
  }
  return decodeURIComponent(location_pathname);
}();
let service;
{
  service = Service;
}
let ServletURL, AttachURL, ContextPath, BaseURL;
if (service) {
  BaseURL = [window.location.protocol, "//", window.location.host, "/", service].join("");
  ServletURL = [window.location.protocol, "//", window.location.host, "/", service, "/", "servlet"].join("");
  AttachURL = [window.location.protocol, "//", window.location.host, "/", service, "/", "attach"].join("");
} else {
  BaseURL = [window.location.protocol, "//", window.location.host].join("");
  ServletURL = [window.location.protocol, "//", window.location.host, "/", "servlet"].join("");
  AttachURL = [window.location.protocol, "//", window.location.host, "/", "attach"].join("");
}
ContextPath = "/" + Service;
let currentMap = {};
let currentSize = 0;
let globalMap = {};
let globalSize = 0;
class HeadInfos {
  static put(key, value, global) {
    var added = false;
    if (global) {
      if (!HeadInfos.containsKey(key, global)) {
        ++globalSize;
        added = true;
      }
      globalMap[key] = value;
    } else {
      if (!HeadInfos.containsKey(key, global)) {
        ++currentSize;
        added = true;
      }
      currentMap[key] = value;
    }
    return added;
  }
  static containsKey(key, global) {
    if (global) {
      return key in globalMap;
    } else {
      return key in currentMap;
    }
  }
  static getAll() {
    return Object.assign({}, currentMap, globalMap);
  }
  static putAll(map2) {
    for (var m in map2) {
      this.put(m, map2[m]);
    }
  }
  static get(key, global) {
    var value = null;
    if (HeadInfos.containsKey(key, global)) {
      if (global) {
        value = globalMap[key];
      } else {
        value = currentMap[key];
      }
    }
    return value;
  }
  static remove(key, global) {
    if (HeadInfos.containsKey(key, global)) {
      if (global) {
        var value = globalMap[key];
        if (delete globalMap[key]) {
          --globalSize;
          return value;
        }
      } else {
        var value = currentMap[key];
        if (delete currentMap[key]) {
          --currentSize;
          return value;
        }
      }
    }
    return null;
  }
  static empty() {
    return currentSize == 0 && globalSize == 0;
  }
  static clearCurrent() {
    currentSize = 0;
    currentMap = new Object();
  }
  static toJSON() {
    return JSON.stringify(Object.assign({}, currentMap, globalMap));
  }
}
class GZipUtil {
  static gzip(str) {
    var gs = pako.gzip(str, { level: RequestSetting.gzipLevel });
    let b64encoded = Base64.encode64(gs);
    return b64encoded;
  }
}
class InterceptorManager {
  constructor() {
    this.interceptor = [];
  }
  isEmpty() {
    return this.interceptor.length == 0;
  }
  add(fn) {
    this.interceptor.push(fn);
  }
  async exec() {
    for (var i2 = this.interceptor.length - 1; i2 >= 0; i2--) {
      await this.interceptor[i2].apply(this, arguments);
    }
  }
}
let header = {};
class RequestUtil {
  static addHeader(key, v) {
    header[key] = v;
  }
  static removeHeader(key) {
    delete header[key];
  }
  static getHeader() {
    return header;
  }
  static clear() {
    header = {};
  }
}
const formList = [];
const activeFormStack = [];
class FormStack {
  static addForm(form) {
    formList.push(form);
  }
  static getFormByUUID(formUUID) {
    for (var i2 = 0; i2 < formList.length; i2++) {
      let form = formList[i2];
      if (formUUID == (form == null ? void 0 : form.getFormUUID())) {
        return form;
      }
    }
    return;
  }
  static getForm(formID2) {
    for (var i2 = 0; i2 < formList.length; i2++) {
      if (formID2 == formList[i2].formID) {
        return formList[i2];
      }
    }
    return;
  }
  static removeForm(formID2) {
    for (var i2 = 0; i2 < activeFormStack.length; i2++) {
      if (formID2 == activeFormStack[i2].formID) {
        activeFormStack.splice(i2, 1);
      }
    }
    for (var i2 = 0; i2 < formList.length; i2++) {
      var f = formList[i2];
      if (formID2 == f.formID) {
        if (f == this.activeForm) {
          this.activeForm = activeFormStack.length > 0 ? activeFormStack.pop() : void 0;
        }
        formList.splice(i2, 1);
        f.destroy();
      }
    }
  }
  static removeAll() {
    if (!formList)
      return;
    for (var i2 = 0; i2 < formList.length; i2++) {
      formList[i2].destroy();
    }
    formList.splice(0, formList.length);
  }
  static getFormList() {
    return formList;
  }
  static setActiveForm(form, bModal) {
    if (bModal) {
      if (this.activeForm)
        activeFormStack.push(this.activeForm);
    } else {
      activeFormStack.length = 0;
    }
    this.activeForm = form;
  }
  static getActiveForm() {
    return this.activeForm;
  }
  // 如果当前是模态,那么先找zIndex最大的模态获取焦点
  // 如果不传curForm,stack从后往前遍历
  // 找不到就和普通表单关闭一样找到active的表单获取焦点
  static findFocusForm(curForm) {
    if (!curForm || curForm.getTarget() == FormTarget.MODAL) {
      let modalForm;
      for (let i2 = 0, form; form = formList[i2]; i2++) {
        if (form.getTarget() == FormTarget.MODAL) {
          if (modalForm) {
            if (modalForm.zIndex < form.zIndex) {
              modalForm = form;
            }
          } else {
            modalForm = form;
          }
        }
      }
      if (modalForm) {
        return modalForm;
      }
    }
    return FormStack.getActiveForm();
  }
}
class HeadInfoOptType {
}
HeadInfoOptType.STR_BUTTON = "Button";
HeadInfoOptType.STR_TOOLBAR = "Toolbar";
HeadInfoOptType.STR_ENTRY = "Entry";
HeadInfoOptType.STR_ValueChanged = "ValueChanged";
HeadInfoOptType.STR_DeleteRow = "DeleteRow";
HeadInfoOptType.STR_RowClick = "RowClick";
HeadInfoOptType.STR_RowDblClick = "RowDblClick";
class HeadInfoType {
}
HeadInfoType.SYSOPT = "Sys_Opt";
HeadInfoType.SYSOPTTYPE = "Sys_Opt_Type";
HeadInfoType.SYSOPTCAPTION = "Sys_Opt_Caption";
HeadInfoType.SYSOPTFORMKEY = "Sys_Opt_FormKey";
HeadInfoType.SysSvrFormKey = "Sys_Svr_FormKey";
HeadInfoType.SYSOPTCONTAINERFORMKEY = "Sys_Opt_Container_FormKey";
HeadInfoType.SYSENTRYPATH = "Sys_Entry_Path";
HeadInfoType.SYSOPTFORMCAPTION = "Sys_Opt_FormCaption";
HeadInfoType.SysOptSkipMessages = "Sys_Opt_Skip_Messages";
HeadInfoType.SysFormID = "Sys_Form_ID";
HeadInfoType.SysParentFormID = "Sys_ParentForm_ID";
HeadInfoType.SysRootFormID = "Sys_RootForm_ID";
HeadInfoType.SkipAllMessageItems = "Skip_All_Message_Items";
HeadInfoType.SysOptID = "Sys_Opt_ID";
HeadInfoType.TCode = "TCode";
HeadInfoType.Activity = "Activity";
HeadInfoType.SYSOPTBOOKMARK = "Sys_Opt_Bookmark";
class HeadInfoUtil {
  static put(self, type, ofFormID) {
    try {
      this.clear();
      var form = FormStack.getForm(ofFormID);
      if (!form)
        throw new Error("表单不存在");
      if (type == HeadInfoOptType.STR_ENTRY) {
        HeadInfos.put(HeadInfoType.SYSENTRYPATH, self.path);
        HeadInfos.put(HeadInfoType.TCode, self.tcode);
      } else {
        const container = form.getDefContainer() || form.getContainer();
        if (container && container.form) {
          HeadInfos.put(HeadInfoType.SYSOPTCONTAINERFORMKEY, container.form.getFormKey());
        }
        if (form._MessageContextSkipItems) {
          HeadInfos.put(HeadInfoType.SysOptSkipMessages, form._MessageContextSkipItems);
        }
        if (form._SkipAllMessageItems) {
          HeadInfos.put(HeadInfoType.SkipAllMessageItems, form._SkipAllMessageItems);
        }
      }
      HeadInfos.put(HeadInfoType.SYSOPT, self.key);
      HeadInfos.put(HeadInfoType.SYSOPTTYPE, type);
      HeadInfos.put(HeadInfoType.SYSOPTCAPTION, self.caption);
      HeadInfos.put(HeadInfoType.SYSOPTFORMKEY, form.getFormKey());
      HeadInfos.put(HeadInfoType.SYSOPTFORMCAPTION, form.getCaption());
      HeadInfos.put(HeadInfoType.SysFormID, form.getFormUUID());
      HeadInfos.put(HeadInfoType.SysParentFormID, form.getParentFormUUID());
      HeadInfos.put(HeadInfoType.SysRootFormID, form.getRootFormUUID());
      HeadInfos.put(HeadInfoType.SysOptID, this.getOptID());
    } catch (e) {
      console.error(e);
    }
  }
  static getOptID() {
    var uuid = Utils.guid();
    var timestamp = (/* @__PURE__ */ new Date()).getTime();
    return uuid + "-" + timestamp;
  }
  static appendGlobalHeadInfos(form) {
    if (!form) {
      return;
    }
    HeadInfos.put(HeadInfoType.SysSvrFormKey, form.getFormKey());
    HeadInfos.put("TCode", form.TCode);
    HeadInfos.put("Activity", form.Activity);
    const topForm = form.getTopForm && form.getTopForm();
    if (!topForm) {
      return;
    }
    const bizLockOptFormKey = topForm.getDefContainer() ? form.getFormKey() : topForm.getFormKey();
    const bizLockFormUUID = topForm.getFormUUID();
    HeadInfos.put("BizLockFormUUID", bizLockFormUUID);
    HeadInfos.put("BizLockFormKey", bizLockOptFormKey);
  }
  static clear() {
    HeadInfos.clearCurrent();
  }
  static putAll(map2) {
    HeadInfos.putAll(map2);
  }
  static getAll() {
    return HeadInfos.getAll();
  }
  static appendBookmark(bookmark) {
    HeadInfos.put(HeadInfoType.SYSOPTBOOKMARK, bookmark);
  }
}
class HeadInfoField {
  static async loadHeadInfos(form) {
    if (Utils.isDefined(HeadInfoField.headInfoFieldEnable)) {
      return;
    }
    const paras = {
      service: "InvokeService",
      extSvrName: "HeadInfoFieldService"
    };
    const result = await new Request$1(form).getData(paras);
    HeadInfoField.headInfoFieldEnable = result.enable;
    const formKey2FieldKeys = result.formKey2FieldKeys;
    if (formKey2FieldKeys) {
      HeadInfoField.headInfoField = {};
      for (let i2 = 0; i2 < formKey2FieldKeys.length; i2++) {
        const _formKey = formKey2FieldKeys[i2].formKey;
        const _fieldKey = formKey2FieldKeys[i2].fieldKey;
        HeadInfoField.headInfoField[_formKey] = _fieldKey;
      }
    }
  }
  static getValue(form) {
    const fieldKey = HeadInfoField.getFieldKey(form);
    let value;
    if (fieldKey) {
      const com = form.getComponent(fieldKey);
      if (com) {
        value = com.getValue();
      } else {
        const loc = form.getCellLocation(fieldKey);
        const gridKey = loc && loc.key;
        const grid = gridKey && form.getComponent(gridKey);
        const row = grid.getRowDataAt(0);
        value = row ? grid.getValueByKey(0, fieldKey) : 0;
      }
      if (value && value instanceof ItemData) {
        value = value.getOID();
      }
    }
    return value;
  }
  static getFieldKey(form) {
    if (Utils.isUndefined(HeadInfoField.headInfoFieldEnable)) {
      return null;
    }
    if (HeadInfoField.headInfoFieldEnable == false) {
      return null;
    }
    const formKey = form.getFormKey();
    if (HeadInfoField.headInfoField && HeadInfoField.headInfoField[formKey]) {
      return HeadInfoField.headInfoField[formKey];
    }
    return HeadInfoField.headInfoField[formKey];
  }
}
class UIOptTraceUtil {
  /** 初始化动作*/
  static async init() {
    await this.initDB();
  }
  /** 设置启用用户行为记录
   * @param enable 是否启用
  */
  static setEnableTrace(enable) {
    this.enableTrace = enable;
  }
  /** 获取是否启用用户行为记录*/
  static isEnableTrace() {
    return this.enableTrace;
  }
  /** 添加请求耗时 
   * @param traceID 请求ID
   * @param requestTime 请求耗时
   * @param responseTime 后台响应耗时
  */
  static addRequestTime(traceID, requestTime, responseTime) {
    if (!traceID)
      return;
    if (this.traceRequestTimes.traceID != traceID) {
      this.resetTraceRequestTimes();
      this.traceRequestTimes.traceID = traceID;
    }
    this.traceRequestTimes.requestTotalTime += requestTime;
    this.traceRequestTimes.responseTotalTime += responseTime;
  }
  /** 获取请求耗时集合对象*/
  static getTraceRequestTimes() {
    return this.traceRequestTimes;
  }
  /** 重置请求耗时集合对象*/
  static resetTraceRequestTimes() {
    this.traceRequestTimes = { traceID: "", requestTotalTime: 0, responseTotalTime: 0 };
  }
  /**
   * 获取当前时间戳，格式为：2025/4/23 14:30:45.123
   */
  static getNowDateTime() {
    const date = /* @__PURE__ */ new Date();
    const year = date.getFullYear();
    const month = String(date.getMonth() + 1).padStart(2, "0");
    const day = String(date.getDate()).padStart(2, "0");
    const hours = String(date.getHours()).padStart(2, "0");
    const minutes = String(date.getMinutes()).padStart(2, "0");
    const seconds = String(date.getSeconds()).padStart(2, "0");
    const milliseconds = String(date.getMilliseconds()).padStart(3, "0");
    const timezone = Intl.DateTimeFormat().resolvedOptions().timeZone;
    const timeStr = `${year}-${month}-${day} ${hours}:${minutes}:${seconds}.${milliseconds} ${timezone}`;
    return { longValue: date.getTime(), timeZoneString: timeStr };
  }
  /**
   * 判断是否为JSON字符串
   * @param str 待判断的字符串
   * @return {boolean} 是否为JSON字符串
   */
  static isJSON(str) {
    if (typeof str == "string") {
      try {
        var obj = JSON.parse(str);
        if (typeof obj == "object" && obj) {
          return true;
        } else {
          return false;
        }
      } catch (e) {
        return false;
      }
    }
    return false;
  }
  // 初始化数据库
  static initDB() {
    let self = this;
    return new Promise((resolve2, reject) => {
      let request2 = indexedDB.open(self.dbName, 1);
      request2.onerror = (event2) => {
        console.error("UIOptTrace IndexedDB Open Failed:", event2.target.error);
        resolve2(false);
      };
      request2.onsuccess = (event2) => {
        self.db = event2.target.result;
        console.log("UIOptTrace IndexedDB Open Success");
        resolve2(true);
      };
      request2.onupgradeneeded = (event2) => {
        self.db = event2.target.result;
        self.db.createObjectStore(self.storeName, { keyPath: "id", autoIncrement: true });
        console.log(self.storeName + "UIOptTrace IndexedDB Created");
      };
    });
  }
  /**
   * 判断两条记录关键信息是否相同
   */
  static isEqualTraceObject(trace, newTrace) {
    return trace && newTrace && trace.userID == newTrace.userID && trace.user == newTrace.user && trace.docOID == newTrace.docOID && trace.formKey == newTrace.formKey && trace.formCaption == newTrace.formCaption && trace.actionType == newTrace.actionType && trace.fieldKey == newTrace.fieldKey && trace.fieldCaption == newTrace.fieldCaption && trace.mainFrameID == newTrace.mainFrameID && trace.formID == newTrace.formID && trace.rootFormID == newTrace.rootFormID && trace.parentFormCaption == newTrace.parentFormCaption;
  }
  /**
   * 替换最后一条记录
   * @returns 替换是否成功
   */
  static replaceLastTraceInDB(newTrace) {
    let self = this;
    return new Promise((resolve2, reject) => {
      if (!self.enableTrace || !self.db)
        resolve2(false);
      let transaction = self.db.transaction([self.storeName], "readwrite");
      let objectStore = transaction.objectStore(self.storeName);
      const cursorRequest = objectStore.openCursor(null, "prev");
      cursorRequest.onsuccess = function(cursorEvent) {
        let target = cursorEvent.target;
        const cursor = target.result;
        const lastTrace = cursor ? cursor.value : null;
        if (self.isEqualTraceObject(lastTrace, newTrace)) {
          const deleteRequest = objectStore.delete(cursor.key);
          deleteRequest.onsuccess = () => {
            const addRequest = objectStore.add(newTrace);
            addRequest.onsuccess = () => resolve2(true);
            addRequest.onerror = (errorEvent) => {
              console.error("替换最后一条新数据失败：", errorEvent.target.error);
              resolve2(false);
            };
          };
          deleteRequest.onerror = (errorEvent) => {
            console.error("删除最后一条数据失败：", errorEvent.target.error);
            resolve2(false);
          };
        } else {
          resolve2(false);
        }
      };
      cursorRequest.onerror = function(errorEvent) {
        console.error("定位最后一条数据失败：", errorEvent.target.error);
        resolve2(false);
      };
    });
  }
  /**
   * 添加用户行为记录到数据库
   */
  static addTracesToDB(newTrace) {
    let self = this;
    return new Promise((resolve2, reject) => {
      if (!self.enableTrace || !self.db)
        resolve2(false);
      let transaction = self.db.transaction([self.storeName], "readwrite");
      let objectStore = transaction.objectStore(self.storeName);
      const addRequest = objectStore.add(newTrace);
      addRequest.onsuccess = () => resolve2(true);
      addRequest.onerror = (event2) => {
        console.error("添加一条新数据失败：", event2.target.error);
        resolve2(false);
      };
    });
  }
  /**
   * 记录用户行为, 将行为记录存储到 sessionStorage 中
   * @param traceObj 用户行为记录对象
   */
  static async appendTrace(traceObj) {
    try {
      if (!this.enableTrace || !this.db)
        return;
      if (traceObj.isRepeatTrace) {
        let replace = await this.replaceLastTraceInDB(traceObj);
        if (!replace) {
          await this.addTracesToDB(traceObj);
        }
      } else {
        await this.addTracesToDB(traceObj);
      }
    } catch (e) {
      console.error("添加记录用户行为失败：", e);
    }
  }
  /**
   * 异步上传用户行为记录日志
  */
  static uploadTraces() {
    if (!this.enableTrace || !this.db)
      return;
    let self = this;
    return new Promise((resolve2, reject) => {
      let transaction = self.db.transaction([self.storeName], "readwrite");
      let objectStore = transaction.objectStore(self.storeName);
      let request2 = objectStore.getAll();
      request2.onsuccess = (event2) => {
        let traces = event2.target.result;
        if (traces && traces.length > 0) {
          new RemoteService(null).uploadUIOptTraces(traces).then((result) => {
            transaction = self.db.transaction([self.storeName], "readwrite");
            objectStore = transaction.objectStore(self.storeName);
            for (const trace of traces) {
              objectStore.delete(trace.id);
            }
            resolve2(true);
          }).catch((e) => {
            console.error("上传记录失败：", e);
            resolve2(false);
          });
        } else {
          resolve2(true);
        }
      };
      request2.onerror = (event2) => {
        console.error("上传记录失败，未能获取所有数据：", event2.target.error);
        resolve2(false);
      };
    });
  }
}
UIOptTraceUtil.enableTrace = true;
UIOptTraceUtil.db = null;
UIOptTraceUtil.dbName = "UIOptTraceDB";
UIOptTraceUtil.storeName = "Yes_Core_UIOptTrace";
UIOptTraceUtil.traceRequestTimes = { traceID: "", requestTotalTime: 0, responseTotalTime: 0 };
const preHandle = new InterceptorManager();
const postHandle = new InterceptorManager();
const requestErrorHandler = new InterceptorManager();
const addPostHandle = function(fn) {
  postHandle.add(fn);
};
axios.interceptors.request.use(function(config) {
  console.log("beforesend..................1");
  try {
    if (!preHandle.isEmpty()) {
      preHandle.exec.apply(preHandle, arguments);
    }
  } catch (e) {
    console.error(e);
  }
  return config;
});
axios.interceptors.response.use(async function(response) {
  try {
    if (!postHandle.isEmpty()) {
      await postHandle.exec.apply(postHandle, arguments);
    }
  } catch (e) {
    console.error(e);
  }
  if (response.status == 200) {
    let responseTime = response.headers["x-response-time"];
    responseTime = responseTime ? responseTime : 0;
    responseTime = parseInt(responseTime);
    return { ...response.data, responseTime };
  }
}, async function(error) {
  try {
    if (!requestErrorHandler.isEmpty()) {
      await requestErrorHandler.exec.apply(requestErrorHandler, arguments);
    }
  } catch (e) {
    console.error("用户自定义 requestErrorHandler 处理器内部错误", e);
  }
  return Promise.reject(error);
});
const _Request = class _Request2 {
  constructor(form, showLoading = true) {
    this.convertResult = function(msg) {
      var ret = msg.data;
      if (msg.type === JavaDataType.STR_USER_DATATABLE) {
        ret = DataUtil$1.fromJSONDataTable(ret);
      } else if (msg.type === JavaDataType.STR_USER_DOCUMENT) {
        ret = DataUtil$1.fromJSONDoc(ret);
      }
      return ret;
    };
    this.form = form;
    this.showLoading = showLoading;
  }
  processParams(params) {
    HeadInfoUtil.appendGlobalHeadInfos(this.form);
    if (!HeadInfos.empty()) {
      params.headinfos = HeadInfos.toJSON();
    }
    if (this.form && !params.parameters) {
      var parameters = this.form.getParas();
      if (parameters) {
        params.parameters = parameters.toJSON();
      }
    }
  }
  transData(data2) {
    if (data2 == null) {
      return data2;
    }
    data2.mode = _Request2.mode;
    data2.isYES2 = true;
    var json = JSON.stringify(data2);
    if (json.length < RequestSetting.compressionThreshold) {
      return data2;
    }
    try {
      var postData = {};
      postData.yigoData = GZipUtil.gzip(json);
      return postData;
    } catch (e) {
      console.warn(json);
      console.error(e);
      return data2;
    }
  }
  getNormalizedUri(params, url, form) {
    var _formKey, _projectKey;
    if (form) {
      _formKey = form.getFormKey();
      _projectKey = form.getProjectKey();
    }
    if (form) {
      if (!form.getAppEnv()) {
        console.log("...................appEnv is null..............");
      }
    }
    var service2 = params["service"];
    var cmd = params["cmd"] || "do";
    var projectKey = _projectKey || "global";
    var key = params["itemKey"] || params["dataObjectKey"] || params["formKey"] || _formKey || "";
    if (!url) {
      url = ServletURL;
    }
    if (service2) {
      url = url + "/" + service2 + "/" + cmd + "/" + projectKey;
      url = key ? url + "/" + key : url;
      return url;
    }
    return url;
  }
  getRequestHeader(url, postData, async, timeout, form) {
    var header2 = {
      contentType: "application/x-www-form-urlencoded;charset=UTF-8",
      method: "post",
      url,
      data: postData,
      timeout
    };
    var appKey = "Global";
    if (form) {
      let appEnv = form.getAppEnv();
      if (appEnv) {
        appKey = appEnv.getAppKey();
      }
    }
    let h = RequestUtil.getHeader();
    header2.headers = Object.assign(
      {
        "Content-Type": "application/x-www-form-urlencoded;charset=UTF-8"
      },
      {
        "appKey": appKey,
        "yigo-contextpath": ContextPath
      },
      this._header,
      h
    );
    if (form) {
      const headInfoFieldValue = HeadInfoField.getValue(form);
      if (headInfoFieldValue && headInfoFieldValue != 0) {
        header2.headers = Object.assign({ "X-Form-CompanyCodeID": headInfoFieldValue }, header2.headers);
      }
    }
    return header2;
  }
  decryptData(data2) {
    return data2;
  }
  addHeader(key, value) {
    this._header = this._header || {};
    this._header[key] = value;
  }
  getData(params, url, notConvert) {
    url = this.getNormalizedUri(params, url, this.form);
    var timeout = 0;
    this.processParams(params);
    var postData = this.transData(params);
    var self = this;
    var header2 = self.getRequestHeader(url, postData, true, timeout, this.form);
    if (_Request2.PREPARE_FOR_BEACON) {
      _Request2.BEACON_ATTACH_DATA = header2;
      return Promise.resolve("OK");
    }
    const traceId = header2.headers["x-b3-traceid"];
    const startTime = (/* @__PURE__ */ new Date()).getTime();
    return axios(header2).then(function(data2) {
      const endTime = (/* @__PURE__ */ new Date()).getTime();
      const duration = endTime - startTime;
      const responseTime = data2.responseTime;
      UIOptTraceUtil.addRequestTime(traceId, duration, responseTime);
      if (self.decryptData) {
        data2 = self.decryptData(data2);
      }
      if (data2.success == false) {
        var error = data2.error;
        var e = new CoreException(error.error_code, error.error_info);
        console.error("error........" + e);
        throw e;
      }
      if (!("data" in data2)) {
        console.warn(`"${header2.url}"接口返回的数据无"data"字段，请检查!`);
        return data2;
      }
      if (notConvert) {
        return data2.data;
      }
      var ret = self.convertResult(data2);
      return ret;
    }, function(err) {
      const endTime = (/* @__PURE__ */ new Date()).getTime();
      const duration = endTime - startTime;
      UIOptTraceUtil.addRequestTime(traceId, duration, 0);
      console.log(err);
      if (err.response || err.response) {
        var req = err.request;
        if (req && req.readyState == 0) {
          var e = new CoreException(-1, I18N.getString("REQUEST_CHECK", "请求状态未初始化，检查服务器连接！"));
          throw e;
        }
        var resp = err.response;
        if (resp) {
          self.handleError(resp);
        } else {
          self.handleError(req);
        }
      } else {
        throw new Exception(-1, err.message + " traceId:[" + traceId + "] cost:" + duration + " ms");
      }
    });
  }
  handleError(result) {
    var ret;
    if (this.decryptData) {
      ret = this.decryptData(result.responseJSON);
    } else {
      ret = result.responseJSON;
    }
    if (!ret && result.responseText) {
      try {
        ret = JSON.parse(result.responseText);
      } catch (ex) {
        throw new Exception(-1, result.status + " " + result.statusText);
      }
    }
    var error = ret && ret.error;
    var e;
    if (error) {
      e = new CoreException(error.error_code, error.error_info);
    } else if (ret) {
      e = new Exception(-1, ret);
    } else {
      e = new Exception(-1, result.status + " " + result.statusText);
    }
    throw e;
  }
  uploadFile(options2) {
    var file = options2.file;
    var files = file.files;
    const formData = new FormData();
    for (var i2 = 0, len = files.length; i2 < len; i2++) {
      formData.append("file", files[i2]);
    }
    delete options2.file;
    options2.mode = _Request2.mode;
    let v;
    for (let key of Object.keys(options2)) {
      v = options2[key];
      v && formData.append(key, options2[key]);
    }
    return axios({
      method: "post",
      headers: {
        "Content-Type": "multipart/form-data"
      },
      url: AttachURL,
      data: formData
    }).then((ret) => {
      if (ret.success == false) {
        var error = ret.error;
        var e = new Exception(error.error_code, error.error_info);
        return Promise.reject(e);
      } else {
        return ret.data;
      }
    }).catch((error) => {
      throw error;
    });
  }
  downloadFile(options2, callback) {
    options2.mode = _Request2.mode;
    var xhr = new XMLHttpRequest();
    xhr.open("post", AttachURL, true);
    xhr.responseType = "blob";
    var toData = function(json) {
      var arr = new Array();
      var i2 = 0;
      for (var attr in json) {
        arr[i2] = attr + "=" + encodeURIComponent(json[attr]);
        i2++;
      }
      return arr.join("&");
    };
    xhr.onreadystatechange = function() {
      if (this.readyState == this.DONE) {
        var obj = {
          checkCode: decodeURIComponent(this.getResponseHeader("checkCode")),
          fileName: decodeURIComponent(this.getResponseHeader("filename"))
        };
        callback(this.response, obj);
      }
    };
    xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
    xhr.setRequestHeader("Range", "bytes=0-");
    xhr.send(toData(options2));
  }
  uploadFileData(options2) {
  }
  batchFileUpload(options2) {
  }
  errorUtilsLogin(arg) {
    return axios(arg[0].config).then((data2) => {
      arg[0]["data"] = data2;
    });
  }
};
_Request.mode = 1;
_Request.PREPARE_FOR_BEACON = false;
_Request.BEACON_ATTACH_DATA = "";
let Request = _Request;
const Request$1 = Request;
var reqMap = {};
const DOWNLOAD_BASE64_IMAGE = "DownloadBase64Image";
const cache$j = new ImageCache();
class Base64ImageService {
  constructor(form) {
    this.form = form;
    this.request = new Request$1(form);
  }
  async loadBase64Image(path, thumbnail = null, sourceType = -1, project = null, formKey = null) {
    var formKey = this.form ? this.form.getFormKey() : formKey;
    var key = project + "_" + path;
    var img = cache$j.get(key);
    if (img) {
      return img;
    }
    if (!reqMap[key]) {
      var params = {
        cmd: DOWNLOAD_BASE64_IMAGE,
        service: ServiceName.BASE64_IMAGE,
        path,
        formKey,
        thumbnail,
        sourceType,
        project,
        r: Math.random()
      };
      reqMap[key] = this.request.getData(params).then((data2) => {
        cache$j.put(key, data2);
        return data2;
      }).catch((e) => {
      }).finally(function() {
        setTimeout(function() {
          delete reqMap[key];
        }, ImgSetting.DelayTime);
      });
    }
    return reqMap[key];
  }
}
const DOWNLOAD_PROCESS_GRAPH = "DownloadProcessGraph";
const KILL_INSTACNCE = "KillInstance";
const RESTART_INSTANCE = "RestartInstance";
const RECALL_INSTANCE = "RecallInstance";
const START_INSTANCE = "StartInstance";
const REBIND_INSTANCE = "RebindInstance";
const RESTART_INSTANCE_BY_OID = "RestartInstanceByOID";
const IS_INSTANCE_STARTED = "IsInstanceStarted";
const END_INSTANCE = "EndInstance";
const BATCH_ENDORSE_TASK = "BatchEndorseTask";
const PAUSE_INSTANCE = "PauseInstance";
const RESUME = "Resume";
const COMMIT_WORKITEM = "CommitWorkitem";
const LOAD_WORKITEM_INFO = "LoadWorkitemInfo";
const BATCH_COMMIT_WORKITEM = "BatchCommitWorkitem";
const BATCH_COMMIT_WORKITEM_By_WID = "BatchCommitWorkitemByWID";
const IS_TRANSIT = "IsTransit";
const REVOKE_WORKITEM = "RevokeWorkitem";
const ROLLBACK_TO_WORKITEM = "RollbackToWorkitem";
const FORCIBLE_MOVE = "ForcibleMove";
const BATCH_STATE_ACTION = "BatchStateAction";
const ADD_DELEGATE_DATA = "AddDelegateData";
const DELETE_DELEGATE_DATA = "DeleteDelegateData";
const UPDATE_DELEGATE_DATA_STATE = "UpdateDelegateDataState";
const REGISTER_ATTACHMENT = "RegisterAttachment";
const LOAD_PROCESS_PATH = "LoadProcessPath";
const LAUNCH_TASK = "LaunchTask";
const ENDORSE_TASK = "EndorseTask";
const TRANSFER_TASK = "TransferTask";
const REFUSE_TASK = "RefuseTask";
const REFUSE_TO_OPERATOR = "RefuseToOperator";
const GET_VALID_NODES = "GetValidNodes";
const TRANSFER_TO_NODE = "TransferToNode";
const DIR_START_INSTANCE = "DirStartInstance";
const REVIVE_INSTANCE = "ReviveInstance";
const DISTRIBUTE_WORKITEM = "DistributeWorkitem";
const CANCEL_DISTRIBUTE_WORKITEM = "CancelDistributeWorkitem";
const BATCH_DISTRIBUTE_WORKITEM = "BatchDistributeWorkitem";
const MANUAL_TRANSFER_TO_NODE = "ManualTransferToNode";
const ADD_PARTICIPATORS = "AddParticipators";
const RESEND_MESSAGE = "ResendMessage";
const UPDATE_USERINFO = "UpdateUserInfo";
const DEPLOY_DBPROCESS = "DeployDBProcess";
const HOT_DEPLOY_PROCESS = "HotDeployProcess";
const REVOKE_DEPLOY_PROCESS = "RevokeDeployProcess";
const GET_NEXT_NODE_PARTICIPATOR = "GetNextNodeParticipator";
class BPMService {
  constructor(form) {
    this.form = form;
    this.request = new Request$1(form);
  }
  /**
   * 获取流程图数据
   */
  getProcessGraph(processKey, processVer, OID) {
    var params = {
      cmd: DOWNLOAD_PROCESS_GRAPH,
      service: ServiceName.BPM_DEF_SERVICE,
      processKey,
      processVer,
      OID
    };
    return this.request.getData(params);
  }
  /**
   * 关闭流程
   */
  killInstance(form, instanceID, userinfo) {
    var params = {
      service: ServiceName.BPM,
      cmd: KILL_INSTACNCE,
      instanceID,
      userInfo: userinfo,
      parameters: form.getParas().toJSON()
    };
    return this.request.getData(params);
  }
  /**
   * 重启流程
   */
  restartInstance(instanceID) {
    var _a;
    var params = {
      service: ServiceName.BPM,
      cmd: RESTART_INSTANCE,
      parameters: (_a = this.form) == null ? void 0 : _a.getParas().toJSON(),
      instanceID
    };
    return this.request.getData(params);
  }
  /**
   * 召回一个流程
   */
  recallInstance(instanceID, userinfo) {
    var params = {
      service: ServiceName.BPM,
      cmd: RECALL_INSTANCE,
      instanceID,
      userInfo: userinfo
    };
    return this.request.getData(params);
  }
  /**
  * 召回一个流程
  */
  recallInstanceByOID(oid, userinfo) {
    var params = {
      service: ServiceName.BPM,
      cmd: RECALL_INSTANCE,
      OID: oid,
      userInfo: userinfo
    };
    return this.request.getData(params);
  }
  /**
  * 启动流程
  */
  startInstance(formKey, oid, processKey, formDoc2) {
    var _a;
    var doc = DataUtil$1.toJSONDoc(formDoc2);
    var params = {
      service: ServiceName.BPM,
      cmd: START_INSTANCE,
      parameters: (_a = this.form) == null ? void 0 : _a.getParas().toJSON(),
      formKey,
      oid,
      processKey,
      document: JSON.stringify(doc)
    };
    return this.request.getData(params);
  }
  /**
   * 重新绑定流程
   */
  rebindInstance(formKey, oid, processKey, formDoc2) {
    var doc = DataUtil$1.toJSONDoc(formDoc2);
    var params = {
      service: ServiceName.BPM,
      cmd: REBIND_INSTANCE,
      formKey,
      oid,
      processKey,
      document: JSON.stringify(doc)
    };
    return this.request.getData(params);
  }
  /**
  * 重启流程
  */
  restartInstanceByOID(oid) {
    var params = {
      service: ServiceName.BPM,
      cmd: RESTART_INSTANCE_BY_OID,
      OID: oid
    };
    return this.request.getData(params);
  }
  /**
   * 单据对应的流程是否启动
   */
  isInstanceStarted(oid) {
    var params = {
      service: ServiceName.BPM,
      cmd: IS_INSTANCE_STARTED,
      OID: oid
    };
    return this.request.getData(params);
  }
  /**
   * 结束一个流程实例
   */
  endInstance(form, instanceID, userinfo) {
    var params = {
      service: ServiceName.BPM,
      cmd: END_INSTANCE,
      instanceID,
      userInfo: userinfo,
      parameters: form.getParas().toJSON()
    };
    return this.request.getData(params);
  }
  /**
   * 批量加签：指的是同时对多人进行加签，并可指定同时或者按顺序执行，默认同时执行。参数【workitemID,operatorList,launchInfo,inOrder】
   * <ul>
   * <li> workitemID: 工作项ID
   * <li> operatorList: 被加签操作员ID集合,支持的参数类型：
   * <ol>
   * <li>集合类型，如ArrayList,大多使用于多选字典的值 
   * <li>以逗号“,”分隔的字符串，如{1,2,3}或“1,2,3”
   * <li>Long类型，此时指的是单个操作员
   * </ol>
   * <li> launchInfo: 加签发起人的意见
   * <li> inOrder: 可选参数 ，是否顺序执行，默认为false
   * </ul>
   * @author wbh
   *
   */
  batchEndorseTask(wid, ppObject, launchInfo, inOrder, hide) {
    var params = {
      service: ServiceName.BPM_EXTEND,
      cmd: BATCH_ENDORSE_TASK,
      WorkitemID: wid,
      PPObject: JSON.stringify(ppObject.toJSON()),
      LaunchInfo: launchInfo,
      InOrder: inOrder,
      Hide: hide
    };
    return this.request.getData(params);
  }
  /**
  * 暂停一个流程实例
  */
  pauseInstance(form, instanceID, userinfo) {
    var params = {
      service: ServiceName.BPM,
      cmd: PAUSE_INSTANCE,
      instanceID,
      userInfo: userinfo,
      parameters: form.getParas().toJSON()
    };
    return this.request.getData(params);
  }
  /**
   * 取消暂停一个流程实例
   */
  resume(form, instanceID, userinfo) {
    var params = {
      service: ServiceName.BPM,
      cmd: RESUME,
      instanceID,
      userInfo: userinfo,
      parameters: form.getParas().toJSON()
    };
    return this.request.getData(params);
  }
  /**
   * 提交一个工作项
   */
  commitWorkitem(workitemInfo, formDoc2) {
    var doc = DataUtil$1.toJSONDoc(formDoc2);
    var params = {
      service: ServiceName.BPM,
      cmd: COMMIT_WORKITEM,
      workitemInfo: JSON.stringify(workitemInfo),
      document: JSON.stringify(doc)
    };
    return this.request.getData(params);
  }
  /**
  * 查询一个工作项
  */
  loadWorkitemInfo(workitemID) {
    var params = {
      service: ServiceName.BPM,
      cmd: LOAD_WORKITEM_INFO,
      workitemID
    };
    return this.request.getData(params);
  }
  /**
   * 批量提交工作项
   */
  batchCommitWorkitem(oids, result, userInfo) {
    var params = {
      service: ServiceName.BPM,
      cmd: BATCH_COMMIT_WORKITEM,
      OIDListStr: JSON.stringify(oids),
      binaryResult: result,
      userInfo
    };
    return this.request.getData(params);
  }
  /**
   * 批量提交工作项
   */
  batchCommitWorkitemByWID(wids, result, userInfo) {
    var params = {
      service: ServiceName.BPM,
      cmd: BATCH_COMMIT_WORKITEM_By_WID,
      WIDListStr: JSON.stringify(wids),
      binaryResult: result,
      userInfo
    };
    return this.request.getData(params);
  }
  /**
   * 是否转办
   */
  isTransit(WorkitemID) {
    var params = {
      service: ServiceName.BPM,
      cmd: IS_TRANSIT,
      workitemID: WorkitemID
    };
    return this.request.getData(params);
  }
  revokeWorkitem(workitemID, userInfo) {
    var params = {
      service: ServiceName.BPM,
      cmd: REVOKE_WORKITEM,
      workitemID,
      userInfo
    };
    return this.request.getData(params);
  }
  /**
   * 回滚
   */
  rollbackToWorkitem(workitemID, logicCheck) {
    var params = {
      service: ServiceName.BPM,
      cmd: ROLLBACK_TO_WORKITEM,
      workitemID,
      logicCheck
    };
    return this.request.getData(params);
  }
  forcibleMove(instanceID, srcNode, tgtNode) {
    var params = {
      service: ServiceName.BPM,
      cmd: FORCIBLE_MOVE,
      instanceID,
      sourceNode: srcNode,
      targetNode: tgtNode
    };
    return this.request.getData(params);
  }
  /**
   * 在叙事薄界面为勾选的若个单据，进行批量审批
   */
  batchStateAction(processKey, actionNodeKey, oids, result, userInfo) {
    var params = {
      service: ServiceName.BPM,
      cmd: BATCH_STATE_ACTION,
      OIDListStr: JSON.stringify(oids),
      processKey,
      binaryResult: result,
      userInfo,
      actionNodeKey
    };
    return this.request.getData(params);
  }
  /**
  * 添加代理
  */
  addDelegateData(delegateType, srcOperatorID, tgtOperatorID, objectType, objectKey, nodeKey, startTime, endTime, alwaysValid, userInfo) {
    var params = {
      service: ServiceName.BPM,
      cmd: ADD_DELEGATE_DATA,
      delegateType,
      srcOperatorID,
      tgtOperatorID,
      objectType,
      objectKey,
      nodeKey,
      startTime: startTime && startTime.getTime(),
      endTime: endTime && endTime.getTime(),
      alwaysValid,
      userInfo
    };
    return this.request.getData(params);
  }
  /**
  * 删除代理
  */
  deleteDelegateData(delegateID, userInfo) {
    var params = {
      service: ServiceName.BPM,
      cmd: DELETE_DELEGATE_DATA,
      delegateID,
      userInfo
    };
    return this.request.getData(params);
  }
  /**
  * 修改代理
  */
  updateDelegateDataState(delegateID, onUse) {
    var params = {
      service: ServiceName.BPM,
      cmd: UPDATE_DELEGATE_DATA_STATE,
      delegateID,
      onUse
    };
    return this.request.getData(params);
  }
  /**
   * 注册附件
   */
  registerAttachment(oid, key, attachmentOID, attachmentInfo, attachmentPara) {
    var params = {
      service: ServiceName.BPM,
      cmd: REGISTER_ATTACHMENT,
      OID: oid,
      Key: key,
      AttachmentOID: attachmentOID,
      AttachmentInfo: attachmentInfo,
      AttachmentPara: attachmentPara
    };
    return this.request.getData(params);
  }
  /**
   * 生成当前流程运转路径
   */
  loadProcessPath(oid) {
    var params = {
      service: ServiceName.BPM_DEF_SERVICE,
      cmd: LOAD_PROCESS_PATH,
      OID: oid
    };
    return this.request.getData(params);
  }
  /**
   * 在指定的工作项上发起加签动作，会产生一个新的加签工作项，只有这个加签工作项被提交了，当前工作项才可以被提交
   */
  launchTask(wid, nodeKey, ppObject, launchInfo, hideActiveWorkitem) {
    var params = {
      service: ServiceName.BPM_EXTEND,
      cmd: LAUNCH_TASK,
      WorkitemID: wid,
      NodeKey: nodeKey,
      HideActiveWorkitem: hideActiveWorkitem,
      LaunchInfo: launchInfo,
      PPObject: JSON.stringify(ppObject.toJSON())
    };
    return this.request.getData(params);
  }
  /**
   * 在指定的工作项上发起加签动作，会产生一个新的加签工作项，只有这个加签工作项被提交了，当前工作项才可以被提交
   */
  endorseTask(wid, operatorID, launchInfo, hide) {
    var params = {
      service: ServiceName.BPM_EXTEND,
      cmd: ENDORSE_TASK,
      WorkitemID: wid,
      OperatorID: operatorID,
      LaunchInfo: launchInfo,
      Hide: hide
    };
    return this.request.getData(params);
  }
  /**
   * 移交工作项
   */
  transferTask(wid, operatorID, createRecord, userinfo, auditResult, srcOperator, transferType) {
    var params = {
      service: ServiceName.BPM_EXTEND,
      cmd: TRANSFER_TASK,
      WorkitemID: wid,
      OperatorID: operatorID,
      CreateRecord: createRecord,
      UserInfo: userinfo,
      AuditResult: auditResult,
      SrcOpt: srcOperator,
      TransferType: transferType
    };
    return this.request.getData(params);
  }
  refuseTask(wid, auditResult, userInfo) {
    var params = {
      service: ServiceName.BPM_EXTEND,
      cmd: REFUSE_TASK,
      workitemID: wid,
      auditResult,
      userInfo
    };
    return this.request.getData(params);
  }
  refuseToOperator(info, operatorID) {
    var params = {
      service: ServiceName.BPM,
      cmd: REFUSE_TO_OPERATOR,
      workitemInfo: JSON.stringify(info),
      operatorID
    };
    return this.request.getData(params);
  }
  /**
   * 获得可驳回节点
   */
  getValidNodes(nodeID, processKey, instanceid, ignoreDeep, version) {
    var params = {
      service: ServiceName.BPM,
      cmd: GET_VALID_NODES,
      nodeID,
      processKey,
      instanceID: instanceid,
      ignoreDeep,
      version
    };
    return this.request.getData(params);
  }
  /**
   * 直送工作项
   */
  transferToNode(workiteminfo, formDoc2) {
    var doc = DataUtil$1.toJSONDoc(formDoc2);
    var params = {
      service: ServiceName.BPM,
      cmd: TRANSFER_TO_NODE,
      workiteminfo: JSON.stringify(workiteminfo),
      document: JSON.stringify(doc)
    };
    return this.request.getData(params);
  }
  /**
   * 直送启动
   */
  dirStratInstance(instanceID, auditResult, formDoc2, keepParts) {
    var _a;
    var doc = DataUtil$1.toJSONDoc(formDoc2);
    var params = {
      service: ServiceName.BPM,
      cmd: DIR_START_INSTANCE,
      parameters: (_a = this.form) == null ? void 0 : _a.getParas().toJSON(),
      InstanceID: instanceID,
      document: JSON.stringify(doc),
      auditResult,
      keepParts
    };
    return this.request.getData(params);
  }
  /**
   * 从结束状态复活一个流程实例
   */
  reviveInstance(form, instanceID, userinfo) {
    var params = {
      service: ServiceName.BPM,
      cmd: REVIVE_INSTANCE,
      InstanceID: instanceID,
      userInfo: userinfo,
      parameters: form.getParas().toJSON()
    };
    return this.request.getData(params);
  }
  distributeWorkitem(workitemID, operatorID) {
    var params = {
      service: ServiceName.BPM,
      cmd: DISTRIBUTE_WORKITEM,
      workitemID,
      operatorID
    };
    return this.request.getData(params);
  }
  cancelDistributeWorkitem(workitemID) {
    var params = {
      service: ServiceName.BPM,
      cmd: CANCEL_DISTRIBUTE_WORKITEM,
      workitemID
    };
    return this.request.getData(params);
  }
  batchDistributeWorkitem(wids, operatorID) {
    var params = {
      service: ServiceName.BPM,
      cmd: BATCH_DISTRIBUTE_WORKITEM,
      WIDListStr: JSON.stringify(wids),
      operatorID
    };
    return this.request.getData(params);
  }
  manualTransferToNode(info) {
    var params = {
      service: ServiceName.BPM,
      cmd: MANUAL_TRANSFER_TO_NODE,
      manualTransferInfo: JSON.stringify(info)
    };
    return this.request.getData(params);
  }
  /**
   * 新增参与者<br>
   * 参数：【operatorList, nodeKey, instanceID, isInsert】
   * <ul>
   * <li> operatorList: 新增人员集合,支持的参数类型：
   * <ol>
   * <li>集合类型，如ArrayList,大多使用于多选字典的值 
   * <li>以逗号“,”分隔的字符串，如{1,2,3}或“1,2,3”
   * <li>Long类型，此时指的是单个操作员
   * </ol>	
   * <li> nodeKey: 目标节点
   * <li> instanceID: 流程实例ID
   * <li> isInsert: 是否insert新增人员
   * </ul>
   * @author gwj
   *
   */
  addParticipators(opList, nodeKey, instanceID, isInsert) {
    var params = {
      service: ServiceName.BPM,
      cmd: ADD_PARTICIPATORS,
      operatorListStr: JSON.stringify(opList),
      nodeKey,
      instanceID,
      isInsert
    };
    return this.request.getData(params);
  }
  resendMessage(nodeID, instanceID, inlineNodeID) {
    var params = {
      service: ServiceName.BPM,
      cmd: RESEND_MESSAGE,
      nodeID,
      instanceID,
      inlineNodeID
    };
    return this.request.getData(params);
  }
  /**
   * 修改审批意见
   */
  updateUserInfo(workitemID, userInfo) {
    var params = {
      service: ServiceName.BPM,
      cmd: UPDATE_USERINFO,
      workitemID,
      userInfo
    };
    return this.request.getData(params);
  }
  deployDBProcess(processKey, version) {
    var params = {
      service: ServiceName.BPM,
      cmd: DEPLOY_DBPROCESS,
      processKey,
      version
    };
    return this.request.getData(params);
  }
  hotDeployProcess(processKey, verID, formKey, dataObjectKey) {
    var params = {
      service: ServiceName.BPM,
      cmd: HOT_DEPLOY_PROCESS,
      processKey,
      verID,
      formKey,
      dataObjectKey
    };
    return this.request.getData(params);
  }
  revokeDeployProcess(processKey, verID, formKey, dataObjectKey) {
    var params = {
      service: ServiceName.BPM,
      cmd: REVOKE_DEPLOY_PROCESS,
      processKey,
      verID,
      formKey,
      dataObjectKey
    };
    return this.request.getData(params);
  }
  getNextNodeParticipator(workitemID, processKey) {
    var params = {
      service: ServiceName.BPM,
      cmd: GET_NEXT_NODE_PARTICIPATOR,
      workitemID,
      processKey
    };
    return this.request.getData(params).then((table) => {
      if (table) {
        table.first();
      }
      return table;
    });
  }
}
const BATCH_MID_MAP = "BatchMidMap";
const MID_MAP = "MidMap";
class DataMapService {
  constructor(form) {
    this.form = form;
    this.request = new Request$1(form);
  }
  /**
   * 中间层批量下推
   */
  batchMidMap(mapKey, oids, sysTopic) {
    var params = {
      service: ServiceName.MAP_DATA,
      cmd: BATCH_MID_MAP,
      MapKey: mapKey,
      sysTopic,
      OIDListStr: JSON.stringify(oids)
    };
    return this.request.getData(params);
  }
  mapData(mapKey, srcFormKey, tgtFormKey, srcDoc, tgtDoc) {
    var paras = {
      service: ServiceName.MAP_DATA,
      cmd: MID_MAP,
      mapKey,
      tgtFormKey,
      srcFormKey,
      srcDoc: JSON.stringify(srcDoc)
    };
    tgtDoc != null && (paras.tgtDoc = JSON.stringify(tgtDoc));
    return this.request.getData(paras);
  }
  midMap(mapKey, tgtFormKey, oid, sysTopic) {
    var paras = {
      service: ServiceName.MAP_DATA,
      cmd: MID_MAP,
      mapKey,
      tgtFormKey,
      srcOID: oid,
      sysTopic
    };
    return this.request.getData(paras);
  }
  autoMap(mapKey, srcDoc, sysTopic) {
    var paras = {
      service: ServiceName.MAP_DATA,
      cmd: MID_MAP,
      mapKey,
      srcDoc: JSON.stringify(srcDoc),
      saveTarget: true,
      sysTopic
    };
    return this.request.getData(paras);
  }
}
const RE_MIGRATE = "ReMigrate";
const ROLL_DATA = "RollData";
class DataMigrationService {
  constructor(form) {
    this.form = form;
    this.request = new Request$1(form);
  }
  reMigrate(dataObjectKey) {
    var params = {
      service: ServiceName.MIGRATION,
      cmd: RE_MIGRATE,
      dataObjectKey
    };
    return this.request.getData(params);
  }
  rollData(objectKey, endPeriod, group) {
    var params = {
      service: ServiceName.MIGRATION,
      cmd: ROLL_DATA,
      dataObjectKey: objectKey,
      endPeriod,
      group: JSON.stringify(group)
    };
    return this.request.getData(params);
  }
}
class ControlType {
}
ControlType.PANEL = 0;
ControlType.COLUMNLAYOUTPANEL = 1;
ControlType.GRIDLAYOUTPANEL = 2;
ControlType.SPLITPANEL = 3;
ControlType.PAGEPANEL = 4;
ControlType.TABPANEL = 5;
ControlType.HTMLPANEL = 6;
ControlType.FLOWLAYOUTPANEL = 7;
ControlType.BORDERLAYOUTPANEL = 8;
ControlType.FLEXFLOWLAYOUTPANEL = 9;
ControlType.TABLELAYOUTPANEL = 10;
ControlType.FLUIDTABLELAYOUTPANEL = 11;
ControlType.WIZARDPANEL = 12;
ControlType.LINEARLAYOUTPANLE = 13;
ControlType.SLIDINGLAYOUTPANEL = 14;
ControlType.CUSTOMLAYOUTPANEL = 15;
ControlType.FLEXBOXPANEL = 16;
ControlType.COLLAPSEPANEL = 17;
ControlType.BUTTON = 200;
ControlType.CHECKBOX = 201;
ControlType.CHECKLISTBOX = 202;
ControlType.COLORPICKER = 203;
ControlType.COMBOBOX = 204;
ControlType.DATEPICKER = 205;
ControlType.DICT = 206;
ControlType.FONTPICKER = 207;
ControlType.HYPERLINK = 208;
ControlType.LABEL = 209;
ControlType.NUMBEREDITOR = 210;
ControlType.IMAGE = 211;
ControlType.PROGRESSBAR = 212;
ControlType.RADIOBUTTON = 213;
ControlType.TEXTBUTTON = 214;
ControlType.TEXTEDITOR = 215;
ControlType.LISTVIEW = 216;
ControlType.GRID = 217;
ControlType.IMAGELIST = 218;
ControlType.MASKEDITOR = 219;
ControlType.TREEVIEW = 220;
ControlType.MENUBAR = 221;
ControlType.TREEMENUBAR = 222;
ControlType.TOOLBAR = 223;
ControlType.CALENDAR = 224;
ControlType.RICHEDITOR = 225;
ControlType.CHART = 226;
ControlType.MAP = 227;
ControlType.CONTAINER = 228;
ControlType.STATUSBAR = 229;
ControlType.BUTTON_GROUP = 230;
ControlType.SEPARATOR = 231;
ControlType.TOGGLEBUTTON = 232;
ControlType.WEBBROWSER = 233;
ControlType.PASSWORDEDITOR = 234;
ControlType.TREEMENU = 235;
ControlType.SPLITBUTTON = 236;
ControlType.DROPDOWNBUTTON = 237;
ControlType.EMBEDSUB = 238;
ControlType.BPM_GRAPH = 239;
ControlType.UPLOADBUTTON = 240;
ControlType.DYNAMICDICT = 241;
ControlType.COMPDICT = 242;
ControlType.STATELIST = 243;
ControlType.DICTVIEW = 244;
ControlType.ATTACHMENT = 245;
ControlType.TEXTAREA = 246;
ControlType.SUBDETAIL = 247;
ControlType.DIALOG = 248;
ControlType.FILECHOOSER = 251;
ControlType.EMBED = 253;
ControlType.UTCDATEPICKER = 254;
ControlType.ROTATOR = 256;
ControlType.GALLERY = 257;
ControlType.TILEDLIST = 258;
ControlType.WATERFALL = 259;
ControlType.SEGMENTEDCONTROL = 260;
ControlType.TABGROUP = 262;
ControlType.ROTATORLIST = 263;
ControlType.TABLEVIEW = 264;
ControlType.TABLEVIEWROW = 26401;
ControlType.TABLEVIEWFIXROW = 26402;
ControlType.TABLEVIEWDETAILROW = 26403;
ControlType.STEPEDITOR = 265;
ControlType.POPVIEW = 266;
ControlType.WIZARDLIST = 267;
ControlType.REFRESHCONTROL = 268;
ControlType.DYNAMIC = 20001;
ControlType.ICON = 270;
ControlType.IMAGEBUTTON = 271;
ControlType.SCOREBAR = 272;
ControlType.SWITCH = 275;
ControlType.POPBUTTON = 276;
ControlType.SLIDER = 277;
ControlType.NUMBERINFOEDITOR = 278;
ControlType.PROGRESSINDICATOR = 279;
ControlType.SHRINKVIEW = 280;
ControlType.COUNTDOWNVIEW = 281;
ControlType.GIFIMAGE = 282;
ControlType.VALIDATEBOX = 283;
ControlType.MONTHPICKER = 284;
ControlType.TIMEPICKER = 285;
ControlType.EMPTY = 286;
ControlType.COUNTUP = 287;
ControlType.TIMEZONEDATEPICKER = 288;
ControlType.DATERANGEPICKER = 289;
ControlType.CAROUSEL = 290;
ControlType.BATCHIMAGEUPLOADER = 291;
ControlType.LISTLAYOUTVIEW = 300;
ControlType.MULTISTATEBUTTON = 301;
ControlType.COMBOVIEW = 302;
ControlType.DICTPANE = 303;
ControlType.DICTSEARCHBOX = 304;
ControlType.EDITVIEW = 305;
ControlType.COLLECTIONVIEW = 306;
ControlType.VIDEOPLAYER = 307;
ControlType.BARCODER = 308;
ControlType.MODULEEDITOR = 309;
ControlType.NOTICEBAR = 310;
ControlType.TIMECOUNTDOWN = 311;
ControlType.PRICELABEL = 312;
ControlType.RELATIVETIME = 313;
ControlType.HOVERBUTTON = 314;
ControlType.DRAWERBOX = 315;
ControlType.FLEXGRIDLAYOUTPANEL = 316;
ControlType.CUSTOM = 1e4;
ControlType.BLOCK = 2e4;
ControlType.NAVIGATIONLIST = 3e4;
ControlType.NAVIGATIONBAR = 4e4;
ControlType.GANTT = 269;
const GroupCode$3 = 32779;
class _ViewException extends CoreException {
  constructor(code, args) {
    var message = formatMessage$3(code, ...args);
    var c = GroupCode$3 << 16 | code;
    super(c, message);
    this.name = "YIUI.CoreException";
  }
  setSourceComponent(sourceComponent) {
    this.sourceComponent = sourceComponent;
    return this;
  }
  getSourceComponent() {
    return this.sourceComponent;
  }
}
const COMPONENT_CHECK_ERROR = (...args) => {
  return new _ViewException(COMPONENT_CHECK_ERROR$1, args);
};
const DATA_BINDING_ERROR = (...args) => {
  return new _ViewException(DATA_BINDING_ERROR$1, args);
};
const COMPONENT_REQUIRED = (...args) => {
  return new _ViewException(COMPONENT_REQUIRED$1, args);
};
const COMPONENT_NOT_EXISTS = (...args) => {
  return new _ViewException(COMPONENT_NOT_EXISTS$1, args);
};
const COMPDICT_CANNOT_SET_MULTIDICT = (...args) => {
  return new _ViewException(COMPDICT_CANNOT_SET_MULTIDICT$1, args);
};
const DYNAMICDICT_ITEMKEY_NULL = (...args) => {
  return new _ViewException(DYNAMICDICT_ITEMKEY_NULL$1, args);
};
const COMPDICT_ITEMKEY_NULL = (...args) => {
  return new _ViewException(COMPDICT_ITEMKEY_NULL$1, args);
};
const Date_Diff_Param_Error = (...args) => {
  return new _ViewException(Date_Diff_Param_Error$1, args);
};
const PRIMARYKEYS_ERROR = (...args) => {
  return new _ViewException(PRIMARYKEYS_ERROR$1, args);
};
const FORM_CHECK_ERROR = (...args) => {
  return new _ViewException(FORM_CHECK_ERROR$1, args);
};
const GRID_ROW_ERROR = (...args) => {
  return new _ViewException(GRID_ROW_ERROR$1, args);
};
const GRID_CELL_ERROR = (...args) => {
  return new _ViewException(GRID_CELL_ERROR$1, args);
};
const GRID_CELL_REQUIRED = (...args) => {
  return new _ViewException(GRID_CELL_REQUIRED$1, args);
};
const GRID_CELL_INFINITY = (...args) => {
  return new _ViewException(GRID_CELL_INFINITY$1, args);
};
const UNEQUAL_PARAM_NUM$1 = (...args) => {
  return new _ViewException(UNEQUAL_PARAM_NUM$2, args);
};
const BuddyKey_NOT_EXISTS = (...args) => {
  return new _ViewException(BUDDYKEY_NOT_EXISTS, args);
};
const DATAROW_NO_PRIMARYKEYS = (...args) => {
  return new _ViewException(DATAROW_NO_PRIMARYKEYS$1, args);
};
const MAP_MISS_FORMKEY = (...args) => {
  return new _ViewException(MAP_MISS_FORMKEY$1, args);
};
const FORM_SERIALIZATION_ERROR = (...args) => {
  return new _ViewException(FORM_SERIALIZATION_ERROR$1, args);
};
const FORM_UNDEFINEDR = (...args) => {
  return new _ViewException(FORM_UNDEFINED, args);
};
const COMPONENT_INFINITY = (...args) => {
  return new _ViewException(COMPONENT_INFINITY$1, args);
};
const checkCompState$1 = (comp) => {
  if (!comp || comp.isDestroyed) {
    throw new Exception(-1, "组件已销毁", true);
  }
};
class UIUtil {
  static getComponentValue(control, dataTable, columnKey) {
    var value = dataTable.getByKey(columnKey);
    if (value === null) {
      return value;
    }
    var result, type = control.type, itemKey;
    switch (type) {
      case ControlType.DICT:
      case ControlType.DYNAMICDICT:
      case ControlType.COMPDICT:
        itemKey = control.itemKey;
        if (control.multiSelect) {
          if (TypeConvertor.toString(value).length == 0) {
            break;
          }
          if (type == ControlType.DYNAMICDICT) {
            itemKey = dataTable.getByKey(columnKey + "ItemKey");
          }
          if (itemKey) {
            var oids = TypeConvertor.toString(value).split(","), oid, list = [];
            for (var i2 = 0, size2 = oids.length; i2 < size2; i2++) {
              oid = TypeConvertor.toLong(oids[i2]);
              list.push(new ItemData({
                oid,
                itemKey
              }));
            }
            result = list;
          }
          if (type == ControlType.COMPDICT)
            ;
        } else {
          if (TypeConvertor.toLong(value) <= 0 && !control.isEditValue) {
            break;
          }
          if (type == ControlType.DYNAMICDICT || type == ControlType.COMPDICT) {
            itemKey = dataTable.getByKey(columnKey + "ItemKey");
          }
          if (!control.isEditValue) {
            var oid = TypeConvertor.toLong(value);
            result = new ItemData({
              oid,
              itemKey
            });
          } else {
            result = new ItemData({
              itemKey,
              editValue: value,
              oid: -1
            });
          }
        }
        break;
      default:
        result = value;
        break;
    }
    return result;
  }
  static getCellValue(control, table, form) {
    var compValue = null;
    var value = null;
    var columnKey = control.columnKey;
    if (table.isValid()) {
      if (control.dbIndex >= 0) {
        value = table.get(control.dbIndex);
      } else {
        value = table.getByKey(columnKey);
      }
    }
    if (value === null) {
      return value;
    }
    var type = control.cellType || control.type;
    var itemKey;
    switch (type) {
      case ControlType.DICT:
      case ControlType.COMPDICT:
      case ControlType.DYNAMICDICT:
        itemKey = control.itemKey || control.editOptions.itemKey;
        if (control.editOptions.multiSelect) {
          if (type == ControlType.DYNAMICDICT) {
            let refDataElementKey = control.editOptions.refDataElementKey;
            if (refDataElementKey) {
              let dataElementCmp = form.getCellLocation(refDataElementKey);
              if (!dataElementCmp) {
                throw COMPONENT_NOT_EXISTS(refDataElementKey);
              }
              refDataElementKey = dataElementCmp.columnKey;
              if (!itemKey) {
                let dataElementKey = table.getByKey(refDataElementKey);
                itemKey = form.getItemKeyByDataElementKey(dataElementKey);
              }
            } else {
              itemKey = table.getByKey(columnKey + "ItemKey");
            }
          }
          if (type == ControlType.COMPDICT) {
            throw COMPDICT_CANNOT_SET_MULTIDICT(control.key);
          }
        } else {
          if (parseInt(value) <= 0 && !control.editOptions.isEditValue) {
            break;
          }
          if (type == ControlType.DYNAMICDICT) {
            let refDataElementKey = control.editOptions.refDataElementKey;
            if (refDataElementKey) {
              let dataElementCmp = form.getCellLocation(refDataElementKey);
              if (!dataElementCmp) {
                throw COMPONENT_NOT_EXISTS(refDataElementKey);
              }
              refDataElementKey = dataElementCmp.columnKey;
              if (!itemKey) {
                let dataElementKey = table.getByKey(refDataElementKey);
                itemKey = form.getItemKeyByDataElementKey(dataElementKey);
              }
            } else {
              if (!itemKey) {
                itemKey = table.getByKey(columnKey + "ItemKey");
              }
            }
            if (itemKey == null || itemKey.length == 0) {
              throw DYNAMICDICT_ITEMKEY_NULL(control.key);
            }
          } else if (type == ControlType.COMPDICT) {
            itemKey = table.getByKey(columnKey + "ItemKey");
            if (itemKey == null || itemKey.length == 0) {
              throw COMPDICT_ITEMKEY_NULL(control.key);
            }
            if (control.multiSelect) {
              throw COMPDICT_CANNOT_SET_MULTIDICT(control.key);
            }
          }
        }
        var codecode = "";
        var col = table.getColByKey(columnKey);
        if (col) {
          var codeColumnKey = col.codeColumnKey;
          if (codeColumnKey) {
            codecode = table.getByKey(codeColumnKey);
          }
        }
        var captionKey = columnKey + "_caption";
        var columnIndex = table.indexByKey(captionKey);
        if (columnIndex === null) {
          if (!control.editOptions.isEditValue) {
            compValue = this.convertDictValue(itemKey, control, value, codecode);
          } else {
            if (control.editOptions.multiSelect) {
              var list = value.split(",");
              var vals = [];
              for (var i2 = 0; i2 < list.length; i2++) {
                vals.push(new ItemData({
                  itemKey,
                  editValue: list[i2],
                  oid: -1,
                  Code: codecode
                }));
              }
              compValue = vals;
            } else {
              compValue = new ItemData({
                itemKey,
                editValue: value,
                oid: -1
              });
            }
          }
        }
        break;
      default:
        compValue = value;
    }
    return compValue;
  }
  static convertDictValue(itemKey, control, value, code) {
    var ret = null;
    if (control.editOptions.multiSelect) {
      var ids = value;
      if (ids.length > 0) {
        var oids = ids.split(",");
        if (oids.length > 0) {
          var list = [];
          for (var i2 = 0, len = oids.length; i2 < len; i2++) {
            list.push(new ItemData({
              itemKey,
              oid: oids[i2],
              Code: code
            }));
          }
          ret = list;
        }
      }
    } else {
      var oid = parseFloat(value);
      ret = new ItemData({
        itemKey,
        oid,
        Code: code
      });
    }
    return ret;
  }
  static isNull(v) {
    return v == void 0 || v == null;
  }
  static getCompareType(v1, v2) {
    var type = -1;
    if (this.isNull(v1)) {
      var temp = v2;
      v2 = v1;
      v1 = temp;
    }
    if (this.isNull(v1)) {
      type = DataType.NUMERIC;
    } else if (typeof v1 == "string") {
      if (Utils.isNumeric(v1)) {
        type = DataType.NUMERIC;
      } else {
        type = DataType.STRING;
      }
    } else if (typeof v1 == "number") {
      if (this.isNull(v2)) {
        type = DataType.NUMERIC;
      } else if (typeof v2 == "string") {
        type = DataType.STRING;
      } else {
        type = DataType.NUMERIC;
      }
    } else if (typeof v1 == "boolean") {
      if (this.isNull(v2)) {
        type = DataType.NUMERIC;
      } else if (typeof v2 == "number" || v2 instanceof Decimal) {
        type = DataType.NUMERIC;
      } else if (typeof v2 == "string") {
        type = DataType.STRING;
      } else if (typeof v2 == "boolean") {
        type = DataType.BOOLEAN;
      }
    } else if (v1 instanceof Decimal) {
      if (this.isNull(v2)) {
        type = DataType.NUMERIC;
      } else if (typeof v2 == "number" || v2 instanceof Decimal) {
        type = DataType.NUMERIC;
      } else if (typeof v2 == "string") {
        type = DataType.STRING;
      } else if (typeof v2 == "boolean") {
        type = DataType.BOOLEAN;
      }
    }
    return type;
  }
  static dataType2JavaDataType(dataType) {
    switch (dataType) {
      case DataType.LONG:
        return JavaDataType.USER_LONG;
      case DataType.BINARY:
        return JavaDataType.USER_BINARY;
      case DataType.BOOLEAN:
        return JavaDataType.USER_BOOLEAN;
      case DataType.DATE:
      case DataType.DATETIME:
        return JavaDataType.USER_DATETIME;
      case DataType.DOUBLE:
      case DataType.FLOAT:
      case DataType.NUMERIC:
        return JavaDataType.USER_NUMERIC;
      case DataType.INT:
        return JavaDataType.USER_INT;
      case DataType.STRING:
      case DataType.TEXT:
      case DataType.FIXED_STRING:
        return JavaDataType.USER_STRING;
    }
    return -1;
  }
  static randomString(len) {
    var $chars = "ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678";
    var maxPos = $chars.length;
    var s = "";
    for (var i2 = 0; i2 < len; i2++) {
      s += $chars.charAt(Math.floor(Math.random() * maxPos));
    }
    return s;
  }
  static getComsInfo(form) {
    var getInfo = function(com2) {
      var cInfo = {};
      cInfo.caption = com2.getCaption();
      cInfo.visible = com2.isVisible();
      cInfo.enable = com2.isEnable();
      if (com2.type == ControlType.GRID || com2.type == ControlType.LISTVIEW) {
        var colInfo = [], columns = com2.getColumns();
        columns.forEach(function(column) {
          var info2 = {};
          info2.key = column.key;
          info2.caption = column.caption || column.label;
          info2.visible = column.visible;
          colInfo.push(info2);
        });
        cInfo.columns = colInfo;
      }
      return cInfo;
    };
    var getCellInfo = function(grid) {
      for (var i22 = 0, size2 = grid.getRowCount(); i22 < size2; i22++) {
        var rowData = grid.getRowDataAt(i22);
        if (rowData.rowType != "Fix") {
          continue;
        }
        var metaRow = rowData.meta;
        for (var k = 0, length2 = metaRow.cells.length; k < length2; k++) {
          var metaCell = metaRow.cells[k];
          var caption = rowData.data[k].caption || metaCell.caption;
          info[metaCell.key] = {
            caption
          };
        }
      }
    };
    var info = {};
    var list = form.getComponentList(), com;
    for (var i2 = 0; com = list[i2]; i2++) {
      if (com.bindingCellKey !== null && com.bindingCellKey !== "") {
        continue;
      }
      info[com.key] = getInfo(com);
      if (com.type == ControlType.GRID && com.hasFixRow) {
        getCellInfo(com);
      }
    }
    return info;
  }
}
const JSON_Object = 0;
const JSON_Array = 1;
const convertJSON = (para) => {
  var json = {};
  if (para == null) {
    json.value = null;
    json.dataType = -1;
  } else if (para instanceof ItemData) {
    json.value = para;
    json.dataType = 12;
  } else if (para instanceof DataTable) {
    json.value = DataUtil$1.toJSONDataTable(para);
    json.dataType = 9;
  } else if (para instanceof Decimal) {
    json.value = para;
    json.dataType = 4;
  } else if (typeof para == "boolean") {
    json.value = para;
    json.dataType = 6;
  } else if (typeof para == "string") {
    json.value = para;
    json.dataType = 2;
  } else if (Utils.isNumeric(para)) {
    json.value = para;
    json.dataType = 7;
  } else if (para instanceof Date) {
    json.value = para.getTime();
    json.dataType = 3;
  } else {
    json.value = para;
    json.dataType = 2;
  }
  return json;
};
const getJsonType = function(strJson) {
  if (!strJson || typeof strJson !== "string")
    return -1;
  var char = strJson.charAt(0);
  if (char === "{") {
    return JSON_Object;
  } else if (char === "[") {
    return JSON_Array;
  }
  return -1;
};
class YesJSONUtil {
  static toJSONArray(array) {
    if (!array) {
      return null;
    }
    if (!Utils.isArray(array)) {
      return null;
    }
    var jsonArray = new Array();
    for (var i2 = 0; i2 < array.length; i2++) {
      jsonArray[i2] = convertJSON(array[i2]);
    }
    return jsonArray;
  }
  static toJSONObject(obj) {
    if (!obj) {
      return null;
    }
    if (Utils.isEmptyObject(obj)) {
      return null;
    }
    for (var key in obj) {
      obj[key] = convertJSON(obj[key]);
    }
    return obj;
  }
  static isJsonObject(obj) {
    return getJsonType(obj) == JSON_Object;
  }
  static isJsonArray(obj) {
    return getJsonType(obj) == JSON_Array;
  }
}
const GET_QUERY_ITEMS = "getQueryItems";
const GET_FILTER_QUERY_ITEMS = "GetFilterQueryItems";
const GET_DYNAMIC_CELL_KEY = "GetDynamicCellKey";
const GET_COND_SIGN_ITEMS = "GetCondSignItems";
const GET_CONDITION_ITEMS = "GetConditionItems";
const GET_DATA_OBJECT_KEY$1 = "GetDataObjectKey";
const SERVER_DATE = "ServerDate";
const SERVER_DBDATE = "ServerDBDate";
const DBUPDATE = "DBUpdate";
const DBNAMED_UPDATE = "DBNamedUpdate";
const DBQUERY = "DBQuery";
const DBNAMED_QUERY = "DBNamedQuery";
const INVOKE_EXT_SERVICE = "InvokeExtService";
const INVOKE_EXT_SERVICE2 = "InvokeExtService2";
const EVAL_MID_EXP = "EvalMidExp";
const EXPORT_EXCEL = "ExportExcel";
const BATCH_EXPORT_EXCEL = "BatchExportExcel";
const EXPORT_CSV = "ExportCSV";
const EXPORT_DICT = "ExportDict";
const IMPORT_EXCEL = "ImportExcel";
const IMPORT_EXCEL_WITH_FORMULA = "ImportExcelWithFormula";
const SINGLE_IMPORT_EXCEL = "SingleImportExcel";
const IMPORT_DATA = "ImportData";
const EXPORT_EXCEL_WITH_STAMP = "ExportExcelWithStamp";
const IMPORT_EXCEL_WITH_STAMP = "ImportExcelWithStamp";
const _DataService = class _DataService2 {
  constructor(form) {
    this.form = form;
    this.request = new Request$1(form);
  }
  getQueryItems(formKey, fieldKey, typeDefKey, paras) {
    var jsonParas = JSON.stringify(paras);
    var key = formKey + "_" + fieldKey + typeDefKey + "_getQueryItems_" + jsonParas;
    if (!_DataService2.reqMap[key]) {
      var params = {
        service: ServiceName.COMBOBOX_SERVICE,
        cmd: GET_QUERY_ITEMS,
        formKey,
        fieldKey,
        typeDefKey,
        paras: jsonParas
      };
      _DataService2.reqMap[key] = this.request.getData(params).finally(function() {
        setTimeout(function() {
          delete _DataService2.reqMap[key];
        }, 100);
      });
    }
    return _DataService2.reqMap[key];
  }
  getFilterQueryItems(formKey, fieldKey, typeDefKey, paras) {
    var jsonParas = JSON.stringify(paras);
    var key = formKey + "_" + fieldKey + typeDefKey + "_GetFilterQueryItems_" + jsonParas;
    if (!_DataService2.reqMap[key]) {
      var params = {
        service: ServiceName.COMBOBOX_SERVICE,
        cmd: GET_FILTER_QUERY_ITEMS,
        formKey,
        fieldKey,
        typeDefKey,
        paras: jsonParas
      };
      _DataService2.reqMap[key] = this.request.getData(params).finally(function() {
        setTimeout(function() {
          delete _DataService2.reqMap[key];
        }, 100);
      });
    }
    return _DataService2.reqMap[key];
  }
  async loadVariant(form, paras) {
    await form.refreshParas();
    var params = {
      service: "FormVariant",
      cmd: "LoadFormVariant",
      projectKey: form.projectKey,
      formKey: form.formKey
    };
    var parameters = form.getParas();
    if (parameters) {
      params.parameters = parameters.toJSON();
    }
    if (paras) {
      params.paras = JSON.stringify(paras);
    }
    return this.request.getData(params);
  }
  getDynamicCellKey(formKey, field, sign) {
    var params = {
      service: ServiceName.WEB_META_SERVICE,
      cmd: GET_DYNAMIC_CELL_KEY,
      formKey,
      field,
      sign
    };
    return this.request.getData(params);
  }
  invokeService(extSvrName, paras, doc) {
    var params = {
      service: ServiceName.INVOKE_SERVICE,
      extSvrName
    };
    var cmd;
    if (Utils.isArray(paras)) {
      cmd = INVOKE_EXT_SERVICE;
    } else {
      cmd = INVOKE_EXT_SERVICE2;
    }
    params.cmd = cmd;
    params.paras = JSON.stringify(paras);
    if (doc) {
      params.document = JSON.stringify(doc);
    }
    return this.request.getData(params);
  }
  invokeUnsafeService(extSvrName, paras, doc) {
    var params = {
      service: ServiceName.INVOKE_UNSAFE_SERVICE,
      extSvrName
    };
    var cmd;
    if (Utils.isArray(paras)) {
      cmd = "InvokeExtService";
    } else {
      cmd = INVOKE_EXT_SERVICE2;
    }
    params.cmd = cmd;
    params.paras = JSON.stringify(paras);
    if (doc) {
      params.document = JSON.stringify(doc);
    }
    return this.request.getData(params);
  }
  getCondSignItems(formKey, field) {
    var params = {
      service: ServiceName.WEB_META_SERVICE,
      cmd: GET_COND_SIGN_ITEMS,
      formKey,
      field
    };
    return this.request.getData(params);
  }
  getConditionItems(formKey) {
    var params = {
      service: ServiceName.WEB_META_SERVICE,
      cmd: GET_CONDITION_ITEMS,
      formKey
    };
    return this.request.getData(params);
  }
  /**
   * 
   *  @deprecated 不使用的方法
   *  
   */
  getDataObjectKey(formKey) {
    var params = {
      service: ServiceName.WEB_META_SERVICE,
      cmd: GET_DATA_OBJECT_KEY$1,
      formKey
    };
    return this.request.getData(params);
  }
  serverDate() {
    var params = {
      service: ServiceName.DATE_SERVICE,
      cmd: SERVER_DATE
    };
    return this.request.getData(params);
  }
  serverDBDate() {
    var params = {
      service: ServiceName.DATE_SERVICE,
      cmd: SERVER_DBDATE
    };
    return this.request.getData(params);
  }
  dbUpdate(SQL, values) {
    var paras = YesJSONUtil.toJSONArray(values);
    var params = {
      service: ServiceName.DBUPDATE,
      cmd: DBUPDATE,
      sql: SQL,
      paras: JSON.stringify(paras)
    };
    return this.request.getData(params);
  }
  dbNamedUpdate(form, SQLName, values) {
    var paras = YesJSONUtil.toJSONArray(values);
    var params = {
      service: ServiceName.DBUPDATE,
      cmd: DBNAMED_UPDATE,
      formKey: form.getFormKey(),
      sql: SQLName,
      paras: JSON.stringify(paras)
    };
    return this.request.getData(params);
  }
  dbQuery(SQL, values) {
    var paras = YesJSONUtil.toJSONArray(values);
    var params = {
      service: ServiceName.DBQUERY,
      cmd: DBQUERY,
      sql: SQL,
      paras: JSON.stringify(paras)
    };
    return this.request.getData(params);
  }
  dbNamedQuery(form, sqlName, values) {
    var paras = YesJSONUtil.toJSONArray(values);
    var jsonParas = JSON.stringify(paras);
    var formKey = form.getFormKey();
    var key = formKey + "_" + sqlName + "_dbNamedQuery_" + jsonParas;
    if (!_DataService2.reqMap[key]) {
      var params = {
        service: ServiceName.DBQUERY,
        cmd: DBNAMED_QUERY,
        sql: sqlName,
        formKey,
        paras: jsonParas
      };
      _DataService2.reqMap[key] = this.request.getData(params).finally(function() {
        setTimeout(function() {
          delete _DataService2.reqMap[key];
        }, 100);
      });
    }
    return _DataService2.reqMap[key];
  }
  evalMidExp(exp, doc, paras, formParas) {
    var parasJson = YesJSONUtil.toJSONArray(paras);
    var jsonDoc = DataUtil$1.toJSONDoc(doc);
    var formParaJson = formParas ? formParas.toJSON() : null;
    var paras = {
      service: ServiceName.EVAL_MID_EXP,
      cmd: EVAL_MID_EXP,
      exp,
      document: JSON.stringify(jsonDoc),
      paras: parasJson,
      parameters: formParaJson
    };
    return this.request.getData(paras);
  }
  exportExcel(form, options2) {
    var doc = DataUtil$1.toJSONDoc(form.getDocument());
    var params = {
      service: ServiceName.EXPORT_FILE,
      cmd: EXPORT_EXCEL,
      formKey: form.formKey,
      document: JSON.stringify(doc),
      parameters: form.getParas().toJSON(),
      filterMap: JSON.stringify(form.getFilterMap()),
      condition: JSON.stringify(form.getCondParas())
    };
    params = Object.assign(params, options2);
    return this.request.getData(params);
  }
  batchExportExcel(form, options2) {
    var doc = DataUtil$1.toJSONDoc(form.getDocument());
    var params = {
      service: ServiceName.EXPORT_FILE,
      cmd: BATCH_EXPORT_EXCEL,
      formKey: form.formKey,
      document: JSON.stringify(doc),
      parameters: form.getParas().toJSON(),
      filterMap: JSON.stringify(form.getFilterMap()),
      condition: JSON.stringify(form.getCondParas())
    };
    params = Object.assign(params, options2);
    return this.request.getData(params);
  }
  exportCSV(form, options2) {
    var doc = DataUtil$1.toJSONDoc(form.getDocument());
    var params = {
      service: ServiceName.EXPORT_FILE,
      cmd: EXPORT_CSV,
      formKey: form.formKey,
      document: JSON.stringify(doc),
      parameters: form.getParas().toJSON(),
      filterMap: JSON.stringify(form.getFilterMap()),
      condition: JSON.stringify(form.getCondParas())
    };
    params = Object.assign(params, options2);
    return this.request.getData(params);
  }
  exportDict(formKey, templateKey, serviceName, fileName) {
    var params = {
      service: ServiceName.EXPORT_FILE,
      cmd: EXPORT_DICT,
      exportFormKey: formKey,
      templateKey,
      postExportServiceName: serviceName,
      exportFileName: fileName
    };
    return this.request.getData(params);
  }
  importExcel(formKey, params) {
    var params = Object.assign({
      formKey,
      service: ServiceName.DTS,
      cmd: IMPORT_EXCEL
    }, params);
    return this.request.uploadFile(params);
  }
  importExcelWithFormula(formKey, params) {
    var params = Object.assign({
      formKey,
      service: ServiceName.DTS,
      cmd: IMPORT_EXCEL_WITH_FORMULA
    }, params);
    return this.request.uploadFile(params);
  }
  singleImportExcel(formKey, params) {
    var params = Object.assign({
      formKey,
      service: ServiceName.DTS,
      cmd: SINGLE_IMPORT_EXCEL
    }, params);
    return this.request.uploadFile(params);
  }
  importData(formKey, params) {
    var params = Object.assign({
      formKey,
      service: ServiceName.DTS,
      cmd: IMPORT_DATA
    }, params);
    return this.request.uploadFile(params);
  }
  exportExcelWithStamp(form, options2) {
    var doc = DataUtil$1.toJSONDoc(form.getDocument());
    var params = {
      service: ServiceName.EXPORT_FILE,
      cmd: EXPORT_EXCEL_WITH_STAMP,
      formKey: form.formKey,
      document: JSON.stringify(doc),
      parameters: form.getParas().toJSON(),
      filterMap: JSON.stringify(form.getFilterMap()),
      uiconfig: JSON.stringify(UIUtil.getComsInfo(form)),
      condition: JSON.stringify(form.getCondParas())
    };
    params = Object.assign(params, options2);
    return this.request.getData(params);
  }
  importExcelWithStamp(formKey, params) {
    var params = Object.assign({
      formKey,
      service: ServiceName.DTS,
      cmd: IMPORT_EXCEL_WITH_STAMP
    }, params);
    return this.request.uploadFile(params);
  }
};
_DataService.reqMap = {};
let DataService = _DataService;
let __PARAS = {};
class SessionParasCache {
  /**
   * 存储
   * key-value
   */
  static set(key, value) {
    __PARAS[key] = value;
  }
  /**
   * 存储 SessionParas
   * paras :object
   */
  static setParas(paras) {
    __PARAS = paras;
  }
  /**
   * 获取 SessionParas
   */
  static getParas() {
    return __PARAS;
  }
  /**
   * 获取
   * key sessionParas下的key
   * reutrn 对应的值
   */
  static get(key) {
    return __PARAS[key];
  }
  /**
   * 移除sessionParas下对应的key
   */
  static removeItem(key) {
    delete __PARAS[key];
  }
  /**
   * 清除存储对象sessionParas中所有的键
   */
  static clear() {
    __PARAS = {};
  }
}
var UserInfo = {
  userName: SessionParasCache.get("_yigo_userName"),
  userID: SessionParasCache.get("_yigo_userID"),
  clusterId: SessionParasCache.get("_yigo_clusterid"),
  loginTime: SessionParasCache.get("_yigo_login_time"),
  code: SessionParasCache.get("_yigo_code")
};
class SessionInfo {
  static getUserName() {
    return SessionParasCache.get("_yigo_userName") || UserInfo.userName;
  }
  static setUserName(userName) {
    SessionParasCache.set("_yigo_userName", userName);
  }
  static getUserID() {
    return SessionParasCache.get("_yigo_userID") || UserInfo.userID;
  }
  static setUserID(userID) {
    SessionParasCache.set("_yigo_userID", userID);
  }
  static getClusterID() {
    return SessionParasCache.get("_yigo_clusterid") || UserInfo.clusterId;
  }
  static setClusterID(clusterId) {
    SessionParasCache.set("_yigo_clusterid", clusterId);
  }
  static getLoginTime() {
    return SessionParasCache.get("_yigo_login_time") || UserInfo.loginTime;
  }
  static setLoginTime(s) {
    SessionParasCache.set("_yigo_login_time", s);
  }
  static getCode() {
    return SessionParasCache.get("_yigo_code") || UserInfo.code;
  }
  static setCode(code) {
    SessionParasCache.set("_yigo_code", code);
  }
  static getOldURL() {
    return SessionParasCache.get("_yigo_oldurl");
  }
  static setOldURL(oldURL) {
    SessionParasCache.set("_yigo_oldurl", oldURL);
  }
  static clear() {
    SessionParasCache.clear();
  }
}
if ("indexedDB" in window) {
  console.log("support indexeddb");
} else {
  console.warn("not support indexeddb");
}
const DB_NAME = "YigoCache_" + BaseURL;
const DICT_TABLE_NAME = "DictCache";
const META_TABLE_NAME = "MetaCache";
const DOC_TABLE_NAME = "DocCache";
const DATAOBJ_TABLE_NAME = "DataObjCache";
const RIGHTS_TABLE_NAME = "RightsCache";
const HISTORY_LOGIN_TABLE_NAME = "HistoryLogin";
const HISTORY_INPUT_TABLE_NAME = "HistoryInput";
const OPERATOR_PARAS_TABLE_NAME = "OperatorParas";
const MENUFAVORITES_TABLE_NAME = "MenuFavorites";
var DB_VERSION = 7;
var tables = [DICT_TABLE_NAME, META_TABLE_NAME, DOC_TABLE_NAME, DATAOBJ_TABLE_NAME, RIGHTS_TABLE_NAME];
var no_delete_tables = [HISTORY_LOGIN_TABLE_NAME, HISTORY_INPUT_TABLE_NAME, OPERATOR_PARAS_TABLE_NAME, MENUFAVORITES_TABLE_NAME];
const _get = function(db, table, key, tx) {
  return new Promise((resolve2, reject) => {
    tx = tx || db.transaction(table, "readwrite");
    var store = tx.objectStore(table);
    var request2 = store.get(key);
    request2.onsuccess = () => {
      resolve2(request2.result);
    };
    request2.onerror = (e) => {
      reject(e);
    };
  });
};
const _put = function(db, table, value, tx) {
  return new Promise((resolve2, reject) => {
    tx = tx || db.transaction(table, "readwrite");
    var store = tx.objectStore(table);
    var request2 = store.put(value);
    request2.onsuccess = () => {
      resolve2(request2.result);
    };
    request2.onerror = (e) => {
      reject(e);
    };
  });
};
const _getByIndex = function(db, table, indexName, key, tx) {
  return new Promise((resolve2, reject) => {
    tx = tx || db.transaction(table, "readwrite");
    var store = tx.objectStore(table);
    var index = store.index(indexName);
    var request2 = index.get(IDBKeyRange.only(key));
    request2.onsuccess = () => {
      resolve2(request2.result);
    };
    request2.onerror = (e) => {
      reject(e);
    };
  });
};
const _clear = function(db, table, dbName, tx) {
  return new Promise((resolve2, reject) => {
    tx = tx || db.transaction(table, "readwrite");
    if (db.objectStoreNames.contains(table)) {
      var store = tx.objectStore(table);
      var request2 = store.clear();
      request2.onsuccess = () => {
        console.log("clear ..." + dbName + " table: " + table);
        resolve2(request2.result);
      };
      request2.onerror = (e) => {
        reject(e);
      };
    }
  });
};
const _delete = function(db, table, key, tx) {
  return new Promise((resolve2, reject) => {
    tx = tx || db.transaction(table, "readwrite");
    var store = tx.objectStore(table);
    var request2 = store.delete(key);
    request2.onsuccess = function() {
      resolve2(request2.result);
    };
    request2.onerror = (e) => {
      reject(e);
    };
  });
};
const _openCursor = function(db, table, tx) {
  tx = tx || db.transaction(table);
  var store = tx.objectStore(table);
  return store.openCursor();
};
class IndexedDBProxy {
  constructor(name2) {
    this.dbName = name2;
    this.db = null;
  }
  support() {
    return "indexedDB" in window;
  }
  isOpen() {
    return this.db != null;
  }
  open(upgrade2, version) {
    let self = this;
    const dbPromise = new Promise((resolve2, reject) => {
      var request2 = indexedDB.open(self.dbName, version);
      if (upgrade2) {
        request2.onupgradeneeded = upgrade2;
      }
      request2.onsuccess = () => {
        self.db = request2.result;
        resolve2(self.db);
        console.log("indexdb open...");
      };
      request2.onerror = (event2) => {
        reject(event2);
      };
    });
    return dbPromise;
  }
  async get(table, key) {
    if (!this.isOpen()) {
      await this.open();
    }
    var self = this;
    return _get(self.db, table, key);
  }
  exists(table) {
    if (this.isOpen()) {
      return this.db.objectStoreNames.contains(table);
    }
  }
  async put(table, value) {
    if (!this.isOpen()) {
      await this.open();
    }
    var db = this.db;
    return _put(db, table, value);
  }
  async getByIndex(table, indexName, key) {
    if (!this.isOpen()) {
      await this.open();
    }
    var db = this.db;
    return _getByIndex(db, table, indexName, key);
  }
  clear(table) {
    return _clear(this.db, table, this.dbName);
  }
  async delete(table, key) {
    if (!this.isOpen()) {
      await this.open();
    }
    var db = this.db;
    return _delete(db, table, key);
  }
  async openCursor(table) {
    if (!this.isOpen()) {
      await this.open();
    }
    var db = this.db;
    return _openCursor(db, table);
  }
}
var upgrade = function(evt) {
  for (var i2 = 0, len = tables.length; i2 < len; i2++) {
    if (evt.currentTarget.result.objectStoreNames.contains(tables[i2])) {
      evt.currentTarget.result.deleteObjectStore(tables[i2]);
    }
    var store = evt.currentTarget.result.createObjectStore(
      tables[i2],
      {
        keyPath: "key"
      }
    );
    store.createIndex("index_keypath", "key", {
      unique: true
    });
  }
  const db = evt.currentTarget.result;
  const objectStoreNames = db.objectStoreNames;
  for (var i2 = 0, len = no_delete_tables.length; i2 < len; i2++) {
    var taleName = no_delete_tables[i2];
    if (!objectStoreNames.contains(taleName)) {
      var store = db.createObjectStore(taleName, { keyPath: "key" });
      store.createIndex("index_keypath", "key", { unique: true });
    }
  }
  console.debug("initDb.onupgradeneeded");
};
var clearHistory = function(def) {
  const curUserID = SessionInfo.getUserID() || "";
  const clearHistoryInput = async (userKey) => {
    const inputStore = await _indexedDB.openCursor(HISTORY_INPUT_TABLE_NAME);
    inputStore.onsuccess = function(inputEvent) {
      const inputCursor = inputEvent.target.result;
      if (inputCursor) {
        const inputKey = inputCursor.key;
        if (inputKey.startsWith(userKey)) {
          _indexedDB.delete(HISTORY_INPUT_TABLE_NAME, inputKey);
        }
        inputCursor.continue();
      }
    };
  };
  const clearHistoryUser = async () => {
    const userStore = await _indexedDB.openCursor(HISTORY_LOGIN_TABLE_NAME);
    userStore.onsuccess = function(userEvent) {
      const userCursor = userEvent.target.result;
      if (userCursor) {
        const userKey = userCursor.key;
        if (userKey !== curUserID) {
          const isExpired = (/* @__PURE__ */ new Date()).getTime() - userCursor.value > 30 * 24 * 60 * 60 * 1e3;
          if (isExpired) {
            _indexedDB.delete(HISTORY_LOGIN_TABLE_NAME, userKey);
            clearHistoryInput(userKey);
          }
        }
        userCursor.continue();
      }
    };
  };
  if (_indexedDB.exists(HISTORY_LOGIN_TABLE_NAME)) {
    _indexedDB.put(HISTORY_LOGIN_TABLE_NAME, {
      key: curUserID,
      value: (/* @__PURE__ */ new Date()).getTime()
    });
    clearHistoryUser();
  }
};
var _indexedDB = new IndexedDBProxy(DB_NAME);
_indexedDB.open(upgrade, DB_VERSION).then(function(d) {
  console.log("indexedDB open...................");
  clearHistory();
  for (var i2 = 0, len = tables.length; i2 < len; i2++) {
    if (_indexedDB.exists(tables[i2])) {
      _indexedDB.clear(tables[i2]);
    }
  }
  indexedDB.deleteDatabase("YigoDictDB");
}, function(e) {
  console.debug("open error");
  console.error(e);
  indexedDB.deleteDatabase(DB_NAME);
  _indexedDB.open(upgrade, DB_VERSION).then(function(d) {
    clearHistory();
    for (var i2 = 0, len = tables.length; i2 < len; i2++) {
      if (_indexedDB.exists(tables[i2])) {
        _indexedDB.clear(tables[i2]);
      }
    }
    indexedDB.deleteDatabase("YigoDictDB");
  }, function(e2) {
    console.debug("open error");
  });
});
class IndexedDBCache {
  constructor(tableName) {
    this.tableName = tableName;
  }
  get(key) {
    return _indexedDB.get(this.tableName, key).then(function(data2) {
      if (data2) {
        return data2.value;
      } else {
        return null;
      }
    });
  }
  put(key, value) {
    var o = {};
    o.key = key;
    o.value = value;
    _indexedDB.put(this.tableName, o);
  }
  clear() {
    return _indexedDB.clear(this.tableName);
  }
  isOpen() {
    return _indexedDB.isOpen();
  }
  support() {
    return _indexedDB.support();
  }
}
let cache$i;
let traceMap = /* @__PURE__ */ new Map();
cache$i = new IndexedDBCache(DICT_TABLE_NAME);
if (!cache$i.support()) {
  cache$i = new LRUCache(30);
}
class DictCache extends BaseCache {
  getCache() {
    return cache$i;
  }
  getDictTraceDependence(formKey) {
    return traceMap.get(formKey);
  }
  setDictTraceDependence(formKey, dependence) {
    traceMap.set(formKey, dependence);
  }
}
class BaseItem {
  constructor() {
    this.itemKey = "";
    this.oid = 0;
    this.caption = "";
    this.enable = 0;
    this.nodeType = 0;
    this.showCode = "";
  }
  toJSON() {
    var jsonObj = {
      oid: this.oid,
      itemKey: this.itemKey,
      caption: this.caption,
      nodeType: this.nodeType,
      showCode: this.showCode,
      i18nCaption: this.i18nCaption
    };
    return jsonObj;
  }
  fromJSON(jsonObj) {
    for (const key in jsonObj) {
      this[key] = jsonObj[key];
    }
    if (jsonObj.Enable) {
      this.enable = jsonObj.Enable;
    }
    if (jsonObj.NodeType) {
      this.nodeType = jsonObj.NodeType;
    }
    const i18nCaption = jsonObj.i18nCaption;
    if (i18nCaption) {
      const locale = Utils.getCookie("locale");
      if (locale) {
        const caption = i18nCaption[locale];
        caption && (this.caption = caption);
      }
    }
  }
}
let Item$1 = class Item {
  constructor() {
    this.__ignoreRights = false;
    this.itemKey = null;
    this.oid = 0;
    this.nodeType = 0;
    this.enable = 0;
    this.caption = null;
    this.mainTableKey = null;
    this.itemTables = {};
  }
  getOID() {
    return this.oid;
  }
  getItemKey() {
    return this.itemKey;
  }
  getNodeType() {
    return this.nodeType;
  }
  getEnable() {
    return this.enable;
  }
  getCaption() {
    return this.caption;
  }
  equals(o) {
    if (o == null) {
      return false;
    }
    return this.toString() == o.toString();
  }
  toString() {
    return this.itemKey + "_" + this.oid;
  }
  toItemData() {
    var o = {};
    o.oid = this.oid;
    o.itemKey = this.itemKey;
    o.caption = this.caption;
    o.UseCode = this.useCode || this.getValue("UseCode");
    o.Code = this.code || this.getValue("Code");
    o.Name = this.getValue("Name");
    let attributeType = this.attributeType;
    if (!attributeType) {
      attributeType = this.getValue("AttributeType");
    }
    o.AttributeType = attributeType;
    return new ItemData(o);
  }
  toBaseItem() {
    const table = this.itemTables[this.mainTableKey];
    const row = table.itemRows[0];
    const o = { ...row };
    o.oid = this.oid;
    o.itemKey = this.itemKey;
    o.caption = this.caption;
    o.enable = o.Enable;
    o.nodeType = o.NodeType;
    return o;
  }
  getValue(key, tableKey) {
    if (!tableKey) {
      tableKey = this.mainTableKey;
    }
    var fieldKey = key, index = key.indexOf(".");
    if (index > 0) {
      tableKey = key.substring(0, index);
      fieldKey = key.substring(index + 1);
    }
    var table = this.itemTables[tableKey];
    var value = null;
    if (table && table.itemRows.length > 0) {
      if (table.tableMode == 0) {
        value = table.itemRows[0][fieldKey];
      } else {
        var len = table.itemRows.length;
        value = new Array(len);
        for (var i2 = 0; i2 < len; i2++) {
          value.push(table.itemRows[i2][fieldKey]);
        }
      }
    }
    return value;
  }
  toJSON() {
    var jsonObj = {
      oid: this.oid,
      itemKey: this.itemKey,
      caption: this.caption,
      enable: this.enable,
      nodeType: this.nodeType,
      mainTableKey: this.mainTableKey,
      itemTables: this.itemTables
    };
    return jsonObj;
  }
  fromJSON(jsonObj) {
    if (jsonObj.AttributeType) {
      this.attributeType = jsonObj.AttributeType;
    }
    for (const key in jsonObj) {
      this[key] = jsonObj[key];
    }
    const i18nCaption = jsonObj.i18nCaption;
    if (i18nCaption) {
      const locale = Utils.getCookie("locale");
      if (locale) {
        const caption = i18nCaption[locale];
        caption && (this.caption = caption);
      }
    }
    jsonObj["OID"] && (this.oid = jsonObj["OID"]);
    jsonObj["Enable"] && (this.enable = jsonObj["Enable"]);
    jsonObj["NodeType"] && (this.nodeType = jsonObj["NodeType"]);
    jsonObj["ItemKey"] && (this.itemKey = jsonObj["ItemKey"]);
    jsonObj["Code"] && (this.code = jsonObj["Code"]);
    jsonObj["UseCode"] && (this.useCode = jsonObj["UseCode"]);
  }
};
class ItemDataUtil {
  static fromJSONItem(json) {
    if (!json)
      return null;
    const item = new Item$1();
    item.fromJSON(json);
    return item;
  }
  static fromJSONItems(jsonarr) {
    const items = [];
    if (!Array.isArray(jsonarr))
      return items;
    let item;
    jsonarr.forEach((json) => {
      item = new Item$1();
      item.fromJSON(json);
      if (item) {
        items.push(item);
      }
    });
    return items;
  }
  static fromJSONBaseItem(json) {
    if (!json)
      return null;
    const item = new BaseItem();
    item.fromJSON(json);
    return item;
  }
  static fromJSONBaseItems(jsonarr) {
    let items = [], baseItem;
    if (!Array.isArray(jsonarr))
      return items;
    for (let i2 = 0, len = jsonarr.length, json; i2 < len; i2++) {
      baseItem = new BaseItem();
      json = jsonarr[i2];
      baseItem.fromJSON(json);
      items.push(baseItem);
    }
    return items;
  }
  static fromJSONItemData(json) {
    if (!json)
      return null;
    const itemData = new ItemData(json);
    return itemData;
  }
  static fromJSONItemDatas(jsonarr) {
    const itemDatas = [];
    if (!Array.isArray(jsonarr))
      return itemDatas;
    jsonarr.forEach((json) => {
      const itemData = new ItemData(json);
      itemDatas.push(itemData);
    });
    return itemDatas;
  }
}
var cache$h = new LRUCache(100);
const GET_ALL_ITEMS = "GetAllItems";
const GET_ITEMS = "GetItems";
const GET_ITEM = "GetItem";
const GET_DICT_CHILDREN = "GetDictChildren";
const LOCATE = "Locate";
const GET_QUERY_DATA = "GetQueryData";
const GET_ITEM_DATAS = "GetItemDatas";
const GET_BROWSER_FORM_KEY = "GetBrowserFormKey";
const GET_DICT_FILTER_SQL = "GetDictFilterSql";
const GET_QUERY_FORM_KEY = "GetQueryFormKey";
const GET_QUERY_COLUMNS = "GetQueryColumns";
const GET_DISPLAY_COLUMNS = "GetDisplayColumns";
const ENABLED_DICT = "EnabledDict";
const GET_CAPTION = "getCaption";
const GET_PARENT_PATH = "GetParentPath";
const GET_ITEM_BY_OID = "GetItemByOID";
const GET_COMP_ALL_ITEMS = "GetCompAllItems";
const GET_ALL_ITEMS2 = "GetAllItems2";
const _DictService = class _DictService2 {
  constructor(form) {
    this.form = form;
    this.request = new Request$1(form);
    this.dictCacheProxy = new DictCacheProxy(form);
  }
  /**
      * 获取所有字典项
      */
  async getAllItems(itemKey, filter, stateMask = null, formKey = null, fieldKey = null) {
    var params = {};
    params.service = ServiceName.DICT_SERVICE;
    params.cmd = GET_ALL_ITEMS;
    params.itemKey = itemKey;
    if (stateMask != null) {
      params.stateMask = stateMask;
    }
    if (filter != null) {
      params.filter = JSON.stringify(filter);
    }
    params.formKey = formKey;
    params.fieldKey = fieldKey;
    const result = await this.request.getData(params);
    const items = ItemDataUtil.fromJSONItems(result);
    return items;
  }
  /**
   *批量获取字典项
   */
  async getItems(itemKey, oids, formKey = null, fieldKey = null) {
    if (oids && oids.length == 1 && this.form && StringUtil.equalsIgnoreCase(itemKey, this.form.dataObjectKey)) {
      const items = [];
      const item = await this.getOrgItem(itemKey, oids[0], null, formKey, fieldKey);
      items.push(item);
      return items;
    }
    var params = {};
    params.service = ServiceName.DICT_SERVICE;
    params.cmd = GET_ITEMS;
    params.oids = JSON.stringify(oids);
    params.itemKey = itemKey;
    params.formKey = formKey;
    params.fieldKey = fieldKey;
    const result = await this.request.getData(params);
    const list = ItemDataUtil.fromJSONItems(result);
    return list;
  }
  /**
  * 获取一个字典缓存
  */
  async getOrgItem(itemKey, oid, statMask = null, formKey = null, fieldKey = null) {
    const form = this.form;
    const doc = DataUtil$1.toJSONDoc(form.getDocument());
    const options2 = {
      itemKey,
      oid,
      statMask,
      cmd: GET_ITEM,
      service: ServiceName.ORG_DICT_SERVICE,
      document: JSON.stringify(doc),
      metaFormKey: formKey || form.getFormKey(),
      fieldKey
    };
    const data2 = await this.request.getData(options2);
    if (data2) {
      const item = ItemDataUtil.fromJSONItem(data2);
      return item;
    }
    return null;
  }
  async getOrgQueryData(itemKey, startRow, maxRows, pageIndicatorCount, fuzzyValue, stateMask, filter, root, formKey = null, fieldKey = null) {
    const doc = DataUtil$1.toJSONDoc(this.form.getDocument());
    const params = {};
    params.itemKey = itemKey;
    params.startRow = startRow;
    params.maxRows = maxRows;
    params.pageIndicatorCount = pageIndicatorCount;
    params.value = fuzzyValue;
    params.stateMask = stateMask;
    if (filter != null) {
      params.filter = JSON.stringify(filter);
    }
    if (root != null) {
      params.root = JSON.stringify(root);
    }
    params.document = JSON.stringify(doc);
    params.metaFormKey = this.form.metaForm.formKey;
    params.service = ServiceName.ORG_DICT_SERVICE;
    params.cmd = GET_QUERY_DATA;
    const result = await this.request.getData(params);
    return result;
  }
  /**
   * 根据显示值反向匹配字典项
   */
  async getData(itemKey, display, filter, root, stateMask, formKey, fieldKey) {
    var key = itemKey + "_" + display;
    if (!_DictService2.reqMap[key]) {
      var params = {
        service: ServiceName.DICT_SERVICE,
        cmd: GET_ITEM_DATAS,
        itemKey,
        display,
        stateMask,
        formKey,
        fieldKey
      };
      if (filter) {
        params.filter = JSON.stringify(filter);
      }
      if (root) {
        params.root = root;
      }
      try {
        const result = await this.request.getData(params);
        const itemDatas = ItemDataUtil.fromJSONItemDatas(result);
        _DictService2.reqMap[key] = itemDatas;
      } finally {
        setTimeout(() => {
          delete _DictService2.reqMap[key];
        }, 200);
      }
    }
    return _DictService2.reqMap[key];
  }
  /**
   * 根据父节点获取子节点
   */
  async getDictChildren(itemKey, itemData, filter, stateMask = null, formKey = null, fieldKey = null) {
    var params = {};
    params.itemKey = itemKey;
    if (this.form.document) {
      params.formState = this.form.document.form_OperationState;
    }
    params.itemData = JSON.stringify(itemData);
    if (filter != null) {
      params.filter = JSON.stringify(filter);
    }
    params.service = ServiceName.WEB_DICT_SERVICE;
    params.cmd = GET_DICT_CHILDREN;
    params.stateMask = stateMask;
    params.formKey = formKey;
    params.fieldKey = fieldKey;
    const childs = await this.request.getData(params);
    const items = ItemDataUtil.fromJSONBaseItems(childs);
    return items;
  }
  async getBrowserFormKey(itemKey) {
    const params = {};
    params.itemKey = itemKey;
    params.service = ServiceName.ORG_DICT_SERVICE;
    params.cmd = GET_BROWSER_FORM_KEY;
    const cacheKey = "BrowserFormKey_" + itemKey;
    let ret = await _DictService2.browserFormKeyCache.get(cacheKey);
    if (ret == null) {
      ret = await this.request.getData(params);
      _DictService2.browserFormKeyCache.set(cacheKey, ret);
    }
    return ret;
  }
  async getGetDictFilterSql(dictFormKey, dictFieldKey, itemKey, dictFilter, form_OperationState) {
    const params = {};
    params.dictFormKey = dictFormKey;
    params.dictFieldKey = dictFieldKey;
    params.itemKey = itemKey;
    params.dictFilter = dictFilter;
    params.form_OperationState = form_OperationState;
    params.service = ServiceName.ORG_DICT_SERVICE;
    params.cmd = GET_DICT_FILTER_SQL;
    let ret = await this.request.getData(params);
    return ret;
  }
  async getQueryFormKey(itemKey) {
    const params = {};
    params.itemKey = itemKey;
    params.service = ServiceName.ORG_DICT_SERVICE;
    params.cmd = GET_QUERY_FORM_KEY;
    const cacheKey = "QueryFormKey_" + itemKey;
    let ret = await _DictService2.queryFormKeyCache.get(cacheKey);
    if (ret == null) {
      ret = await this.request.getData(params);
      _DictService2.queryFormKeyCache.set(cacheKey, ret);
    }
    return ret;
  }
  /**
   * 精确查找 
   */
  async locate(itemKey, field, value, filter = null, root = null, statMask = null, callback = null, formKey = null, fieldKey = null) {
    var params = {};
    params.itemKey = itemKey;
    if (field != null) {
      params.field = field;
    }
    params.value = value;
    if (filter != null) {
      params.filter = JSON.stringify(filter);
    }
    if (root != null) {
      params.root = JSON.stringify(root);
    }
    params.statMask = statMask;
    params.service = ServiceName.DICT_SERVICE;
    params.cmd = LOCATE;
    if (formKey != null) {
      params.formKey = formKey;
    }
    if (fieldKey != null) {
      params.fieldKey = fieldKey;
    }
    const result = await this.request.getData(params);
    const item = ItemDataUtil.fromJSONItem(result);
    return item;
  }
  /**
   * 获取一个字典缓存,异步
   */
  async getItem(itemKey, oid, statMask = null, callback = null, formKey = null, fieldKey = null) {
    var data2 = {};
    data2.itemKey = itemKey;
    data2.oid = oid;
    data2.statMask = statMask;
    data2.cmd = GET_ITEM;
    data2.service = ServiceName.WEB_DICT_SERVICE;
    data2.formKey = formKey;
    data2.fieldKey = fieldKey;
    const result = await this.request.getData(data2);
    const item = ItemDataUtil.fromJSONItem(result);
    return item;
  }
  async getQueryData(itemKey, startRow, maxRows, pageIndicatorCount, fuzzyValue, stateMask, filter, root, queryMatchType = null, formKey = null, fieldKey = null, formState = null) {
    var params = {};
    params.itemKey = itemKey;
    params.startRow = startRow;
    if (fuzzyValue) {
      var splitLength = fuzzyValue.split(",").length;
      if (splitLength > maxRows) {
        maxRows = splitLength;
      }
    }
    params.maxRows = maxRows;
    params.pageIndicatorCount = pageIndicatorCount;
    params.value = fuzzyValue;
    params.stateMask = stateMask;
    params.queryMatchType = queryMatchType;
    if (filter != null) {
      params.filter = JSON.stringify(filter);
    }
    if (root != null) {
      params.root = JSON.stringify(root);
    }
    params.formKey = formKey;
    params.fieldKey = fieldKey;
    params.formState = formState;
    params.service = ServiceName.DICT_SERVICE;
    params.cmd = GET_QUERY_DATA;
    const result = await this.request.getData(params);
    return result;
  }
  async getQueryCols(itemKey) {
    let key = "getQueryCols_" + itemKey;
    if (!cache$h.contains(key)) {
      var params = {};
      params.itemKey = itemKey;
      params.service = ServiceName.WEB_META_SERVICE;
      params.cmd = GET_QUERY_COLUMNS;
      let obj = await this.request.getData(params);
      cache$h.put(key, obj);
    }
    return cache$h.get(key);
  }
  async getDisplayCols(itemKey) {
    let key = "getDisplayCols_" + itemKey;
    if (!cache$h.contains(key)) {
      var params = {};
      params.itemKey = itemKey;
      params.service = ServiceName.WEB_META_SERVICE;
      params.cmd = GET_DISPLAY_COLUMNS;
      let obj = await this.request.getData(params);
      cache$h.put(key, obj);
      return obj;
    }
    return cache$h.get(key);
  }
  /**
  /**
   * 修改字典使用状态
   */
  enabledDict(itemKey, oid, enable, allChildren) {
    var data2 = {};
    data2.itemKey = itemKey;
    data2.oid = oid;
    if (typeof enable == void 0 || enable == null) {
      enable = 1;
    }
    data2.enable = enable.toString();
    data2.allChildren = allChildren;
    data2.cmd = ENABLED_DICT;
    data2.service = ServiceName.DICT_SERVICE;
    return this.request.getData(data2);
  }
  /**
   * 根据字典itemKey id取caption
   */
  getCaption(itemKey, oid) {
    var params = {};
    params.itemKey = itemKey;
    if (Utils.isArray(oid)) {
      oid = JSON.stringify(oid);
    }
    params.oids = oid;
    params.cmd = GET_CAPTION;
    params.service = ServiceName.WEB_DICT_SERVICE;
    return this.request.getData(params);
  }
  /**
   *  @deprecated 不使用的方法
   *  @see DictCacheProxy
   */
  getDictValue(itemKey, oid, fieldKey) {
    return this.dictCacheProxy.getDictValue(itemKey, oid, fieldKey);
  }
  /**
   *  @deprecated 不使用的方法
   *  @see DictCacheProxy
   */
  removeCache(itemKey, oid) {
    return this.dictCacheProxy.removeCache(itemKey, oid);
  }
  /*
   *根据节点获取父节点路径
   */
  getTreePath(itemKey, child, rootOID) {
    var params = {
      service: ServiceName.DICT_SERVICE,
      cmd: GET_PARENT_PATH,
      itemKey,
      rootOID
    };
    params[Utils.isArray(child) ? "itemDatas" : "itemData"] = JSON.stringify(child);
    return this.request.getData(params);
  }
  getParentPath(itemKey, child) {
    var paras = {
      service: ServiceName.DICT_SERVICE,
      cmd: GET_PARENT_PATH,
      itemKey,
      itemData: JSON.stringify(child)
    };
    return this.request.getData(paras);
  }
  /**
  * L2R方式获取所有节点
  */
  async getAllItems2(itemKey, itemData, filter, stateMask, formKey, fieldKey) {
    var params = {};
    params.itemKey = itemKey;
    params.itemData = JSON.stringify(itemData);
    if (filter != null) {
      params.filter = JSON.stringify(filter);
    }
    params.service = ServiceName.DICT_SERVICE;
    params.cmd = GET_ALL_ITEMS2;
    params.stateMask = stateMask;
    params.formKey = formKey;
    params.fieldKey = fieldKey;
    const childs = await this.request.getData(params);
    const items = ItemDataUtil.fromJSONBaseItems(childs);
    return items;
  }
  /**
   * 依据OID获取字典缓存
   */
  async getItemByOID(itemKey, startRow, maxRows, pageIndicatorCount, fuzzyValue, stateMask, filter, root, formKey, fieldKey) {
    const params = {};
    params.itemKey = itemKey;
    params.startRow = startRow;
    params.maxRows = maxRows;
    params.pageIndicatorCount = pageIndicatorCount;
    params.value = fuzzyValue;
    params.stateMask = stateMask;
    if (filter != null) {
      params.filter = JSON.stringify(filter);
    }
    if (root != null) {
      params.root = JSON.stringify(root);
    }
    params.formKey = formKey;
    params.fieldKey = fieldKey;
    params.service = ServiceName.ORG_DICT_SERVICE;
    params.cmd = GET_ITEM_BY_OID;
    const ret = await this.request.getData(params);
    const item = ItemDataUtil.fromJSONItem(ret);
    return item;
  }
  async getCompAllItems(itemKey, itemData, filters, stateMask = null, formKey = null, fieldKey = null) {
    var params = {};
    params.itemKey = itemKey;
    params.itemData = JSON.stringify(itemData);
    if (filters != null) {
      params.filters = JSON.stringify(filters);
    }
    params.service = ServiceName.DICT_SERVICE;
    params.cmd = GET_COMP_ALL_ITEMS;
    params.stateMask = stateMask;
    params.formKey = formKey;
    params.fieldKey = fieldKey;
    const result = await this.request.getData(params);
    const items = ItemDataUtil.fromJSONBaseItems(result);
    return items;
  }
};
_DictService.browserFormKeyCache = new LRUCache(200);
_DictService.queryFormKeyCache = new LRUCache(200);
_DictService.reqMap = {};
let DictService = _DictService;
let cache$g;
cache$g = new IndexedDBCache(DATAOBJ_TABLE_NAME);
if (!cache$g.support()) {
  cache$g = new LRUCache(30);
}
class DataObjCache extends BaseCache {
  getCache() {
    return cache$g;
  }
}
let cache$f;
cache$f = new IndexedDBCache(META_TABLE_NAME);
if (!cache$f.support()) {
  cache$f = new LRUCache(30);
}
class MetaCache extends BaseCache {
  getCache() {
    return cache$f;
  }
}
class SecondaryType {
}
SecondaryType.NORMAL = 2;
SecondaryType.DICT = 3;
SecondaryType.COMPDICT = 4;
SecondaryType.CHAINDICT = 5;
SecondaryType.DATAOBJECTLIST = 8;
class DataObject {
  constructor() {
    this.key = null;
    this.caption = null;
    this.primaryType = 1;
    this.secondaryType = 2;
    this.mainTableKey = null;
    this.tables = [];
  }
  getKey() {
    return this.key;
  }
  getCaption() {
    return this.caption;
  }
  getPrimaryType() {
    return this.primaryType;
  }
  getSecondaryType() {
    return this.secondaryType;
  }
  getMainTableKey() {
    return this.mainTableKey;
  }
  getTable(key) {
    var table = null;
    for (var i2 = 0, len = this.tables.length; i2 < len; i2++) {
      table = this.tables[i2];
      if (table.key == key) {
        return table;
      }
    }
    return null;
  }
  getColumn(tableKey, colKey) {
    var table = this.getTable(colKey === void 0 ? this.mainTableKey : tableKey);
    if (table) {
      var key = colKey === void 0 ? tableKey : colKey;
      var col;
      for (var i2 = 0, len = table.columns.length; i2 < len; i2++) {
        col = table.columns[i2];
        if (col.key == key) {
          return col;
        }
      }
    }
    return null;
  }
  getDisplayColumns() {
    if (this.displayCols) {
      return this.displayCols;
    }
    return null;
  }
  getQueryColumns() {
    if (this.queryCols) {
      return this.queryCols;
    }
    return null;
  }
  fromJSON(jsonObj) {
    if (jsonObj.key) {
      this.key = jsonObj.key;
    }
    if (jsonObj.caption) {
      this.caption = jsonObj.caption;
    }
    if (jsonObj.primaryType) {
      this.primaryType = jsonObj.primaryType;
    }
    if (jsonObj.secondaryType) {
      this.secondaryType = jsonObj.secondaryType;
    }
    if (jsonObj.mainTableKey) {
      this.mainTableKey = jsonObj.mainTableKey;
    }
    if (jsonObj.tables) {
      this.tables = jsonObj.tables;
    }
    if (jsonObj.browserFormKey) {
      this.browserFormKey = jsonObj.browserFormKey;
    }
    if (jsonObj.queryFormKey) {
      this.queryFormKey = jsonObj.queryFormKey;
    }
    if (this.secondaryType == SecondaryType.COMPDICT) {
      this.relation = jsonObj.relation;
    }
    if (this.secondaryType == SecondaryType.DICT || this.secondaryType == SecondaryType.CHAINDICT) {
      var displayFields = jsonObj.displayFields || "Code;Name";
      var fields = displayFields.split(";");
      this.displayCols = [];
      var col;
      for (var i2 = 0, len = fields.length; i2 < len; i2++) {
        col = this.getColumn(this.mainTableKey, fields[i2]);
        this.displayCols.push(col);
      }
      var queryFields = jsonObj.queryFields || displayFields;
      fields = queryFields.split(";");
      this.queryCols = [];
      for (var i2 = 0, len = fields.length; i2 < len; i2++) {
        col = this.getColumn(this.mainTableKey, fields[i2]);
        this.queryCols.push(col);
      }
      const dropviewFields = jsonObj.dropviewFields || displayFields;
      const drop_fields = dropviewFields.split(";");
      this.dropCols = [];
      for (var i2 = 0, len = drop_fields.length; i2 < len; i2++) {
        col = this.getColumn(this.mainTableKey, drop_fields[i2]);
        this.dropCols.push(col);
      }
    }
  }
}
class AppEventTriggerType {
}
AppEventTriggerType.NOW = 0;
AppEventTriggerType.SHOW = 1;
class Env {
  static setEventDefCollection(eventDefCollection) {
    if (eventDefCollection.length > 0) {
      for (let i2 = 0; i2 < eventDefCollection.length; i2++) {
        let _edc = eventDefCollection[i2];
        this.eventdef[_edc["key"]] = _edc;
        this.eventdef[_edc["key"]]["manage"] = false;
        this.eventdef[_edc["key"]]["signalforms"] = [];
        this.eventdef["signalObj"] = {};
      }
    }
  }
  static getEventDefCollection() {
    return this.eventdef;
  }
  static setAliasKeyMap(aliasKeyMap) {
    this.aliasKeyMap = aliasKeyMap;
  }
  static getAliasKeyMap() {
    return this.aliasKeyMap;
  }
  static addSendSignalForm(form) {
    let ehc = form["eventHandlerCollection"];
    if (ehc && ehc.length > 0) {
      if (!this.eventdef["signalObj"][form.formKey]) {
        this.eventdef["signalObj"][form.formKey] = { manage: false };
        for (let i2 = 0; i2 < ehc.length; i2++) {
          var key = ehc[i2]["key"];
          if (!this.eventdef[key]) {
            throw new Error(key + " 的事件处理器未注册");
          } else {
            this.eventdef[key] = Object.assign(this.eventdef[key], ehc[i2]);
            this.eventdef[key]["signalforms"].push(form);
          }
        }
        this.eventdef["signalObj"][form.formKey]["list"] = [];
      }
    }
  }
  static doSendSignal(signalKey) {
    let signalEevents = this.eventdef[signalKey];
    if (signalEevents) {
      var forms = signalEevents["signalforms"];
      for (var i2 = 0; i2 < forms.length; i2++) {
        if (signalEevents["trigger"] == AppEventTriggerType.NOW) {
          forms[i2].asyncEval(signalEevents["content"]);
        } else {
          var list = this.eventdef["signalObj"][forms[i2]["formKey"]]["list"];
          if (signalEevents["mergeEvent"]) {
            var flag = true;
            for (var j = 0; j < list.length; j++) {
              if (list[j] == signalEevents["key"]) {
                flag = false;
              }
            }
            if (flag) {
              list.push(signalEevents["key"]);
              this.eventdef["signalObj"][forms[i2]["formKey"]]["manage"] = true;
            }
          } else {
            list.push(signalEevents["key"]);
            this.eventdef["signalObj"][forms[i2]["formKey"]]["manage"] = true;
          }
        }
      }
    }
    return true;
  }
  static doSendSignalForm(pform) {
    let _doSignal = this.eventdef["signalObj"] && this.eventdef["signalObj"][pform["formKey"]];
    if (_doSignal) {
      var list = _doSignal["list"], self = this;
      if (_doSignal["manage"] && list.length > 0) {
        for (var i2 = 0; i2 < list.length; i2++) {
          (function(i22) {
            pform.asyncEval(self.eventdef[list[i22]]["content"]).then(function() {
              list.pop();
            });
          })(i2);
        }
        _doSignal["manage"] = false;
      }
    }
  }
}
Env.aliasKeyMap = {};
Env.signalForms = [];
Env.eventdef = {};
class RowType {
  static parse(v) {
    if (!v) {
      return -1;
    }
    v = v.toUpperCase();
    var ret = this[v];
    return typeof ret == "undefined" ? -1 : ret;
  }
  static toString(v) {
    return v == this.FIXED && this.STR_FIXED || v == this.GROUP && this.STR_GROUP || v == this.DETAIL && this.STR_DETAIL || v == this.GROUPTAIL && this.STR_GROUPTAIL || "";
  }
}
RowType.FIXED = 0;
RowType.STR_FIXED = "Fixed";
RowType.GROUP = 1;
RowType.STR_GROUP = "Group";
RowType.DETAIL = 2;
RowType.STR_DETAIL = "Detail";
RowType.GROUPTAIL = 3;
RowType.STR_GROUPTAIL = "GroupTail";
class TableViewProcess {
  static MergeTableRow(metaForm) {
    let body = metaForm["body"];
    for (let i2 = 0; i2 < body.items.length; i2++) {
      let block = body["items"][i2];
      let root = block.root;
      this.getComp(root);
    }
  }
  static getComp(parent2) {
    const type = parent2.type;
    switch (type) {
      case ControlType.SUBDETAIL: {
        if (parent2.bindingGridKey && this.subDetailMap[parent2.bindingGridKey]) {
          parent2.bindingGridKey = this.subDetailMap[parent2.bindingGridKey];
        }
        let chirdRoot = parent2.root;
        this.getComp(chirdRoot);
        break;
      }
      case ControlType.POPVIEW: {
        let chirdRoot = parent2.root;
        this.getComp(chirdRoot);
        break;
      }
      case ControlType.TABLEVIEW: {
        this.process(parent2);
        return;
      }
    }
    let items = parent2.items;
    if (items == null)
      return;
    for (let i2 = 0; i2 < items.length; i2++) {
      let item = items[i2];
      this.getComp(item);
    }
  }
  static process(meta) {
    let metaRows = meta.items;
    meta.rows = meta.items;
    delete meta.items;
    meta["columns"] = [];
    metaRows.forEach((metaRow, index) => {
      let columns = this.doTableViewColumn(metaRow);
      switch (metaRow.rowType) {
        case RowType.FIXED:
          break;
        case RowType.GROUP:
          if (metaRows[index + 1].rowType == RowType.DETAIL) {
            if (metaRow.groupColumnKeys) {
              meta.hasGroupRow = true;
              meta.groupRow = metaRow;
              meta.groupColumnKeys = metaRow.groupColumnKeys;
              meta.indicatorKey = metaRow.indicatorKey;
              meta.onCollapse = metaRow.onCollapse;
              meta.onExpand = metaRow.onExpand;
              meta.indicator = metaRow.indicator;
              meta.hoverHead = metaRow.hoverHead;
            } else {
              throw "分组行%1$s未定义GroupColumnKeys属性";
            }
          } else {
            throw "分组头行%1$s未定义在明细行之前";
          }
          break;
        case RowType.GROUPTAIL:
          if (metaRows[index - 1].rowType = RowType.STR_DETAIL) {
            meta.hasGroupRowTail = true;
            meta.groupRowTail = metaRow;
          } else {
            throw "分组尾行%1$s未定义在明细行之后";
          }
          break;
        default:
          meta.focusRowChanged = metaRow.focusRowChanged;
          meta.tableKey = metaRow.tableKey;
          meta.pageRowCount = metaRow.pageRowCount;
          meta.pageLoadType = metaRow.pageLoadType === PageLoadType.DB ? PageLoadType.DB : PageLoadType.UI;
          meta.showTotalRowCount = metaRow.showTotalRowCount;
          meta.hasSubDetail = metaRow.hasSubDetail;
          meta.linkType = metaRow.linkType;
          meta.sourceFields = metaRow.sourceFields;
          meta.targetFields = metaRow.targetFields;
          meta.insertBtn = metaRow.insertBtn;
          meta.styleType = metaRow.style;
          meta.columnCount = metaRow.columnCount;
          meta.isSubDetail = metaRow.isSubDetail;
          meta.parentGridKey = metaRow.parentGridKey;
          meta.editColumnsOrder = metaRow.editColumnsOrder;
          meta.columns = columns;
          break;
      }
      metaRow.rowType = RowType.toString(metaRow.rowType);
    });
  }
  /*生成columns */
  static doTableViewColumn(metaRow) {
    let columns = [], root = metaRow.root;
    if (!root.tagName)
      return;
    let updateCell = function(_comp) {
      let dataBinding = _comp.dataBinding;
      if (dataBinding) {
        _comp.tableKey = dataBinding.tableKey;
        _comp.columnKey = dataBinding.columnKey;
        _comp.hasDB = dataBinding;
      }
      _comp.editOptions = _comp.properties;
      _comp.cellType = _comp.type;
      columns.push(_comp);
    };
    let deepComp = function(comp) {
      if (comp.items) {
        if (comp.items.length > 0) {
          comp.tagName && columns.push(comp);
          comp.items.forEach((item) => {
            deepComp(item);
          });
        }
      } else {
        updateCell(comp);
      }
    };
    if (root.items) {
      deepComp(root);
    } else {
      updateCell(root);
    }
    metaRow.cells = columns;
    return columns;
  }
}
TableViewProcess.subDetailMap = {};
class BaseMergeHandler {
  /**
   * 控件meta对象合并
   * @param sourceComp 源控件
   * @param comp 
   **/
  merge(sourceComp, comp) {
    return this.mergeImpl(sourceComp, comp);
  }
  /**
   * 控件meta对象合并,子类实现
   * @param sourceComp 源控件
   * @param comp 
   **/
  mergeImpl(sourceComp, comp) {
    return this.defaultMergeImpl(sourceComp, comp);
  }
  defaultMergeImpl(sourceComp, comp) {
    this.attributeLeftMerge(sourceComp, comp);
    if (sourceComp.properties && comp.properties)
      ;
    return sourceComp;
  }
  attributeLeftMerge(sourceComp, comp) {
    if (comp.caption) {
      sourceComp.caption = comp.caption;
    }
    if (comp.buddyKey) {
      sourceComp.buddyKey = comp.buddyKey;
    }
    if (comp.enable) {
      sourceComp.enable = comp.enable;
    }
    if (comp.enableDependency) {
      sourceComp.enableDependency = comp.enableDependency;
    }
    if (comp.parentGridKey) {
      sourceComp.parentGridKey = comp.parentGridKey;
    }
    if (comp.bindingCellKey) {
      sourceComp.bindingCellKey = comp.bindingCellKey;
    }
    if (comp.tip) {
      sourceComp.tip = comp.tip;
    }
    if (comp.activate) {
      sourceComp.activate = comp.activate;
    }
    if (comp.x != -1) {
      sourceComp.x = comp.x;
    }
    if (comp.y != -1) {
      sourceComp.y = comp.y;
    }
    if (comp.xSpan != 1) {
      sourceComp.xSpan = comp.xSpan;
    }
    if (comp.ySpan != 1) {
      sourceComp.ySpan = comp.ySpan;
    }
    if (comp.width) {
      sourceComp.width = comp.width;
    }
    if (comp.height) {
      sourceComp.height = comp.height;
    }
    if (comp.minHeight) {
      sourceComp.minHeight = comp.minHeight;
    }
    if (comp.hAlign != 1) {
      sourceComp.hAlign = comp.hAlign;
    }
    if (comp.vAlign != 0) {
      sourceComp.vAlign = comp.vAlign;
    }
    if (comp.area) {
      sourceComp.area = comp.area;
    }
    if (comp.position) {
      sourceComp.position = comp.position;
    }
    if (comp.top != 1) {
      sourceComp.top = comp.top;
    }
    if (comp.right != 1) {
      sourceComp.right = comp.right;
    }
    if (comp.bottom != 1) {
      sourceComp.bottom = comp.bottom;
    }
    if (comp.left != 1) {
      sourceComp.left = comp.left;
    }
    if (comp.floatType != -1) {
      sourceComp.floatType = comp.floatType;
    }
    if (comp.padding) {
      sourceComp.padding = comp.padding;
    }
    if (comp.topPadding) {
      sourceComp.topPadding = comp.topPadding;
    }
    if (comp.rightPadding) {
      sourceComp.rightPadding = comp.rightPadding;
    }
    if (comp.bottomPadding) {
      sourceComp.bottomPadding = comp.bottomPadding;
    }
    if (comp.leftPadding) {
      sourceComp.leftPadding = comp.leftPadding;
    }
    if (comp.margin) {
      sourceComp.margin = comp.margin;
    }
    if (comp.topMargin) {
      sourceComp.topMargin = comp.topMargin;
    }
    if (comp.rightMargin) {
      sourceComp.rightMargin = comp.rightMargin;
    }
    if (comp.bottomMargin) {
      sourceComp.bottomMargin = comp.bottomMargin;
    }
    if (comp.leftMargin) {
      sourceComp.leftMargin = comp.leftMargin;
    }
    if (comp.tabOrder != 1) {
      sourceComp.tabOrder = comp.tabOrder;
    }
    if (comp.clearable) {
      sourceComp.clearable = comp.clearable;
    }
    if (comp.initEnable) {
      sourceComp.initEnable = comp.initEnable;
    }
    if (comp.initVisible) {
      sourceComp.initVisible = comp.initVisible;
    }
    if (comp.copynew) {
      sourceComp.copynew = comp.copynew;
    }
    if (comp.borderColor) {
      sourceComp.borderColor = comp.borderColor;
    }
    if (comp.borderRadius) {
      sourceComp.borderRadius = comp.borderRadius;
    }
    if (comp.borderWidth) {
      sourceComp.borderWidth = comp.borderWidth;
    }
    if (comp.borderStyle) {
      sourceComp.borderStyle = comp.borderStyle;
    }
    if (comp.onlyShow) {
      sourceComp.onlyShow = comp.onlyShow;
    }
    if (comp.compStyle) {
      sourceComp.compStyle = comp.compStyle;
    }
    if (comp.cssClass) {
      sourceComp.cssClass = comp.cssClass;
    }
    if (comp.checkOnClickNode) {
      sourceComp.checkOnClickNode = comp.checkOnClickNode;
    }
  }
  attributeRightMerge(sourceComp, comp) {
    if (!comp.caption) {
      comp.caption = sourceComp.caption;
    }
    if (!comp.buddyKey) {
      comp.buddyKey = sourceComp.buddyKey;
    }
    if (!comp.enable) {
      comp.enable = sourceComp.enable;
    }
    if (!comp.enableDependency) {
      comp.enableDependency = sourceComp.enableDependency;
    }
    if (!comp.parentGridKey) {
      comp.parentGridKey = sourceComp.parentGridKey;
    }
    if (!comp.bindingCellKey) {
      comp.bindingCellKey = sourceComp.bindingCellKey;
    }
    if (!comp.tip) {
      comp.tip = sourceComp.tip;
    }
    if (!comp.activate) {
      comp.activate = sourceComp.activate;
    }
    if (comp.x == -1) {
      comp.x = sourceComp.x;
    }
    if (comp.y == -1) {
      comp.y = sourceComp.y;
    }
    if (comp.xSpan == 1) {
      comp.xSpan = sourceComp.xSpan;
    }
    if (comp.ySpan == 1) {
      comp.ySpan = sourceComp.ySpan;
    }
    if (!comp.width) {
      comp.width = sourceComp.width;
    }
    if (!comp.height) {
      comp.height = sourceComp.height;
    }
    if (!comp.minHeight) {
      comp.minHeight = sourceComp.minHeight;
    }
    if (comp.hAlign == 1) {
      comp.hAlign = sourceComp.hAlign;
    }
    if (comp.vAlign == 0) {
      comp.vAlign = sourceComp.vAlign;
    }
    if (!comp.area) {
      comp.area = sourceComp.area;
    }
    if (!comp.position) {
      comp.position = sourceComp.position;
    }
    if (comp.top == -1) {
      comp.top = sourceComp.top;
    }
    if (comp.right == -1) {
      comp.right = sourceComp.right;
    }
    if (comp.bottom == -1) {
      comp.bottom = sourceComp.bottom;
    }
    if (comp.left == -1) {
      comp.left = sourceComp.left;
    }
    if (comp.floatType == -1) {
      comp.floatType = sourceComp.floatType;
    }
    if (!comp.padding) {
      comp.padding = sourceComp.padding;
    }
    if (!comp.topPadding) {
      comp.topPadding = sourceComp.topPadding;
    }
    if (!comp.rightPadding) {
      comp.rightPadding = sourceComp.rightPadding;
    }
    if (!comp.bottomPadding) {
      comp.bottomPadding = sourceComp.bottomPadding;
    }
    if (!comp.leftPadding) {
      comp.leftPadding = sourceComp.leftPadding;
    }
    if (!comp.margin) {
      comp.margin = sourceComp.margin;
    }
    if (!comp.topMargin) {
      comp.topMargin = sourceComp.topMargin;
    }
    if (!comp.rightMargin) {
      comp.rightMargin = sourceComp.rightMargin;
    }
    if (!comp.bottomMargin) {
      comp.bottomMargin = sourceComp.bottomMargin;
    }
    if (!comp.leftMargin) {
      comp.leftMargin = sourceComp.leftMargin;
    }
    if (comp.tabOrder == 1) {
      comp.tabOrder = sourceComp.tabOrder;
    }
    if (!comp.clearable) {
      comp.clearable = sourceComp.clearable;
    }
    if (!comp.initEnable) {
      comp.initEnable = sourceComp.initEnable;
    }
    if (!comp.initVisible) {
      comp.initVisible = sourceComp.initVisible;
    }
    if (!comp.copynew) {
      comp.copynew = sourceComp.copynew;
    }
    if (!comp.borderColor) {
      comp.borderColor = sourceComp.borderColor;
    }
    if (!comp.borderRadius) {
      comp.borderRadius = sourceComp.borderRadius;
    }
    if (!comp.borderWidth) {
      comp.borderWidth = sourceComp.borderWidth;
    }
    if (!comp.borderStyle) {
      comp.borderStyle = sourceComp.borderStyle;
    }
    if (!comp.onlyShow) {
      comp.onlyShow = sourceComp.onlyShow;
    }
    if (!comp.compStyle) {
      comp.compStyle = sourceComp.compStyle;
    }
    if (!comp.checkOnClickNode) {
      comp.checkOnClickNode = sourceComp.checkOnClickNode;
    }
  }
}
const handlers = new HashMap();
class MergeHandlerMap {
  static reg(type, handler) {
    handlers.put(type, handler);
  }
  static get(type) {
    const result = handlers.get(type);
    if (!result) {
      console.log(`MergeHandler  ${type} not supported!`);
    }
    return result;
  }
  static getHandlers() {
    return handlers;
  }
}
class MergeUtil {
  static mergeForm(metaForm) {
    let delayMergeInfo = metaForm.delayMergeInfo;
    if (!delayMergeInfo) {
      return metaForm;
    }
    let tempMetaForm = delayMergeInfo.formInfo;
    if (!tempMetaForm) {
      return metaForm;
    }
    metaForm.extensionFormKey = tempMetaForm.key;
    this.mergeFormPropertis(metaForm, tempMetaForm);
    this.mergeOpt(metaForm.operationCollection, tempMetaForm.operationCollection);
    this.mergeFormComponent(metaForm, tempMetaForm);
    this.mergeMacro(metaForm, tempMetaForm.macroCollection);
    this.mergeScript(metaForm, tempMetaForm);
  }
  //合并form属性
  static mergeFormPropertis(sourceMetaForm, tempMetaForm) {
    if (tempMetaForm.caption) {
      sourceMetaForm.caption = tempMetaForm.caption;
    }
    if (tempMetaForm.authenticate != null) {
      sourceMetaForm.authenticate = tempMetaForm.authenticate;
    }
    if (tempMetaForm.formulaCaption) {
      sourceMetaForm.formulaCaption = tempMetaForm.formulaCaption;
    }
    if (tempMetaForm.abbrCaption) {
      sourceMetaForm.abbrCaption = tempMetaForm.abbrCaption;
    }
    if (tempMetaForm.formulaAbbrCaption) {
      sourceMetaForm.formulaAbbrCaption = tempMetaForm.formulaAbbrCaption;
    }
  }
  //合并操作栏属性
  static mergeOpt(sourceOpertaion, tempOpertaion) {
    if (tempOpertaion && sourceOpertaion) {
      let operations = sourceOpertaion.items;
      let showOpts = tempOpertaion.items;
      if (operations && showOpts) {
        out:
          for (let i2 = operations.length - 1; i2 >= 0; i2--) {
            let operaton = operations[i2];
            let key = operaton.key;
            for (let j = showOpts.length - 1; j >= 0; j--) {
              let showOpt = showOpts[j];
              if (showOpt.key == key) {
                continue out;
              }
            }
            operations.splice(i2, 1);
          }
      }
    }
  }
  //合并宏公式，这里仅仅是添加
  static mergeMacro(sourceMetaForm, tempMacroCollection) {
    if (!tempMacroCollection) {
      return;
    }
    let sourceMacroCollection = sourceMetaForm.macroCollection;
    if (!sourceMacroCollection) {
      sourceMacroCollection = [];
    }
    out:
      for (let i2 = 0; i2 < tempMacroCollection.length; i2++) {
        let tempMacro = tempMacroCollection[i2];
        for (let j = 0; j < sourceMacroCollection.length; j++) {
          let sourceMacro = sourceMacroCollection[j];
          if (tempMacro.key == sourceMacro.key) {
            continue out;
          }
        }
        sourceMacroCollection.push(tempMacro);
      }
    sourceMetaForm.macroCollection = sourceMacroCollection;
  }
  /**
   *
   * 控件配置对象合并
   */
  static mergeFormComponent(sourceMetaForm, tempMetaForm) {
    let sourceComMap = {};
    this.getCompList(sourceMetaForm, sourceComMap);
    let tempComMap = {};
    this.getCompList(tempMetaForm, tempComMap);
    let mergedComMap = {};
    let hiddenComArray = new Array();
    for (const key in sourceComMap) {
      let sourceCom = sourceComMap[key];
      let tempCom = tempComMap[key];
      if (tempCom) {
        let mergeCom = this.mergeComponent(sourceCom, tempCom);
        mergedComMap[mergeCom.key] = mergeCom;
      } else if (this.needReserve(sourceCom)) {
        sourceCom.ignoreDisplay = true;
        hiddenComArray.push(sourceCom);
      }
    }
    this.resetPostionComps(tempMetaForm, mergedComMap);
    var body = tempMetaForm["body"];
    var block = { "root": {} };
    let hiddenRoot = this.newEmptyLayoutPanelJson();
    hiddenComArray.forEach((element) => {
      hiddenRoot.items.push(element);
    });
    block["root"] = hiddenRoot;
    body["items"].push(block);
    sourceMetaForm["body"] = body;
  }
  static mergeComponent(sourceComp, comp) {
    var handler = this.getMergeHandler(sourceComp.type);
    this.preMerge(sourceComp, comp);
    if (handler) {
      return handler.merge(sourceComp, comp);
    }
  }
  static preMerge(sourceComp, comp) {
  }
  static mergeScript(sourceMetaForm, tempMetaForm) {
    if (tempMetaForm.onLoad != null) {
      sourceMetaForm.onLoad = tempMetaForm.onLoad;
    }
    if (tempMetaForm.postShow != null) {
      sourceMetaForm.postShow = tempMetaForm.postShow;
    }
  }
  static getMergeHandler(sourceControlType) {
    var handler = MergeHandlerMap.get(sourceControlType);
    if (!handler) {
      handler = new BaseMergeHandler();
    }
    return handler;
  }
  /**
   * metaForm 配置对象
   */
  static getCompList(metaForm, comMap) {
    let body = metaForm["body"];
    for (let i2 = 0; i2 < body.items.length; i2++) {
      let block = body["items"][i2];
      let root = block.root;
      this.getComp(root, comMap);
    }
    return comMap;
  }
  static getComp(parent2, comMap) {
    if (!parent2 || !parent2.key) {
      return;
    }
    if (this.needMerge(parent2)) {
      comMap[parent2.key] = parent2;
    }
    const type = parent2.type;
    switch (type) {
      case ControlType.SUBDETAIL:
      case ControlType.POPVIEW: {
        let chirdRoot = parent2.root;
        this.getComp(chirdRoot, comMap);
        break;
      }
      case ControlType.TABLEVIEW: {
        let rows = parent2.items;
        for (var j = 0; j < rows.length; j++) {
          var row = rows[j];
          if (row.rowType == 2) {
            comMap[row.key] = parent2;
          }
        }
        return;
      }
    }
    let items = parent2.items;
    if (items == null)
      return;
    for (let i2 = 0; i2 < items.length; i2++) {
      let item = items[i2];
      this.getComp(item, comMap);
    }
  }
  static needMerge(com) {
    switch (com.type) {
      case ControlType.TOOLBAR:
        return false;
    }
    return true;
  }
  static needReserve(com) {
    switch (com.type) {
      case ControlType.PANEL:
      case ControlType.COLUMNLAYOUTPANEL:
      case ControlType.GRIDLAYOUTPANEL:
      case ControlType.SPLITPANEL:
      case ControlType.PAGEPANEL:
      case ControlType.TABPANEL:
      case ControlType.HTMLPANEL:
      case ControlType.FLOWLAYOUTPANEL:
      case ControlType.BORDERLAYOUTPANEL:
      case ControlType.FLEXFLOWLAYOUTPANEL:
      case ControlType.TABLELAYOUTPANEL:
      case ControlType.FLUIDTABLELAYOUTPANEL:
      case ControlType.WIZARDPANEL:
      case ControlType.LINEARLAYOUTPANLE:
      case ControlType.SLIDINGLAYOUTPANEL:
      case ControlType.CUSTOMLAYOUTPANEL:
      case ControlType.FLEXBOXPANEL:
      case ControlType.COLLAPSEPANEL:
      case ControlType.FLEXGRIDLAYOUTPANEL:
        com.items = [];
        com.layout.items = [];
        return true;
      case ControlType.CONTAINER:
      case ControlType.POPVIEW:
      case ControlType.SUBDETAIL:
        return false;
    }
    return true;
  }
  /**
   * metaForm 配置对象
   */
  static resetPostionComps(metaForm, comMap) {
    let body = metaForm["body"];
    for (let i2 = 0; i2 < body.items.length; i2++) {
      let block = body["items"][i2];
      let root = block.root;
      this.resetPostionComp(root, comMap);
    }
  }
  static resetPostionComp(parent2, comMap) {
    if (!parent2 || !parent2.key) {
      return;
    }
    const type = parent2.type;
    switch (type) {
      case ControlType.SUBDETAIL:
      case ControlType.POPVIEW: {
        let chirdRoot = parent2.root;
        this.resetPostionComp(chirdRoot, comMap);
        break;
      }
    }
    let items = parent2.items;
    if (items == null)
      return;
    for (let i2 = 0; i2 < items.length; i2++) {
      let item = items[i2];
      let com = comMap[item.key];
      if (com) {
        items[i2] = com;
      }
      this.resetPostionComp(item, comMap);
    }
  }
  static defaultMerge(target, source) {
    return source;
  }
  static newEmptyLayoutPanelJson() {
    var layout = { key: "HiddenRoot" + (/* @__PURE__ */ new Date()).getTime(), type: ControlType.FLEXFLOWLAYOUTPANEL, ignoreDisplay: true, items: [], layout: { items: [] } };
    return layout;
  }
}
class MetaFormProcess {
  constructor(metaForm) {
    this.metaForm = metaForm;
  }
  process() {
    if (!this.metaForm) {
      return;
    }
    MergeUtil.mergeForm(this.metaForm);
    TableViewProcess.MergeTableRow(this.metaForm);
  }
}
class DialogType {
}
DialogType.DEFAULT = 0;
DialogType.YES_NO = 1;
DialogType.YES_NO_CANCEL = 2;
DialogType.OK_CANCEL = 3;
DialogType.CLOSE = 4;
const _FormTarget = class _FormTarget2 {
  static parse(target) {
    var type = -1;
    if (_FormTarget2.STR_SELF == target.toLowerCase()) {
      type = _FormTarget2.SELF;
    } else if (_FormTarget2.STR_NEWTAB == target.toLowerCase()) {
      type = _FormTarget2.NEWTAB;
    } else if (_FormTarget2.STR_MODAL == target.toLowerCase()) {
      type = _FormTarget2.MODAL;
    } else if (_FormTarget2.STR_STACK == target.toLowerCase()) {
      type = _FormTarget2.STACK;
    }
    return type;
  }
  static toString(type) {
    var s = null;
    switch (type) {
      case this.SELF:
        s = this.STR_SELF;
        break;
      case this.NEWTAB:
        s = this.STR_NEWTAB;
        break;
      case this.MODAL:
        s = this.STR_MODAL;
        break;
      case this.STACK:
        s = this.STR_STACK;
        break;
    }
    return s;
  }
};
_FormTarget.SELF = 0;
_FormTarget.STR_SELF = "self";
_FormTarget.NEWTAB = 1;
_FormTarget.STR_NEWTAB = "newtab";
_FormTarget.MODAL = 2;
_FormTarget.STR_MODAL = "modal";
_FormTarget.STACK = 3;
_FormTarget.STR_STACK = "stack";
let FormTarget = _FormTarget;
const _OperationState = class _OperationState2 {
  static parse(state) {
    _OperationState2.DEFAULT;
    if (state === _OperationState2.STR_New) {
      state = _OperationState2.NEW;
    } else if (state === _OperationState2.STR_Edit) {
      state = _OperationState2.EDIT;
    } else if (state === _OperationState2.STR_Delete) {
      state = _OperationState2.DELETE;
    }
    return state;
  }
};
_OperationState.DEFAULT = 0;
_OperationState.NEW = 1;
_OperationState.EDIT = 2;
_OperationState.DELETE = 3;
_OperationState.STR_Default = "Default";
_OperationState.STR_New = "New";
_OperationState.STR_Edit = "Edit";
_OperationState.STR_Delete = "Delete";
let OperationState = _OperationState;
class DocumentType {
}
DocumentType.DATAOBJECT = 1;
DocumentType.DETAIL = 2;
class TableFilterDetail {
  constructor() {
    this.tableKey = "";
    this.filter = "";
    this.startRow = 0;
    this.maxRows = 0;
    this.OID = -1;
    this.fieldValues = null;
    this.paraValues = null;
    this.SourceKey = "";
    this.indicatorCount = 1;
    this.OrderField = [];
    this.OrderFieldType = [];
  }
  setTableKey(tableKey) {
    this.tableKey = tableKey;
  }
  getTableKey() {
    return this.tableKey;
  }
  setFilter(filter) {
    this.filter = filter;
  }
  setStartRow(startRow) {
    this.startRow = startRow;
  }
  getStartRow() {
    return this.startRow;
  }
  setMaxRows(maxRows) {
    this.maxRows = maxRows;
  }
  getMaxRows() {
    return this.maxRows;
  }
  setPageIndicatorCount(count) {
    this.indicatorCount = count;
  }
  getIndicatorCount() {
    return this.indicatorCount;
  }
  setFieldValues(fieldValues) {
    this.fieldValues = fieldValues;
  }
  setParaValues(paraValues) {
    this.paraValues = paraValues;
  }
  setSourceKey(sourceKey) {
    this.SourceKey = sourceKey;
  }
  addOrderField(key, value) {
    var i2 = this.OrderField.indexOf(key);
    if (i2 > -1) {
      this.OrderField.splice(i2, 1);
      this.OrderFieldType.splice(i2, 1);
    }
    this.OrderField.push(key);
    this.OrderFieldType.push(value);
  }
  clearOrderField() {
    this.OrderField.splice(0, this.OrderField.length);
    this.OrderFieldType.splice(0, this.OrderFieldType.length);
  }
  reset() {
    this.startRow = 0;
  }
  fromJSON(obj) {
    this.tableKey = obj["tableKey"] || "";
    this.filter = obj["filter"] || "";
    this.startRow = obj["startRow"] || 0;
    this.maxRows = obj["maxRows"] || 0;
    this.OID = obj["OID"] || -1;
    this.SourceKey = obj["SourceKey"] || "";
    this.indicatorCount = obj["indicatorCount"] || 1;
    this.fieldValues = obj["fieldValues"] || null;
    this.paraValues = obj["paraValues"] || null;
    this.OrderField = obj["OrderField"] || [];
    this.OrderFieldType = obj["OrderFieldType"] || [];
  }
}
class FilterMap {
  constructor(obj = {}) {
    this.type = obj["type"] || DocumentType.DATAOBJECT, this.OID = obj["OID"] || -1, this.needDocInfo = obj["needDocInfo"] || true, this.filterMap = obj["filterMap"] || new Array();
  }
  setOID(OID) {
    this.OID = OID;
  }
  getOID() {
    return this.OID;
  }
  setType(type) {
    this.type = type;
  }
  getType() {
    return this.type;
  }
  setNeedDocInfo(needDocInfo) {
    this.needDocInfo = needDocInfo;
  }
  isNeedDocInfo() {
    return this.needDocInfo;
  }
  setFilterMap(filterMap) {
    this.filterMap = filterMap;
  }
  getFilterMap() {
    return this.filterMap;
  }
  addTblDetail(tblDetail) {
    this.filterMap.push(tblDetail);
  }
  setStartRow(tableKey, row) {
    this.getTblFilter(tableKey).startRow = row;
  }
  setMaxRows(tableKey, max) {
    this.getTblFilter(tableKey).maxRows = max;
  }
  setIndicatorCount(tableKey, count) {
    this.getTblFilter(tableKey).setPageIndicatorCount(count);
  }
  retain(tableKey) {
    let maps = this.filterMap, map2;
    for (var i2 = maps.length - 1; i2 >= 0; i2--) {
      map2 = maps[i2];
      if (map2.tableKey != tableKey) {
        maps.splice(i2, 1);
      }
    }
  }
  getTblFilter(tableKey) {
    var tbl = this.get(tableKey);
    if (tbl == null) {
      tbl = new TableFilterDetail();
      tbl.setTableKey(tableKey);
      this.addTblDetail(tbl);
    }
    return tbl;
  }
  get(tableKey) {
    var maps = this.filterMap, map2;
    for (var i2 = 0, len = maps.length; i2 < len; i2++) {
      map2 = maps[i2];
      if (map2.tableKey == tableKey) {
        return map2;
      }
    }
    return null;
  }
  getByIndex(i2) {
    return this.filterMap[i2];
  }
  size() {
    return this.filterMap.length;
  }
  reset() {
    this.filterMap.forEach(function(fd) {
      fd.reset();
    });
  }
  fromJSON(obj) {
    this.type = obj["type"] || DocumentType.DATAOBJECT, this.OID = obj["OID"] || -1, this.needDocInfo = obj["needDocInfo"] || true;
    var list = obj["filterMap"] || new Array();
    for (var i2 = 0, len = list.length; i2 < len; i2++) {
      var tblFilter = new TableFilterDetail();
      tblFilter.fromJSON(list[i2]);
      this.addTblDetail(tblFilter);
    }
  }
}
class FormParasUtil {
  static processCallParas(parent2, form) {
    if (parent2 != null) {
      var callParas = parent2.getCallParas();
      if (callParas != null) {
        var map2 = callParas.map;
        for (var key in map2) {
          if (key != "IsFormShowing") {
            form.setPara(key, map2[key]);
          }
        }
      }
    }
  }
}
class StringUtil {
  static trim(s) {
    return s.trim();
  }
  static isEmpt(s) {
    return s.length == 0;
  }
  static equalsIgnoreCase(s, str) {
    var equals2 = false;
    if (str == null) {
      equals2 = s == str;
    } else {
      str = str.toString();
      equals2 = s.toLowerCase() === str.toLowerCase();
    }
    return equals2;
  }
  static startsWith(s, prefix) {
    return s.slice(0, prefix.length) === prefix;
  }
  static endsWith(s, suffix) {
    return s.indexOf(suffix, s.length - suffix.length) !== -1;
  }
  static insert(s, idx, str) {
    if (!str)
      return s.valueOf();
    if (idx == 0)
      return str + s.valueOf();
    if (idx == s.length - 1)
      return s.valueOf() + str;
    return s.substring(0, idx) + str + s.substring(idx);
  }
  static deleteCharAt(s, idx) {
    if (idx < 0 || idx >= s.length) {
      return s.valueOf();
    } else if (idx == 0) {
      return s.substring(1);
    } else if (idx == s.length - 1) {
      return s.substring(0, s.length - 1);
    } else {
      return s.substring(0, idx) + s.substring(idx + 1);
    }
  }
}
class ErrorDialogProvider {
  static create(option) {
    if (ErrorDialogProvider.instance) {
      return ErrorDialogProvider.instance.create(option);
    } else {
      return null;
    }
  }
  static setInstance(i2) {
    ErrorDialogProvider.instance = i2;
  }
}
class CommonDialog {
  constructor(options2) {
    this.options = options2 || {};
  }
  // createHtml() {
  //     this.dialog.createHtml()
  // }
  /**
   * 这几个方法是在模态弹出之前
   */
  setTitle(title) {
    this.dialog.setTitle(title);
  }
  setContent(content) {
    this.dialog.setContent(content);
  }
  addClassName(key, name2) {
    this.dialog.addClassName(key, name2);
  }
  setZiBase(ziBase) {
    this.dialog.setZiBase(ziBase);
  }
  async doOnClick(key) {
    return this.dialog.doOnClick(key);
  }
  closeBtnClick() {
  }
  show() {
    return this.dialog.show();
  }
  close() {
    this.dialog.close();
  }
  hide() {
    this.dialog.hide();
  }
  maskRemove() {
    this.dialog.maskRemove();
  }
  showModal() {
    this.dialog.showModal();
  }
  __setAttribute(key, value) {
    this.dialog.__setAttribute(key, value);
  }
  getDialogEl() {
    return this.dialog.dialog;
  }
  addClassNameMask(className) {
    this.dialog.addClassNameMask(className);
  }
  __setContent(content) {
    this.dialog.__setContent(content);
  }
  __setHeaderTitle(title) {
    this.dialog.__setHeaderTitle(title);
  }
}
class Errordialog extends CommonDialog {
  constructor(options2) {
    var _a;
    super(options2);
    options2.resizeit = {
      resize: Errordialog.resize
    };
    const msgObj = Errordialog.parseErrorMessge(options2.msg);
    if (msgObj) {
      options2.msg = msgObj.message;
      options2.detail = msgObj.errorDetail;
    }
    const messageInfo = (_a = options2.detail) == null ? void 0 : _a.messageInfo;
    if (messageInfo) {
      options2.msg = messageInfo.content;
      options2.longtext = messageInfo == null ? void 0 : messageInfo.longtext;
      options2.messageInfo = messageInfo;
    }
    this.dialog = ErrorDialogProvider.create(options2);
  }
  show() {
    this.dialog.show();
  }
  click(key) {
    this.dialog.click(key);
  }
  static parseErrorMessge(message) {
    let msg = message;
    let errorDetail;
    if (YesJSONUtil.isJsonObject(msg)) {
      errorDetail = JSON.parse(msg);
      if (errorDetail.message) {
        msg = errorDetail.message;
      }
    }
    return { message: msg, errorDetail };
  }
}
class WarnDialogProvider {
  static create(option) {
    if (WarnDialogProvider.instance) {
      return WarnDialogProvider.instance.create(option);
    } else {
      return null;
    }
  }
  static setInstance(i2) {
    WarnDialogProvider.instance = i2;
  }
}
class WarnDialog extends CommonDialog {
  constructor(options2) {
    super(options2);
    options2.type = "warn";
    options2.headerTitle = "警告";
    options2.resizeit = {
      resize: Errordialog.resize
    };
    const msgObj = Errordialog.parseErrorMessge(options2.msg);
    options2.detail = msgObj.errorDetail;
    const messageInfo = msgObj.errorDetail.messageInfo;
    options2.msg = messageInfo.content;
    options2.longtext = messageInfo.longtext;
    options2.messageInfo = messageInfo;
    this.dialog = WarnDialogProvider.create(options2);
  }
  show() {
    this.dialog.show();
  }
  click(key) {
    this.dialog.click(key);
  }
}
class DialogProvider {
  static create(option) {
    if (DialogProvider.instance) {
      return DialogProvider.instance.create(option);
    } else {
      return null;
    }
  }
  static setInstance(i2) {
    DialogProvider.instance = i2;
  }
}
class Dialog extends CommonDialog {
  constructor(options2) {
    super(options2);
    this.dialog = DialogProvider.create(options2);
  }
  init() {
    this.dialog.init();
  }
  closeBtnClick() {
    return this.dialog.closeBtnClick();
  }
  click(key) {
    return this.dialog.click(key);
  }
}
class DialogFactory {
  static create(options2) {
    var dialog;
    switch (options2.type) {
      case "error":
        let msg = options2.msg;
        if (YesJSONUtil.isJsonObject(msg)) {
          let errorDetail = JSON.parse(msg);
          if (errorDetail.messageInfo) {
            let msgType = errorDetail.messageInfo.type;
            if (msgType === "ERROR") {
              return new Errordialog(options2);
            } else if (msgType === "WARN") {
              return new WarnDialog(options2);
            }
          }
        }
        dialog = new Errordialog(options2);
        break;
      case "warn":
        dialog = new WarnDialog(options2);
        break;
      default:
        dialog = new Dialog(options2);
        break;
    }
    return dialog;
  }
}
class LocationInfo {
  constructor(key, row, column = -1) {
    this.rowArea = -1;
    this.colArea = -1;
    this.crossValue = null;
    this.key = key;
    this.row = row;
    this.column = column;
  }
  setKey(key) {
    this.key = key;
  }
  getKey() {
    return this.key;
  }
  setRow(row) {
    this.row = row;
  }
  getRow() {
    return this.row;
  }
  setColumn(column) {
    this.column = column;
  }
  getColumn() {
    return this.column;
  }
  setCrossValue(crossValue) {
    this.crossValue = crossValue;
  }
  getCrossValue() {
    return this.crossValue;
  }
  setColArea(area) {
    this.colArea = area;
  }
  getColArea() {
    return this.colArea;
  }
  setRowArea(area) {
    this.rowArea = area;
  }
  getRowArea() {
    return this.rowArea;
  }
}
class ViewContext {
  constructor(form) {
    this.parent = null;
    this.locationMap = {};
    this.paras = {};
    this.rowIndex = -1;
    this.tag = null;
    this.excpAction = null;
    this.container = null;
    this._grids = [];
    this.grid = null;
    this.compData = /* @__PURE__ */ new Map();
    this.form = form;
    if (form) {
      var grids = form.getGridArray(), grid;
      for (var i2 = 0; grid = grids[i2]; i2++) {
        this.locationMap[grid.key] = new LocationInfo(grid.key, grid.getFocusRowIndex(), -1);
      }
      var lvs = form.getListArray(), lv;
      for (var i2 = 0; lv = lvs[i2]; i2++) {
        this.locationMap[lv.key] = new LocationInfo(lv.key, lv.getFocusRowIndex(), -1);
      }
      var gts = form.getGanttArray(), gt;
      for (var i2 = 0; gt = gts[i2]; i2++) {
        this.locationMap[gt.key] = new LocationInfo(gt.key, -1, -1);
      }
    }
  }
  getForm() {
    return this.form;
  }
  setParent(parent2) {
    this.parent = parent2;
  }
  getParent() {
    return this.parent;
  }
  setContainer(container) {
    this.container = container;
  }
  getContainer() {
    return this.container;
  }
  getLoc(key) {
    return this.locationMap[key];
  }
  setTag(tag) {
    this.tag = tag;
  }
  getTag() {
    return this.tag;
  }
  setExpAction(action) {
    this.excpAction = action;
  }
  getExpAction() {
    return this.excpAction;
  }
  getRowIndex() {
    return this.rowIndex;
  }
  setRowIndex(rowIndex) {
    this.rowIndex = rowIndex;
  }
  getClickButtonKey() {
    return this.clickButtonKey;
  }
  setClickButtonKey(clickButtonKey) {
    this.clickButtonKey = clickButtonKey;
  }
  updateLocation(key, row, column) {
    var loc = this.locationMap[key];
    if (!loc)
      return;
    loc.setRow(row);
    loc.setColumn(column);
  }
  setPara(key, value) {
    this.paras[key] = value;
  }
  getPara(key) {
    return this.paras[key];
  }
  setGrid(grid) {
    this.grid = grid;
  }
  getGrid() {
    return this.grid;
  }
  setCrossValue(key, crossValue) {
    var loc = this.locationMap[key];
    loc.setCrossValue(crossValue);
  }
  getCrossValue(key) {
    var loc = this.locationMap[key];
    return loc.getCrossValue();
  }
  setColArea(key, area) {
    var loc = this.locationMap[key];
    loc.setColArea(area);
  }
  setRowArea(key, area) {
    var loc = this.locationMap[key];
    loc.setRowArea(area);
  }
  getColArea(key) {
    var loc = this.locationMap[key];
    return loc.getColArea();
  }
  getRowArea(key) {
    var loc = this.locationMap[key];
    return loc.getRowArea();
  }
  setBatchDelete(batchDelete) {
    this.batchDelete = batchDelete;
  }
  isBatchDelete() {
    return this.batchDelete;
  }
  getGrids() {
    return this._grids;
  }
  addGrid(grid) {
    if (!this._grids.includes(grid)) {
      this._grids.push(grid);
    }
  }
  hasChangeData() {
    return this.changeData && this.changeData.length > 0;
  }
  addChangeData(key) {
    this.changeData = this.changeData || [];
    if (this.changeData.indexOf(key) == -1) {
      this.changeData.push(key);
    }
  }
  getChangeData() {
    return this.changeData;
  }
  hasChangeKey(key) {
    return this.changeData && this.changeData.indexOf(key) >= 0;
  }
  getLocationMap() {
    return this.locationMap;
  }
  setTarget(target) {
    this.eventTarget = target;
  }
  getTarget() {
    return this.eventTarget;
  }
  setCompData(compData) {
    if (compData) {
      var newKeys = compData.keys();
      for (var key of newKeys) {
        this.compData.set(key, compData.get(key));
      }
    }
  }
  getCompData(name2) {
    return this.compData.get(name2);
  }
}
class ViewObjectContext {
  constructor(obj) {
    this.obj = obj;
  }
  setObject(obj) {
    this.obj = obj;
  }
  getObject() {
    return this.obj;
  }
}
class PageLoadType {
}
PageLoadType.NONE = 0;
PageLoadType.STR_NONE = "NONE";
PageLoadType.UI = 1;
PageLoadType.STR_UI = "UI";
PageLoadType.DB = 2;
PageLoadType.STR_DB = "DB";
class GridCellExpand {
  constructor(form, grid) {
    this.form = form;
    this.grid = grid;
    this.groups = [];
  }
  async expand() {
    var self = this, metaGrid = self.grid.getOrgMetaObj(), targetMetaGrid = Utils.deepClone(metaGrid);
    self.initGroup(targetMetaGrid);
    await self.expandGroup();
    self.mergeGroupTitle();
    self.replaceGroup(targetMetaGrid);
    self.refreshColumnCaption(targetMetaGrid);
    self.grid.setMetaObj(targetMetaGrid);
  }
  initGroup(metaGrid) {
    var rows = metaGrid.rows, columns = metaGrid.columns, rowCount = rows.length, colCount = columns.length;
    var metaCell, columnExpand, tempGroups = [], group, area = 0, expandModel = this.grid.dataModel.expandModel, i2, k, info;
    for (i2 = 0; i2 < colCount; i2++) {
      info = null;
      for (k = 0; k < rowCount; k++) {
        metaCell = rows[k].cells[i2];
        columnExpand = metaCell.columnExpand;
        if (columnExpand) {
          group = new CellExpandCellGroup();
          group.metaCell = metaCell;
          group.rowIndex = k;
          group.left = i2;
          group.right = i2;
          tempGroups.push(group);
          if (columnExpand.expandType == ColumnExpandType.DATA) {
            info = info || [];
            info.push(columnExpand.columnKey);
          }
        }
      }
      if (tempGroups.length > 0) {
        var group = this.fillCellGroups(tempGroups, metaGrid, area++);
        group.calcCount();
        this.groups.push(group);
        tempGroups.length = 0;
        expandModel.push(info);
      }
    }
  }
  fillCellGroups(groups, metaGrid, area) {
    var rows = metaGrid.rows, columns = metaGrid.columns, group, child, metaCell;
    for (var i2 = groups.length - 1; group = groups[i2]; --i2) {
      if (i2 == groups.length - 1) {
        group.leaf = true;
      } else {
        group.leaf = false;
      }
      group.area = area;
      metaCell = group.metaCell;
      if (metaCell.isMerged && metaCell.isMergedHead) {
        var colspan = metaCell.colspan;
        if (colspan > 1) {
          group.right = group.left + colspan - 1;
        }
      }
      var left = group.left, right = group.right, size2 = rows.length;
      for (var k = left; k <= right; k++) {
        if (group.leaf) {
          var cells = new CellExpandCellList();
          cells.column = columns[k];
          for (var m = 0; m < size2; m++) {
            cells.add(rows[m].cells[k]);
          }
          group.add(cells);
        } else {
          if (k != child.left) {
            var cells = new CellExpandCellList();
            for (var m = 0; m < size2; m++) {
              cells.add(rows[m].cells[k]);
            }
            group.add(cells);
          } else {
            group.add(child);
          }
        }
      }
      child = group;
    }
    return groups[0];
  }
  expandGroup() {
    var self = this;
    return self.groups.reduce(async (prev, group) => {
      await prev;
      return self.expandOneGroup(group);
    }, true);
  }
  async expandOneGroup(group) {
    var self = this, metaCell = group.metaCell;
    if (metaCell.columnExpand.expandType == ColumnExpandType.DATA) {
      await self.doExpandGroup(metaCell, group);
    }
    return group.objectArray.reduce(async (prev, obj) => {
      await prev;
      if (obj.getObjectType() == CellExpandObjectType.Group) {
        self.form.setPara("PEV", obj.expValue);
        return self.expandOneGroup(obj);
      }
    }, true);
  }
  async doExpandGroup(metaCell, group) {
    var columnExpand = metaCell.columnExpand, columnKey = columnExpand.columnKey, cellKey = metaCell.key;
    var items = await this.extractExpandSources(metaCell);
    if (!items || items.length == 0) {
      return;
    }
    var item, obj, newObj, tempList = [];
    for (var i2 = 0; item = items[i2]; i2++) {
      for (var k = 0, length2 = group.size(); k < length2; k++) {
        obj = group.get(k);
        newObj = obj.clone();
        newObj.expValue = item.value;
        newObj.traversal(item, function(item2, cell) {
          var key = cell.key;
          if (key && key == cellKey) {
            cell.caption = item2.caption;
          }
          cell.columnArea = group.area;
          cell.isColExpand = true;
          var crossValue = cell.crossValue, crossValueMap = cell.crossValueMap;
          if (!crossValue) {
            crossValue = new MultiKey();
            cell.crossValue = crossValue;
          }
          if (!crossValueMap) {
            crossValueMap = {};
            cell.crossValueMap = crossValueMap;
          }
          var value = item2.value, javaType = UIUtil.dataType2JavaDataType(item2.dataType);
          var node = new MultiKeyNode(javaType, value);
          crossValue.addValue(node);
          crossValueMap[columnKey] = node;
        });
        tempList.push(newObj);
      }
    }
    group.clear();
    group.addAll(tempList);
  }
  refreshColumnCaption(metaGrid) {
    var columns = metaGrid.columns, caption;
    for (var i2 = 0, size2 = columns.length; i2 < size2; i2++) {
      caption = ColumnIDUtil.toColumnID(i2);
      columns[i2].caption = caption;
    }
  }
  mergeGroupTitle() {
    for (var i2 = 0, group; group = this.groups[i2]; i2++) {
      this.impl_mergeGroupTitle(group);
    }
  }
  impl_mergeGroupTitle(group) {
    if (group.leaf) {
      return;
    }
    var curValue, arr, arrs = [];
    for (var i2 = 0, size2 = group.size(); i2 < size2; i2++) {
      var obj = group.get(i2);
      if (curValue == null || obj.expValue == curValue) {
        if (arr == null) {
          arr = [];
          arrs.push(arr);
        }
      } else {
        arr = [];
        arrs.push(arr);
      }
      arr.push(obj);
      curValue = obj.expValue;
    }
    for (var i2 = 0, size1 = arrs.length; i2 < size1; i2++) {
      var arr = arrs[i2], cells = [];
      for (let k = 0, length2 = arr.length; k < length2; k++) {
        arr[k].getLeafCells(cells, group.rowIndex);
      }
      for (let k = 0, length2 = cells.length; k < length2; k++) {
        var metaCell = cells[k];
        if (k == 0) {
          metaCell.isMerged = true;
          metaCell.isMergedHead = true;
          metaCell.colspan = length2;
        } else {
          metaCell.isMerged = true;
          metaCell.isMergedHead = false;
        }
      }
    }
    for (var m = 0, count = group.size(); m < count; m++) {
      obj = group.get(m);
      if (obj.objectType == CellExpandObjectType.Group) {
        this.impl_mergeGroupTitle(obj);
      }
    }
  }
  replaceGroup(metaGrid) {
    var rows = metaGrid.rows, columns = metaGrid.columns, group, left, count, metaRow, size2 = this.groups.length;
    for (var i2 = 0; i2 < size2; i2++) {
      group = this.groups[i2];
      left = group.left;
      count = group.count;
      var leafColumns = [];
      group.getLeafColumns(leafColumns);
      columns.splice(left, count);
      for (var k = 0; k < leafColumns.length; k++) {
        columns.splice(left + k, 0, leafColumns[k]);
      }
      var cells = [];
      for (var j = 0, len = rows.length; j < len; j++) {
        group.getLeafCells(cells, j);
        metaRow = rows[j];
        metaRow.cells.splice(left, count);
        for (var m = 0, mLen = cells.length; m < mLen; m++) {
          metaRow.cells.splice(left + m, 0, cells[m]);
        }
        cells.length = 0;
      }
    }
  }
  async extractExpandSources(metaCell) {
    var columnExpand = metaCell.columnExpand;
    var tableKey = this.grid.tableKey;
    if (!tableKey) {
      tableKey = columnExpand.tableKey;
    }
    var dataTable = this.form.getDocument().getByKey(tableKey), columnKey = columnExpand.columnKey;
    var column = dataTable.getColByKey(columnKey), dataType = column.type, items = [], value, caption;
    var cxt = new ViewContext(this.form);
    if (columnExpand.expandSourceType == ExpandSourceType.DATA) {
      var set2 = [];
      dataTable.beforeFirst();
      while (dataTable.next()) {
        value = dataTable.getByKey(columnKey);
        if (set2.indexOf(value) == -1) {
          set2.push(value);
        }
      }
      var itemKey = columnExpand.itemKey, service2;
      for (var i2 = 0; value = set2[i2]; i2++) {
        if (value == null || dataType == DataType.INT && TypeConvertor.toInt(value) == 0) {
          continue;
        }
        caption = value.toString();
        if (itemKey) {
          service2 = service2 || new DictService(this.form);
          caption = await service2.getCaption(itemKey, TypeConvertor.toLong(value));
        }
        items.push(new ExpandItem(value, caption, dataType));
      }
      return items;
    } else {
      var source = columnExpand.content;
      if (!source) {
        throw new Error("expand content undefind");
      }
      var result = await this.form.__eval(source, cxt);
      if (result instanceof DataTable) {
        result.beforeFirst();
        while (result.next()) {
          value = TypeConvertor.toDataType(dataType, result.get(0));
          caption = TypeConvertor.toString(result.get(1));
          items.push(new ExpandItem(value, caption, dataType));
        }
      } else if (typeof result == "string") {
        var ret = TypeConvertor.toString(result);
        if (ret.length > 0) {
          var v = ret.split(";"), item, idx, value, caption;
          for (var j = 0; item = v[j]; j++) {
            idx = item.indexOf(",");
            value = item.substring(0, idx);
            caption = item.substring(idx + 1);
            items.push(new ExpandItem(TypeConvertor.toDataType(dataType, value), caption, dataType));
          }
        }
      }
      return items;
    }
  }
}
class CellExpandCellList {
  constructor() {
    this.cellArray = [];
    this.objectType = CellExpandObjectType.Cells;
  }
  add(cell) {
    this.cellArray.push(cell);
  }
  getObjectType() {
    return this.objectType;
  }
  size() {
    return this.cellArray.length;
  }
  clone() {
    var newObj = new CellExpandCellList(), cell, clone;
    for (var i2 = 0, len = this.cellArray.length; i2 < len; i2++) {
      cell = this.cellArray[i2];
      clone = Utils.deepClone(cell);
      if (cell.crossValue != null) {
        clone.crossValue = cell.crossValue.clone();
      }
      newObj.add(clone);
    }
    newObj.column = Utils.deepClone(this.column);
    return newObj;
  }
  traversal(context, process) {
    for (var i2 = 0, obj; obj = this.cellArray[i2]; i2++) {
      process.call(this, context, obj);
    }
  }
  getLeafColumns(columns) {
    columns.push(this.column);
  }
  getLeafCells(cells, rowIndex) {
    cells.push(this.cellArray[rowIndex]);
  }
}
class CellExpandCellGroup {
  constructor() {
    this.metaCell = null;
    this.rowIndex = -1;
    this.leaf = false;
    this.count = 0;
    this.area = -1;
    this.objectArray = [];
    this.objectType = CellExpandObjectType.Group;
  }
  add(obj) {
    this.objectArray.push(obj);
  }
  getObjectType() {
    return this.objectType;
  }
  get(i2) {
    return this.objectArray[i2];
  }
  size() {
    return this.objectArray.length;
  }
  clear() {
    this.objectArray = [];
  }
  addAll(list) {
    for (var i2 = 0, len = list.length; i2 < len; i2++) {
      this.objectArray.push(list[i2]);
    }
  }
  clone() {
    var newObj = new CellExpandCellGroup();
    newObj.metaCell = this.metaCell;
    newObj.rowIndex = this.rowIndex;
    newObj.leaf = this.leaf;
    newObj.area = this.area;
    for (var i2 = 0, len = this.objectArray.length; i2 < len; i2++) {
      newObj.add(this.objectArray[i2].clone());
    }
    return newObj;
  }
  calcCount() {
    this.count = 0;
    for (var i2 = 0, obj; obj = this.objectArray[i2]; i2++) {
      obj = this.objectArray[i2];
      if (obj.objectType == CellExpandObjectType.Group) {
        obj.calcCount();
        this.count += obj.count;
      } else {
        this.count += 1;
      }
    }
  }
  traversal(context, process) {
    for (var i2 = 0, obj; obj = this.objectArray[i2]; i2++) {
      obj.traversal(context, process);
    }
  }
  getLeafColumns(columns) {
    for (var i2 = 0, obj; obj = this.objectArray[i2]; i2++) {
      obj.getLeafColumns(columns);
    }
  }
  getLeafCells(cells, rowIndex) {
    for (var i2 = 0, obj; obj = this.objectArray[i2]; i2++) {
      obj.getLeafCells(cells, rowIndex);
    }
  }
}
class GridCellMerger {
  constructor(grid) {
    this.grid = grid;
  }
  merge() {
    this.mergeCell(this.grid.mergeCellKeys, this.grid.mergeGroupKeys);
  }
  mergeCell(cellKeys, groupKeys) {
    this.mergeFixCell();
    this.mergeDetailCell(cellKeys, groupKeys);
  }
  // 合并固定行和单元格拓展(也是固定行拓展)
  mergeFixCell() {
    var grid = this.grid;
    if (grid.hasFixCellMerge || grid.hasCellExpand) {
      var rowCount = grid.getRowCount();
      var fillFixMergeInfo = function(grid2, ri, ci, rowspan, colspan) {
        var curType;
        for (let i2 = 0; i2 < rowspan; i2++) {
          let rowType = grid2.getRowDataAt(ri + i2).rowType;
          if (i2 > 0 && rowType !== curType) {
            throw new Error("合并单元格配置错误");
          }
          for (let j = 0; j < colspan; j++) {
            let cellData = grid2.getCellDataAt(ri + i2, ci + j);
            if (i2 == 0 && j == 0) {
              cellData.isMerged = true;
              cellData.isMergedHead = true;
              cellData.rowspan = rowspan;
              cellData.colspan = colspan;
            } else {
              cellData.isMerged = true;
              cellData.isMergedHead = false;
              cellData.rowspan = i2;
              cellData.colspan = j;
            }
          }
          curType = rowType;
        }
      };
      if (grid.topFixRowCount > 0) {
        for (let i2 = 0; i2 < rowCount; i2++) {
          let rowData = grid.getRowDataAt(i2);
          if (rowData.rowType == "Detail")
            break;
          for (let k = 0, length2 = rowData.data.length; k < length2; k++) {
            let metaCell = rowData.data[k].meta;
            if (metaCell.isMerged && metaCell.isMergedHead) {
              fillFixMergeInfo(grid, i2, k, metaCell.rowspan, metaCell.colspan);
            }
          }
        }
      }
      if (grid.bottomFixRowCount > 0) {
        for (let i2 = rowCount - 1; i2 >= 0; i2--) {
          let rowData = grid.getRowDataAt(i2);
          if (rowData.rowType == "Detail")
            break;
          for (let k = 0, length2 = rowData.data.length; k < length2; k++) {
            let metaCell = rowData.data[k].meta;
            if (metaCell.isMerged && metaCell.isMergedHead) {
              fillFixMergeInfo(grid, i2, k, metaCell.rowspan, metaCell.colspan);
            }
          }
        }
      }
    }
  }
  // 根据分组字段和单元格标识做合并
  mergeDetailCell(cellKeys, groupKeys) {
    var grid = this.grid, form = grid.getForm();
    if (grid.hasDetailCellMerge) {
      this.resetDetailMergeInfo(form, cellKeys);
    }
    if (cellKeys.length == 0) {
      grid.hasDetailCellMerge = false;
      return;
    }
    var loc, metaCell, rowCount = grid.getRowCount(), metaRow = grid.getDetailMetaRow();
    var multiKeyFn;
    if (groupKeys && groupKeys.length > 0) {
      var table = form.getDocument().getByKey(grid.tableKey);
      var indexes = [], types = [], columnKeys = [];
      groupKeys.forEach(function(key) {
        loc = form.getCellLocation(key);
        metaCell = metaRow.cells[loc.column];
        metaCell.columnKey && columnKeys.push(metaCell.columnKey);
      });
      DataUtil$1.getIndexesAndTypes(table, columnKeys, indexes, types);
      multiKeyFn = function(row) {
        if (!row.bkmkRow)
          return null;
        table.setByBkmk(row.bkmkRow.getBookmark());
        return DataUtil$1.makeMultiKey(table, indexes, types);
      };
    }
    for (var i2 = 0, size2 = cellKeys.length; i2 < size2; i2++) {
      loc = form.getCellLocation(cellKeys[i2]);
      metaCell = metaRow.cells[loc.column];
      this.fillDetailMergeInfo(loc.column, metaCell.key, rowCount, metaCell.mergeGroup, multiKeyFn);
    }
    grid.hasDetailCellMerge = true;
  }
  resetDetailMergeInfo(form, cellKeys) {
    let loc, cellData, rowCount = this.grid.getRowCount();
    for (let i2 = 0, size2 = cellKeys.length; i2 < size2; i2++) {
      loc = form.getCellLocation(cellKeys[i2]);
      for (let k = 0; k < rowCount; k++) {
        cellData = this.grid.getCellDataAt(k, loc.getColumn());
        delete cellData.isMerged;
        delete cellData.isMergedHead;
        delete cellData.rowspan;
        delete cellData.colspan;
      }
    }
  }
  fillDetailMergeInfo(colIndex, cellKey, rowCount, mergeGroup, fn) {
    var grid = this.grid, headRow, currRow, mergeInfo;
    var fillMergeInfo = () => {
      var headCell = headRow.data[colIndex];
      var currCell = currRow.data[colIndex];
      if (++mergeInfo.rowspan == 2) {
        headCell.isMerged = true;
        headCell.isMergedHead = true;
      }
      headCell.rowspan = mergeInfo.rowspan;
      headCell.colspan = mergeInfo.colspan;
      currCell.isMerged = true;
      currCell.isMergedHead = false;
    };
    for (var i2 = 0; i2 < rowCount; i2++) {
      currRow = grid.getRowDataAt(i2);
      if (currRow.rowType == "Group") {
        if (mergeGroup) {
          if (!mergeInfo) {
            headRow = currRow;
            mergeInfo = { row: i2, col: cellKey, rowspan: 1, colspan: 1 };
          } else {
            fillMergeInfo();
          }
        } else {
          headRow = null;
          mergeInfo = null;
        }
      } else if (currRow.rowType == "Detail") {
        if (mergeInfo) {
          if (headRow.rowType == "Detail") {
            var headVal = headRow.data[colIndex].value;
            var currVal = currRow.data[colIndex].value;
            var curKey = fn ? fn(currRow) : null;
            var orgKey = fn ? fn(headRow) : null;
            if (headVal != null && grid.checkEquals(headVal, currVal) && (!orgKey || orgKey.equals(curKey))) {
              fillMergeInfo();
            } else {
              headRow = currRow;
              mergeInfo = { row: i2, col: cellKey, rowspan: 1, colspan: 1 };
            }
          } else {
            var preRow = grid.getRowDataAt(i2 - 1);
            if (preRow.rowType == "Detail") {
              var preVal = preRow.data[colIndex].value;
              var currVal = currRow.data[colIndex].value;
              var curKey = fn ? fn(currRow) : null;
              var orgKey = fn ? fn(preRow) : null;
              if (preVal != null && grid.checkEquals(preVal, currVal) && (!orgKey || orgKey.equals(curKey))) {
                fillMergeInfo();
              } else {
                headRow = currRow;
                mergeInfo = { row: i2, col: cellKey, rowspan: 1, colspan: 1 };
              }
            } else {
              fillMergeInfo();
            }
          }
        } else {
          headRow = currRow;
          mergeInfo = { row: i2, col: cellKey, rowspan: 1, colspan: 1 };
        }
      }
    }
  }
}
class GridColumnExpand {
  constructor(form, grid) {
    this.groups = [];
    this.map = {};
    this.form = form;
    this.grid = grid;
    this.groups = [];
    this.map = {};
  }
  async expand() {
    var metaGrid = this.grid.getOrgMetaObj(), targetMeta = Utils.deepClone(metaGrid);
    this.initGroups(targetMeta);
    var self = this;
    await self.expandColumns(targetMeta.columns);
    await self.expandGroups();
    self.replaceCells(targetMeta);
    self.grid.setMetaObj(targetMeta);
  }
  async extractExpandSources(metaColumn) {
    var _a;
    const form = this.form;
    const grid = this.grid;
    const columnExpand = metaColumn.columnExpand;
    let tableKey = grid.tableKey;
    if (!tableKey) {
      tableKey = columnExpand.tableKey;
    }
    const formKey = form.formKey;
    const dataTable = (_a = form.getDocument()) == null ? void 0 : _a.getByKey(tableKey), columnKey = columnExpand.columnKey;
    const column = dataTable.getColByKey(columnKey), dataType = column.type, items = [];
    const cxt = new ViewContext(form);
    if (columnExpand.expandSourceType == ExpandSourceType.DATA) {
      const set2 = [];
      dataTable.beforeFirst();
      while (dataTable.next()) {
        const value2 = dataTable.getByKey(columnKey);
        if (set2.indexOf(value2) == -1) {
          set2.push(value2);
        }
      }
      const itemKey = columnExpand.itemKey;
      const service2 = new DictService(form);
      let value;
      for (let i2 = 0; value = set2[i2]; i2++) {
        if (value == null || dataType == DataType.INT && TypeConvertor.toInt(value) == 0) {
          continue;
        }
        let caption = value.toString();
        if (itemKey) {
          caption = await service2.getCaption(itemKey, TypeConvertor.toLong(value), true);
        }
        items.push(new ExpandItem(value, caption, dataType));
      }
    } else {
      const source = columnExpand.content;
      if (!source) {
        throw new Error("expand content undefind");
      }
      const metaKey = metaColumn.orginalKey || metaColumn.metaKey;
      let result = await new RichDocService(form).richDocumentColumnExpand(formKey, metaKey, columnKey, cxt.getLocationMap());
      if (result == false) {
        result = await form.asyncEval(source, cxt);
      }
      if (result instanceof DataTable) {
        result.beforeFirst();
        while (result.next()) {
          const value = TypeConvertor.toDataType(dataType, result.get(0));
          const caption = TypeConvertor.toString(result.get(1));
          items.push(new ExpandItem(value, caption, dataType));
        }
      } else if (typeof result == "string") {
        const ret = TypeConvertor.toString(result);
        if (ret.length > 0) {
          const v = ret.split(";");
          let item;
          for (let j = 0; item = v[j]; j++) {
            const idx = item.indexOf(",");
            const value = item.substring(0, idx);
            const caption = item.substring(idx + 1);
            items.push(new ExpandItem(TypeConvertor.toDataType(dataType, value), caption, dataType));
          }
        }
      }
    }
    return items;
  }
  initGroups(metaGrid) {
    var columns = metaGrid.columns, orgMeta = this.grid.getOrgMetaObj(), expandModel = this.grid.dataModel.expandModel, metaColumn, area = 0, info;
    for (var i2 = 0; metaColumn = columns[i2]; i2++) {
      info = [];
      var columnExpand = metaColumn.columnExpand;
      if (columnExpand) {
        var root = new ColumnExpandGroup();
        root.setColumn(metaColumn);
        root.setArea(area);
        if (columnExpand.expandType == ColumnExpandType.DATA) {
          info.push(columnExpand.columnKey);
        }
        this.fillColumnGroups(root, info, metaColumn, area++);
        root.calcCount();
        root.left = orgMeta.leafIndexMap[root.getFirst().key];
        root.right = root.left + root.count;
        this.groups.push(root);
        expandModel.push(info);
      }
    }
  }
  fillColumnGroups(parent2, info, column, area) {
    var columns = column.columns, metaGrid = this.grid.getOrgMetaObj(), rows = metaGrid.rows;
    var child, metaRow, columnExpand;
    if (columns) {
      for (var i2 = 0, len = columns.length; i2 < len; i2++) {
        child = columns[i2], columnExpand = child.columnExpand;
        if (columnExpand) {
          var group = new ColumnExpandGroup();
          group.setColumn(child);
          group.area = area;
          parent2.add(group);
          if (columnExpand.expandType == ColumnExpandType.DATA) {
            info.push(columnExpand.columnKey);
          }
          this.fillColumnGroups(group, info, child, area);
        } else {
          var cells = new ColumnExpandCells();
          cells.setColumn(child);
          var idx = metaGrid.leafIndexMap[child.key];
          for (var j = 0, count = rows.length; j < count; j++) {
            metaRow = rows[j];
            cells.addCell(metaRow.cells[idx]);
          }
          parent2.add(cells);
        }
      }
    } else {
      var cells = new ColumnExpandCells();
      cells.setColumn(column);
      var idx = metaGrid.leafIndexMap[column.key];
      for (var j = 0, count = rows.length; j < count; j++) {
        metaRow = rows[j];
        cells.addCell(metaRow.cells[idx]);
      }
      parent2.add(cells);
    }
  }
  expandGroups() {
    var self = this;
    return self.groups.reduce(async (prev, group) => {
      await prev;
      return self.expandOneGroup(group);
    }, true);
  }
  async expandOneGroup(group) {
    var self = this, column = group.getColumn();
    if (column.columnExpand.expandType == ColumnExpandType.DATA) {
      await this.doExpandGroup(column, group);
    }
    return group.columnArray.reduce(async (prev, obj) => {
      await prev;
      if (obj.getObjectType() == ColumnExpandObjectType.Group) {
        self.form.setPara("PEV", obj.expValue);
        return self.expandOneGroup(obj);
      }
    }, true);
  }
  async expandColumns(collection) {
    var self = this, columns = [], invalid = false;
    if (!collection) {
      return;
    }
    await collection.reduce(async (prev, column) => {
      var _a;
      await prev;
      if (column.columnExpand && column.columnExpand.expandType == ColumnExpandType.DATA) {
        var items = await self.extractExpandSources(column);
        if (items == null || items.length == 0) {
          column.invalidExpand = true;
          return invalid = true;
        }
        column.invalidExpand = false;
        for (var j = 0, item; item = items[j]; j++) {
          var cloneColumn = Utils.deepClone(column);
          var secondKey = TypeConvertor.toString(item.value);
          cloneColumn.key = cloneColumn.key + "_" + secondKey;
          cloneColumn.caption = item.caption;
          cloneColumn.expValue = item.value;
          (_a = cloneColumn.columns) == null ? void 0 : _a.forEach((column2) => {
            column2.key = column2.key + "_" + secondKey;
          });
          columns.push(cloneColumn);
        }
      } else {
        columns.push(column);
      }
    }, true);
    if (invalid) {
      return;
    }
    collection.length = 0;
    Array.prototype.push.apply(collection, columns);
    return collection.reduce(async (prev, column) => {
      await prev;
      self.form.setPara("PEV", column.expValue);
      return self.expandColumns(column.columns);
    }, true);
  }
  async doExpandGroup(column, group) {
    var items = await this.extractExpandSources(column);
    if (!items || items.length == 0) {
      return;
    }
    var item, obj, newObj, tempList = [];
    for (var i2 = 0; item = items[i2]; i2++) {
      for (var k = 0, length2 = group.size(); k < length2; k++) {
        obj = group.get(k);
        newObj = obj.clone();
        newObj.expValue = item.value;
        newObj.traversal(item, function(item2, cell) {
          cell.columnArea = group.area;
          cell.isColExpand = true;
          var crossValue = cell.crossValue, crossValueMap = cell.crossValueMap;
          if (!crossValue) {
            crossValue = new MultiKey();
            cell.crossValue = crossValue;
          }
          if (!crossValueMap) {
            crossValueMap = {};
            cell.crossValueMap = crossValueMap;
          }
          var value = item2.value, javaType = UIUtil.dataType2JavaDataType(item2.dataType);
          var node = new MultiKeyNode(javaType, value);
          crossValue.addValue(node);
          crossValueMap[column.columnExpand.columnKey] = node;
        });
        tempList.push(newObj);
      }
    }
    group.clear();
    group.addAll(tempList);
  }
  replaceCells(targetMeta) {
    for (var i2 = this.groups.length - 1; i2 >= 0; i2--) {
      var group = this.groups[i2];
      var left = group.left, count = group.count;
      for (var j = 0, len = targetMeta.rows.length; j < len; j++) {
        var metaRow = targetMeta.rows[j];
        metaRow.cells.splice(left, count);
        var leafCells = group.getLeafCells(j);
        for (var m = 0, mLen = leafCells.length; m < mLen; m++) {
          metaRow.cells.splice(left + m, 0, leafCells[m]);
        }
      }
    }
  }
}
class ColumnExpandCells {
  constructor() {
    this.cellArray = [];
  }
  addCell(cellOpt) {
    this.cellArray.push(cellOpt);
  }
  setColumn(column) {
    this.column = column;
  }
  getColumn() {
    return this.column;
  }
  getObjectType() {
    return ColumnExpandObjectType.Column;
  }
  clone() {
    var newObj = new ColumnExpandCells();
    newObj.setColumn(this.column);
    for (var i2 = 0, len = this.cellArray.length; i2 < len; i2++) {
      var cell = this.cellArray[i2];
      var cloneCell = Object.assign({ extendInfo: {} }, cell);
      if (cell.crossValue != null) {
        cloneCell.crossValue = cell.crossValue.clone();
      }
      newObj.addCell(cloneCell);
    }
    return newObj;
  }
  getCell(index) {
    return this.cellArray[index];
  }
  traversal(context, process) {
    for (var i2 = 0, obj; obj = this.cellArray[i2]; i2++) {
      process.call(this, context, obj);
    }
  }
  getColumnCount() {
    return 1;
  }
}
class ColumnExpandGroup {
  constructor() {
    this.column = null;
    this.columnArray = [];
    this.count = 0;
    this.left = -1;
    this.area = -1;
  }
  setColumn(column) {
    this.column = column;
  }
  getColumn() {
    return this.column;
  }
  setArea(area) {
    this.area = area;
  }
  getLeafColumnList(list) {
    for (var i2 = 0, len = this.columnArray.length; i2 < len; i2++) {
      var obj = this.columnArray[i2];
      if (obj.getObjectType() == ColumnExpandObjectType.Column) {
        list.push(obj);
      } else {
        obj.getLeafColumnList(list);
      }
    }
  }
  getLeafCells(rowIndex) {
    var list = [], leafColumnList = [], column;
    this.getLeafColumnList(leafColumnList);
    for (var i2 = 0, len = leafColumnList.length; i2 < len; i2++) {
      column = leafColumnList[i2];
      list.push(column.getCell(rowIndex));
    }
    return list;
  }
  calcCount() {
    this.count = 0;
    var obj;
    for (var i2 = 0, len = this.columnArray.length; i2 < len; i2++) {
      obj = this.columnArray[i2];
      if (obj.getObjectType() == ColumnExpandObjectType.Group) {
        obj.calcCount();
        this.count += obj.count;
      } else {
        this.count += 1;
      }
    }
  }
  getFirst() {
    var obj = this.columnArray[0];
    if (obj.getObjectType() == ColumnExpandObjectType.Group) {
      return obj.getFirst();
    } else {
      return obj.getColumn();
    }
  }
  add(obj) {
    this.columnArray.push(obj);
  }
  size() {
    return this.columnArray.length;
  }
  clear() {
    this.columnArray = [];
  }
  addAll(list) {
    for (var i2 = 0, len = list.length; i2 < len; i2++) {
      this.columnArray.push(list[i2]);
    }
  }
  replace(index, list) {
    this.columnArray.splice(index, 1);
    for (var i2 = 0, len = list.length; i2 < len; i2++) {
      this.columnArray.splice(index + i2, 0, list[i2]);
    }
  }
  get(index) {
    return this.columnArray[index];
  }
  getObjectType() {
    return ColumnExpandObjectType.Group;
  }
  clone() {
    var newObj = new ColumnExpandGroup();
    newObj.setColumn(this.column);
    for (var i2 = 0, len = this.columnArray.length; i2 < len; i2++) {
      newObj.add(this.columnArray[i2].clone());
    }
    newObj.area = this.area;
    return newObj;
  }
  traversal(context, process) {
    for (var i2 = 0, obj; obj = this.columnArray[i2]; i2++) {
      obj.traversal(context, process);
    }
  }
}
class FilterValueType {
}
FilterValueType.FIELD = 0;
FilterValueType.FORMULA = 1;
FilterValueType.CONST = 2;
class CondSign {
}
CondSign.EQ = 0;
CondSign.S_EQ = "=";
CondSign.GT = 1;
CondSign.S_GT = ">";
CondSign.GT_EQ = 2;
CondSign.S_GT_EQ = ">=";
CondSign.LT = 3;
CondSign.S_LT = "<";
CondSign.LT_EQ = 4;
CondSign.S_LT_EQ = "<=";
CondSign.NEQ = 5;
CondSign.S_NEQ = "<>";
CondSign.BET = 6;
CondSign.S_BET = "between";
CondSign.LIKE = 7;
CondSign.S_LIKE = "like";
CondSign.CUSTOM = 8;
CondSign.S_CUSTOM = "custom";
CondSign.IN = 9;
CondSign.S_IN = "IN";
class OptSign {
}
OptSign.AND = 0;
OptSign.OR = 1;
let MainContainer = {
  set: function(mainContainer) {
    for (var k in mainContainer) {
      MainContainer[k] = mainContainer[k];
    }
  }
};
let TabMainContainer = {
  set: function(tabContainer) {
    for (var k in tabContainer) {
      TabMainContainer[k] = tabContainer[k];
    }
  }
};
let MainFrameInterface = {
  MainFrame: {}
};
let LLMChatInterface = {
  LLMChat: {},
  LLMChatTrigger: {}
};
class TimerTaskManager {
  constructor(form) {
    this.needRun = false;
    this.tasks = {};
    this.tabForm = form;
    this.needRun = false;
    this.tasks = {};
  }
  addTasks(timerTaskCollection) {
    for (var key in timerTaskCollection) {
      var info = timerTaskCollection[key];
      var task = new TimeTask(this.tabForm, info);
      this.tasks[task.key] = task;
    }
  }
  runTasks() {
    for (var key in this.tasks) {
      var task = this.tasks[key];
      task.run();
    }
  }
  startTasks(runImmediately) {
    if (!this.tabForm)
      return;
    for (var key in this.tasks) {
      var task = this.tasks[key];
      if (!runImmediately) {
        if (!task.startOnload)
          continue;
      }
      this.startTask(key);
    }
  }
  startTask(key) {
    if (!this.tasks)
      return;
    if (!this.tasks[key])
      return;
    var task = this.tasks[key];
    if (task.timerOutId)
      return;
    task.timerOutId = setTimeout(function() {
      try {
        task.start();
      } catch (e) {
        console.log(e.name + ":" + e.message);
        delete this.tasks[task.key];
      }
    }, task.delay);
  }
  closeAllTasks() {
    for (var key in this.tasks) {
      var task = this.tasks[key];
      try {
        task.close();
      } finally {
        delete this.tasks[key];
      }
    }
  }
  isValid(key) {
    if (!this.tasks)
      return;
    if (!this.tasks[key])
      return;
    var task = this.tasks[key];
    if (task.taskId != null) {
      return true;
    }
    return false;
  }
  stopTask(key) {
    if (!this.tasks)
      return;
    if (!this.tasks[key])
      return;
    var task = this.tasks[key];
    task.close();
  }
}
class TimeTask {
  constructor(form, info) {
    this.needRun = true;
    this.repeat = info.repeat;
    this.delay = info.delay;
    this.needRun = true;
    this.key = info.key;
    this.content = info.content;
    this.period = info.period || 6e4;
    this.tabForm = form;
    this.taskId = null;
    this.startOnload = info.startOnload;
  }
  start() {
    var _this = this;
    if (this.repeat) {
      this.taskId = setInterval(function() {
        let activeFormID = MainContainer.getActiveFormID();
        if (!activeFormID) {
          _this.close();
          return;
        }
        _this.needRun = true;
        if (activeFormID == _this.tabForm.formID || _this.tabForm.getTarget()) {
          _this.run();
        }
      }, _this.period);
    } else {
      let activeFormID = MainContainer.getActiveFormID();
      if (!activeFormID)
        return;
      _this.needRun = true;
      if (activeFormID == _this.tabForm.formID || _this.tabForm.getTarget()) {
        _this.run();
      }
    }
  }
  run() {
    if (this.needRun) {
      var cxt = new ViewContext(this.tabForm);
      this.tabForm.__eval(this.content, cxt, null);
      this.needRun = false;
    }
  }
  needClear() {
    if (this.repeat) {
      return false;
    } else if (this.needRun) {
      return false;
    }
    return true;
  }
  close() {
    if (this.timerOutId) {
      clearTimeout(this.timerOutId);
      this.timerOutId = null;
    }
    if (this.taskId) {
      clearInterval(this.taskId);
      this.taskId = null;
    }
  }
}
let timerList = {};
class TimerTaskManagerFactory {
  static createManager(form) {
    var manager = null;
    var timerTaskCollection = form.timerTaskCollection;
    if (timerTaskCollection) {
      manager = new TimerTaskManager(form);
      manager.addTasks(timerTaskCollection);
      timerList[form.formID] = manager;
    }
    return manager;
  }
  static getManager(formID2) {
    return timerList[formID2];
  }
  static removeManager(formID2) {
    delete timerList[formID2];
  }
}
const builders = new HashMap();
class CompBuilder {
  static reg(type, builder) {
    builders.put(type, builder);
  }
  static get(type) {
    const result = builders.get(type);
    if (!result) {
      console.log(`control ${type} not supported!`);
    }
    return result;
  }
  static getBuilders() {
    return builders;
  }
}
class CalcItemType {
}
CalcItemType.HEAD = 0;
CalcItemType.LIST = 1;
class CheckItemType {
}
CheckItemType.HEAD = 0;
CheckItemType.LIST = 1;
CheckItemType.GLOBAL = 2;
class EnableItemType {
}
EnableItemType.HEAD = 0;
EnableItemType.LIST = 1;
EnableItemType.OPERATION = 2;
EnableItemType.GRIDOPERATION = 3;
class VisibleItemType {
}
VisibleItemType.HEAD = 0;
VisibleItemType.COLUMN = 1;
VisibleItemType.OPERATION = 2;
VisibleItemType.FIXROW = 3;
VisibleItemType.TOTALROW = 4;
VisibleItemType.GROUPROW = 5;
VisibleItemType.GRIDOPERATION = 6;
class ExprItemType {
}
ExprItemType.Item = 0;
ExprItemType.Set = 1;
class CalcItem {
  constructor(target, source, type) {
    this.formulaValue = "";
    this.defaultValue = "";
    this.order = -1;
    this.depends = [];
    this.pos = null;
    this.syntaxTree = null;
    this.treeSum = false;
    this.treeInit = false;
    this.objectType = ExprItemType.Item;
    this.target = target;
    this.source = source;
    this.type = type;
  }
  setType(type) {
    this.type = type;
  }
  getType() {
    return this.type;
  }
  setTree(tree) {
    this.syntaxTree = tree;
  }
  getTree() {
    return this.syntaxTree;
  }
  setSource(source) {
    this.source = source;
  }
  getSource() {
    return this.source;
  }
  setTarget(target) {
    this.target = target;
  }
  getTarget() {
    return this.target;
  }
  setFormulaValue(formulaValue) {
    this.formulaValue = formulaValue;
  }
  getFormulaValue() {
    return this.formulaValue;
  }
  setDefaultValue(defaultValue) {
    this.defaultValue = defaultValue;
  }
  getDefaultValue() {
    return this.defaultValue;
  }
  isTreeSum() {
    return this.treeSum;
  }
  setTreeSum(treeSum) {
    this.treeSum = treeSum;
  }
  setOrder(order) {
    this.order = order;
  }
  getOrder() {
    return this.order;
  }
  isEmpty() {
    return !this.defaultValue && !this.formulaValue;
  }
  setPos(pos) {
    this.pos = pos;
  }
  getPos() {
    return this.pos;
  }
  getObjectType() {
    return this.objectType;
  }
  addDepends(depends) {
    var self = this;
    depends.forEach(function(depend) {
      self.addDepend(depend);
    });
  }
  addDepend(depend) {
    this.depends.indexOf(depend) == -1 && this.depends.push(depend);
  }
  getDepends() {
    return this.depends;
  }
}
class CheckItem {
  constructor(target, source, type) {
    this.required = false;
    this.errorMsg = "";
    this.items = [];
    this.depends = [];
    this.pos = null;
    this.treeInit = false;
    this.objectType = ExprItemType.Item;
    this.type = type;
    this.source = source;
    this.target = target;
  }
  setType(type) {
    this.type = type;
  }
  getType() {
    return this.type;
  }
  getPos() {
    return this.pos;
  }
  setPos(pos) {
    this.pos = pos;
  }
  setSource(source) {
    this.source = source;
  }
  getSource() {
    return this.source;
  }
  setTarget(target) {
    this.target = target;
  }
  getTarget() {
    return this.target;
  }
  setErrorMsg(msg) {
    this.errorMsg = msg;
  }
  getErrorMsg() {
    return this.errorMsg;
  }
  isRequired() {
    return this.required;
  }
  setRequired(required) {
    return this.required = required;
  }
  isEmpty() {
    return this.items.length = 0;
  }
  getObjectType() {
    return this.objectType;
  }
  addItem(item) {
    this.items.push(item);
  }
  getItem(index) {
    return this.items[index];
  }
  getItems() {
    return this.items;
  }
  addDepends(depends) {
    var self = this;
    depends.forEach(function(depend) {
      self.addDepend(depend);
    });
  }
  addDepend(depend) {
    this.depends.indexOf(depend) == -1 && this.depends.push(depend);
  }
  getDepends() {
    return this.depends;
  }
}
class EnableItem {
  constructor(target, source, type) {
    this.items = [];
    this.depends = [];
    this.treeInit = false;
    this.pos = null;
    this.objectType = ExprItemType.Item;
    this.target = target;
    this.source = source;
    this.type = type;
  }
  setType(type) {
    this.type = type;
  }
  getType() {
    return this.type;
  }
  getPos() {
    return this.pos;
  }
  setPos(pos) {
    this.pos = pos;
  }
  setSource(source) {
    this.source = source;
  }
  getSource() {
    return this.source;
  }
  setTarget(target) {
    this.target = target;
  }
  getTarget() {
    return this.target;
  }
  addItem(item) {
    this.items.push(item);
  }
  getItem(index) {
    return this.items[index];
  }
  size() {
    return this.items.length;
  }
  getItems() {
    return this.items;
  }
  addDepends(depends) {
    var self = this;
    depends.forEach((depend) => {
      self.addDepend(depend);
    });
  }
  addDepend(depend) {
    this.depends.indexOf(depend) == -1 && this.depends.push(depend);
  }
  getDepends() {
    return this.depends;
  }
  getObjectType() {
    return this.objectType;
  }
}
const __defaultValue = "DefaultValue";
const __defaultFormula = "DefaultFormulaValue";
const __formulaDep = "ValueDependency";
const __enable = "Enable";
const __enableDepend = "EnableDependency";
const __visible = "Visible";
const __visibleDepend = "VisibleDependency";
const __checkRule = "CheckRule";
const __checkRuleDep = "CheckDependency";
const __errorInfo = "ErrorInfo";
const __required = "Required";
const __valueChanged = "ValueChanged";
class Variant {
  constructor(data2) {
    this.data = data2;
  }
  getDefaultValue(key, defaultValue) {
    return this.getImpl(__defaultValue, key, defaultValue);
  }
  getFormulaValue(key, defaultValue) {
    return this.getImpl(__defaultFormula, key, defaultValue);
  }
  getFormulaDep(key, defaultValue) {
    return this.getImpl(__formulaDep, key, defaultValue);
  }
  getRequired(key, defaultValue) {
    return this.getImpl(__required, key, defaultValue).toString() == "true" ? true : false;
  }
  getErrorInfo(key, defaultValue) {
    return this.getImpl(__errorInfo, key, defaultValue);
  }
  getEnable(key) {
    return this._getImpl(__enable, key);
  }
  getEnableDep(key) {
    return this._getImpl(__enableDepend, key);
  }
  getVisible(key) {
    return this._getImpl(__visible, key);
  }
  getVisibleDep(key) {
    return this._getImpl(__visibleDepend, key);
  }
  getCheckRule(key) {
    return this._getImpl(__checkRule, key);
  }
  getCheckRuleDep(key) {
    return this._getImpl(__checkRuleDep, key);
  }
  getValueChanged(key) {
    return this._getImpl(__valueChanged, key);
  }
  getImpl(field, key, defaultValue) {
    var o = this.data[field];
    if (!o)
      return defaultValue;
    var item = o[key];
    if (!item)
      return defaultValue;
    return item.values.length > 0 ? item.values[0] : defaultValue;
  }
  _getImpl(field, key) {
    var o = this.data[field];
    if (o && o[key]) {
      return new VariantItem(o[key]);
    }
    return null;
  }
}
Variant.override = 1;
Variant.addition = 2;
class VariantItem {
  constructor(o) {
    this.option = o.option;
    this.values = o.values;
  }
  size() {
    return this.values.length;
  }
  getValue(index) {
    return this.values[index];
  }
  getValues() {
    return this.values;
  }
  getOption() {
    return this.option;
  }
}
class VisibleItem {
  constructor(target, source, type) {
    this.items = [];
    this.depends = [];
    this.pos = null;
    this.treeInit = false;
    this.objectType = ExprItemType.Item;
    this.target = target;
    this.source = source;
    this.type = type;
  }
  setPos(pos) {
    this.pos = pos;
  }
  getPos() {
    return this.pos;
  }
  getObjectType() {
    return this.objectType;
  }
  setType(type) {
    this.type = type;
  }
  getType() {
    return this.type;
  }
  setSource(source) {
    this.source = source;
  }
  getSource() {
    return this.source;
  }
  setTarget(target) {
    this.target = target;
  }
  getTarget() {
    return this.target;
  }
  addItem(item) {
    this.items.push(item);
  }
  getItem(index) {
    return this.items[index];
  }
  size() {
    return this.items.length;
  }
  getItems() {
    return this.items;
  }
  addDepends(depends) {
    var self = this;
    depends.forEach(function(depend) {
      self.addDepend(depend);
    });
  }
  addDepend(depend) {
    this.depends.indexOf(depend) == -1 && this.depends.push(depend);
  }
  getDepends() {
    return this.depends;
  }
}
class Item2 {
  constructor(content) {
    this.content = content;
    this.syntaxTree = null;
  }
  setContent(content) {
    this.content = content;
  }
  getContent() {
    return this.content;
  }
  setTree(tree) {
    this.syntaxTree = tree;
  }
  getTree() {
    return this.syntaxTree;
  }
}
class BaseExprHandler {
  createCalcItem(target, source, type, defaultV, formulaV, depend, variant) {
    var item = new CalcItem(target, source, type);
    var defaultValue = variant == null ? defaultV : variant.getDefaultValue(target, defaultV);
    var formulaValue = variant == null ? formulaV : variant.getFormulaValue(target, formulaV);
    var depend = variant == null ? depend : variant.getFormulaDep(target, depend);
    item.setDefaultValue(defaultValue);
    item.setFormulaValue(formulaValue);
    if (depend) {
      item.addDepends(depend.split(","));
    }
    return item;
  }
  createEnableItem(target, source, type, enable, depend, variant) {
    var item = new EnableItem(target, source, type);
    var vItem = variant == null ? null : variant.getEnable(target);
    if (vItem) {
      if (vItem.getOption() == Variant.addition) {
        if (enable) {
          item.addItem(new Item2(enable));
        }
      }
      vItem.getValues().forEach((value) => {
        if (value)
          item.addItem(new Item2(value));
      });
    } else {
      if (enable) {
        item.addItem(new Item2(enable));
      }
    }
    vItem = variant == null ? null : variant.getEnableDep(target);
    if (vItem) {
      if (vItem.getOption() == Variant.addition) {
        if (depend) {
          item.addDepends(depend.split(","));
        }
      }
      item.addDepends(vItem.getValues());
    } else {
      if (depend) {
        item.addDepends(depend.split(","));
      }
    }
    return item;
  }
  createVisibleItem(target, source, type, visible, depend, variant) {
    var item = new VisibleItem(target, source, type);
    var vItem = variant == null ? null : variant.getVisible(target);
    if (vItem) {
      if (vItem.getOption() == Variant.addition) {
        if (visible) {
          item.addItem(new Item2(visible));
        }
      }
      vItem.getValues().forEach((value) => {
        if (value)
          item.addItem(new Item2(value));
      });
    } else {
      if (visible) {
        item.addItem(new Item2(visible));
      }
    }
    vItem = variant == null ? null : variant.getVisibleDep(target);
    if (vItem) {
      if (vItem.getOption() == Variant.addition) {
        if (depend) {
          item.addDepends(depend.split(","));
        }
      }
      item.addDepends(vItem.getValues());
    } else {
      if (depend) {
        item.addDepends(depend.split(","));
      }
    }
    return item;
  }
  createCheckItem(target, source, type, checkRule, errorInfo2, required, depend, variant) {
    var item = new CheckItem(target, source, type);
    var vItem = variant == null ? null : variant.getCheckRule(target);
    if (vItem) {
      if (vItem.getOption() == Variant.addition) {
        if (checkRule) {
          item.addItem(new Item2(checkRule));
        }
      }
      vItem.getValues().forEach(function(value) {
        if (value)
          item.addItem(new Item2(value));
      });
    } else {
      if (checkRule) {
        item.addItem(new Item2(checkRule));
      }
    }
    vItem = variant == null ? null : variant.getCheckRuleDep(target);
    if (vItem) {
      if (vItem.getOption() == Variant.addition) {
        if (depend) {
          item.addDepends(depend.split(","));
        }
      }
      item.addDepends(vItem.getValues());
    } else {
      if (depend) {
        item.addDepends(depend.split(","));
      }
    }
    item.setErrorMsg(variant == null ? errorInfo2 : variant.getErrorInfo(target));
    item.setRequired(variant == null ? !!required : variant.getRequired(target, required));
    return item;
  }
  createCheckItems(target, type, collection, variant) {
    var vItem = variant == null ? null : variant.getCheckRule(target);
    var dItem = variant == null ? null : variant.getCheckRuleDep(target);
    if (vItem) {
      var items = [];
      if (vItem.getOption() == Variant.addition) {
        items = this.createCheckRulesImpl(collection, target, type);
      }
      vItem.getValues().forEach(function(value, i2) {
        var item = new CheckItem(target, target + "_Global" + i2, type);
        item.addItem(new Item2(value));
        if (dItem) {
          var depend = dItem.getValues()[i2];
          if (depend) {
            item.addDepends(depend.split(","));
          }
        }
        items.push(item);
      });
    } else {
      return this.createCheckRulesImpl(collection, target, type);
    }
  }
  // 构建原始集合
  createCheckRulesImpl(collection, target, type) {
    var items = [];
    if (collection) {
      collection.forEach(function(rule, i2) {
        if (rule.content) {
          var item = new CheckItem(target, rule.key || target + "_Global" + i2, type);
          item.addItem(new Item2(rule.content));
          item.setErrorMsg(rule.errorInfo);
          if (rule.dependency) {
            item.addDepends(rule.dependency.split(","));
          }
          items.push(item);
        }
      });
    }
    return items;
  }
}
class DefaultExprHandler extends BaseExprHandler {
  doCalcItemInit(meta, variant) {
    var metaKey = meta.key;
    var items = [];
    if (metaKey) {
      var binding = meta.dataBinding;
      var defaultValue = binding ? binding.defaultValue : "";
      var formulaValue = binding ? binding.defaultFormulaValue : "";
      var valueDependency = binding ? binding.valueDependency : "";
      var item = this.createCalcItem(
        metaKey,
        metaKey,
        CalcItemType.HEAD,
        defaultValue,
        formulaValue,
        valueDependency,
        variant
      );
      items.push(item);
    }
    return items;
  }
  doEnableItemInit(meta, tree, variant) {
    var metaKey = meta.key;
    if (metaKey) {
      var item = this.createEnableItem(
        metaKey,
        metaKey,
        EnableItemType.HEAD,
        meta.enable,
        meta.enableDependency,
        variant
      );
      tree.add(item);
    }
  }
  doVisibleItemInit(meta, tree, variant) {
    var metaKey = meta.key;
    if (metaKey) {
      var item = this.createVisibleItem(
        metaKey,
        metaKey,
        VisibleItemType.HEAD,
        meta.visible,
        meta.visibleDependency,
        variant
      );
      tree.add(item);
    }
  }
  doCheckItemInit(meta, tree, variant) {
    var metaKey = meta.key;
    if (metaKey) {
      var binding = meta.dataBinding;
      var checkRule = binding ? binding.checkRule : "";
      var errorInfo2 = binding ? binding.errorInfo : "";
      var required = binding ? binding.required : "";
      var checkDependency = binding ? binding.checkDependency : "";
      var vItem = variant == null ? null : variant.getCheckRule(metaKey);
      if (checkRule || required || vItem) {
        var item = this.createCheckItem(
          metaKey,
          metaKey,
          CheckItemType.HEAD,
          checkRule,
          errorInfo2,
          required,
          checkDependency,
          variant
        );
        tree.add(item);
      }
    }
  }
  doOperationEnableInit(metaForm, tree, variant) {
    var self = this;
    metaForm.operations.forEach(function(opt) {
      var item = self.createEnableItem(
        opt.key,
        opt.key,
        EnableItemType.OPERATION,
        opt.enableCnt,
        opt.enableDependency,
        variant
      );
      tree.add(item);
    });
  }
  doOperationVisibleInit(metaForm, tree, variant) {
    var self = this;
    metaForm.operations.forEach(function(opt) {
      var item = self.createVisibleItem(
        opt.key,
        opt.key,
        VisibleItemType.OPERATION,
        opt.visibleCnt,
        opt.visibleDependency,
        variant
      );
      tree.add(item);
    });
  }
  doGlobalCheckInit(metaForm, tree, variant) {
    var items = this.createCheckItems(
      metaForm.key,
      CheckItemType.GLOBAL,
      metaForm.uichecks,
      variant
    );
    tree.setGlobalItems(items);
    return items;
  }
}
class VisibleItemSet {
  constructor(source) {
    this.items = [];
    this.objectType = ExprItemType.Set;
    this.source = source;
  }
  getObjectType() {
    return this.objectType;
  }
  setSource(source) {
    this.source = source;
  }
  getSource() {
    return this.source;
  }
  add(item) {
    return this.items.push(item);
  }
  get(index) {
    return this.items[index];
  }
  size() {
    return this.items.length;
  }
  getItems() {
    return this.items;
  }
}
class EnableItemSet {
  constructor(source) {
    this.items = [];
    this.objectType = ExprItemType.Set;
    this.source = source;
  }
  getObjectType() {
    return this.objectType;
  }
  setSource(source) {
    this.source = source;
  }
  getSource() {
    return this.source;
  }
  add(item) {
    return this.items.push(item);
  }
  get(index) {
    return this.items[index];
  }
  getItems() {
    return this.items;
  }
  size() {
    return this.items.length;
  }
}
class CheckItemSet {
  constructor(source) {
    this.items = [];
    this.objectType = ExprItemType.Set;
    this.source = source;
  }
  getObjectType() {
    return this.objectType;
  }
  setSource(source) {
    this.source = source;
  }
  getSource() {
    return this.source;
  }
  add(item) {
    return this.items.push(item);
  }
  get(index) {
    return this.items[index];
  }
  getItems() {
    return this.items;
  }
  size() {
    return this.items.length;
  }
}
class ExprItemPos {
  constructor() {
    this.columnExpand = false;
    this.index = -1;
    this.indexes = [];
    this.setIndexes = function(indexes) {
      this.indexes = indexes;
    };
  }
  setColumnExpand(columnExpand) {
    this.columnExpand = columnExpand;
  }
  isColumnExpand() {
    return this.columnExpand;
  }
  setIndex(index) {
    this.index = index;
  }
  getIndex() {
    return this.index;
  }
  getIndexes() {
    return this.indexes;
  }
}
class GridExprHandler extends BaseExprHandler {
  doCalcItemInit(meta, variant) {
    var rows = meta.rows;
    var self = this, items = [];
    rows.forEach(function(row) {
      if (row.rowType == "Detail" || row.rowType == "Fix") {
        var index = 0;
        row.cells.forEach(function(cell) {
          var cellKey = cell.key;
          if (cellKey) {
            var binding = cell.dataBinding;
            var defaultValue = binding ? binding.defaultValue : "";
            var defaultValue = defaultValue || cell.dsDefaultValue;
            var formulaValue = binding ? binding.defaultFormulaValue : "";
            var valueDependency = binding ? binding.valueDependency : "";
            var item = self.createCalcItem(
              cellKey,
              meta.key,
              row.rowType == "Detail" ? CalcItemType.LIST : CalcItemType.HEAD,
              defaultValue,
              formulaValue,
              valueDependency,
              variant
            );
            var pos = new ExprItemPos();
            pos.setIndex(index);
            item.setPos(pos);
            if (row.rowType == "Detail" && meta.hasTree) {
              item.setTreeSum(item.getFormulaValue() && item.getFormulaValue().indexOf("Sum(") != -1);
            }
            items.push(item);
          }
          index++;
        });
      }
    });
    return items;
  }
  doEnableItemInit(meta, tree, variant) {
    var self = this;
    var getCellEnable = function(metaCell, index) {
      var o = {};
      o.enable = metaCell.enable;
      o.enableDependency = metaCell.enableDependency;
      if (!o.enable) {
        var column = meta.leafColumns[index];
        o.enable = column.enable;
        o.enableDependency = column.enableDependency;
        if (!o.enable) {
          o.enable = meta.enable;
          o.enableDependency = meta.enableDependency;
        }
      }
      return o;
    };
    var metaKey = meta.key;
    if (metaKey) {
      var item = self.createEnableItem(
        metaKey,
        metaKey,
        EnableItemType.HEAD,
        meta.enable,
        meta.enableDependency,
        variant
      );
      tree.add(item);
      var itemSet = new EnableItemSet(metaKey);
      tree.add(itemSet);
      var rows = meta.rows;
      rows.forEach(function(row) {
        if (row.rowType == "Detail" || row.rowType == "Fix") {
          var index = 0;
          row.cells.forEach(function(cell) {
            var cellKey = cell.key;
            if (cellKey) {
              var cellO = getCellEnable(cell, index);
              var item2 = self.createEnableItem(
                cellKey,
                meta.key,
                row.rowType == "Detail" ? EnableItemType.LIST : EnableItemType.HEAD,
                cellO.enable,
                cellO.enableDependency,
                variant
              );
              var pos = new ExprItemPos();
              pos.setIndex(index);
              item2.setPos(pos);
              if (item2.getType() == EnableItemType.LIST) {
                itemSet.add(item2);
              } else {
                tree.add(item2);
              }
            }
            index++;
          });
        }
      });
      let extOpts = meta.extOpts;
      if (extOpts) {
        extOpts.forEach((opt) => {
          if (opt.enable) {
            item = self.createEnableItem(
              opt.key,
              metaKey,
              EnableItemType.GRIDOPERATION,
              opt.enable,
              opt.enableDependency,
              variant
            );
            tree.add(item);
          }
        });
      }
    }
  }
  doVisibleItemInit(meta, tree, variant) {
    var self = this;
    var metaKey = meta.key;
    if (metaKey) {
      var item = self.createVisibleItem(
        metaKey,
        metaKey,
        VisibleItemType.HEAD,
        meta.visible,
        meta.visibleDependency,
        variant
      );
      tree.add(item);
      var buildColumnsVisible = function(meta2, columns2, itemSet2, refIndex2) {
        columns2.forEach(function(column) {
          var _columns = column.columns;
          if (_columns && _columns.length > 0) {
            buildColumnsVisible(meta2, _columns, itemSet2, refIndex2);
          } else {
            buildColumnVisible(meta2, column, itemSet2, refIndex2);
          }
        });
      };
      var buildColumnVisible = function(meta2, metaColumn, itemSet2, refIndex2) {
        var colKey = metaColumn.key;
        var item2 = self.createVisibleItem(
          colKey,
          meta2.key,
          VisibleItemType.COLUMN,
          metaColumn.visible,
          metaColumn.visibleDependency,
          variant
        );
        var index = refIndex2.index;
        var pos = new ExprItemPos();
        pos.setIndex(index);
        item2.setPos(pos);
        itemSet2.add(item2);
        refIndex2.index = index + 1;
        itemSet2.add(item2);
      };
      var columns = meta.columns;
      var refIndex = { index: 0 };
      var itemSet = new VisibleItemSet(metaKey);
      tree.add(itemSet);
      buildColumnsVisible(meta, columns, itemSet, refIndex);
      var rows = meta.rows;
      rows.forEach(function(row) {
        if (row.rowType !== "Detail" && row.visible) {
          var type;
          switch (row.rowType) {
            case "Fix":
              type = VisibleItemType.FIXROW;
              break;
            case "Total":
              type = VisibleItemType.TOTALROW;
              break;
            case "Group":
              type = VisibleItemType.GROUPROW;
              break;
          }
          var item2 = self.createVisibleItem(
            row.key,
            metaKey,
            type,
            row.visible,
            row.visibleDependency,
            variant
          );
          if (type == VisibleItemType.GROUPROW) {
            tree.addGroupVisibleTag(metaKey);
          }
          tree.add(item2);
        }
      });
      let extOpts = meta.extOpts;
      if (extOpts) {
        extOpts.forEach((opt) => {
          if (opt.visible) {
            item = self.createVisibleItem(
              opt.key,
              metaKey,
              VisibleItemType.GRIDOPERATION,
              opt.visible,
              opt.visibleDependency,
              variant
            );
            tree.add(item);
          }
        });
      }
    }
  }
  doCheckItemInit(meta, tree, variant) {
    var self = this;
    var metaKey = meta.key;
    var itemSet = new CheckItemSet(metaKey);
    tree.add(itemSet);
    var rows = meta.rows;
    rows.forEach(function(row) {
      if (row.rowType == "Detail" || row.rowType == "Fix") {
        var index = 0;
        row.cells.forEach(function(cell) {
          var cellKey = cell.key;
          if (cellKey) {
            var binding = cell.dataBinding;
            var checkRule = binding ? binding.checkRule : "";
            var errorInfo2 = binding ? binding.errorInfo : "";
            var required = binding ? binding.required : "";
            var checkDependency = binding ? binding.checkDependency : "";
            var vItem = variant == null ? null : variant.getCheckRule(cellKey);
            if (checkRule || required || vItem) {
              var item = self.createCheckItem(
                cellKey,
                meta.key,
                row.rowType == "Detail" ? CheckItemType.LIST : CheckItemType.HEAD,
                checkRule,
                errorInfo2,
                required,
                checkDependency,
                variant
              );
              var pos = new ExprItemPos();
              pos.setIndex(index);
              item.setPos(pos);
              if (item.getType() == CheckItemType.LIST) {
                itemSet.add(item);
              } else {
                tree.add(item);
              }
            }
          }
          index++;
        });
        if (row.rowType == "Detail") {
          var items = self.createCheckItems(row.key, metaKey, row.checkRules, variant);
          if (items && items.length > 0) {
            tree.setRowItems(row.key, items);
          }
        }
      }
    });
  }
}
class ListViewExprHandler extends BaseExprHandler {
  doCalcItemInit(metaLV, variant) {
    var columns = metaLV.columnInfo;
    var self = this, items = [];
    var index = 0;
    columns.forEach(function(column) {
      var colKey = column.key;
      if (colKey) {
        var binding = column.dataBinding;
        var defaultValue = binding ? binding.defaultValue : "";
        if (!defaultValue) {
          defaultValue = column.defaultValue;
        }
        var formulaValue = binding ? binding.defaultFormulaValue : "";
        if (!formulaValue) {
          formulaValue = column.formulaValue;
        }
        var valueDependency = binding ? binding.valueDependency : "";
        if (!valueDependency) {
          valueDependency = column.valueDependency;
        }
        var item = self.createCalcItem(
          colKey,
          metaLV.key,
          CalcItemType.LIST,
          defaultValue,
          formulaValue,
          valueDependency,
          variant
        );
        var pos = new ExprItemPos();
        pos.setIndex(index);
        item.setPos(pos);
        items.push(item);
      }
      index++;
    });
    return items;
  }
  doEnableItemInit(metaLV, tree, variant) {
    var metaKey = metaLV.key;
    var self = this;
    if (metaKey) {
      var item = self.createEnableItem(
        metaKey,
        metaKey,
        EnableItemType.HEAD,
        metaLV.enable,
        metaLV.enableDependency,
        variant
      );
      tree.add(item);
      var itemSet = new EnableItemSet(metaKey);
      tree.add(itemSet);
      var index = 0;
      metaLV.columnInfo.forEach(function(column) {
        var colKey = column.key;
        if (colKey) {
          var item2 = self.createEnableItem(
            colKey,
            metaKey,
            EnableItemType.LIST,
            column.enable,
            column.enableDependency,
            variant
          );
          var pos = new ExprItemPos();
          pos.setIndex(index);
          item2.setPos(pos);
          itemSet.add(item2);
        }
        index++;
      });
    }
  }
  doVisibleItemInit(metaLV, tree, variant) {
    var metaKey = metaLV.key;
    var self = this;
    if (metaKey) {
      var item = self.createVisibleItem(
        metaKey,
        metaKey,
        VisibleItemType.HEAD,
        metaLV.visible,
        metaLV.visibleDependency,
        variant
      );
      tree.add(item);
      var itemSet = new VisibleItemSet(metaKey);
      tree.add(itemSet);
      var index = 0;
      metaLV.columnInfo.forEach(function(column) {
        var colKey = column.key;
        if (colKey) {
          var item2 = self.createVisibleItem(
            colKey,
            metaKey,
            VisibleItemType.COLUMN,
            column.visible,
            column.visibleDependency,
            variant
          );
          var pos = new ExprItemPos();
          pos.setIndex(index);
          item2.setPos(pos);
          itemSet.add(item2);
        }
        index++;
      });
    }
  }
  doCheckItemInit(metaLV, tree, variant) {
    var metaKey = metaLV.key;
    var self = this;
    if (metaKey) {
      var itemSet = new CheckItemSet(metaKey);
      tree.add(itemSet);
      var index = 0;
      metaLV.columnInfo.forEach(function(column) {
        var colKey = column.key;
        if (colKey) {
          var binding = column.dataBinding;
          var checkRule = binding ? binding.checkRule : "";
          var errorInfo2 = binding ? binding.errorInfo : "";
          var required = binding ? binding.required : "";
          var checkDependency = binding ? binding.checkDependency : "";
          var item = self.createCheckItem(
            colKey,
            metaKey,
            CheckItemType.LIST,
            checkRule,
            errorInfo2,
            required,
            checkDependency,
            variant
          );
          var pos = new ExprItemPos();
          pos.setIndex(index);
          item.setPos(pos);
          itemSet.add(item);
        }
        index++;
      });
    }
  }
}
class TabGroupExprHandler extends BaseExprHandler {
  doCalcItemInit(meta, variant) {
  }
  doEnableItemInit(meta, variant) {
  }
  doCheckItemInit(meta, variant) {
  }
  doVisibleItemInit(meta, tree, variant) {
    var self = this;
    var metaKey = meta.key;
    if (metaKey) {
      var item = self.createVisibleItem(
        metaKey,
        metaKey,
        VisibleItemType.HEAD,
        meta.visible,
        meta.visibleDependency,
        variant
      );
      tree.add(item);
      var items = meta.items;
      if (items) {
        items.forEach((item2) => {
          var comKey = item2.key;
          if (comKey) {
            var visibleItem = self.createVisibleItem(
              comKey,
              metaKey,
              VisibleItemType.HEAD,
              item2.visible,
              item2.visibleDependency,
              variant
            );
            tree.add(visibleItem);
          }
        });
      }
    }
  }
}
class TableViewExprHandler extends BaseExprHandler {
  doCalcItemInit(meta, variant) {
    var rows = meta.rows;
    var self = this, items = [];
    rows.forEach(function(row) {
      row.cells.forEach(function(cell, index) {
        var cellKey = cell.key;
        if (cellKey) {
          var binding = cell.dataBinding;
          var defaultValue = binding ? binding.defaultValue : "";
          var defaultValue = defaultValue || cell.dsDefaultValue;
          var formulaValue = binding ? binding.defaultFormulaValue : "";
          var valueDependency = binding ? binding.valueDependency : "";
          var item = self.createCalcItem(
            cellKey,
            row.rowType == RowType.STR_FIXED ? cellKey : meta.key,
            row.rowType == RowType.STR_FIXED ? CalcItemType.HEAD : CalcItemType.LIST,
            defaultValue,
            formulaValue,
            valueDependency,
            variant
          );
          var pos = new ExprItemPos();
          pos.setIndex(index);
          item.setPos(pos);
          item.setTreeSum(item.getFormulaValue() && item.getFormulaValue().indexOf("Sum(") != -1);
          items.push(item);
        }
      });
    });
    return items;
  }
  doEnableItemInit(meta, tree, variant) {
    var self = this;
    var getCellEnable = function(metaCell, index) {
      var o = {};
      o.enable = metaCell.enable;
      o.enableDependency = metaCell.enableDependency;
      if (!o.enable) {
        o.enable = meta.enable;
        o.enableDependency = meta.enableDependency;
      }
      return o;
    };
    var metaKey = meta.key;
    if (metaKey) {
      var item = self.createEnableItem(
        metaKey,
        metaKey,
        EnableItemType.HEAD,
        meta.enable,
        meta.enableDependency,
        variant
      );
      tree.add(item);
      var itemSet = new EnableItemSet(metaKey);
      tree.add(itemSet);
      var rows = meta.rows;
      rows.forEach(function(row) {
        row.cells.forEach(function(cell, index) {
          var cellKey = cell.key;
          if (cellKey) {
            var cellO = getCellEnable(cell);
            var item2 = self.createEnableItem(
              cellKey,
              row.rowType == RowType.STR_FIXED ? cellKey : meta.key,
              row.rowType == RowType.STR_FIXED ? EnableItemType.HEAD : EnableItemType.LIST,
              cellO.enable,
              cellO.enableDependency,
              variant
            );
            var pos = new ExprItemPos();
            pos.setIndex(index);
            item2.setPos(pos);
            if (item2.getType() == EnableItemType.LIST) {
              itemSet.add(item2);
            } else {
              tree.add(item2);
            }
          }
        });
      });
      let extOpts = meta.extOpts;
      if (extOpts) {
        extOpts.forEach((opt) => {
          if (opt.enable) {
            item = self.createEnableItem(
              opt.key,
              metaKey,
              EnableItemType.GRIDOPERATION,
              opt.enable,
              opt.enableDependency,
              variant
            );
            tree.add(item);
          }
        });
      }
    }
  }
  doVisibleItemInit(meta, tree, variant) {
    var self = this;
    var getCellVisible = function(metaCell, index) {
      var o = {};
      o.visible = metaCell.visible;
      o.visibleDependency = metaCell.visibleDependency;
      if (!o.visible) {
        o.visible = meta.visible;
        o.visibleDependency = meta.visibleDependency;
      }
      return o;
    };
    var metaKey = meta.key;
    if (metaKey) {
      var item = self.createVisibleItem(
        metaKey,
        metaKey,
        VisibleItemType.HEAD,
        meta.visible,
        meta.visibleDependency,
        variant
      );
      tree.add(item);
      var itemSet = new VisibleItemSet(metaKey);
      tree.add(itemSet);
      var rows = meta.rows;
      rows.forEach(function(row) {
        row.cells.forEach(function(cell, index) {
          var cellKey = cell.key;
          if (cellKey) {
            var cellO = getCellVisible(cell);
            var item2 = self.createVisibleItem(
              cellKey,
              row.rowType == RowType.STR_FIXED ? cellKey : meta.key,
              row.rowType == RowType.STR_FIXED ? VisibleItemType.HEAD : VisibleItemType.COLUMN,
              cellO.visible,
              cellO.visibleDependency,
              variant
            );
            var pos = new ExprItemPos();
            pos.setIndex(index);
            item2.setPos(pos);
            if (item2.getType() == VisibleItemType.COLUMN) {
              itemSet.add(item2);
            } else {
              tree.add(item2);
            }
          }
        });
      });
      let extOpts = meta.extOpts;
      if (extOpts) {
        extOpts.forEach((opt) => {
          if (opt.visible) {
            item = self.createVisibleItem(
              opt.key,
              metaKey,
              VisibleItemType.GRIDOPERATION,
              opt.visible,
              opt.visibleDependency,
              variant
            );
            tree.add(item);
          }
        });
      }
    }
  }
  doCheckItemInit(meta, tree, variant) {
    var self = this;
    var metaKey = meta.key;
    var itemSet = new CheckItemSet(metaKey);
    tree.add(itemSet);
    var rows = meta.rows;
    rows.forEach(function(row) {
      var index = 0;
      row.cells.forEach(function(cell) {
        var cellKey = cell.key;
        if (cellKey) {
          var binding = cell.dataBinding;
          var checkRule = binding ? binding.checkRule : "";
          var errorInfo2 = binding ? binding.errorInfo : "";
          var required = binding ? binding.required : "";
          var checkDependency = binding ? binding.checkDependency : "";
          var vItem = variant == null ? null : variant.getCheckRule(cellKey);
          if (checkRule || required || vItem) {
            var item = self.createCheckItem(
              cellKey,
              row.rowType == RowType.STR_FIXED ? cellKey : meta.key,
              row.rowType == RowType.STR_FIXED ? CheckItemType.HEAD : CheckItemType.LIST,
              checkRule,
              errorInfo2,
              required,
              checkDependency,
              variant
            );
            var pos = new ExprItemPos();
            pos.setIndex(index);
            item.setPos(pos);
            if (item.getType() == CheckItemType.LIST) {
              itemSet.add(item);
            } else {
              tree.add(item);
            }
          }
        }
        index++;
      });
      var items = self.createCheckItems(row.key, metaKey, row.checkRules, variant);
      if (items && items.length > 0) {
        tree.setRowItems(row.key, items);
      }
    });
  }
}
class EidtViewExprHandler extends BaseExprHandler {
  doCalcItemInit(metaLV, variant) {
    var columns = metaLV.columnInfo;
    var self = this, items = [];
    var index = 0;
    columns.forEach(function(column) {
      var colKey = column.key;
      if (colKey) {
        var binding = column.dataBinding;
        var defaultValue = binding ? binding.defaultValue : "";
        if (!defaultValue) {
          defaultValue = column.defaultValue;
        }
        var formulaValue = binding ? binding.defaultFormulaValue : "";
        if (!formulaValue) {
          formulaValue = column.formulaValue;
        }
        var valueDependency = binding ? binding.valueDependency : "";
        if (!valueDependency) {
          valueDependency = column.valueDependency;
        }
        var item = self.createCalcItem(
          colKey,
          metaLV.key,
          CalcItemType.LIST,
          defaultValue,
          formulaValue,
          valueDependency,
          variant
        );
        var pos = new ExprItemPos();
        pos.setIndex(index);
        item.setPos(pos);
        items.push(item);
      }
      index++;
    });
    return items;
  }
  doEnableItemInit(metaLV, tree, variant) {
    var metaKey = metaLV.key;
    var self = this;
    if (metaKey) {
      var item = self.createEnableItem(
        metaKey,
        metaKey,
        EnableItemType.HEAD,
        metaLV.enable,
        metaLV.enableDependency,
        variant
      );
      tree.add(item);
      var itemSet = new EnableItemSet(metaKey);
      tree.add(itemSet);
      var index = 0;
      metaLV.columnInfo.forEach(function(column) {
        var colKey = column.key;
        if (colKey) {
          var item2 = self.createEnableItem(
            colKey,
            metaKey,
            EnableItemType.LIST,
            column.enable,
            column.enableDependency,
            variant
          );
          var pos = new ExprItemPos();
          pos.setIndex(index);
          item2.setPos(pos);
          itemSet.add(item2);
        }
        index++;
      });
    }
  }
  doVisibleItemInit(metaLV, tree, variant) {
    var metaKey = metaLV.key;
    var self = this;
    if (metaKey) {
      var item = self.createVisibleItem(
        metaKey,
        metaKey,
        VisibleItemType.HEAD,
        metaLV.visible,
        metaLV.visibleDependency,
        variant
      );
      tree.add(item);
      var itemSet = new VisibleItemSet(metaKey);
      tree.add(itemSet);
      var index = 0;
      metaLV.columnInfo.forEach(function(column) {
        var colKey = column.key;
        if (colKey) {
          var item2 = self.createVisibleItem(
            colKey,
            metaKey,
            VisibleItemType.COLUMN,
            column.visible,
            column.visibleDependency,
            variant
          );
          var pos = new ExprItemPos();
          pos.setIndex(index);
          item2.setPos(pos);
          itemSet.add(item2);
        }
        index++;
      });
    }
  }
  doCheckItemInit(metaLV, tree, variant) {
    var metaKey = metaLV.key;
    var self = this;
    if (metaKey) {
      var itemSet = new CheckItemSet(metaKey);
      tree.add(itemSet);
      var index = 0;
      metaLV.columnInfo.forEach(function(column) {
        var colKey = column.key;
        if (colKey) {
          var binding = column.dataBinding;
          var checkRule = binding ? binding.checkRule : "";
          var errorInfo2 = binding ? binding.errorInfo : "";
          var required = binding ? binding.required : "";
          var checkDependency = binding ? binding.checkDependency : "";
          var item = self.createCheckItem(
            colKey,
            metaKey,
            CheckItemType.LIST,
            checkRule,
            errorInfo2,
            required,
            checkDependency,
            variant
          );
          var pos = new ExprItemPos();
          pos.setIndex(index);
          item.setPos(pos);
          itemSet.add(item);
        }
        index++;
      });
    }
  }
}
const map$3 = new HashMap();
map$3.put(0, DefaultExprHandler);
map$3.put(ControlType.GRID, GridExprHandler);
map$3.put(ControlType.LISTVIEW, ListViewExprHandler);
map$3.put(ControlType.TABLEVIEW, TableViewExprHandler);
map$3.put(ControlType.TABGROUP, TabGroupExprHandler);
map$3.put(ControlType.EDITVIEW, EidtViewExprHandler);
map$3.put(ControlType.ROTATOR, EidtViewExprHandler);
map$3.put(ControlType.ROTATORLIST, EidtViewExprHandler);
map$3.put(ControlType.WATERFALL, EidtViewExprHandler);
map$3.put(ControlType.TILEDLIST, EidtViewExprHandler);
map$3.put(ControlType.GALLERY, EidtViewExprHandler);
class ExprHandlerMap {
  static getImpl(type) {
    return map$3.get(type);
  }
  static reg(type, name2) {
    map$3.put(type, name2);
  }
}
class FormType {
  static parse(s) {
    var type = -1;
    if (this.STR_Normal == s) {
      type = this.NORMAL;
    } else if (this.STR_Entity == s) {
      type = this.ENTITY;
    } else if (this.STR_Dict == s) {
      type = this.DICT;
    } else if (this.STR_View == s) {
      type = this.VIEW;
    } else if (this.STR_Detail == s) {
      type = this.DETAIL;
    } else if (this.STR_Report == s) {
      type = this.REPORT;
    } else if (this.STR_ChainDict == s) {
      type = this.CHAINDICT;
    } else if (this.STR_CompDict == s) {
      type = this.CHAINDICT;
    } else if (this.STR_Template == s) {
      type = this.TEMPLATE;
    } else if (this.STR_Extension == s) {
      type = this.EXTENSION;
    }
    return type;
  }
  static toString(type) {
    var s = null;
    switch (type) {
      case this.NORMAL:
        s = this.STR_Normal;
        break;
      case this.ENTITY:
        s = this.STR_Entity;
        break;
      case this.DICT:
        s = this.STR_Dict;
        break;
      case this.VIEW:
        s = this.STR_View;
        break;
      case this.DETAIL:
        s = this.STR_Detail;
        break;
      case this.REPORT:
        s = this.STR_Report;
        break;
      case this.CHAINDICT:
        s = this.STR_ChainDict;
        break;
      case this.COMPDICT:
        s = this.STR_CompDict;
        break;
      case this.TEMPLATE:
        s = this.STR_Template;
        break;
      case this.EXTENSION:
        s = this.STR_Extension;
        break;
    }
    return s;
  }
}
FormType.NORMAL = 0;
FormType.ENTITY = 1;
FormType.DICT = 2;
FormType.VIEW = 3;
FormType.DETAIL = 4;
FormType.REPORT = 5;
FormType.CHAINDICT = 6;
FormType.COMPDICT = 7;
FormType.TEMPLATE = 8;
FormType.EXTENSION = 9;
FormType.STR_Normal = "Normal";
FormType.STR_Entity = "Entity";
FormType.STR_Dict = "Dict";
FormType.STR_View = "View";
FormType.STR_Detail = "Detail";
FormType.STR_Report = "Report";
FormType.STR_ChainDict = "ChainDict";
FormType.STR_CompDict = "CompDict";
FormType.STR_Template = "Template";
FormType.STR_Extension = "Extension";
class Paras {
  constructor(json) {
    this.map = {};
    this.mapType = {};
    this.init(json);
  }
  put(key, value) {
    this.map[key] = value;
  }
  get(key) {
    if (this.map.hasOwnProperty(key)) {
      return this.map[key];
    }
    return null;
  }
  remove(key) {
    delete this.map[key];
    delete this.mapType[key];
  }
  getMap() {
    return this.map;
  }
  init(json) {
    if (Utils.isEmptyObject(json))
      return;
    var items = json.items;
    for (var i2 = 0, len = items.length; i2 < len; i2++) {
      var item = items[i2];
      this.put(item.key, item.value);
      this.mapType[item.key] = item.type;
    }
  }
  toJSON() {
    let json = {};
    if (!Utils.isEmptyObject(this.map)) {
      var items = [];
      for (var m in this.map) {
        var v = this.map[m];
        var type = this.mapType[m];
        if (!type || type == -1) {
          if (typeof v == "string") {
            type = JavaDataType.USER_STRING;
          } else if (v instanceof Decimal) {
            type = JavaDataType.USER_NUMERIC;
            v = v.toString();
          } else if (Utils.isNumeric(v)) {
            type = JavaDataType.USER_LONG;
          } else if (typeof v == "boolean") {
            type = JavaDataType.USER_BOOLEAN;
          } else if (v instanceof Date) {
            type = JavaDataType.USER_DATETIME;
            v = v.getTime();
          }
        }
        var item = {
          key: m,
          value: v,
          type
        };
        items.push(item);
      }
      json.items = items;
    }
    return JSON.stringify(json);
  }
  updateParas(paraJson, excludeKeys) {
    if (Utils.isEmptyObject(paraJson) || Utils.isEmptyObject(paraJson.items)) {
      return;
    }
    const items = paraJson.items;
    for (let i2 = 0, len = items.length; i2 < len; i2++) {
      const item = items[i2];
      if (!Utils.isEmptyObject(excludeKeys) && excludeKeys.hasOwnProperty(item.key)) {
        continue;
      }
      this.put(item.key, item.value);
      this.mapType[item.key] = item.type;
    }
  }
}
class MetaForm {
  constructor(jsonObj) {
    this.operations = [];
    this.uichecks = [];
    this.componentMap = new HashMap();
    this.detailCompMap = new HashMap();
    this.gridArray = [];
    this.lvArray = [];
    this.detailArray = [];
    this.tableViewArray = [];
    this.expandGridArray = [];
    this.subDetailCompMap = new HashMap();
    this.operationState = jsonObj["operationState"] ? jsonObj["operationState"] : OperationState.DEFAULT;
    this.mergeToSource = jsonObj["MergeToSource"] ? jsonObj["MergeToSource"] : false;
    this.initState = jsonObj["initState"] || OperationState.DEFAULT;
    this.type = jsonObj["type"] || FormType.NORMAL;
    this.sourceForm = jsonObj["sourceForm"];
    this.operations = [];
    var operationCollection = jsonObj["operationCollection"];
    if (operationCollection) {
      this.operations = operationCollection.items.concat();
    }
    var uiCheckRuleCollection = jsonObj["uiCheckRuleCollection"];
    if (uiCheckRuleCollection) {
      this.uichecks = uiCheckRuleCollection.slice();
    }
    this.defTbr = jsonObj["defTbr"];
    this.key = jsonObj["key"];
    this.version = jsonObj["version"] || -1;
    this.platform = jsonObj["platform"] || -1;
    this.formKey = jsonObj["key"];
    this.extend = jsonObj["extend"];
    this.caption = jsonObj["caption"];
    this.abbrCaption = jsonObj["abbrCaption"];
    this.formulaCaption = jsonObj["formulaCaption"];
    this.formulaAbbrCaption = jsonObj["formulaAbbrCaption"];
    this.extensionFormKey = jsonObj["extensionFormKey"];
    this.target = jsonObj["target"];
    this.onLoad = jsonObj["onLoad"];
    this.onClose = jsonObj["onClose"];
    this.scriptCollection = jsonObj["scriptCollection"];
    this.cellTypeGroup = jsonObj["cellTypeGroup"];
    this.templateKey = jsonObj["templateKey"];
    this.body = jsonObj["body"];
    var body = this.body;
    var indexOfblock = body["index_of_block"];
    var block = body["items"][indexOfblock];
    this.lazyCompute = body["lazyCompute"];
    this.viewCollection = body["viewCollection"];
    var root = block["root"];
    root.topMargin = jsonObj["topMargin"];
    root.bottomMargin = jsonObj["bottomMargin"];
    root.leftMargin = jsonObj["leftMargin"];
    root.rightMargin = jsonObj["rightMargin"];
    root.abbrCaption = jsonObj["abbrCaption"];
    root.hAlign = jsonObj["hAlign"];
    root.height = "100%";
    this.root = root;
    this.authenticate = jsonObj["authenticate"];
    this.standalone = jsonObj["standalone"] || false;
    this.shouldInitFocus = jsonObj["initFocus"];
    this.confirmClose = jsonObj["confirmClose"];
    this.macroCollection = jsonObj["macroCollection"];
    this.statusItems = jsonObj["statusItems"];
    this.statusBarColor = jsonObj["statusBarColor"];
    this.paraGroups = jsonObj["paraGroups"];
    this.sysExpVals = jsonObj["sysExpVals"];
    this.paras = new Paras(jsonObj["parameters"]);
    this.callParas = new Paras(jsonObj["callParameters"]);
    this.paraCollection = jsonObj["paraCollection"];
    this.checkRules = jsonObj["checkRules"];
    this.mapGrids = jsonObj["mapGrids"];
    this.dataSource = jsonObj["dataSource"] || null;
    this.dataObject = this.dataSource && this.dataSource.dataObject;
    this.mainTableKey = this.dataObject && this.dataObject.primaryTableKey;
    this.dataObjectKey = this.dataObject && this.dataObject.key;
    this.postShow = jsonObj["postShow"] || null;
    this.timerTaskCollection = jsonObj["timerTaskCollection"];
    this.navigation = jsonObj["navigation"] || null;
    this.hasNavigationBar = jsonObj["hasNavigationBar"] ? String(jsonObj["hasNavigationBar"]) == "true" : true;
    this.delayMergeInfo = jsonObj["delayMergeInfo"];
    var body = jsonObj["body"];
    if (body) {
      this.popWidth = body["popWidth"];
      this.popHeight = body["popHeight"];
      this.resizable = body["resizable"];
    }
    this.topMargin = jsonObj["topMargin"];
    this.bottomMargin = jsonObj["bottomMargin"];
    this.leftMargin = jsonObj["leftMargin"];
    this.rightMargin = jsonObj["rightMargin"];
    this.projectKey = jsonObj["projectKey"];
    this.variant = jsonObj["variant"];
    this.useVariant = jsonObj["useVariant"];
    this.dimValueProvider = jsonObj["dimValueProvider"];
    this.watermark = jsonObj["watermark"];
    this.eventHandlerCollection = jsonObj["eventHandlerCollection"];
    this.strings = jsonObj["strings"];
    this.load(body);
  }
  getComponentMap() {
    return this.componentMap;
  }
  getComponent(key) {
    return this.componentMap.get(key);
  }
  getGridArray() {
    return this.gridArray;
  }
  getLVArray() {
    return this.lvArray;
  }
  getSubDetailCompMap() {
    return this.subDetailCompMap;
  }
  getDetailCompMap() {
    return this.detailCompMap;
  }
  hasExpandGrid() {
    return this.expandGridArray.length > 0;
  }
  load(metaBody) {
    var _a;
    if (this.type == FormType.TEMPLATE) {
      return;
    }
    var stack = new Stack();
    var items = metaBody.items, root;
    for (var i2 = 0, len = items.length; i2 < len; i2++) {
      root = (_a = items[i2]) == null ? void 0 : _a.root;
      if (root) {
        stack.push(root);
      }
    }
    while (!stack.empty()) {
      var metaComp = stack.pop();
      if (!metaComp) {
        continue;
      }
      var key = metaComp.key;
      this.componentMap.put(key, metaComp);
      var controlType = metaComp.type;
      switch (controlType) {
        case ControlType.GRID:
          if (metaComp.hasColExpand || metaComp.hasCellExpand) {
            this.expandGridArray.push(key);
          }
          this.gridArray.push(key);
          break;
        case ControlType.LISTVIEW:
          this.lvArray.push(key);
          this.detailArray.push(key);
          break;
        case ControlType.TILEDLIST:
        case ControlType.GALLERY:
        case ControlType.ROTATOR:
        case ControlType.ROTATORLIST:
        case ControlType.WATERFALL:
        case ControlType.EDITVIEW:
          this.lvArray.push(key);
          this.detailArray.push(key);
          break;
        case ControlType.COLLECTIONVIEW:
          break;
        case ControlType.TABLEVIEW:
          this.gridArray.push(key);
          break;
        case ControlType.REFRESHCONTROL:
          break;
        case ControlType.COMBOVIEW:
          break;
        case ControlType.CONTAINER:
          break;
        case ControlType.TOOLBAR:
          break;
        case ControlType.COLLAPSEPANEL:
          break;
        case ControlType.POPVIEW:
          break;
        case ControlType.SUBDETAIL:
          let self = this;
          let addSubDetailComp = function(comp) {
            comp.parentSubDetail = metaComp.key;
            self.subDetailCompMap.put(comp.key, comp);
            if (comp.items != null && comp.items.length > 0) {
              for (var i22 = 0, len2 = comp.items.length; i22 < len2; i22++) {
                addSubDetailComp(comp.items[i22]);
              }
            }
          };
          addSubDetailComp(metaComp.root);
          break;
        case ControlType.POPBUTTON:
          break;
        case ControlType.SHRINKVIEW:
          break;
        case ControlType.LISTLAYOUTVIEW:
          break;
      }
      var items = metaComp.items;
      if (items != null && items.length > 0) {
        for (var i2 = 0, len = items.length; i2 < len; i2++) {
          let item = items[i2];
          if (metaComp.type == ControlType.TABLEVIEW) {
            item.parentKey = metaComp.key;
          }
          stack.push(item);
        }
      }
    }
  }
}
let cache$e;
cache$e = new IndexedDBCache(DOC_TABLE_NAME);
if (!cache$e.support()) {
  cache$e = new LRUCache(30);
}
class DocCache extends BaseCache {
  getCache() {
    return cache$e;
  }
}
class TableMode {
}
TableMode.UNKNOWN = -1;
TableMode.HEAD = 0;
TableMode.DETAIL = 1;
class DocType {
}
DocType.NORMAL = 0;
DocType.NEW = 1;
DocType.MODIFIED = 2;
DocType.DELETE = 3;
class ExpandDataType {
}
ExpandDataType.INT = 1;
ExpandDataType.LONG = 2;
ExpandDataType.STRING = 3;
ExpandDataType.JSON_OBJECT = 7;
ExpandDataType.JSONOBJ = 10;
ExpandDataType.MAP = 14;
class YesDocument {
  constructor() {
    this.tbls = new Array();
    this.shadows = new HashMap();
    this.maps = new HashMap();
    this.oid = -1;
    this.poid = -1;
    this.verid = -1;
    this.dverid = -1;
    this.state = 0;
    this.docType = DataDef.D_Obj;
    this.expData = {};
    this.expDataType = {};
    this.expDataClass = {};
    this.mainTableKey = "";
    this.object_key = "";
    this.version = 0;
  }
  isNew() {
    return this.state == DocType.NEW;
  }
  getExpDataInfo(key) {
    return { data: this.expData[key], dataType: this.expDataType[key], dataClass: this.expDataClass[key] };
  }
  getExpData(key) {
    return this.expData[key];
  }
  putExpData(key, value) {
    this.expData[key] = value;
  }
  rmExpData(key) {
    delete this.expData[key];
    delete this.expDataType[key];
    delete this.expDataClass[key];
  }
  add(key, tbl) {
    this.tbls.push(tbl);
    this.maps.put(key, tbl);
  }
  size() {
    return this.tbls.length;
  }
  addShadow(key, tbl) {
    this.shadows.put(key, tbl);
  }
  removeShadow(key) {
    this.shadows.remove(key);
  }
  shadowKeys() {
    return this.shadows.keys();
  }
  remove(key) {
    var tbl = this.maps.get(key);
    this.maps.remove(key);
    for (var i2 = this.tbls.length - 1; i2 >= 0; --i2) {
      if (this.tbls[i2] == tbl) {
        this.tbls.splice(i2, 1);
        break;
      }
    }
  }
  get(idx) {
    return this.tbls[idx];
  }
  keys() {
    return this.maps.keys();
  }
  setByKey(key, tbl) {
    this.maps.put(key, tbl);
    for (var i2 = this.tbls.length - 1; i2 >= 0; --i2) {
      if (this.tbls[i2].key == key) {
        this.tbls.splice(i2, 1, tbl);
        break;
      }
    }
  }
  /**
   * 获取指定数据表的直接子表
   * @param parentKey
   * @returns {Array}
   */
  getByParentKey(parentKey) {
    var subTables = [], table;
    for (var i2 = 0, len = this.tbls.length; i2 < len; i2++) {
      table = this.tbls[i2];
      if (table.parentKey == parentKey) {
        subTables.push(table);
      }
    }
    return subTables;
  }
  getByParent(tbls, parentKey) {
    var tables2 = this.getByParentKey(parentKey);
    tbls.push.apply(tbls, tables2);
    for (var i2 = 0, size2 = tables2.length; i2 < size2; i2++) {
      this.getByParent(tbls, tables2[i2].key);
    }
  }
  /**
   * 获取指定数据表的所有子表
   * @param parentKey
   * @returns {Array}
   */
  getTblsByParentKey(parentKey) {
    var tbls = [];
    this.getByParent(tbls, parentKey);
    return tbls;
  }
  // FIXME 什么逻辑？
  getByKey(key, original) {
    const table = this.maps.get(key);
    if (!table) {
      return table;
    }
    if (original) {
      return table;
    }
    return table.expanddatatable || table;
  }
  getShadow(key) {
    return this.shadows.get(key);
  }
  clear() {
    this.tbls.length = 0;
    this.maps.clear();
    this.shadows.clear();
  }
  setDocType(type) {
    this.docType = type;
  }
  setModified() {
    this.state = DocType.MODIFIED;
  }
  batchUpdate() {
    for (var i2 = 0, l = this.tbls.length; i2 < l; ++i2) {
      var t = this.tbls[i2];
      t.batchUpdate();
    }
  }
  setNew() {
    this.state = DocType.NEW;
  }
  getHeadValue(key) {
    const headValues = this.getHeadValues();
    return headValues[key];
  }
  setHeadValue(key, value) {
    const headValues = this.getHeadValues();
    headValues[key] = value;
    this.setHeadValues(headValues);
  }
  setHeadValues(headValues) {
    this.headValues = headValues || {};
    this.setExpData("headValues", this.headValues, ExpandDataType.MAP || 14);
  }
  getHeadValues() {
    return this.headValues || {};
  }
  getOtherFieldValue(key) {
    const otherFieldValues = this.getOtherFieldValues();
    return otherFieldValues[key];
  }
  deleteOtherFieldValue(key) {
    const otherFieldValues = this.getOtherFieldValues();
    delete otherFieldValues[key];
    this.setOtherFieldValues(otherFieldValues);
  }
  setOtherFieldValue(key, value) {
    const otherFieldValues = this.getOtherFieldValues();
    otherFieldValues[key] = value;
    this.setOtherFieldValues(otherFieldValues);
  }
  setOtherFieldValues(otherFieldValues) {
    this.otherFieldValues = otherFieldValues || {};
    this.setExpData("otherFieldValues", this.otherFieldValues, ExpandDataType.MAP || 14);
  }
  getOtherFieldValues() {
    return this.otherFieldValues || {};
  }
  setTableFilters(tableFilters) {
    this.tableFilters = tableFilters || {};
    this.setExpData("tableFilter", this.tableFilters, ExpandDataType.MAP || 14);
  }
  getTableFilters() {
    return this.tableFilters || {};
  }
  setEmptyGridRowValues(emptyGridRowValues) {
    this.emptyGridRowValues = emptyGridRowValues || {};
    this.setExpData("emptyGridRowValues", this.emptyGridRowValues, ExpandDataType.MAP || 14);
  }
  getEmptyGridRowValues() {
    return this.emptyGridRowValues || {};
  }
  getGridEmptyGridRowValues(gridKey) {
    const emptyGridRowValues = this.getEmptyGridRowValues();
    return emptyGridRowValues[gridKey] || null;
  }
  deleteGridEmptyRowValues(gridKey) {
    const emptyGridRowValues = this.getEmptyGridRowValues();
    delete emptyGridRowValues[gridKey];
    this.setEmptyGridRowValues(emptyGridRowValues);
  }
  setGridEmptyRowValues(gridKey, value) {
    const emptyGridRowValues = this.getEmptyGridRowValues();
    emptyGridRowValues[gridKey] = value;
    this.setEmptyGridRowValues(emptyGridRowValues);
  }
  setGridEmptyRowFieldValue(gridKey, key, value) {
    const emptyGridRowValues = this.getEmptyGridRowValues();
    const gridEmptyGridRowValues = emptyGridRowValues[gridKey] || {};
    gridEmptyGridRowValues[key] = value;
    this.setGridEmptyRowValues(gridKey, gridEmptyGridRowValues);
  }
  setForm_OperationState(form_OperationState) {
    this.form_OperationState = form_OperationState;
    this.setExpData("form_OperationState", this.form_OperationState, ExpandDataType.INT);
  }
  getForm_OperationState() {
    return this.form_OperationState;
  }
  setDataIsFromTemporary(dataIsFromTemporary) {
    this.dataIsFromTemporary = dataIsFromTemporary;
    this.setExpData("dataIsFromTemporary", this.dataIsFromTemporary ? 1 : 0, ExpandDataType.INT);
  }
  getDataIsFromTemporary() {
    return this.dataIsFromTemporary;
  }
  setGridSettingVariants(gridSettingVariants) {
    this.gridSettingVariants = gridSettingVariants;
    this.setExpData("gridSettingVariants", this.gridSettingVariants, ExpandDataType.MAP || 14);
  }
  getGridSettingVariants() {
    return this.gridSettingVariants || {};
  }
  mergeExtraProp(doc) {
    if (doc) {
      const headValues = this.getHeadValues() || doc.getHeadValues();
      const otherFieldValues = this.getOtherFieldValues() || doc.getOtherFieldValues();
      const emptyGridRowValues = this.getEmptyGridRowValues() || doc.getEmptyGridRowValues();
      const tableFilter = this.getTableFilters() || doc.getTableFilters();
      const form_OperationState = this.getForm_OperationState() || doc.getForm_OperationState();
      this.setHeadValues(headValues);
      this.setOtherFieldValues(otherFieldValues);
      this.setEmptyGridRowValues(emptyGridRowValues);
      this.setTableFilters(tableFilter);
      this.setForm_OperationState(form_OperationState);
      this.setShadowTables(doc);
    }
    const dataIsFromTemporary = this.getDataIsFromTemporary() || false;
    this.setDataIsFromTemporary(dataIsFromTemporary);
  }
  setShadowTables(doc) {
    if (!this.shadows.empty()) {
      return;
    }
    let keys = doc.shadowKeys();
    if (keys.length == 0) {
      return;
    }
    for (let i2 = 0, tableKey; tableKey = keys[i2]; i2++) {
      let table = this.getByKey(tableKey);
      let shadow = DataUtil$1.newShadowDataTable(table);
      let index = table.indexByKey(SystemField.SELECT_FIELD_KEY);
      if (index >= 0) {
        for (let k = 0; k < table.size(); k++) {
          let sValue = table.getObject(k, index);
          if (sValue) {
            let rowIndex = shadow.addRow();
            for (let m = 0; m < table.getColumnCount(); m++) {
              shadow.setObject(rowIndex, m, table.getObject(k, m));
            }
          }
        }
      }
      this.addShadow(tableKey, shadow);
    }
  }
  setExpData(key, value, expDataType) {
    {
      return;
    }
  }
  // clone() {
  //     // @ts-ignore
  //     const newDoc = <YesDocumentExt>this.base.clone();
  //     const headValues = Object.assign({}, this.getHeadValues());
  //     const otherFieldValues = Object.assign({}, this.getOtherFieldValues());
  //     const tableFilter = Object.assign({}, this.getTableFilters());
  //     newDoc.setHeadValues(headValues);
  //     newDoc.setOtherFieldValues(otherFieldValues);
  //     newDoc.setTableFilters(tableFilter);
  //     return newDoc;
  // }
  clone() {
    var newDoc = new YesDocument();
    newDoc.oid = this.oid;
    newDoc.poid = this.poid;
    newDoc.verid = this.verid;
    newDoc.dverid = this.dverid;
    newDoc.state = this.state;
    newDoc.docType = this.docType;
    newDoc.mainTableKey = this.mainTableKey;
    newDoc.tbls = [];
    newDoc.maps = new HashMap();
    for (var i2 = 0, table, len = this.tbls.length; i2 < len; i2++) {
      table = this.tbls[i2].clone();
      newDoc.tbls.push(table);
      newDoc.maps.put(table.key, table);
    }
    newDoc.expData = Object.assign({}, this.expData);
    newDoc.expDataType = Object.assign({}, this.expDataType);
    newDoc.expDataClass = Object.assign({}, this.expDataClass);
    const headValues = Object.assign({}, this.getHeadValues());
    const otherFieldValues = Object.assign({}, this.getOtherFieldValues());
    const tableFilter = Object.assign({}, this.getTableFilters());
    newDoc.setHeadValues(headValues);
    newDoc.setOtherFieldValues(otherFieldValues);
    newDoc.setTableFilters(tableFilter);
    return newDoc;
  }
}
const dataType2JavaDataType = (dataType) => {
  switch (dataType) {
    case DataType.LONG:
      return JavaDataType.USER_LONG;
    case DataType.BINARY:
      return JavaDataType.USER_BINARY;
    case DataType.BOOLEAN:
      return JavaDataType.USER_BOOLEAN;
    case DataType.DATE:
    case DataType.DATETIME:
      return JavaDataType.USER_DATETIME;
    case DataType.DOUBLE:
    case DataType.FLOAT:
    case DataType.NUMERIC:
      return JavaDataType.USER_NUMERIC;
    case DataType.INT:
      return JavaDataType.USER_INT;
    case DataType.STRING:
    case DataType.TEXT:
    case DataType.FIXED_STRING:
      return JavaDataType.USER_STRING;
  }
  return -1;
};
const newEmptyDataTable = (metaTable) => {
  if (!metaTable)
    return null;
  var dataTable = new DataTable();
  dataTable.key = metaTable.key;
  dataTable.tableMode = metaTable.tableMode;
  dataTable.persist = metaTable.persist;
  dataTable.parentKey = metaTable.parentKey;
  var columns = metaTable.columns;
  for (var i2 = 0, len = columns.length; i2 < len; i2++) {
    var column = columns[i2];
    if (column.supportI18n) {
      continue;
    }
    var type = column.type;
    var javaType = dataType2JavaDataType(type);
    dataTable.addCol({
      key: column.key,
      type,
      userType: javaType,
      accessControl: column.accessControl,
      defaultValue: column.defaultValue,
      defaultFormulaValue: column.defaultFormulaValue,
      isPrimary: column.isPrimary,
      checkLength: column.checkLength,
      scale: column.scale,
      codeColumnKey: column.codeColumnKey,
      length: column.length
    });
  }
  return dataTable;
};
const toMergeDataTable = (dataTable, oldDataTable) => {
  dataTable.key = oldDataTable.key;
  dataTable.parentKey = oldDataTable.parentKey;
  dataTable.tableMode = oldDataTable.tableMode;
  dataTable.isPersist = oldDataTable.isPersist;
  var docTable = oldDataTable, allDataRows = docTable.allRows, columns = docTable.cols;
  var dataRow, len, row, col, cIdx;
  for (var i2 = 0; i2 < allDataRows.length; i2++) {
    dataRow = allDataRows[i2];
    len = dataRow.vals.length;
    if (dataTable.tableMode == TableMode.HEAD) {
      row = dataTable.allRows[0];
    } else {
      row = new Row();
    }
    for (var k = 0; k < len; k++) {
      col = columns[k];
      cIdx = dataTable.indexByKey(col.key, true);
      row.vals[cIdx] = dataRow.vals[k];
      if (dataRow.orgVals) {
        row.orgVals = row.orgVals || [];
        row.orgVals[cIdx] = dataRow.orgVals[k];
      }
    }
    row.state = dataRow.state;
    row.bkmk = dataRow.bkmk;
    row.parentBkmk = dataRow.parentBkmk;
    if (dataTable.tableMode != TableMode.HEAD) {
      dataTable.allRows.push(row);
      if (row.state != DataDef.R_Deleted) {
        dataTable.rows.push(row);
      }
    }
  }
  dataTable.pos = docTable.pos;
  dataTable.bkmkSeed = docTable.bkmkSeed;
  dataTable.tableMode = docTable.tableMode;
  dataTable.showDelete = docTable.showDelete;
  dataTable.isPersist = docTable.isPersist;
  dataTable.bkmks = docTable.bkmks;
  dataTable.filterEval = docTable.filterEval;
  return dataTable;
};
class DocumentUtil {
  static newDocument(metaDataObject) {
    if (!metaDataObject)
      return null;
    var doc = new YesDocument();
    doc.object_key = metaDataObject.key;
    doc.mainTableKey = metaDataObject.primaryTableKey;
    var metaTables = metaDataObject.tables;
    for (var i2 = 0, len = metaTables.length; i2 < len; i2++) {
      var metaTable = metaTables[i2];
      var tableKey = metaTable.key;
      var dataTable = newEmptyDataTable(metaTable);
      if (dataTable) {
        if (metaTable.tableMode == TableMode.HEAD) {
          dataTable.addRow(true);
        }
      }
      doc.add(tableKey, dataTable);
    }
    return doc;
  }
  static toMergeDoc(newDoc, oldDoc) {
    if (!oldDoc) {
      return newDoc;
    }
    var tbls = newDoc.tbls, oldTable;
    for (var i2 = 0, table, len = tbls.length; i2 < len; i2++) {
      table = tbls[i2];
      oldTable = oldDoc.getByKey(table.key);
      if (oldTable) {
        toMergeDataTable(table, oldTable);
        newDoc.maps.put(table.key, table);
      }
    }
    newDoc.oid = oldDoc.oid;
    newDoc.poid = oldDoc.poid;
    newDoc.verid = oldDoc.verid;
    newDoc.dverid = oldDoc.dverid;
    newDoc.state = oldDoc.state;
    newDoc.docType = oldDoc.docType;
    newDoc.expData = Object.assign({}, oldDoc.expData);
    newDoc.expDataType = Object.assign({}, oldDoc.expDataType);
    newDoc.expDataClass = Object.assign({}, oldDoc.expDataClass);
  }
}
class RowCountUtil {
  static getRowCountKey(tableKey) {
    return tableKey + "_RowCount";
  }
  static getTotalRowCountKey(tableKey) {
    return tableKey + "_TotalRowCount";
  }
  static getStartRowCountKey(tableKey) {
    return tableKey + "_StartRowCount";
  }
  static getRowCount(doc, tableKey) {
    return TypeConvertor.toInt(doc.getExpData(RowCountUtil.getRowCountKey(tableKey)));
  }
  static getStartRowCount(doc, tableKey) {
    return TypeConvertor.toInt(doc.getExpData(RowCountUtil.getStartRowCountKey(tableKey)));
  }
  static getTotalRowCount(doc, tableKey) {
    var data2 = doc.getExpData(RowCountUtil.getTotalRowCountKey(tableKey));
    return data2 != void 0 ? TypeConvertor.toInt(data2) : -1;
  }
  static setRowCount(doc, tableKey, rowCount) {
    var key = RowCountUtil.getRowCountKey(tableKey);
    doc.putExpData(key, rowCount);
    doc.expDataType[key] = ExpandDataType.LONG;
  }
  static setStartRowCount(doc, tableKey, rowCount) {
    var key = RowCountUtil.getStartRowCountKey(tableKey);
    doc.putExpData(key, rowCount);
    doc.expDataType[key] = ExpandDataType.LONG;
  }
  static setTotalRowCount(doc, tableKey, rowCount) {
    var key = RowCountUtil.getTotalRowCountKey(tableKey);
    doc.putExpData(key, rowCount);
    doc.expDataType[key] = ExpandDataType.LONG;
  }
  static rmTotalRowCount(doc, tableKey) {
    var key = RowCountUtil.getTotalRowCountKey(tableKey);
    doc.rmExpData(key, key);
  }
}
const docCache$2 = new DocCache();
const BATCH_DELETE_DATA = "BatchDeleteData";
const BATCH_INPUT_GRID_DATA = "BatchInputGridData";
const DELETE_FORM_DATA = "DeleteFormData";
const _DocService = class _DocService2 {
  constructor(form) {
    this.form = form;
    this.request = new Request$1(form);
    if (form) {
      var appEnv = form.getAppEnv();
      if (appEnv) {
        this.appKey = appEnv.getAppKey();
      }
    }
  }
  /**
    * 创建一个doc，头表新增一行。
    */
  newDocument(dataObject) {
    try {
      var doc = DocumentUtil.newDocument(dataObject);
      return doc;
    } catch (e) {
      console.error("newDocument error ......" + e);
      throw e;
    }
  }
  async newDefaultDocument(form) {
    const formKey = form.getFormKey();
    if (form) {
      const appEnv = form.getAppEnv();
      if (appEnv) {
        appEnv.getAppKey();
      }
    }
    let entryParas = form.entryParas;
    if (form.pFormID) {
      const pForm = FormStack.getForm(form.pFormID);
      entryParas = pForm ? entryParas + pForm.entryParas : entryParas;
    }
    let version = form.getDataObjectVersion();
    if (Utils.isUndefined(version)) {
      version = await new MetaService(form).getDataObjectVersionByFormKey(formKey);
      form.setDataObjectVersion(version);
    }
    {
      let data2 = await new RichDocService(form).newDefaultDocument();
      this.setActivity(form);
      if (!data2) {
        data2 = {};
      }
      if (data2.expand_data && data2.expand_data.advancedqueryvalue) {
        let parse = JSON.parse(data2.expand_data.advancedqueryvalue);
        const json = {};
        var advancedQueryValueCache = new LRUCache(30);
        if (!form.advancedQueryValueCache) {
          form.advancedQueryValueCache = advancedQueryValueCache;
        } else {
          advancedQueryValueCache = form.advancedQueryValueCache;
        }
        for (let parseKey in parse) {
          let parseElement = parse[parseKey];
          let component = form.getComponent(parseKey);
          var componentitemKey = "";
          if (component.itemKey) {
            componentitemKey = component.itemKey;
          }
          if (!parseElement.isUse) {
            component.advancedQueryJsonValue = void 0;
            continue;
          }
          let parse1 = JSON.parse(parseElement.fieldObjects);
          component.advancedQueryJsonValue = parse1;
          if (component.condition) {
            component.condition.useAdvancedQuery = JSON.stringify(parseElement);
          }
          if (parse1.zh) {
            json[parseKey] = parse1.zh;
            advancedQueryValueCache.put("GetQueryValue_" + form.formKey + "_" + parseKey, json[parseKey]);
          }
          if (parse1.document) {
            docCache$2.put("GetMultipleOptions_" + form.formKey + "_" + parseKey + componentitemKey + form.entryPath, parse1.document);
          }
        }
        advancedQueryValueCache.put("GetQueryValue_" + form.formKey + "_", json);
      }
      let ret = _DocService2.entryParasCache.get(formKey);
      if (ret == null) {
        ret = [entryParas];
        _DocService2.entryParasCache.set(formKey, ret);
      } else {
        ret.push(entryParas);
      }
      data2 = DataUtil$1.fromJSONDoc(data2);
      return data2;
    }
  }
  setActivity(form) {
    let formActivity = form.Activity;
    if (!formActivity) {
      let formInitState = form.getOperationState() != -1 ? form.getOperationState() : form.metaForm.initState;
      if (formInitState == OperationState.NEW) {
        form.Activity = "01";
      } else if (formInitState == OperationState.EDIT) {
        form.Activity = "02";
      } else if (formInitState == OperationState.DEFAULT) {
        form.Activity = "03";
      }
    }
  }
  async newRichDocument(form) {
    return await new RichDocService(form).newRichDocument();
  }
  // async loadFormData(form,filterMap?) {
  //     if (!form) {
  //         throw new Error(I18N.getString("DOCSERVICEPROXY_NOFORMDEFINED", "form 不能为空"));
  //     }
  //     await form.refreshParas();
  //     var parameters = form.getParas();
  //     var filterMap = filterMap || form.getFilterMap();
  //     var condParas = form.getCondParas();
  //     var templateKey = form.getTemplateKey();
  //     var params: any = {
  //         cmd: "",
  //         service: "LoadFormData",
  //         oid: filterMap.OID,
  //         formKey: form.getFormKey()
  //     };
  //     if (parameters) {
  //         params.parameters = parameters.toJSON();
  //     }
  //     if (filterMap) {
  //         params.filterMap = JSON.stringify(filterMap);
  //     }
  //     if (condParas) {
  //         params.condition = JSON.stringify(condParas);
  //     }
  //     if (templateKey) {
  //         params.templateKey = templateKey;
  //     }
  //     var _loadInfo = form.getSysExpVals(BPMKeys.LOAD_WORKITEM_INFO);
  //     if (_loadInfo != undefined) {
  //         params.loadWorkItemInfo = _loadInfo;
  //     }
  //     return this.request.getData(params).then(doc => {
  //         if (form.metaForm.dataObject.version != doc.version) {
  //             throw new Error(" version is error, refresh.");
  //         }
  //         return doc;
  //     });
  // }
  async loadFormData(form, oid = null, filterMap = null, condParas = null) {
    if (!form) {
      throw new Error(I18N.getString("form 不能为空", "form 不能为空"));
    }
    await form.refreshParas();
    oid = oid == null ? form.getOID() : oid;
    const data2 = await new RichDocService(form).richDocumentLoadFormData(filterMap, condParas);
    let doc;
    const formDirtyDatas = data2.formDirtyDatas;
    for (let i2 = 0; formDirtyDatas && i2 < formDirtyDatas.length; i2++) {
      const dirtyData = formDirtyDatas[i2].dirtyData;
      if (dirtyData.isFullData) {
        doc = DataUtil$1.fromJSONDoc(dirtyData.documentJson);
        const uiRawCache = dirtyData.UIAttrCache;
        if (uiRawCache) {
          FormUICache$1.merge(form, uiRawCache);
        }
        break;
      }
    }
    if (!doc) {
      doc = DataUtil$1.fromJSONDoc(data2);
    }
    if (form.metaForm.dataObject.version != doc.version) {
      throw new Error(" version is error, refresh.");
    }
    const d = form.getDocument();
    if (d) {
      const keys = d.keys();
      for (let i2 = 0, key; key = keys[i2]; i2++) {
        const totalCount = RowCountUtil.getTotalRowCount(doc, key);
        if (totalCount > 0) {
          RowCountUtil.setTotalRowCount(d, key, totalCount);
        }
      }
    }
    return doc;
  }
  // see remoteService.deletebyform
  async deleteFormData(form, oid, sysTopic, verid) {
    await form.refreshParas();
    var paras = form.getParas();
    var params = {
      cmd: DELETE_FORM_DATA,
      service: ServiceName.DELETE_DATA,
      parameters: paras.toJSON(),
      formKey: form.getFormKey(),
      oid,
      verid,
      sysTopic
    };
    return this.request.getData(params);
  }
  batchDeleteData(objectKey, OIDList, sysTopic) {
    var params = {
      service: ServiceName.DELETE_DATA,
      cmd: BATCH_DELETE_DATA,
      dataObjectKey: objectKey,
      OIDListStr: JSON.stringify(OIDList),
      sysTopic
    };
    return this.request.getData(params);
  }
  async saveFormData(form, sysTopic) {
    await form.refreshParas();
    var paras = form.getParas(), formDoc2 = form.getDocument();
    formDoc2 = DataUtil$1.toJSONDoc(formDoc2, true);
    var params = {
      service: ServiceName.SAVE_FORM_DATA,
      parameters: paras.toJSON(),
      document: JSON.stringify(formDoc2),
      formKey: form.getFormKey(),
      sysTopic
    };
    return this.request.getData(params);
  }
  copyNew(form) {
    var formDoc2 = form.getDocument();
    var docJson = DataUtil$1.toJSONDoc(formDoc2);
    var params = {
      formKey: form.getFormKey(),
      service: ServiceName.COPY_NEW,
      document: JSON.stringify(docJson)
    };
    return this.request.getData(params);
  }
  loadData(objectKey, oid, filterMap, condParas, paras) {
    var params = {
      cmd: "",
      service: ServiceName.LOAD_DATA,
      OID: oid,
      dataObjectKey: objectKey
    };
    if (paras) {
      params.parameters = paras.toJSON();
    }
    if (filterMap) {
      params.filterMap = JSON.stringify(filterMap);
    }
    if (condParas) {
      params.condition = JSON.stringify(condParas);
    }
    return this.request.getData(params);
  }
  async reloadMetaForm(metaFormKeys) {
    const formKeys = metaFormKeys.split(",");
    for (let i2 = formKeys.length - 1; i2 >= 0; i2--) {
      this.removeCache(formKeys[i2]);
    }
    return new RichDocService(this.form).reloadForm(metaFormKeys);
  }
  async removeCache(formKey) {
    if (!formKey) {
      return;
    }
    const ret = await _DocService2.entryParasCache.get(formKey);
    const cacheKeys = [];
    if (ret != null) {
      for (let i2 = ret.length - 1; i2 >= 0; i2--) {
        const cacheKey = formKey + (ret[i2] ? "_" + ret[i2] : "");
        cacheKeys.push(cacheKey);
      }
    } else {
      cacheKeys.push(formKey);
    }
    for (let i2 = cacheKeys.length - 1; i2 >= 0; i2--) {
      const cacheKey = cacheKeys[i2];
      _DocService2.entryParasCache.del(formKey);
      delete _DocService2.reqMap[cacheKey];
    }
  }
  async batchInputGridData(form, gridKey, oids, columnInfo, values) {
    const thisForm = this.form;
    const request2 = this.request;
    const doc = DataUtil$1.toJSONDoc(thisForm.getDocument());
    var filter;
    const paras = {
      service: ServiceName.RICH_DOCUMENT,
      cmd: BATCH_INPUT_GRID_DATA,
      metaFormKey: thisForm.formKey,
      document: JSON.stringify(doc),
      gridKey,
      oids,
      columnInfo: JSON.stringify(columnInfo),
      values
    };
    if (form.getFormKey().endsWith("V_AdvancedQuery")) {
      const pForm = FormStack.getForm(form.pFormID);
      if (pForm != null) {
        var component = pForm.getComponent(form.AdvancedQueriesFieldKey);
        if (component.type == 206) {
          var cxt = new ViewContext(form);
          var filter = await DictHandler.getDictFilter(pForm, component.getMetaObj(), component.itemKey, component.typeDefKey, cxt);
          form.setPara("metaFilters", filter);
          paras.advancedQueryItemKey = component.itemKey;
        }
        paras.advancedQueryControlKey = form.AdvancedQueriesFieldKey;
        paras.advancedQuerypFormKey = pForm.formKey;
        const parentFormKey = pForm.formKey;
        const parentDoc = DataUtil$1.toJSONDoc(pForm.getDocument());
        paras.parentFormKey = parentFormKey;
        paras.parentDocument = JSON.stringify(parentDoc);
        paras.parentEntryPath = pForm.entryPath;
        if (pForm.getParas()) {
          paras.parentParameters = pForm.getParas().toJSON();
        }
      }
    }
    const bookmarks = UIScopeTrees.getJsonBookmarks(thisForm);
    paras.bkmks = bookmarks;
    const parameters = form.getParas();
    if (parameters) {
      paras.parameters = parameters.toJSON();
    }
    const parentForm = form.getParentForm();
    if (parentForm) {
      const formulaScopes = await form.getFormulaScope();
      const scopeKey = ".GridKey." + gridKey;
      const scope = formulaScopes[scopeKey];
      if (scope && scope.includeParentDocument == true) {
        const parentDoc = DataUtil$1.toJSONDoc(parentForm.getDocument());
        const parentFormKey = parentForm.formKey;
        if (parentForm.getParas()) {
          paras.parentParameters = parentForm.getParas().toJSON();
        }
        paras.parentBkmks = UIScopeTrees.getJsonBookmarks(parentForm);
        paras.parentFormKey = parentFormKey;
        paras.parentDocument = JSON.stringify(parentDoc);
      }
    }
    return await request2.getData(paras);
  }
  async saveI18NInfo(form) {
    await form.refreshParas();
    var paras = form.getParas(), formDoc2 = form.getDocument();
    formDoc2 = DataUtil$1.toJSONDoc(formDoc2, true);
    var params = {
      service: ServiceName.I18NINFO,
      cmd: "SaveI18NInfo",
      parameters: paras.toJSON(),
      document: JSON.stringify(formDoc2),
      formKey: form.getFormKey()
    };
    return this.request.getData(params);
  }
};
_DocService.entryParasCache = new LRUCache(30);
_DocService.reqMap = {};
let DocService = _DocService;
class BPMConstants {
}
BPMConstants.WORKITEM_VIEW = "WorkitemView";
BPMConstants.WORKITEM_INFO = "WorkitemInfo";
BPMConstants.BPM_INSTANCE_ID = "InstanceID";
BPMConstants.ELEMENT_STATE = "State";
BPMConstants.BPM_PROCESS_KEY = "ProcessKey";
BPMConstants.BPM_STARTCAPTION = "StartCaption";
BPMConstants.BPM_STARTACTION = "StartAction";
BPMConstants.BPM_TRANSIT_TO = "TransitTo";
class FormEvent {
}
FormEvent.CLOSE = "Close";
FormEvent.SHOWDOCUMENT = "ShowDocument";
class FormUIStatusMask {
}
FormUIStatusMask.ENABLE = 1;
FormUIStatusMask.VISIBLE = 2;
FormUIStatusMask.OPERATION = 4;
FormUIStatusMask.CHECKRULE = 8;
const getInsertPos = (grid, idx) => {
  if (!grid.hasFixRow && !grid.hasTotalRow) {
    return idx;
  }
  if (idx < 0) {
    for (var size2 = grid.getRowCount(), i2 = size2 - 1; i2 >= 0; --i2) {
      if (grid.getRowDataAt(i2).rowType == RowType.STR_DETAIL) {
        return i2 == size2 - 1 ? -1 : i2 + 1;
      }
    }
  } else {
    for (var size2 = grid.getRowCount(), i2 = 0; i2 < size2; i2++) {
      if (grid.getRowDataAt(i2).rowType == RowType.STR_DETAIL) {
        return i2;
      }
    }
  }
  return grid.getMetaObj().rowLayer.areaIndex;
};
const updateTable = function(src, tgt) {
  var colInfo, value;
  for (var i2 = 0, size2 = tgt.cols.length; i2 < size2; i2++) {
    colInfo = tgt.getCol(i2);
    var index = src.indexByKey(colInfo.key);
    if (index != null) {
      value = src.getByKey(colInfo.key);
      tgt.setByKey(colInfo.key, value == void 0 ? null : value);
    }
  }
};
const updateGrid = async (form, grid, idx) => {
  var viewForm = FormStack.getForm(form.pFormID);
  if (!viewForm)
    return;
  var doc = form.getDocument();
  var row = -1, colKey, metaCell;
  metaCell = viewForm.getCellByDataBinding(grid.tableKey, SystemField.OID_SYS_KEY);
  if (metaCell) {
    colKey = metaCell.key;
  }
  if (!colKey)
    return;
  var rowCount = grid.getRowCount();
  for (var i2 = 0; i2 < rowCount; i2++) {
    if (grid.getValueByKey(i2, colKey) == doc.oid) {
      row = i2;
      break;
    }
  }
  if (form.getOperationState() == OperationState.DELETE) {
    if (row != -1) {
      await grid.deleteRow(row, true);
      grid.refreshSelectAll();
    }
  } else {
    var viewDoc = viewForm.getDocument(), tableKey = grid.tableKey, table = doc.getByKey(tableKey), viewTable = viewDoc.getByKey(tableKey);
    table.first();
    if (row == -1) {
      viewTable.addRow(true);
      let bkmkRow = new DetailRowBkmk(viewTable.getBkmk());
      row = await grid.insertRow(getInsertPos(grid, idx), true);
      let rowData2 = grid.getRowDataAt(row);
      rowData2.bkmkRow = bkmkRow;
    }
    var rowData = grid.getRowDataAt(row);
    viewTable.setByBkmk(rowData.bkmkRow.getBookmark());
    updateTable(table, viewTable);
    viewTable.setState(DataDef.R_Normal);
    grid.getHandler().showRowData(viewForm, grid, row, rowData.meta, false);
    await viewForm.getUIProcess().doCalcOneRow(grid, row);
    await viewForm.getStyleProcess().doCalcOneRow(grid, row);
    grid.refreshSelectAll();
  }
};
const updateListView = async (form, listView, idx) => {
  var viewForm = FormStack.getForm(form.pFormID);
  if (!viewForm)
    return;
  var doc = form.getDocument();
  var row = -1, colKey, column;
  column = viewForm.getLvColumnByDataBinding(listView.tableKey, SystemField.OID_SYS_KEY);
  if (column) {
    colKey = column.key;
  }
  if (!colKey)
    return;
  var rowCount = listView.getRowCount();
  for (var i2 = 0; i2 < rowCount; i2++) {
    if (listView.getValByKey(i2, colKey) == doc.oid) {
      row = i2;
      break;
    }
  }
  var viewDoc = viewForm.getDocument(), tableKey = listView.tableKey, table = doc.getByKey(tableKey), viewTable = viewDoc.getByKey(tableKey);
  table.first();
  if (form.getOperationState() == OperationState.DELETE) {
    if (row != -1) {
      await listView.deleteRow(row);
      listView.refreshSelectAll();
    }
  } else {
    if (row == -1) {
      viewTable.addRow(true);
      var bkmkRow = new DetailRowBkmk(viewTable.getBkmk());
      row = await listView.insertRow(idx, bkmkRow, true);
    }
    var rowData = listView.getRowDataAt(row);
    viewTable.setByBkmk(rowData.bkmkRow.getBookmark());
    updateTable(table, viewTable);
    viewTable.setState(DataDef.R_Normal);
    listView.handler.showDetailRow(viewForm, listView, row);
    await viewForm.getUIProcess().doCalcOneRow(listView, row);
    await viewForm.getStyleProcess().doCalcOneRow(listView, row);
    listView.refreshSelectAll();
  }
};
class ViewUtil {
  // 寻找影子表行
  static findShadowBkmk(doc, tableKey) {
    var sdt = doc.getShadow(tableKey);
    if (!sdt) {
      return -1;
    }
    let bookmark = -1, oid, multiKey, indexes = [], types = [];
    let dt = doc.getByKey(tableKey);
    let OIDIndex = sdt.indexByKey(SystemField.OID_SYS_KEY);
    if (OIDIndex != null && OIDIndex > -1) {
      oid = dt.get(OIDIndex);
    } else {
      let primaryKeys = DataUtil$1.getPrimaryKeys(dt);
      if (primaryKeys.length == 0) {
        throw DATAROW_NO_PRIMARYKEYS(tableKey);
      }
      DataUtil$1.getIndexesAndTypes(dt, primaryKeys, indexes, types);
      multiKey = DataUtil$1.makeMultiKey(dt, indexes, types);
    }
    sdt.beforeFirst();
    while (sdt.next()) {
      if (dt.getState() != DataDef.R_New) {
        if (OIDIndex != null && OIDIndex > -1) {
          if (oid == sdt.get(OIDIndex)) {
            bookmark = sdt.getBkmk();
          }
        } else {
          if (multiKey.equals(DataUtil$1.makeMultiKey(sdt, indexes, types))) {
            bookmark = sdt.getBkmk();
          }
        }
      } else {
        if (sdt.getParentBkmk() == dt.getBkmk()) {
          bookmark = sdt.getBkmk();
        }
      }
      if (bookmark != -1) {
        break;
      }
    }
    return bookmark;
  }
  // 向影子表中增加一行,如果是新增行,记录parentbookmark
  static addShadowRow(table, shadowTable) {
    shadowTable.addRow();
    for (var j = 0, clen = shadowTable.cols.length; j < clen; j++) {
      shadowTable.set(j, table.get(j));
    }
    shadowTable.setState(DataDef.D_Normal);
    if (table.getState() == DataDef.R_New) {
      shadowTable.setParentBkmk(table.getBkmk());
    }
    return shadowTable.getBkmk();
  }
  // 合并影子表数据到当前行,不新增行
  static mergeShadowRow(tgtTable, shadowTable) {
    for (var k = 0, clen = tgtTable.cols.length; k < clen; k++) {
      tgtTable.set(k, shadowTable.get(k));
    }
  }
  // 重新载入一张数据表
  static async reloadTable(form, tableKey, sourceKey) {
    let filterMap = form.getFilterMap();
    let json = JSON.stringify(filterMap);
    let cloneMap = new FilterMap();
    cloneMap.fromJSON(JSON.parse(json));
    cloneMap.setType(DocumentType.DETAIL);
    cloneMap.setNeedDocInfo(false);
    cloneMap.retain(tableKey);
    let filterDetail = cloneMap.getTblFilter(tableKey);
    filterDetail.reset();
    if (sourceKey) {
      filterDetail.setSourceKey(sourceKey);
    }
    let doc = await new DocService(form).loadFormData(form, form.getOID(), cloneMap);
    let document2 = form.getDocument();
    if (doc && document2) {
      let newExpData = doc.expData;
      if (newExpData) {
        let oldExpData = document2.expData;
        if (oldExpData) {
          for (let expDataKey in newExpData) {
            let newDataValue = newExpData[expDataKey];
            let oldDataValue = oldExpData[expDataKey];
            if (oldDataValue) {
              for (let dataKey in newDataValue) {
                oldDataValue[dataKey] = newDataValue[dataKey];
              }
            } else {
              oldExpData[expDataKey] = newDataValue;
            }
          }
        } else {
          document2.expData = newExpData;
        }
      }
    }
    return doc == null ? void 0 : doc.getByKey(tableKey);
  }
  // 检查一个头控件是否访问控制
  static checkComAccessControl(form, com) {
    if (!com.getMetaObj().accessControl)
      return true;
    var table = form.getDocument().getByKey(com.tableKey);
    var val = -1;
    if (table.first()) {
      val = TypeConvertor.toInt(table.getByKey(com.columnKey + "_CF"));
    }
    return (val & FormUIStatusMask.ENABLE) != 0 ? false : true;
  }
  // 检查一个单元格是否访问控制
  static checkCellAccessControl(form, grid, ri, key) {
    var rowData = grid.getRowDataAt(ri);
    var loc = form.getCellLocation(key);
    if (loc.expand || !rowData || !rowData.bkmkRow) {
      return true;
    }
    var metaCell = grid.getCellEditOpt(ri, loc.column);
    if (!metaCell || !metaCell.accessControl)
      return true;
    var table = form.getDocument().getByKey(metaCell.tableKey);
    if (table.tableMode == TableMode.HEAD) {
      table.first();
    } else {
      table.setByBkmk(rowData.bkmkRow.getBookmark());
    }
    var val = TypeConvertor.toInt(table.getByKey(metaCell.columnKey + "_CF"));
    return (val & FormUIStatusMask.ENABLE) != 0 ? false : true;
  }
  // idx : 插行的位置
  static updateView(form, idx) {
    var tag = form.getSysExpVals(BPMConstants.WORKITEM_VIEW);
    if (tag == BPMConstants.WORKITEM_VIEW) {
      return;
    }
    var pFormID = form.pFormID;
    if (!pFormID) {
      return;
    }
    var viewForm = FormStack.getForm(pFormID);
    if (!viewForm || viewForm.type != FormType.VIEW) {
      return;
    }
    if (form.getDataObjectKey() != viewForm.getDataObjectKey()) {
      return;
    }
    var mTblKey = viewForm.mainTableKey, listView, grid;
    if (mTblKey) {
      listView = viewForm.getListView(mTblKey);
    } else {
      listView = viewForm.getListView(0);
    }
    if (listView) {
      return updateListView(form, listView, idx);
    }
    if (mTblKey) {
      grid = viewForm.getGrid(mTblKey);
    } else {
      grid = viewForm.getGrid(0);
    }
    if (grid) {
      return updateGrid(form, grid, idx);
    }
  }
}
class ErrorItem {
  constructor(source, msg) {
    this.source = "";
    this.msg = "";
    this.source = source;
    this.msg = msg;
  }
}
class CheckError {
  constructor() {
    this.items = [];
  }
  setError(error, msg, source) {
    if (error) {
      this.addError(msg, source);
    } else {
      this.removeError(source);
    }
  }
  addError(msg, source) {
    var index = this.items.findIndex((item) => item.source == source);
    if (index == -1) {
      this.items.push(new ErrorItem(source, msg));
    } else {
      this.items.splice(index, 1, new ErrorItem(source, msg));
    }
  }
  removeError(source) {
    this.items = this.items.filter((item) => item.source != source);
  }
  reset() {
    this.items.length = 0;
  }
  isError() {
    return this.items.length > 0;
  }
  hasError(source) {
    for (let item of this.items) {
      if (item.source == source) {
        return true;
      }
    }
    return false;
  }
  getErrorMsg() {
    var _msg = "", idx = 1;
    var length2 = this.items.length;
    if (length2) {
      if (length2 > 1) {
        this.items.forEach((item) => {
          _msg += idx++ + ": " + item.msg + "\n";
        });
      } else {
        _msg = this.items[0].msg;
      }
    }
    return _msg;
  }
}
const _RoundingMode = class _RoundingMode2 {
  static parseStr(modeStr) {
    var mode = _RoundingMode2.HALF_UP;
    if (modeStr == _RoundingMode2.STR_HALF_UP) {
      mode = _RoundingMode2.HALF_UP;
    } else if (modeStr == _RoundingMode2.STR_ROUND_UP) {
      mode = _RoundingMode2.ROUND_UP;
    } else if (modeStr == _RoundingMode2.STR_ROUND_DOWN) {
      mode = _RoundingMode2.ROUND_DOWN;
    } else if (modeStr == _RoundingMode2.STR_ROUND_CEILING) {
      mode = _RoundingMode2.ROUND_CEILING;
    } else if (modeStr == _RoundingMode2.STR_ROUND_FLOOR) {
      mode = _RoundingMode2.ROUND_FLOOR;
    }
    return mode;
  }
};
_RoundingMode.HALF_UP = 4;
_RoundingMode.STR_HALF_UP = "HALF_UP";
_RoundingMode.ROUND_UP = 0;
_RoundingMode.STR_ROUND_UP = "ROUND_UP";
_RoundingMode.ROUND_DOWN = 1;
_RoundingMode.STR_ROUND_DOWN = "ROUND_DOWN";
_RoundingMode.ROUND_CEILING = 2;
_RoundingMode.STR_ROUND_CEILING = "ROUND_CEILING";
_RoundingMode.ROUND_FLOOR = 3;
_RoundingMode.STR_ROUND_FLOOR = "ROUND_FLOOR";
let RoundingMode = _RoundingMode;
const ZERO_ONE = new Decimal("0.1");
const TEN = new Decimal("10");
const ZERO$1 = new Decimal("0");
const getMaxValue = (precision, decScale) => {
  let max = Decimal.pow(TEN, precision - decScale).minus(Decimal.pow(ZERO_ONE, decScale));
  return max;
};
const NumberSetting = {
  // 组分割符
  A_SEP: ",",
  // 组大小
  GROUP: 3,
  // 小数点符号
  A_DEC: ".",
  // 前缀或后缀符号
  A_SIGN: "",
  // p是前缀 s是后缀
  P_SIGN: "",
  // 四舍五入方式
  ROUNDING_MODE: RoundingMode.HALF_UP,
  // 总长度
  PRECISION: 16,
  //小数位数
  // mDec: '2',
  SCALE: 2,
  //去尾零
  STRIP_TRAILING_ZEROS: false,
  // 使用分隔符
  USE_SEPARATOR: true,
  // 显示零值
  SHOWZERO: false,
  // 零值显示值
  ZEROSTRING: "",
  // 是否允许为null
  ALLOWNULL: false
};
const decimal_format = function(num, dGroup, aSep) {
  let isNegative = num.indexOf("-") >= 0;
  let s;
  if (isNegative) {
    s = num.substring(1);
  } else {
    s = num;
  }
  let len = s.length;
  if (len <= dGroup) {
    return num;
  }
  let f = len % dGroup;
  let r = s.substring(0, f);
  for (var i2 = 0; i2 < Math.floor(len / dGroup); i2++) {
    r += aSep + s.substring(f + i2 * dGroup, f + (i2 + 1) * dGroup);
  }
  if (f === 0) {
    r = r.substring(1);
  }
  if (isNegative) {
    r = "-" + r;
  }
  return r;
};
class DecimalFormat {
  static format(value, settings) {
    var isZero = false;
    var allowNull = Utils.isDefined(settings.allowNull) ? settings.allowNull : NumberSetting.ALLOWNULL;
    if (allowNull) {
      if (value == null) {
        return "";
      }
    } else {
      if (value.isZero()) {
        isZero = true;
      }
    }
    if (isZero) {
      var showZero = Utils.isDefined(settings.showZero) ? settings.showZero : NumberSetting.SHOWZERO;
      var zeroString = Utils.isDefined(settings.zeroString) ? settings.zeroString : NumberSetting.ZEROSTRING;
      if (zeroString) {
        return zeroString;
      }
      if (!showZero) {
        return "";
      }
    }
    var caption = "", mDec = Utils.isDefined(settings.scale) ? settings.scale : NumberSetting.SCALE;
    if (mDec !== 0) {
      var stripTrailingZeros = Utils.isDefined(settings.stripTrailingZeros) ? settings.stripTrailingZeros : NumberSetting.STRIP_TRAILING_ZEROS;
      if (stripTrailingZeros) {
        caption = value.toFixed();
      } else {
        var mRound = Utils.isDefined(settings.roundingMode) ? settings.roundingMode : NumberSetting.ROUNDING_MODE;
        caption = value.toFixed(mDec, mRound);
      }
    } else {
      caption = value.toFixed();
    }
    var aDec = Utils.isDefined(settings.aDec) ? settings.aDec : NumberSetting.A_DEC;
    let index = caption.indexOf(aDec);
    let s;
    let ceil;
    if (index > -1) {
      s = caption.substring(0, index);
      ceil = caption.substring(index + 1);
    } else {
      s = caption;
      ceil = "";
    }
    var useSeparator = Utils.isDefined(settings.useSeparator) ? settings.useSeparator : NumberSetting.USE_SEPARATOR;
    if (useSeparator) {
      var dGroup = Utils.isDefined(settings.dGroup) ? settings.dGroup : NumberSetting.GROUP, aSep = Utils.isDefined(settings.aSep) ? settings.aSep : NumberSetting.A_SEP;
      s = decimal_format(s, dGroup, aSep);
    }
    if (index > -1) {
      caption = s + aDec + ceil;
    } else {
      caption = s;
    }
    if (settings.prefix) {
      caption = settings.prefix + caption;
    } else if (settings.suffix) {
      caption = caption + settings.suffix;
    }
    return caption;
  }
}
function UTCToDate(timestamp) {
  let len = timestamp.length;
  let date = null;
  if (len == 8 || len == 14) {
    let year = parseInt(timestamp.substring(0, 4), 10);
    let month = parseInt(timestamp.substring(4, 6), 10) - 1;
    let day = parseInt(timestamp.substring(6, 8), 10);
    date = new Date(year, month, day, 0, 0, 0);
    if (len == 14) {
      let hour = parseInt(timestamp.substring(8, 10), 10);
      let minute = parseInt(timestamp.substring(10, 12), 10);
      let second = parseInt(timestamp.substring(12, 14), 10);
      date.setHours(hour, minute, second);
    }
  }
  return date;
}
class DateFormat {
  static isInValid(text) {
    if (text) {
      let len = text.length;
      if (len >= 4 && len <= 19) {
        return false;
      } else {
        return true;
      }
    }
    return true;
  }
  static format(date, onlyDate, format = "") {
    if (!date) {
      return "";
    }
    var dateFormat = format;
    if (format === "") {
      dateFormat = onlyDate ? SHORT_FORMAT : LONG_FORMAT;
    }
    return Utils.dateFormat(date, dateFormat);
  }
  static dateFormat(value, format) {
    if (!value) {
      return "";
    }
    return Utils.dateFormat(value, format);
  }
  static parse(date, format) {
    if (this.isInValid(date)) {
      return "";
    }
    return Utils.parse(date, format);
  }
  static monthsFormat(date, format = "") {
    if (!date) {
      return "";
    }
    if (format === "") {
      format = Utils.getMonthFormat();
    }
    var dateStr = Utils.parse(date, YEARS_FORMAT);
    return Utils.dateFormat(dateStr, format);
  }
  static UTCFormat(value, onlyDate, format = "") {
    if (!value) {
      return "";
    }
    var formatstr = format;
    if (format === "") {
      if (onlyDate) {
        formatstr = SHORT_FORMAT;
      } else {
        formatstr = LONG_FORMAT;
      }
    }
    let d = UTCToDate(value.toString());
    if (d == null) {
      return "";
    }
    return Utils.dateFormat(d, formatstr);
  }
}
class TimeFormat {
  static monthPickerFormat(value) {
    if (!value)
      return "";
    value = String(value);
    if (value.lastIndexOf("-") == -1) {
      var val = value.replace(/(\d*)(\d{2})/, "$1-$2");
      var reg = /^\d{4}-((0([1-9]))|(1(0|1|2)))$/;
      if (val.match(reg) == null) {
        return "";
      }
    }
    return val;
  }
  static timePickerFormat(second, value) {
    value = String(value);
    var str = "24:00:00";
    if (second) {
      if (value.length < 6) {
        value = (Array(6).join("0") + value).slice(-6);
      }
      var val = value.replace(/(\d{2})(\d{2})(\d{2})/, "$1:$2:$3");
      var reg = /^([0-1][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$/;
    } else {
      if (value.length < 4) {
        value = (Array(4).join("0") + value).slice(-4);
      }
      var val = value.replace(/(\d{2})(\d{2})/, "$1:$2");
      var reg = /^([0-1][0-9]|2[0-3]):([0-5][0-9])$/;
      str = "24:00";
    }
    if (val == str) {
      return val;
    }
    if (val.match(reg) == null) {
      return "";
    }
    return val;
  }
  //HHmm转为自定义HH:mm, mm/HH等
  static format(value, formatStr, second = false) {
    if (!value) {
      return "";
    }
    value = String(value);
    formatStr = formatStr || Utils.getTimeFormat(second);
    var hour = value.substring(0, 2);
    var minutes = value.substring(2, 4);
    var seconds = "", char = "00";
    if (value == "0") {
      hour = char;
      minutes = char;
      seconds = char;
    }
    var newFormat = formatStr.replace(/h|H{1,2}/g, hour);
    newFormat = newFormat.replace(/m{1,2}/g, minutes);
    if (value.length == 6) {
      seconds = value.substring(4, 6);
      newFormat = newFormat.replace(/s{1,2}/g, seconds);
    } else if (formatStr.indexOf("s") != -1) {
      newFormat = newFormat.replace(/s{1,2}/g, char);
    }
    return newFormat;
  }
}
class DictLoadType {
}
DictLoadType.R2L = 0;
DictLoadType.L2R = 1;
class DocExpandDataKeys {
}
DocExpandDataKeys.ROWCOUNT_SUFFIX = "_RowCount";
DocExpandDataKeys.DICT_CAPTIONS = "DictCaptions";
DocExpandDataKeys.DICT_CODES = "DictCodes";
DocExpandDataKeys.DICT_DATA_ELEMENTS = "DictDataElements";
class RSAUtil {
  static encrypt_b64(publicKey, str) {
    const rsa = new JSEncrypt();
    var s = "-----BEGIN PUBLIC KEY-----" + publicKey + "-----END PUBLIC KEY-----";
    rsa.setPublicKey(s);
    str = rsa.encrypt(str);
    var rs = CryptoJS.enc.Base64.parse(str);
    var h = CryptoJS.enc.Hex.stringify(rs);
    let c = CryptoJS.enc.Utf8.parse(h);
    let data2 = CryptoJS.enc.Base64.stringify(c);
    return data2;
  }
}
class Interactive {
  /** 判断是否可以交互，只有使用原生程序壳时才为true，其他情况为false
   * @returns {Boolean} 是否可以交互
   */
  canInteractive() {
    return false;
  }
  /**
   * 初始化数据
   *
   * */
  initConfig() {
  }
  /** 调用原生系统拍照
   * @returns {string} 返回Base64的图片字符串， 格式为"data:image/jpeg;base64,xxxxxxx..."
   */
  takePhotoOnly(isBase64) {
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /** 调用原生系统拍照，并上传
   * @param {string} formKey 上传表单标识
   * @param {string} oid 上传表单的数据源OID
   * @param {long} maxSize 上传图片文件的最大大小
   * @param {string} provider 后台上传方式的二开类的定义标识
   * @param {string} fileName 固定图片名称
   * @returns {string} 返回上传后相对于Data文件夹的相对路径
   */
  takePhotoForUpload(formKey, oid, maxSize, provider, fileName) {
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /** 调用原生系统相册
   * @returns {string} 返回Base64的图片字符串， 格式为"data:image/jpeg;base64,xxxxxxx..."
   */
  selectPhotoOnly(isBase64) {
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /** 调用原生系统相册，并上传
   * @param {string} formKey 上传表单标识
   * @param {string} oid 上传表单的数据源OID
   * @param {long} maxSize 上传图片文件的最大大小
   * @param {string} provider 后台上传方式的二开类的定义标识
   * @param {string} fileName 固定图片名称
   * @returns {string} 返回上传后相对于Data文件夹的相对路径
   */
  selectPhotoForUpload(formKey, oid, maxSize, provider, fileName) {
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /** 调用多选图片选项器
   * @param {int} maxSelectNum 可以选择的最大数量，默认是9
   * @returns {string} 返回Base64的图片字符串的jsonArray对象，
   * 格式为"{[data:image/jpeg;base64,xxxxxxx..., data:image/jpeg;base64,xxxxxxx..., ......]}"
   */
  multiSelectPhotoOnly(maxSelectNum, isBase64) {
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /** 调用多选图片选项器，并上传
   * @param {int} maxSelectNum 可以选择的最大数量，默认是9
   * @param {string} formKey 上传表单标识
   * @param {string} oid 上传表单的数据源OID
   * @param {long} maxSize 上传图片文件的最大大小
   * @param {string} provider 后台上传方式的二开类的定义标识 
   * @returns {string} 返回上传后相对于Data目录的相对路径的JSONArray集合，
   */
  multiSelectPhotoForUpload(maxSelectNum, formKey, oid, maxSize, provider) {
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /** 调用系统视频录制
   * @returns {string} 返回Base64的图片字符串， 格式为"data:video/mp4;base64,xxxxxxx..."
   */
  takeVideoOnly() {
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /** 调用系统视频录制，并上传 
   * @param {string} formKey 上传表单标识
   * @param {string} oid 上传表单的数据源OID 
   * @param {string} provider 后台上传方式的二开类的定义标识
   * @returns {string} 返回上传后相对于Data目录的相对路径
   */
  takeVideoForUpload(formKey, oid, provider) {
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /** 调用视频选项器 
   * @returns {string} 返回Base64的图片字符串， 格式为"data:video/mp4;base64,xxxxxxx..."
   */
  selectVideoOnly() {
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /** 调用视频选择器，并上传 
   * @param {string} formKey 上传表单标识
   * @param {string} oid 上传表单的数据源OID 
   * @param {string} provider 后台上传方式的二开类的定义标识
   * @returns {string} 返回上传后相对于Data目录的相对路径
   */
  selectVideoForUpload(formKey, oid, provider) {
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /** 调用原生系统电话功能，拨打电话
   * @param {string} phoneNum 需要拨打的电话号码
   * @returns {boolean} 是否拨打成功
   */
  callPhone(phoneNum) {
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /** 调用原生系统通讯录功能，选择一个联系人后，返回该联系人信息。
   *  @returns {string} 返回值为JSON字符串，格式为：
   *  {
   *     "name":"",
   *     "contactID":"",
   *     "phoneNumber":[
   *          "xxxx-xxxxxxx",
   *          "xxxxxxxxxxx",
   *          ... ...
   *      ]
   *  }
   */
  selectContact() {
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /** 调用原生系统通讯录，获取通讯录中所有联系人的信息。
   *  @returns {string} 返回值为JSON字符串，格式为：
   *  {
   *      {
   *          "name":"name1",
   *          "contactID":"",
   *          "phoneNumber":[
   *              "xxxx-xxxxxxx",
   *              "xxxxxxxxxxx",
   *              ... ...
   *          ]
   *      }
   *      {
   *          "name":"name2",
   *          "contactID":"",
   *          "phoneNumber":[
   *              "xxxx-xxxxxxx",
   *              "xxxxxxxxxxx",
   *              ... ...
   *          ]
   *      }
   *      ... ...
   *  }
   */
  readContacts() {
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /** 调用原生二维码扫描功能，扫描后返回二维码信息。
   *  @returns {string}
   *  返回值为JSON字符串，格式为：
   *  {
   *      "Contents":"", //二维码内容
   *      "FormatName":"", //二维码格式化类型
   *      "RawBytes":"",
   *      "Orientation":"",
   *      "ErrorCorrectionLevel":""
   *  }
   */
  scanBarCode() {
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /**
   * 调用原生二维码生成功能，对需要转换的内容进行处理，生成一个二维码图片并返回
   * @param {String} codeString 需要生成二维码的内容
   * @param {String} codeType 生成二维码的格式
   * @param {Boolean} showContent 显示二维码图片时是否显示内容
   * @param {Boolean} showImage  是否显示二维码图片
   * @returns {string} 二维码图片的Base64字符串，格式为"data:image/jpeg;base64,xxxxxxx..."
   */
  createBarCode(codeString, codeType, showContent, showImage) {
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /**
   * 获取二维码预览界面的表单json
   */
  getPreviewForm() {
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /**
   * 转跳默认浏览器，打开URL
   * @param {String} urlString  需要跳转的url地址
   * @returns {Boolean} 是否转跳成功
   */
  openURL(urlString) {
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 获取打包壳工程信息
   * @returns {String} 壳工程信息，json格式：
   * {
   *      packageName:"",
   *      versionCode:"",
   *      versionName:""
   * }
   */
  getPackageInfo() {
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /**
   * 获取网络信息
   * @returns {String} 当前网络信息，json格式：
   * {
   *      Available:"",
   *      Type:"",
   *      TypeName:""
   * }
   */
  getNetWorkInfo() {
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /**
   * 获取GPS定位
   * @returns {String} GPS定位信息，json格式：
   * {
   *      Latitude:"",
   *      Longitude:"", 
   * }
   */
  getLocation(provider, timeout) {
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /**
   * 获取最后一次的GPS定位
   * @returns {String} GPS定位信息，json格式：
   * {
   *      Latitude:"",
   *      Longitude:"", 
   * }
   */
  getLastLocation(provider) {
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /**
   * 设置剪切板内容
   * @param {String} content 设置到剪切板的内容
   * @returns {Boolean} 是否设置成功
   */
  setToClipboard(content) {
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 获取剪切板内容
   * @returns {String} 剪切板内容
   */
  getFromClipboard() {
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 获取推送的设备唯一标识
   * @returns {String} 设备的唯一标识
   */
  getChannelID(platformName) {
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 设置状态条颜色
   * @param {String} color 设置的十六进制颜色字符串
   * @returns {Boolean} 是否设置成功
   */
  setStatusBarColor(color) {
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 获取状态栏高度
   * @returns {String} 状态栏高度
   */
  getStatusBarHeight() {
    return new Promise((resolve2) => {
      resolve2("0");
    });
  }
  /**
   * 登陆后的交互操作
   */
  afterLogin() {
  }
  /**
   * 向硬件设备传cookie
   * @param {String} cookie 当前请求的cookie信息
   * @returns {Boolean} 是否保存成功
   */
  saveCookie(cookie) {
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 将数据存储到本地数据缓存中
   * @param {String} key 数据对应的标识
   * @param {String} value 数据内容
   * @returns {Boolean} 是否保存成功
   */
  saveLocalData(key, value) {
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 从本地数据缓存中，获取对应的数据
   * @param {String} key 数据对应的标识
   * @returns {String} 获取到的对应数据
   */
  loadLocalData(key) {
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 打开附件
   * @param {String} formKey 附件所在表单的配置对象标识
   * @param {String} path 附件相对于Data文件夹的路径
   * @param {Boolean} isDefault 是否默认方式打开
   * @param {String} provider 后台附件服务的二次开发类标识
   * @returns {Boolean} 是否打开成功
   */
  openAttachment(formKey, path, isDefault, provider) {
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 选择发票
   * @param {String} type 发票来源类型，目前支持：WeChat-微信；Alipay-支付宝
   * @returns {String} 发票的相关内容json字符串
   */
  chooseInvoice(type) {
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /**
   * 支付
   * @param {String} outTradeNo 支付表单的编号，即订单号
   * @param {String} totalFee 支付金额
   * @param {String} detail 支付时，显示在支付界面的订单详情
   * @returns {Boolean} 支付成功与否
   */
  pay(outTradeNo, totalFee, detail) {
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 退款
   * @param {String} outTradeNo 支付表单的编号，即订单号
   * @param {String} totalFee 支付金额
   * @param {String} refundFee 退款金额
   * @returns {Boolean} 退款成功与否
   */
  refund(outTradeNo, totalFee, refundFee) {
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 清空本地数据缓存文件
   */
  clearCacheFiles() {
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 获取请求模式，目前Android和IOS壳中，统一返回"2"
   */
  getRequestMode() {
    return new Promise((resolve2) => {
      resolve2(2);
    });
  }
  /**
   * 是否支持分享到微信
   */
  supportWeiXinShare() {
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 分享当前表单到微信好友 
   * @param {String} shareFormKey 分享的表单标志,必填参数
   * @param {String} shareOid 分享表单的OID，必填参数
   * @param {Boolean} onlyText 是否纯文本链接分享，可选参数，默认为true
   * @param {String} title 非纯文本分享时的标题内容，可选参数
   * @param {String} description  非纯文本分享时的描述内容，可选参数
   * @param {String} thumbImage  非纯文本分享时的缩略图名称，该图片存在于配置的Resource目录，可选参数
   * @returns {Boolean} 分享动作是否成功
   */
  shareToWeiXin(shareFormKey, shareOid, onlyText, title, description, thumbImage) {
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * excel导出打开查看
   * @param options excel导出所需要的相关参数集合
   * @returns 
   */
  exportExcel(options2) {
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 上传附件
   * @param options 上传附件所需要的相关参数集合
   * @returns 
   */
  uploadAttachment(options2) {
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 上传附件
   * @param options 上传附件所需要的相关参数集合
   * @returns 
   */
  downloadAttachment(options2) {
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  doBackPress() {
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
  * 记录日志到原生壳中（仅支持安卓）
  */
  recordLog(options2) {
    return Promise.resolve(false);
  }
}
Interactive.callbackID = 0;
const _InterActiveFactory = class _InterActiveFactory2 {
  static setInteractive(interactive) {
    if (interactive.canInteractive()) {
      _InterActiveFactory2.Interactive = interactive;
      _InterActiveFactory2.Interactive.initConfig();
      _InterActiveFactory2.Interactive.getStatusBarHeight().then((height) => {
        _InterActiveFactory2.interactiveHeigth = height;
      });
    }
  }
};
_InterActiveFactory.Interactive = new Interactive();
_InterActiveFactory.interactiveHeigth = 0;
let InterActiveFactory = _InterActiveFactory;
class NativeInteractive extends Interactive {
  /** 判断是否可以交互，只有使用原生程序壳时才为true，其他情况为false
   * @returns {Boolean} 是否可以交互
   */
  canInteractive() {
    var canOpt = false;
    if (window.webkit != null && window.webkit.messageHandlers.YigoMobile != null) {
      canOpt = true;
    } else if (window.YigoMobile != null) {
      canOpt = true;
    }
    return canOpt;
  }
  /** 同原生程序交互的最底层接口，通常不直接使用
   * @param {JSON} paras 接口传递参数对象
   * @returns {Boolean} 是否交互成功
   */
  opt(paras) {
    if (window.webkit != null && window.webkit.messageHandlers.YigoMobile != null) {
      window.webkit.messageHandlers.YigoMobile.postMessage(JSON.stringify(paras));
      return true;
    } else if (window.YigoMobile != null) {
      window.YigoMobile.postMessage(JSON.stringify(paras));
      return true;
    }
    return false;
  }
  /** 同原生程序交互的操作基类，通常不直接使用
   * @param {JSON} paras 操作参数对象
   * @param {*} callback 回调方法
   * @returns {*} 返回交互操作结果
   */
  doAction(paras, callback) {
    return new Promise((resolve2) => {
      var callbackName = paras.functionName + Interactive.callbackID++ + "_callback";
      paras.callback = callbackName;
      var interActiveCallback = function(result) {
        if (paras.functionName == "takeVideoOnly" || paras.functionName == "selectVideoOnly") {
          result = decodeURIComponent(result);
        }
        resolve2(result);
        setTimeout(() => {
          delete window[paras.callback];
        }, 500);
      };
      window[callbackName] = callback == null ? interActiveCallback : callback;
      if (parent) {
        parent[callbackName] = callback == null ? interActiveCallback : callback;
      }
      this.opt(paras);
    });
  }
  /** 调用原生系统拍照
   * @returns {string} 返回Base64的图片字符串， 格式为"data:image/jpeg;base64,xxxxxxx..."
   */
  takePhotoOnly(isBase64) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "takePhotoOnly",
        isBase64
      };
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /** 调用原生系统拍照，并上传
   * @param {string} formKey 上传表单标识
   * @param {string} oid 上传表单的数据源OID
   * @param {long} maxSize 上传图片文件的最大大小
   * @param {string} provider 后台上传方式的二开类的定义标识
   * @param {string} fileName 固定图片名称
   * @returns {string} 返回上传后相对于Data文件夹的相对路径
   */
  takePhotoForUpload(formKey, oid, maxSize, provider, fileName) {
    var paras = {
      functionName: "takePhotoForUpload",
      formKey,
      oid,
      maxSize,
      provider,
      fileName
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /** 调用原生系统相册
   * @returns {string} 返回Base64的图片字符串， 格式为"data:image/jpeg;base64,xxxxxxx..."
   */
  selectPhotoOnly(isBase64) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "selectPhotoOnly",
        isBase64
      };
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /** 调用原生系统相册，并上传
   * @param {string} formKey 上传表单标识
   * @param {string} oid 上传表单的数据源OID
   * @param {long} maxSize 上传图片文件的最大大小
   * @param {string} provider 后台上传方式的二开类的定义标识
   * @param {string} fileName 固定图片名称
   * @returns {string} 返回上传后相对于Data文件夹的相对路径
   */
  selectPhotoForUpload(formKey, oid, maxSize, provider, fileName) {
    var paras = {
      functionName: "selectPhotoForUpload",
      formKey,
      oid,
      maxSize,
      provider,
      fileName
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /** 调用多选图片选项器
   * @param {int} maxSelectNum 可以选择的最大数量，默认是9
   * @returns {string} 返回Base64的图片字符串的jsonArray对象，
   * 格式为"{[data:image/jpeg;base64,xxxxxxx..., data:image/jpeg;base64,xxxxxxx..., ......]}"
   */
  multiSelectPhotoOnly(maxSelectNum, isBase64) {
    var paras = {
      functionName: "multiSelectPhotoOnly",
      maxSelectNum,
      isBase64
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return JSON.parse(result);
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /** 调用多选图片选项器，并上传
   * @param {int} maxSelectNum 可以选择的最大数量，默认是9
   * @param {string} formKey 上传表单标识
   * @param {string} oid 上传表单的数据源OID
   * @param {long} maxSize 上传图片文件的最大大小
   * @param {string} provider 后台上传方式的二开类的定义标识
   * @returns {string} 返回上传后相对于Data目录的相对路径的JSONArray集合，
   */
  multiSelectPhotoForUpload(maxSelectNum, formKey, oid, maxSize, provider) {
    var paras = {
      functionName: "multiSelectPhotoForUpload",
      maxSelectNum,
      formKey,
      oid,
      maxSize,
      provider
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return JSON.parse(result);
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /** 调用系统视频录制
   * @returns {string} 返回Base64的图片字符串， 格式为"data:video/mp4;base64,xxxxxxx..."
   */
  takeVideoOnly() {
    var paras = {
      functionName: "takeVideoOnly"
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /** 调用系统视频录制，并上传 
   * @param {string} formKey 上传表单标识
   * @param {string} oid 上传表单的数据源OID 
   * @param {string} provider 后台上传方式的二开类的定义标识
   * @returns {string} 返回上传后相对于Data目录的相对路径
   */
  takeVideoForUpload(formKey, oid, provider) {
    var paras = {
      functionName: "takeVideoForUpload",
      formKey,
      oid,
      provider
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /** 调用视频选项器 
   * @returns {string} 返回Base64的图片字符串， 格式为"data:video/mp4;base64,xxxxxxx..."
   */
  selectVideoOnly() {
    var paras = {
      functionName: "selectVideoOnly"
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /** 调用视频选择器，并上传 
   * @param {string} formKey 上传表单标识
   * @param {string} oid 上传表单的数据源OID 
   * @param {string} provider 后台上传方式的二开类的定义标识
   * @returns {string} 返回上传后相对于Data目录的相对路径
   */
  selectVideoForUpload(formKey, oid, provider) {
    var paras = {
      functionName: "selectVideoForUpload",
      formKey,
      oid,
      provider
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /** 调用原生系统电话功能，拨打电话
   * @param {string} phoneNum 需要拨打的电话号码
   * @returns {boolean} 是否拨打成功
   */
  callPhone(phoneNum) {
    var paras = {
      functionName: "callPhone",
      phoneNum
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /** 调用原生系统通讯录功能，选择一个联系人后，返回该联系人信息。
   *  @returns {string} 返回值为JSON字符串，格式为：
   *  {
   *     "name":"",
   *     "contactID":"",
   *     "phoneNumber":[
   *          "xxxx-xxxxxxx",
   *          "xxxxxxxxxxx",
   *          ... ...
   *      ]
   *  }
   */
  selectContact() {
    var paras = {
      functionName: "selectContact"
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /** 调用原生系统通讯录，获取通讯录中所有联系人的信息。
   *  @returns {string} 返回值为JSON字符串，格式为：
   *  {
   *      {
   *          "name":"name1",
   *          "contactID":"",
   *          "phoneNumber":[
   *              "xxxx-xxxxxxx",
   *              "xxxxxxxxxxx",
   *              ... ...
   *          ]
   *      },
   *      {
   *          "name":"name2",
   *          "contactID":"",
   *          "phoneNumber":[
   *              "xxxx-xxxxxxx",
   *              "xxxxxxxxxxx",
   *              ... ...
   *          ]
   *      },
   *      ... ...
   *  }
   */
  readContacts() {
    var paras = {
      functionName: "readContacts"
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /** 调用原生二维码扫描功能，扫描后返回二维码信息。
   *  @returns {string}
   *  返回值为JSON字符串，格式为：
   *  {
   *      "Contents":"", //二维码内容
   *      "FormatName":"", //二维码格式化类型
   *      "RawBytes":"",
   *      "Orientation":"",
   *      "ErrorCorrectionLevel":""
   *  }
   */
  scanBarCode() {
    if (this.canInteractive()) {
      var paras = {
        functionName: "scanBarCode"
      };
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /**
   * 调用原生二维码生成功能，对需要转换的内容进行处理，生成一个二维码图片并返回
   * @param {String} codeString 需要生成二维码的内容
   * @param {String} codeType 生成二维码的格式
   * @param {Boolean} showContent 显示二维码图片时是否显示内容
   * @param {Boolean} showImage  是否显示二维码图片
   * @returns {string} 二维码图片的Base64字符串，格式为"data:image/jpeg;base64,xxxxxxx..."
   */
  createBarCode(codeString, codeType, showContent, showImage) {
    var paras = {
      functionName: "createBarCode",
      codeString,
      codeType,
      showContent,
      showImage
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 获取二维码预览界面的表单json
   */
  getPreviewForm() {
    var paras = {
      functionName: "getPreviewForm"
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /**
   * 转跳默认浏览器，打开URL
   * @param {String} urlString  需要跳转的url地址
   * @returns {Boolean} 是否转跳成功
   */
  openURL(urlString) {
    var paras = {
      functionName: "openURL",
      URL: urlString
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 获取打包壳工程信息
   * @returns {String} 壳工程信息，json格式：
   * {
   *      packageName:"",
   *      versionCode:"",
   *      versionName:""
   * }
   */
  getPackageInfo() {
    var paras = {
      functionName: "getPackageInfo"
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /**
   * 获取网络信息
   * @returns {String} 当前网络信息，json格式：
   * {
   *      Available:"",
   *      Type:"",
   *      TypeName:""
   * }
   */
  getNetWorkInfo() {
    if (this.canInteractive()) {
      var paras = {
        functionName: "getNetWorkInfo"
      };
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /**
   * 获取GPS定位
   * @returns {String} GPS定位信息，json格式：
   * {
   *      Latitude:"",
   *      Longitude:"", 
   * }
   */
  getLocation(provider, timeout) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "getLocation",
        provider,
        timeout
      };
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /**
   * 获取最后一次的GPS定位
   * @returns {String} GPS定位信息，json格式：
   * {
   *      Latitude:"",
   *      Longitude:"", 
   * }
   */
  getLastLocation(provider) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "getLastLocation",
        provider
      };
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("{}");
    });
  }
  /**
   * 设置剪切板内容
   * @param {String} content 设置到剪切板的内容
   * @returns {Boolean} 是否设置成功
   */
  setToClipboard(content) {
    var paras = {
      functionName: "setToClipboard",
      content
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 获取剪切板内容
   * @returns {String} 剪切板内容
   */
  getFromClipboard() {
    var paras = {
      functionName: "getFromClipboard"
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 获取推送的设备唯一标识
   * @returns {String} 设备的唯一标识
   */
  getChannelID(platformName) {
    var paras = {
      functionName: "getChannelID",
      platformName
      //推送类型名称，目前只支持极光推送-“JPush”;后期有多个推送选择时，再处理
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 设置状态条颜色
   * @param {String} color 设置的十六进制颜色字符串
   * @returns {Boolean} 是否设置成功
   */
  setStatusBarColor(color) {
    var paras = {
      functionName: "setStatusBarColor",
      color
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 获取状态栏高度
   * @returns {String} 状态栏高度
   */
  getStatusBarHeight() {
    var paras = {
      functionName: "getStatusBarHeight"
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("0");
    });
  }
  /**
   * 向硬件设备传cookie
   * @param {String} cookie 当前请求的cookie信息
   * @returns {Boolean} 是否保存成功
   */
  saveCookie(cookie) {
    var paras = {
      functionName: "saveCookie",
      cookie
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 将数据存储到本地数据缓存中
   * @param {String} key 数据对应的标识
   * @param {String} value 数据内容
   * @returns {Boolean} 是否保存成功
   */
  saveLocalData(key, value) {
    var paras = {
      functionName: "saveLocalData",
      key,
      value
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 从本地数据缓存中，获取对应的数据
   * @param {String} key 数据对应的标识
   * @returns {String} 获取到的对应数据
   */
  loadLocalData(key) {
    var paras = {
      functionName: "loadLocalData",
      key
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 打开附件
   * @param {String} formKey 附件所在表单的配置对象标识
   * @param {String} path 附件相对于Data文件夹的路径
   * @param {Boolean} isDefault 是否默认方式打开
   * @param {String} provider 后台附件服务的二次开发类标识
   * @returns {Boolean} 是否打开成功
   */
  openAttachment(formKey, path, isDefault, provider) {
    var paras = {
      functionName: "openAttachment",
      formKey,
      path,
      isDefault,
      provider
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 选择发票
   * @param {String} type 发票来源类型，目前支持：WeChat-微信；Alipay-支付宝
   * @returns {String} 发票的相关内容json字符串
   */
  chooseInvoice(type) {
    var paras = {
      functionName: "chooseInvoice",
      type
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 支付
   * @param {String} outTradeNo 支付表单的编号，即订单号
   * @param {String} totalFee 支付金额
   * @param {String} detail 支付时，显示在支付界面的订单详情
   * @returns {Boolean} 支付成功与否
   */
  pay(outTradeNo, totalFee, detail) {
    var paras = {
      functionName: "pay",
      outTradeNo,
      totalFee,
      detail
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 退款
   * @param {String} outTradeNo 支付表单的编号，即订单号
   * @param {String} totalFee 支付金额
   * @param {String} refundFee 退款金额
   * @returns {Boolean} 退款成功与否
   */
  refund(outTradeNo, totalFee, refundFee) {
    var paras = {
      functionName: "refund",
      outTradeNo,
      totalFee,
      refundFee
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 清空本地数据缓存文件
   */
  clearCacheFiles() {
    var paras = {
      functionName: "clearCacheFiles"
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 获取请求模式，目前Android和IOS壳中，统一返回"2"
   */
  getRequestMode() {
    var paras = {
      functionName: "getRequestMode"
    };
    if (this.canInteractive()) {
      return this.doAction(paras, null).then(function(result) {
        return TypeConvertor.toInt(result);
      });
    }
    return new Promise((resolve2) => {
      resolve2(2);
    });
  }
  /**
   * 是否支持分享到微信
   */
  supportWeiXinShare() {
    var paras = {
      functionName: "supportWeiXinShare"
    };
    return this.doAction(paras, null).then(function(result) {
      return result;
    });
  }
  /**
   * 分享当前表单到微信好友 
   * @param {String} shareFormKey 分享的表单标志,必填参数
   * @param {String} shareOid 分享表单的OID，必填参数
   * @param {Boolean} onlyText 是否纯文本链接分享，可选参数，默认为true
   * @param {String} title 非纯文本分享时的标题内容，可选参数
   * @param {String} description  非纯文本分享时的描述内容，可选参数
   * @param {String} thumbImage  非纯文本分享时的缩略图名称，该图片存在于配置的Resource目录，可选参数
   * @returns {Boolean} 分享动作是否成功
   */
  shareToWeiXin(shareFormKey, shareOid, onlyText, title, description, thumbImage) {
    var paras = {
      functionName: "shareToWeiXin",
      shareFormKey,
      shareOid,
      onlyText,
      title,
      description,
      thumbImage
    };
    return this.doAction(paras, null).then(function(result) {
      return result;
    });
  }
  decodeBarCode(codeImage) {
    var paras = {
      functionName: "decodeBarCode",
      codeImage
    };
    return this.doAction(paras, null).then(function(result) {
      return result;
    });
  }
  exportExcel(options2) {
    options2.functionName = "exportExcel";
    if (this.canInteractive()) {
      return this.doAction(options2, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  uploadAttachment(options2) {
    options2.functionName = "uploadAttachment";
    if (this.canInteractive()) {
      return this.doAction(options2, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  downloadAttachment(options2) {
    options2.functionName = "downloadAttachment";
    if (this.canInteractive()) {
      return this.doAction(options2, null).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  doBackPress() {
    return this.doAction({ functionName: "doBackPress" }, null);
  }
  /**
   * 记录日志到原生壳中（仅支持安卓）
   */
  recordLog(logInfo) {
    if (this.canInteractive()) {
      var paras = { functionName: "recordLog", logInfo };
      return this.doAction(paras, null);
    }
    return Promise.resolve(false);
  }
}
InterActiveFactory.setInteractive(new NativeInteractive());
const LOAD_DIM_VALUE = "LoadDimValue";
const CHANGE_PWD = "ChangePWD";
const SAVE_PREFERENCE = "SavePreference";
const LOAD_PREFERENCE = "LoadPreference";
const KICK_OFF_OPERATOR = "KickOffOperator";
const UNLOCK_OPERATOR = "UnlockOperator";
const SET_SESSION_PARAS = "SetSessionParas";
const SET_CLUSTER_ID = "SetClusterID";
const UPLOAD_FILE = "UploadFile";
const GET_THIRD_APP_ENV_INFO = "GetThirdAppEnvInfo";
const GET_MOBILE_FILE = "GetMobileFile";
const DOWNLOAD_ATTACHMENT = "DownloadAttachment";
const GET_MOBILE_ENV_DEF = "GetMobileEnvDef";
const GET_COMMON_DEF = "GetCommonDef";
const GET_OFF_LINE_INFO = "GetOfflineInfo";
const QUERY_VALIDATE_IMAGE = "QueryValidateImage";
const CREATE_TEMP_CLIENT_ID = "CreateTempClientID";
const GET_LOGIN_DEF = "GetLoginDef";
const Re_MIGRATE = "ReMigrate";
class RemoteService {
  constructor(form) {
    this.request = new Request$1(form);
  }
  /**
   * 获取一个新增的oid
   */
  applyNewOID(dataObjectKey) {
    var params = {
      service: ServiceName.APPLY_NEW_OID,
      dataObjectKey
    };
    return this.request.getData(params).then((data2) => {
      return data2.OID;
    });
  }
  /**
   * 获取表单纬度值
   */
  loadDimValue(formKey, params) {
    var params = Object.assign({}, {
      service: ServiceName.LOAD_DIM_VALUE,
      cmd: LOAD_DIM_VALUE,
      formKey
    }, params);
    return this.request.getData(params);
  }
  /**
   * 获取平台公共密钥
   */
  getPublicKey() {
    let params = {
      service: ServiceName.GET_PUBLIC_KEY
    };
    return this.request.getData(params);
  }
  /**
   * 修改密码
   */
  changePWD(operatorID, password, newPassword) {
    var paras = {
      service: ServiceName.SESSION_RIGHTS,
      cmd: CHANGE_PWD,
      operatorID,
      password,
      newPassword
    };
    return this.request.getData(paras);
  }
  /**
   * 设置sessionParas，存放在服务器端
   */
  setSessionParas(paras) {
    var params = {
      cmd: SET_SESSION_PARAS,
      service: ServiceName.HTTP_AUTHENTICATE,
      paras: JSON.stringify(paras)
    };
    return this.request.getData(params);
  }
  savePreference(formKey, data2) {
    var params = {
      service: ServiceName.PREFERENCE,
      cmd: SAVE_PREFERENCE,
      key: formKey,
      formKey,
      prefData: JSON.stringify(data2)
    };
    return this.request.getData(params);
  }
  loadPreference(formKey) {
    var params = {
      service: ServiceName.PREFERENCE,
      cmd: LOAD_PREFERENCE,
      key: formKey,
      formKey
    };
    return this.request.getData(params);
  }
  savePreference2(formKey, key, data2) {
    var params = {
      service: ServiceName.PREFERENCE,
      cmd: SAVE_PREFERENCE,
      formKey,
      key,
      prefData: JSON.stringify(data2)
    };
    return this.request.getData(params);
  }
  loadPreference2(formKey, key) {
    var params = {
      service: ServiceName.PREFERENCE,
      cmd: LOAD_PREFERENCE,
      formKey,
      key
    };
    return this.request.getData(params);
  }
  convertStatus(dataObjKey, doc, isKey, status, sysTopic) {
    var docJson = DataUtil$1.toJSONDoc(doc);
    var params = {
      service: ServiceName.CONVERT_STATUS,
      dataObjectKey: dataObjKey,
      document: JSON.stringify(docJson),
      isKey,
      status,
      sysTopic
    };
    return this.request.getData(params);
  }
  kickOffOperator(mode, clientID) {
    var params = {
      service: ServiceName.SESSION_RIGHTS,
      cmd: KICK_OFF_OPERATOR,
      loginMode: mode,
      client: clientID
    };
    return this.request.getData(params);
  }
  unlockOperator(mode, operatorID) {
    var params = {
      service: ServiceName.SESSION_RIGHTS,
      cmd: UNLOCK_OPERATOR,
      loginMode: mode,
      operatorID
    };
    return this.request.getData(params);
  }
  setClusterID(clusterID) {
    var params = {
      service: ServiceName.HTTP_AUTHENTICATE,
      cmd: SET_CLUSTER_ID,
      clusterID
    };
    return this.request.getData(params);
  }
  localeString(formKey, group, key, values) {
    var params = {
      service: ServiceName.LOCALE_STRING,
      formKey,
      group,
      key,
      paras: JSON.stringify(values)
    };
    return this.request.getData(params);
  }
  applyNewSequence(dataObjectKey, NoPrefix) {
    var params = {
      service: ServiceName.APPLY_NEW_SEQUENCE,
      dataObjectKey,
      NoPrefix
    };
    return this.request.getData(params);
  }
  uploadAttachment(formKey, oid, params) {
    var params = Object.assign({
      service: ServiceName.UPLOAD_ATTACHMENT,
      formKey,
      operatorID: SessionInfo.getUserID(),
      oid,
      isFixName: false
    }, params);
    return this.request.uploadFile(params);
  }
  deleteAttachment(formKey, provider, path) {
    var params = {
      formKey,
      provider,
      path,
      service: ServiceName.DELETE_ATTACHMENT
    };
    return this.request.getData(params);
  }
  uploadImage(formKey, oid, params) {
    var params = Object.assign({
      service: ServiceName.UPLOAD_IMAGE,
      formKey,
      operatorID: SessionInfo.getUserID(),
      oid,
      isFixName: false
    }, params);
    return this.request.uploadFile(params);
  }
  deleteImage(formKey, filePath) {
    var params = {
      service: ServiceName.DELETE_IMAGE,
      formKey,
      filePath,
      operatorID: SessionInfo.getUserID()
    };
    return this.request.getData(params, AttachURL);
  }
  batchImageUpload(formKey, oid, params) {
    var params = Object.assign({
      service: ServiceName.UPLOAD_IMAGE,
      formKey,
      operatorID: SessionInfo.getUserID(),
      oid,
      isFixName: false
    }, params);
    return this.request.uploadFile(params);
  }
  uploadFile(formKey, oid, params) {
    var params = Object.assign({
      service: ServiceName.UPLOAD_ATTACHMENT,
      cmd: UPLOAD_FILE,
      formKey,
      operatorID: SessionInfo.getUserID(),
      oid,
      isFixName: false
    }, params);
    return this.request.uploadFile(params);
  }
  getThirdAppEnvInfo(paras) {
    var params = {
      cmd: GET_THIRD_APP_ENV_INFO,
      service: ServiceName.MOBILE_SERVICE,
      url: paras.url,
      thirdAppType: paras.thirdAppType
    };
    return this.request.getData(params);
  }
  getMobileFile(path, checkCode = null) {
    var options2 = {
      filePath: path,
      path,
      cmd: GET_MOBILE_FILE,
      service: ServiceName.MOBILE_FILE,
      checkCode
    };
    var self = this;
    return new Promise((resolve2) => {
      self.request.downloadFile(options2, function(blob, obj) {
        new Response(blob).text().then(function(res) {
          obj["fileStr"] = res;
          obj["blob"] = blob;
          resolve2(obj);
        });
      });
    });
  }
  getAttachmentFile(option, checkCode = null) {
    var options2 = {
      formKey: option.formKey || "",
      tableKey: option.tableKey || "",
      path: option.path || "",
      provider: option.provider || "",
      sourceType: option.sourceType || -1,
      range: option.range || "bytes=0-",
      cmd: DOWNLOAD_ATTACHMENT,
      service: ServiceName.DOWNLOAD_ATTACHMENT,
      checkCode
    };
    var self = this;
    return new Promise((resolve2) => {
      self.request.downloadFile(options2, function(blob, obj) {
        new Response(blob).text().then(function(res) {
          obj["fileStr"] = res;
          obj["blob"] = blob;
          resolve2(obj);
        });
      });
    });
  }
  getMobileEnvDef() {
    var params = {
      cmd: GET_MOBILE_ENV_DEF,
      service: ServiceName.MOBILE_SERVICE
    };
    return this.request.getData(params);
  }
  async uploadImageAttachment(base64file, paras) {
    var strArray = base64file.split(",");
    var bytes = window.atob(strArray[1]);
    var array = [];
    for (var i2 = 0; i2 < bytes.length; i2++) {
      array.push(bytes.charCodeAt(i2));
    }
    var str = strArray[0].substring(5);
    str = str.substring(0, str.indexOf(";"));
    var blob = new Blob([new Uint8Array(array)], {
      type: str
    });
    var fileName = Date.now() + (paras.type || ".jpg");
    if (paras.fileName) {
      fileName = paras.fileName + (paras.type || ".jpg");
    }
    var path = paras.formKey + "/" + paras.oid + "/" + fileName;
    var fd = new FormData();
    fd.append("file", blob, fileName);
    fd.append("service", "UploadAttachment");
    fd.append("fileName", fileName);
    fd.append("formKey", paras.formKey);
    fd.append("path", paras.path || path);
    fd.append("seriesPath", paras.seriesPath || "");
    fd.append("oid", paras.oid);
    fd.append("provider", paras.provider);
    fd.append("deleteOld", "true");
    var result = await this.request.uploadFileData(fd);
    return result.Path;
  }
  // 获取CommonDef
  getCommonDef(projectKey) {
    var params = {
      cmd: GET_COMMON_DEF,
      service: ServiceName.WEB_META_SERVICE,
      projectKey
    };
    return this.request.getData(params);
  }
  // 获取离线相关信息服务
  getOfflineInfo() {
    var params = {
      cmd: GET_OFF_LINE_INFO,
      service: ServiceName.MOBILE_SERVICE
    };
    return this.request.getData(params);
  }
  // 验证图片
  queryValidateImage() {
    var params = {
      service: ServiceName.HTTP_AUTHENTICATE,
      cmd: QUERY_VALIDATE_IMAGE
    };
    return this.request.getData(params);
  }
  // 获取系统信息
  getSystemInfo() {
    var params = {
      service: ServiceName.GET_SYSTEM_INFO
    };
    return this.request.getData(params);
  }
  //获取TempClientID 
  getTempClientID() {
    var params = {
      service: ServiceName.HTTP_AUTHENTICATE,
      cmd: CREATE_TEMP_CLIENT_ID
    };
    return this.request.getData(params);
  }
  //获取GetLoginDef信息
  getLoginDef() {
    var params = {
      service: ServiceName.HTTP_AUTHENTICATE,
      cmd: GET_LOGIN_DEF
    };
    return this.request.getData(params);
  }
  /**
   * 重新迁移
   * @deprecated 不使用的方法
   * @see datamigrationservice
   */
  reMigrate(dataObjectKey) {
    var params = {
      service: ServiceName.MIGRATION,
      cmd: Re_MIGRATE,
      dataObjectKey
    };
    return this.request.getData(params);
  }
  uploadUIOptTraces(traceJSONArray) {
    var params = {
      service: ServiceName.UIOPTTRACE,
      cmd: "SaveUIOptTrace",
      traces: JSON.stringify(traceJSONArray)
    };
    return this.request.getData(params);
  }
  loadUIOptTraces(conditionParas) {
    var params = {
      service: ServiceName.UIOPTTRACE,
      cmd: "LoadUIOptTrace",
      conditionParas: JSON.stringify(conditionParas)
    };
    return this.request.getData(params);
  }
}
class ExceptionDialog {
  constructor(options2) {
    this.msg = options2.msg;
    this.title = options2.title;
    this.events = options2.events;
    this.closeEvent = options2.closeEvent;
    this.errorStack = options2.errorStack;
  }
  show() {
    var options2 = {
      msg: this.msg,
      errorStack: this.errorStack,
      headerTitle: this.title,
      events: this.events,
      panelSize: void 0,
      closeEvent: this.closeEvent,
      type: "error"
    };
    var dialog = DialogFactory.create(options2);
    dialog.show();
  }
}
class BaseDialogProvider {
  static create(option) {
    if (BaseDialogProvider.instance) {
      return BaseDialogProvider.instance.create(option);
    } else {
      return null;
    }
  }
  static setInstance(i2) {
    BaseDialogProvider.instance = i2;
  }
}
class BaseDialog extends CommonDialog {
  constructor(options2) {
    super(options2);
    this.dialog = BaseDialogProvider.create(options2);
  }
}
class ReLoginDialog {
  static async show() {
    var result = await SvrMgr.verifyClientID();
    if (result == null) {
      return location.reload();
    }
    const user = I18N.getString("LOGIN_USERNAME", "用户名");
    const password = I18N.getString("LOGIN_PASSWORD", "密码");
    var code = I18N.getString("DIALOG_VALIDATECODE", "验证码");
    const html_login = '<div class="login-content"><span class="username">' + user + '</span><div class="login-user"><input type="text" placeholder=' + user + ' readonly/></div><span class="password">' + password + '</span><div class="login-psd"><input type="password" placeholder=' + password + ' /><span class="show-switch closed"></span></div><span class="validcode">' + code + '</span><div class="login-valid"><input type="text" placeholder=' + code + ' /><img class="relogin_valid_img"/></div><div class="login-btns"><div class="login">' + I18N.getString("LOGIN_LOGINBTN", "登录") + '</div><div class="reset">' + I18N.getString("DIALOG_RETURN", "返回") + "</div></div></div>";
    this.def = await SvrMgr.getLoginDef();
    this.modalDialog = new BaseDialog({
      //theme: "#7d53c9",
      headerTitle: I18N.getString("LOGIN_USERLOGIN", "用户登录"),
      panelSize: "400 250",
      className: { "panel": "relogin-modal dialog show", "title": "dialog-title", "btn-close": "dialog-close" },
      content: html_login,
      ziBase: 8888
    });
    this.modalDialog.show();
    this.setValid();
    this.install();
  }
  static setValid() {
    var dialog = this.modalDialog.getDialogEl();
    async function refreshValidateCode() {
      let id = CookiesUtil.get("tmpClientID");
      if (!id) {
        id = await SvrMgr.getTmpClientID();
        CookiesUtil.set("tmpClientID", id);
      }
      const { result } = await SvrMgr.validateImage({ tmpclientid: id });
      var img = dialog.querySelector(".relogin_valid_img");
      img.setAttribute("src", "data:image/png;base64," + result);
    }
    if (this.def && this.def.valid) {
      refreshValidateCode();
      dialog.querySelector(".relogin_valid_img").addEventListener("click", function() {
        refreshValidateCode();
      });
    } else {
      dialog.querySelector(".validcode").remove();
      dialog.querySelector(".login-valid").remove();
    }
  }
  static install() {
    var dialog = this.modalDialog.getDialogEl();
    var self = this;
    this.user = dialog.querySelector(".login-user input");
    this.user.value = SessionInfo.getUserName();
    this.psd = dialog.querySelector(".login-psd input");
    dialog.querySelector(".show-switch").addEventListener("click", function() {
      this.classList.toggle("closed");
      if (this.classList.contains("closed")) {
        self.psd.setAttribute("type", "password");
      } else {
        self.psd.setAttribute("type", "text");
      }
    });
    dialog.querySelector(".login").addEventListener("click", function() {
      var password = self.psd.value;
      var valid = dialog.querySelectorAll(".login-valid input")[0];
      var validCode = valid && valid.value;
      SvrMgr.doLoginByClientID(password, validCode).then(function(ret) {
        self.modalDialog.close();
        if (!ret) {
          var dialog2 = new ExceptionDialog({
            msg: I18N.getString("DIALOG_FAILEDMSG", "登录失败，返回登录界面!"),
            title: I18N.getString("TITLE_ERROR", "错误"),
            events: {
              "OK": function() {
                location.reload();
              }
            }
          });
          dialog2.show();
        }
      }).catch(function(error) {
        throw error;
      });
    });
    dialog.querySelector(".reset").addEventListener("click", function() {
      self.modalDialog.close();
      location.reload();
    });
  }
}
const throwE = (error, form) => {
  var msg = error.message;
  var errorStack = "";
  ExceptionStack.clear();
  if (error.code != "800A0002" || error.code != "800A0003") {
    UIOptTraceUtil.uploadTraces();
  }
  if (document.getElementsByClassName("error jsPanel").length > 0) {
    console.error(error);
    return;
  }
  if (error.noThrow) {
    return;
  }
  if (error.code == -1 || !error.code) {
    errorStack = error.stack;
  }
  var dialog = new ExceptionDialog({
    msg,
    errorStack,
    title: I18N.getString("DIALOG_ERROR", "错误"),
    closeEvent: function() {
      error.onClose && error.onClose();
    },
    events: {
      "OK": function() {
        if (error.code == "800A0002" || error.code == "800A0003") {
          ReLoginDialog.show();
        }
      }
    }
  });
  dialog.show();
};
class ExceptionStack {
  static push(e, form) {
    if (e.noThrow) {
      return;
    }
    this._e = e;
    if (this._e) {
      console.log(this._e);
    }
    var self = this;
    setTimeout(function() {
      var a = self._e;
      if (a) {
        throwE(a);
      }
    }, 50);
    return e;
  }
  static clear() {
    this._e = null;
  }
}
class WXInteractive extends Interactive {
  canInteractive() {
    var canOpt = false, ua = navigator.userAgent.toLowerCase();
    if (ua.match(/micromessenger/i) == "micromessenger") {
      canOpt = true;
    } else if (ua.match(/miniprogram/i) == "miniprogram") {
      canOpt = true;
    } else if (ua.match(/wxwork/i) == "wxwork") {
      canOpt = true;
    }
    return canOpt;
  }
  //判断是否在微信的浏览器中打开
  isInWeiXin() {
    var ua = navigator.userAgent.toLowerCase();
    return ua.match(/micromessenger/i) == "micromessenger";
  }
  //判断是否在微信小程序中的浏览器中打开
  isInWeiXinApp() {
    if (WXInteractive.isInWeiXin()) {
      var ua = navigator.userAgent.toLowerCase();
      return ua.match(/miniprogram/i) == "miniprogram";
    }
  }
  //判断是否在企业微信的浏览器中打开
  isInQyWeiXin() {
    var ua = navigator.userAgent.toLowerCase();
    return ua.match(/wxwork/i) == "wxwork";
  }
  getWXConfigInfo() {
    return new Promise((resolve2) => {
      var paras = {
        "url": location.href,
        "thirdAppType": WXInteractive.isInQyWeiXin() ? "qywx" : "wx"
      };
      new RemoteService().getThirdAppEnvInfo(paras).then(function(configInfo) {
        resolve2(configInfo);
      }).fail(function(e) {
        ExceptionStack.clear();
        console.log(e);
      });
    });
  }
  initConfig() {
    if (!WXInteractive.isInWeiXin())
      return;
    WXInteractive.getWXConfigInfo().then(function(configInfo) {
      if (configInfo) {
        WXInteractive.wx_configInfo = configInfo;
        wx.config({
          beta: true,
          debug: false,
          // 开启调试模式,调用的所有api的返回值会在客户端alert出来,测试完成后需要关闭。
          appId: configInfo.appid,
          // 必填，公众号的唯一标识
          timestamp: configInfo.timestamp,
          // 必填，生成签名的时间戳
          nonceStr: configInfo.noncestr,
          // 必填，生成签名的随机串
          signature: configInfo.signature,
          // 必填，签名（加密后，下文有实现）
          // 必填，需要使用的JS接口列表，开发文档上有所有接口名称，根据需要选用就好。
          jsApiList: [
            "closeWindow",
            "chooseImage",
            "getLocation",
            "openLocation",
            "getLocalImgData",
            "scanQRCode",
            "getNetworkType",
            "addCard",
            "chooseCard",
            "openCard",
            "chooseInvoice",
            "chooseInvoiceTitle"
          ]
        });
      }
      wx.ready(function() {
        console.log("WXInteractive init success");
      });
      wx.error(function(res) {
        console.log("WXInteractive init error:" + res);
      });
    });
    wx.miniProgram.getEnv(function(res) {
      WXInteractive.isMiniProgram = res.miniprogram;
    });
  }
  supportWeiXinShare() {
    return new Promise((resolve2) => {
      resolve2("false");
    });
  }
  shareToWeiXin(shareFormKey, shareOid, onlyText, title, description, thumbImage) {
    return new Promise((resolve2) => {
      resolve2("false");
    });
  }
  callPhone(phoneNum) {
    return new Promise((resolve2) => {
      var telA = document.createElement("a");
      telA.setAttribute("href", 'tel:" + phoneNum + "');
      telA.click();
      resolve2("true");
    });
  }
  getLocation() {
    return new Promise((resolve2) => {
      wx.getLocation({
        type: "gcj02",
        success(res) {
          console.log(JSON.stringify(res));
          resolve2(JSON.stringify(res));
        },
        fail(res) {
          resolve2("");
        },
        cancel(res) {
          resolve2("");
        }
      });
    });
  }
  getLastLocation() {
    return WXInteractive.getLocation();
  }
  getLocationAddress() {
    return new Promise((resolve2) => {
      wx.getLocation({
        type: "gcj02",
        success(res) {
          let locationString = res.latitude + "," + res.longitude;
          axios({
            url: "https://apis.map.qq.com/ws/geocoder/v1/",
            data: {
              "key": "6AMBZ-MQV6P-WPYDG-LTUZL-FCD72-FZBXJ",
              "location": locationString,
              "output": "jsonp"
            },
            type: "get",
            dataType: "jsonp",
            success(res2) {
              resolve2(res2.result.address);
            },
            fail(res2) {
              resolve2("");
            },
            error(xhr, status, e) {
              defer.reject("");
            }
          });
        },
        fail(res) {
          resolve2("");
        },
        cancel(res) {
          resolve2("");
        }
      });
    });
  }
  openLocation(location2) {
    return new Promise((resolve2) => {
      wx.openLocation({
        latitude: location2.latitude,
        longitude: location2.longitude,
        name: "",
        // 位置名
        address: "",
        // 地址详情说明
        scale: 18,
        // 地图缩放级别,整型值,范围从1~28。默认为最大
        infoUrl: "",
        // 在查看位置界面底部显示的超链接,可点击跳转
        success(res) {
          resolve2("true");
        },
        fail(res) {
          resolve2("false");
        },
        cancel(res) {
          resolve2("false");
        }
      });
    });
  }
  getNetWorkInfo() {
    return new Promise((resolve2) => {
      var result = { Available: false, Type: -1, TypeName: "" };
      wx.getNetworkType({
        success(res) {
          var networkType = res.networkType;
          result.Available = true;
          if (networkType.equalsIgnoreCase("wifi")) {
            result.Type = 4;
            result.TypeName = "WIFI";
          } else {
            result.Type = 2;
            result.TypeName = "MOBILE";
          }
          resolve2(JSON.stringify(result));
        },
        fail() {
          resolve2(JSON.stringify(result));
        },
        cancel() {
          resolve2(JSON.stringify(result));
        }
      });
    });
  }
  scanBarCode() {
    return new Promise((resolve2) => {
      var result = { Contents: "", FormatName: "", RawBytes: "", Orientation: "", ErrorCorrectionLevel: "" };
      wx.scanQRCode({
        needResult: 1,
        // 默认为0，扫描结果由微信处理，1则直接返回扫描结果，
        scanType: ["qrCode", "barCode"],
        // 可以指定扫二维码还是一维码，默认二者都有
        success(res) {
          if (res.resultStr.indexOf(",") >= 0) {
            var codeStrArray = res.resultStr.split(",");
            result.FormatName = codeStrArray[0];
            result.Contents = codeStrArray[1];
          } else {
            result.FormatName = "QR";
            result.Contents = res.resultStr;
          }
          resolve2(JSON.stringify(result));
        },
        fail() {
          resolve2(JSON.stringify(result));
        },
        cancel() {
          resolve2(JSON.stringify(result));
        }
      });
    });
  }
  takePhotoForUpload(formKey, oid, maxSize, provider, fileName) {
    var paras = {
      formKey,
      oid,
      maxSize,
      provider,
      fileName
    };
    return WXInteractive.takePhoto(true, paras);
  }
  takePhotoOnly(isBase64) {
    return WXInteractive.takePhoto(false, {});
  }
  takePhoto(upload, paras) {
    return new Promise((resolve2) => {
      wx.chooseImage({
        count: 1,
        // 默认9
        sizeType: ["original"],
        // 指定是原图还是压缩图，默认都有
        sourceType: ["camera"],
        // 指定来源是相册还是相机，默认都有
        success(res) {
          var localIds = res.localIds;
          if (upload) {
            WXInteractive.uploadImage(localIds[0], paras).then(function(imagePath) {
              resolve2(imagePath);
            });
          } else {
            WXInteractive.getBase64Image(localIds[0]).then(function(base64Image) {
              resolve2(base64Image);
            });
          }
        },
        fail() {
          resolve2("");
        },
        cancel() {
          resolve2("");
        }
      });
    });
  }
  selectPhotoForUpload(formKey, oid, maxSize, provider, fileName) {
    var paras = {
      formKey,
      oid,
      maxSize,
      provider,
      fileName
    };
    return WXInteractive.selectPhoto(true, paras);
  }
  selectPhotoOnly(isBase64) {
    return WXInteractive.selectPhoto(false, { "isBase64": isBase64 });
  }
  selectPhoto(upload, paras) {
    return new Promise((resolve2) => {
      wx.chooseImage({
        count: 1,
        // 默认9
        sizeType: ["original"],
        // 指定是原图还是压缩图，默认都有
        sourceType: ["album"],
        // 指定来源是相册还是相机，默认都有
        success(res) {
          var localIds = res.localIds;
          if (upload) {
            WXInteractive.uploadImage(localIds[0], paras).then(function(imagePath) {
              resolve2(imagePath);
            });
          } else {
            WXInteractive.getBase64Image(localIds[0]).then(function(base64Image) {
              resolve2(base64Image);
            });
          }
        },
        fail() {
          resolve2("");
        },
        cancel() {
          resolve2("");
        }
      });
    });
  }
  multiSelectPhotoForUpload(maxSelectNum, formKey, oid, maxSize, provider) {
    var paras = {
      maxSelectNum,
      formKey,
      oid,
      maxSize,
      provider
    };
    return WXInteractive.multiSelectPhoto(true, paras);
  }
  multiSelectPhotoOnly(maxSelectNum, isBase64) {
    return WXInteractive.multiSelectPhoto(false, { maxSelectNum });
  }
  multiSelectPhoto(upload, paras) {
    return new Promise((resolve2) => {
      wx.chooseImage({
        count: paras.maxSelectNum,
        // 默认9
        sizeType: ["original"],
        // 指定是原图还是压缩图，默认都有
        sourceType: ["album"],
        // 指定来源是相册还是相机，默认都有
        success(res) {
          var localIds = res.localIds;
          var images = [];
          if (upload) {
            localIds.forEach((subLocalId) => {
              WXInteractive.uploadImage(subLocalId, paras).then(function(imagePath) {
                images.push(imagePath);
                if (i >= localIds.length - 1) {
                  resolve2(JSON.stringify(images));
                }
              });
            });
          } else {
            localIds.forEach((subLocalId) => {
              WXInteractive.getBase64Image(subLocalId).then(function(base64Image) {
                images.push(base64Image);
                if (i >= localIds.length - 1) {
                  resolve2(JSON.stringify(images));
                }
              });
            });
          }
        },
        fail() {
          resolve2("");
        },
        cancel() {
          resolve2("");
        }
      });
    });
  }
  takeVideoOnly(isBase64) {
    return WXInteractive.selectVideo(false, { "isBase64": isBase64 });
  }
  takeVideoForUpload(formKey, oid, provider) {
    var paras = {
      formKey,
      oid,
      provider
    };
    return WXInteractive.selectVideo(true, paras);
  }
  selectVideoOnly(isBase64) {
    return WXInteractive.selectVideo(false, { "isBase64": isBase64 });
  }
  selectVideoForUpload(formKey, oid, provider) {
    var paras = {
      formKey,
      oid,
      provider
    };
    return WXInteractive.selectVideo(true, paras);
  }
  selectVideo(upload, paras) {
    return new Promise((resolve2) => {
      var fileCancle = false;
      var inputEL = document.createElement("input");
      inputEL.setAttribute("type", "file");
      inputEL.setAttribute("name", "file");
      inputEL.setAttribute("accept", "video/*");
      inputEL.className = "upload";
      var newParas = paras;
      inputEL.on("change", function(event2) {
        fileCancle = false;
        var files = event2.currentTarget.files;
        if (files.length > 0) {
          var file = files[0];
          if (upload) {
            var paras2 = Object.assign({
              file: inputEL
            }, newParas);
            new RemoteService().uploadAttachment(paras2.formKey, paras2.oid, paras2).then(function(result) {
              resolve2(result.Path);
            });
          } else {
            const fr = new FileReader();
            fr.readAsDataURL(file);
            fr.onload = (result) => {
              const base64Str = result.currentTarget.result;
              resolve2(base64Str);
            };
          }
        } else {
          resolve2("");
        }
        inputState = 0;
      });
      inputEL.click();
      fileCancle = true;
      window.addEventListener(
        "focus",
        () => {
          setTimeout(() => {
            if (fileCancle) {
              inputEl = null;
              resolve2("");
            }
          }, 100);
        },
        { once: true }
      );
    });
  }
  chooseInvoice(type) {
    return new Promise((resolve2) => {
      wx.invoke(
        "chooseInvoice",
        {
          "timestamp": WXInteractive.wx_configInfo.timestamp,
          "nonceStr": WXInteractive.wx_configInfo.noncestr
        },
        function(res) {
          alert(JSON.stringify(res));
          resolve2(JSON.stringify(res));
        }
      );
    });
  }
  /**
   * 支付
   * @param {String} outTradeNo 支付表单的编号，即订单号
   * @param {String} totalFee 支付金额
   * @param {String} detail 支付时，显示在支付界面的订单详情
   * @returns {Boolean} 支付成功与否
   */
  pay(outTradeNo, totalFee, detail, payUIPagePath) {
    return new Promise((resolve2) => {
      if (WXInteractive.isMiniProgram) {
        let payData = { outTradeNo, totalFee, detail };
        let payDataStr = JSON.stringify(payData);
        wx.miniProgram.navigateTo({
          url: payUIPagePath + "?payDataStr=" + payDataStr,
          fail() {
            console.log("fail");
            resolve2("");
          }
        });
        var windowFocusEvent = function() {
          console.log("window.focus");
          window.removeEventListener("focus", windowFocusEvent);
          var paras = {
            optType: "getPayResult",
            outTradeNo
          };
          new DataService().invokeService("PaymentService", paras).then(function(result) {
            resolve2(result);
          }).catch((err) => {
            resolve2("");
          });
        };
        window.addEventListener("focus", windowFocusEvent);
      }
    });
  }
  /**
   * 退款
   * @param {String} outTradeNo 	支付表单的编号，即订单号
   * @param {String} outRefundNo  退款表单的编号，即订单号
   * @param {String} totalAmount 	支付金额
   * @param {String} refundAmount 	退款金额
   * @returns {Boolean} 退款成功与否
   */
  refund(outTradeNo, outRefundNo, totalAmount, refundAmount) {
    return new Promise((resolve2) => {
      if (WXInteractive.isMiniProgram) {
        let refundDatas = {
          outTradeNo,
          outRefundNo,
          totalAmount,
          refundAmount,
          optType: "refund"
        };
        new DataService().invokeService("PaymentService", refundDatas).then(function(result) {
          resolve2(result);
        }).catch((err) => {
          console.log(err);
          resolve2(false);
        });
      }
    });
  }
  getBase64Image(localId) {
    return new Promise((resolve2) => {
      wx.getLocalImgData({
        localId,
        success(res) {
          var localData = res.localData;
          if (localData.indexOf("data:image") !== 0) {
            localData = "data:image/jpeg;base64," + localData;
          }
          resolve2(localData);
        },
        fail() {
          resolve2("");
        }
      });
    });
  }
  uploadImage(localId, paras) {
    return new Promise((resolve2) => {
      wx.getLocalImgData({
        localId,
        success(res) {
          var localData = res.localData;
          if (localData.indexOf("data:image") !== 0) {
            localData = "data:image/jpeg;base64," + localData;
          }
          new RemoteService().uploadImageAttachment(localData, paras).then(function(result) {
            resolve2(result);
          });
        },
        fail() {
          resolve2("");
        }
      });
    });
  }
}
InterActiveFactory.setInteractive(new WXInteractive());
class WindowsInteractive extends Interactive {
  constructor() {
    super(...arguments);
    this.callbackID = 0;
  }
  canInteractive() {
    var canOpt = false;
    if (window.YigoWinMobile != null) {
      canOpt = true;
    }
    return canOpt;
  }
  opt(paras) {
    if (window.YigoWinMobile != null) {
      window.YigoWinMobile.PostMessage(JSON.stringify(paras));
      return true;
    }
    return false;
  }
  doAction(paras, callback) {
    return new Promise((resolve2) => {
      var callbackName = paras.functionName + Interactive.callbackID++ + "_callback";
      paras.callback = callbackName;
      var interActiveCallback = function(result) {
        resolve2(result);
        setTimeout(() => {
          delete window[paras.callback];
        }, 500);
      };
      window[callbackName] = callback == null ? interActiveCallback : callback;
      if (parent) {
        parent[callbackName] = callback == null ? interActiveCallback : callback;
      }
      this.opt(paras);
    });
  }
  /**
   * 向硬件设备传cookie
   * @param {String} cookie 当前请求的cookie信息
   * @returns {Boolean} 是否保存成功
   */
  saveCookie(cookie) {
    var paras = {
      functionName: "saveCookie",
      cookie
    };
    if (this.canInteractive()) {
      return this.doAction(paras).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
       * 将数据存储到本地数据缓存中
       * @param {String} key 数据对应的标识
       * @param {String} value 数据内容
       * @returns {Boolean} 是否保存成功
       */
  saveLocalData(key, value) {
    var paras = {
      functionName: "saveLocalData",
      key,
      value
    };
    if (this.canInteractive()) {
      return this.doAction(paras).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2(false);
    });
  }
  /**
   * 从本地数据缓存中，获取对应的数据
   * @param {String} key 数据对应的标识
   * @returns {String} 获取到的对应数据
   */
  loadLocalData(key) {
    var paras = {
      functionName: "loadLocalData",
      key
    };
    if (this.canInteractive()) {
      return this.doAction(paras).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 打开系统设置界面
   * @returns 成功与否
   */
  OpenSystemConfig() {
    if (this.canInteractive()) {
      var paras = {
        functionName: "openSystemConfig"
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 获取当前WebSocket服务的运行状态
   * @returns 返回JSON对象，格式为：{status: 0-停止/1-运行中, port:xxxx}
   */
  GetNetStatus() {
    if (this.canInteractive()) {
      var paras = {
        functionName: "getNetStatus"
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 获取当前WebSocket服务的标识集合
   * @returns 返回JSONArray对象
   */
  GetNetServerKeys() {
    if (this.canInteractive()) {
      var paras = {
        functionName: "getNetServerKeys"
      };
      return this.doAction(paras).then(function(result) {
        return JSON.parse(result);
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 通过端口启动WebSocket服务
   * @param {string} key 服务标识
   * @param {string} type 服务类型，目前值只支持：WebSocket
   * @param {string} port 端口号
   * @param {boolean} isLocalOnly 是否只允许本地连接
   * @returns 启动成功与否
   */
  StartNetByKey(key, type, port, isLocalOnly) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "startNetByKey",
        key,
        type,
        port,
        isLocalOnly
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 通过端口停止对应WebSocket服务
   * @param {string} key 服务标识
   * @returns 停止服务成功与否
   */
  StopNetByKey(key) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "stopNetByKey",
        key
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 打开默认摄像头
   * @returns 打开成功与否
   */
  OpenCamera() {
    if (this.canInteractive()) {
      var paras = {
        functionName: "openCamera"
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 关闭默认摄像头
   * @returns 关闭成功与否
   */
  CloseCamera() {
    if (this.canInteractive()) {
      var paras = {
        functionName: "closeCamera"
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 使用默认摄像头开始录像
   * @returns 录像开始与否
   */
  StartVideo(fileName, fileType) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "startVideo",
        fileName,
        fileType
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 停止默认摄像头录像
   * @returns 录像停止与否
   */
  StopVideo() {
    if (this.canInteractive()) {
      var paras = {
        functionName: "stopVideo"
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 使用默认摄像头拍照
   * @returns 拍照成功与否
   */
  TakePhotoOnly(fileName) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "takePhotoOnly",
        fileName
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 上传摄像头相关录像文件、照片
   * @returns 上传成功与否
   */
  CameraUpload(uploadUrl, fileName) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "cameraUpload",
        uploadUrl,
        fileName
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 遍历摄像头服务本地文件池
   * @param formKey 执行公式所在表单的标识
   * @param callbackFunction 遍历回调函数，在回调callback函数中，可以通过Para("CameraPooledFiles_FileName")来获取当前文件名称
   */
  CameraPooledFiles(formKey, callbackFunction) {
    if (this.canInteractive()) {
      var paras = {
        formKey,
        functionName: "cameraPooledFiles",
        callbackFunction
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  /**
   * 摄像头服务本地文件池中的文件总数
   * @returns 返回本地文件总数
   */
  CameraPooledFilesCount() {
    if (this.canInteractive()) {
      var paras = {
        functionName: "cameraPooledFilesCount"
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  //--------------------------------------------打印服务接口-----开始------------------------------------------//
  PrintPDFByBase64(printTaskStr, content) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "printPDFByBase64",
        printTaskStr,
        content
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    }
    return new Promise((resolve2) => {
      resolve2("");
    });
  }
  //--------------------------------------------打印服务接口-----结束------------------------------------------//
  //--------------------------------------------离线使用接口-----开始------------------------------------------//
  /** 保存静态对象到本地数据库中
   * @param key 静态对象存储的唯一标识
   * @param {JSON} saveObj 静态对象
   * @returns 是否保存成功
   */
  saveLocalObject(key, saveObj) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "saveLocalObject",
        key,
        object: saveObj
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    } else {
      return new Promise((resolve2) => {
        resolve2("");
      });
    }
  }
  /** 从本地数据库中获取静态对象
   * @param key 静态对象存储的唯一标识
   * @returns 静态对象
   */
  getLocalObject(key) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "getLocalObject",
        key
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    } else {
      return new Promise((resolve2) => {
        resolve2("");
      });
    }
  }
  /** 保存文件对象到本地数据库中
   * @param key 文件对象存储的唯一标识
   * @param {JSON} saveObj 文件对象
   * @returns 是否保存成功
   */
  saveLocalFile(key, saveObj) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "saveLocalFile",
        key,
        object: saveObj
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    } else {
      return new Promise((resolve2) => {
        resolve2("");
      });
    }
  }
  /** 从本地数据库中获取文件对象
   * @param key 文件对象存储的唯一标识
   * @returns 文件对象
   */
  getLocalFile(key) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "getLocalFile",
        key
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    } else {
      return new Promise((resolve2) => {
        resolve2("");
      });
    }
  }
  /** 保存数据对象到本地数据库中
   * @param dataObjectKey 数据对象的配置对象标识
   * @param {JSON} document 数据对象
   * @returns 是否保存成功
   */
  saveLocalDocument(dataObjectKey, document2) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "saveDocument",
        dataObjectKey,
        document: document2
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    } else {
      return new Promise((resolve2) => {
        resolve2("");
      });
    }
  }
  /** 从本地数据库中获取数据对象
   * @param dataObjectKey 数据对象对应的表单标识
   * @returns 数据对象
   */
  getLocalDocument(dataObjectKey, oid) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "getDocument",
        dataObjectKey,
        oid
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    } else {
      return new Promise((resolve2) => {
        resolve2("");
      });
    }
  }
  /**	依据查询条件，查询本地数据，返回对应的数据对象
   * @param dataObject 数据对象对应的配置对象
   * @param document 表单的数据对象JSON化
   * @param {JSON} filterMap 查询条件
   * @param {JSON} condParas 查询条件
   * @param {JSON} paras 查询条件
   * @returns 查询后的数据对象
   * 
   */
  queryLocalDocument(dataObject, document2, filterMap, condParas, paras, showDeleted) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "queryDocument",
        dataObject,
        document: document2,
        filterMap,
        condParas,
        paras,
        showDeleted
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    } else {
      return new Promise((resolve2) => {
        resolve2("");
      });
    }
  }
  saveFormData(form) {
    if (this.canInteractive()) {
      var formParas = form.getParas(), dataObj = form.getDataObject();
      formDoc = form.getDocument();
      formDoc = DataUtil$1.toJSONDoc(formDoc, true);
      var paras = {
        functionName: "saveFormData",
        document: formDoc,
        dataObject: dataObj,
        paras: formParas
      };
      return this.doAction(paras).then(function(result) {
        return DataUtil$1.fromJSONDoc(result);
      });
    } else {
      return new Promise((resolve2) => {
        resolve2("");
      });
    }
  }
  deleteFormData(dataObjectKey, oid) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "deleteFormData",
        dataObjectKey,
        oid
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    } else {
      return new Promise((resolve2) => {
        resolve2("");
      });
    }
  }
  applyNewOID() {
    if (this.canInteractive()) {
      var paras = {
        functionName: "applyNewOID"
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    } else {
      return new Promise((resolve2) => {
        resolve2("");
      });
    }
  }
  //移除本地数据库中的对应Document对象
  removeLocalDocument(dataObjectKey, oid) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "removeFormData",
        dataObjectKey,
        oid
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    } else {
      return new Promise((resolve2) => {
        resolve2("");
      });
    }
  }
  getDictDataByFilter(itemKey, formKey, filter) {
    if (this.canInteractive()) {
      var paras = {
        functionName: "getDictData",
        itemKey,
        formKey,
        filter
      };
      return this.doAction(paras).then(function(result) {
        return result;
      });
    } else {
      return new Promise((resolve2) => {
        resolve2("");
      });
    }
  }
  //--------------------------------------------离线使用接口-----结束------------------------------------------//
}
InterActiveFactory.setInteractive(new WindowsInteractive());
var request$1 = new Request$1();
class SvrMgr {
  constructor() {
  }
  static doLogin(username, password, sessionPara, validateCode, tmpClientID, mode) {
    return this.getPublicKey().then(function(publicKey) {
      var loginInfo = {};
      loginInfo.user = username;
      loginInfo.password = password;
      loginInfo.validatecode = validateCode;
      loginInfo.mode = mode || 1;
      var str1 = JSON.stringify(loginInfo);
      let data2 = RSAUtil.encrypt_b64(publicKey, str1);
      if (typeof sessionPara !== "string") {
        sessionPara = JSON.stringify(sessionPara || {});
      }
      var opts = {
        logininfo: data2,
        tmpclientid: tmpClientID || "",
        paras: sessionPara,
        cmd: "Login",
        service: "Authenticate"
      };
      return request$1.getData(opts).then(function(result) {
        if (result) {
          CookiesUtil.set("tmpClientID", null);
          var time = result.Time;
          var date = new Date(time);
          var dateStr = Utils.dateFormat(date, "yyyy/MM/dd HH:mm:ss");
          if (result.SessionParas) {
            var sessionData = result.SessionParas;
            if (typeof sessionData === "string") {
              sessionData = JSON.parse(sessionData);
            }
            SessionParasCache.setParas(sessionData);
          }
          SessionInfo.setCode(username);
          SessionInfo.setUserName(result.Name);
          SessionInfo.setUserID(result.UserID);
          SessionInfo.setClusterID(result.clusterID);
          SessionInfo.setLoginTime(dateStr);
          return OperatorParas.clear().then(() => {
            return result;
          });
        }
        return false;
      });
    });
  }
  static doLoginByClientID(password, validateCode) {
    return this.getPublicKey().then(function(publicKey) {
      var loginInfo = {};
      loginInfo.password = password;
      loginInfo.validatecode = validateCode;
      var str1 = JSON.stringify(loginInfo);
      var data2 = RSAUtil.encrypt_b64(publicKey, str1);
      var opts = {
        logininfo: data2,
        tmpclientid: CookiesUtil.get("tmpClientID") || "",
        cmd: "LoginByClientID",
        service: "Authenticate"
      };
      return request$1.getData(opts).then(function(result) {
        if (result) {
          var time = result.Time;
          var date = new Date(time);
          var dateStr = Utils.dateFormat(date, "yyyy/MM/dd HH:mm:ss");
          SessionInfo.setLoginTime(dateStr);
          return result;
        }
        return false;
      });
    });
  }
  // 默认异步注销
  static doLogout(paras = {}, callback) {
    paras = Object.assign(
      {
        cmd: "Logout",
        service: "Authenticate"
      },
      paras
    );
    return request$1.getData(paras).then(() => {
      callback && callback();
    });
  }
  // 获取游客登录的clientID;
  static touristLogin() {
    let paras = {
      cmd: "TouristLogin",
      service: "Authenticate",
      async: true,
      isYES2: true
    };
    return request$1.getData(paras).then(function(result) {
      SessionInfo.setCode(result.username);
      SessionInfo.setUserName(result.Name);
      SessionInfo.setUserID(result.UserID);
      SessionInfo.setClusterID(result.clusterID);
      InterActiveFactory.Interactive.saveCookie({ "clientID": result.clientID });
      return result;
    });
  }
  // 校验clientID是否有效;
  static checkSession() {
    var paras = {
      cmd: "CheckSession",
      service: "HttpAuthenticate"
    };
    return request$1.getData(paras);
  }
  // 获取后台sessionInfo的信息;
  static async getSessionInfo() {
    let result = SessionParasCache.getParas();
    if (!Object.keys(result).length) {
      var paras = {
        cmd: "GetSessionInfo",
        service: "HttpAuthenticate"
      };
      result = await request$1.getData(paras);
    }
    return result;
  }
  static getPublicKey() {
    let params = {
      service: "GetPublicKey"
    };
    return request$1.getData(params);
  }
  // 获取登录时界面显示信息
  static getTmpClientID(paras) {
    paras = Object.assign(
      {
        service: "HttpAuthenticate",
        cmd: "CreateTempClientID"
      },
      paras
    );
    return request$1.getData(paras);
  }
  // 获取登录时界面显示信息
  static getLoginDef(paras) {
    paras = Object.assign(
      {
        service: "HttpAuthenticate",
        cmd: "GetLoginDef"
      },
      paras
    );
    return request$1.getData(paras);
  }
  // 获取验证码图片
  static validateImage(paras) {
    paras = Object.assign(
      {
        service: "HttpAuthenticate",
        cmd: "QueryValidateImage"
      },
      paras
    );
    return request$1.getData(paras);
  }
  static loadSessionParaItems(data2) {
    return request$1.getData({
      service: "HttpAuthenticate",
      cmd: "LoadSessionParaItems",
      user: data2.user,
      provider: data2.provider,
      paras: JSON.stringify(data2.paras)
    });
  }
  static cutImg(paras) {
    paras = Object.assign({
      url: ServletURL,
      service: "CutImage"
    }, paras);
    return request$1.getData(paras);
  }
  static loadGanttData(paras, success) {
    paras = Object.assign({
      url: ServletURL,
      service: "Gantt",
      cmd: "LoadGanttData"
    }, paras);
    return request$1.getData(paras);
  }
  static saveGanttData(paras, success) {
    paras = Object.assign({
      url: ServletURL,
      service: "Gantt",
      cmd: "SaveGanttData"
    }, paras);
    return request$1.getData(paras).then((data2) => {
      success(data2);
    });
  }
  static loadForm(paras, success) {
    paras = Object.assign({
      url: ServletURL,
      service: "LoadForm"
    }, paras);
    return request$1.getData(paras).then((data2) => {
      success(data2);
    });
  }
  static loadi18nData(replaceStrings = false) {
    var paras = {
      url: ServletURL,
      service: "GetLocalStrings",
      version: I18N.geti18nVersion()
    };
    return request$1.getData(paras).then((strings) => {
      if (strings) {
        I18N.seti18nVersion(strings.version);
        if (replaceStrings) {
          I18N.seti18nStrings(strings);
        }
      }
      I18N.setLastCheckTime((/* @__PURE__ */ new Date()).getTime());
      return strings;
    }).catch((e) => {
      console.log(e);
    });
  }
}
SvrMgr.reqMap = {};
SvrMgr.baseurl = Service;
SvrMgr.getStartForm = function() {
  var getMobileType = function() {
    var u = navigator.userAgent;
    if (u.indexOf("Android") > -1 || u.indexOf("Adr") > -1) {
      return "Android";
    } else if (!!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/)) {
      return "ios";
    } else {
      return "pc";
    }
  };
  var paras = {
    service: "WebMetaService",
    cmd: "GetStartItem",
    platform: getMobileType()
  };
  return request$1.getData(paras);
};
SvrMgr.getSupportLang = () => request$1.getData({
  service: "HttpAuthenticate",
  cmd: "GetSupportLang"
});
SvrMgr.getSystemInfo = () => {
  return request$1.getData({
    service: "GetSystemInfo",
    cmd: "do"
  });
};
SvrMgr.getProjectSystemInfo = () => {
  return request$1.getData({
    service: "GetProjectSystemInfo",
    cmd: "do"
  }).catch((err) => {
    return {};
  });
};
SvrMgr.getLicenseInfo = () => {
  return request$1.getData({
    service: "SystemInfo",
    cmd: "GetLicenseInfo"
  });
};
SvrMgr.getAppList = () => {
  return request$1.getData({
    service: "GetAppList",
    cmd: "do"
  });
};
SvrMgr.getBase64Image = (params) => {
  return new Base64ImageService(null).loadBase64Image(params.path, params.thumbnail, params.sourceType, params.project, params.formKey);
};
SvrMgr.loadPreference = function(formKey) {
  var params = {
    service: "Preference",
    cmd: "LoadPreference",
    key: formKey
  };
  return request$1.getData(params);
};
SvrMgr.savePreference = function(formKey, data2) {
  var params = {
    service: "Preference",
    cmd: "SavePreference",
    key: formKey,
    prefData: JSON.stringify(data2)
  };
  return request$1.getData(params);
};
SvrMgr.ErrorUtilsLogin = function(arg) {
  return request$1.errorUtilsLogin(arg);
};
SvrMgr.verifyClientID = () => {
  var opts = {
    overtimeCheck: true,
    cmd: "GetSessionInfo",
    service: "Authenticate"
  };
  return request$1.getData(opts);
};
SvrMgr.checkInfo = () => {
  let c = [67, 104, 101, 99, 107, 69, 120, 112, 105, 114, 101, 100];
  var opts = {
    mode: Request$1.mode,
    cmd: String.fromCharCode.apply(null, c),
    service: "YigoInfo"
  };
  return request$1.getData(opts);
};
let isShow = false;
let popSize = 0;
let showTimeId$1 = null;
let startTimeId = null;
let isMaskLoading = false;
class LoadingUtil {
  static createHtml() {
    this.mask = document.createElement("div");
    this.mask.className = "loading mask";
    let imgInner = document.createElement("image");
    imgInner.className = "loading image";
    this.img = document.createElement("div");
    this.img.className = "loading-box";
    let label = document.createElement("label");
    label.className = "loading-text";
    label.innerText = window.getLoadingText();
    this.img.appendChild(imgInner);
    this.img.appendChild(label);
    document.body.appendChild(this.mask);
    document.body.appendChild(this.img);
  }
  static show(time) {
    if (!this.mask) {
      this.createHtml();
    }
    isMaskLoading = true;
    time = time || this.delayTime;
    popSize++;
    isShow = true;
    var self = this;
    if (!showTimeId$1 && this.img.style.display != "block") {
      showTimeId$1 = setTimeout(function() {
        if (isShow) {
          self.mask.style.display = "block";
          self.img.style.display = "block";
        }
      }, time);
    }
  }
  static hide() {
    if (--popSize > 0) {
      return;
    }
    isShow = false;
    var self = this;
    setTimeout(function() {
      if (!isShow) {
        if (self.mask) {
          self.mask.style.display = "none";
          self.img.style.display = "none";
        }
        popSize = 0;
        showTimeId$1 = null;
        isMaskLoading = false;
        isShow = false;
      }
    }, 300);
  }
  static start() {
    if (!isShow) {
      return;
    }
    var self = this;
    startTimeId = setTimeout(function() {
      if (isShow) {
        self.mask.style.display = "block";
        self.img.style.display = "block";
        isMaskLoading = true;
      }
    }, 300);
  }
  static stop() {
    if (!isShow) {
      return;
    }
    clearTimeout(showTimeId$1);
    clearTimeout(startTimeId);
    this.mask.style.display = "none";
    this.img.style.display = "none";
    isMaskLoading = false;
  }
  static isloading() {
    return isMaskLoading;
  }
  static isShowing() {
    return isShow;
  }
}
LoadingUtil.delayTime = RequestSetting.delayTime;
class FieldUtil {
  static isOtherField(fieldKey) {
    return fieldKey && fieldKey.endsWith("_NODB4Other");
  }
}
const regExp$1 = /^#[0-9a-fA-F]{6}$/;
class BaseHandler {
  static formatDate(date, format) {
    return Utils.dateFormat(date, format);
  }
  static convertValue(value, type) {
    var ret;
    switch (type) {
      case DataType.STRING:
        ret = TypeConvertor.toString(value);
        break;
      case DataType.INT:
      case DataType.LONG:
      case DataType.DOUBLE:
      case DataType.FLOAT:
      case DataType.NUMERIC:
        ret = TypeConvertor.toDecimal(value);
        break;
      case DataType.BOOLEAN:
        ret = value ? true : false;
        break;
      case DataType.DATE:
      case DataType.DATETIME:
        ret = TypeConvertor.toDate(value);
        break;
      default:
        ret = value;
    }
    return ret;
  }
  static doOnClick(formID2, formula, ...args) {
    var form = FormStack.getForm(formID2);
    return form == null ? void 0 : form.asyncEval(formula);
  }
  static doEval(formID2, formula) {
    var form = FormStack.getForm(formID2);
    return form == null ? void 0 : form.asyncEval(formula);
  }
  /** 值变化逻辑 */
  static async doValueChanged(control, commitValue, editing, fireEvent, ignoreFireValueChanged) {
    console.time("==doValueChanged======" + control.key + "==");
    const _setOtherFieldValueToDocument = function(form2, control2, newValue) {
      const type = control2.type;
      const fieldKey = control2.key;
      if (newValue != null) {
        switch (type) {
          case ControlType.DICT:
          case ControlType.DYNAMICDICT:
          case ControlType.COMPDICT:
            if (control2.multiSelect) {
              if (newValue.length > 0) {
                let str = "";
                for (let i2 = 0; i2 < newValue.length; i2++) {
                  if (newValue[i2] instanceof ItemData) {
                    str += "," + newValue[i2].oid;
                  } else {
                    str += "," + newValue;
                  }
                }
                form2.getDocument().setOtherFieldValue(fieldKey, str.substring(1));
              }
            } else {
              if (newValue instanceof ItemData) {
                form2.getDocument().setOtherFieldValue(fieldKey, newValue.oid);
              } else {
                if (control2.isEditValue) {
                  form2.getDocument().setOtherFieldValue(fieldKey, newValue);
                } else {
                  form2.getDocument().setOtherFieldValue(fieldKey, TypeConvertor.toLong(newValue));
                }
              }
            }
            break;
          case ControlType.NUMBEREDITOR:
            form2.getDocument().setOtherFieldValue(fieldKey, TypeConvertor.toDecimal(newValue));
            break;
          case ControlType.DATEPICKER:
            form2.getDocument().setOtherFieldValue(fieldKey, TypeConvertor.toLong(newValue));
            break;
          default:
            form2.getDocument().setOtherFieldValue(fieldKey, newValue);
        }
      } else {
        form2.getDocument().deleteOtherFieldValue(fieldKey);
      }
    };
    const form = control.getForm();
    if (!form) {
      return;
    }
    const monitor = form.getViewDataMonitor();
    const document2 = form.getDocument();
    if (!document2) {
      return;
    }
    let meta = control.getMetaObj();
    if (meta.codeComponentKey) {
      let codeCom = form.getComponent(meta.codeComponentKey);
      codeCom.__setValue(this.getRealCode(meta.displayCols, control.value));
    }
    if (commitValue) {
      const tableKey = control.tableKey, columnKey = control.columnKey;
      const dataTable = document2.getByKey(tableKey);
      if (FieldUtil.isOtherField(control.key)) {
        _setOtherFieldValueToDocument(form, control, control.value);
      } else if (dataTable && dataTable.tableMode != TableMode.HEAD) {
        const dataType = dataTable.getColByKey(control.columnKey).type;
        const value = this.convertValue(control.value, dataType);
        document2.setHeadValue(control.key, value);
        if (dataTable) {
          const oldPos = dataTable.pos;
          dataTable.beforeFirst();
          while (dataTable.next()) {
            this.setValueToDocument(form, control, control.value, dataTable.getBkmk());
          }
          dataTable.setPos(oldPos);
        }
      } else if (control.isSubDetail) {
        if (tableKey && columnKey || control.bindingCellKey) {
          await this.setSubDetailValueToDocument(form, control, control.value, fireEvent);
        }
      } else {
        if (tableKey && columnKey) {
          this.setValueToDocument(form, control, control.value);
        }
      }
    }
    if (!ignoreFireValueChanged) {
      if (!(form.formKey === "D_GridFieldModule" && control.key === "Key")) {
        await monitor.preValueChanged(control);
      }
    }
    form.setOldValue(control.key, control.getOldValue());
    if (fireEvent) {
      LoadingUtil.show();
      try {
        await monitor.valueChanged(control);
      } finally {
        LoadingUtil.hide();
      }
    }
    form.setOldValue(null, null);
    await monitor.postValueChanged(control);
    if (fireEvent && this.isVariantDep(form, control.key)) {
      await monitor.refreshVariant(true);
    }
    console.timeEnd("==doValueChanged======" + control.key + "==");
  }
  static async initDisplayCols(form, meta, type, itemKey) {
    if (type == ControlType.DICT) {
      if (!meta.displayCols) {
        meta.displayCols = await new DictService(form).getDisplayCols(itemKey);
      }
    } else if (type == ControlType.DYNAMICDICT || type == ControlType.COMPDICT) {
      meta.displayCols = await new DictService(form).getDisplayCols(itemKey);
    }
  }
  static initCodeColumnKey(form, meta) {
    if (!meta || meta.codeColumnKey !== void 0) {
      return;
    }
    let doc = form.getDocument();
    let tableKey = Utils.isUndefined(meta.dataBinding) ? meta.tableKey : meta.dataBinding.tableKey;
    let columnKey = Utils.isUndefined(meta.dataBinding) ? meta.columnKey : meta.dataBinding.columnKey;
    let table = doc.getByKey(tableKey);
    if (!table) {
      return;
    }
    let column = table.getColByKey(columnKey, false);
    if (!column) {
      return;
    }
    meta.codeColumnKey = column.codeColumnKey || null;
    if (!meta.codeColumnKey) {
      return;
    }
    let codeComponent = form.getCompByDataBinding(tableKey, meta.codeColumnKey);
    if (!codeComponent) {
      return;
    }
    meta.codeComponentKey = codeComponent.key;
  }
  static async fetchDictCode(control) {
    let meta = control.meta, prop = meta.properties, value = control.value;
    if (prop.multiSelect || prop.isEditValue) {
      return;
    }
    let form = control.getForm(), doc = form.getDocument();
    let code = "";
    if (value && value.oid > 0) {
      code = value.code;
      if (!code) {
        if (!doc) {
          return;
        }
        let codeCache = doc.getExpData(DocExpandDataKeys.DICT_CODES);
        if (!codeCache) {
          return;
        }
        code = codeCache[value.itemKey + "_" + value.oid];
        if (code) {
          value.code = code;
          value.useCode = code;
        } else {
          return console.error(value.itemKey, value.oid, " code is null from cache");
        }
      }
    }
    this.initCodeColumnKey(form, meta);
  }
  static setValueToDocument(form, control, newValue, bookmark) {
    var tableKey = control.tableKey, columnKey = control.columnKey, doc = form.getDocument();
    var dataTable = doc.getByKey(tableKey);
    if (dataTable.tableMode == TableMode.HEAD) {
      !dataTable.first() && dataTable.addRow(true);
    } else {
      bookmark != null && dataTable.setByBkmk(bookmark);
    }
    var type = control.type, meta = control.meta;
    var dataType = dataTable.getColByKey(columnKey).type;
    if (newValue != null) {
      switch (type) {
        case ControlType.DICT:
        case ControlType.DICTSEARCHBOX:
        case ControlType.DICTPANE:
        case ControlType.DYNAMICDICT:
        case ControlType.COMPDICT:
          if (control.multiSelect) {
            if (newValue.length > 0) {
              var str = "";
              var vals = "";
              for (var i2 = 0; i2 < newValue.length; i2++) {
                str += "," + newValue[i2].oid;
                vals += "," + newValue[i2].editValue;
              }
              if (control.isEditValue) {
                dataTable.setByKey(columnKey, vals.substring(1));
              } else {
                dataTable.setByKey(columnKey, str.substring(1));
              }
              if (type == ControlType.DYNAMICDICT) {
                let refDataElementKey = control.refDataElementKey;
                if (refDataElementKey) {
                  let dataElementCmp = form.getCellLocation(refDataElementKey);
                  if (dataElementCmp) {
                    dataElementCmp = form.getComponent(refDataElementKey);
                  }
                  refDataElementKey = dataElementCmp.getColumnKey();
                  let dataElementKey = newValue[0].dataElementKey;
                  if (!dataElementKey) {
                    dataElementKey = control.dataElementKey;
                  }
                  dataTable.setByKey(refDataElementKey, dataElementKey);
                } else {
                  dataTable.setByKey(columnKey + "ItemKey", newValue[0].itemKey);
                }
              } else if (type == ControlType.COMPDICT) {
                dataTable.setByKey(columnKey + "ItemKey", newValue[0].itemKey);
              }
            }
          } else {
            if (control.isEditValue) {
              dataTable.setByKey(columnKey, newValue.editValue);
            } else {
              dataTable.setByKey(columnKey, newValue.oid);
            }
            if (type == ControlType.DYNAMICDICT) {
              let refDataElementKey = control.refDataElementKey;
              if (refDataElementKey) {
                let dataElementCmp = form.getCellLocation(refDataElementKey);
                if (dataElementCmp) {
                  refDataElementKey = dataElementCmp.columnKey;
                } else {
                  dataElementCmp = form.getComponent(refDataElementKey);
                  refDataElementKey = dataElementCmp.getColumnKey();
                }
                let dataElementKey = newValue.dataElementKey;
                if (!dataElementKey) {
                  dataElementKey = control.dataElementKey;
                }
                dataTable.setByKey(refDataElementKey, dataElementKey);
              } else if (type == ControlType.COMPDICT) {
                dataTable.setByKey(columnKey + "ItemKey", newValue.itemKey);
              }
            } else if (type == ControlType.COMPDICT) {
              dataTable.setByKey(columnKey + "ItemKey", newValue.itemKey);
            }
          }
          if (meta.codeColumnKey) {
            dataTable.setByKey(meta.codeColumnKey, this.getRealCode(meta.displayCols, newValue));
          }
          break;
        default:
          dataTable.setByKey(columnKey, BaseHandler.convertValue(newValue, dataType));
      }
    } else {
      if (type == ControlType.NUMBEREDITOR) {
        if (!control.allowNull) {
          newValue = TypeConvertor.toDecimal(newValue);
        }
        dataTable.setByKey(columnKey, newValue);
      } else {
        dataTable.setByKey(columnKey, BaseHandler.convertValue(newValue, dataType));
      }
    }
  }
  static async setSubDetailValueToDocument(form, control, newValue, fireEvent) {
    const grid = form.getComponent(control.parentGridKey);
    let ctx = control.contextHook ? control.contextHook() : null;
    let rowIndex = ctx ? ctx.rowIndex : -1;
    if (isNaN(rowIndex) || rowIndex == -1) {
      rowIndex = grid.getLastEmptyRowIndex();
      if (isNaN(rowIndex) || rowIndex == -1) {
        return;
      }
      grid.setFocusRowIndex(rowIndex);
    }
    if (control.bindingCellKey) {
      await grid.setValueByKey(rowIndex, control.bindingCellKey, newValue, true, true, fireEvent);
    } else {
      const rowData = grid.getRowDataAt(rowIndex);
      if (!rowData.bkmkRow) {
        return;
      }
      this.setValueToDocument(form, control, newValue, rowData.bkmkRow.getBookmark());
    }
  }
  /**
   * 头控件触发值变化事件
   */
  // static async doFireHeadEvent(form, control) {
  //     const self = this;
  //     const valueChanged = control.getMetaObj().valueChanged;
  //     if (form.metaForm.useVariant) {
  //         const events = self.getValueChanged(form, control.key, valueChanged);
  //         if (!events) {
  //             return;
  //         }
  //         for (let i = 0; i < events.length; i++) {
  //             const event = events[i];
  //             await form.__eval(event, new ViewContext(form));
  //         }
  //     } 
  // }
  // /**
  //  * 明细触发值变化事件
  //  */
  // static doFireDetailEvent(form, grid, metaObj, rowIndex) {
  //     var valueChanged = metaObj.valueChanged;
  //     if (form.metaForm.useVariant) {
  //         var events = this.getValueChanged(form, metaObj.key, valueChanged);
  //         return events.reduce(async (prev, event) => {
  //             await prev;
  //             var cxt = new ViewContext(form);
  //             cxt.updateLocation(grid.key, rowIndex, -1);
  //             return form.__eval(event, cxt);
  //         }, true);
  //     } else {
  //         if (valueChanged) {
  //             var cxt = new ViewContext(form);
  //             cxt.updateLocation(grid.key, rowIndex, -1);
  //             return form.__eval(valueChanged, cxt);
  //         }
  //     }
  // }
  static isVariantDep(form, comKey) {
    return form.metaForm.useVariant && form.metaForm.variant && form.metaForm.variant.dependency.indexOf(comKey) != -1;
  }
  static isDict(type) {
    return type == ControlType.DICT || type == ControlType.DYNAMICDICT || type == ControlType.COMPDICT;
  }
  static getRealCode(displayCols = [], dictValue) {
    let useCodeCol = displayCols.find((col) => col.key == "UseCode");
    return dictValue ? useCodeCol ? dictValue.useCode : dictValue.code : "";
  }
  static async validated(formID2, validation) {
    var form = FormStack.getForm(formID2);
    return form == null ? void 0 : form.asyncEval(validation);
  }
  static async __validated(formID2, validation) {
    var form = FormStack.getForm(formID2);
    return form == null ? void 0 : form.__eval(validation);
  }
  static hasChanging(changing) {
    var hasChanging = false;
    if (changing) {
      hasChanging = true;
    }
    return hasChanging;
  }
  static changing(formID2, changing) {
    var form = FormStack.getForm(formID2);
    return form == null ? void 0 : form.__eval(changing);
  }
  static getImageBase64URL(control, path, thumbnail, sourceType) {
    let params = {
      path,
      formKey: control.getForm().formKey,
      thumbnail,
      sourceType
    };
    return SvrMgr.getBase64Image(params);
  }
  static calcColor(form, color, cxt) {
    if (regExp$1.test(color) || color.includes("rgb")) {
      return color;
    }
    return form.__eval(color, cxt).catch(function() {
      return color;
    });
  }
  /**
   * 判断值是否为空值. null,'',undefined,0都是空值,下拉框只要选择了,就不是空值,没选''或者null
   */
  static isNullValue(value, config) {
    if (value == null || value === "") {
      return true;
    }
    if (value instanceof Decimal) {
      return config ? config.allowNull ? false : value.isZero() : value.isZero();
    }
    if (value instanceof ItemData) {
      return value.oid == 0;
    }
    if (Array.isArray(value)) {
      return value.length == 0;
    }
    return false;
  }
  //TODO 移到各自的handler中
  static async checkValue(formID2, props, type, value, gridKey, rowIndex, meta) {
    var form = FormStack.getForm(formID2);
    if (type == ControlType.DICT && !props.multiSelect && !props.isEditValue) {
      await this.initDisplayCols(form, meta, type, props.itemKey);
    }
    if ((type == ControlType.DICT && value !== 0 || type == ControlType.DYNAMICDICT || props && props.isEditValue) && (Utils.isNumeric(value) || Utils.isString(value))) {
      var cxt = new ViewContext(form);
      if (gridKey && rowIndex != null) {
        cxt.updateLocation(gridKey, rowIndex, -1);
      }
      var itemKey = "";
      var dataElementKey = "";
      if (type == ControlType.DYNAMICDICT) {
        if (props.refDataElementKey) {
          dataElementKey = await form.__eval(props.refDataElementKey, cxt);
          itemKey = await this.getItemKeyByDataElementKeyService(form, dataElementKey);
        } else {
          itemKey = await form.__eval(props.refKey, cxt);
        }
      } else {
        itemKey = props.itemKey;
      }
      if (props.multiSelect) {
        var val = TypeConvertor.toString(value).split(",");
        var datas = [];
        for (var i2 = 0; i2 < val.length; i2++) {
          let item;
          if (props.isEditValue) {
            item = new ItemData({
              oid: -1,
              editValue: val[i2],
              itemKey,
              dataElementKey
            });
          } else {
            item = new ItemData({
              oid: TypeConvertor.toLong(val[i2]),
              itemKey,
              dataElementKey
            });
          }
          datas.push(item);
        }
        return datas;
      } else {
        if (!props.isEditValue) {
          const oid = TypeConvertor.toLong(value);
          this.initCodeColumnKey(form, meta);
          if (meta && meta.codeColumnKey && oid > 0) {
            let code;
            let codeCache = form.getDocument().getExpData(DocExpandDataKeys.DICT_CODES);
            if (codeCache) {
              code = codeCache[itemKey + "_" + oid];
            }
            if (code) {
              return new ItemData({
                oid,
                itemKey,
                dataElementKey,
                UseCode: code,
                Code: code
              });
            } else {
              const item = await new DictCacheProxy(form).getItem(itemKey, oid);
              if (item) {
                const baseItem = item.toBaseItem();
                return new ItemData({
                  oid,
                  itemKey,
                  dataElementKey,
                  UseCode: baseItem.UseCode,
                  Code: baseItem.Code
                });
              }
            }
          }
          return new ItemData({
            oid,
            itemKey,
            dataElementKey
          });
        } else {
          return new ItemData({
            oid: -1,
            editValue: value,
            itemKey: props.itemKey,
            dataElementKey
          });
        }
      }
    }
    return value;
  }
  static async getItemKeyByDataElementKeyService(form, dataElementKey) {
    let itemKey;
    if (dataElementKey) {
      itemKey = form.getItemKeyByDataElementKey(dataElementKey);
      if (!itemKey) {
        itemKey = await new RichDocService(form).getItemKeyByDataElementKey(dataElementKey);
      }
    }
    return itemKey;
  }
  static checkEquals(o1, o2) {
    if (BaseHandler.isNullValue(o1) || BaseHandler.isNullValue(o2)) {
      return false;
    }
    if (typeof o1 == "object") {
      if (o1 instanceof ItemData) {
        return o1.getOID() == o2.getOID();
      } else if (o1 instanceof Decimal) {
        return o1.equals(o2);
      } else if (o1 instanceof Date) {
        return o1.getTime() == o2.getTime();
      }
    } else {
      return o1 == o2;
    }
  }
  // static getValueChanged(form, key, defaultValue) {
  //     var arr = [], variant = form.variant;
  //     var vItem = variant ? variant.getValueChanged(key) : null;
  //     if (vItem) {
  //         if (vItem.option == Variant.addition) {
  //             if (defaultValue) arr.push(defaultValue);
  //         }
  //         for (var i = 0, e; e = vItem.values[i]; i++) {
  //             arr.push(e);
  //         }
  //     } else {
  //         if (defaultValue) arr.push(defaultValue);
  //     }
  //     return arr;
  // }
  static checkError(com) {
    if (!(com.advancedQueryJsonValue && !com.advancedQueryJsonValue.clean)) {
      if (com.isRequired()) {
        return COMPONENT_REQUIRED(com.caption).setSourceComponent({ key: com.key, isControlError: true });
      }
      if (com.isError()) {
        com.setErrorStyle();
        return com.getErrorMsg() || COMPONENT_CHECK_ERROR(com.caption).setSourceComponent({ key: com.key, isControlError: true });
      }
      if (com.infinity) {
        return COMPONENT_INFINITY(com.caption).setSourceComponent({ key: com.key, isControlError: true });
      }
    }
  }
  static locateError(com) {
    let form = com.getForm();
    if (!com.isVisible() && (com.isError() || com.isRequired())) {
      if (com.isError()) {
        form.setError(true, com.getErrorMsg(), com.key);
      }
      if (com.isRequired()) {
        form.setError(true, com.caption + " " + I18N.getString("CONTROL_REQUIRED", "-必须填写-"), com.key);
      }
    } else {
      if (form.error.hasError(com.key)) {
        form.setError(false, null, com.key);
      }
    }
  }
}
class DictTraceUtil {
  /**
   * 用于判断字典是否可以溯源弹出
   */
  static canPopupDict(form, meta, itemKey) {
    if (!meta) {
      return false;
    }
    const type = meta.cellType || meta.type;
    if (ControlType.DYNAMICDICT == type) {
      return true;
    }
    if (!itemKey) {
      return false;
    }
    if (ControlType.DICT != type && ControlType.DYNAMICDICT != type) {
      return false;
    }
    if (meta.multiSelect) {
      return;
    }
    if (meta.isEditValue) {
      return;
    }
    const pForm = form.getParentForm();
    if (pForm) {
      const pFormKey = pForm.getFormKey();
      if (pForm && StringUtil.endsWith(pFormKey, "_PopupDictProcess")) {
        return false;
      }
    }
    if (itemKey.endsWith("__Dic")) {
      return true;
    }
    let dependence = form.getDictTraceDependence();
    if (!dependence)
      return false;
    let canPopup;
    if (dependence[0] != ";") {
      dependence = ";" + dependence;
    }
    canPopup = dependence.indexOf(`;${itemKey};`) >= 0;
    return canPopup;
  }
}
class SearchHelpUtil {
  static async showSearchHelp(clickKey, pForm, itemKey, filter, fuzzyValue) {
    let target = FormTarget.MODAL;
    LoadingUtil.show(true);
    const container = pForm.getContainer();
    const containerFormKey = "SearchHelp";
    var metaService = new MetaService();
    var dataObject = await metaService.getDataObject(itemKey);
    var caption = dataObject.getCaption();
    const builder = new FormBuilder(containerFormKey);
    builder.setContainer(container);
    builder.setParentForm(pForm);
    builder.setTarget(target);
    const emptyForm = await builder.newEmpty();
    emptyForm.getParas().updateParas(JSON.parse(pForm.getParas().toJSON()), { "IsFormShowing": "IsFormShowing" });
    FormParasUtil.processCallParas(pForm, emptyForm);
    var defaultTCode = await emptyForm.getDefaultTCode(pForm);
    emptyForm.TCode = defaultTCode || pForm.TCode;
    emptyForm.Activity = pForm.Activity || "03";
    if (fuzzyValue != null) {
      emptyForm.setPara("FuzzyValue", fuzzyValue);
    }
    emptyForm.setPara("DictFilterSql", filter);
    emptyForm.setPara("DictFieldKey", clickKey);
    emptyForm.setPara("ItemKey", itemKey);
    emptyForm.setCaption(caption);
    if (emptyForm.getDefContainer().formulaFormKey) {
      var cxt = new ViewContext(emptyForm);
      var formKeys = await emptyForm.asyncEval(emptyForm.getDefContainer().formulaFormKey, cxt);
      if (formKeys) {
        var list = formKeys.split(";");
        for (var i2 = 0; i2 < list.length; i2++) {
          var formKey = list[i2];
          var innerBuilder = new FormBuilder(formKey);
          innerBuilder.setParentForm(emptyForm);
          let innerForm = await innerBuilder.newEmpty();
          if (innerForm) {
            var innerDoc = await new DocService(innerForm).newDefaultDocument(innerForm);
            innerForm.setDocument(innerDoc);
            var defaultTCode = await innerForm.getDefaultTCode(emptyForm);
            innerForm.TCode = defaultTCode || emptyForm.TCode;
            innerForm.Activity = "03";
            try {
              await new RichDocService(innerForm).checkDataAuthority(formKey, innerForm.getDocument());
            } catch (error) {
              LoadingUtil.hide();
              throw error;
            }
          }
        }
      }
    }
    await builder.build(emptyForm);
    LoadingUtil.hide();
  }
}
class DictHandler extends BaseHandler {
  static getRoot(form, itemKey, rootKey, cxt, dataElementKey) {
    var rootItem = {};
    if (rootKey && rootKey.length >= 0) {
      rootItem = form.getValue(rootKey, cxt);
      if (rootItem == null) {
        rootItem = {};
        rootItem.oid = 0;
        rootItem.itemKey = itemKey;
        rootItem.dataElementKey = dataElementKey;
      }
    } else {
      rootItem.oid = 0;
      rootItem.itemKey = itemKey;
      rootItem.dataElementKey = dataElementKey;
    }
    return new ItemData(rootItem);
  }
  static async getItemKey(form, refKey, loc) {
    const cxt = new ViewContext(form);
    if (loc) {
      cxt.updateLocation(loc.getKey(), loc.getRow(), loc.getColumn());
    }
    return await form.asyncEval(refKey, cxt, null);
  }
  static async getItemKeyByDataElementKey(form, refDataElementKey, loc) {
    const cxt = new ViewContext(form);
    if (loc) {
      cxt.updateLocation(loc.getKey(), loc.getRow(), loc.getColumn());
    }
    const dataElementKey = await form.asyncEval(refDataElementKey, cxt, null);
    return await this.getItemKeyByDataElementKeyService(form, dataElementKey);
  }
  static createRoot(form, itemKey, rootKey, cxt, dataElementKey) {
    var rootItem = this.getRoot(form, itemKey, rootKey, cxt, dataElementKey);
    return new MetaService(form, false).getDataObject(itemKey).then((dataObj) => {
      var ret = {};
      ret.root = rootItem;
      ret.secondaryType = dataObj.secondaryType;
      ret.displayCols = dataObj.displayCols;
      ret.dropCols = dataObj.dropCols;
      ret.queryFormKey = dataObj.queryFormKey;
      if (rootItem.getOID() == 0) {
        ret.rootCaption = dataObj.caption;
      } else if (rootItem.hasCaption()) {
        ret.rootCaption = rootItem.getCaption();
      } else {
        return new DictCacheProxy(form).getCaption(itemKey, rootItem.oid).then((caption) => {
          rootItem.caption = caption;
          ret.root = rootItem;
          ret.rootCaption = caption;
          return ret;
        });
      }
      return ret;
    });
  }
  static getDisplayCols(control) {
    var dictService = new DictService(control.getForm());
    return dictService.getDisplayCols(control.itemKey);
  }
  static getQueryCols(control) {
    var dictService = new DictService(control.getForm());
    return dictService.getQueryCols(control.itemKey);
  }
  static getTreePath(control, nodes, rootId) {
    var dictService = new DictService(control.getForm());
    return dictService.getTreePath(control.itemKey, nodes, rootId);
  }
  static async locate(control, field, value, root, cxt) {
    await this.calcItemKey(control, cxt);
    if (Utils.isUndefined(field)) {
      let columns = await control.getQueryCols(control.itemKey);
      field = columns[0].key;
    }
    var form = control.getForm();
    const formKey = form.formKey;
    const fieldKey = control.getMetaObj().key;
    var dictService = new DictService(form);
    return dictService.locate(
      control.itemKey,
      field,
      value,
      control.dictFilter,
      root,
      control.stateMask,
      null,
      formKey,
      fieldKey
    ).catch((e) => {
      return null;
    });
  }
  static async getGetDictFilterSql(dictFormKey, dictFieldKey, itemKey, dictFilter, form) {
    var dictService = new DictService(form);
    return dictService.getGetDictFilterSql(
      dictFormKey,
      dictFieldKey,
      itemKey,
      dictFilter,
      form.getOperationState()
    );
  }
  static async getSearchHelpFormKeys(form, itemKey) {
    var cxt = new ViewContext(form);
    var formKeys = await form.asyncEval("Macro_GetSearchHelpFormKeys('" + itemKey + "')", cxt);
    return formKeys;
  }
  static async showSearchHelp(pForm, args) {
    var dictFilterSql = await DictHandler.getGetDictFilterSql(args.dictFormKey, args.dictFieldKey, args.itemKey, args.dictFilter, pForm);
    var returnFieldKey;
    if (args.advancedFieldKey == "") {
      returnFieldKey = args.dictFieldKey;
    } else {
      returnFieldKey = args.advancedFieldKey;
    }
    await SearchHelpUtil.showSearchHelp(returnFieldKey, pForm, args.itemKey, dictFilterSql, args.fuzzyValue);
  }
  static async getQueryData(control, startRow, maxRows, pageIndicatorCount, fuzzyValue, root, cxt) {
    var form = control.getForm();
    await this.calcItemKey(control, cxt);
    var formState = form.getDocument().form_OperationState;
    var dictService = new DictService(form);
    const result = await dictService.getQueryData(
      control.itemKey,
      startRow,
      maxRows,
      pageIndicatorCount,
      fuzzyValue,
      control.stateMask,
      control.dictFilter,
      root,
      control.queryMatchType,
      control.ofFormKey,
      control.getMetaObj().key,
      formState
    );
    const c_result = { ...result };
    const childs = result.data;
    const items = ItemDataUtil.fromJSONBaseItems(childs);
    c_result.data = items;
    return c_result;
  }
  static async getDictChildren(control, pItemData) {
    var _a;
    var form = control.getForm();
    var dictService = new DictService(form);
    var id = pItemData.itemKey + "_" + pItemData.oid;
    if (control.loadType == DictLoadType.L2R) {
      if (control.cacheData) {
        var nodes = control.cacheData[id];
        if (!nodes) {
          nodes = [];
        }
        return { data: nodes };
      } else {
        var data2 = await dictService.getAllItems2(
          control.itemKey,
          pItemData,
          control.dictFilter,
          control.stateMask,
          control.ofFormKey,
          control.getMetaObj().key
        );
        control.setCacheData(data2);
        control.cacheData ? control.cacheData : control.cacheData = {};
        var tempData = control.cacheData[id];
        if (!tempData) {
          tempData = [];
        }
        return { data: tempData };
      }
    } else {
      var formKey = form.formKey;
      var fieldKey = control.getMetaObj().key;
      if (formKey.endsWith("V_AdvancedQuery") && form.pFormID) {
        formKey = (_a = FormStack.getForm(form.pFormID)) == null ? void 0 : _a.formKey;
        fieldKey = form.AdvancedQueriesFieldKey;
      }
      var data2 = await dictService.getDictChildren(
        control.itemKey,
        pItemData,
        control.dictFilter,
        control.stateMask,
        formKey,
        fieldKey
      );
      return { data: data2 };
    }
  }
  static async checkDict(control, loc) {
    var form = control.getForm();
    var cxt;
    if (loc) {
      cxt = new ViewContext(form);
      cxt.updateLocation(loc.getKey(), loc.getRow(), loc.getColumn());
      cxt.setCrossValue(loc.getKey(), loc.getCrossValue());
    }
    var itemKey = control.itemKey;
    var dataElementKey = "";
    if (control.type == ControlType.DYNAMICDICT) {
      if (control.refDataElementKey) {
        dataElementKey = await form.asyncEval(control.refDataElementKey, cxt);
        form.setPara("DynamicDictDataElementKey", dataElementKey);
        itemKey = await DictHandler.getItemKeyByDataElementKeyService(form, dataElementKey);
      } else {
        itemKey = await form.asyncEval(control.refKey, cxt);
      }
    }
    if (!itemKey)
      return false;
    var filter;
    if (form.formKey.endsWith("V_AdvancedQuery")) {
      const pForm = FormStack.getForm(form.pFormID);
      if (pForm) {
        var component = pForm.getComponent(form.AdvancedQueriesFieldKey);
        filter = await DictHandler.getDictFilter(pForm, component.getMetaObj(), itemKey, component.typeDefKey, cxt);
      }
    } else {
      filter = await DictHandler.getDictFilter(form, control.getMetaObj(), itemKey, control.typeDefKey, cxt);
    }
    var result = await this.createRoot(form, itemKey, control.root, cxt, dataElementKey);
    if (result) {
      result.itemKey = itemKey;
      result.browserFormKey = await this.getSearchHelpFormKeys(form, itemKey);
      if (result.queryFormKey) {
        result.queryFormKey = result.browserFormKey;
      }
      result.dataElementKey = dataElementKey;
      result.loadType = control.loadType;
      result.dictFilter = filter;
      control.displayCols = result.displayCols;
      control.dropCols = result.dropCols;
      return result;
    }
    return false;
  }
  static async getMetaFilter(form, properties, itemKey, cxt) {
    var itemFilters = properties.itemFilters;
    if (itemFilters) {
      var itemFilter = itemFilters[itemKey] || itemFilters[""];
      if (itemFilter) {
        var result = null;
        await itemFilter.reduce(async (prev, filter) => {
          await prev;
          if (!result) {
            if (filter.cond) {
              var ret = await form.asyncEval(filter.cond, cxt);
              if (ret)
                result = filter;
            } else {
              result = filter;
            }
          }
        }, true);
        return result;
      }
    }
    return null;
  }
  static async getDictFilter(form, meta, itemKey, typeDefKey, cxt) {
    var formKey = form.getFormKey(), fieldKey = meta.key;
    var metaFilter = await DictHandler.getMetaFilter(form, meta.properties || meta.editOptions, itemKey, cxt);
    if (metaFilter) {
      var dictFilter = {};
      dictFilter.itemKey = itemKey;
      dictFilter.formKey = formKey;
      dictFilter.fieldKey = fieldKey;
      dictFilter.filterIndex = metaFilter.filterIndex;
      dictFilter.dependency = metaFilter.dependency;
      dictFilter.values = [];
      dictFilter.typeDefKey = typeDefKey;
      var filterVals = metaFilter.filterVals;
      if (filterVals) {
        await filterVals.reduce(async (prev, filterVal) => {
          await prev;
          var value;
          switch (filterVal.type) {
            case FilterValueType.CONST:
              value = filterVal.refVal;
              break;
            case FilterValueType.FORMULA:
              value = await form.getUIProcess().evalFilter(fieldKey, filterVal.refVal);
              break;
            case FilterValueType.FIELD:
              if (form.formKey.endsWith("V_AdvancedQuery")) {
                const uiForm = FormStack.getForm(form.pFormID);
                if (!cxt) {
                  cxt = new ViewContext(uiForm);
                }
                value = await (uiForm == null ? void 0 : uiForm.asyncEval(filterVal.refVal, cxt, null));
              } else {
                if (!cxt) {
                  cxt = new ViewContext(form);
                }
                value = await form.asyncEval(filterVal.refVal, cxt, null);
              }
              break;
          }
          if (value instanceof Date) {
            value = value.getTime();
          }
          dictFilter.values.push(value);
        }, true);
        return dictFilter;
      }
      if (form.formKey.endsWith("V_AdvancedQuery")) {
        const uiForm = FormStack.getForm(form.pFormID);
        dictFilter.formKey = uiForm == null ? void 0 : uiForm.formKey;
        dictFilter.fieldKey = form.AdvancedQueriesFieldKey;
      }
      return dictFilter;
    }
    return null;
  }
  static async getShowCaption(form, val, multiSelect, independent, editValue, textField = "", fieldKey) {
    var caption = "";
    var itemKey;
    if (val != null) {
      if (editValue) {
        if (multiSelect) {
          let str2 = [];
          for (var i2 = 0, value; value = val[i2]; i2++) {
            str2.push(value.editValue);
          }
          caption = str2.join(",");
        } else {
          caption = val.editValue;
        }
      } else {
        let captionCache, formKey, doc = form.getDocument();
        if (doc) {
          captionCache = doc.getExpData(DocExpandDataKeys.DICT_CAPTIONS);
          formKey = form.getFormKey();
        }
        let oids, needCaption = false;
        if (multiSelect) {
          oids = [];
          var text = "";
          for (var i2 = 0, len = val.length; i2 < len; i2++) {
            var v = val[i2];
            if (v.oid != 0) {
              oids.push(v.oid);
              if (v.hasCaption() && !textField) {
                text = text + "," + v.getCaption();
              } else {
                itemKey = v.getItemKey();
                var key = itemKey + "_" + v.oid + (textField ? "_" + textField : "");
                if (captionCache && captionCache.hasOwnProperty(key)) {
                  text = text + "," + captionCache[key];
                } else {
                  needCaption = true;
                }
              }
            } else {
              if (!independent) {
                text = "," + I18N.getString("RIGHTSSET_SELECTALL", "全选");
                break;
              }
            }
          }
          if (!needCaption) {
            if (text.length > 0) {
              text = text.substring(1);
            }
            caption = text;
          }
        } else if (val.oid == 0) {
          caption = "";
        } else if (val instanceof ItemData) {
          if (val.hasCaption() && !textField) {
            caption = val.getCaption();
          } else {
            oids = val.oid;
            itemKey = val.getItemKey();
            var key = itemKey + "_" + val.oid + (textField ? "_" + textField : "");
            if (captionCache && captionCache.hasOwnProperty(key)) {
              caption = captionCache[key];
            } else {
              needCaption = true;
            }
          }
        }
        if (needCaption) {
          if (multiSelect) {
            var args = [];
            var dictCacheProxy = new DictCacheProxy(form);
            for (var i2 = 0; i2 < oids.length; i2++) {
              args.push(dictCacheProxy.getItem(itemKey, oids[i2]));
            }
            let rets = await Promise.all(args);
            var c = "";
            for (var i2 = 0; i2 < rets.length; i2++) {
              var str = "";
              if (rets[i2]) {
                if (textField) {
                  str = rets[i2].getValue(textField);
                  c = c + "," + str;
                } else {
                  str = rets[i2].caption;
                  c = c + "," + str;
                }
              }
            }
            if (c.length > 0) {
              c = c.substring(1);
            }
            caption = c;
          } else {
            let item = await new DictCacheProxy(form).getItem(itemKey, oids, formKey, fieldKey);
            if (item) {
              if (textField) {
                caption = item.getValue(textField);
              } else {
                caption = item.caption;
              }
            }
          }
        }
      }
    }
    return caption;
  }
  static async calcItemKey(self, cxt) {
    var itemKey = self.itemKey;
    if (self.type == ControlType.DYNAMICDICT) {
      var form = self.getForm();
      if (self.refDataElementKey) {
        var dataElementKey = await form.asyncEval(self.refDataElementKey, cxt);
        self.dataElementKey = dataElementKey;
        itemKey = await DictHandler.getItemKeyByDataElementKeyService(form, dataElementKey);
      } else {
        itemKey = await form.asyncEval(self.refKey, cxt);
      }
      self.itemKey = itemKey;
    }
    return itemKey;
  }
  static canPopupDict(meta, form, itemKey) {
    return DictTraceUtil.canPopupDict(form, meta, itemKey);
  }
}
class ComboboxParameterSourceType {
}
ComboboxParameterSourceType.CONST = 0;
ComboboxParameterSourceType.FORMULA = 1;
ComboboxParameterSourceType.FIELD = 2;
class ComboboxSourceType {
}
ComboboxSourceType.ITEMS = 0;
ComboboxSourceType.FORMULA = 1;
ComboboxSourceType.QUERY = 2;
ComboboxSourceType.STATUS = 3;
ComboboxSourceType.PARAGROUP = 4;
class ComboFilterType {
}
ComboFilterType.EXCLUDE = 0;
ComboFilterType.FILTER = 1;
class ComboBoxItem {
  constructor(options2) {
    this.key = options2.key, this.value = options2.value, this.caption = options2.caption, this.showCaption = options2.caption, this.icon = options2.icon;
  }
  setCaption(caption) {
    this.caption = caption;
  }
  getCaption() {
    return this.caption;
  }
  setShowCaption(showCaption) {
    this.showCaption = showCaption;
  }
  getShowCaption() {
    return this.showCaption;
  }
  setValue(value) {
    this.value = value;
  }
  getValue() {
    return this.value;
  }
  setkey(key) {
    this.key = key;
  }
  getKey() {
    return this.key;
  }
  setIcon(icon) {
    this.icon = icon;
  }
  getIcon() {
    return this.icon;
  }
}
const cache$d = new LRUCache(20);
const filterCache = new LRUCache(20);
const getRequestKey = async (form, prop, cxt, filter = false) => {
  var data2 = {};
  data2.key = prop.key;
  data2.formKey = form == null ? void 0 : form.getFormKey();
  data2.filter = filter;
  var dependency = prop.dependency;
  if (dependency) {
    await dependency.split(",").reduce(async (prev, field) => {
      await prev;
      var value = await (form == null ? void 0 : form.__eval(field, cxt));
      data2[field] = value;
    }, true);
    return JSON.stringify(data2);
  }
  return JSON.stringify(data2);
};
const getCacheKey$4 = async (form, prop, cxt, filter = false) => {
  if (prop.cache) {
    return getRequestKey(form, prop, cxt, filter);
  }
  return null;
};
const getQueryParas = async (form, prop, cxt) => {
  var queryDef = prop.queryDef;
  var queryParas = queryDef && queryDef.queryParas;
  var paras = [];
  if (queryParas) {
    await queryParas.reduce(async (prev, para) => {
      await prev;
      var v;
      switch (para.sourceType) {
        case ComboboxParameterSourceType.CONST:
          v = para.value;
          break;
        case ComboboxParameterSourceType.FORMULA:
          v = await (form == null ? void 0 : form.asyncEval(para.formula, cxt));
          break;
        case ComboboxParameterSourceType.FIELD:
          v = await (form == null ? void 0 : form.asyncEval(para.fieldKey, cxt));
          break;
      }
      if (v instanceof Date) {
        v = v.getTime();
      }
      paras.push(v);
    }, true);
  }
  return paras;
};
const getQueryItems$1 = async (form, prop, cxt, typeDefKey) => {
  var paras = await getQueryParas(form, prop, cxt);
  return form && new DataService(form).getQueryItems(form.formKey, prop.key, typeDefKey, paras);
};
const getFilterQueryItems = async (form, prop, cxt, typeDefKey) => {
  var paras = await getQueryParas(form, prop, cxt);
  return form && new DataService(form).getFilterQueryItems(form.formKey, prop.key, typeDefKey, paras);
};
const getItemVal = (items, text) => {
  for (var i2 = 0, item; item = items[i2]; i2++) {
    if (item.showCaption == text || item.caption == text || item.value == text) {
      return item.value;
    }
  }
  return "";
};
const getEliminateDatas = (items, filterItems, coincide) => {
  const datas = new Set(
    filterItems.map((item) => item.value)
  );
  var data2 = items.filter((item) => {
    var value = TypeConvertor.toString(item.value);
    return coincide ? datas.has(value) : !datas.has(value);
  });
  return data2;
};
class ComboboxShowFormat {
}
ComboboxShowFormat.FMT_VALUE_CAPTION = "${Value} ${Caption}";
ComboboxShowFormat.FMT_CAPTION = "${Caption}";
ComboboxShowFormat.FMT_CAPTION_VALUE = "${Caption} ${Value}";
const _ComboBoxHandler = class _ComboBoxHandler2 extends BaseHandler {
  //获取下拉框和ComboFilter计算过后的值
  static async getItems(formID2, prop, loc, typeDefKey) {
    var form = FormStack.getForm(formID2);
    if (form && form.formKey.endsWith("V_AdvancedQuery") && form.pFormID) {
      form = FormStack.getForm(form.pFormID);
    }
    var cxt;
    if (loc) {
      cxt = new ViewContext(form);
      cxt.updateLocation(loc.getKey(), loc.getRow(), -1);
    }
    var items = await this.getComboboxItems(form, prop, cxt, typeDefKey);
    var filter = prop.comboFilter;
    if (filter) {
      filter.cache = prop.cache;
      filter.key = prop.key;
      var filterItems = await this.getFilterItems(form, filter, cxt, typeDefKey);
      switch (filter.type) {
        case ComboFilterType.EXCLUDE:
          return getEliminateDatas(items, filterItems, false);
        case ComboFilterType.FILTER:
          return getEliminateDatas(items, filterItems, true);
      }
    }
    return items;
  }
  //获取下拉框的值
  static async getComboboxItems(form, prop, cxt, typeDefKey) {
    var sourceType = prop.sourceType;
    var items;
    switch (sourceType) {
      case ComboboxSourceType.ITEMS:
      case ComboboxSourceType.STATUS:
      case ComboboxSourceType.PARAGROUP:
        return this.convertItems(prop.items, prop);
      case ComboboxSourceType.FORMULA:
        var items;
        var cacheKey = await getCacheKey$4(form, prop, cxt);
        if (cacheKey) {
          items = cache$d.get(cacheKey);
          if (items) {
            return this.convertItems(items, prop);
          }
        }
        items = await _ComboBoxHandler2.getFormulaItems(form, prop, cxt);
        if (cacheKey) {
          cache$d.set(cacheKey, items);
        }
        return this.convertItems(items, prop);
      case ComboboxSourceType.QUERY:
        var cacheKey = await getCacheKey$4(form, prop, cxt);
        if (cacheKey) {
          var items = cache$d.get(cacheKey);
          if (items) {
            return this.convertItems(items, prop);
          }
        }
        var items = await getQueryItems$1(form, prop, cxt, typeDefKey);
        if (prop.cache && cacheKey) {
          cache$d.set(cacheKey, items);
        }
        return this.convertItems(items, prop);
    }
  }
  //获取ComboFilter的值
  static async getFilterItems(form, prop, cxt, typeDefKey) {
    var sourceType = prop.sourceType;
    var items;
    switch (sourceType) {
      case ComboboxSourceType.ITEMS:
      case ComboboxSourceType.STATUS:
      case ComboboxSourceType.PARAGROUP:
        return this.convertItems(prop.items, prop);
      case ComboboxSourceType.FORMULA:
        var items;
        var cacheKey = await getCacheKey$4(form, prop, cxt, true);
        if (cacheKey) {
          items = filterCache.get(cacheKey);
          if (items) {
            return this.convertItems(items, prop);
          }
        }
        items = await _ComboBoxHandler2.getFormulaItems(form, prop, cxt, true);
        if (cacheKey) {
          filterCache.set(cacheKey, items);
        }
        return this.convertItems(items, prop);
      case ComboboxSourceType.QUERY:
        var cacheKey = await getCacheKey$4(form, prop, cxt, true);
        if (cacheKey) {
          var items = filterCache.get(cacheKey);
          if (items) {
            return this.convertItems(items, prop);
          }
        }
        var items = await getFilterQueryItems(form, prop, cxt, typeDefKey);
        if (prop.cache && cacheKey) {
          filterCache.set(cacheKey, items);
        }
        return this.convertItems(items, prop);
    }
  }
  static createComboBoxItem(options2, properties) {
    var cItem = new ComboBoxItem(options2);
    var caption = options2.caption;
    var value = options2.value;
    if (!caption || !StringUtil.trim(caption)) {
      cItem.setCaption("");
      return cItem;
    }
    let showFormat = SessionParasCache.get("UserComboBoxShowFormat");
    if (!showFormat) {
      showFormat = properties.textShowFormat || ComboboxShowFormat.FMT_VALUE_CAPTION;
    }
    let text = value + " " + caption;
    if (showFormat == ComboboxShowFormat.FMT_CAPTION) {
      text = caption;
    } else if (showFormat == ComboboxShowFormat.FMT_CAPTION_VALUE) {
      text = caption + " " + value;
    }
    cItem.setShowCaption(text);
    return cItem;
  }
  static convertItems(items, prop) {
    if (!items)
      return [];
    var _items = [];
    items.forEach((item) => {
      _items.push(this.createComboBoxItem(item, prop));
    });
    return _items;
  }
  static getItemCaption(items, v) {
    for (var i2 = 0, item; item = items[i2]; i2++) {
      if (item.value == v) {
        return item.showCaption || item.caption || "";
      }
    }
    return "";
  }
  static getFixCaption(value, prop, isCheckListBox) {
    let items = [];
    if (prop.items) {
      items = this.convertItems(prop.items, prop);
    }
    return _ComboBoxHandler2.getCaptionFromItems(prop, items, value, isCheckListBox);
  }
  static async getShowCaption(com, value, prop, isCheckListBox, rowIndex, typeDefKey) {
    if (value === null || value === "")
      return "";
    let location2;
    if (rowIndex != null) {
      location2 = new LocationInfo(com.key, rowIndex, -1);
    }
    let items = await _ComboBoxHandler2.getItems(com.ofFormID, prop, location2, typeDefKey);
    return _ComboBoxHandler2.getCaptionFromItems(prop, items, value, isCheckListBox);
  }
  static getCaptionFromItems(prop, items, value, isCheckListBox) {
    let caption = "";
    if (items) {
      if (value != null && value !== "") {
        switch (prop.sourceType) {
          case ComboboxSourceType.QUERY:
            value = TypeConvertor.toString(value);
            if (value.indexOf(",") != -1) {
              var values = value.split(",");
              for (var i2 = 0, len = values.length; i2 < len; i2++) {
                if (i2 > 0) {
                  caption += ",";
                }
                caption += _ComboBoxHandler2.getItemCaption(items, values[i2]);
              }
            } else {
              caption = _ComboBoxHandler2.getItemCaption(items, value);
            }
            break;
          default:
            if (isCheckListBox) {
              value = TypeConvertor.toString(value);
              var values = value.split(",");
              for (var i2 = 0, len = values.length; i2 < len; i2++) {
                if (i2 > 0) {
                  caption += ",";
                }
                caption += _ComboBoxHandler2.getItemCaption(items, values[i2]);
              }
            } else {
              caption = _ComboBoxHandler2.getItemCaption(items, value);
            }
            break;
        }
      }
    }
    if (!caption && prop.editable) {
      caption = TypeConvertor.toString(value);
    }
    return caption;
  }
  static getValByCaption(items, caption) {
    var texts = caption.split(","), v;
    for (var k = 0, size2 = texts.length; k < size2; k++) {
      if (!v) {
        v = getItemVal(items, texts[k]);
      } else {
        v += "," + getItemVal(items, texts[k]);
      }
    }
    return v;
  }
  static clearCache() {
    cache$d.reset();
  }
  static getCache() {
    return cache$d;
  }
  static async dealResult(form, rs, prop, cxt) {
    var items = [];
    if (typeof rs === "string") {
      if (rs == "")
        return items;
      var item_Arr = rs.split(";");
      for (var i2 = 0, len = item_Arr.length; i2 < len; i2++) {
        var item_obj = item_Arr[i2].split(",");
        var i1 = item_obj[0];
        var i22 = "";
        if (item_obj.length > 1) {
          i22 = item_obj[1];
        } else {
          i22 = i1;
        }
        i22 = await form.getString("", i22, i22);
        var i3 = item_obj.length > 2 ? item_obj[2] : "";
        var item = {
          value: i1,
          caption: i22,
          icon: i3
        };
        items.push(item);
      }
      return items;
    } else if (rs instanceof DataTable) {
      rs.beforeFirst();
      if (rs.cols.length == 1) {
        var globalItems = prop.globalItems;
        var arr = await form.asyncEval(globalItems, cxt);
        rs.beforeFirst();
        while (rs.next()) {
          var value = TypeConvertor.toString(rs.get(0));
          var caption = "";
          if (arr && arr.length > 0) {
            for (var i2 = 0, item2; item2 = arr[i2]; i2++) {
              if (item2.value == value) {
                caption = item2.caption;
                break;
              }
            }
          }
          caption = caption == "" ? value : caption;
          items.push({
            value,
            caption
          });
        }
      } else if (rs.cols.length > 1) {
        while (rs.next()) {
          var item3 = {
            value: TypeConvertor.toString(rs.get(0)),
            caption: TypeConvertor.toString(rs.get(1)),
            icon: TypeConvertor.toString(rs.get(2))
          };
          items.push(item3);
        }
      }
      return items;
    } else if (Utils.isArray(rs)) {
      return items.concat(rs);
    } else if (rs && Utils.isArray(rs.items)) {
      return items.concat(rs.items);
    } else {
      return items;
    }
  }
  static async calcNeedRebuild(self) {
    var metaObj = self.getMetaObj();
    var prop = metaObj.properties;
    var items = await this.getItems(self.ofFormID, prop).then(function(items2) {
      return items2;
    }).catch((e) => {
      throw e;
    });
    var oldList = [];
    let oldValue = self.getValue();
    if (oldValue) {
      oldValue = TypeConvertor.toString(oldValue);
      oldList = oldValue.split(",");
    } else {
      return false;
    }
    var intersection = items.filter((item) => oldList.includes(TypeConvertor.toString(item.value)));
    if (oldList.length == intersection.length) {
      return false;
    }
    return true;
  }
};
_ComboBoxHandler.reqMap = {};
_ComboBoxHandler.getFormulaItems = async (form, prop, cxt, filter = false) => {
  if (prop.formula) {
    var requestKey = await getRequestKey(form, prop, cxt, filter);
    var rs, key = prop.key;
    if (!form)
      return [];
    if (!_ComboBoxHandler.reqMap[requestKey]) {
      let getItems = () => {
        if (form.getDocument()) {
          var formulaItemsCache = form.getDocument().getExpData("ComboBoxNoCacheFormulaValues");
          if (formulaItemsCache && formulaItemsCache.hasOwnProperty(key)) {
            rs = formulaItemsCache[key];
          }
        }
        if (rs) {
          return _ComboBoxHandler.dealResult(form, rs, prop, cxt);
        }
        return form.asyncEval(prop.formula, cxt).then((rs2) => {
          return _ComboBoxHandler.dealResult(form, rs2, prop, cxt);
        });
      };
      try {
        _ComboBoxHandler.reqMap[requestKey] = getItems();
      } finally {
        setTimeout(function() {
          delete _ComboBoxHandler.reqMap[requestKey];
        }, 500);
      }
    }
    return _ComboBoxHandler.reqMap[requestKey];
  }
  return [];
};
let ComboBoxHandler = _ComboBoxHandler;
class ImageSourceType {
  static parse(typeStr) {
    if (typeStr.toLowerCase() == "data") {
      return this.DATA;
    } else if (typeStr.toLowerCase() == "resource") {
      return this.RESOURCE;
    } else if (typeStr.toLowerCase() == "url") {
      return this.URL;
    }
    return -1;
  }
}
ImageSourceType.DATA = 1;
ImageSourceType.RESOURCE = 2;
ImageSourceType.URL = 3;
class ZIndexUtil {
  static getZIndex(form, type) {
    var _a, _b;
    let zIndex = 0;
    if (form) {
      if (((_a = form.getContainer()) == null ? void 0 : _a.type) == ControlType.CONTAINER) {
        form = (_b = form.getContainer()) == null ? void 0 : _b.getForm();
      }
      zIndex = form.zIndex;
    } else {
      zIndex = 300;
    }
    switch (type) {
      case "splitline":
        zIndex += 1;
        break;
      case "tip":
        zIndex += 20;
        break;
      case "control":
        zIndex += 10;
        break;
      case "dialog":
        zIndex += 500;
        break;
      case "error":
      case "warn":
        zIndex += 8888;
        break;
      case "zoom":
        zIndex += 100;
        form.zIndex = zIndex;
        break;
      case "modal":
        let topForm;
        const getTopForm = function(__form) {
          if (__form) {
            if (__form.getParentForm() && __form.getTarget() == FormTarget.MODAL) {
              getTopForm(__form.getParentForm());
            } else {
              topForm = __form;
            }
          }
        };
        getTopForm(form);
        zIndex = this.getTopZIndex(topForm) + 200;
        form.zIndex = zIndex;
        break;
      case "tabmodal":
        let formTop, parentForm = form.getParentForm();
        if (parentForm && parentForm.getTarget() == FormTarget.NEWTAB) {
          zIndex = parentForm.zIndex + 100;
        } else {
          const getTopForm2 = function(__form) {
            if (__form) {
              if (__form.getParentForm()) {
                getTopForm2(__form.getParentForm());
              } else {
                formTop = __form;
              }
            }
          };
          getTopForm2(form);
          zIndex = this.getTopZIndex(formTop) + 100;
        }
        form.zIndex = zIndex;
        break;
      case "navopt":
        zIndex += 50;
        break;
      case "hoverbutton":
        zIndex += 400;
        break;
      case "popview":
        zIndex += 150;
        form.zIndex = zIndex;
        break;
      case "water":
        zIndex += 1e4;
        break;
      case "login":
        zIndex += 10001;
        break;
      case "newtab":
        zIndex = 0;
        break;
    }
    return zIndex;
  }
  static clearZoomZIndex(form) {
    form.zIndex -= 100;
  }
  static clearPopViewZIndex(form) {
    form.zIndex -= 150;
  }
  static getTopZIndex(form) {
    let zindexs = [];
    var getZIndexs = function(_form) {
      FormStack.getFormList().forEach((__form) => {
        if (__form.pFormID && __form.pFormID == (_form == null ? void 0 : _form.formID)) {
          zindexs.push(__form.zIndex);
          getZIndexs(__form);
        }
      });
    };
    getZIndexs(form);
    return zindexs.length == 0 ? 0 : Math.max.apply(null, zindexs);
  }
}
const data$4 = new Array();
class EditFlag {
  static getInstance() {
    if (!EditFlag.instance) {
      EditFlag.instance = new EditFlag();
      return EditFlag.instance;
    }
    return EditFlag.instance;
  }
  affectAll() {
    data$4.push("ALL");
  }
  affectComponent(...key) {
    data$4.push.apply(data$4, key);
  }
  endAffect() {
    data$4.length = 0;
  }
  hasAffect(key) {
    return data$4.includes("ALL") || data$4.includes(key);
  }
}
class BaseComponent {
  /**
   * 初始化方法，此方法由组件构造函数默认调用。
   * @param options 传入属性设置，格式为json : {key : key, caption : caption,...}
   */
  constructor(meta) {
    this.enable = true;
    this.visible = true;
    this.width = null;
    this.height = null;
    this.required = false;
    this.format = null;
    this.active = null;
    this.buddyKey = null;
    this.buddy = false;
    this.extend = false;
    this.clearable = true;
    this.needRender = true;
    this.errorInfo = {};
    this.customParas = {};
    this.parentGridKey = "";
    this.useAdvancedQuery = false;
    this.meta = meta;
    this.type = meta.type;
    this.errorInfo = {};
    this.style = CssUtil.getStyle(meta);
    this.lastSize = {
      width: -1,
      height: -1
    };
    this.lastPosition = {
      top: -1,
      left: -1
    };
    this.lastFontSize = {
      fontSize: -1
    };
  }
  setMetaObj(metaObj) {
    this.meta = metaObj;
  }
  getMetaObj() {
    return this.meta;
  }
  setOnActive(onActive) {
    this.onActive = onActive;
  }
  isOnActive() {
    return Utils.isUndefined(this.onActive) ? false : this.onActive;
  }
  // 是否支持数据绑定
  isDataBinding() {
    return true;
  }
  // 是否有数据绑定
  hasDataBinding() {
    return this.tableKey && this.columnKey;
  }
  /**
   * 设置除零错(数值框)
   * @param infinity 是否除零错
   */
  setInfinity(infinity) {
    var _a;
    this.infinity = infinity;
    (_a = this.impl) == null ? void 0 : _a.setShowText(infinity ? "#DIV/0" : "");
  }
  /**
   * 设置组件宽度。
   * @param width：Number类型。
   */
  setWidth(width) {
    if (!width) {
      return;
    }
    if (!this.rendered) {
      this.width = width;
      return;
    }
    var lastSize = this.lastSize;
    if (lastSize.width !== width) {
      lastSize.width = width;
      this.onSetWidth(width);
    }
  }
  // private 默认的设置组件宽度方法，如果组件有自定义设置宽度方法，可在子组件重写此方法。
  onSetWidth(width) {
    this.width = width;
    this.impl.setWidth(width);
    console.log(this.key + " onSetWidth call impl setWidth" + width);
  }
  /**
   * 获取组件宽度。
   * @return Number。
   */
  getWidth() {
    if (this.rendered) {
      console.log(this.key + " get width call impl getWidth");
    }
    return this.width;
  }
  /**
   * 设置组件高度。
   * @param height：Number。
   */
  setHeight(height) {
    if (!height)
      return;
    if (!this.rendered) {
      this.height = height;
      return;
    }
    var lastSize = this.lastSize;
    if (lastSize.height !== height) {
      lastSize.height = height;
      this.onSetHeight(height);
    }
  }
  // private 默认的设置组件高度方法，如果组件有自定义设置高度方法，可在子组件重写此方法。
  onSetHeight(height) {
    this.height = height;
    this.impl.setHeight(height);
    console.log(this.key + " onSetWidth call impl setHeight" + height);
  }
  /**
   * 获取组件高度。
   * @return Number。
   */
  getHeight() {
    if (this.rendered) {
      console.log(this.key + " get width call impl getHeight");
    }
    return this.height;
  }
  // private 获取除去padding和border的宽度
  getInnerWidth() {
    console.log("call getInnerWidth ");
    return this.width;
  }
  // private 获取除去padding和border的高度
  getInnerHeight() {
    console.log("call getInnerHeight ");
    return this.height;
  }
  // flexlayout中设置权重
  setFlex(flex) {
    if (!flex || !Utils.isNumeric(flex) || flex <= 0)
      return;
    if (this.flex == flex) {
      return;
    }
    this.flex = flex;
    this.impl && this.impl.flex(flex);
  }
  // 设置css样式
  setCss(key, val) {
    if (!key) {
      return;
    }
    if (!this.cssObj) {
      this.cssObj = {};
    }
    this.cssObj[key] = val;
    this.impl && this.impl.setCss(key, val);
  }
  /**
   * 设置水平方向位置。
   * @param left：Number。
   */
  setLeft(left) {
    if (!left || !Utils.isNumeric(left) || left <= 0)
      return;
    var lastPosition = this.lastPosition;
    if (lastPosition.left !== left) {
      lastPosition.left = left;
      if (this.rendered) {
        this.onSetLeft(left);
      } else {
        this.left = left;
      }
    }
  }
  // private 默认的设置组件位置方法，如果组件有自定义设置位置方法，可在子组件重写此方法。
  onSetLeft(left) {
    console.log("onSetLeft call this.impl.left");
  }
  /**
   * 设置竖直方向位置。
   * @param top：Number。
   */
  setTop(top) {
    if (!top && top != 0 || top == "auto")
      return;
    var lastPosition = this.lastPosition;
    if (lastPosition.top !== top) {
      lastPosition.top = top;
      if (this.rendered) {
        this.onSetTop(top);
      } else {
        this.top = top;
      }
    }
  }
  // private 默认的设置组件位置方法，如果组件有自定义设置位置方法，可在子组件重写此方法。
  onSetTop(top) {
    console.log("onSetTop call this.impl.top");
  }
  setPadding(padding) {
    this.padding = padding;
    console.log("setPadding......not impl");
  }
  setLeftPadding(leftPadding) {
    this.leftPadding = leftPadding;
    console.log("setleftPadding......not impl");
  }
  setRightPadding(rightPadding) {
    this.rightPadding = rightPadding;
    console.log("setrightPadding.....not impl");
  }
  setTopPadding(topPadding) {
    this.topPadding = topPadding;
    console.log("setTopPadding.......not impl");
  }
  setBottomPadding(bottomPadding) {
    this.bottomPadding = bottomPadding;
    console.log("setBottomPadding......not impl");
  }
  setMargin(margin) {
    if (margin && this.margin != margin) {
      this.margin = margin;
      this.impl && this.impl.margin(margin);
    }
  }
  setMarginLeft(marginLeft) {
    if (marginLeft && this.marginLeft != marginLeft) {
      this.marginLeft = marginLeft;
      this.impl && this.impl.marginLeft(marginLeft);
    }
  }
  setMarginRight(marginRight) {
    if (marginRight && this.marginRight != marginRight) {
      this.marginRight = marginRight;
      this.impl && this.impl.marginRight(marginRight);
    }
  }
  setMarginTop(marginTop) {
    if (marginTop && this.marginTop != marginTop) {
      this.marginTop = marginTop;
      this.impl && this.impl.marginTop(marginTop);
    }
  }
  setMarginBottom(marginBottom) {
    if (marginBottom && this.marginBottom != marginBottom) {
      this.marginBottom = marginBottom;
      this.impl && this.impl.marginBottom(marginBottom);
    }
  }
  setBorderColor(borderColor) {
    this.borderColor = borderColor;
    console.log("setBorderColor..............not impl");
  }
  setBorderRadius(borderRadius) {
    this.borderRadius = borderRadius;
    console.log("setBorderRadius..............not impl");
  }
  setVAlign(vAlign) {
    this.vAlign = vAlign;
    console.log("setVAlign......................not impl");
  }
  setHAlign(hAlign) {
    this.hAlign = hAlign;
    console.log("setHAlign......................not impl");
  }
  /**
   * 返回控件id，如果id未定义，则给组件自动生成一个唯一id。
   * @return String。
   */
  getId() {
    if (this.ofFormID) {
      return this.id || (this.id = this.ofFormID + "_" + this.key);
    }
  }
  setColumnKey(columnKey) {
    this.columnKey = columnKey;
  }
  setTableKey(tableKey) {
    this.tableKey = tableKey;
  }
  setDefaultFormulaValue(defaultFormulaValue) {
    this.defaultFormulaValue = defaultFormulaValue;
  }
  getColumnKey() {
    return this.columnKey;
  }
  getTableKey() {
    return this.tableKey;
  }
  getDefaultFormulaValue() {
    return this.defaultFormulaValue;
  }
  dependedValueChange(...args) {
  }
  reset() {
  }
  resetStatus() {
  }
  // /**
  //  * 设置控件是否可编辑。
  //  * @param editable：Boolean。
  //  */
  // setEditable: function (editable) {
  //     this.editable = editable;
  // },
  getFormatEl() {
    console.log("getFormatEL not impl.....");
  }
  setFocusManager(focusManager) {
    this.focusManager = focusManager;
  }
  setTabIndex(tabIndex) {
    this.tabIndex = tabIndex;
  }
  getTabIndex() {
    return this.tabIndex;
  }
  /**
   * 控件是否可编辑。
   * @return Boolean。
   */
  isEditable() {
    return this.editable;
  }
  /**
   * 控件是否可用。
   * @return Boolean。
   */
  isEnable() {
    return this.enable;
  }
  setCaption(caption) {
    this.caption = caption;
    var ownerCt = this.ownerCt;
    if (ownerCt) {
      ownerCt.changeCaption(this);
    }
    this.impl && this.impl.setCaption(caption);
  }
  getCaption() {
    return this.caption;
  }
  checkNeedRender(com) {
    if (!com.needRender) {
      return false;
    }
    if (com.meta.ignoreDisplay) {
      return false;
    }
    var ownerCt = com.ownerCt;
    if (!ownerCt) {
      return true;
    }
    if (ownerCt.rendered || ownerCt.getOuterEl()) {
      if (ownerCt.type == ControlType.TABPANEL) {
        return ownerCt.isActive(com);
      } else {
        return true;
      }
    }
    return false;
  }
  setVisible(visible) {
    this.orgVisible = this.visible;
    if (this.visible != visible) {
      this.visible = visible;
      var ownerCt = this.ownerCt;
      if (ownerCt) {
        ownerCt.reduceVisible && ownerCt.reduceVisible(visible, this);
      }
      if (visible && !this.rendered) {
        if (this.yesCom) {
          this.doRender(this.container);
        }
      }
      this.impl && this.impl.setVisible(visible);
      if (this.buddyKey) {
        var buddy = this.getForm().getComponent(this.buddyKey);
        if (buddy && !buddy.extend) {
          buddy.setVisible(visible);
        }
      }
      this.locateError();
    }
    return this.orgVisible != visible;
  }
  locateError() {
    if (this.isSubDetail) {
      return;
    }
    this.handler.locateError(this);
  }
  setEnable(enable) {
    if (this.enable != enable) {
      this.enable = enable;
      this.impl && this.impl.setEnable(enable);
    }
  }
  setCustomPara(key, value) {
    this.customParas[key] = value;
  }
  getCustomPara(key) {
    return this.customParas[key];
  }
  /**
   * 控件是否可见。
   * @return Boolean。
   */
  isVisible() {
    return this.visible;
  }
  /**
   * 设置鼠标悬停时显示的提示信息。
   * @param tip String，显示的文本。
   */
  setTip(tip) {
    this.impl && this.impl.setTip(tip);
  }
  /**
   * 返回使用的jQueryUI对象的dom。
   * @return jQuery。
   */
  getEl() {
    return this.impl ? this.impl.el : null;
  }
  /**
   * 返回控件最外层dom，有些控件的最外层dom和getEl()不同，比如grid。
   * @return jQuery。
   */
  getOuterEl() {
    return this.getEl();
  }
  /**
   * 用于控制在刷新界面时,是否需要清空值
   * @return
   */
  needClean() {
    var meta = this.getMetaObj();
    if (meta.condition) {
      return false;
    }
    return this.clearable;
  }
  /**
   * 把控件渲染到container中
   * @param container：jQuery，当前控件的父节点。
   */
  render(container) {
    this.initContainer = container;
    this.beforeRender();
    let isRendered = this.doRender(container);
    if (isRendered) {
      this.afterRender();
      if (this.useAdvancedQuery) {
        const wrap = this.impl.getWrapNode();
        this.advancedQueryObj.render(wrap);
      }
    }
  }
  afterRender() {
  }
  doRender(container) {
    try {
      if (this.meta.ignoreDisplay) {
        return false;
      }
      if (!this.visible && !this.rendered) {
        this.container = container;
        return false;
      } else {
        this.impl = this.yesCom;
        this.impl.render(container);
        this.rendered = true;
        return true;
      }
    } catch (e) {
      this.impl = void 0;
      this.yesCom = void 0;
      this.rendered = false;
      throw e;
    }
  }
  setYesCom(yesCom) {
    this.yesCom = yesCom;
  }
  onRenderChildren() {
  }
  /**
   * 控件渲染前所做准备。
   */
  beforeRender() {
  }
  setError(error, msg) {
    if (this.errorInfo.error != error || this.errorInfo.errorMsg != msg) {
      this.errorInfo.error = error;
      this.errorInfo.errorMsg = msg;
      this.setErrorStyle();
    }
  }
  setErrorStyle() {
    this.impl && this.impl.setError(this.errorInfo.error, this.errorInfo.errorMsg);
  }
  isError() {
    return this.errorInfo.error;
  }
  getErrorMsg() {
    return this.errorInfo.errorMsg;
  }
  setRequired(required) {
    if (this.required != required) {
      this.required = required;
      this.setRequiredStyle();
    }
  }
  setRequiredStyle() {
    this.impl && this.impl.setRequired(this.required);
  }
  getForm() {
  }
  needCheckRequired() {
    this._needCheckRequired = true;
    this.impl && this.impl.needCheckRequired();
    if (this.buddyKey) {
      var buddy = this.getForm().getComponent(this.buddyKey);
      if (buddy && !buddy.extend) {
        buddy.needCheckRequired();
      }
    }
  }
  hasAffect() {
    return EditFlag.getInstance().hasAffect(this.key);
  }
  isRequired() {
    return this.required;
  }
  /**
   * 重新布局组件
   */
  doLayout(panelWidth, panelHeight) {
  }
  setKey(key) {
    this.key = key;
  }
  /**
   * 设置背景色
   */
  setBackColor(backColor) {
    this.backColor = backColor;
    this.impl && this.impl.setBackColor(backColor);
  }
  /**
   * 设置前景色
   */
  setForeColor(foreColor) {
    this.foreColor = foreColor;
    this.impl && this.impl.setForeColor(foreColor);
  }
  /**
   * 设置图标
   */
  setIcon(url) {
    this.impl && this.impl.setIcon(url);
  }
  /**
   * 设置组件显示样式。
   * @param style Object，参考style属性说明。
   */
  setStyle(style) {
    console.log("setStyle........not impl");
  }
  setFormatStyle(cssStyle) {
    console.log("setFormatStyle........not impl");
  }
  setCssClass(cssClass) {
    console.log("setCssClass........not impl");
  }
  focus() {
    this.focusManager.focusOwner = this;
    this.impl && this.impl.focus();
  }
  isActive(com) {
    if (!this.impl) {
      return false;
    }
    return this.impl.isActive(com);
  }
  doActive() {
  }
  doPostShow() {
  }
  needTip() {
    return true;
  }
  setShowText(text) {
    this.impl && this.impl.setShowText(text);
  }
  getShowText() {
    if (this.impl && typeof this.impl.getShowText == "function") {
      return this.impl.getShowText();
    }
    return this.showText;
  }
  getNowShowText() {
    if (this.impl && typeof this.impl.getShowText == "function") {
      return this.impl.getShowText();
    }
    return this.showText;
  }
  /**
   * 给DOM添加事件监听。
   */
  install() {
    this.impl && this.impl.install();
  }
  /**
   * 销毁控件，防止内存泄露。
   */
  destroy() {
    if (this.isDestroyed)
      return;
    if (this.beforeDestroy() !== false) {
      this.impl && this.impl.destroy();
      this.afterDestroy();
      this.isDestroyed = true;
    }
  }
  beforeDestroy() {
    return this.impl && this.impl.beforeDestroy();
  }
  /**
   * 解除自身所有属性的引用
   */
  afterDestroy() {
    for (var prop in this) {
      if (this.hasOwnProperty(prop)) {
        delete this[prop];
      }
    }
  }
  /**
         * 设置角标
         * @param badge 数组0->key 1->值 2->第一个（tabgroup）
         */
  addBadge(badge) {
    this.impl && this.impl.addViewBadge(badge);
  }
  /**
  * 移除角标
  * @param badge 数组0->key 1->值 2->第一个（tabgroup）
  */
  removeBadge(badge) {
    this.impl && this.impl.removeViewBadge(badge);
  }
  // getForm() {
  //     return this.form;
  // }
  calcAutoHeight() {
    return 0;
  }
  getZIndex(type) {
    return ZIndexUtil.getZIndex(this.getForm(), type);
  }
  clearZoomZIndex() {
    return ZIndexUtil.clearZoomZIndex(this.getForm());
  }
  getCompData(name2) {
    return this.impl && this.impl.getCompData(name2);
  }
}
class BaseControl extends BaseComponent {
  constructor() {
    super(...arguments);
    this.value = null;
    this.backupValue = null;
    this.showText = "";
    this.checkRule = null;
    this.trigger = null;
    this.initValue = false;
    this.fireHistorySearch = false;
    this.matchAllHistoryItem = false;
    this.preSearchValue = "";
  }
  isNull() {
    return this.value == null || this.value == "";
  }
  commitValue(value) {
    return this.setValue(value, true, true, true);
  }
  async commitChangingValue() {
    if (this.changing) {
      await this.handler.doValueChanged(this, true, true, true);
    }
    this.changing = false;
  }
  rollbackValue() {
    this.changing = false;
    this.__setValue(this.backupValue);
  }
  async __setValue(value) {
    var _this = this;
    if (!_this.behavior) {
      return false;
    }
    if (this.infinity) {
      delete this.infinity;
      this.showText = "";
    }
    _this.initValue = true;
    var options2 = {};
    options2.oldVal = _this.value;
    options2.newVal = value;
    let prop = this.getMetaObj().properties;
    if (this.type == ControlType.DYNAMICDICT) {
      if (value && !value.itemKey) {
        const form = this.getForm();
        if (prop.refDataElementKey) {
          const cxt = new ViewContext(form);
          const dataElementKey = await form.asyncEval(prop.refDataElementKey, cxt, null);
          options2.itemKey = await DictHandler.getItemKeyByDataElementKeyService(form, dataElementKey);
          if (value instanceof ItemData) {
            value.dataElementKey = dataElementKey;
            value.itemKey = options2.itemKey;
          }
        } else {
          options2.itemKey = await DictHandler.getItemKey(form, prop.refKey);
        }
      }
    }
    var isChanged = _this.behavior.checkAndSet(options2, prop);
    if (isChanged) {
      _this.backupValue = _this.value;
      _this.value = options2.newVal;
      _this.setControlValue(_this.value);
    }
    if (this.handler.isDict(this.type)) {
      this.handler.fetchDictCode(this);
    }
    return isChanged;
  }
  // 打开表单,头控件计算默认值commit = true
  async __setValueImpl(value, commit, editing, fireEvent, ignoreValueChanged) {
    var _a;
    var self = this, metaObj = self.getMetaObj(), handler = self.handler;
    var newValue = await handler.checkValue(self.ofFormID, metaObj.properties, metaObj.type, value, null, null, metaObj);
    var isChanged = await this.__setValue(newValue);
    if (isChanged) {
      await ((_a = this.advancedQueryObj) == null ? void 0 : _a.setControlAdvancedQueryValue(self.value));
      var ret;
      if (editing) {
        var validation = metaObj.dataBinding && metaObj.dataBinding.validation;
        var valid = true;
        if (validation) {
          valid = await handler.validated(self.ofFormID, validation);
        }
        if (valid) {
          await handler.doValueChanged(self, commit, editing, fireEvent, ignoreValueChanged);
        } else {
          var changing = metaObj.dataBinding && metaObj.dataBinding.valueChanging;
          if (handler.hasChanging(changing)) {
            self.changing = true;
            await handler.changing(self.ofFormID, changing);
          } else {
            self.rollbackValue();
          }
        }
        return ret;
      } else {
        await handler.doValueChanged(self, commit, editing, fireEvent, ignoreValueChanged);
        return true;
      }
    } else {
      if (self.impl && self.initValue) {
        self.setShowText(self.showText);
      }
    }
    return false;
  }
  // 打开表单,头控件计算默认值commit = true
  setValue(value, commit, editing, fireEvent, ignoreValueChanged) {
    return this.__setValueImpl(value, commit, editing, fireEvent, ignoreValueChanged);
  }
  /** 没有el时调用*/
  setControlValue(value) {
    if (this.impl && this.rendered) {
      this.checkEnd(value);
    }
  }
  /** 有el时调用*/
  checkEnd(value) {
    this.value = value;
  }
  reset() {
    if (this.needClean()) {
      this.__setValue(null);
    }
    this.resetStatus();
  }
  /** 获取控件真实值 */
  getValue() {
    return this.value;
  }
  /** 获取控件旧值 */
  getOldValue() {
    return this.backupValue;
  }
  /** 设置控件显示值，对应于界面显示。默认与setValue()相同，对于真实值与显示值不同的控件，可覆盖此方法。 */
  setText(text) {
    this.setValue(text);
  }
  /** 获取控件显示值，同setText */
  getText() {
    return this.getValue();
  }
  /** 获取图片地址*/
  getImageBase64URL(icon, thumbnail, sourceType) {
    return this.handler.getImageBase64URL(this, icon, thumbnail, sourceType);
  }
  /** 检查错误*/
  checkError() {
    return this.handler.checkError(this);
  }
  focus() {
    if (this.ofFormID && this.key) {
      this.ofFormID;
    }
    super.focus();
  }
}
class BarCoder extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  checkEnd(value) {
    this.value = value;
    this.impl && this.impl.setValue(value);
  }
  // async getBarCoder() {
  //     var metaObj = this.getMetaObj();
  //     var value = await this.handler.getBarCoder(this.value, metaObj)
  //     this.value = value;
  //     return value;
  // }
  // onRender(ct) {
  //     super.onRender(ct);
  //     this.checkEnd(this.value);
  // }
}
class BatchImageUploader extends BaseControl {
  constructor(meta) {
    super(meta);
    this.isDelete = false;
  }
  onRender(ct) {
    this.isDelete = false;
    this.checkEnd(this.image || this.value);
  }
  setControlValue(value) {
    if (this.sourceType == ImageSourceType.RESOURCE) {
      return;
    }
    super.setControlValue(value);
  }
  uploadImg($file, paras, files) {
    var self = this;
    return this.handler.uploadImage(self, $file, paras).then(function(data2) {
      if (data2) {
        var v = "", path = "";
        if (Utils.isString(data2)) {
          path = data2;
          data2 = data2.split(",");
        } else if (Utils.isArray(data2)) {
          data2 = data2.reverse();
          path = data2.join(",");
        }
        if (self.value) {
          v = self.value + "," + path;
        } else {
          v = path;
        }
        self.isDelete = false;
        self.commitValue(v).then(function(isChanged) {
          isChanged !== false && self.getForm().getUIOptTracer().traceOnValueChanged(self, self.value);
          return isChanged;
        });
      }
    });
  }
  async deleteImage(path) {
    var self = this;
    var vals = self.value.split(",");
    var index = vals.indexOf(path);
    if (index > -1) {
      vals.splice(index, 1);
    }
    var v = vals.join(",");
    self.isDelete = true;
    await self.commitValue(v).then(function(isChanged) {
      isChanged !== false && self.getForm().getUIOptTracer().traceOnValueChanged(self, self.value);
      return isChanged;
    });
    self.isDelete = false;
  }
  downloadImg(path) {
    return this.handler.downloadImg(this, path);
  }
  checkEnd(value) {
    this.value = value;
    if (this.isDelete)
      return;
    this.impl.splitValue(value);
  }
  dealWithValue(value) {
    var v = "", path = "";
    if (Utils.isString(value)) {
      path = value;
    } else if (Utils.isArray(value)) {
      value = value.reverse();
      path = value.join(",");
    }
    if (this.value) {
      v = this.value + "," + path;
    } else {
      v = path;
    }
    return v;
  }
  async takePhotoBymobile() {
    var form = this.getForm();
    var document2 = form && form.getDocument();
    var formKey = form.formKey;
    var oid = document2.oid || -1;
    var self = this;
    var result = await InterActiveFactory.Interactive.takePhotoForUpload(formKey, oid, this.maxSize, "", "");
    if (result) {
      self.isDelete = false;
      self.commitValue(self.dealWithValue(result));
    }
  }
  async selectPhotoBymobile(selectedNum) {
    var form = this.getForm();
    var document2 = form && form.getDocument();
    var formKey = form.formKey;
    var oid = document2.oid || -1;
    var self = this;
    var maxCount = this.maxCount > 0 ? this.maxCount : 9;
    var result = await InterActiveFactory.Interactive.multiSelectPhotoForUpload(maxCount - (selectedNum || 0), formKey, oid, this.maxSize, "");
    if (result) {
      self.isDelete = false;
      self.commitValue(self.dealWithValue(result));
    }
  }
}
class BPMGraph extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  onRender(ct) {
    super.onRender(ct);
    this.impl.createGraph();
  }
  checkEnd() {
    this.impl.createGraph();
  }
  refreshGraph() {
    this.impl && this.impl.createGraph();
  }
  isDataBinding() {
    return super.isDataBinding();
  }
  async loadData() {
    var graph = this;
    var meta = graph.getMetaObj().properties;
    var keyFormula = meta.processKey;
    var verFormula = meta.processVer;
    var pathFormula = meta.processPath;
    var OIDFomula = meta.OID;
    var form = this.getForm();
    var processKey = "", processVer = -1, path = "", OID = -1;
    if (keyFormula) {
      processKey = await form.asyncEval(keyFormula);
    }
    if (verFormula) {
      processVer = await form.asyncEval(verFormula);
    }
    if (pathFormula) {
      path = await form.asyncEval(pathFormula);
    }
    if (OIDFomula) {
      OID = await form.asyncEval(OIDFomula);
    }
    var isPastNodeInPath = function(transPath, node) {
      if (transPath) {
        for (var i2 = 0; i2 < transPath["steps"].length; i2++) {
          var step = transPath["steps"][i2];
          if (step.source == node.id) {
            return true;
          }
        }
      }
      return false;
    };
    var isLastNodeInPath = function(transPath, node) {
      if (transPath) {
        for (var i2 = 0; i2 < transPath["last"].length; i2++) {
          var step = transPath["last"][i2];
          if (step == node.id) {
            return true;
          }
        }
      }
      return node.last;
    };
    var isTransPathLine = function(transPath, transition, sourceId, targetId) {
      if (transPath) {
        var step;
        for (var i2 = 0; i2 < transPath["steps"].length; i2++) {
          step = transPath["steps"][i2];
          if (step.source == sourceId && step.target == targetId) {
            return true;
          }
        }
      }
      return transition.inpath;
    };
    return new BPMService(form).getProcessGraph(processKey, processVer, OID).then(function(transGraph) {
      if (transGraph != null) {
        var transPath;
        if (transGraph.transPath) {
          transPath = transGraph.transPath;
        } else {
          transPath = path;
        }
        graph.swims = transGraph.swims;
        var nodes = transGraph.nodes;
        var transitions = [];
        for (var j = 0, len = nodes.length; j < len; j++) {
          var node = nodes[j];
          node.isPastNodeInPath = isPastNodeInPath(transPath, node);
          node.isLastNodeInPath = isLastNodeInPath(transPath, node);
          var n_transitions = node.transitions;
          if (n_transitions) {
            for (var i2 = 0, size2 = n_transitions.length; i2 < size2; ++i2) {
              var n_transition = n_transitions[i2];
              var soureId = node.id;
              var targetId = n_transition["target-node-id"];
              var transition = {
                "lineStyle": n_transition["line-style"],
                "inpath": n_transition["inpath"],
                "source": node["key"],
                "tagName": n_transition["tag-name"],
                "target": n_transition["target-node-key"]
              };
              transition.isTransPathLine = isTransPathLine(transPath, transition, soureId, targetId);
              transitions.push(transition);
            }
          }
          delete node.transitions;
        }
        graph.nodes = nodes;
        graph.transitions = transitions;
        graph.refreshGraph();
      }
    });
  }
}
class Button extends BaseControl {
  // 按钮的默认显示类型
  constructor(meta) {
    super(meta);
    this.key = meta.key;
    this.type = meta.type;
    this.btnType = "default";
  }
  setText(s) {
    this.impl.setText(s);
  }
  async doOnClick(eventTarget) {
    if (this.enable) {
      return this.handler.doOnClick(this, this.onClick, null, eventTarget);
    }
  }
  checkEnd(value) {
    this.value = value;
    var caption = this.caption;
    if (this.value != null) {
      caption = this.value.toString();
    } else {
      if (this.hasDataBinding()) {
        caption = "";
      }
    }
    this.showText = caption;
    this.impl.setShowText(caption);
    this.impl.setTip(caption);
  }
  needClean() {
    return false;
  }
}
class Carousel extends BaseControl {
  constructor(meta) {
    super(meta);
    this.items = meta.items || [];
  }
  async checkItems() {
    var metaObj = this.getMetaObj();
    var prop = metaObj;
    var self = this;
    if (self.needRebuild || !prop.cache) {
      self.needRebuild = false;
      return await self.handler.getItems(this.getForm(), prop).then(function(items) {
        self.items = items;
        return items;
      }).catch((e) => {
        self.needRebuild = true;
        throw e;
      });
    } else {
      return null;
    }
  }
  getItems() {
    return this.items;
  }
  reset() {
    super.reset();
    this.needRebuild = true;
  }
  beforeDestroy() {
    this.impl && this.impl.destroy();
  }
  getValue() {
    return this.impl && this.impl.getValue();
  }
  getItemKey(index) {
    if (index) {
      return this.items[index] && this.items[index].key;
    } else {
      return this.impl && this.impl.getItemKey();
    }
  }
  async doOnClick() {
    if (this.enable) {
      return this.handler.doOnClick(this.ofFormID, this.onClick);
    }
  }
}
class ChartSourceType {
}
ChartSourceType.DATAOBJECT = 0;
ChartSourceType.STR_DATAOBJECT = "DataObject";
ChartSourceType.LISTVIEW = 1;
ChartSourceType.STR_LISTVIEW = "ListView";
ChartSourceType.MOGRIDDAL = 2;
ChartSourceType.STR_GRID = "Grid";
class chart extends BaseControl {
  constructor(meta) {
    super(meta);
    this.dataModel = null;
  }
  setDataModel(dataModel) {
    this.dataModel = dataModel;
  }
  getDataModel() {
    return this.dataModel;
  }
  async doOnClick(eventTarget) {
    return this.handler.doOnClick(this, this.onClick, null, eventTarget);
  }
  loadData() {
    var form = this.getForm();
    var metaChart = this.getMetaObj();
    var document2 = form.getDocument();
    var dataJSON = {};
    var dataSource = metaChart.dataSource;
    var sourceType = metaChart.sourceType;
    var categoryKey = new HashMap();
    if (dataSource != null) {
      if (sourceType == ChartSourceType.DATAOBJECT) {
        var table = document2.getByKey(dataSource.bindingKey);
        var metaCategory = dataSource.category;
        table.beforeFirst();
        var index = 0;
        var categoryCount = 0;
        var categories = [];
        if (metaCategory) {
          while (table.next()) {
            var o = table.getByKey(metaCategory.dataKey);
            var value = TypeConvertor.toString(o);
            if (!categoryKey.containsKey(value)) {
              categories.push(value);
              categoryKey.put(value, index);
              ++index;
              ++categoryCount;
            }
          }
        }
        dataJSON.categories = categories;
        var metaSeriesArray = dataSource.series;
        var series = [];
        if (metaSeriesArray && metaSeriesArray.length > 0) {
          metaSeriesArray.forEach(function(metaSeries, i2) {
            var splitDataKey = metaSeries.splitDataKey;
            var splitSeries = splitDataKey != null && splitDataKey != "";
            if (splitSeries) {
              var seriesMap = new HashMap();
              table.beforeFirst();
              var jsonObj = null;
              while (table.next()) {
                var splitData = table.getByKey(splitDataKey);
                var o2 = table.getByKey(metaSeries.dataKey);
                var value2 = TypeConvertor.toFloat(o2);
                jsonObj = seriesMap.get(splitData);
                if (jsonObj == null) {
                  jsonObj = {};
                  var data2 = [];
                  for (var i2 = 0; i2 < categoryCount; ++i2) {
                    data2.push(parseInt(0));
                  }
                  jsonObj.data = data2;
                  jsonObj.name = splitData.toString();
                  seriesMap.put(splitData, jsonObj);
                  series.push(jsonObj);
                }
                o2 = table.getByKey(metaCategory.dataKey);
                var c_value = TypeConvertor.toString(o2);
                var c_index = categoryKey.get(c_value);
                if (c_index != null) {
                  var data2 = jsonObj["data"];
                  data2[c_index] = value2;
                }
              }
            } else {
              table.beforeFirst();
              var jsonObj = { "name": metaSeries.title };
              var data2 = [];
              while (table.next()) {
                var o2 = table.getByKey(metaSeries.dataKey);
                var value2 = TypeConvertor.toInt(o2);
                data2.push(value2);
              }
              jsonObj.data = data2;
              series.push(jsonObj);
            }
          });
        }
        dataJSON.series = series;
      }
    }
    this.setDataModel(dataJSON);
    this.impl && this.impl.draw();
  }
  // doLayout(panelWidth, panelHeight) {
  // 	this.impl && this.impl.reDraw();
  // }
}
class CheckBox extends BaseControl {
  constructor(meta) {
    super(meta);
    this.value = meta.defaultValue;
    this.checked = meta.defaultValue == 1 ? true : false;
  }
  // setRc(rc) {
  //     this.yeschk = rc;
  // }
  checkEnd(value) {
    this.value = value;
    this.impl.setValue(value);
  }
  doClick() {
    this.isChecked = !this.isChecked;
  }
}
class CheckListBox extends BaseControl {
  // value 显示
  constructor(meta) {
    super(meta);
    this.checkList = true;
    this.columnCount = 3;
    this.valueStyle = "Card";
  }
  async checkItems(keepRebuild) {
    var metaObj = this.getMetaObj();
    var prop = metaObj.properties;
    var self = this;
    if (self.needRebuild || !prop.cache) {
      var items = await self.handler.getItems(self.ofFormID, prop);
      self.items = items;
      self.impl && self.impl.reset();
      !keepRebuild && (self.needRebuild = false);
      return items;
    } else {
      return self.items;
    }
  }
  reset() {
    super.reset();
    this.needRebuild = true;
  }
  async checkEnd(value) {
    this.value = value;
    var _this = this;
    var data2 = await this.checkItems(true);
    _this.impl.setValue(value);
    data2 = _this.items;
    var caption = _this.handler.getCaptionFromItems(_this.getMetaObj().properties, data2, value, true);
    _this.showText = caption;
    _this.setShowText(caption);
    _this.setTip(caption);
    _this.impl.setIsEmpty(caption);
  }
  checkItem(value) {
    this.checkItem(value);
  }
  async dependedValueChange() {
    this.needRebuild = true;
    if (this.viewStyle == "Tiled") {
      this.impl && this.impl.refresh();
    }
    if (!this.isSubDetail) {
      var needResetValue = await this.handler.calcNeedRebuild(this);
      if (needResetValue) {
        return this.setValue(null, true, true, true);
      }
    }
    return true;
  }
  beforeDestroy() {
    this.impl && this.impl.destroy();
  }
}
class ComboBox extends BaseControl {
  constructor(meta) {
    super(meta);
    this.items = meta.properties.items;
  }
  isNull() {
    if (this.integerValue && this.value == 0) {
      this.items = this.items || [];
      for (var i2 = 0; i2 < this.items.length; i2++) {
        var item = this.items[i2];
        if (item.value == this.value) {
          return false;
        }
      }
    }
    return this.value == null || this.value == "";
  }
  async checkItems() {
    var metaObj = this.getMetaObj();
    var prop = metaObj.properties;
    var self = this;
    if (self.needRebuild || !prop.cache) {
      try {
        self.needRebuild = false;
        self.items = await self.handler.getItems(self.ofFormID, prop);
        self.impl && self.impl.reset();
        return self.items;
      } catch (error) {
        self.needRebuild = true;
      }
    } else {
      return self.items;
    }
  }
  getItems() {
    return this.items;
  }
  reset() {
    super.reset();
    this.needRebuild = true;
  }
  async dependedValueChange() {
    this.needRebuild = true;
    if (this.viewStyle == "Tiled") {
      this.impl && this.impl.refresh();
    }
    if (!this.isSubDetail) {
      var needResetValue = await this.handler.calcNeedRebuild(this);
      if (needResetValue) {
        return this.setValue(null, true, true, true);
      }
    }
    return true;
  }
  checkEnd(value) {
    this.value = value;
    var _this = this;
    this.checkItems().then((data2) => {
      checkCompState$1(this);
      var data2 = _this.items;
      _this.impl.setValue(_this.value);
      var caption = _this.handler.getCaptionFromItems(_this.getMetaObj().properties, data2, _this.value, false);
      caption = _this.impl.getIntCaption(data2, caption);
      _this.showText = caption;
      _this.impl.setShowText(caption);
      _this.impl.setTip(caption);
      if (!_this.value) {
        _this.impl.hideClearBtn();
      }
    });
  }
}
class ComboView extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  closeOnComboView() {
    this.impl && this.impl.closeOnComboView();
  }
  onRender(ct) {
    super.onRender(ct);
    this.showText = this.caption;
  }
  destroy() {
    this.root.destroy();
    super.destroy();
  }
  checkError() {
    let com = this.root, exception;
    const throwCompError = function(com2) {
      if (com2.isPanel) {
        for (let i2 = 0; i2 < com2.items.length; i2++) {
          if (throwCompError(com2.items[i2]))
            break;
        }
      } else {
        exception = com2.checkError();
      }
      return exception;
    };
    return throwCompError(com);
  }
}
const data$3 = new HashMap();
class HandlerProvider {
  static reg(type, Control) {
    data$3.put(type, Control);
  }
  static get(type = -1) {
    const result = data$3.get(type);
    if (!result) {
      return data$3.get(-1);
    }
    return result;
  }
  static getMap() {
    return data$3;
  }
}
class JoinPoint {
  constructor(target, args) {
    this.target = target;
    this.args = args;
  }
  getTarget() {
    return this.target;
  }
  getArgs() {
    return this.args;
  }
}
var beforeMap = /* @__PURE__ */ new Map();
var afterMap = /* @__PURE__ */ new Map();
const doBefore = (method, target, args) => {
  try {
    var key = method.toLowerCase();
    var list = beforeMap.get(key);
    if (!list) {
      return;
    }
    var point = new JoinPoint(target, args);
    list.reduce((prev, process) => {
      return process(point);
    }, true);
  } catch (e) {
    console.error(e);
  }
};
const doAfter = (method, target, args) => {
  try {
    var key = method.toLowerCase();
    var list = afterMap.get(key);
    if (!list) {
      return;
    }
    var point = new JoinPoint(target, args);
    list.reduce((prev, process) => {
      return process(point);
    }, true);
  } catch (e) {
    console.error(e);
  }
};
const CompEventListener = (params = {}) => (target, name2, descriptor) => {
  const origin = descriptor.value;
  descriptor.value = async function(...args) {
    console.log("................." + name2);
    var ret;
    doBefore(name2, this, args);
    try {
      ret = await origin.apply(this, args);
    } finally {
      doAfter(name2, this, args);
    }
    return ret;
  };
  return descriptor;
};
class CompAspects {
  constructor() {
  }
  static addPointcut(clazz, method) {
    var org = clazz[method];
    clazz[method] = function() {
      var ret;
      doBefore(method, this, arguments);
      ret = org.apply(this, arguments);
      doAfter(method, this, arguments);
      return ret;
    };
  }
  static before(method, fn) {
    var key = method.toLowerCase();
    var list = beforeMap.get(key);
    if (!list) {
      list = [];
      beforeMap.set(key, list);
    }
    list.push(fn);
  }
  static after(method, fn) {
    var key = method.toLowerCase();
    var list = afterMap.get(key);
    if (!list) {
      list = [];
      afterMap.set(key, list);
    }
    list.push(fn);
  }
}
var __defProp$e = Object.defineProperty;
var __getOwnPropDesc$e = Object.getOwnPropertyDescriptor;
var __decorateClass$e = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$e(target, key) : target;
  for (var i2 = decorators.length - 1, decorator; i2 >= 0; i2--)
    if (decorator = decorators[i2])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$e(target, key, result);
  return result;
};
class ButtonHandler extends BaseHandler {
  static doOnClick(btn, formula, key, event2) {
    var form = btn.getForm();
    var click = function() {
      var key2 = btn.key;
      HeadInfoUtil.put(btn, HeadInfoOptType.STR_BUTTON, form.formID);
      if (form.getEvent(key2)) {
        try {
          return form.doEvent(key2);
        } finally {
          HeadInfoUtil.clear();
        }
      } else {
        var cxt = new ViewContext(form);
        event2 && cxt.setTarget(event2.target);
        let activity = btn.activity;
        if (activity && activity != "") {
          return form.checkDataAuthority(activity).then(function() {
            return form.asyncEval(formula, cxt).then(function(ret) {
              return ret;
            }).finally(() => {
              HeadInfoUtil.clear();
            });
          });
        } else {
          return form.asyncEval(formula, cxt).then(function(ret) {
            return ret;
          }).finally(() => {
            HeadInfoUtil.clear();
          });
        }
      }
    };
    return click();
  }
}
__decorateClass$e([
  CompEventListener()
], ButtonHandler, "doOnClick", 1);
var __defProp$d = Object.defineProperty;
var __getOwnPropDesc$d = Object.getOwnPropertyDescriptor;
var __decorateClass$d = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$d(target, key) : target;
  for (var i2 = decorators.length - 1, decorator; i2 >= 0; i2--)
    if (decorator = decorators[i2])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$d(target, key, result);
  return result;
};
const cache$c = new LRUCache(20);
const getCacheKey$3 = async (form, prop, cxt) => {
  if (prop.cache) {
    var data2 = {};
    data2["key"] = prop.key;
    data2["formKey"] = form.getFormKey();
    var dependency = prop.dependency;
    if (dependency) {
      await dependency.split(",").reduce(async (prev, field) => {
        await prev;
        var value = await form.__eval(field, cxt);
        data2[field] = value;
      }, true);
      return JSON.stringify(data2);
    }
    return JSON.stringify(data2);
  }
  return null;
};
const getFormulaItems$3 = (form, prop, cxt) => {
  var items = [];
  if (prop.formulaItems) {
    return form.asyncEval(prop.formulaItems, cxt).then((rs) => {
      if (typeof rs === "string") {
        var item_Arr = rs.split(";");
        for (var i2 = 0, len = item_Arr.length; i2 < len; i2++) {
          var item_obj = item_Arr[i2].split(",");
          var item = {
            key: item_obj[0],
            caption: item_obj[1],
            value: item_obj[2]
          };
          items == null ? void 0 : items.push(item);
        }
        return items;
      } else if (rs instanceof DataTable) {
        rs.beforeFirst();
        if (rs.cols.length > 0) {
          while (rs.next()) {
            items.push({
              key: TypeConvertor.toString(rs.get(0)),
              caption: TypeConvertor.toString(rs.get(1)),
              value: TypeConvertor.toString(rs.get(2))
            });
          }
          return items;
        }
      } else if (Utils.isArray(rs)) {
        for (var i2 = 0, len1 = rs.length; i2 < len1; i2++) {
          items.push({
            key: rs[i2].Key,
            caption: rs[i2].Caption,
            value: rs[i2].Image
          });
        }
        return items;
      } else if (rs && Utils.isArray(rs.items)) {
        return items.concat(rs.items);
      } else {
        return items;
      }
    });
  }
  return items;
};
class CarouselHandler extends BaseHandler {
  //获取下拉框的值
  static async getItems(form, prop, loc, defKey) {
    var sourceType = prop.sourceType;
    var cxt, ret;
    if (loc) {
      cxt = new ViewContext(form);
      cxt.updateLocation(loc.getKey(), loc.getRow(), -1);
    }
    if (sourceType == ComboboxSourceType.ITEMS) {
      return prop.items;
    } else if (sourceType == ComboboxSourceType.FORMULA) {
      var cacheKey = await getCacheKey$3(form, prop, cxt);
      if (cacheKey) {
        var items = cache$c.get(cacheKey);
        ret = items ? items : null;
      }
      if (ret == null) {
        var items = await getFormulaItems$3(form, prop, cxt);
        if (prop.cache && cacheKey) {
          cache$c.set(cacheKey, items);
        }
        return items;
      }
      return ret;
    }
  }
  static doOnClick(formID2, formula, ...args) {
    return super.doOnClick(formID2, formula, ...args);
  }
}
__decorateClass$d([
  CompEventListener()
], CarouselHandler, "doOnClick", 1);
class CheckBoxHandler extends BaseHandler {
}
class CheckListBoxHandler extends ComboBoxHandler {
}
var __defProp$c = Object.defineProperty;
var __getOwnPropDesc$c = Object.getOwnPropertyDescriptor;
var __decorateClass$c = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$c(target, key) : target;
  for (var i2 = decorators.length - 1, decorator; i2 >= 0; i2--)
    if (decorator = decorators[i2])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$c(target, key, result);
  return result;
};
class CountDownViewHandler extends BaseHandler {
  static doOnFinish(countDownView, content) {
    var form = countDownView.getForm();
    return form.asyncEval(content);
  }
  static doOnClick(formID2, formula, ...args) {
    return super.doOnClick(formID2, formula, ...args);
  }
}
__decorateClass$c([
  CompEventListener()
], CountDownViewHandler, "doOnClick", 1);
class DatePickerHandler extends BaseHandler {
}
class DialogHandler extends BaseHandler {
  doOnClick(formID2, formula, opt, callback) {
    if (callback) {
      return callback(opt).catch(function(e) {
        console.log(e.stack);
        var form = FormStack.getForm(formID2);
        if (form) {
          return form.asyncEval(formula).catch(function(e2) {
            console.log(e2.stack);
            throw e2;
          });
        }
      });
    } else {
      return Promise.resolve(true);
    }
  }
}
class DictViewHandler extends BaseHandler {
  static async doOnRowClick(dictView) {
    var rowClick = dictView.getMetaObj().rowClick;
    if (rowClick) {
      try {
        LoadingUtil.show();
        return await dictView.getForm().asyncEval(rowClick);
      } finally {
        LoadingUtil.hide();
      }
    }
    return Promise.resolve();
  }
  static async doOnFocusRowChange(dictView) {
    var focusRowChanged = dictView.getMetaObj().focusRowChanged;
    if (focusRowChanged) {
      try {
        LoadingUtil.show();
        return await dictView.getForm().asyncEval(focusRowChanged);
      } finally {
        LoadingUtil.hide();
      }
    }
    return Promise.resolve();
  }
  static async doOnRowDblClick(dictView) {
    var dblClick = dictView.getMetaObj().dblClick;
    if (dblClick) {
      try {
        LoadingUtil.show();
        return await dictView.getForm().asyncEval(dblClick);
      } finally {
        LoadingUtil.hide();
      }
    }
    return Promise.resolve();
  }
  static async getDictChildren(dictView, nodeValue, deep = false) {
    const id = nodeValue.itemKey + "_" + nodeValue.oid;
    if (dictView.loadType == DictLoadType.L2R) {
      if (dictView.cacheData) {
        var nodes = dictView.cacheData[id];
        if (!nodes) {
          nodes = [];
        }
        return nodes;
      } else {
        const dictService = new DictService(dictView.getForm());
        var filter = await this.getDictFilter(dictView);
        const data2 = await dictService.getAllItems2(
          dictView.itemKey,
          dictView.root,
          filter,
          -1,
          dictView.getForm().formKey,
          dictView.getMetaObj().key
        );
        dictView.setCacheData(data2);
        dictView.cacheData ? dictView.cacheData : dictView.cacheData = {};
        let tempData = dictView.cacheData[id];
        if (!tempData) {
          tempData = [];
        }
        return tempData;
      }
    } else {
      if (dictView.dictType == SecondaryType.COMPDICT) {
        const filters = await this.getCompDictFilter(dictView);
        let formKey = null;
        const form = dictView.getForm();
        if (form) {
          formKey = form.getFormKey();
        }
        return new DictService(dictView.getForm()).getCompAllItems(dictView.itemKey, nodeValue, filters, null, formKey);
      } else {
        if (deep) {
          const dictService = new DictService(dictView.getForm());
          var filter = await this.getDictFilter(dictView);
          const data2 = await dictService.getAllItems2(
            dictView.itemKey,
            nodeValue,
            filter,
            -1,
            dictView.getForm().formKey,
            dictView.getMetaObj().key
          );
          return data2;
        } else {
          const filter2 = await this.getDictFilter(dictView);
          return new DictService(dictView.getForm()).getDictChildren(dictView.itemKey, nodeValue, filter2);
        }
      }
    }
  }
  static async getQueryData(dictView, pageNum) {
    var startRow = (pageNum - 1) * dictView.pageRowCount;
    var pageIndicatorCount = dictView.pageIndicatorCount;
    var maxRows = dictView.pageRowCount;
    var fuzzyValue = dictView.getQueryValue();
    var filter = await this.getDictFilter(dictView);
    var data2 = await new DictService(dictView.getForm()).getQueryData(
      dictView.itemKey,
      startRow,
      maxRows,
      pageIndicatorCount,
      fuzzyValue,
      null,
      filter,
      null
    );
    var pageInfo = {
      currentPage: pageNum,
      total: startRow + data2.totalRowCount,
      pageSize: dictView.pageRowCount,
      pageLoadType: PageLoadType.DB,
      pagerCount: dictView.pageIndicatorCount,
      layouts: ["PrevPage", "Number", "NextPage"],
      align: "center"
    };
    dictView.pageInfo = pageInfo;
    return data2.data;
  }
  static async getOrgQueryData(dictView, itemKey, startRow, maxRows, pageIndicatorCount, fuzzyValue, stateMask, filter, root) {
    const result = await new DictService(dictView.getForm()).getOrgQueryData(itemKey, startRow, maxRows, pageIndicatorCount, fuzzyValue, stateMask, filter, root);
    const c_result = { ...result };
    const childs = result.data;
    const items = ItemDataUtil.fromJSONBaseItems(childs);
    c_result.data = items;
    return c_result;
  }
  static doGoToPage(dictView, pageNum) {
    return this.getQueryData(dictView, pageNum).then((data2) => {
      dictView.show(data2);
    });
  }
  // static async doGoToPage (dictView, index, isResetPageNum) {
  //     const itemKey = dictView.itemKey;
  //     const maxRows = dictView.pageRowCount;
  //     const pageIndicatorCount = dictView.pageIndicatorCount;
  //     const value = dictView.getQueryValue();
  //     const startRow = index <= 0 ? 0 : dictView.pageRowCount * index;
  //     const form = FormStack.getForm(dictView.ofFormID);
  //     const result = await new DictServiceExt(null).getOrgQueryData(itemKey, startRow, maxRows, pageIndicatorCount, value, null, dictView.dictFilter, form);
  //     if (result) {
  //         //清空数据
  //         dictView.isResetPageNum = isResetPageNum;
  //         $('tr:gt(1)', dictView._$table).remove()
  //         const nodes = result.data;
  //         const len = nodes.length;
  //         if (len > 0) {
  //             const pId = dictView.root.id;
  //             nodes[len - 1].islast = true;
  //             let prevId = null;
  //             for (let i = 0, len = nodes.length; i < len; i++) {
  //                 if (prevId != null) {
  //                     nodes[i].previd = prevId;
  //                 }
  //                 nodes[i].id = nodes[i].itemKey + '_' + nodes[i].OID;
  //                 prevId = nodes[i].id;
  //                 nodes[i].pid = pId;
  //             }
  //             dictView.addNodes(nodes);
  //             dictView.setTotalRowCount(startRow + result.totalRowCount);
  //             await dictView.focusNode(nodes[0].id);
  //         } else {
  //             dictView.setTotalRowCount(len);
  //         }
  //     }
  // }
  static doOnSearchClick(dictView) {
    return this.doGoToPage(dictView, 1);
  }
  static async doOnTreeClick(dictView, rowIndex, expanded) {
    var rowData = dictView.getRowDataAt(rowIndex);
    var data2 = dictView.getDatas();
    if (expanded) {
      var size2 = 0;
      for (var i2 = rowIndex + 1, row; row = data2[i2]; i2++) {
        if (row.treeLevel == rowData.treeLevel)
          break;
        var parent2 = row.parentRow;
        if (parent2) {
          parent2.children.push(row);
          parent2.expanded = false;
          size2++;
        }
      }
      data2.splice(rowIndex + 1, size2);
    } else {
      var children = rowData.children;
      if (children && children.length) {
        children.unshift(rowIndex + 1, 0);
        Array.prototype.splice.apply(data2, children);
        children.length = 0;
      } else {
        var nodeValue = new ItemData({ oid: rowData.oid, itemKey: dictView.itemKey });
        var data2 = await this.getDictChildren(dictView, nodeValue);
        if (data2 && data2.length) {
          this.showData(dictView, data2, rowIndex, rowData);
        }
      }
    }
    rowData.expanded = !expanded;
    return dictView.refresh();
  }
  static showData(dictView, data2, index, parentRow) {
    var columns = dictView.columns;
    data2.forEach((d) => {
      var rowIndex = dictView.insertRow(++index, d["OID"], d["NodeType"], parentRow);
      columns.forEach((column, index2) => {
        dictView.setValueAt(rowIndex, index2, d[column.key]);
      });
    });
  }
  getParentPath(dictView, itemData) {
    return new DictService(dictView.getForm()).getParentPath(dictView.itemKey, itemData);
  }
  getItem(dictView, itemKey, oid) {
    return new DictService(dictView.getForm()).getItem(itemKey, oid);
  }
  static async getMetaFilter(form, meta, itemKey, cxt) {
    var itemFilters = meta.itemFilters;
    if (itemFilters) {
      var itemFilter = itemFilters[itemKey] || itemFilters[""];
      if (itemFilter) {
        var result = null;
        await itemFilter.reduce(async (prev, filter) => {
          await prev;
          if (!result) {
            if (filter.cond) {
              var ret = await form.asyncEval(filter.cond, cxt);
              if (ret)
                result = filter;
            } else {
              result = filter;
            }
          }
        }, true);
        return result;
      }
    }
    return null;
  }
  static async getDictFilter(dictView) {
    var filter = await this.getDictFilterImpl(dictView.getForm(), dictView.getMetaObj(), dictView.itemKey);
    return dictView.dictFilter = filter;
  }
  static async getDictFilterImpl(form, meta, itemKey, cxt) {
    var formKey = form.getFormKey(), fieldKey = meta.key;
    var metaFilter = await this.getMetaFilter(form, meta, itemKey, cxt);
    if (metaFilter) {
      var dictFilter = {};
      dictFilter.itemKey = itemKey;
      dictFilter.formKey = formKey;
      dictFilter.fieldKey = fieldKey;
      dictFilter.filterIndex = metaFilter.filterIndex;
      dictFilter.dependency = metaFilter.dependency;
      dictFilter.values = [];
      await metaFilter.filterVals.reduce(async (prev, filterVal) => {
        await prev;
        var value = null;
        switch (filterVal.type) {
          case FilterValueType.CONST:
            value = filterVal.refVal;
            break;
          case FilterValueType.FORMULA:
            value = await form.getUIProcess().evalFilter(fieldKey, filterVal.refVal);
            break;
          case FilterValueType.FIELD:
            const cxt2 = new ViewContext(form);
            value = await form.asyncEval(filterVal.refVal, cxt2, null);
            break;
        }
        if (value instanceof Date) {
          value = value.getTime();
        }
        dictFilter.values.push(value);
      }, true);
      return dictFilter;
    }
    return null;
  }
  static getItemKey(form, meta) {
    return form.asyncEval(meta.formulaItemKey);
  }
  static async getDVInfo(form, meta) {
    var itemKey = await this.getItemKey(form, meta);
    return new MetaService(form).getDataObject(itemKey);
  }
  static getDataObject(form, itemKey) {
    return new MetaService(form).getDataObject(itemKey);
  }
  static async getCompDictFilter(dictView) {
    var _a, _b;
    let items = (_b = (_a = dictView.getForm().getDataObject()) == null ? void 0 : _a.relation) == null ? void 0 : _b.items;
    let self = this;
    let dictFilters = [];
    if (items != null) {
      for (let i2 = 0, len = items.length; i2 < len; i2++) {
        let item = items[i2];
        let itemKey = item.itemKey;
        var filter = await self.getDictFilterImpl(dictView.getForm(), dictView.getMetaObj(), itemKey);
        if (filter != null) {
          dictFilters.push(filter);
        }
      }
    }
    if (dictFilters.length > 0) {
      return dictView.dictFilter = dictFilters;
    } else {
      return null;
    }
  }
}
var __defProp$b = Object.defineProperty;
var __getOwnPropDesc$b = Object.getOwnPropertyDescriptor;
var __decorateClass$b = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$b(target, key) : target;
  for (var i2 = decorators.length - 1, decorator; i2 >= 0; i2--)
    if (decorator = decorators[i2])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$b(target, key, result);
  return result;
};
class DropdownButtonHandler extends BaseHandler {
  static doOnClick(formID2, formula, ...args) {
    return super.doOnClick(formID2, formula, ...args);
  }
}
__decorateClass$b([
  CompEventListener()
], DropdownButtonHandler, "doOnClick", 1);
class PageHandler {
  static doGoToPage(control, currentPage, pageSize = control.pageInfo.pageSize) {
    control.getForm().getUIOptTracer().traceOnClick(event, control, { currentPage });
    control.pageInfo.currentPage = currentPage;
    control.pageInfo.pageSize = pageSize;
    if (control.pageLoadType == PageLoadType.UI) {
      return control.load();
    } else {
      var form = control.getForm(), filterMap = form.getFilterMap(), filterType = filterMap.getType(), startRi = (currentPage - 1) * pageSize, tableKey = control.tableKey;
      filterMap.setOID(form.getOID());
      filterMap.setType(DocumentType.DETAIL);
      filterMap.getTblFilter(tableKey).startRow = startRi;
      filterMap.getTblFilter(tableKey).maxRows = pageSize;
      LoadingUtil.show();
      return new DocService(form).loadFormData(form).then(function(newDoc) {
        var doc = form.getDocument(), dataTable = newDoc.getByKey(tableKey);
        doc.setByKey(tableKey, dataTable);
        var startCount = RowCountUtil.getStartRowCount(newDoc, tableKey);
        RowCountUtil.setStartRowCount(doc, tableKey, startCount);
        var datas = newDoc.getExpData(DocExpandDataKeys.DICT_CAPTIONS);
        var captionCache = doc.getExpData(DocExpandDataKeys.DICT_CAPTIONS);
        captionCache = captionCache || {};
        Object.assign(captionCache, datas);
        return control.load();
      }).finally(function() {
        filterMap.setType(filterType);
        LoadingUtil.hide();
      });
    }
  }
  static refreshPage(grid) {
    var tableKey = grid.tableKey;
    var pageInfo = grid.pageInfo;
    if (grid.pageLoadType != PageLoadType.NONE && grid.needRefresh) {
      var doc = grid.getForm().getDocument();
      var total = doc.getByKey(tableKey).size();
      var rowCount = RowCountUtil.getStartRowCount(doc, tableKey);
      if (rowCount > 0) {
        total = rowCount;
      }
      var totalCount = RowCountUtil.getTotalRowCount(doc, tableKey);
      if (totalCount != -1) {
        total = totalCount;
      }
      var pageCount = Math.ceil(total / pageInfo.pageSize);
      pageInfo.pageCount = pageCount == 0 ? 1 : pageCount;
      pageInfo.total = total;
      pageInfo.showTotalPage = totalCount != -1;
    } else {
      pageInfo.total = grid.getAllRowCount();
    }
  }
}
class SelectHandler extends BaseHandler {
  // 多选
  static async doSelectMulti(grid, colIndex, start, end, value) {
    grid.selectMulting = true;
    let startRow = grid.getRowDataAt(start);
    let endRow = grid.getRowDataAt(end);
    start = grid.getAllRowIndexByID(startRow.rowId);
    end = grid.getAllRowIndexByID(endRow.rowId);
    await grid.getAllData().slice(start, end + 1).reduce(async (prev, row, i2) => {
      await prev;
      if (row.isDetail && row.bkmkRow) {
        let view_index = grid.getRowIndexByID(row.rowId);
        if (view_index != null) {
          if (grid.isCellEnable(view_index, colIndex)) {
            return grid.__setValueAtImpl(view_index, colIndex, value, true, true, true);
          }
        } else {
          if (grid.isAllCellEnable(start + i2, colIndex)) {
            return grid.__setAllDataValueAt(start + i2, colIndex, value, true, true, true);
          }
        }
      }
    }, true);
    grid.selectMulting = false;
    if (colIndex == grid.selectFieldIndex) {
      await this.selectRowChanged(grid);
    }
    grid.refreshSelectAll(colIndex);
  }
  // 全选
  static async doSelectAll(grid, value, col) {
    let colIndex = typeof col == "string" ? grid.findIndex(col) : col;
    let column = grid.getColumnAt(colIndex);
    let form = grid.getForm();
    grid.selectMulting = true;
    await grid.getAllData().reduce(async (prev, row, all_index) => {
      await prev;
      if (row.isDetail && row.bkmkRow) {
        let view_index = grid.getRowIndexByID(row.rowId);
        if (view_index != null) {
          if (grid.isCellEnable(view_index, colIndex)) {
            return grid.__setValueAtImpl(view_index, colIndex, value, true, true, true, false, column.onSelect);
          }
        } else {
          if (grid.isAllCellEnable(all_index, colIndex)) {
            return grid.__setAllDataValueAt(all_index, colIndex, value, true, false, false);
          }
        }
      }
    }, true);
    if (column.onSelect) {
      try {
        LoadingUtil.show();
        form.setPara("SelectValue", value);
        var cxt = new ViewContext(form);
        cxt.updateLocation(grid.key, -1, colIndex);
        cxt.setGrid(grid);
        await form.asyncEval(column.onSelect, cxt);
      } finally {
        form.rmvPara("SelectValue");
        LoadingUtil.hide();
      }
    }
    if (colIndex == grid.selectFieldIndex) {
      await this.selectRowChanged(grid);
    }
    grid.selectMulting = false;
  }
  // 单选,清除其他字段,多选,检查全选
  static async doSelectRow(grid, rowIndex, colIndex, editOpt, value) {
    if (editOpt.cellType == ControlType.CHECKBOX || editOpt.columnType == ControlType.CHECKBOX) {
      let { enableHalfCheck } = editOpt.editOptions || editOpt.properties;
      if (enableHalfCheck && !value) {
        delete grid.getCellDataAt(rowIndex, colIndex).halfChecked;
      }
      let column = grid.getColumnAt(colIndex);
      let singleSelect = editOpt.singleSelect;
      if (column.singleSelect != null) {
        singleSelect = column.singleSelect;
      }
      if (!grid.selectMulting && singleSelect && value) {
        await this.checkSingle(grid, rowIndex, colIndex, editOpt, value);
      }
      if (!grid.selectMulting && grid.hasTree) {
        await this.checkTreeDepend(grid, rowIndex, colIndex, editOpt, value);
      }
      if (colIndex == grid.selectFieldIndex) {
        let oldCount = grid.selectCount;
        this.selectRowImpl(grid, rowIndex, value);
        let selectRowChanged;
        if (singleSelect) {
          selectRowChanged = value;
        } else {
          selectRowChanged = oldCount != grid.selectCount;
        }
        if (!grid.selectMulting && selectRowChanged) {
          await this.selectRowChanged(grid);
        }
      }
      if (!grid.selectMulting && !grid.isEmptyRow(rowIndex)) {
        grid.refreshSelectAll(colIndex);
      }
    }
  }
  // 选中行变化,包括单选和多选
  static selectRowChanged(grid) {
    var form = grid.getForm(), monitor = form.getViewDataMonitor();
    return monitor.selectRowChanged(grid);
  }
  //单选时,清除其他字段
  static async checkSingle(grid, rowIndex, colIndex, editOpt, value) {
    grid.selectMulting = true;
    await grid.getDatas().reduce(async (prev, row, index) => {
      return prev.then(() => {
        if (row.isDetail && index != rowIndex) {
          if (row.bkmkRow) {
            return grid.__setValueAtImpl(index, colIndex, null, true, true, true);
          }
          return grid.__setValueAt(index, colIndex, null);
        }
      });
    }, Promise.resolve());
    grid.selectMulting = false;
  }
  // 设置父行选中状态
  static async setParentNodeCheckBox(grid, rowData, colIndex, enableHalfCheck, value) {
    let parentRow = rowData.parentRow;
    if (parentRow) {
      let parentIndex = grid.getRowIndexByID(parentRow.rowId);
      if (grid.isCellEnable(parentIndex, colIndex)) {
        if (value) {
          await grid.__setValueAtImpl(parentIndex, colIndex, true, true, true, true);
        } else {
          let hasSonChecked = this.hasSonChecked(grid, parentRow, colIndex);
          if (!hasSonChecked) {
            await grid.__setValueAtImpl(parentIndex, colIndex, false, true, true, true);
          }
        }
        let cellData = parentRow.data[colIndex];
        if (enableHalfCheck && cellData.value) {
          this.checkRowHalfChecked(grid, parentRow, parentIndex, colIndex);
        }
      }
      return this.setParentNodeCheckBox(grid, parentRow, colIndex, enableHalfCheck, value);
    }
  }
  // 设置子行选中状态
  static async setSonNodeCheckBox(grid, rowData, colIndex, enableHalfCheck, checked) {
    let childRows = rowData.childRows;
    if (childRows && childRows.length > 0) {
      let sonIdx, sonRow;
      for (let i2 = 0; i2 < childRows.length; i2++) {
        sonIdx = grid.getRowIndexByID(childRows[i2]);
        if (sonIdx != null) {
          sonRow = grid.getRowDataAt(sonIdx);
          if (grid.isCellEnable(sonIdx, colIndex)) {
            await grid.__setValueAtImpl(sonIdx, colIndex, checked, true, true, true);
          }
          await this.setSonNodeCheckBox(grid, sonRow, colIndex, enableHalfCheck, checked);
        } else {
          sonIdx = grid.getAllRowIndexByID(childRows[i2]);
          if (sonIdx != null) {
            sonRow = grid.getAllRowDataAt(sonIdx);
            if (grid.isAllCellEnable(sonIdx, colIndex)) {
              await grid.__setAllDataValueAt(sonIdx, colIndex, checked, true, true, true);
            }
            await this.setSonNodeCheckBox(grid, sonRow, colIndex, enableHalfCheck, checked);
          }
        }
      }
    }
  }
  // 检查子是否有选中
  static hasSonChecked(grid, rowData, colIndex) {
    let childRows = rowData.childRows, rowIdx;
    for (let i2 = 0; i2 < childRows.length; i2++) {
      rowIdx = grid.getAllRowIndexByID(childRows[i2]);
      if (rowIdx != null) {
        if (grid.getAllValueAt(rowIdx, colIndex)) {
          return true;
        }
      }
    }
    return false;
  }
  // 递归检查父行半选
  static checkParentHalfChecked(grid, rowData, colIndex) {
    let parentRow = rowData.parentRow;
    if (parentRow) {
      let cellData = parentRow.data[colIndex];
      if (cellData.value) {
        cellData.halfChecked = this.__doHalfChecked(grid, parentRow, colIndex);
        let parentIndex = grid.getRowIndexByID(parentRow.rowId);
        grid.updateHalfChecked(parentIndex, colIndex);
        return this.checkParentHalfChecked(grid, parentRow, colIndex);
      }
    }
  }
  // 检查是否半选
  static checkRowHalfChecked(grid, rowData, rowIndex, colIndex) {
    let cellData = rowData.data[colIndex];
    cellData.halfChecked = this.__doHalfChecked(grid, rowData, colIndex);
    grid.updateHalfChecked(rowIndex, colIndex);
  }
  // 判断一行是否半选
  static __doHalfChecked(grid, rowData, colIndex) {
    let childRows = rowData.childRows;
    if (childRows && childRows.length > 0) {
      let sonIdx, sonData, sonValue;
      for (let i2 = 0; i2 < childRows.length; i2++) {
        sonIdx = grid.getAllRowIndexByID(childRows[i2]);
        sonValue = grid.getAllValueAt(sonIdx, colIndex);
        if (!sonValue) {
          return true;
        }
        sonData = grid.getAllRowDataAt(sonIdx);
        let halfChecked = this.__doHalfChecked(grid, sonData, colIndex);
        if (halfChecked) {
          return true;
        }
      }
    }
    return false;
  }
  // 树形联动处理
  static async checkTreeDepend(grid, rowIndex, colIndex, editOpt, value) {
    grid.selectMulting = true;
    let rowData = grid.getRowDataAt(rowIndex);
    if (!rowData.isLeaf && !rowData.childRows) {
      await grid.loadChildren(rowIndex);
    }
    let editOptions = editOpt.editOptions;
    let { checkedType, unCheckedType, enableHalfCheck } = editOptions;
    if (value) {
      if ((checkedType == null ? void 0 : checkedType.toLowerCase().indexOf("s")) > -1) {
        await this.setSonNodeCheckBox(grid, rowData, colIndex, enableHalfCheck, true);
      } else {
        if (enableHalfCheck) {
          this.checkRowHalfChecked(grid, rowData, rowIndex, colIndex);
        }
      }
      if ((checkedType == null ? void 0 : checkedType.toLowerCase().indexOf("p")) > -1) {
        await this.setParentNodeCheckBox(grid, rowData, colIndex, enableHalfCheck, true);
      } else {
        if (enableHalfCheck) {
          this.checkParentHalfChecked(grid, rowData, colIndex);
        }
      }
    } else {
      if ((unCheckedType == null ? void 0 : unCheckedType.toLowerCase().indexOf("s")) > -1) {
        await this.setSonNodeCheckBox(grid, rowData, colIndex, enableHalfCheck, false);
      }
      if ((unCheckedType == null ? void 0 : unCheckedType.toLowerCase().indexOf("p")) > -1) {
        await this.setParentNodeCheckBox(grid, rowData, colIndex, enableHalfCheck, false);
      } else {
        if (enableHalfCheck) {
          this.checkParentHalfChecked(grid, rowData, colIndex);
        }
      }
    }
    grid.selectMulting = false;
  }
  static selectRowImpl(grid, rowIndex, newValue) {
    var row = grid.getRowDataAt(rowIndex);
    var tableKey = grid.tableKey, bkmkRow = row.bkmkRow;
    if (!tableKey || !bkmkRow) {
      return;
    }
    var doc = grid.getForm().getDocument(), dataTable = doc.getByKey(tableKey);
    var selectKey = SystemField.SELECT_FIELD_KEY, dataType = dataTable.getColByKey(selectKey).type;
    newValue = TypeConvertor.toDataType(dataType, newValue);
    if (bkmkRow.getRowType() == BkmkType.Expand) {
      for (var i2 = 0, len = bkmkRow.size(); i2 < len; i2++) {
        dataTable.setByBkmk(bkmkRow.getAt(i2).getBookmark());
        dataTable.setByKey(selectKey, newValue);
      }
    } else {
      dataTable.setByBkmk(bkmkRow.getBookmark());
      dataTable.setByKey(selectKey, newValue, false);
      if (grid.pageLoadType == PageLoadType.DB) {
        var shadowTable = doc.getShadow(tableKey);
        var bookmark = ViewUtil.findShadowBkmk(doc, tableKey);
        if (newValue) {
          if (bookmark == -1) {
            ViewUtil.addShadowRow(dataTable, shadowTable);
          } else {
            shadowTable.setByKey(selectKey, newValue, false);
          }
        } else {
          if (shadowTable.getState() == DataDef.R_Normal) {
            shadowTable.setState(DataDef.R_New);
            shadowTable.delRow();
          } else {
            shadowTable.setByKey(selectKey, newValue, false);
          }
        }
      }
    }
    if (newValue) {
      grid.selectCount++;
    } else {
      grid.selectCount--;
    }
  }
}
class PrintGridUtil {
  static async toJSONRowsSection(form, grid) {
    await grid.fetchCaptionAll();
    const dataModel = grid.dataModel;
    const viewColumns = dataModel.viewColumns;
    let section = { columns: [], rows: [] };
    let data2 = dataModel.data;
    for (let i2 = 0, len = data2.length; i2 < len; i2++) {
      let rowData = data2[i2];
      let row = {}, cells = [];
      for (let j = 0, column; column = viewColumns[j]; j++) {
        if (column.visible) {
          let cellData = rowData.data[column.orgIndex];
          let cell = this.getDefJSONCell();
          if (rowData.rowType == "Group") {
            if (column.cellType === ControlType.DICT || column.cellType === ControlType.DYNAMICDICT) {
              if (cellData.value) {
                cell.text = this.convertDictValue(cellData, rowData);
              }
            } else if (column.cellType === ControlType.NUMBEREDITOR) {
              if (cellData.value) {
                cell.text = cellData.value.toString();
              }
            } else {
              cell.text = cellData.caption;
            }
          } else if (rowData.rowType == "Total") {
            if (column.cellType === ControlType.DICT || column.cellType === ControlType.DYNAMICDICT) {
              if (cellData.value) {
                cell.text = this.convertDictValue(cellData, rowData);
              }
            } else if (column.cellType === ControlType.NUMBEREDITOR) {
              if (cellData.value) {
                cell.text = cellData.value.toString();
              }
            } else {
              cell.text = cellData.caption;
            }
          } else {
            if (column.cellType) {
              if (column.cellType === ControlType.DICT || column.cellType === ControlType.DYNAMICDICT) {
                if (cellData.value) {
                  cell.text = this.convertDictValue(cellData, rowData);
                }
              } else if (column.cellType === ControlType.NUMBEREDITOR) {
                if (cellData.value) {
                  cell.text = cellData.value.toString();
                }
              } else if (column.cellType === ControlType.CHECKBOX) {
                cell.text = TypeConvertor.toInt(cellData.value);
              } else {
                cell.text = cellData.caption;
              }
            } else {
              cell.text = cellData.caption;
            }
          }
          cells.push(cell);
        }
      }
      row.cells = cells;
      section.rows.push(row);
    }
    return section;
  }
  static convertDictValue(cellData, rowData) {
    let text = "";
    if (cellData.value instanceof ItemData) {
      text = cellData.value.oid;
    } else if (cellData.value instanceof Array) {
      var oids = [], values = cellData.value;
      for (var k = 0, length2 = values.length; k < length2; k++) {
        oids.push(values[k].oid);
      }
      text = oids.join(",");
    } else if (rowData.alvRow) {
      text = cellData.value.split("_")[1];
    } else if (cellData.value) {
      text = cellData.value.oid;
    } else {
      text = cellData.caption;
    }
    return text;
  }
  static async toJSONSection(form, grid, isExcel = false) {
    var dataModel = grid.dataModel;
    var viewColumns = dataModel.viewColumns;
    var columns = [];
    if (grid.showRowHead() && isExcel) {
      columns.unshift({
        caption: "序号",
        name: "rn",
        width: 50,
        align: "center",
        visible: true
      });
    }
    columns = columns.concat(viewColumns);
    var section = { columns: [], rows: [] };
    for (var i2 = 0, cl; cl = columns[i2]; i2++) {
      if (cl.visible) {
        if (isExcel && cl.cellType && cl.cellType === 206) {
          section.columns.push({
            width: parseInt(cl.width) * 72 / 97,
            visible: true
          });
          section.columns.push({
            width: parseInt(cl.width) * 72 / 97,
            visible: true
          });
        } else {
          section.columns.push({
            width: parseInt(cl.width) * 72 / 97,
            visible: true
          });
        }
      }
    }
    var row = {}, cells = [];
    for (var i2 = 0, column; column = columns[i2]; i2++) {
      if (column.visible) {
        if (isExcel && column.cellType && column.cellType === 206) {
          var codeCell = this.getDefJSONCell();
          codeCell.text = column.caption + "Code";
          cells.push(codeCell);
          var nameCell = this.getDefJSONCell();
          nameCell.text = column.caption + "Name";
          cells.push(nameCell);
        } else {
          var cell = this.getDefJSONCell();
          cell.text = column.caption;
          cells.push(cell);
        }
      }
    }
    row.cells = cells;
    row.height = 30 * 72 / 97;
    section.rows.push(row);
    this.buildGroupHeaders(grid, dataModel.rootColumns, columns, section, isExcel);
    await grid.fetchCaptionAll();
    var data2 = dataModel.data;
    for (let i22 = 0, len = data2.length; i22 < len; i22++) {
      var rowData = data2[i22];
      var row = {}, cells = [];
      if (grid.showRowHead()) {
        var cell = this.getDefJSONCell();
        cell.text = i22 + 1;
        cells.push(cell);
      }
      for (let j = 0, column2; column2 = viewColumns[j]; j++) {
        if (column2.visible) {
          var cellData = rowData.data[column2.orgIndex];
          var cell = this.getDefJSONCell();
          if (cellData.isMerged) {
            if (cellData.isMergedHead) {
              cell.isMerged = true;
              cell.isMergedHead = true;
              cell.mergedColumnSpan = cellData.colspan;
              cell.mergedRowSpan = cellData.rowspan;
              cell.text = cellData.caption;
            } else {
              cell.isMerged = true;
              cell.isMergedHead = false;
              cell.mergedColumnSpan = 1;
              cell.mergedRowSpan = 1;
            }
          } else {
            if (isExcel && column2.cellType && column2.cellType === 206) {
              const caption = cellData.caption;
              let codeCell2 = this.getDefJSONCell();
              let nameCell2 = this.getDefJSONCell();
              if (caption) {
                let [code, name2] = caption.split(" ");
                codeCell2.text = code;
                nameCell2.text = name2;
              } else {
                codeCell2.text = "";
                nameCell2.text = "";
              }
              cells.push(codeCell2);
              cells.push(nameCell2);
            } else {
              cell.text = cellData.caption;
              cells.push(cell);
            }
          }
        }
      }
      row.cells = cells;
      row.height = parseInt(rowData.rowHeight) * 72 / 97;
      section.rows.push(row);
    }
    return section;
  }
  static getColumnList(columns) {
    var _getColumnList = function(columns2) {
      var result = [];
      columns2.forEach(function(column) {
        result.push.apply(result, column.columns && column.columns.length ? _getColumnList(column.columns) : [column]);
      });
      return result;
    };
    return _getColumnList(columns);
  }
  static buildGroupHeaders(grid, rootColumns, viewColumns, section, isExcel) {
    var self = this;
    if (!grid.isGroup)
      return;
    var groupHeaderRows = [];
    var findGroupHeader2Build = function(columns) {
      var groupHeaders = [], children = [];
      for (var i22 = 0, column; column = columns[i22]; i22++) {
        if (column.columns && column.columns.length) {
          var leafColumns = self.getColumnList(column.columns);
          var groupHeader = {
            startColumnName: leafColumns[0].name,
            numberOfColumns: leafColumns.length,
            caption: column.caption,
            formulaCaption: column.formulaCaption,
            leafColumns
          };
          groupHeaders.push(groupHeader);
          children = children.concat(column.columns);
        }
      }
      if (groupHeaders.length > 0) {
        self.addGroupHeaders(groupHeaders, viewColumns, section, groupHeaderRows, isExcel);
      }
      if (children.length > 0) {
        findGroupHeader2Build(children);
      }
    };
    findGroupHeader2Build(rootColumns);
    section.rows = groupHeaderRows.concat(section.rows);
    var chs = section.rows;
    section.rows[section.rows.length - 1];
    for (var i2 = chs.length - 2, ch; ch = chs[i2]; i2--) {
      for (var ci = 0, rhci = 0, clen = ch.cells.length; ci < clen; ci++) {
        var chCell = ch.cells[ci];
        var span = parseInt(chCell.mergedColumnSpan) || 0;
        if (span <= 0) {
          var chNext = chs[i2 + 1];
          var chCellNext = chNext.cells[ci];
          chCell.isMergedHead = true;
          chCell.isMerged = true;
          chCell.mergedRowSpan = chCellNext.mergedRowSpan ? chCellNext.mergedRowSpan + 1 : 2;
          chCell.mergedColumnSpan = 1;
          chCellNext.isMerged = true;
          chCellNext.isMergedHead = false;
          chCellNext.mergedRowSpan = 1;
          chCellNext.mergedColumnSpan = 1;
          chCell.text = chCellNext.text;
          chCellNext.text = "";
        }
      }
    }
  }
  static addGroupHeaders(groupHeaderArray, viewColumns, section, groupHeaderRows, isExcel) {
    var indexOfColumnHeader = function(name2, columnHeaders) {
      for (var i22 = 0; i22 < columnHeaders.length; i22++) {
        const leafColumns = columnHeaders[i22].leafColumns;
        for (let j = 0; j < leafColumns.length; j++) {
          if (leafColumns[j].name === name2) {
            return i22;
          }
        }
      }
      return -1;
    };
    var row = {}, cells = [];
    for (var i2 = 0; i2 < viewColumns.length; i2++) {
      var cell = this.getDefJSONCell();
      var index = indexOfColumnHeader(viewColumns[i2].name, groupHeaderArray);
      if (index >= 0) {
        var colDef = groupHeaderArray[index];
        if (!viewColumns[i2].visible) {
          const leafColumns = colDef.leafColumns;
          for (let j = 0; j < leafColumns.length; j++) {
            if (leafColumns[j].name === viewColumns[i2].name) {
              colDef.numberOfColumns -= 1;
              break;
            }
          }
          continue;
        }
        var count = colDef.numberOfColumns, vCount = 0;
        for (var iCol = 0; iCol < count && i2 + iCol < viewColumns.length; iCol++) {
          if (!viewColumns[i2 + iCol].visible)
            continue;
          if (isExcel && viewColumns[i2 + iCol].cellType && viewColumns[i2 + iCol].cellType === 206) {
            vCount += 2;
          } else {
            vCount += 1;
          }
        }
        cell.text = colDef.caption;
        cell.isMerged = true;
        cell.isMergedHead = true;
        cell.mergedColumnSpan = vCount;
        cell.mergedRowSpan = 1;
        cells.push(cell);
        i2 += count - 1;
        for (let j = 0; j < vCount - 1; j++) {
          cells.push({
            isMerged: true,
            mergedColumnSpan: 1,
            mergedRowSpan: 1,
            padding: ""
          });
        }
      } else {
        if (!viewColumns[i2].visible) {
          continue;
        }
        if (isExcel && viewColumns[i2].cellType && viewColumns[i2].cellType === 206) {
          cells.push(this.getDefJSONCell());
          cells.push(this.getDefJSONCell());
        } else {
          cells.push(cell);
        }
      }
    }
    row.cells = cells;
    row.height = 30 * 72 / 97;
    groupHeaderRows.push(row);
  }
  static getDefJSONCell() {
    var cell = {};
    var color = {
      r: 0,
      g: 0,
      b: 0
    };
    var display = {
      font: {
        name: "Microsoft YaHei",
        size: 10,
        underlineStyle: -1
      },
      border: {
        topColor: color,
        leftColor: color,
        rightColor: color,
        bottomColor: color,
        leftStyle: 1,
        topStyle: 1,
        rightStyle: 1,
        bottomStyle: 1
      },
      verticalAlignment: 1,
      horizontalAlignment: 1
    };
    cell.type = 0;
    cell.display = display;
    cell.foreColor = color;
    cell.overflowType = 1;
    cell.padding = "";
    return cell;
  }
}
var getFileInfo = function(file, index) {
  if (!index)
    index = 0;
  var prefix, size2, fileName;
  var $file = file;
  var files = $file.files[index];
  size2 = files.size / 1024;
  fileName = files.name;
  prefix = fileName.substring(fileName.lastIndexOf(".") + 1);
  var info = {};
  info.prefix = prefix.toLowerCase();
  info.size = size2;
  info.fileName = fileName;
  return info;
};
var checkFile = function(info, maxSize, types, fileInput) {
  if (fileInput) {
    fileInput = fileInput[0];
  }
  if (types && types.length > 0 && !types.includes(info.prefix)) {
    fileInput && (fileInput.outerHTML = fileInput.outerHTML);
    throw new Error(I18N.getString("FILEUTIL_NONTYPEFILE", "非指定类型文件!") + "(" + types + ")");
  }
  if (maxSize && maxSize != -1 && info.size > maxSize) {
    fileInput && (fileInput.outerHTML = fileInput.outerHTML);
    throw new Error(info.fileName + I18N.getString("JQUERYEXT_ATTACHMENTEXCEEDMAXSIZE", "超出指定大小!") + "(" + maxSize + "KB)");
  }
  return true;
};
class FileUtil {
  static downLoadFile(options2) {
    options2 && (options2.mode = Request$1.mode);
    if (options2.needDownload === false) {
      return new Request$1().getData(options2, AttachURL);
    }
    var $iframe = document.createElement("iframe");
    $iframe.setAttribute("id", "download-file-iframe");
    document.body.appendChild($iframe);
    var $form = document.createElement("form");
    $form.setAttribute("name", "AAA");
    $form.setAttribute("target", "download-file-iframe");
    $form.setAttribute("enctype", "multipart/form-data");
    $form.setAttribute("method", "post");
    $form.setAttribute("action", AttachURL);
    for (var key in options2) {
      var p2 = document.createElement("input");
      p2.setAttribute("type", "hidden");
      p2.setAttribute("name", key);
      p2.setAttribute("value", options2[key]);
      $form.appendChild(p2);
    }
    $iframe.appendChild($form);
    $form.submit();
    $iframe.remove();
    $form.remove();
  }
  static createFileInput(type) {
    var $iframe = document.getElementById("upload-frame");
    var $form = document.getElementById("upload-form");
    $iframe && $iframe.remove();
    $form && $form.remove();
    $iframe = document.createElement("iframe");
    $iframe.setAttribute("name", "upload-file-iframe");
    $iframe.setAttribute("id", "upload-frame");
    $form = document.createElement("form");
    $form.setAttribute("id", "upload-form");
    $form.setAttribute("target", "upload-file-iframe");
    $form.setAttribute("enctype", "multipart/form-data");
    $form.setAttribute("method", "post");
    $form.setAttribute("style", "display:none;");
    var $file = document.createElement("input");
    $file.setAttribute("type", "file");
    $file.setAttribute("name", "upload-file");
    window.uploadType && $file.setAttribute("multiple", window.uploadType);
    type && $file.setAttribute("accept", type);
    $form.appendChild($file);
    document.body.appendChild($iframe).appendChild($form);
    $iframe.addEventListener("load", function() {
      var data2 = this.contentDocument.documentElement.innerText;
      if (data2) {
        var ret = JSON.parse(data2);
        if (ret.data && typeof options.success === "function") {
          options.success(ret.data);
        } else if (ret.error) {
          throw new Error(ret.error.error_info);
        }
        $iframe.remove();
        $form.remove();
      }
    });
    window.setTimeout(function() {
      $file.click();
    }, 0);
    return $file;
  }
  static uploadFile(options2) {
    var $iframe = document.getElementById("upload-frame");
    var $form = document.getElementById("upload-form");
    $iframe && $iframe.remove();
    $form && $form.remove();
    $iframe = document.createElement("iframe");
    $iframe.setAttribute("name", "upload-file-iframe");
    $iframe.setAttribute("id", "upload-frame");
    $form = document.createElement("form");
    $form.setAttribute("id", "upload-form");
    $form.setAttribute("target", "upload-file-iframe");
    $form.setAttribute("enctype", "multipart/form-data");
    $form.setAttribute("method", "post");
    $form.setAttribute("style", "display:none;");
    $form.setAttribute("action", AttachURL);
    var $file = document.createElement("input");
    $file.setAttribute("type", "file");
    $file.setAttribute("name", "upload-file");
    $form.appendChild($file);
    document.body.appendChild($iframe).appendChild($form);
    $file.addEventListener("change", function() {
      var info = getFileInfo(this);
      options2.fileName = info.fileName;
      for (var key in options2) {
        if (typeof options2[key] === "function")
          continue;
        var p2 = document.createElement(input);
        p2.setAttribute("type", "hidden");
        p2.setAttribute("name", key);
        p2.setAttribute("value", options2[key]);
        $form.appendChild(p2);
      }
      if (checkFile(info, options2.maxSize, options2.types)) {
        $form.submit();
      }
    });
    $iframe.addEventListener("load", function() {
      var data2 = this.contentDocument.documentElement.innerText;
      if (data2) {
        var ret = JSON.parse(data2);
        if (ret.data && typeof options2.success === "function") {
          options2.success(ret.data);
        } else if (ret.error) {
          throw new Error(ret.error.error_info);
        }
        $iframe.remove();
        $form.remove();
      }
    });
    $file.click();
  }
  static checkFile(options2) {
    var file = options2.file;
    var files = file.files;
    var len = files.length;
    if (len > 1) {
      for (var i2 = 0; i2 < len; i2++) {
        var info = getFileInfo(options2.file, i2);
        checkFile(info, options2.maxSize, options2.types, options2.file);
      }
    } else {
      var info = getFileInfo(options2.file);
      checkFile(info, options2.maxSize, options2.types, options2.file);
    }
    return info;
  }
  static needUploadFile(s) {
    return s.indexOf("ImportDictionary") > -1 || s.indexOf("ImportExcel") > -1 || s.indexOf("SingleImportExcel") > -1 || s.indexOf("ImportData") > -1 || s.indexOf("UploadAttachment") > -1;
  }
}
const _processCallParas = async (form, tsParas, cxt) => {
  var paras = ModalCallbackUtil.splitPara(tsParas);
  if (paras) {
    return Object.keys(paras).reduce(async (prev, key) => {
      await prev;
      var value = await form.asyncEval(paras[key], cxt);
      form.setCallPara(key, value);
    }, true);
  }
};
class ModalCallbackUtil {
  static splitPara(para) {
    if (!para) {
      return null;
    }
    para = TypeConvertor.toString(para);
    var mapCallback = {}, len = para.length, key = "", deep = 0, start = 0;
    for (var i2 = 0; i2 < len; i2++) {
      var c = para.charAt(i2);
      if (c == ":" && deep === 0) {
        key = para.substring(start, i2).trim();
      } else if (c == "," && deep === 0) {
        start = ++i2;
      } else if (c == "{") {
        if (deep === 0) {
          start = ++i2;
        }
        deep++;
      } else if (c == "}") {
        deep--;
        if (deep == 0) {
          mapCallback[key] = para.substring(start, i2);
        }
      }
    }
    return mapCallback;
  }
  static processCallParas(form, tsParas, cxt, fn) {
    return _processCallParas(form, tsParas, cxt).then(() => {
      return fn && fn();
    });
  }
}
class FormRender {
  static setYesCom(impl) {
    this.impl = impl;
  }
  static render(form, div, callBack) {
    return this.impl.render(form, div, callBack);
  }
}
class FallBackUtil {
  static addFallBack(fallBackInfo, target) {
    if (target === FormTarget.MODAL) {
      if (!fallBackInfo.getFormKey) {
        this.fallBacks.push(fallBackInfo);
      } else {
        let pform = fallBackInfo == null ? void 0 : fallBackInfo.getParentForm();
        let containerForm;
        if (pform) {
          if (pform.containerForm) {
            containerForm = pform.containerForm;
          }
        }
        let getContainer = function(form) {
          let _pform = form == null ? void 0 : form.getParentForm();
          if (_pform) {
            if (_pform.containerForm) {
              containerForm = _pform.containerForm;
            } else {
              getContainer(_pform.getParentForm());
            }
          }
        };
        getContainer(fallBackInfo);
        if (containerForm) {
          let backForm = this.fallBacks.filter((_back) => _back.getFormKey && _back.getFormKey() === containerForm.getFormKey());
          if (backForm.length > 0) {
            this.fallBacks.push(fallBackInfo);
          }
        } else {
          let backForm = this.fallBacks.filter((_back) => {
            var _a;
            return _back.getFormKey && _back.getFormKey() === ((_a = fallBackInfo.getParentForm()) == null ? void 0 : _a.getFormKey());
          });
          if (backForm.length > 0) {
            this.fallBacks.push(fallBackInfo);
          } else {
            this.modalBacks.push(fallBackInfo);
          }
        }
      }
    } else {
      this.fallBacks.push(fallBackInfo);
      if (this.modalBacks.length > 0) {
        this.modalBacks.forEach((modal) => {
          let pform = modal.getParentForm();
          if ((pform == null ? void 0 : pform.getFormKey()) === (fallBackInfo == null ? void 0 : fallBackInfo.getFormKey())) {
            this.fallBacks.push(modal);
          }
        });
        this.modalBacks = [];
      }
    }
  }
  static async doFallBack() {
    if (!this.back)
      return;
    var fallBackInfo = this.fallBacks[this.fallBacks.length - 1];
    await (fallBackInfo == null ? void 0 : fallBackInfo.fireClose());
  }
  static removeFallBack() {
    this.fallBacks.splice(this.fallBacks.length - 1, 1);
  }
  static removeAllBack() {
    this.fallBacks.splice(0, 1);
  }
  static isBackApp() {
    return this.fallBacks.length < 2 ? false : true;
  }
  static setBack(back) {
    this.back = back;
  }
}
FallBackUtil.fallBacks = [];
FallBackUtil.back = true;
FallBackUtil.modalBacks = [];
class BaseContainer {
  doActiveEvent() {
  }
  add(form) {
  }
  close(form) {
  }
  getIsModal() {
    return true;
  }
  isShow(formid) {
    return true;
  }
}
class ModalContainer extends BaseContainer {
  constructor() {
    super();
    this.formItems = {};
    this.modals = {};
    this._showCloseIcon = true;
  }
  add(form) {
    let target = form.getTarget();
    if (target == FormTarget.SELF) {
      this.formItems[form.formID] = form;
      if (height == "auto") {
        reposition = function() {
          var dialogBase = self.dialog.dialog;
          dialogBase.dialog.reposition();
        };
      }
      FallBackUtil.addFallBack(form);
      form.getContainer().modals[form.formID] = this.dialog;
      this.dialog.__setAttribute("formKey", form.formKey);
      this.startTimeTasks(form);
      var div = document.createElement("div");
      var content = FormRender.render(form, div, reposition);
      this.dialog.__setContent(content);
      this.dialog.__setHeaderTitle(form.getCaption());
      return;
    }
    this.formItems[form.formID] = form;
    this.options = {};
    this.options.headerTitle = form.getCaption();
    var width = form.popWidth || "40%";
    var height = form.popHeight || "60%";
    var c_h = document.body.clientHeight;
    if (parseInt(height) > c_h) {
      height = c_h;
    }
    this.options.panelSize = width + " " + height;
    this.options.className = { "panel": "modal dialog show", "title": "dialog-title", "btn-close": "dialog-close" };
    var self = this;
    var reposition;
    if (height == "auto" || height == "pref") {
      reposition = function() {
        var dialogBase = self.dialog.dialog;
        dialogBase.dialog.reposition();
      };
      this.options.className.panel += " auto";
    }
    var div = document.createElement("div");
    this.options.content = FormRender.render(form, div, reposition);
    var showCloseIcon = Utils.isUndefined(form.entryClose) ? this._showCloseIcon : form.entryClose;
    this.options.hideCloseBtn = !showCloseIcon;
    this.options.onbeforeclose = function(panel, closedByUser) {
      if (self.formItems[form.formID]) {
        self.closeTimerTasks(form);
        form.fireClose();
      } else {
        return true;
      }
    };
    this.options.maskClick = Utils.isUndefined(form.modalMaskClick) ? false : true;
    this.options.header = Utils.isUndefined(form.modalHeaderShow) ? true : false;
    this.options.resizeit = form.resizeit;
    if (this.options.maskClick) {
      this.options.close = this.options.onbeforeclose;
    }
    this.options.ziBase = form.zIndex;
    this.options.resizable = form.resizable;
    this.dialog = new BaseDialog(this.options);
    this.dialog.show();
    FallBackUtil.addFallBack(form, target);
    form.getContainer().modals[form.formID] = this.dialog;
    this.dialog.__setAttribute("formKey", form.formKey);
    var parentForm = form.getParentForm();
    if (parentForm && target != FormTarget.MODAL) {
      parentForm.getContainer().hide(parentForm);
    }
    this.startTimeTasks(form);
  }
  setShowCloseIcon(close) {
    this._showCloseIcon = close;
  }
  hide(form) {
    var dialog = form.getContainer().modals[form.formID];
    dialog.hide();
  }
  show(form) {
    var dialog = form.getContainer().modals[form.formID];
    dialog.showModal();
  }
  close(form) {
    console.log("=========modal-close============formKey:" + form.formKey + "========formID:" + form.formID);
    let target = form.getTarget();
    delete this.formItems[form.formID];
    var dialog = form.getContainer().modals[form.formID];
    dialog && dialog.close();
    delete form.getContainer().modals[form.formID];
    var parentForm = form.getParentForm();
    if (parentForm && target != FormTarget.MODAL) {
      if (form.formID != parentForm.formID && target != FormTarget.SELF) {
        parentForm.getContainer().show(parentForm);
      }
    }
    FallBackUtil.removeFallBack();
    FormStack.removeForm(form.formID);
    form.getRoot().destroy();
  }
  startTimeTasks(form) {
    if (!form)
      return;
    var manager = TimerTaskManagerFactory.createManager(form);
    if (manager) {
      manager.startTasks();
    }
  }
  closeTimerTasks(form) {
    if (!form)
      return;
    var manager = TimerTaskManagerFactory.getManager(form.formID);
    try {
      if (manager) {
        manager.closeAllTasks();
      }
    } finally {
      TimerTaskManagerFactory.removeManager(form.formID);
    }
  }
  getIsModal() {
    return true;
  }
  closeAll() {
  }
}
const _NewOIDCache = class _NewOIDCache2 {
  static async applyNewOID() {
    if (!_NewOIDCache2.oids || _NewOIDCache2.index >= _NewOIDCache2.count) {
      const paras = {
        service: "ERPService",
        cmd: "ApplyMultiNewOIDCmd",
        count: _NewOIDCache2.count
      };
      const result = await new Request$1().getData(paras);
      const oids = result.OIDs;
      _NewOIDCache2.oids = oids.split(",");
      _NewOIDCache2.index = 0;
    }
    return TypeConvertor.toLong(_NewOIDCache2.oids[_NewOIDCache2.index++]);
  }
};
_NewOIDCache.count = 128;
_NewOIDCache.index = 0;
let NewOIDCache = _NewOIDCache;
class FormRefreshContext {
  constructor() {
    this.ignoreGrids = [];
  }
  // 忽略刷新的grid
  addIgnoreGrid(gridKey) {
    this.ignoreGrids.push(gridKey);
  }
  getIgnoreGrids() {
    return this.ignoreGrids;
  }
  containsKey(gridKey) {
    return this.ignoreGrids.indexOf(gridKey) != -1;
  }
  clear() {
    this.ignoreGrids.length = 0;
  }
}
class LinkType {
}
LinkType.PARENT = 1;
LinkType.FOREIGN = 2;
class TableViewRowGroup {
  constructor(form, tbview) {
    this.form = form;
    this.tbview = tbview;
  }
  group() {
    this.tbview.dataModel.rowMap = {};
    var detailRow = this.tbview.getDetailMetaRow();
    if (detailRow == null || !this.tbview.tableKey) {
      return;
    }
    this.tbview.dataModel.rootBkmk = this.buildNormalTableViewRowData(this.sortData());
  }
  buildNormalTableViewRowData(data2) {
    var root = new GroupRowBkmk();
    var doc = this.form.getDocument();
    if (doc == null)
      return;
    var table = doc.getByKey(this.tbview.tableKey);
    if (table == null)
      return;
    var groupRowBkmk = new GroupRowBkmk();
    for (let h = 0, len = data2.length; h < len; h++) {
      table.setByBkmk(data2[h].bkmk);
      let detailTableViewRow = new DetailRowBkmk(table.getBkmk());
      groupRowBkmk.addRow(detailTableViewRow);
    }
    root.addRow(groupRowBkmk);
    return root;
  }
  sortData() {
    var table = this.form.getDocument().getByKey(this.tbview.tableKey);
    var data2 = [];
    let { groupColumnKeys, indicatorKey } = this.tbview, groupColumnKeysMap = {}, indicators = new Array();
    table.beforeFirst();
    while (table.next()) {
      let bkmk = table.getBkmk();
      data2.push({ bkmk });
      if (groupColumnKeys) {
        let key = table.getByKey(groupColumnKeys);
        if (groupColumnKeysMap[key]) {
          groupColumnKeysMap[key].push({ table, bkmk });
        } else {
          groupColumnKeysMap[key] = [{ table, bkmk }];
        }
      }
      if (indicatorKey) {
        indicators.push(table.getByKey(groupColumnKeys));
      }
    }
    this.tbview.dataModel.groupColumnKeysMap = groupColumnKeysMap;
    this.tbview.dataModel.indicators = [...new Set(indicators)];
    return data2;
  }
}
class CellLocation {
  constructor(options2) {
    this.key = options2.key;
    this.column = options2.column;
    this.columns = options2.columns;
    this.row = options2.row;
    this.rows = options2.rows;
    this.tableKey = options2.tableKey;
    this.columnKey = options2.columnKey;
    this.expand = options2.expand;
    this.isFix = options2.isFix;
  }
  getKey() {
    return this.key;
  }
  getRow() {
    return this.row;
  }
  getRows() {
    return this.rows;
  }
  getColumn() {
    return this.column;
  }
  getColumns() {
    return this.columns;
  }
  isExpand() {
    return this.expand;
  }
  isFixCell() {
    return this.isFix;
  }
}
class GridLookUpUtil {
  /**
   * 建立单元格查找
   */
  static buildCellLookup(form, com) {
    switch (com.type) {
      case ControlType.GRID:
        var metaRows = com.getMetaObj().rows, metaRow, key, keys = [];
        for (var i2 = 0; metaRow = metaRows[i2]; i2++) {
          var rowIndex = metaRow.rowType === "Fix" ? i2 : -1;
          for (var k = 0, metaCell; metaCell = metaRow.cells[k]; k++) {
            key = metaCell.key;
            if (key) {
              var tableKey = metaRow.rowType === "Fix" ? metaCell.tableKey : com.tableKey, columnKey = metaCell.columnKey;
              var loc = form.formAdapt.getCellLocation(key);
              if (!loc) {
                loc = new CellLocation({
                  key: com.key,
                  column: -1,
                  columns: [],
                  row: rowIndex,
                  rows: [],
                  tableKey,
                  columnKey,
                  expand: false,
                  isFix: metaRow.rowType === "Fix"
                });
                form.formAdapt.addCellLocation(key, loc);
              }
              if (keys.indexOf(key) == -1) {
                loc.columns.length = 0;
                loc.column = -1;
                keys.push(key);
              }
              if (metaCell.isColExpand) {
                loc.expand = true;
                loc.columns.push(k);
                metaCell.expandIndex = loc.columns.length - 1;
              } else {
                loc.column = k;
              }
            }
          }
        }
        break;
      case ControlType.ROTATOR:
      case ControlType.ROTATORLIST:
      case ControlType.GALLERY:
      case ControlType.WATERFALL:
      case ControlType.TILEDLIST:
      case ControlType.LISTVIEW:
      case ControlType.EDITVIEW:
      case ControlType.LISTLAYOUTVIEW:
      case ControlType.GANTT:
        for (var i2 = 0, column; column = com.getColumns()[i2]; i2++) {
          column.tableKey = com.tableKey;
          if (com.tableKey) {
            loc = new CellLocation({
              key: com.key,
              column: i2,
              row: -1,
              tableKey: com.tableKey,
              columnKey: column.columnKey
            });
            form.formAdapt.addCellLocation(column.key, loc);
          }
        }
        break;
      case ControlType.TABLEVIEW:
        var metaRows = com.getMetaObj().rows, metaRow, key, keys = [];
        for (var i2 = 0; metaRow = metaRows[i2]; i2++) {
          var rowIndex = metaRow.rowType === RowType.STR_FIXED ? i2 : -1;
          for (var k = 0, metaCell; metaCell = metaRow.cells[k]; k++) {
            key = metaCell.key;
            if (key) {
              var tableKey = metaRow.tableKey, columnKey = metaCell.columnKey;
              var loc = form.formAdapt.getCellLocation(key);
              if (!loc) {
                loc = new CellLocation({
                  key: com.key,
                  column: -1,
                  columns: [],
                  row: rowIndex,
                  rows: [],
                  tableKey,
                  columnKey,
                  expand: false,
                  isFix: metaRow.rowType === RowType.STR_FIXED
                });
                form.formAdapt.addCellLocation(key, loc);
              }
              if (keys.indexOf(key) == -1) {
                loc.columns.length = 0;
                loc.column = -1;
                keys.push(key);
              }
              loc.column = k;
            }
          }
        }
        break;
    }
  }
  /**
   * 更新一行固定行位置
   */
  static updateFixRowPos(form, metaRow, index) {
    for (var i2 = 0, metaCell; metaCell = metaRow.cells[i2]; i2++) {
      if (metaCell.key) {
        var loc = form.getCellLocation(metaCell.key);
        if (metaRow.isAreaExpand) {
          loc.rows[metaRow.areaIndex] = index;
          loc.row = -1;
        } else {
          loc.row = index;
        }
        loc.areaExpand = metaRow.isAreaExpand;
      }
    }
  }
  /**
   * 更新固定行位置
   */
  static updateFixRowsPos(grid) {
    if (!grid.hasFixRow) {
      return;
    }
    var form = grid.getForm();
    if (grid.hasRowAreaExpand) {
      for (var i2 = 0, size2 = grid.getRowCount(); i2 < size2; i2++) {
        var rowData = grid.getRowDataAt(i2);
        var metaRow = rowData.meta;
        if (metaRow.rowType == "Fix") {
          this.updateFixRowPos(form, metaRow, i2);
        }
      }
    } else {
      var count = 0;
      if (grid.topFixRowCount > 0) {
        for (var i2 = 0, size2 = grid.getRowCount(); i2 < size2; i2++) {
          var rowData = grid.getRowDataAt(i2);
          var metaRow = rowData.meta;
          if (metaRow.rowType == "Fix") {
            this.updateFixRowPos(form, metaRow, i2);
            count++;
          }
          if (count == grid.topFixRowCount) {
            break;
          }
        }
      }
      count = 0;
      if (grid.bottomFixRowCount > 0) {
        for (var i2 = grid.getRowCount() - 1; i2 >= 0; i2--) {
          var rowData = grid.getRowDataAt(i2);
          var metaRow = rowData.meta;
          if (metaRow.rowType == "Fix") {
            this.updateFixRowPos(form, metaRow, i2);
            count++;
          }
          if (count == grid.bottomFixRowCount) {
            break;
          }
        }
      }
    }
  }
}
class TableViewRowSimpleBuilder {
  constructor(form, tbview) {
    this.form = form;
    this.tbview = tbview;
  }
  async build(group) {
    var self = this;
    var metaRow = self.tbview.getDetailRow();
    let { groupRow, groupRowTail, dataModel } = self.tbview;
    var rowCount = group.getRowCount(), start = 0, end = rowCount;
    if (this.tbview.hasGroupRow) {
      let groupColumnKeysMap = dataModel.groupColumnKeysMap;
      for (const key in groupColumnKeysMap) {
        let tables2 = groupColumnKeysMap[key];
        for (let i2 = 0; i2 < tables2.length; i2++) {
          let { table, bkmk } = tables2[i2];
          table.setByBkmk(bkmk);
          let bkmkRow = new DetailRowBkmk(bkmk);
          if (groupRow && i2 == 0) {
            var groupRowIndex = self.tbview.__addGridRow(-1, groupRow, bkmkRow, null, null, null, true);
            await self.tbview.getHandler().showRowData(self.form, self.tbview, groupRowIndex, groupRow);
            let groudRow = self.tbview.getRowDataAt(groupRowIndex);
            groudRow.groupColumnValue = key;
          }
          var rowIndex = self.tbview.__addGridRow(-1, metaRow, bkmkRow, null, null, null, true);
          await self.tbview.getHandler().showRowData(self.form, self.tbview, rowIndex, metaRow);
          let detailRow = self.tbview.getRowDataAt(rowIndex);
          detailRow.groupColumnValue = key;
          if (groupRowTail && i2 == tables2.length - 1) {
            var groupRowTailIndex = self.tbview.__addGridRow(-1, groupRowTail, bkmkRow, null, null, null, true);
            await self.tbview.getHandler().showRowData(self.form, self.tbview, groupRowTailIndex, groupRowTail);
            let groudTailRow = self.tbview.getRowDataAt(groupRowTailIndex);
            groudTailRow.groupColumnValue = key;
          }
        }
      }
    } else {
      var currentPage = self.tbview.pageInfo.currentPage, pageSize = self.tbview.pageInfo.pageSize;
      start = (currentPage - 1) * pageSize;
      end = start + pageSize > rowCount ? rowCount : start + pageSize;
      for (var m = start; m < end; m++) {
        var rowIndex = self.tbview.__addGridRow(-1, metaRow, group.rowArray[m], null, null, null, true);
        await self.tbview.getHandler().showRowData(self.form, self.tbview, rowIndex, metaRow);
      }
    }
  }
}
class TableViewRowTreeBuilder {
  constructor(form, tbview) {
    this.root = "ROOT";
    this.form = form;
    this.tbview = tbview;
  }
  async build(table, group) {
    var detailRow = this.tbview.getDetailMetaRow(), treeMap = this.tbview.dataModel.treeMap = {}, rowTree = detailRow.rowTree, treeIndex = this.tbview.colIndexMap[rowTree.cellKey], treeCell = detailRow.cells[treeIndex], root, columnKey;
    if (rowTree.treeType == TreeType.DICT) {
      var IDMap = {}, keys = [];
      columnKey = rowTree.columnKey = treeCell.columnKey;
      var getParentID = function(item) {
        var table2 = item.itemTables[item.mainTableKey], parentID;
        if (table2.tableMode == TableMode.HEAD) {
          parentID = table2.itemRows[0]["ParentID"];
        }
        return parentID;
      };
      for (var i2 = 0, size2 = group.getRowCount(); i2 < size2; i2++) {
        var bkmk = group.getRowAt(i2);
        if (bkmk.getRowType() == BkmkType.Expand) {
          bkmk = bkmk.getAt(0);
        }
        table.setByBkmk(bkmk.getBookmark());
        var id = TypeConvertor.toLong(table.getByKey(columnKey));
        var bkmks = IDMap[id];
        if (!bkmks) {
          bkmks = [];
          IDMap[id] = bkmks;
        }
        bkmks.push(bkmk);
        keys.indexOf(id) == -1 && keys.push(id);
      }
      var itemKey = treeCell.editOptions.itemKey;
      var items = await new DictService(this.form).getItems(itemKey, keys);
      items.forEach((item) => {
        var parentID = TypeConvertor.toLong(getParentID(item));
        if (parentID == 0 || IDMap[parentID] == null) {
          parentID = 0;
        }
        var children2 = treeMap[parentID];
        if (!children2) {
          children2 = [];
          treeMap[parentID] = children2;
        }
        IDMap[item.oid].forEach(function(bkmk2) {
          children2.push(bkmk2);
        });
      });
      root = treeMap["0"];
    } else {
      var foreign = rowTree.foreign, parSet = [], parValue, fgnValue;
      columnKey = rowTree.columnKey = rowTree.parent;
      for (var i2 = 0, size2 = group.getRowCount(); i2 < size2; i2++) {
        var bkmk = group.getRowAt(i2);
        if (bkmk.getRowType() == BkmkType.Expand) {
          bkmk = bkmk.getAt(0);
        }
        table.setByBkmk(bkmk.getBookmark());
        parValue = table.getByKey(columnKey);
        parSet.push(parValue);
      }
      for (var i2 = 0, size2 = group.getRowCount(); i2 < size2; i2++) {
        var bkmk = group.getRowAt(i2);
        if (bkmk.getRowType() == BkmkType.Expand) {
          bkmk = bkmk.getAt(0);
        }
        table.setByBkmk(bkmk.getBookmark());
        parValue = table.getByKey(columnKey);
        fgnValue = table.getByKey(foreign);
        if (!TypeConvertor.toBoolean(fgnValue) || parSet.indexOf(fgnValue) == -1) {
          fgnValue = this.root;
        }
        var children = treeMap[fgnValue];
        if (!children) {
          children = [];
          treeMap[fgnValue] = children;
        }
        children.push(bkmk);
      }
      root = treeMap[this.root];
    }
    if (root) {
      await this.buildTree(treeMap, table, columnKey, null, root, rowTree, true, -1);
    }
  }
  /** 
   * 加载树形行
   */
  async buildTree(treeMap, table, columnKey, parentRow, bkmks, rowTree, loading, index) {
    let metaRow = this.tbview.getDetailMetaRow();
    for (let i2 = 0, bkmk; bkmk = bkmks[i2]; i2++) {
      if (bkmk.getRowType() == BkmkType.Expand) {
        bkmk = bkmk.getAt(0);
      }
      table.setByBkmk(bkmk.getBookmark());
      let mainValue = table.getByKey(columnKey);
      mainValue = mainValue instanceof Decimal ? mainValue.toNumber() : mainValue;
      let treeLevel = parentRow ? parentRow.treeLevel + 1 : 0;
      let children = treeMap[mainValue], childrenField;
      if (!children) {
        childrenField = table.indexByKey("ChildrenCount");
        if (childrenField != null) {
          children = table.getByKey("ChildrenCount");
        }
      }
      let rowIndex = this.tbview.__addGridRow(loading ? -1 : index++, metaRow, bkmk, null, {
        treeLevel,
        isLeaf: !children,
        parentRow
      }, null, loading);
      let rowData = this.tbview.getRowDataAt(rowIndex);
      if (children) {
        if (loading) {
          rowData.expanded = childrenField ? false : rowTree.expand || treeLevel <= rowTree.expandLevel;
          rowData.orgExpanded = rowData.expanded;
        } else {
          rowData.expanded = false;
        }
        rowData.needCalcChildUI = true;
      }
      if (parentRow) {
        let childRows = parentRow.childRows || [];
        childRows.push(rowData.rowId);
        parentRow.childRows = childRows;
        rowData.visible = parentRow.expanded;
      }
      await this.tbview.getHandler().showRowData(this.form, this.tbview, rowIndex, metaRow, loading);
      if (children) {
        await this.buildTree(treeMap, table, columnKey, rowData, children, rowTree, loading, -1);
      }
    }
  }
}
class TableViewRowBuilder {
  constructor(form, tbview) {
    this.form = form;
    this.tbview = tbview;
  }
  async build(scrollInfo) {
    var self = this;
    var impl_buildNormal = function() {
      var metaObj = self.tbview.getMetaObj(), rows = metaObj.rows;
      var doc = self.form.getDocument(), table;
      if (doc) {
        table = doc.getByKey(self.tbview.tableKey);
      }
      return rows.reduce(async (prev, metaRow, index) => {
        await prev;
        if (metaRow.rowType == RowType.STR_FIXED && !scrollInfo) {
          var rowIndex = self.tbview.__addGridRow(-1, metaRow);
          GridLookUpUtil.updateFixRowPos(self.form, metaRow, rowIndex);
          return self.tbview.getHandler().showRowData(self.form, self.tbview, rowIndex, metaRow);
        } else if (metaRow.rowType == RowType.STR_DETAIL) {
          var root = self.tbview.dataModel.rootBkmk;
          if (root) {
            return await self.loadGroup(table, root);
          }
        }
      }, true);
    };
    self.tbview.clearGridData(scrollInfo);
    self.form.clearCellLocation(self.tbview.key);
    return await impl_buildNormal();
  }
  async loadGroup(table, group) {
    var self = this;
    return group.rowArray.reduce(async (prev, groupBkmk) => {
      await prev;
      if (this.tbview.hasTree) {
        let builder = new TableViewRowTreeBuilder(self.form, self.tbview);
        return await builder.build(table, groupBkmk);
      } else {
        let builder = new TableViewRowSimpleBuilder(self.form, self.tbview);
        return await builder.build(groupBkmk);
      }
    }, true);
  }
}
class ShowTableViewData {
  constructor(form, tbview) {
    this.form = form;
    this.tbview = tbview;
  }
  async load(scrollInfo) {
    let tbview = this.tbview, form = this.form;
    let doc = form.getDocument();
    if (!doc) {
      return;
    }
    let tableKey = tbview.tableKey;
    if (tableKey) {
      doc.getByKey(tableKey);
    }
    if (tbview.isSubDetail && !SubDetailUtil.isParentValid(tbview)) {
      return SubDetailUtil.clearData(form, tbview.parentGrid);
    }
    if (tbview.isSubDetail) {
      await SubDetailUtil.filter(form, tbview.parentGrid, tableKey);
    }
    tbview.needRefresh = true;
    await new TableViewRowGroup(form, tbview).group();
    await new TableViewRowBuilder(form, tbview).build(scrollInfo);
    tbview.dataModel.allData = tbview.dataModel.data.slice();
    tbview.refreshIndex(0);
  }
}
class SubDetailUtil {
  static async doChain(form, grid, isRowChanged = false) {
    if (!grid.hasSubDetail)
      return;
    let process = form.getUIProcess();
    let newIndex = grid.getFocusRowIndex();
    let oldIndex = grid.getOldFocusRowIndex();
    let oldData = grid.getRowDataAt(oldIndex);
    if (oldData && isRowChanged) {
      process.moveSubDetailError(grid, oldIndex);
    }
    let rowData = grid.getRowDataAt(newIndex);
    if (rowData && rowData.rowType == RowType.STR_DETAIL && rowData.bkmkRow) {
      process.moveParentRowError(grid, newIndex);
      await this.showData(form, grid);
      await process.calcSubDetail(grid.key);
    } else {
      this.clearData(form, grid);
    }
    let childGrids = this.getChildGrids(form, grid);
    for (let i2 = 0, sub_grid; sub_grid = childGrids[i2]; i2++) {
      if (sub_grid.needRefresh) {
        await sub_grid.doPostShow();
        sub_grid.refreshGrid();
      }
      await this.doChain(form, sub_grid);
    }
  }
  static getChildGrids(form, grid) {
    return form.getSubDetail(grid.key).filter((com) => com.type == grid.type && com.parentGrid == grid);
  }
  static clearData(form, grid) {
    let coms = form.getSubDetail(grid.key);
    if (coms) {
      for (let i2 = 0, com; com = coms[i2]; i2++) {
        if (com.type == ControlType.GRID || com.type == ControlType.TABLEVIEW || com.type == ControlType.EDITVIEW) {
          com.clearGridData();
        }
        com.reset();
        com.setRequired(false);
        com.setError(false, null);
      }
    }
  }
  static async showData(form, grid) {
    let coms = form.getSubDetail(grid.key);
    if (coms) {
      let rowIndex = grid.getFocusRowIndex();
      let rowData = grid.getRowDataAt(rowIndex);
      let doc = form.getDocument(), table = doc.getByKey(grid.tableKey);
      table.setByBkmk(rowData.bkmkRow.getBookmark());
      return coms.reduce(async (prev, com) => {
        await prev;
        if (com.type == ControlType.GRID) {
          return this.loadGrid(form, com);
        } else if (com.type == ControlType.TABLEVIEW) {
          return this.loadTableView(form, com);
        } else if (com.type == ControlType.EDITVIEW) {
          return this.loadEditView(form, com);
        } else {
          return this.loadHeader(form, grid, rowIndex, com);
        }
      }, true);
    }
  }
  static loadGrid(form, grid) {
    let show2 = new ShowGridData(form, grid);
    return show2.load(true);
  }
  static loadTableView(form, tbview) {
    let show2 = new ShowTableViewData(form, tbview);
    return show2.load();
  }
  static loadEditView(form, editrow) {
    return editrow.load(true, true);
  }
  static loadHeader(form, grid, rowIndex, com) {
    com.resetStatus();
    let meta = com.getMetaObj();
    let cellKey = meta.bindingCellKey;
    if (cellKey) {
      let value = grid.getValueByKey(rowIndex, cellKey);
      return com.__setValue(value);
    } else if (com.hasDataBinding()) {
      let table = form.getDocument().getByKey(meta.tableKey);
      let rowData = grid.getRowDataAt(rowIndex);
      table.setByBkmk(rowData.bkmkRow.getBookmark());
      let value = table.getByKey(meta.dataBinding.columnKey);
      return com.__setValue(value);
    }
  }
  static getBindingCell(subComp) {
    const bindingKey = subComp.bindingCellKey;
    if (!bindingKey) {
      return null;
    }
    const grid = subComp.parentGrid;
    if (grid == null) {
      return null;
    }
    const rowIndex = grid.getFocusRowIndex();
    if (rowIndex == -1) {
      return null;
    }
    let rowData = grid.getRowDataAt(rowIndex);
    if (!rowData || GridUtil.isEmptyRow(rowData)) {
      return null;
    }
    return grid.getCellDataByKey(rowIndex, bindingKey);
  }
  static getBindingColumn(subComp) {
    let bindingKey = subComp.bindingCellKey;
    if (!bindingKey)
      return null;
    let grid = subComp.parentGrid;
    if (grid == null)
      return null;
    return grid.findColumn(bindingKey);
  }
  static isParentValid(grid) {
    let parent2 = grid.parentGrid;
    let rowIndex = parent2.getFocusRowIndex();
    if (rowIndex < 0) {
      return false;
    }
    let rowData = parent2.getRowDataAt(rowIndex);
    if (!rowData) {
      return false;
    }
    return !!rowData.bkmkRow;
  }
  static filter(form, parentGrid, tableKey) {
    let rowIndex = parentGrid.getFocusRowIndex();
    let rowData = parentGrid.getRowDataAt(rowIndex);
    if (!rowData) {
      return;
    }
    let bookmark = rowData.bkmkRow.getBookmark();
    let doc = form.getDocument(), table = doc.getByKey(parentGrid.tableKey), subTable = doc.getByKey(tableKey);
    table.setByBkmk(bookmark);
    let detailRow = parentGrid.getDetailMetaRow();
    switch (detailRow.linkType) {
      case LinkType.PARENT:
        let OID = table.getByKey(SystemField.OID_SYS_KEY);
        subTable.setFilterEval(function() {
          let POID = subTable.getByKey(SystemField.POID_SYS_KEY);
          if (POID > 0) {
            return POID == OID;
          }
          let parentBkmk = subTable.getParentBkmk();
          if (bookmark != null && parentBkmk == bookmark) {
            return true;
          }
          return false;
        });
        break;
      case LinkType.FOREIGN:
        subTable.setFilterEval(function() {
          let sourceFields = detailRow.sourceFields, targetFields = detailRow.targetFields, srcField, tgtField;
          for (let k = 0, slen = sourceFields.length; k < slen; k++) {
            srcField = sourceFields[k];
            tgtField = targetFields[k];
            let dataType = table.getColByKey(srcField).type;
            let dV = BaseHandler.convertValue(table.getByKey(srcField), dataType), compDV = BaseHandler.convertValue(subTable.getByKey(tgtField), dataType);
            if (dV instanceof Decimal && compDV instanceof Decimal) {
              if (!dV.equals(compDV)) {
                return false;
              }
            } else if (dV !== compDV) {
              return false;
            }
          }
          return true;
        });
        break;
    }
    subTable.filter();
  }
}
var __defProp$a = Object.defineProperty;
var __getOwnPropDesc$a = Object.getOwnPropertyDescriptor;
var __decorateClass$a = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$a(target, key) : target;
  for (var i2 = decorators.length - 1, decorator; i2 >= 0; i2--)
    if (decorator = decorators[i2])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$a(target, key, result);
  return result;
};
const depValChanged$2 = async (form, grid, loc, row, depend, fire) => {
  if (loc.expand) {
    for (let i2 = 0; i2 < loc.columns.length; i2++) {
      const column = loc.columns[i2];
      await _depChanged$2(form, grid, row, column, depend, fire);
    }
  } else {
    await _depChanged$2(form, grid, row, loc.column, depend, fire);
  }
};
const _depChanged$2 = async (form, grid, row, col, depend, fire) => {
  const editOpt = grid.getCellEditOpt(row, col);
  const cellData = grid.getCellDataAt(row, col);
  const typeDef = cellData.typeDef;
  let meta;
  if (typeDef) {
    meta = typeDef.editOptions;
  } else {
    meta = editOpt.editOptions;
  }
  if (editOpt.cellType == ControlType.DYNAMIC) {
    const needClean = meta && meta.dependency && meta.dependency.indexOf(depend) != -1;
    if (needClean) {
      await grid.__setValueAtImpl(row, col, null, fire, fire, fire);
    }
    const dependency = editOpt.editOptions.dependency;
    const needRefresh = dependency && dependency.indexOf(depend) != -1;
    if (needRefresh) {
      await grid.getHandler().refreshDynamicOpt(form, grid, row, col, editOpt);
    }
  } else if (editOpt.cellType == ControlType.COMBOBOX || editOpt.cellType == ControlType.CHECKLISTBOX) {
    await combobox_dependedValueChanged$1(form, grid, row, col, cellData.value, editOpt, fire);
  } else if (editOpt.cellType == ControlType.DICT || editOpt.cellType == ControlType.DYNAMICDICT) {
    await dict_dependedValueChanged$2(form, grid, row, col, cellData.value, editOpt, fire);
  } else {
    await grid.__setValueAtImpl(row, col, null, fire, fire, fire);
  }
};
const dict_dependedValueChanged$2 = async (form, grid, row, col, value, editOpt, fire) => {
  const cellDataValue = value && Utils.isArray(value) ? value[0] : value;
  if (!cellDataValue || cellDataValue.getOID() <= 0) {
    await grid.setValueAt(row, col, null, fire, fire, fire);
    return;
  }
  let itemKey = editOpt.editOptions.itemKey;
  const stateMask = editOpt.editOptions.stateMask;
  const cxt = new ViewContext(form);
  cxt.updateLocation(grid.key, row, col);
  let handler = HandlerProvider.get(ControlType.DICT);
  if (editOpt.cellType == ControlType.DYNAMICDICT) {
    let location2 = new LocationInfo(grid.key, row, col);
    if (editOpt.editOptions.refDataElementKey) {
      itemKey = await handler.getItemKeyByDataElementKey(form, editOpt.editOptions.refDataElementKey, location2);
    } else {
      itemKey = await handler.getItemKey(form, editOpt.editOptions.refKey, location2);
    }
  }
  let dictFilter = await handler.getDictFilter(form, editOpt, itemKey);
  let ret = await handler.createRoot(form, itemKey, editOpt.editOptions.root, cxt);
  const item = await new DictService(form).getItemByOID(
    itemKey,
    0,
    10,
    3,
    cellDataValue.getOID(),
    stateMask,
    dictFilter,
    ret.root,
    form.formKey,
    editOpt.key
  );
  if (item && item != null) {
    await grid.setValueAt(row, col, cellDataValue, fire, fire, fire);
  } else {
    await grid.setValueAt(row, col, null, fire, fire, fire);
  }
};
const combobox_dependedValueChanged$1 = async (form, grid, row, col, value, editOpt, fire) => {
  let handler = HandlerProvider.get(ControlType.COMBOBOX);
  let loc = new LocationInfo(grid.key, row, col);
  var items = await handler.getItems(form.formID, editOpt.editOptions, loc);
  const cellData = grid.getCellDataAt(row, col);
  value = cellData.value;
  var oldList = [];
  if (value) {
    value = TypeConvertor.toString(value);
    oldList = value.split(",");
  } else {
    return;
  }
  var intersection = items.filter((item) => oldList.includes(TypeConvertor.toString(item.value)));
  if (oldList.length != intersection.length) {
    return grid.setValueAt(row, col, null, fire, fire, fire);
  }
  return grid.setValueAt(row, col, value, fire, fire, fire);
};
const setSystemColumIfNull$2 = async function(doc, table, parentTable) {
  let oidIndex = table.indexByKey(SystemField.OID_SYS_KEY);
  if (oidIndex != null) {
    const oid = TypeConvertor.toLong(table.get(oidIndex));
    if (oid <= 0) {
      table.setByKey(SystemField.OID_SYS_KEY, await NewOIDCache.applyNewOID());
    }
  }
  let soidIndex = table.indexByKey(SystemField.SOID_SYS_KEY);
  if (soidIndex != null) {
    const soid = TypeConvertor.toLong(table.get(soidIndex));
    if (soid <= 0) {
      table.setByKey(SystemField.SOID_SYS_KEY, doc.oid);
    }
  }
  if (parentTable) {
    let poidIndex = table.indexByKey(SystemField.POID_SYS_KEY);
    if (poidIndex != null) {
      const poid = TypeConvertor.toLong(table.get(poidIndex));
      if (poid <= 0) {
        const parentOID = TypeConvertor.toLong(parentTable.getByKey(SystemField.OID_SYS_KEY));
        if (parentOID > 0) {
          table.setByKey(SystemField.POID_SYS_KEY, parentOID);
        }
      }
    }
  }
};
class GridHandler extends Utils.mix(BaseHandler, PageHandler, SelectHandler) {
  static async doValueChanged(grid, rowIndex, colIndex, editOpt, newValue, commitValue, editing, fireEvent, curOldValue, ignoreFireCellValueChanged) {
    const form = grid.getForm();
    const monitor = form.getViewDataMonitor();
    let hasFlush = false;
    const rowData = grid.getRowDataAt(rowIndex);
    if (!rowData)
      return;
    if (editOpt.codeColIndex >= 0) {
      let realCode = this.getRealCode(editOpt.displayCols, newValue);
      grid.__setValueAt(rowIndex, editOpt.codeColIndex, realCode);
    }
    const isSelectField = grid.selectFieldIndex == colIndex && rowData.rowType === "Detail";
    const isEmptyRow = GridUtil.isEmptyRow(rowData);
    const isEmptyRowSelectField = isSelectField && isEmptyRow;
    if (!isEmptyRowSelectField && commitValue) {
      hasFlush = await this.setCellValueToDocument(form, grid, rowIndex, colIndex, rowData);
    } else if (!isEmptyRowSelectField && isEmptyRow) {
      await this.setEmptyGridRowValues(form, grid, editOpt, newValue);
    }
    if (rowData.rowType == "Detail") {
      await this.doSelectRow(grid, rowIndex, colIndex, editOpt, newValue);
    }
    let eventDone = false;
    LoadingUtil.show();
    try {
      if (!ignoreFireCellValueChanged) {
        await monitor.preCellValueChanged(grid, rowIndex, colIndex, editOpt);
        if (editing && fireEvent) {
          form.setOldValue(editOpt.key, curOldValue);
          await monitor.cellValueChanged(grid, rowIndex, colIndex, editOpt);
          form.setOldValue(null, null);
        }
        if (grid.hasSubDetail && grid.getFocusRowIndex() == rowIndex && rowData.rowType === "Detail") {
          if (hasFlush) {
            await SubDetailUtil.doChain(form, grid, false);
          } else {
            let coms = form.getSubDetail(editOpt.key);
            if (coms) {
              coms.forEach((com) => com.__setValueImpl(newValue));
            }
          }
        }
      }
      if (fireEvent) {
        await this.fireEvent(form, grid, editOpt, rowIndex);
        await this.processRowStyle(grid, rowIndex);
        eventDone = true;
      }
      await monitor.postCellValueChanged(grid, rowIndex, colIndex, editOpt);
    } catch (e) {
      if (!eventDone && fireEvent) {
        await this.fireEvent(form, grid, editOpt, rowIndex);
        await this.processRowStyle(grid, rowIndex);
      }
      throw e;
    } finally {
      LoadingUtil.hide();
    }
  }
  static async doAllDataValueChanged(grid, rowIndex, colIndex, editOpt, newValue, commitValue, editing, fireEvent) {
    const form = grid.getForm();
    const rowData = grid.getFullRowDataAt(rowIndex);
    const cellData = rowData.data[colIndex];
    if (commitValue) {
      await this.setCellValueToDocument(form, grid, rowIndex, colIndex, rowData, cellData);
    }
  }
  static async processRowStyle(grid, rowIndex) {
    var metaRow = grid.getDetailMetaRow();
    if (metaRow && metaRow.cells) {
      var form = grid.getForm();
      const cxt = new ViewContext(form);
      var metaCells = metaRow.cells, metaCell;
      for (let index = 0; index < metaCells.length; index++) {
        metaCell = metaCells[index];
        if (metaCell.backColor && !metaCell.backColor.startsWith("#")) {
          cxt.updateLocation(grid.key, rowIndex, index);
          var backColor = await form.asyncEval(metaCell.backColor, cxt);
          grid.setCellBackColor(rowIndex, index, backColor);
        }
      }
    }
  }
  //为默认行更新值
  static async setEmptyGridRowValues(form, grid, cellEditOpt, newValue) {
    const doc = form.getDocument(), gridKey = grid.key, cellKey = cellEditOpt.key;
    let v = newValue;
    if (v instanceof Date) {
      v = v.getTime();
    } else if (v instanceof Decimal) {
      const scale = cellEditOpt.editOptions.scale;
      if (scale > 0) {
        v = v.toFixed(scale);
      }
    } else if (v instanceof ItemData) {
      v = v.oid;
    }
    doc.setGridEmptyRowFieldValue(gridKey, cellKey, v);
  }
  static async fireEvent(form, grid, editOpt, rowIndex, rowData) {
    rowData = rowData || grid.getRowDataAt(rowIndex);
    if (!rowData || rowData.rowType != "Detail") {
      return;
    }
    if (grid.isEnable() && !grid.hasTree) {
      return this.dealRowInsert(grid, editOpt, rowIndex, rowData);
    }
  }
  // 处理设值后的空白行和分组插入
  static async dealRowInsert(grid, editOpt, rowIndex, rowData) {
    if (editOpt.columnKey && !editOpt.isSelect || grid.condition) {
      var inAutoGroup = rowData.inAutoGroup;
      if (rowData.inAutoGroup) {
        rowData.inAutoGroup = false;
        for (var i2 = rowIndex - 1; i2 >= 0; i2--) {
          var pRow = grid.getRowDataAt(i2);
          if (!pRow.inAutoGroup)
            break;
          pRow.inAutoGroup = false;
        }
        for (var k = rowIndex + 1, len = grid.getRowCount(); k < len; k++) {
          var nRow = grid.getRowDataAt(k);
          if (!nRow.inAutoGroup)
            break;
          nRow.inAutoGroup = false;
        }
      } else if (rowData.isAutoRow) {
        rowData.isAutoRow = false;
      }
      if (await grid.getNewEmptyRow()) {
        await grid.appendEmptyRow(rowIndex, rowData);
      }
      if (inAutoGroup) {
        return grid.appendEmptyGroup();
      }
    }
  }
  static async doOnCellClick(grid, rowIndex, colIndex) {
    var cellData = grid.getCellDataAt(rowIndex, colIndex);
    var editOpt = grid.getCellEditOpt(rowIndex, colIndex);
    editOpt = cellData.typeDef || editOpt;
    var onClick = editOpt.editOptions.onClick;
    if (onClick) {
      try {
        LoadingUtil.show();
        var form = grid.getForm();
        var cxt = new ViewContext(form);
        cxt.setGrid(grid);
        cxt.updateLocation(grid.key, rowIndex, colIndex);
        cxt.setClickButtonKey(editOpt.key);
        let activity = editOpt.editOptions.activity;
        if (activity && activity != "") {
          HeadInfoUtil.put(editOpt, HeadInfoOptType.STR_BUTTON, grid.ofFormID);
          let rowData = grid.getRowDataAt(rowIndex);
          let bookmark = rowData.bkmkRow.getBookmark();
          HeadInfoUtil.appendBookmark(bookmark);
          await form.checkDataAuthority(activity);
        }
        await form.asyncEval(onClick, cxt);
      } finally {
        LoadingUtil.hide();
      }
    }
  }
  static async doOnRowClick(grid, rowIndex) {
    let rowClick = grid.rowClick;
    if (rowClick) {
      let form = grid.getForm();
      form && form.getUIOptTracer().traceOnClick(event, grid, { rowIndex }, grid.impl);
      let rowData = grid.getRowDataAt(rowIndex);
      if (rowData && rowData.rowType == "Detail") {
        try {
          LoadingUtil.show();
          let frc = new FormRefreshContext();
          frc.addIgnoreGrid(grid.key);
          form.setRefreshContext(frc);
          let cxt = new ViewContext(form);
          cxt.setGrid(grid);
          cxt.updateLocation(grid.key, rowIndex, -1);
          HeadInfoUtil.put(grid, HeadInfoOptType.STR_RowClick, form.formID);
          await form.asyncEval(rowClick, cxt);
        } catch (e) {
          form && form.getUIOptTracer().traceOnResult(e);
          throw e;
        } finally {
          LoadingUtil.hide();
          form.setRefreshContext(null);
        }
      }
      form && form.getUIOptTracer().traceOnResult(null);
    }
  }
  static async doOnRowChanged(grid, rowIndex, oldRowIndex) {
    let form = grid.getForm();
    if (!form) {
      return;
    }
    await form.getUIProcess().doAfterRowChanged(grid);
    if (form.isDestroyed) {
      return;
    }
    let rowData = grid.getRowDataAt(rowIndex);
    let subdetails = form.getSubDetail(grid.key);
    if (subdetails) {
      let contextHook = null;
      if (rowData) {
        contextHook = ((rowData2) => {
          return () => {
            return {
              key: grid.key,
              rowIndex: grid.getRowIndex(rowData2)
            };
          };
        })(rowData);
      }
      subdetails.forEach((sub) => sub.contextHook = contextHook);
    }
    try {
      LoadingUtil.show();
      await SubDetailUtil.doChain(form, grid, true);
    } finally {
      LoadingUtil.hide();
    }
    let rowChanged = grid.focusRowChanged;
    if (rowChanged) {
      try {
        LoadingUtil.show();
        if (rowChanged) {
          let cxt = new ViewContext(form);
          cxt.updateLocation(grid.key, rowIndex, -1);
          await form.asyncEval(rowChanged, cxt);
        }
      } finally {
        LoadingUtil.hide();
      }
    }
  }
  static async doOnDblClick(grid, rowIndex, colIndex) {
    var form = grid.getForm(), cxt;
    var editOpt = grid.getCellEditOpt(rowIndex, colIndex);
    var cellDblClick = editOpt && editOpt.cellDblClick;
    var rowDblClick = grid.rowDblClick;
    if (cellDblClick || rowDblClick) {
      try {
        LoadingUtil.show();
        if (cellDblClick) {
          var form = grid.getForm();
          cxt = new ViewContext(form);
          cxt.setGrid(grid);
          cxt.updateLocation(grid.key, rowIndex, colIndex);
          await form.asyncEval(cellDblClick, cxt);
        }
        if (rowDblClick) {
          let form2 = grid.getForm();
          form2 && form2.getUIOptTracer().traceOnClick(event, grid, { rowIndex }, grid.impl);
          var rowData = grid.getRowDataAt(rowIndex);
          if (rowData) {
            try {
              form2.setPara("RowType", rowData.rowType);
              let groupCells = grid.groupCells;
              if (groupCells.length > 0) {
                form2.setPara("GroupCells", groupCells.join(","));
                let groupValues = {};
                groupCells.forEach((key) => {
                  let value = grid.getValueByKey(rowIndex, key);
                  if (value && value instanceof ItemData) {
                    value = value.getOID();
                  }
                  groupValues[key] = value;
                });
                form2.setPara("GroupValues", JSON.stringify(groupValues));
              }
              cxt = cxt || new ViewContext(form2);
              cxt.setGrid(grid);
              cxt.updateLocation(grid.key, rowIndex, -1);
              HeadInfoUtil.put(grid, HeadInfoOptType.STR_RowDblClick, form2.formID);
              await form2.asyncEval(rowDblClick, cxt);
            } finally {
              form2.rmvPara("RowType");
              form2.rmvPara("GroupCells");
              form2.rmvPara("GroupValues");
            }
          }
          form2 && form2.getUIOptTracer().traceOnResult(null);
        }
      } finally {
        LoadingUtil.hide();
      }
    }
  }
  static doOnChkClick(grid, rowIndex, colIndex, value, shiftDown) {
    let rowData = grid.getRowDataAt(rowIndex);
    let column = grid.getColumnAt(colIndex);
    if ((column.type == "select" || column.type == "checkbox") && // 可选择列
    !column.singleSelect && // 支持多选
    rowData.rowType == "Detail" && // 明细行
    shiftDown) {
      var oldFocusIndex = grid.getOldFocusRowIndex();
      if (oldFocusIndex != -1) {
        var start = Math.min(rowIndex, oldFocusIndex);
        var end = Math.max(rowIndex, oldFocusIndex);
        return this.doSelectMulti(grid, colIndex, start, end, value);
      }
    }
    return grid.setValueAt(rowIndex, colIndex, value, true, true, true);
  }
  static deleteRange(grid, left, right, top, bottom) {
    var deleteEachRow = (index) => {
      return ArrayUtil.dim(right - left + 1).reduce(async (prev, e, idx) => {
        await prev;
        var column = grid.getViewColumnAt(idx + left);
        var dataIndex = column.orgIndex;
        var cellData = grid.getCellDataAt(index, dataIndex);
        if (cellData.enable) {
          return grid.setValueAt(index, dataIndex, null, true, true, true);
        }
      }, true);
    };
    return ArrayUtil.dim(bottom - top + 1).reduce(async (prev, e, idx) => {
      await prev;
      return deleteEachRow(top + idx);
    }, true);
  }
  static checkOptions(grid, rowIndex) {
    var form = grid.getForm(), cxt = new ViewContext(form);
    cxt.updateLocation(grid.key, rowIndex, -1);
    var options2 = [];
    grid.traces.forEach((item) => {
      if (item.condition) {
        options2.push(form.asyncEval(item.condition).then((ret) => {
          if (ret) {
            return {
              caption: item.caption,
              content: item.content
            };
          }
        }));
      } else {
        options2.push({
          caption: item.caption,
          content: item.content
        });
      }
    });
    return Promise.all(options2);
  }
  static doOnMenuClick(grid, rowIndex, content) {
    if (content) {
      var form = grid.getForm(), cxt = new ViewContext(form);
      cxt.updateLocation(grid.key, rowIndex, -1);
      return form.asyncEval(content, cxt);
    }
  }
  // 只排序行,不做其他事
  static async doSortRows(grid, sortConfig) {
    let __sort = function(row1, row2, colIndex, sortType) {
      let cell1 = row1.data[colIndex], cell2 = row2.data[colIndex];
      let v1 = cell1.value, v2 = cell2.value;
      if (v1 == void 0 && v2 == void 0)
        return 0;
      if (v1 !== void 0 && v2 == void 0)
        return sortType === "asc" ? -1 : 1;
      if (v1 == void 0 && v2 !== void 0)
        return sortType === "asc" ? 1 : -1;
      if (v1 instanceof ItemData) {
        v1 = cell1.caption;
        v2 = cell2.caption;
      } else if (v1 instanceof Decimal) {
        v1 = v1.toNumber();
        v2 = v2.toNumber();
      } else if (v1 instanceof Date) {
        v1 = v1.getTime();
        v2 = v2.getTime();
      } else if (typeof v1 == "boolean") {
        v1 = v1 ? 1 : 0;
        v2 = v2 ? 1 : 0;
      }
      if (typeof v1 === "number") {
        return sortType === "desc" ? v2 - v1 : v1 - v2;
      }
      return sortType === "desc" ? v2.localeCompare(v1) : v1.localeCompare(v2);
    };
    let oldConfig = grid.getSortCfg();
    if (oldConfig) {
      oldConfig.forEach((item) => {
        let column = grid.findColumn(item.key);
        delete column.order;
        delete column.orderIndex;
      });
    }
    let len = sortConfig ? sortConfig.length : 0;
    if (len == 0) {
      if (!oldConfig) {
        return;
      }
      grid.getDatas().sort(function(row1, row2) {
        var idx1 = grid.getOldRowIndexByID(row1.rowId), idx2 = grid.getOldRowIndexByID(row2.rowId);
        if (idx1 == null || idx2 == null)
          return 0;
        if (idx1 == null && idx2 != null)
          return -1;
        if (idx1 != null && idx2 == null)
          return 1;
        return idx1 - idx2;
      });
      grid.deleteOldRowIDMap();
    } else {
      grid.ensureOldRowIDMap();
      let cols = [];
      for (let i2 = 0, config; config = sortConfig[i2]; i2++) {
        let column = grid.findColumn(config.key);
        if (column.type == "dict") {
          cols.push(column.key);
        }
      }
      await grid.fetchColsCaption(...cols);
      grid.getDatas().sort(function(row1, row2) {
        if (row1.rowType == "Fix" || row1.rowType == "Total" || row2.rowType == "Fix" || row2.rowType == "Total") {
          return grid.getRowIndexByID(row1.rowId) - grid.getRowIndexByID(row2.rowId);
        }
        if (!row1.bkmkRow)
          return 1;
        if (!row2.bkmkRow)
          return -1;
        let result = 0, i2 = 0, criteria;
        while (result === 0 && (criteria = sortConfig[i2++]) != null) {
          let colIndex = grid.findIndex(criteria.key);
          let sortType = criteria.order || "asc";
          result = __sort(row1, row2, colIndex, sortType);
        }
        return result;
      });
      sortConfig.forEach((item, index) => {
        let column = grid.findColumn(item.key);
        column.order = item.order;
        column.orderIndex = index;
      });
    }
    grid.updateAllData();
  }
  static doExport(grid) {
    let form = grid.getForm();
    let section = PrintGridUtil.toJSONSection(form, grid);
    let options2 = {
      service: "ExportFile",
      cmd: "ExportGrid",
      needDownload: true,
      exportFileName: grid.key,
      formKey: form.formKey,
      section: JSON.stringify(section),
      mode: 1
    };
    FileUtil.downLoadFile(options2);
  }
  static doShiftUpRow(grid, rowIndex) {
    grid.getForm().getUIOptTracer().traceOnClick(event, grid, { rowIndex }, grid.impl);
    if (grid.hasTree) {
      return this.doShiftUpRow_Tree(grid, rowIndex);
    }
    if (rowIndex <= 0) {
      return;
    }
    let rowData = grid.getRowDataAt(rowIndex);
    if (rowData.rowType != "Detail") {
      return;
    }
    let preData = grid.getRowDataAt(rowIndex - 1);
    if (preData.rowType != "Detail") {
      return;
    }
    return this.doExchangeRow(grid, rowIndex, rowIndex - 1);
  }
  static async doShiftUpRow_Tree(grid, rowIndex) {
    if (rowIndex <= 0) {
      return;
    }
    let rowData = grid.getRowDataAt(rowIndex);
    if (rowData.rowType != "Detail") {
      return;
    }
    let all_index = grid.getAllRowIndex(rowData);
    let view_index = grid.getRowIndex(rowData);
    let all_Data = grid.getAllData();
    let pre_index = -1, pre_view_index = -1, pre_row;
    for (let i2 = all_index - 1, row; row = all_Data[i2]; i2--) {
      if (row.treeLevel == rowData.treeLevel) {
        pre_row = row;
        pre_index = i2;
        pre_view_index = grid.getRowIndex(pre_row);
        break;
      } else if (row.treeLevel < rowData.treeLevel) {
        break;
      }
    }
    if (pre_index < 0) {
      return;
    }
    let curSeq = this.getCurSeq(grid, pre_row, rowData);
    let last_index = all_index, last_view_index = view_index;
    for (let i2 = all_index + 1, child_Row; child_Row = all_Data[i2]; i2++) {
      if (child_Row.treeLevel > rowData.treeLevel) {
        last_index = i2;
        last_view_index = child_Row.visible ? grid.getRowIndex(child_Row) : last_view_index;
      } else {
        break;
      }
    }
    let exc_rows = [];
    for (let i2 = last_index; i2 >= all_index; i2--) {
      exc_rows.unshift(all_Data.splice(i2, 1).shift());
    }
    all_Data.splice(pre_index, 0, ...exc_rows);
    grid.updateVisibleData();
    grid.rowCountChanged();
    await this.exchangeRowSequence(grid, pre_index, last_index, curSeq);
    await grid.fetchCaption(pre_view_index, last_view_index);
    await grid.fetchRowsStatus(pre_view_index, last_view_index);
    grid.doUpdate(pre_view_index, last_view_index);
    grid.setFocusRowIndex(grid.getRowIndex(rowData), false);
  }
  static doShiftDownRow(grid, rowIndex) {
    grid.getForm().getUIOptTracer().traceOnClick(event, grid, { rowIndex }, grid.impl);
    if (grid.hasTree) {
      return this.doShiftDownRow_Tree(grid, rowIndex);
    }
    if (rowIndex < 0) {
      return;
    }
    let rowData = grid.getRowDataAt(rowIndex);
    if (rowData.rowType != "Detail") {
      return;
    }
    if (rowIndex + 1 >= grid.getRowCount()) {
      return;
    }
    let nextData = grid.getRowDataAt(rowIndex + 1);
    if (nextData.rowType != "Detail") {
      return;
    }
    return this.doExchangeRow(grid, rowIndex, rowIndex + 1);
  }
  static async doShiftDownRow_Tree(grid, rowIndex) {
    if (rowIndex < 0) {
      return;
    }
    let rowData = grid.getRowDataAt(rowIndex);
    if (rowData.rowType != "Detail") {
      return;
    }
    let all_index = grid.getAllRowIndex(rowData);
    let all_Data = grid.getAllData();
    let next_index = -1, next_view_index = -1, next_row;
    for (let i2 = all_index + 1, row; row = all_Data[i2]; i2++) {
      if (row.treeLevel == rowData.treeLevel) {
        next_row = row;
        next_index = i2;
        next_view_index = grid.getRowIndex(next_row);
        break;
      } else if (row.treeLevel < rowData.treeLevel) {
        break;
      }
    }
    if (next_index < 0) {
      return;
    }
    let curSeq = this.getCurSeq(grid, rowData, next_row);
    let last_index = next_index, last_view_index = next_view_index;
    for (let i2 = next_index + 1, child_Row; child_Row = all_Data[i2]; i2++) {
      if (child_Row.treeLevel > rowData.treeLevel) {
        last_index = i2;
        last_view_index = child_Row.visible ? grid.getRowIndex(child_Row) : last_view_index;
      } else {
        break;
      }
    }
    let exc_rows = [];
    for (let i2 = last_index; i2 >= next_index; i2--) {
      exc_rows.unshift(all_Data.splice(i2, 1).shift());
    }
    all_Data.splice(all_index, 0, ...exc_rows);
    grid.updateVisibleData();
    grid.rowCountChanged();
    await this.exchangeRowSequence(grid, all_index, last_index, curSeq);
    await grid.fetchCaption(rowIndex, last_view_index);
    await grid.fetchRowsStatus(rowIndex, last_view_index);
    grid.doUpdate(rowIndex, last_view_index);
    grid.setFocusRowIndex(grid.getRowIndex(rowData), false);
  }
  // 获取起始行sequence值
  static getCurSeq(grid, fromRow, endRow) {
    let fromBkmkRow = fromRow.bkmkRow;
    let endBkmkRow = endRow.bkmkRow;
    let curSeq;
    if (fromBkmkRow && endBkmkRow) {
      let dataTable = grid.getForm().getDocument().getByKey(grid.tableKey);
      let seqIndex = dataTable.indexByKey(SystemField.SEQUENCE_FIELD_KEY);
      if (seqIndex != null) {
        let firstRow = fromBkmkRow;
        if (grid.hasColumnExpand()) {
          firstRow = fromBkmkRow.getAt(0);
        }
        dataTable.setByBkmk(firstRow.getBookmark());
        curSeq = dataTable.get(seqIndex);
      }
    }
    return curSeq;
  }
  // 普通表格交换行
  static async doExchangeRow(grid, rowIndex, excIndex) {
    let fromIndex = Math.min(rowIndex, excIndex);
    let endIndex = Math.max(rowIndex, excIndex);
    let fromRow = grid.getRowDataAt(fromIndex), endRow = grid.getRowDataAt(endIndex);
    let curSeq = this.getCurSeq(grid, fromRow, endRow);
    let allData = grid.getAllData();
    let data2 = grid.getDatas();
    data2.splice(fromIndex, 1, endRow);
    data2.splice(endIndex, 1, fromRow);
    fromIndex = grid.getAllRowIndexByID(fromRow.rowId);
    endIndex = grid.getAllRowIndexByID(endRow.rowId);
    allData.splice(fromIndex, 1, endRow);
    allData.splice(endIndex, 1, fromRow);
    grid.refreshIndex();
    grid.refreshAllIndex();
    await this.exchangeRowSequence(grid, fromIndex, endIndex, curSeq);
    grid.doUpdate(fromIndex, endIndex);
    await grid.setFocusRowIndex(excIndex, false);
  }
  static async beforeInsert(grid, rowIndex, insertChild = false) {
    let form = grid.getForm(), result = true;
    let beforeRowInsert = grid.beforeRowInsert;
    if (beforeRowInsert) {
      try {
        form.setPara("InsertChild", insertChild);
        let cxt = new ViewContext(form);
        cxt.updateLocation(grid.key, rowIndex, -1);
        result = await form.__eval(beforeRowInsert, cxt);
      } catch (e) {
        throw e;
      } finally {
        form.rmvPara("InsertChild");
      }
    }
    return result;
  }
  static async rowInsert(grid, rowIndex) {
    let row = grid.getRowDataAt(rowIndex);
    if (row.rowType != "Detail") {
      return;
    }
    let detailRow = grid.getDetailMetaRow();
    let form = grid.getForm();
    try {
      grid.rowInserting = true;
      await form.getUIProcess().doCalcOneRow(grid, rowIndex);
      row.UIProcessed = true;
    } finally {
      grid.rowInserting = false;
    }
    if (grid.addDataRow && grid.tableKey && !row.isAutoRow) {
      let table = form.getDocument().getByKey(grid.tableKey);
      table.addRow(true);
      row.bkmkRow = new DetailRowBkmk(table.getBkmk());
      let oidDataIndex = table.indexByKey(SystemField.OID_SYS_KEY);
      let oidIndex = grid.findIndexByColumnKey(SystemField.OID_SYS_KEY);
      if (oidIndex != null) {
        await grid.setValueAt(rowIndex, oidIndex, await NewOIDCache.applyNewOID(), true, false, false);
      } else if (oidDataIndex != null) {
        table.setByKey(SystemField.OID_SYS_KEY, await NewOIDCache.applyNewOID());
      }
      await this.dealWithSequence(form, grid, rowIndex);
    }
    if (grid.hasTree && row.parentRow && detailRow.rowTree.treeType == TreeType.COMMON) {
      let table = form.getDocument().getByKey(grid.tableKey);
      let { foreign, parent: parent2 } = detailRow.rowTree;
      let parentVal;
      let bkmkRow = row.parentRow.bkmkRow;
      if (bkmkRow) {
        let rowIndex2 = table.getRowIndexByBkmk(bkmkRow.getBookmark());
        parentVal = table.getObject(rowIndex2, table.indexByKey(parent2));
      } else {
        let parentIndex = grid.findIndexByColumnKey(parent2);
        if (parentIndex >= 0)
          parentVal = row.parentRow.data[parentIndex].value;
      }
      let foreignIndex = grid.findIndexByColumnKey(foreign);
      if (foreignIndex >= 0) {
        await grid.setValueAt(rowIndex, foreignIndex, parentVal, true, false, false);
      } else if (row.bkmkRow) {
        let rowIndex2 = table.getRowIndexByBkmk(row.bkmkRow.getBookmark());
        table.setObject(rowIndex2, table.indexByKey(foreign), parentVal);
      }
    }
    await detailRow.cells.reduce(async (prev, cell, colIndex) => {
      await prev;
      if (cell.cellType == ControlType.DYNAMIC) {
        return this.refreshDynamicOpt(form, grid, rowIndex, colIndex, cell);
      }
    }, true);
    let rowInsert = grid.rowInsert;
    if (rowInsert) {
      let cxt = new ViewContext(form);
      cxt.updateLocation(grid.key, rowIndex, -1);
      return form.__eval(rowInsert, cxt);
    }
  }
  static async rowDelete(grid, rowIndex) {
    var form = grid.getForm();
    await form.getUIProcess().doPostDeleteRow(grid, !grid.getMetaObj().onRowDelete, true);
    if (grid.serialSeq) {
      await this.dealWithSequence(form, grid, rowIndex);
    }
    var rowDelete = grid.rowDelete;
    if (rowDelete) {
      return form.__eval(rowDelete);
    }
  }
  static async setCellValueToDocument(form, grid, rowIndex, colIndex, rowData, cellData) {
    rowData = rowData || grid.getRowDataAt(rowIndex);
    cellData = cellData || rowData.data[colIndex];
    let result;
    switch (rowData.rowType) {
      case "Fix":
        result = await this.setFixValueToDoc(form, grid, rowIndex, colIndex);
        break;
      case "Detail":
        result = await this.setDtlValueToDoc(form, grid, rowIndex, colIndex, rowData, cellData);
        break;
    }
    return result;
  }
  static setCellValueToDataTable(form, grid, table, editOpt, cellData) {
    var columnKey = editOpt.columnKey;
    if (!columnKey)
      return;
    var cellType = editOpt.cellType;
    var newValue = cellData.value;
    switch (cellType) {
      case ControlType.DYNAMICDICT:
      case ControlType.DICT:
        var editOptions = editOpt.editOptions, itemKey = "", dataElementKey = "";
        if (newValue == null) {
          if (editOptions.multiSelect || editOptions.isEditValue) {
            table.setByKey(columnKey, null);
          } else {
            table.setByKey(columnKey, 0);
          }
        } else {
          if (editOptions.isEditValue) {
            if (editOptions.multiSelect) {
              var editValues = [], itemKey = "";
              for (var i2 = 0, len = newValue.length; i2 < len; i2++) {
                editValues.push(newValue[i2].editValue);
                itemKey = newValue[0].itemKey;
                dataElementKey = newValue[0].dataElementKey;
              }
              table.setByKey(columnKey, editValues.join(","));
            } else {
              table.setByKey(columnKey, newValue.editValue);
              itemKey = newValue.itemKey;
              dataElementKey = newValue.dataElementKey;
            }
          } else {
            if (editOptions.multiSelect) {
              var oids = [], itemKey = "";
              for (var i2 = 0, len = newValue.length; i2 < len; i2++) {
                oids.push(newValue[i2].oid);
                oids.push(",");
              }
              if (oids && oids.length > 0) {
                oids.pop();
                itemKey = newValue[0].itemKey;
                dataElementKey = newValue[0].dataElementKey;
              }
              table.setByKey(columnKey, oids.join(""));
            } else {
              table.setByKey(columnKey, newValue.oid);
              itemKey = newValue.itemKey;
              dataElementKey = newValue.dataElementKey;
            }
          }
          if (cellType == ControlType.DYNAMICDICT) {
            if (!dataElementKey) {
              dataElementKey = cellData.dataElementKey;
            }
            let refDataElementKey = editOpt.editOptions.refDataElementKey;
            if (refDataElementKey) {
              let dataElementCmp = form.getCellLocation(refDataElementKey);
              if (!dataElementCmp) {
                throw COMPONENT_NOT_EXISTS(refDataElementKey);
              }
              refDataElementKey = dataElementCmp.columnKey;
              table.setByKey(refDataElementKey, dataElementKey);
            } else {
              table.setByKey(columnKey + "ItemKey", itemKey);
            }
          } else if (cellType == ControlType.COMPDICT) {
            table.setByKey(columnKey + "ItemKey", itemKey);
          }
        }
        if (editOpt.codeColumnKey) {
          table.setByKey(editOpt.codeColumnKey, this.getRealCode(editOpt.displayCols, newValue));
        }
        break;
      case ControlType.DYNAMIC:
        this.setDynamicCellValueToDataTable(form, grid, table, editOpt, cellData);
        break;
      case ControlType.MONTHPICKER:
        table.setByKey(columnKey, newValue);
        break;
      case ControlType.TIMEPICKER:
        table.setByKey(columnKey, newValue);
        break;
      case ControlType.NUMBEREDITOR:
        var editOptions = editOpt.editOptions;
        if (!editOptions.allowNull) {
          newValue = TypeConvertor.toDecimal(newValue);
        }
        table.setByKey(columnKey, newValue);
        break;
      default:
        table.setByKey(columnKey, BaseHandler.convertValue(newValue, table.getColByKey(columnKey).type));
        break;
    }
  }
  static setDynamicCellValueToDataTable(form, grid, table, editOpt, cellData) {
    var typeDef = cellData.typeDef;
    if (!typeDef) {
      return;
    }
    var curOptions = typeDef.editOptions, typeDefKey = typeDef.key, cellType = typeDef.cellType;
    var columnKey = editOpt.columnKey;
    var newValue = cellData.value;
    if (grid.isNullValue(newValue, cellData)) {
      newValue = null;
      typeDefKey = null;
    }
    switch (cellType) {
      case ControlType.DYNAMICDICT:
      case ControlType.DICT:
        if (curOptions.multiSelect) {
          var oids = [], itemKey = "";
          if (newValue) {
            for (var i2 = 0, len = newValue.length; i2 < len; i2++) {
              oids.push(newValue[i2].oid);
              oids.push(",");
            }
          }
          if (oids && oids.length > 0) {
            oids.pop();
            itemKey = newValue[0].itemKey;
          }
          table.setByKey(columnKey, oids.join(""));
          if (cellType == ControlType.DYNAMICDICT) {
            table.setByKey(columnKey + "ItemKey", itemKey);
          }
        } else {
          var oid = newValue ? newValue.oid : null;
          table.setByKey(columnKey, oid);
          if (cellType == ControlType.DYNAMICDICT || cellType == ControlType.COMPDICT) {
            table.setByKey(columnKey + "ItemKey", newValue.itemKey);
          }
        }
        break;
      case ControlType.DATEPICKER:
        var result = null;
        if (newValue) {
          var format = null;
          if (curOptions.onlyDate) {
            format = "yyyy-MM-dd";
          } else {
            format = "yyyy-MM-dd HH:mm:ss";
          }
          result = newValue.Format(format);
        }
        table.setByKey(columnKey, result);
        break;
      case ControlType.CHECKBOX:
        newValue = TypeConvertor.toInt(newValue);
        table.setByKey(columnKey, TypeConvertor.toString(newValue));
        break;
      default:
        table.setByKey(columnKey, TypeConvertor.toString(newValue));
        break;
    }
    let index = table.indexByKey(columnKey + "TypeDefKey");
    if (index != null) {
      table.setByKey(index, typeDefKey);
    }
  }
  static setFixValueToDoc(form, grid, rowIndex, colIndex) {
    var editOpt = grid.getCellEditOpt(rowIndex, colIndex), cellData = grid.getCellDataAt(rowIndex, colIndex), doc = form.getDocument();
    if (!doc) {
      return;
    }
    var table = doc.getByKey(editOpt.tableKey);
    if (!table) {
      return;
    }
    var bkmkRow = cellData.bkmkRow;
    if (bkmkRow) {
      table.setByBkmk(bkmkRow.getBookmark());
      this.setCellValueToDataTable(form, grid, table, editOpt, cellData);
    } else {
      this.flushFixCell(form, grid, editOpt, rowIndex, colIndex);
    }
  }
  static flushFixCell(form, grid, metaCell, rowIndex, colIndex) {
    var doc = form.getDocument(), table = doc.getByKey(metaCell.tableKey);
    table.addRow(true);
    var bkmkRow = new DetailRowBkmk(table.getBkmk());
    if (grid.hasColumnExpand() || grid.hasRowAreaExpand) {
      var rowData = grid.getRowDataAt(rowIndex), metaRow = rowData.meta, rowDimValue = metaRow.dimValue;
      if (grid.hasRowAreaExpand && rowDimValue) {
        for (var c = 0, length2 = rowDimValue.values.length; c < length2; c++) {
          var node = rowDimValue.values[c];
          table.setByKey(node.columnKey, node.value);
        }
      }
      var startRow = rowIndex;
      var startCol = colIndex;
      if (grid.hasRowAreaExpand && !metaRow.isAreaHead) {
        for (var i2 = rowIndex; i2 >= 0; --i2) {
          var rowData = grid.getRowDataAt(i2);
          var metaRow = rowData.meta;
          if (metaRow.isAreaHead) {
            startRow = i2;
            break;
          }
        }
      } else {
        startRow = rowIndex;
      }
      if (metaCell.isColExpand) {
        for (let i22 = colIndex; i22 >= 0; --i22) {
          metaCell = metaRow.cells[i22];
          var tempKey = metaCell.crossValue;
          if (tempKey == null || !tempKey.equals(crossValue)) {
            break;
          }
          startCol = i22;
        }
      } else {
        startCol = 0;
      }
      var crossValue = metaCell.crossValue;
      if (metaCell.isColExpand) {
        var expInfo = grid.dataModel.expandModel[metaCell.columnArea];
        for (let k = 0, length22 = crossValue.values.length; k < length22; k++) {
          var node = crossValue.values[k];
          var columnKey = expInfo[k];
          if (columnKey) {
            table.setByKey(columnKey, node.value);
          }
        }
      }
      for (let i22 = startRow, size2 = grid.getRowCount(); i22 < size2; i22++) {
        var rowData = grid.getRowDataAt(i22);
        var metaRow = rowData.meta;
        if (metaRow.rowType !== "Fix") {
          break;
        }
        for (let k = startCol, length22 = metaRow.cells.length; k < length22; k++) {
          var metaCell = grid.getCellEditOpt(i22, k);
          if (metaCell.isColExpand && !crossValue.equals(metaCell.crossValue)) {
            break;
          }
          if (metaCell.columnKey) {
            var cellData = rowData.data[k];
            this.setCellValueToDataTable(form, grid, table, metaCell, cellData);
            cellData.bkmkRow = bkmkRow;
          }
        }
        if (grid.hasRowAreaExpand && metaRow.isAreaTail) {
          break;
        }
      }
    } else {
      var dimValue = metaCell.dimValue;
      if (dimValue) {
        for (let i22 = 0, length22 = dimValue.size(); i22 < length22; i22++) {
          var node = dimValue.getValue(i22), value = BaseHandler.convertValue(node.value, node.dataType);
          table.setByKey(node.columnKey, value);
        }
      }
      var cellData = grid.getCellDataAt(rowIndex, colIndex);
      this.setCellValueToDataTable(form, grid, table, metaCell, cellData);
      cellData.bkmkRow = bkmkRow;
    }
  }
  static async setDtlValueToDoc(form, grid, rowIndex, colIndex, rowData, cellData) {
    const doc = form.getDocument();
    if (doc == null)
      return false;
    rowData = rowData || grid.getRowDataAt(rowIndex);
    cellData = cellData || rowData.data[colIndex];
    const metaRow = rowData.meta;
    const editOpt = metaRow.cells[colIndex];
    if (!editOpt.hasDB)
      return false;
    const newValue = cellData.value;
    const table = doc.getByKey(grid.tableKey);
    let viewRow = rowData.bkmkRow;
    let hasFlush = false;
    if (rowData.rowType === "Detail" && !viewRow) {
      if (grid.hasColumnExpand()) {
        const expandModel = grid.dataModel.expandModel;
        viewRow = new ExpandRowBkmk(expandModel.length);
        for (let i2 = 0, len = rowData.data.length; i2 < len; i2++) {
          const cellData2 = rowData.data[i2];
          const metaCell = metaRow.cells[i2];
          if (metaCell.isColExpand) {
            const crossValue = metaCell.crossValue;
            const colArea = metaCell.columnArea;
            let detailViewRow = viewRow.getAtArea(colArea, crossValue);
            if (!detailViewRow) {
              table.addRow(true);
              detailViewRow = new DetailRowBkmk(table.getBkmk());
              viewRow.add(colArea, crossValue, detailViewRow);
              let expInfo = expandModel[colArea], node, expKey;
              for (let k = 0, cLen = crossValue.values.length; k < cLen; k++) {
                node = crossValue.values[k];
                expKey = expInfo[k];
                if (expKey !== void 0 && expKey !== null && expKey.length > 0) {
                  table.setByKey(expKey, node.value);
                }
              }
            }
            this.setCellValueToDataTable(form, grid, table, metaCell, cellData2);
          }
        }
        for (let m = 0, size2 = viewRow.size(); m < size2; m++) {
          table.setByBkmk(viewRow.getAt(m).getBookmark());
          for (let n = 0, length2 = rowData.data.length; n < length2; n++) {
            const metaCell = metaRow.cells[n];
            if (!metaCell.isColExpand) {
              this.setCellValueToDataTable(form, grid, table, metaCell, rowData.data[n]);
            }
          }
        }
      } else {
        table.addRow(true);
        viewRow = new DetailRowBkmk(table.getBkmk());
        const dimValue = metaRow.dimValue;
        let dimNode;
        if (dimValue) {
          for (let l = 0, size2 = dimValue.size(); l < size2; l++) {
            dimNode = dimValue.getValue(l);
            table.setByKey(dimNode.getColumnKey(), BaseHandler.convertValue(dimNode.getValue(), dimNode.getDataType()));
          }
        }
        for (let k = 0, len = rowData.data.length; k < len; k++) {
          this.setCellValueToDataTable(form, grid, table, metaRow.cells[k], rowData.data[k]);
        }
        let pGrid, parentRow, pTable, pBkmk;
        if (grid.isSubDetail) {
          var parentIndex = grid.contextHook ? grid.contextHook().rowIndex : -1;
          if (parentIndex == -1) {
            return false;
          }
          pGrid = grid.parentGrid;
          parentRow = pGrid.getRowDataAt(parentIndex);
          pTable = form.getDocument().getByKey(pGrid.tableKey);
          pBkmk = parentRow.bkmkRow.getBookmark();
          pTable.setByBkmk(pBkmk);
          table.setParentBkmk(pBkmk);
        }
        await setSystemColumIfNull$2(form.getDocument(), table, pTable);
        const shadowTable = doc.getShadow(grid.tableKey);
        if (shadowTable) {
          ViewUtil.addShadowRow(table, shadowTable);
          shadowTable.setState(DataDef.D_New);
        }
      }
      rowData.bkmkRow = viewRow;
      await this.dealWithSequence(form, grid, rowIndex);
      await this.dealWithSystemField(form, grid, rowIndex);
      await form.getUIProcess().calcPs.calcEmptyRowChildGridsCmd(grid);
      hasFlush = true;
    } else {
      if (grid.hasColumnExpand()) {
        if (editOpt.isColExpand) {
          const crossValue = editOpt.crossValue, colArea = editOpt.columnArea;
          let cellBkmk = viewRow.getAtArea(colArea, crossValue);
          if (!cellBkmk) {
            table.addRow(true);
            cellBkmk = new DetailRowBkmk(table.getBkmk());
            viewRow.add(colArea, crossValue, cellBkmk);
            const expInfo = grid.dataModel.expandModel[colArea];
            let node;
            for (let k = 0, count = crossValue.values.length; k < count; k++) {
              node = crossValue.values[k];
              table.setByKey(expInfo[k], node.value);
            }
            const metaRow2 = rowData.meta;
            for (let i2 = 0, size2 = metaRow2.cells.length; i2 < size2; i2++) {
              const _editOpt = metaRow2.cells[i2];
              if (!_editOpt.isColExpand) {
                if (_editOpt.columnKey == SystemField.OID_SYS_KEY) {
                  const oid = TypeConvertor.toLong(table.getByKey(SystemField.OID_SYS_KEY));
                  if (oid <= 0) {
                    table.setByKey(SystemField.OID_SYS_KEY, await NewOIDCache.applyNewOID());
                  }
                } else {
                  this.setCellValueToDataTable(form, grid, table, _editOpt, rowData.data[i2]);
                }
              }
            }
          } else {
            table.setByBkmk(cellBkmk.getBookmark());
          }
          this.setCellValueToDataTable(form, grid, table, editOpt, cellData);
        } else {
          for (let i2 = 0, len = viewRow.size(); i2 < len; i2++) {
            table.setByBkmk(viewRow.getAt(i2).getBookmark());
            this.setCellValueToDataTable(form, grid, table, editOpt, cellData);
          }
        }
      } else {
        table.setByBkmk(viewRow.getBookmark());
        const shadowTable = doc.getShadow(grid.tableKey);
        if (shadowTable) {
          let bookmark = ViewUtil.findShadowBkmk(doc, grid.tableKey);
          if (bookmark == -1) {
            bookmark = ViewUtil.addShadowRow(table, shadowTable);
          }
          shadowTable.setByBkmk(bookmark);
        }
        this.setCellValueToDataTable(form, grid, table, editOpt, cellData);
        if (shadowTable) {
          this.setValue2ShadowTable(shadowTable, editOpt, table);
        }
      }
    }
    const coms = form.getSubDetail(editOpt.key);
    if (coms && grid.getFocusRowIndex() == rowIndex) {
      for (let i2 = 0, len = coms.length; i2 < len; i2++) {
        const tmp = coms[i2];
        const com = Utils.isString(tmp) ? form.getComponent(tmp) : tmp;
        await com.setValue(newValue, false, false);
      }
    }
    return hasFlush;
  }
  /**
      dataTable新增一行后会生成OID，如果Grid行中设置了OID和SOID的显示字段，需要将DataTable系统字段值填到GridRow中
  */
  static async dealWithSystemField(form, grid, rowIndex) {
    const rowData = grid.getRowDataAt(rowIndex);
    const bkmkRow = rowData.bkmkRow;
    if (rowData.rowType === "Detail" && !bkmkRow) {
      return;
    }
    const table = form.getDocument().getByKey(grid.tableKey);
    if (table.size() == 0) {
      return;
    }
    if (grid.hasColumnExpand()) {
      const expandModel = grid.dataModel.expandModel;
      let hasExpandSystemField = false;
      for (let expandIndex = 0, expandLen = expandModel.size; expandIndex < expandLen; expandIndex++) {
        if (expandModel[expandIndex] == SystemField.OID_SYS_KEY || expandModel[expandIndex] == SystemField.SOID_SYS_KEY) {
          hasExpandSystemField = true;
          break;
        }
      }
      if (hasExpandSystemField)
        ;
      else {
        table.setByBkmk(bkmkRow.getRowArray()[0].bookmark);
        await this.setSystemFieldInGridFromDtl(grid, rowIndex, table);
      }
    } else {
      table.setByBkmk(bkmkRow.getBookmark());
      await this.setSystemFieldInGridFromDtl(grid, rowIndex, table);
    }
  }
  static async setSystemFieldInGridFromDtl(grid, rowIndex, table) {
    let oidIndex = table.indexByKey(SystemField.OID_SYS_KEY);
    if (oidIndex != null) {
      const oid = table.get(oidIndex);
      let colIndex = grid.findIndexByColumnKey(SystemField.OID_SYS_KEY);
      if (colIndex != null) {
        await grid.setValueAt(rowIndex, colIndex, oid, false, false, false, true);
      }
    }
    let soidIndex = table.indexByKey(SystemField.SOID_SYS_KEY);
    if (soidIndex != null) {
      const soid = table.get(soidIndex);
      let colIndex = grid.findIndexByColumnKey(SystemField.SOID_SYS_KEY);
      if (colIndex != null) {
        await grid.setValueAt(rowIndex, colIndex, soid, false, false, false, true);
      }
    }
  }
  static setValue2ShadowTable(shadowTable, editOpt, dataTable) {
    var columnKey = editOpt.columnKey;
    shadowTable.setByKey(columnKey, dataTable.getByKey(columnKey));
    var itemKeyColumn = columnKey + "ItemKey";
    if (shadowTable.indexByKey(itemKeyColumn) != null) {
      shadowTable.setByKey(itemKeyColumn, dataTable.getByKey(itemKeyColumn));
    }
    var typeDefKeyColumn = columnKey + "TypeDefKey";
    if (shadowTable.indexByKey(typeDefKeyColumn) != null) {
      shadowTable.setByKey(typeDefKeyColumn, dataTable.getByKey(typeDefKeyColumn));
    }
  }
  // 获取拓展的维度数据对应的key
  static crossValKey(metaCell) {
    var key = [];
    key.push(metaCell.columnArea);
    var crossValue = metaCell.crossValue;
    if (crossValue) {
      for (var i2 = 0; i2 < crossValue.values.length; i2++) {
        var node = crossValue.values[i2];
        key.push(node.columnKey, node.dataType, node.value);
      }
    }
    return key.join("_");
  }
  static async showRowData(form, grid, rowIndex, metaRow, loading = true) {
    let rowData = grid.getRowDataAt(rowIndex);
    switch (metaRow.rowType) {
      case "Detail":
        await this.showDetailRowData(form, grid, rowIndex, rowData, metaRow, loading);
        break;
      case "Fix":
        await this.showFixRowData(form, grid, rowIndex, rowData, metaRow, loading);
        break;
      case "Total":
      case "Group":
        await this.showTitleRowData(form, grid, rowIndex, rowData, metaRow, loading);
        break;
    }
  }
  static showTitleRowData(form, grid, rowIndex, rowData, metaRow, loading = true) {
  }
  static showRowDataByTable(form, grid, rowIndex, metaRow, table) {
    var metaCell, columnKey;
    for (var i2 = 0; metaCell = metaRow.cells[i2]; i2++) {
      columnKey = metaCell.columnKey;
      if (columnKey && table.indexByKey(columnKey) != null) {
        var value = UIUtil.getCellValue(metaCell, table, form);
        grid.__setValueAt(rowIndex, i2, value, null, metaCell);
      }
    }
  }
  // 更新动态单元格配置
  static doRefeshDynamicOpt(form, grid, rowIndex, colIndex, typeDef) {
    var cellData = grid.getCellDataAt(rowIndex, colIndex);
    if (typeDef) {
      if (typeDef.key != cellData.typeDefKey) {
        let newData = GridUtil.initCellData(grid, typeDef);
        cellData.value = newData.value;
        cellData.caption = newData.caption;
        cellData.typeDef = Object.assign({}, typeDef);
        cellData.typeDefKey = typeDef.key;
      }
    } else {
      delete cellData.typeDef;
      delete cellData.typeDefKey;
    }
    return cellData.typeDef;
  }
  // 刷新动态单元格,加载时,根据数据中的typeDefKey
  static async refreshDynamicOpt(form, grid, rowIndex, colIndex, editOpt, typeDefKey) {
    var cxt = new ViewContext(form);
    cxt.updateLocation(grid.key, rowIndex, colIndex);
    var result = await form.__eval(editOpt.editOptions.typeFormula, cxt);
    if (!result)
      return;
    let cache2 = form.getCellTypeCache();
    cache2.store(result);
    var typeDef = null;
    if (typeDefKey || typeof result == "string") {
      typeDef = cache2.get(typeDefKey || result);
    } else if (typeof result == "object") {
      typeDef = result;
    }
    this.doRefeshDynamicOpt(form, grid, rowIndex, colIndex, typeDef);
    return grid.refreshDynamicEditor(typeDef, rowIndex, colIndex);
  }
  static async showDetailRowData(form, grid, rowIndex, rowData, metaRow, loading = true) {
    var doc = form.getDocument();
    if (doc == null)
      return;
    var dataTable = doc.getByKey(grid.tableKey);
    if (dataTable == null)
      return;
    var rowbkmk = rowData.bkmkRow, firstRow = rowbkmk;
    if (rowbkmk.getRowType() == BkmkType.Expand) {
      firstRow = rowbkmk.getAt(0);
    }
    dataTable.setByBkmk(firstRow.getBookmark());
    if (grid.pageInfo.pageLoadType == PageLoadType.DB) {
      let shadowTable = doc.getShadow(grid.tableKey);
      if (ViewUtil.findShadowBkmk(doc, grid.tableKey) != -1) {
        ViewUtil.mergeShadowRow(dataTable, shadowTable);
      }
    }
    const typeCache = form.getCellTypeCache();
    let metaCell, cellData;
    for (var i2 = 0, length2 = metaRow.cells.length; i2 < length2; i2++) {
      metaCell = metaRow.cells[i2];
      cellData = rowData.data[i2];
      if (metaCell.cellType === ControlType.DYNAMIC) {
        let typeDef, typeDefKey;
        let index = dataTable.indexByKey(metaCell.columnKey + "TypeDefKey");
        if (index != null) {
          typeDefKey = dataTable.get(index);
        }
        if (typeDefKey) {
          typeDef = typeCache.get(typeDefKey);
        }
        if (typeDef) {
          this.doRefeshDynamicOpt(form, grid, rowIndex, i2, typeDef);
        } else {
          await this.refreshDynamicOpt(form, grid, rowIndex, i2, metaCell, typeDefKey);
        }
      }
      if (metaCell.hasDB) {
        let col = dataTable.getColByKey(metaCell.columnKey);
        let checkInfinity = col.type == DataType.NUMERIC || col.type == DataType.LONG || col.type == DataType.INT;
        if (metaCell.isColExpand) {
          var detailRowBkmk = rowbkmk.getAtArea(metaCell.columnArea, metaCell.crossValue);
          if (detailRowBkmk != null) {
            dataTable.setByBkmk(detailRowBkmk.getBookmark());
            let value = UIUtil.getCellValue(metaCell, dataTable, form);
            if (checkInfinity && value === "Infinity") {
              grid.setCellInfinity(rowIndex, i2, true);
            } else {
              grid.__setValueAt(rowIndex, i2, value, cellData, metaCell, loading);
            }
          }
        } else {
          dataTable.setByBkmk(firstRow.getBookmark());
          let value = UIUtil.getCellValue(metaCell, dataTable, form);
          if (checkInfinity && value === "Infinity") {
            grid.setCellInfinity(rowIndex, i2, true);
          } else {
            grid.__setValueAt(rowIndex, i2, value, cellData, metaCell, loading);
          }
        }
      } else if (metaCell.isSelect) {
        let value = dataTable.getByKey(SystemField.SELECT_FIELD_KEY);
        grid.__setValueAt(rowIndex, i2, value, cellData, metaCell, loading);
      } else if (metaCell.cellType == ControlType.LABEL || metaCell.cellType == ControlType.BUTTON || metaCell.cellType == ControlType.HYPERLINK) {
        cellData.caption = metaCell.caption;
      }
    }
  }
  static showFixRowData(form, grid, rowIndex, rowData, metaRow, loading = true) {
    var document2 = form.getDocument(), table, value;
    var rowDimValue = metaRow.dimValue, bkmkRow, metaCell, tableKey, cellData;
    for (var i2 = 0; metaCell = metaRow.cells[i2]; i2++) {
      cellData = rowData.data[i2];
      if (metaCell.hasDB) {
        tableKey = metaCell.tableKey;
        table = document2.getByKey(tableKey);
        let col = table.getColByKey(metaCell.columnKey);
        let checkInfinity = col.type == DataType.NUMERIC || col.type == DataType.LONG || col.type == DataType.INT;
        if (metaCell.dimValue) {
          var bkmk = DataUtil$1.locate(table, metaCell.dimValue);
          if (bkmk != -1) {
            value = UIUtil.getCellValue(metaCell, table, form);
            if (checkInfinity && value == "Infinity") {
              grid.setCellInfinity(rowIndex, i2, true);
            } else {
              grid.__setValueAt(rowIndex, i2, value, cellData, metaCell, loading);
            }
            cellData.bkmkRow = new DetailRowBkmk(bkmk);
          }
        } else {
          if (metaCell.isColExpand) {
            var rowMap = grid.dataModel.rowMap[tableKey];
            if (rowMap) {
              var crossValue = metaCell.crossValue, realKey = crossValue.clone();
              if (rowDimValue) {
                var multiKey = DataUtil$1.convertDimValue(rowDimValue);
                realKey.values = multiKey.values.concat(realKey.values);
              }
              var bkmkRow = rowMap.get(realKey);
              if (bkmkRow) {
                table.setByBkmk(bkmkRow.getBookmark());
                value = UIUtil.getCellValue(metaCell, table, form);
                if (checkInfinity && value == "Infinity") {
                  grid.setCellInfinity(rowIndex, i2, true);
                } else {
                  grid.__setValueAt(rowIndex, i2, value, cellData, metaCell, loading);
                }
                cellData.bkmkRow = bkmkRow;
              }
            }
          } else {
            if (rowDimValue) {
              if (bkmkRow == null) {
                var bkmk = DataUtil$1.locate(table, rowDimValue);
                if (bkmk != -1) {
                  bkmkRow = new DetailRowBkmk(bkmk);
                }
              }
              if (bkmkRow) {
                value = UIUtil.getCellValue(metaCell, table, form);
                if (checkInfinity && value == "Infinity") {
                  grid.setCellInfinity(rowIndex, i2, true);
                } else {
                  grid.__setValueAt(rowIndex, i2, value, cellData, metaCell, loading);
                }
                cellData.bkmkRow = bkmkRow;
              }
            } else {
              if (table.first()) {
                if (bkmkRow == null) {
                  bkmkRow = new DetailRowBkmk(table.getBkmk());
                }
                value = UIUtil.getCellValue(metaCell, table, form);
                if (checkInfinity && value == "Infinity") {
                  grid.setCellInfinity(rowIndex, i2, true);
                } else {
                  grid.__setValueAt(rowIndex, i2, value, cellData, metaCell, loading);
                }
                cellData.bkmkRow = bkmkRow;
              }
            }
          }
        }
      }
    }
  }
  static async exchangeRowSequence(grid, fromIndex, endIndex, curSeq) {
    if (!grid.tableKey)
      return;
    let table = grid.getForm().getDocument().getByKey(grid.tableKey);
    let seqIndex = table.indexByKey(SystemField.SEQUENCE_FIELD_KEY);
    if (seqIndex == null || curSeq == null) {
      return;
    }
    let data2 = grid.getAllData(), row, bkmkRow;
    for (let i2 = fromIndex; i2 <= endIndex; i2++) {
      row = data2[i2], bkmkRow = row.bkmkRow;
      if (!bkmkRow)
        continue;
      if (grid.hasColumnExpand()) {
        for (let j = 0, jlen = bkmkRow.size(); j < jlen; j++) {
          table.setByBkmk(bkmkRow.getAt(j).getBookmark());
          table.set(seqIndex, curSeq);
        }
      } else {
        table.setByBkmk(bkmkRow.getBookmark());
        table.set(seqIndex, curSeq);
      }
      curSeq++;
    }
    await this.setSeqInGridFromDtl(grid, fromIndex, endIndex);
  }
  // 新增/删除调用,交换行使用exchangeRowSequence
  // rowIndex为界面行
  static async dealWithSequence(form, grid, fromIndex) {
    const dataTable = form.getDocument().getByKey(grid.tableKey);
    if (dataTable.size() == 0) {
      return;
    }
    const SYS_SEQUENCE = SystemField.SEQUENCE_FIELD_KEY;
    const seqIndex = dataTable.indexByKey(SYS_SEQUENCE);
    if (seqIndex === null) {
      return;
    }
    let data2 = grid.getAllData();
    let rowData = grid.getRowDataAt(fromIndex);
    if (!rowData) {
      return;
    }
    fromIndex = grid.getAllRowIndexByID(rowData.rowId);
    let curSeq = 0;
    for (let i2 = fromIndex - 1, row; row = data2[i2]; --i2) {
      if (!row.isDetail || !row.bkmkRow) {
        continue;
      }
      let firstRow = row.bkmkRow;
      if (grid.hasColumnExpand()) {
        firstRow = firstRow.getAt(0);
      }
      dataTable.setByBkmk(firstRow.getBookmark());
      curSeq = dataTable.getByKey(SYS_SEQUENCE);
      break;
    }
    if (grid.getMetaObj().serialSeq) {
      for (let i2 = fromIndex; i2 < data2.length; i2++) {
        let row = data2[i2], bkmk = row.bkmkRow;
        if (!row.isDetail || !bkmk)
          continue;
        curSeq++;
        if (grid.hasColumnExpand()) {
          dataTable.setByBkmk(bkmk.getAt(0).getBookmark());
          for (let j = 0, jlen = bkmk.size(); j < jlen; j++) {
            dataTable.setByBkmk(bkmk.getAt(j).getBookmark());
            dataTable.set(seqIndex, curSeq);
          }
        } else {
          dataTable.setByBkmk(bkmk.getBookmark());
          dataTable.set(seqIndex, curSeq);
        }
      }
    } else {
      for (let i2 = fromIndex; i2 < data2.length; i2++) {
        let row = data2[i2], bkmk = row.bkmkRow;
        if (!row.isDetail || !bkmk)
          continue;
        if (grid.hasColumnExpand()) {
          dataTable.setByBkmk(bkmk.getAt(0).getBookmark());
          let seq = parseInt(dataTable.getByKey(SYS_SEQUENCE));
          if (seq == null || seq <= curSeq) {
            seq = curSeq + 1;
            for (let j = 0, jlen = bkmk.size(); j < jlen; j++) {
              dataTable.setByBkmk(bkmk.getAt(j).getBookmark());
              dataTable.set(seqIndex, seq);
            }
          } else {
            break;
          }
          curSeq = seq;
        } else {
          dataTable.setByBkmk(bkmk.getBookmark());
          let seq = parseInt(dataTable.getByKey(SYS_SEQUENCE));
          if (seq == null || seq <= curSeq) {
            seq = curSeq + 1;
            dataTable.set(seqIndex, seq);
          } else {
            break;
          }
          curSeq = seq;
        }
      }
    }
    await this.setSeqInGridFromDtl(grid);
  }
  static dependValueChange(grid, target, depend) {
    var form = grid.getForm();
    var loc = form.getCellLocation(target);
    if (loc) {
      if (loc.row == null || loc.row == -1) {
        return grid.getDatas().reduce(async (prev, row, index) => {
          await prev;
          if (row.rowType == "Detail") {
            return depValChanged$2(form, grid, loc, index, depend, !!row.bkmkRow);
          }
        }, true);
      } else {
        return depValChanged$2(form, grid, loc, loc.row, depend, true);
      }
    } else {
      return grid.load(true);
    }
  }
  static dependCellValueChange(grid, rowIndex, target, depend) {
    var form = grid.getForm();
    var loc = form.getCellLocation(target);
    return depValChanged$2(form, grid, loc, rowIndex, depend, true);
  }
  // 使界面中DBColumnName为“Sequence”的组件显示DataTable中Sequence的值
  static async setSeqInGridFromDtl(grid, fromIndex, endIndex) {
    const form = grid.getForm(), SYS_SEQUENCE = SystemField.SEQUENCE_FIELD_KEY, dataTable = form.getDocument().getByKey(grid.tableKey), seqIndex = dataTable.indexByKey(SYS_SEQUENCE);
    if (seqIndex === null) {
      return;
    }
    const cell = grid.getMetaCellByColumnKey(SYS_SEQUENCE);
    if (!cell) {
      return;
    }
    let data2 = grid.getAllData();
    fromIndex = fromIndex || 0;
    endIndex = endIndex || data2.length - 1;
    for (let i2 = fromIndex; i2 <= endIndex; i2++) {
      let row = data2[i2], bkmk = row.bkmkRow;
      if (bkmk == null)
        continue;
      if (grid.hasColumnExpand()) {
        dataTable.setByBkmk(bkmk.getAt(0).getBookmark());
      } else {
        dataTable.setByBkmk(bkmk.getBookmark());
      }
      let seqValue = dataTable.get(seqIndex);
      let view_index = grid.getRowIndexByID(row.rowId);
      if (view_index != null) {
        await grid.setValueByKey(view_index, cell.key, seqValue, false, false, false);
      } else {
        await grid.setAllValueByKey(i2, cell.key, seqValue, false, false, false);
      }
    }
  }
  static addGridRow(grid) {
  }
  static editGridRow(grid) {
    var form = grid.getForm();
    var rowIndex = grid.getFocusRowIndex();
    if (rowIndex == -1) {
      var dialog = DialogFactory.create({
        msgType: DialogType.DEFAULT,
        msg: I18N.getString("NEED_SELECT_ROW", "请选选中行")
      });
      return dialog.show();
    }
    var formKey = grid.editRowFormKey;
    if (!formKey || !grid.hasDetailRow)
      return;
    return ModalCallbackUtil.processCallParas(form, {}, null, () => {
      let builder = new FormBuilder(formKey);
      let modalContainer = new ModalContainer();
      builder.setExContainer(modalContainer);
      builder.setParentForm(form);
      builder.setTarget(FormTarget.MODAL);
      return builder.newEmpty().then((editForm) => {
        GridUtil.copyAttrs(grid, editForm);
        FormParasUtil.processCallParas(form, editForm);
        return builder.build(editForm);
      });
    });
  }
  static checkError(grid) {
    var checkRowError = function(ri2) {
      var rowData = grid.getRowDataAt(ri2);
      if (!rowData) {
        return;
      }
      if (!rowData.isFix && !rowData.isDetail)
        return;
      if (rowData.isDetail && !rowData.bkmkRow)
        return;
      let exception2;
      for (var ci = 0, length2 = rowData.data.length; ci < length2; ci++) {
        var cell = rowData.data[ci];
        if (cell.error) {
          exception2 = GRID_CELL_ERROR(grid.caption, ri2 + 1, cell.meta.caption, cell.errMsg);
        } else if (cell.required) {
          exception2 = GRID_CELL_REQUIRED(grid.caption, ri2 + 1, cell.meta.caption);
        } else if (cell.infinity) {
          exception2 = GRID_CELL_INFINITY(grid.caption, ri2 + 1, cell.meta.caption);
        }
        if (exception2) {
          return exception2.setSourceComponent({ key: grid.key, ri: ri2, ci, cellError: true });
        }
      }
      if (rowData.error.isError()) {
        return GRID_ROW_ERROR(grid.caption, ri2 + 1, rowData.error.getErrorMsg()).setSourceComponent({ key: grid.key, ri: ri2, rowError: true });
      }
      return exception2;
    };
    var focusRowIndex = grid.getFocusRowIndex();
    let exception;
    if (focusRowIndex !== -1) {
      exception = checkRowError(focusRowIndex);
      if (typeof exception !== "undefined" && exception !== null) {
        return exception;
      }
    }
    for (var ri = 0, size2 = grid.getRowCount(); ri < size2; ri++) {
      if (ri === focusRowIndex) {
        continue;
      }
      exception = checkRowError(ri);
      if (typeof exception !== "undefined" && exception !== null) {
        return exception;
      }
    }
  }
  static locateCellError(grid, rowIndex, colIndex, rowData, cellData) {
    rowData = rowData || grid.getRowDataAt(rowIndex);
    cellData = cellData || (rowData == null ? void 0 : rowData.data[colIndex]);
    if (!cellData)
      return;
    let column = grid.getColumnAt(colIndex);
    if (!column.visible && (cellData.error || cellData.required)) {
      if (cellData.error) {
        grid.setRowError(rowIndex, true, cellData.errMsg, cellData.key);
      }
      if (cellData.required) {
        grid.setRowError(rowIndex, true, cellData.caption + " " + I18N.getString("CONTROL_REQUIRED", "-必须填写-"), cellData.key);
      }
    } else {
      if (rowData.error.hasError(cellData.key)) {
        grid.setRowError(rowIndex, false, null, cellData.key);
      }
    }
  }
}
__decorateClass$a([
  CompEventListener()
], GridHandler, "doOnCellClick", 1);
class HyperLinkTarget {
}
HyperLinkTarget.NEW = "_blank";
HyperLinkTarget.NEWTAB = "_blank";
HyperLinkTarget.CURRENT = "_self";
class HyperLinkShowType {
}
HyperLinkShowType.NEW = 0;
HyperLinkShowType.STR_NEW = "New";
HyperLinkShowType.NEWTAB = 1;
HyperLinkShowType.STR_NEWTAB = "NewTab";
HyperLinkShowType.CURRENT = 2;
HyperLinkShowType.STR_CURRENT = "Current";
var __defProp$9 = Object.defineProperty;
var __getOwnPropDesc$9 = Object.getOwnPropertyDescriptor;
var __decorateClass$9 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$9(target, key) : target;
  for (var i2 = decorators.length - 1, decorator; i2 >= 0; i2--)
    if (decorator = decorators[i2])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$9(target, key, result);
  return result;
};
class HyperLinkHandler extends BaseHandler {
  static resolveURL(hlk, loc) {
    var resolve2 = async function() {
      if (hlk.formulaURL) {
        var form = hlk.getForm(), cxt;
        if (loc) {
          cxt = new ViewContext(form);
          cxt.updateLocation(loc.getKey(), loc.getRow(), -1);
        }
        return await form.asyncEval(hlk.formulaURL, cxt);
      }
      return hlk.url;
    };
    return resolve2();
  }
  static openURL(hlk, url) {
    if (url.indexOf("http:") != 0 && url.indexOf("https:") != 0) {
      url = "http://" + url;
    }
    if (InterActiveFactory && InterActiveFactory.Interactive.canInteractive()) {
      return InterActiveFactory.Interactive.openURL(url);
    }
    switch (hlk.targetType) {
      case HyperLinkShowType.NEW:
        window.open(url, HyperLinkTarget.NEW, "alwaysRaised=yes");
        break;
      case HyperLinkShowType.NEWTAB:
        window.open(url);
        break;
      case HyperLinkShowType.CURRENT:
        window.open(url, HyperLinkTarget.CURRENT);
        break;
    }
  }
  static doOnClick(hlk, formula) {
    return hlk.getForm().asyncEval(formula);
  }
}
__decorateClass$9([
  CompEventListener()
], HyperLinkHandler, "doOnClick", 1);
const ImageTypes = Object.freeze(["gif", "jpg", "jpeg", "png", "bmp"]);
var __defProp$8 = Object.defineProperty;
var __getOwnPropDesc$8 = Object.getOwnPropertyDescriptor;
var __decorateClass$8 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$8(target, key) : target;
  for (var i2 = decorators.length - 1, decorator; i2 >= 0; i2--)
    if (decorator = decorators[i2])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$8(target, key, result);
  return result;
};
class ImageHandler extends BaseHandler {
  static uploadImage(control, $file, params) {
    var form = control.getForm();
    var info = FileUtil.checkFile({
      maxSize: control.maxSize,
      types: ImageTypes,
      file: $file
    });
    var params = Object.assign({
      file: $file,
      imgType: info.prefix,
      fileName: info.fileName
    }, params);
    return new RemoteService().uploadImage(form.formKey, form.getOID(), params);
  }
  static deleteImg(control, filePath) {
    return new RemoteService().deleteImage(control.getForm().formKey, filePath);
  }
  static downloadImg(control, filePath) {
    var form = control.getForm();
    var options2 = {
      formKey: form.formKey,
      mode: 1,
      path: filePath,
      provider: "",
      service: "DownloadAttachment",
      tableKey: form.mainTableKey || form.formKey
    };
    FileUtil.downLoadFile(options2);
  }
  static downloadURLImg(control, url) {
    var type = "";
    var filename = "";
    const reg = /^data:image\/(jpeg|png|gif);base64,/;
    if (reg.test(url)) {
      type = url.match(/:(.*?);/)[1];
    }
    const img = document.createElement("img");
    img.setAttribute("crossOrigin", "anonymous");
    img.src = url;
    img.onload = function(e) {
      const canvas = document.createElement("canvas");
      canvas.width = img.width;
      canvas.height = img.height;
      const context = canvas.getContext("2d");
      context.drawImage(img, 0, 0, img.width, img.height);
      canvas.getContext("2d").drawImage(img, 0, 0, img.width, img.height);
      canvas.toBlob((blob) => {
        const link = document.createElement("a");
        link.href = window.URL.createObjectURL(blob);
        link.download = filename;
        link.click();
      }, type);
    };
  }
  static doOnClick(formID2, formula, ...args) {
    return super.doOnClick(formID2, formula, ...args);
  }
}
__decorateClass$8([
  CompEventListener()
], ImageHandler, "doOnClick", 1);
let MapDrawType$1 = class MapDrawType {
};
MapDrawType$1.CURRENTPAGE = 0;
MapDrawType$1.STR_CURRENTPAGE = "CURRENTPAGE";
MapDrawType$1.ALLPAGES = 1;
MapDrawType$1.STR_ALLPAGES = "ALLPAGES";
class ListViewHandler extends Utils.mix(BaseHandler, PageHandler, SelectHandler) {
  /**
   * 处理值变化的后续逻辑
   */
  static async doValueChanged(listView, rowIndex, colIndex, value, commitValue, editing, fireEvent) {
    var self = this, form = listView.getForm(), column = listView.columns[colIndex], monitor = form.getViewDataMonitor();
    if (commitValue) {
      await self.setValueToDocument(listView, rowIndex, colIndex, value);
    }
    await monitor.preCellValueChanged(listView, rowIndex, colIndex, column);
    if (editing) {
      await monitor.cellValueChanged(listView, rowIndex, colIndex, column);
    }
    return monitor.postCellValueChanged(listView, rowIndex, colIndex, column);
  }
  static flushRow(...args) {
  }
  static setValueToDocument(listView, rowIndex, colIndex, value) {
    var column = listView.getColumn(colIndex);
    var columnKey = column.columnKey;
    if (!columnKey)
      return;
    var rowData = listView.getRowDataAt(rowIndex);
    var bkmkRow = rowData.bkmkRow;
    var doc = listView.getForm().getDocument();
    var table = doc.getByKey(listView.tableKey);
    if (bkmkRow) {
      table.setByBkmk(rowData.bkmkRow.getBookmark());
      this.setValueToDataTable(table, column, value);
    } else {
      bkmkRow = this.flushRow(listView, table, rowIndex);
      rowData.setBkmkRow(bkmkRow);
    }
    var shadowTbl = doc.getShadow(listView.tableKey);
    if (!shadowTbl)
      return;
    var bookmark = ViewUtil.findShadowBkmk(doc, listView.tableKey);
    if (bookmark != -1) {
      shadowTbl.setByKey(columnKey, table.getByKey(columnKey));
    } else {
      ViewUtil.addShadowRow(table, shadowTbl);
    }
  }
  static setValueToDataTable(table, column, newValue) {
    var columnKey = column.columnKey;
    var cellType = column.type;
    switch (cellType) {
      case ControlType.DYNAMICDICT:
      case ControlType.DICT:
        var prop = column.properties;
        if (newValue == null) {
          if (prop.multiSelect) {
            table.setByKey(columnKey, null);
          } else {
            table.setByKey(columnKey, 0);
          }
          break;
        }
        if (prop.multiSelect) {
          var oids = [], itemKey = "";
          for (var i2 = 0, len = newValue.length; i2 < len; i2++) {
            oids.push(newValue[i2].oid);
            oids.push(",");
          }
          if (oids && oids.length > 0) {
            oids.pop();
            itemKey = newValue[0].itemKey;
          }
          table.setByKey(columnKey, oids.join(""));
          if (cellType == ControlType.DYNAMICDICT) {
            table.setByKey(columnKey + "ItemKey", itemKey);
          }
        } else {
          table.setByKey(columnKey, newValue.oid);
          if (cellType == ControlType.DYNAMICDICT || cellType == ControlType.COMPDICT) {
            table.setByKey(columnKey + "ItemKey", newValue.itemKey);
          }
        }
        break;
      default:
        var tableColumn = table.getColByKey(columnKey);
        var val = HandlerProvider.get().convertValue(newValue, tableColumn.type);
        table.setByKey(columnKey, val);
        break;
    }
  }
  /**
   * ListView行点击
   */
  static async doOnRowClick(listView, rowIndex) {
    var form = listView.getForm(), rowClick = listView.rowClick, ret, cxt;
    if (rowClick) {
      try {
        LoadingUtil.show();
        cxt = new ViewContext(form);
        cxt.updateLocation(listView.key, rowIndex, -1);
        ret = await form.asyncEval(rowClick, cxt);
      } finally {
        LoadingUtil.hide();
      }
    }
    var oldRowIndex = listView.getOldFocusRowIndex();
    if (rowIndex != oldRowIndex) {
      await form.getUIProcess().doAfterRowChanged(listView);
      var focusRowChanged = listView.focusRowChanged;
      var rowChanged = listView.rowChanged;
      if (rowChanged && focusRowChanged) {
        try {
          LoadingUtil.show();
          cxt = cxt || new ViewContext(form);
          cxt.updateLocation(listView.key, rowIndex, -1);
          return await form.asyncEval(focusRowChanged, cxt);
        } finally {
          LoadingUtil.hide();
        }
      }
    }
  }
  /**
   * ListView行双击
   */
  static async doOnRowDblClick(listView, rowIndex) {
    var rowDblClick = listView.rowDblClick;
    if (rowDblClick) {
      try {
        LoadingUtil.show();
        var form = listView.getForm();
        var cxt = new ViewContext(form);
        cxt.updateLocation(listView.key, rowIndex, -1);
        return await form.asyncEval(rowDblClick, cxt);
      } finally {
        LoadingUtil.hide();
      }
    }
  }
  /**
   * ListView焦点切换
   */
  static async doOnRowChanged(listView, rowIndex) {
    var focusRowChanged = listView.focusRowChanged;
    if (focusRowChanged) {
      try {
        LoadingUtil.show();
        var form = listView.getForm();
        var cxt = new ViewContext(form);
        cxt.updateLocation(listView.key, rowIndex, -1);
        return await form.asyncEval(focusRowChanged, cxt);
      } finally {
        LoadingUtil.hide();
      }
    }
  }
  /**
   * 控件点击
   */
  static async doOnCellClick(listView, rowIndex, colIndex) {
    var form = listView.getForm();
    var column = listView.columns[colIndex];
    var p2 = column.properties, url = p2.url;
    if (p2.formulaURL) {
      url = await form.asyncEval(p2.formulaURL);
    }
    if (url) {
      if (p2.targetType == HyperLinkShowType.NEW) {
        window.open(url, HyperLinkTarget.NEW, "alwaysRaised=yes");
      } else if (p2.targetType == HyperLinkShowType.NEWTAB) {
        window.open(url);
      } else if (p2.targetType == HyperLinkShowType.CURRENT) {
        window.open(url, HyperLinkTarget.CURRENT);
      }
    } else {
      if (p2.onClick) {
        var cxt = new ViewContext(form);
        cxt.updateLocation(listView.key, rowIndex);
        return form.asyncEval(p2.onClick, cxt);
      }
    }
  }
  static sort(listView, index, order) {
    var column = listView.columns[index];
    if (listView.sortType == MapDrawType$1.ALLPAGES) {
      var columnKey = column.dataBinding && column.dataBinding.columnKey;
      this.sortColumn(listView, columnKey, order);
    } else {
      listView.data.sort(function(row1, row2) {
        var v1 = row1.data[index].value;
        var v2 = row2.data[index].value;
        if (v1 == null && v2 == null) {
          return 0;
        }
        if (v1 !== null && v2 == null) {
          return order === "asc" ? -1 : 1;
        }
        if (v1 == null && v2 != null) {
          return order === "asc" ? 1 : -1;
        }
        switch (column.columnType) {
          case ControlType.DATEPICKER:
            var d1 = v1.getTime(), d2 = v2.getTime();
            return order === "asc" ? d1 - d2 : d2 - d1;
          case ControlType.DICT:
            var o1 = typeof v1.getOID == "function" ? v1.getOID() : v1, o2 = typeof v2.getOID == "function" ? v2.getOID() : v2;
            return order === "asc" ? o1 - o2 : o2 - o1;
          case ControlType.NUMBEREDITOR:
            return order === "asc" ? v1 - v2 : v2 - v1;
          default:
            var s1 = v1 + "", s2 = v2 + "";
            return order === "asc" ? s1.localeCompare(s2) : s2.localeCompare(s1);
        }
      });
      listView.repaintRows();
    }
  }
  static sortColumn(control, columnKey, order) {
    var tableKey = control.tableKey, form = control.getForm();
    var filterMap = form.getFilterMap();
    var asc = true;
    if (order == "desc") {
      asc = false;
    }
    if (control.pageLoadType == PageLoadType.UI) {
      var document2 = form.getDocument();
      var dataTable = document2.getByKey(tableKey);
      dataTable.clearCriteria();
      dataTable.setSort(columnKey, asc);
      dataTable.sort();
      document2.setByKey(tableKey, dataTable);
      control.load();
    } else {
      filterMap.getTblFilter(tableKey).addOrderField(columnKey, asc);
      return new DocService(form).loadFormData(form).then((doc) => {
        var document22 = form.getDocument();
        var dataTable2 = doc == null ? void 0 : doc.getByKey(tableKey);
        document22.setByKey(tableKey, dataTable2);
        return control.load();
      });
    }
  }
  static showDetailRow(form, listView, rowIndex) {
    var document2 = form.getDocument();
    var tableKey = listView.tableKey;
    if (!tableKey)
      return;
    var table = document2.getByKey(tableKey);
    var row = listView.getRowDataAt(rowIndex);
    table.setByBkmk(row.bkmkRow.getBookmark());
    listView.columns.forEach((column, col) => {
      var value = null;
      if (column.columnKey) {
        value = table.getByKey(column.columnKey);
      } else if (column.isSelect) {
        if (listView.pageLoadType == PageLoadType.DB) {
          if (ViewUtil.findShadowBkmk(document2, listView.tableKey) != -1) {
            value = true;
          }
        } else {
          value = table.getByKey(SystemField.SELECT_FIELD_KEY);
        }
      } else {
        if (column.columnType == ControlType.HYPERLINK || column.columnType == ControlType.BUTTON || column.columnType == ControlType.LABEL) {
          value = column.caption;
        }
      }
      listView.__setValueAt(rowIndex, col, value);
    });
  }
  static doSelectMulti(...args) {
  }
  static doOnChkClick(listView, rowIndex, colIndex, value, shiftDown) {
    var column = listView.columns[colIndex];
    if (shiftDown && !column.singleSelect) {
      var focusIndex = listView.getFocusRowIndex();
      focusIndex = focusIndex == -1 ? rowIndex : focusIndex;
      var start = Math.min(focusIndex, rowIndex);
      var end = Math.max(focusIndex, rowIndex);
      return this.doSelectMulti(listView, start, end + 1, colIndex, value);
    } else {
      return listView.setValueAt(rowIndex, colIndex, value, true);
    }
  }
  /**
   * 删除ListView数据行
   */
  static deleteData(listView, rowData) {
    var form = listView.getForm();
    var doc = form.getDocument(), tableKey = listView.tableKey;
    var shadowTbl = doc.getShadow(tableKey);
    var table = doc.getByKey(tableKey);
    table.setByBkmk(rowData.bkmkRow.getBookmark());
    if (shadowTbl) {
      var bookmark = ViewUtil.findShadowBkmk(doc, tableKey);
      if (bookmark != -1) {
        shadowTbl.setState(DataDef.R_New);
        shadowTbl.delRow();
        listView.selectCount--;
      }
    } else {
      var index = table.indexByKey(SystemField.SELECT_FIELD_KEY);
      if (index != null) {
        var selValue = table.get(index);
        if (selValue) {
          listView.selectCount--;
        }
      }
    }
    table.delRow();
  }
  /**
   * 新增行事件
   */
  static rowInsert(listView, rowIndex) {
    var form = listView.getForm();
    return form.getUIProcess().doCalcOneRow(listView, rowIndex);
  }
  /**
   * 删除行事件
   */
  static rowDelete(listView, rowIndex) {
    var form = listView.getForm();
    return form.getUIProcess().doPostDeleteRow(listView);
  }
}
var setItem = function(control, sorce, key, title, image, groupValue, groupCaption) {
  var pobj = {
    title,
    key,
    image,
    groupValue: groupValue || "group-md1",
    groupCaption,
    userID: SessionInfo.getUserID()
  };
  if (image) {
    control.showImage = true;
  }
  if (sorce) {
    control.moduleDataObj[key] = pobj;
  } else {
    control.dataObj[key] = pobj;
  }
  return pobj;
};
var getDataItems$2 = function(form, meta, cxt, sorce, control) {
  var items = [];
  var document2 = form.getDocument();
  var tableKey = sorce ? meta.sourceTableKey : meta.tableKey;
  var table = document2.getByKey(tableKey);
  if (!table)
    return items;
  table.beforeFirst();
  while (table.next()) {
    var key = table.getByKey("key");
    var title = table.getByKey("caption");
    var image = table.getByKey("image");
    var groupValue = table.getByKey("groupValue");
    var groupCaption = table.getByKey("groupCaption");
    var userID = table.getByKey("userID");
    var needdata = sorce ? true : userID == SessionInfo.getUserID() ? true : false;
    if (key && needdata) {
      items.push(setItem(control, sorce, key, title, image, groupValue, groupCaption));
    }
  }
  return items;
};
var getFormulaItems$2 = function(form, prop, cxt, sorce, control) {
  return new Promise((resolve2, reject) => {
    var items = [];
    if (prop.formulaItems) {
      form.asyncEval(prop.formulaItems, cxt).then(function(rs) {
        if (typeof rs === "string") {
          var item_Arr = rs.split(";");
          for (var i2 = 0, len = item_Arr.length; i2 < len; i2++) {
            var item_obj = item_Arr[i2].split(",");
            var key = item_obj[0], caption = item_obj[1], image = item_obj[2], groupValue = item_obj[3], groupCaption = item_obj[4];
            if (key) {
              items.push(setItem(control, sorce, key, caption, image, groupValue, groupCaption));
            }
          }
          resolve2(items);
        } else if (rs instanceof DataTable) {
          rs.beforeFirst();
          if (rs.cols.length > 0) {
            while (rs.next()) {
              let key2 = rs.getByKey("key"), caption2 = rs.getByKey("caption"), image2 = rs.getByKey("image"), groupValue2 = rs.getByKey("groupValue"), groupCaption2 = rs.getByKey("groupCaption");
              if (key2) {
                items.push(setItem(control, sorce, key2, caption2, image2, groupValue2, groupCaption2));
              }
            }
            resolve2(items);
          }
        } else if (Utils.isArray(rs)) {
          for (let i22 = 0, len2 = rs.length; i22 < len2; i22++) {
            let key2 = rs[i22].Key, caption2 = rs[i22].Caption, image2 = rs[i22].Image, groupValue2 = rs[i22].GroupValue, groupCaption2 = rs[i22].GroupCaption;
            if (key2) {
              items.push(setItem(control, sorce, key2, caption2, image2, groupValue2, groupCaption2));
            }
          }
          resolve2(items);
        } else {
          resolve2(items);
        }
      });
    } else {
      resolve2(items);
    }
  });
};
class ModuleEditorHandler extends BaseHandler {
  //获取下拉框的值
  static getItems(control, sorce, loc) {
    var form = control.getForm();
    let meta = control.getMetaObj();
    var sourceType = meta.sourceType;
    var cxt;
    if (loc) {
      cxt = new ViewContext(form);
      cxt.updateLocation(loc.getKey(), loc.getRow(), -1);
    }
    if (sourceType == ComboboxSourceType.FORMULA) {
      return getFormulaItems$2(form, meta, cxt, sorce, control);
    } else if (sourceType == ComboboxSourceType.QUERY) {
      return getDataItems$2(form, meta, cxt, sorce, control);
    } else {
      return new Promise((resolve2, reject) => {
        var items2 = [];
        if (meta.items && meta.items.length > 0) {
          for (var i2 = 0, len = meta.items.length; i2 < len; i2++) {
            var key = meta.items[i2].key, caption = meta.items[i2].caption, image = meta.items[i2].image, groupValue = meta.items[i2].groupValue, groupCaption = meta.items[i2].groupCaption;
            if (key) {
              items2.push(setItem(control, sorce, key, caption, image, groupValue, groupCaption));
            }
          }
        }
        resolve2(items2);
      });
    }
  }
  static clearDataTable(control) {
    var form = control.getForm();
    var document2 = form.getDocument();
    var tableKey = control.tableKey;
    if (!tableKey) {
      return;
    }
    var table = document2.getByKey(tableKey);
    if (!table)
      return;
    table.delAll();
  }
  static addDataTable(control, newItems) {
    var form = control.getForm();
    var document2 = form.getDocument();
    var tableKey = control.tableKey;
    if (!tableKey) {
      return;
    }
    var table = document2.getByKey(tableKey);
    if (!table)
      return;
    for (let i2 = 0; i2 < newItems.length; i2++) {
      var item = newItems[i2];
      table.addRow(true);
      table.setByKey("key", item.key);
      table.setByKey("caption", item.title);
      table.setByKey("image", item.image);
      table.setByKey("groupValue", item.groupValue);
      table.setByKey("groupCaption", item.groupCaption);
      table.setByKey("userID", SessionInfo.getUserID());
    }
  }
}
var __defProp$7 = Object.defineProperty;
var __getOwnPropDesc$7 = Object.getOwnPropertyDescriptor;
var __decorateClass$7 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$7(target, key) : target;
  for (var i2 = decorators.length - 1, decorator; i2 >= 0; i2--)
    if (decorator = decorators[i2])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$7(target, key, result);
  return result;
};
class MultiStateButtonHandler extends BaseHandler {
  static doOnClick(btn, formula, key, eventTarget) {
    var form = btn.getForm();
    var click = function() {
      var key2 = btn.key;
      HeadInfoUtil.put(btn, HeadInfoOptType.STR_BUTTON, form.formID);
      if (form.getEvent(key2)) {
        try {
          return form.doEvent(key2);
        } finally {
          HeadInfoUtil.clear();
        }
      } else {
        var cxt = new ViewContext(form);
        eventTarget && (cxt.eventTarget = eventTarget);
        return form.asyncEval(formula, cxt).then((ret) => {
          return ret;
        }).finally(() => {
          HeadInfoUtil.clear();
        });
      }
    };
    return click();
  }
  static getShowIndex(items, value) {
    var item;
    for (var i2 = 0; i2 < items.length; i2++) {
      item = items[i2];
      if (item.value == value) {
        return i2;
      }
    }
  }
}
__decorateClass$7([
  CompEventListener()
], MultiStateButtonHandler, "doOnClick", 1);
const _operation = (items, operationkey) => {
  let item;
  for (var i2 = 0; i2 < items.length; i2++) {
    if (items[i2].key == operationkey) {
      item = items[i2];
      break;
    }
    if (items[i2].items) {
      _operation(items[i2].items, operationkey);
    }
  }
  if (item) {
    return item;
  }
};
class NavigationBarHandler extends BaseHandler {
  static doActionClick(nav, operationkey) {
    var _item = _operation(nav.items, operationkey);
    var form = nav.getForm();
    var cxt = new ViewContext(form);
    return form.asyncEval(_item.action, cxt).then(() => {
      var formId = nav.ofFormID;
      var _form = FormStack.getForm(formId);
      return _form && _form.addOperation();
    }).finally(() => {
      HeadInfoUtil.clear();
    });
  }
  static rightBtnClick(nav, content) {
    var form = nav.getForm();
    var cxt = new ViewContext(form);
    return form.asyncEval(content, cxt);
  }
  static leftBtnClick(nav, content) {
    var form = nav.getForm();
    var cxt = new ViewContext(form);
    return form.asyncEval(content, cxt);
  }
  static doLeftBackBtn(nav) {
    var form = nav.getForm();
    form && form.fireClose();
  }
}
class NumberEditorHandler extends BaseHandler {
  static doOnFocus(number, focus) {
    return number.getForm().asyncEval(focus);
  }
  static doTextChanged(number, textChanged) {
    return number.getForm().asyncEval(textChanged);
  }
}
class ProgressIndicatorType {
}
ProgressIndicatorType.ITEMS = 0;
ProgressIndicatorType.DATA = 1;
var cache$b = new LRUCache(20);
var getDataItems$1 = function(form, prop) {
  return new Promise((resolve2, reject) => {
    var items = [];
    var document2 = form.getDocument();
    var table = document2.getByKey(prop.tableKey);
    if (!table)
      return;
    table.beforeFirst();
    while (table.next()) {
      var pobj = {};
      var title = table.getByKey(prop.titleColumnKey);
      var message = table.getByKey(prop.messageColumnKey);
      var dateTime = table.getByKey(prop.dateTimeColumnKey);
      pobj.key = prop.tableKey;
      pobj.caption = title;
      pobj.message = message;
      pobj.dateTime = dateTime;
      items.push(pobj);
    }
    resolve2(items);
  });
};
class ProgressIndicatorHandler extends BaseHandler {
  static getItems(control, prop, loc) {
    return new Promise((resolve2, reject) => {
      var form = control.getForm();
      var sourceType = prop.sourceType;
      var cxt;
      if (loc) {
        cxt = new ViewContext(form);
        cxt.updateLocation(loc.getKey(), loc.getRow(), -1);
      }
      if (sourceType == ProgressIndicatorType.DATA) {
        getDataItems$1(form, prop).then(function(items) {
          var cacheKey;
          if (prop.cache && cacheKey) {
            cache$b.set(cacheKey, items);
          }
          resolve2(items);
        });
      } else {
        resolve2(prop.items);
      }
    });
  }
}
var __defProp$6 = Object.defineProperty;
var __getOwnPropDesc$6 = Object.getOwnPropertyDescriptor;
var __decorateClass$6 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$6(target, key) : target;
  for (var i2 = decorators.length - 1, decorator; i2 >= 0; i2--)
    if (decorator = decorators[i2])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$6(target, key, result);
  return result;
};
class SplitButtonHandler extends BaseHandler {
  static doOnClick(formID2, formula, ...args) {
    return super.doOnClick(formID2, formula, ...args);
  }
}
__decorateClass$6([
  CompEventListener()
], SplitButtonHandler, "doOnClick", 1);
class TabGroupHandler extends BaseHandler {
  static doOnAction(tabgroup, content) {
    var form = tabgroup.getForm();
    return form.asyncEval(content);
  }
}
class UIDictRelationProcess {
  // 表头控件赋值时刷新code和name值
  static async processComponent(form, component) {
    const controlType = component.type;
    if (!component.columnKey) {
      return;
    }
    if (controlType == ControlType.DICT || controlType == ControlType.DYNAMICDICT || controlType == ControlType.COMPDICT) {
      const value = component.value;
      const tableKey = component.tableKey;
      const dataTable = form.document.getByKey(tableKey);
      if (dataTable.getPos() < 0 || dataTable.size() == 0) {
        return;
      }
      const col = dataTable.getColByKey(component.columnKey, false);
      if (col === null || !col.codeColumnKey) {
        return;
      }
      let codeValue;
      if (value instanceof ItemData && value.getOID() > 0) {
        codeValue = value.useCode || value.code;
        value.name;
        if (!codeValue) {
          const itemKey = value.itemKey;
          let displayCols = component.displayCols;
          if (controlType == ControlType.COMPDICT) {
            displayCols = await new DictService(form).getDisplayCols(itemKey);
          } else if (!displayCols || controlType == ControlType.DYNAMICDICT) {
            displayCols = await component.getDisplayCols();
            component.displayCols = displayCols;
          }
          if (this.hasUseCode(displayCols)) {
            codeValue = await this.getDictUseCode(form, value);
          }
        }
      } else if (!value || value == 0 || value instanceof ItemData && value.getOID() == 0) {
        codeValue = null;
      }
      if (col.codeColumnKey) {
        if (codeValue instanceof Promise) {
          codeValue.then(function(v) {
            if (dataTable.getPos() >= 0 && dataTable.size() > 0) {
              const codeComponent2 = form.getCompByDataBinding(tableKey, col.codeColumnKey);
              if (codeComponent2) {
                codeComponent2.setValue(v, true);
              } else {
                UIDictRelationProcess.setDatatableValue(dataTable, dataTable.getPos(), col.codeColumnKey, v);
              }
            }
          });
        }
        const codeComponent = form.getCompByDataBinding(tableKey, col.codeColumnKey);
        if (codeComponent) {
          codeComponent.setValue(codeValue, true);
        } else {
          UIDictRelationProcess.setDatatableValue(dataTable, dataTable.getPos(), col.codeColumnKey, codeValue);
        }
      }
    }
  }
  static hasUseCode(displayCols) {
    if (!displayCols || displayCols.length == 0) {
      return false;
    }
    for (let j = 0; j < displayCols.length; j++) {
      const displayCol = displayCols[j];
      if ("UseCode" === displayCol.key) {
        return true;
      }
    }
    return false;
  }
  // 表格插行时刷入code和name值
  static async processGridCell4FlushRow(form, grid, table, metaCell, cellData) {
    const controlType = metaCell.cellType;
    if (!metaCell.columnKey) {
      return;
    }
    if (controlType == ControlType.DICT || controlType == ControlType.DYNAMICDICT || controlType == ControlType.COMPDICT) {
      const tableKey = metaCell.tableKey || grid.tableKey;
      const dataTable = form.document.getByKey(tableKey);
      if (dataTable.getPos() < 0 || dataTable.size() == 0) {
        return;
      }
      const col = dataTable.getColByKey(metaCell.columnKey, false);
      if (col === null || !col.codeColumnKey) {
        return;
      }
      let codeValue;
      const itemData = cellData.value;
      if (itemData instanceof ItemData && itemData.getOID() > 0) {
        codeValue = itemData.useCode || itemData.code;
        itemData.name;
      }
      if (col.codeColumnKey && codeValue != void 0) {
        UIDictRelationProcess.setDatatableValue(dataTable, dataTable.getPos(), col.codeColumnKey, codeValue);
      }
    }
  }
  // 单元格赋值时刷新code和name值
  static processGridCell(form, grid, rowIndex, colIndex, cellData, needUpdateTable) {
    if (!form.document) {
      return;
    }
    let rowData = grid.getRowDataAt(rowIndex);
    if (!rowData) {
      return;
    }
    const curCellEditOpt = grid.getCellEditOpt(rowIndex, colIndex);
    if (!curCellEditOpt.columnKey) {
      return;
    }
    const controlType = curCellEditOpt.cellType;
    if (controlType == ControlType.DICT || controlType == ControlType.DYNAMICDICT || controlType == ControlType.COMPDICT) {
      const tableKey = curCellEditOpt.tableKey || grid.tableKey;
      const dataTable = form.document.getByKey(tableKey);
      const oldPos = dataTable.getPos();
      if (rowData.bkmkRow == null || grid.hasColExpand) {
        return;
      }
      dataTable.setByBkmk(rowData.bkmkRow.bookmark);
      if (dataTable.getPos() < 0 || dataTable.size() == 0) {
        return;
      }
      const col = dataTable.getColByKey(curCellEditOpt.columnKey, false);
      if (col === null || !col.codeColumnKey) {
        return;
      }
      const cellValue = cellData.value;
      let codeValue;
      if (cellValue instanceof ItemData && cellValue.getOID() > 0) {
        codeValue = cellValue.useCode || cellValue.code;
        cellValue.name;
      } else if (!cellValue || cellValue == 0 || cellValue instanceof ItemData && cellValue.getOID() == 0) {
        codeValue = null;
      }
      if (col.codeColumnKey) {
        if (codeValue instanceof Promise) {
          const pos = dataTable.getPos();
          codeValue.then((v) => {
            if (dataTable.getPos() >= 0 && dataTable.size() > 0 && dataTable.getPos() < dataTable.size()) {
              this.updateColValue(grid, needUpdateTable, dataTable, pos, rowIndex, rowData, col.codeColumnKey, v);
            }
          });
        } else {
          this.updateColValue(grid, needUpdateTable, dataTable, -1, rowIndex, rowData, col.codeColumnKey, codeValue);
        }
      }
      dataTable.setPos(oldPos);
    }
  }
  static updateColValue(grid, needUpdateTable, dataTable, pos, rowIndex, rowData, columnKey, colValue) {
    if (needUpdateTable) {
      UIDictRelationProcess.setDatatableValue(dataTable, pos > 0 ? pos : dataTable.getPos(), columnKey, colValue);
    }
    const cell = grid.getMetaCellByColumnKey(columnKey);
    if (cell) {
      const colIndex = grid.findIndex(cell.key);
      if (colIndex >= 0) {
        const cellData = rowData.data[colIndex];
        cellData.value = colValue;
        cellData.caption = colValue;
        if (rowIndex >= 0) {
          grid.updateCell(rowIndex, colIndex);
        }
      }
    }
  }
  // 获取字典的UseCode
  static getDictUseCode(form, value) {
    if (value.useCode) {
      return value.useCode;
    }
    const fieldKey = "UseCode";
    const dictService = new DictService(form);
    const item = dictService.getDictValue(value.itemKey, value.getOID(), fieldKey);
    return item;
  }
  static setDatatableValue(table, pos, columnKey, value) {
    const colIndex = table.indexByKey(columnKey, true);
    const orgValue = table.getObject(pos, colIndex);
    const v1 = TypeConvertor.toString(orgValue);
    const v2 = TypeConvertor.toString(value);
    if (v1 == v2) {
      return;
    }
    table.setObject(pos, colIndex, value);
  }
}
var depValChanged$1 = function(form, tableviewrow, loc, rowIndex, depend, fire) {
  return _depChanged$1(form, tableviewrow, rowIndex, loc.column, depend, fire);
};
const _depChanged$1 = async (form, grid, row, col, depend, fire) => {
  const editOpt = grid.getCellEditOpt(row, col);
  const cellData = grid.getCellDataAt(row, col);
  const typeDef = cellData.typeDef;
  let meta;
  if (typeDef) {
    meta = typeDef.editOptions;
  } else {
    meta = editOpt.editOptions;
  }
  if (editOpt.cellType == ControlType.DYNAMIC) {
    const needClean = meta && meta.dependency && meta.dependency.indexOf(depend) != -1;
    if (needClean) {
      await grid.__setValueAtImpl(row, col, null, fire, fire, fire);
    }
    const dependency = editOpt.editOptions.dependency;
    const needRefresh = dependency && dependency.indexOf(depend) != -1;
    if (needRefresh) {
      await grid.getHandler().refreshDynamicOpt(form, grid, row, col, editOpt);
    }
  } else if (editOpt.cellType == ControlType.COMBOBOX || editOpt.cellType == ControlType.CHECKLISTBOX) {
    await combobox_dependedValueChanged(form, grid, row, col, cellData.value, editOpt, fire);
  } else if (editOpt.cellType == ControlType.DICT || editOpt.cellType == ControlType.DYNAMICDICT) {
    await dict_dependedValueChanged$1(form, grid, row, col, cellData.value, editOpt, fire);
  } else {
    await grid.__setValueAtImpl(row, col, null, fire, fire, fire);
  }
};
const dict_dependedValueChanged$1 = async (form, tbview, rowIndex, colkey, value, editOpt, fire) => {
  const cellDataValue = value && Utils.isArray(value) ? value[0] : value;
  if (!cellDataValue || cellDataValue.getOID() <= 0) {
    await tbview.setValueAt(rowIndex, colkey, null, fire, fire, fire);
    return;
  }
  let itemKey = editOpt.editOptions.itemKey;
  const stateMask = editOpt.editOptions.stateMask;
  const cxt = new ViewContext(form);
  cxt.updateLocation(tbview.key, rowIndex, colkey);
  let handler = HandlerProvider.get(ControlType.DICT);
  if (editOpt.cellType == ControlType.DYNAMICDICT) {
    let location2 = new LocationInfo(tbview.key, rowIndex, colkey);
    if (editOpt.editOptions.refDataElementKey) {
      itemKey = await handler.getItemKey(form, editOpt.editOptions.refDataElementKey, location2);
    } else {
      itemKey = await handler.getItemKey(form, editOpt.editOptions.refKey, location2);
    }
  }
  let dictFilter = await handler.getDictFilter(form, editOpt, itemKey);
  let ret = await handler.createRoot(form, itemKey, editOpt.editOptions.root, cxt);
  const item = await new DictService(form).getItemByOID(
    itemKey,
    0,
    10,
    3,
    cellDataValue.getOID(),
    stateMask,
    dictFilter,
    ret.root,
    form.formKey,
    editOpt.key
  );
  if (item && item != null) {
    await tbview.setValueAt(rowIndex, colkey, cellDataValue, fire, fire, fire);
  } else {
    await tbview.setValueAt(rowIndex, colkey, null, fire, fire, fire);
  }
};
const combobox_dependedValueChanged = async (form, grid, row, col, value, editOpt, fire) => {
  let handler = HandlerProvider.get(ControlType.COMBOBOX);
  let loc = new LocationInfo(grid.key, row, col);
  var items = await handler.getItems(form.formID, editOpt.editOptions, loc);
  const cellData = grid.getCellDataAt(row, col);
  value = cellData.value;
  var oldList = [];
  if (value) {
    value = TypeConvertor.toString(value);
    oldList = value.split(",");
  } else {
    return;
  }
  var intersection = items.filter((item) => oldList.includes(TypeConvertor.toString(item.value)));
  if (oldList.length != intersection.length) {
    return grid.setValueAt(row, col, null, fire, fire, fire);
  }
  return grid.setValueAt(row, col, value, fire, fire, fire);
};
var deleteSubDetailData$2 = function(form, table) {
  let bookmark = table.getBkmk();
  if (bookmark == null || bookmark < 0) {
    return;
  }
  var subTables = form.getDocument().getByParentKey(table.key), subTable;
  for (var i2 = 0, size2 = subTables.length; i2 < size2; i2++) {
    subTable = subTables[i2];
    subTable.afterLast();
    while (subTable.previous()) {
      var POID = subTable.getByKey("POID");
      if (POID > 0 && table.getByKey("OID") === POID || subTable.getParentBkmk() == table.getBkmk()) {
        deleteSubDetailData$2(form, subTable);
        subTable.delRow();
      }
    }
  }
};
const setSystemColumIfNull$1 = async function(doc, table, parentTable) {
  const oid = TypeConvertor.toLong(table.getByKey(SystemField.OID_SYS_KEY));
  const soid = TypeConvertor.toLong(table.getByKey(SystemField.SOID_SYS_KEY));
  const poid = TypeConvertor.toLong(table.getByKey(SystemField.POID_SYS_KEY));
  if (oid <= 0) {
    table.setByKey(SystemField.OID_SYS_KEY, await NewOIDCache.applyNewOID());
  }
  if (soid <= 0) {
    table.setByKey(SystemField.SOID_SYS_KEY, doc.oid);
  }
  if (parentTable && poid <= 0) {
    const parentOID = TypeConvertor.toLong(parentTable.getByKey(SystemField.OID_SYS_KEY));
    if (parentOID > 0) {
      table.setByKey(SystemField.POID_SYS_KEY, parentOID);
    }
  }
};
class TableViewHandler extends Utils.mix(BaseHandler, PageHandler, SelectHandler) {
  static doGoToPage(control, currentPage, pageSize = control.pageInfo.pageSize) {
    control.pageInfo.currentPage = currentPage;
    control.pageInfo.pageSize = pageSize;
    if (control.pageLoadType == PageLoadType.UI) {
      return control.load(true, true, true);
    } else {
      var form = control.getForm(), filterMap = form.getFilterMap(), filterType = filterMap.getType(), startRi = (currentPage - 1) * pageSize, tableKey = control.tableKey;
      filterMap.setOID(form.getOID());
      filterMap.setType(DocumentType.DETAIL);
      filterMap.getTblFilter(tableKey).startRow = startRi;
      filterMap.getTblFilter(tableKey).maxRows = pageSize;
      LoadingUtil.show();
      return new DocService(form).loadFormData(form).then(function(newDoc) {
        var doc = form.getDocument(), dataTable = newDoc.getByKey(tableKey), oldTable = doc.getByKey(tableKey);
        if (dataTable.size() > 0) {
          dataTable.beforeFirst();
          while (dataTable.next()) {
            oldTable.addRow(true);
            for (let index = 0; index < oldTable.getColumnCount(); index++) {
              let newValue = dataTable.get(index);
              oldTable.set(index, newValue);
            }
          }
        }
        var startCount = RowCountUtil.getStartRowCount(doc, tableKey);
        RowCountUtil.setStartRowCount(doc, tableKey, startCount);
        var datas = doc.getExpData(DocExpandDataKeys.DICT_CAPTIONS);
        var captionCache = doc.getExpData(DocExpandDataKeys.DICT_CAPTIONS);
        captionCache = captionCache || {};
        Object.assign(captionCache, datas);
        return control.load(true, true, true);
      }).finally(function() {
        filterMap.setType(filterType);
        LoadingUtil.hide();
      });
    }
  }
  static async flushRow(tbview, rowIndex) {
    let form = tbview.getForm();
    let metaRow = tbview.getDetailMetaRow();
    metaRow.cells.forEach((cell, colIndex) => {
      this.setDtlValueToDoc(form, tbview, rowIndex, colIndex);
    });
  }
  static async doOnRowChanged(tbview, rowIndex, oldRowIndex, uiChange) {
    var form = tbview.getForm();
    if (!form) {
      return;
    }
    await form.getUIProcess().doAfterRowChanged(tbview);
    var rowData = tbview.getRowDataAt(rowIndex);
    let subdetails = form.getSubDetail(tbview.key);
    if (subdetails) {
      let contextHook = null;
      if (rowData) {
        contextHook = ((rowData2) => {
          return () => {
            return {
              key: tbview.key,
              rowIndex: tbview.getRowIndex(rowData2)
            };
          };
        })(rowData);
      }
      subdetails.forEach((sub) => sub.contextHook = contextHook);
    }
    if (tbview.hasSubDetail && uiChange) {
      try {
        LoadingUtil.show();
        if (tbview.hasSubDetail) {
          await SubDetailUtil.doChain(form, tbview, true);
        }
      } finally {
        LoadingUtil.hide();
      }
    }
    var rowChanged = rowData.focusRowChanged;
    if (rowChanged) {
      try {
        LoadingUtil.show();
        if (rowChanged) {
          var cxt = new ViewContext(form);
          cxt.updateLocation(tbview.key, rowIndex, -1);
          await form.asyncEval(rowChanged, cxt);
        }
      } finally {
        LoadingUtil.hide();
      }
    }
  }
  static async doOnRowClick(tbview, rowIndex) {
    let rowData = tbview.getRowDataAt(rowIndex);
    if (rowData) {
      let rowClick = rowData.rowClick;
      if (rowClick) {
        let form = tbview.getForm();
        try {
          LoadingUtil.show();
          let frc = new FormRefreshContext();
          frc.addIgnoreGrid(tbview.key);
          form.setRefreshContext(frc);
          let cxt = new ViewContext(form);
          cxt.setGrid(tbview);
          cxt.updateLocation(tbview.key, rowIndex, -1);
          HeadInfoUtil.put(tbview, HeadInfoOptType.STR_RowClick, form.formID);
          await form.asyncEval(rowClick, cxt);
        } finally {
          LoadingUtil.hide();
          form.setRefreshContext(null);
        }
      }
    }
    return;
  }
  static async doOnDblClick(tbview, rowIndex, colIndex) {
    var form = tbview.getForm(), cxt;
    var rowData = tbview.getRowDataAt(rowIndex);
    if (rowData) {
      let rowDblClick = rowData.rowDblClick;
      if (rowDblClick) {
        try {
          LoadingUtil.show();
          cxt = cxt || new ViewContext(form);
          cxt.setGrid(tbview);
          cxt.updateLocation(tbview.key, rowIndex, -1);
          HeadInfoUtil.put(tbview, HeadInfoOptType.STR_RowDblClick, form.formID);
          await form.asyncEval(rowDblClick, cxt);
        } finally {
          LoadingUtil.hide();
        }
      }
    }
  }
  static async doOnExpand(tbview, rowIndex) {
    var form = tbview.getForm(), cxt;
    var rowData = tbview.getRowDataAt(rowIndex);
    if (rowData) {
      let onExpand = rowData.onExpand;
      if (onExpand) {
        try {
          LoadingUtil.show();
          cxt = cxt || new ViewContext(form);
          await form.asyncEval(onExpand, cxt);
        } finally {
          LoadingUtil.hide();
        }
      }
    }
  }
  static async doOnCollapse(tbview, rowIndex) {
    var form = tbview.getForm(), cxt;
    var rowData = tbview.getRowDataAt(rowIndex);
    if (rowData) {
      let onCollapse = rowData.onCollapse;
      if (onCollapse) {
        try {
          LoadingUtil.show();
          cxt = cxt || new ViewContext(form);
          await form.asyncEval(onCollapse, cxt);
        } finally {
          LoadingUtil.hide();
        }
      }
    }
  }
  static async doOnRowActionClick(tbview, rowIndex, actionIndex) {
    var form = tbview.getForm(), cxt;
    var rowData = tbview.getRowDataAt(rowIndex);
    if (rowData) {
      let actionCollection = rowData.actionCollection;
      if (actionCollection) {
        var content = actionCollection[actionIndex].content;
        if (content) {
          try {
            LoadingUtil.show();
            cxt = cxt || new ViewContext(form);
            await form.asyncEval(content, cxt);
          } finally {
            LoadingUtil.hide();
          }
        }
      }
    }
  }
  // 获取当前tablerow总行数
  static getTotalCount(tvRow) {
    var form = tvRow.getForm();
    var doc = form.getDocument();
    if (tvRow.pageLoadType != PageLoadType.DB) {
      return doc.getByKey(tvRow.tableKey).size();
    }
    return RowCountUtil.getTotalRowCount(doc, tvRow.tableKey);
  }
  static async doValueChanged(grid, rowIndex, colIndex, editOpt, newValue, commitValue, editing, fireEvent, curOldValue, ignoreFireCellValueChanged) {
    const form = grid.getForm();
    const monitor = form.getViewDataMonitor();
    let hasFlush = false;
    const rowData = grid.getRowDataAt(rowIndex);
    const isSelectField = grid.selectFieldIndex == colIndex && rowData.rowType === RowType.STR_DETAIL;
    const isEmptyRow = GridUtil.isEmptyRow(rowData);
    const isEmptyRowSelectField = isSelectField && isEmptyRow;
    if (!isEmptyRowSelectField && commitValue) {
      hasFlush = await this.setCellValueToDocument(form, grid, rowIndex, colIndex);
    }
    if (rowData.rowType == RowType.STR_DETAIL) {
      await this.doSelectRow(grid, rowIndex, colIndex, editOpt, newValue);
    }
    let eventDone = false;
    LoadingUtil.show();
    try {
      if (!ignoreFireCellValueChanged) {
        await monitor.preCellValueChanged(grid, rowIndex, colIndex, editOpt);
        if (editing && fireEvent) {
          form.setOldValue(editOpt.key, curOldValue);
          await monitor.cellValueChanged(grid, rowIndex, colIndex, editOpt);
          form.setOldValue(null, null);
        }
        if (grid.hasSubDetail && grid.getFocusRowIndex() == rowIndex && rowData.rowType === RowType.STR_DETAIL) {
          if (hasFlush) {
            await SubDetailUtil.doChain(form, grid, false);
          } else {
            var coms = form.getSubDetail(editOpt.key);
            if (coms) {
              coms.forEach((com) => com.__setValueImpl(newValue));
            }
          }
        }
      }
      if (fireEvent) {
        await this.fireEvent(form, grid, editOpt, rowIndex, hasFlush, newValue);
        await this.processRowStyle(grid, rowIndex);
        eventDone = true;
      }
      await monitor.postCellValueChanged(grid, rowIndex, colIndex, editOpt);
    } catch (e) {
      if (!eventDone && fireEvent) {
        await this.fireEvent(form, grid, editOpt, rowIndex, hasFlush, newValue);
        await this.processRowStyle(grid, rowIndex);
      }
      throw e;
    } finally {
      LoadingUtil.hide();
    }
  }
  static async setCellValueToDocument(form, grid, rowIndex, colIndex) {
    const rowData = grid.getRowDataAt(rowIndex);
    const cellData = rowData.data[colIndex];
    let result;
    switch (rowData.rowType) {
      case RowType.STR_FIXED:
        result = await this.setFixValueToDoc(form, grid, rowIndex, colIndex);
        break;
      case RowType.STR_DETAIL:
        result = await this.setDtlValueToDoc(form, grid, rowIndex, colIndex);
        break;
    }
    UIDictRelationProcess.processGridCell(form, grid, rowIndex, colIndex, cellData, true);
    return result;
  }
  static setFixValueToDoc(form, grid, rowIndex, colIndex) {
    var editOpt = grid.getCellEditOpt(rowIndex, colIndex), cellData = grid.getCellDataAt(rowIndex, colIndex), doc = form.getDocument();
    if (!doc) {
      return;
    }
    var table = doc.getByKey(editOpt.tableKey);
    if (!table) {
      return;
    }
    var bkmkRow = cellData.bkmkRow;
    if (bkmkRow) {
      table.setByBkmk(bkmkRow.getBookmark());
      this.setCellValueToDataTable(form, grid, table, editOpt, cellData);
    } else {
      this.flushFixCell(form, grid, editOpt, rowIndex, colIndex);
    }
  }
  static flushFixCell(form, grid, metaCell, rowIndex, colIndex) {
    var doc = form.getDocument(), table = doc.getByKey(metaCell.tableKey);
    table.addRow(true);
    var bkmkRow = new DetailRowBkmk(table.getBkmk());
    if (grid.hasColumnExpand() || grid.hasRowAreaExpand) {
      var rowData = grid.getRowDataAt(rowIndex), metaRow = rowData.meta, rowDimValue = metaRow.dimValue;
      if (grid.hasRowAreaExpand && rowDimValue) {
        for (var c = 0, length2 = rowDimValue.values.length; c < length2; c++) {
          var node = rowDimValue.values[c];
          table.setByKey(node.columnKey, node.value);
        }
      }
      var startRow = rowIndex;
      var startCol = colIndex;
      if (grid.hasRowAreaExpand && !metaRow.isAreaHead) {
        for (var i2 = rowIndex; i2 >= 0; --i2) {
          var rowData = grid.getRowDataAt(i2);
          var metaRow = rowData.meta;
          if (metaRow.isAreaHead) {
            startRow = i2;
            break;
          }
        }
      } else {
        startRow = rowIndex;
      }
      if (metaCell.isColExpand) {
        for (let i22 = colIndex; i22 >= 0; --i22) {
          metaCell = metaRow.cells[i22];
          var tempKey = metaCell.crossValue;
          if (tempKey == null || !tempKey.equals(crossValue)) {
            break;
          }
          startCol = i22;
        }
      } else {
        startCol = 0;
      }
      var crossValue = metaCell.crossValue;
      if (metaCell.isColExpand) {
        var expInfo = grid.dataModel.expandModel[metaCell.columnArea];
        for (let k = 0, length22 = crossValue.values.length; k < length22; k++) {
          var node = crossValue.values[k];
          var columnKey = expInfo[k];
          if (columnKey) {
            table.setByKey(columnKey, node.value);
          }
        }
      }
      for (let i22 = startRow, size2 = grid.getRowCount(); i22 < size2; i22++) {
        var rowData = grid.getRowDataAt(i22);
        var metaRow = rowData.meta;
        if (metaRow.rowType !== "Fix") {
          break;
        }
        for (let k = startCol, length22 = metaRow.cells.length; k < length22; k++) {
          var metaCell = grid.getCellEditOpt(i22, k);
          if (metaCell.isColExpand && !crossValue.equals(metaCell.crossValue)) {
            break;
          }
          if (metaCell.columnKey) {
            var cellData = rowData.data[k];
            this.setCellValueToDataTable(form, grid, table, metaCell, cellData);
            cellData.bkmkRow = bkmkRow;
          }
        }
        if (grid.hasRowAreaExpand && metaRow.isAreaTail) {
          break;
        }
      }
    } else {
      var dimValue = metaCell.dimValue;
      if (dimValue) {
        for (let i22 = 0, length22 = dimValue.size(); i22 < length22; i22++) {
          var node = dimValue.getValue(i22), value = BaseHandler.convertValue(node.value, node.dataType);
          table.setByKey(node.columnKey, value);
        }
      }
      var cellData = grid.getCellDataAt(rowIndex, colIndex);
      this.setCellValueToDataTable(form, grid, table, metaCell, cellData);
      cellData.bkmkRow = bkmkRow;
    }
  }
  static async setDtlValueToDoc(form, grid, rowIndex, colIndex) {
    const doc = form.getDocument();
    if (doc == null)
      return false;
    const rowData = grid.getRowDataAt(rowIndex);
    const metaRow = rowData.meta;
    const editOpt = metaRow.cells[colIndex];
    if (!editOpt.hasDB)
      return false;
    const cellData = rowData.data[colIndex];
    const newValue = cellData.value;
    const table = doc.getByKey(grid.tableKey);
    let viewRow = rowData.bkmkRow;
    let hasFlush = false;
    if (rowData.rowType === RowType.STR_DETAIL && !viewRow) {
      table.addRow(true);
      rowData.bkmkRow = new DetailRowBkmk(table.getBkmk());
      const dimValue = metaRow.dimValue;
      let dimNode;
      if (dimValue) {
        for (let l = 0, size2 = dimValue.size(); l < size2; l++) {
          dimNode = dimValue.getValue(l);
          table.setByKey(dimNode.getColumnKey(), BaseHandler.convertValue(dimNode.getValue(), dimNode.getDataType()));
        }
      }
      for (let k = 0, len = rowData.data.length; k < len; k++) {
        const metaCell = metaRow.cells[k];
        this.setCellValueToDataTable(form, grid, table, metaCell, rowData.data[k]);
        UIDictRelationProcess.processGridCell4FlushRow(form, grid, table, metaCell, rowData.data[k]);
      }
      let pGrid, parentRow, pTable, pBkmk;
      if (grid.isSubDetail) {
        var parentIndex = grid.contextHook ? grid.contextHook().rowIndex : -1;
        if (parentIndex == -1) {
          return false;
        }
        pGrid = grid.parentGrid;
        parentRow = pGrid.getRowDataAt(parentIndex);
        pTable = form.getDocument().getByKey(pGrid.tableKey);
        pBkmk = parentRow.bkmkRow.getBookmark();
        pTable.setByBkmk(pBkmk);
        table.setParentBkmk(pBkmk);
      }
      await setSystemColumIfNull$1(form.getDocument(), table, pTable);
      this.dealWithSequence(form, grid, rowIndex);
      await this.dealWithSystemField(form, grid, rowIndex);
      await form.getUIProcess().calcPs.calcEmptyRowChildGridsCmd(grid);
      hasFlush = true;
    } else {
      table.setByBkmk(viewRow.getBookmark());
      this.setCellValueToDataTable(form, grid, table, editOpt, cellData);
    }
    const coms = form.getSubDetail(editOpt.key);
    if (coms && grid.getFocusRowIndex() == rowIndex) {
      for (let i2 = 0, len = coms.length; i2 < len; i2++) {
        const tmp = coms[i2];
        const com = Utils.isString(tmp) ? form.getComponent(tmp) : tmp;
        await com.setValue(newValue, false, false);
      }
    }
    return hasFlush;
  }
  /**
      dataTable新增一行后会生成OID，如果Grid行中设置了OID和SOID的显示字段，需要将DataTable系统字段值填到GridRow中
  */
  static async dealWithSystemField(form, grid, rowIndex) {
    const rowData = grid.getRowDataAt(rowIndex);
    const bkmkRow = rowData.bkmkRow;
    if (rowData.rowType === RowType.STR_DETAIL && !bkmkRow) {
      return;
    }
    const table = form.getDocument().getByKey(grid.tableKey);
    if (table.size() == 0) {
      return;
    }
    table.setByBkmk(bkmkRow.getBookmark());
    await this.setSystemFieldInGridFromDtl(grid, rowIndex, table);
  }
  static async setSystemFieldInGridFromDtl(grid, rowIndex, table) {
    let oidIndex = table.indexByKey(SystemField.OID_SYS_KEY);
    if (oidIndex != null) {
      const oid = table.get(oidIndex);
      let colIndex = grid.findIndexByColumnKey(SystemField.OID_SYS_KEY);
      if (colIndex != null) {
        await grid.setValueAt(rowIndex, colIndex, oid, false, false, false, true);
      }
    }
    let soidIndex = table.indexByKey(SystemField.SOID_SYS_KEY);
    if (soidIndex != null) {
      const soid = table.get(soidIndex);
      let colIndex = grid.findIndexByColumnKey(SystemField.SOID_SYS_KEY);
      if (colIndex != null) {
        await grid.setValueAt(rowIndex, colIndex, soid, false, false, false, true);
      }
    }
  }
  static setCellValueToDataTable(form, grid, table, editOpt, cellData) {
    var columnKey = editOpt.columnKey, itemKey = "", dataElementKey = "";
    if (!columnKey)
      return;
    var cellType = editOpt.cellType;
    var newValue = cellData.value;
    switch (cellType) {
      case ControlType.DYNAMICDICT:
      case ControlType.DICT:
        var editOptions = editOpt.editOptions;
        if (newValue == null) {
          if (editOptions.multiSelect || editOptions.isEditValue) {
            table.setByKey(columnKey, null);
          } else {
            table.setByKey(columnKey, 0);
          }
          break;
        }
        if (editOptions.multiSelect) {
          var oids = [], itemKey = "";
          for (var i2 = 0, len = newValue.length; i2 < len; i2++) {
            oids.push(newValue[i2].oid);
            oids.push(",");
          }
          if (oids && oids.length > 0) {
            oids.pop();
            itemKey = newValue[0].itemKey;
          }
          table.setByKey(columnKey, oids.join(""));
          dataElementKey = newValue[0].dataElementKey;
        } else {
          if (!editOptions.isEditValue) {
            table.setByKey(columnKey, newValue.oid);
          } else {
            table.setByKey(columnKey, newValue.editValue);
          }
          itemKey = newValue.itemKey;
          if (cellType == ControlType.COMPDICT) {
            table.setByKey(columnKey + "ItemKey", itemKey);
          }
        }
        if (cellType == ControlType.DYNAMICDICT) {
          if (!dataElementKey) {
            dataElementKey = cellData.dataElementKey;
          }
          let refDataElementKey = editOptions.refDataElementKey;
          if (refDataElementKey) {
            let dataElementCmp = form.getCellLocation(refDataElementKey);
            if (!dataElementCmp) {
              throw COMPONENT_NOT_EXISTS(refDataElementKey);
            }
            refDataElementKey = dataElementCmp.columnKey;
            table.setByKey(refDataElementKey, dataElementKey);
          } else {
            table.setByKey(columnKey + "ItemKey", itemKey);
          }
        }
        break;
      case ControlType.DYNAMIC:
        this.setDynamicCellValueToDataTable(form, grid, table, editOpt, cellData);
        break;
      case ControlType.MONTHPICKER:
        table.setByKey(columnKey, newValue);
        break;
      case ControlType.TIMEPICKER:
        table.setByKey(columnKey, newValue);
        break;
      case ControlType.NUMBEREDITOR:
        var editOptions = editOpt.editOptions;
        if (!editOptions.allowNull) {
          newValue = TypeConvertor.toDecimal(newValue);
        }
        table.setByKey(columnKey, newValue);
        break;
      default:
        table.setByKey(columnKey, BaseHandler.convertValue(newValue, table.getColByKey(columnKey).type));
        break;
    }
  }
  static setDynamicCellValueToDataTable(form, grid, table, editOpt, cellData) {
    var typeDef = cellData.typeDef;
    if (!typeDef) {
      return;
    }
    var curOptions = typeDef.editOptions, typeDefKey = typeDef.key, cellType = typeDef.cellType;
    var columnKey = editOpt.columnKey;
    var newValue = cellData.value;
    if (grid.isNullValue(newValue, cellData)) {
      newValue = null;
      typeDefKey = null;
    }
    switch (cellType) {
      case ControlType.DYNAMICDICT:
      case ControlType.DICT:
        if (curOptions.multiSelect) {
          var oids = [], itemKey = "";
          if (newValue) {
            for (var i2 = 0, len = newValue.length; i2 < len; i2++) {
              oids.push(newValue[i2].oid);
              oids.push(",");
            }
          }
          if (oids && oids.length > 0) {
            oids.pop();
            itemKey = newValue[0].itemKey;
          }
          table.setByKey(columnKey, oids.join(""));
          if (cellType == ControlType.DYNAMICDICT) {
            table.setByKey(columnKey + "ItemKey", itemKey);
          }
        } else {
          var oid = newValue ? newValue.oid : null;
          table.setByKey(columnKey, oid);
          if (cellType == ControlType.DYNAMICDICT || cellType == ControlType.COMPDICT) {
            table.setByKey(columnKey + "ItemKey", newValue.itemKey);
          }
        }
        break;
      case ControlType.DATEPICKER:
        var result = null;
        if (newValue) {
          var format = null;
          if (curOptions.onlyDate) {
            format = "yyyy-MM-dd";
          } else {
            format = "yyyy-MM-dd HH:mm:ss";
          }
          result = newValue.Format(format);
        }
        table.setByKey(columnKey, result);
        break;
      case ControlType.CHECKBOX:
        newValue = TypeConvertor.toInt(newValue);
        table.setByKey(columnKey, TypeConvertor.toString(newValue));
        break;
      default:
        table.setByKey(columnKey, TypeConvertor.toString(newValue));
        break;
    }
    let index = table.indexByKey(columnKey + "TypeDefKey");
    if (index != null) {
      table.setByKey(index, typeDefKey);
    }
  }
  static async processRowStyle(grid, rowIndex) {
    var metaRow = grid.getDetailMetaRow();
    if (metaRow && metaRow.cells) {
      var form = grid.getForm();
      const cxt = new ViewContext(form);
      var metaCells = metaRow.cells, metaCell;
      for (let index = 0; index < metaCells.length; index++) {
        metaCell = metaCells[index];
        if (metaCell.backColor && !metaCell.backColor.startsWith("#")) {
          cxt.updateLocation(grid.key, rowIndex, index);
          var backColor = await form.asyncEval(metaCell.backColor, cxt);
          grid.setCellBackColor(rowIndex, index, backColor);
        }
      }
    }
  }
  static doOnMoreItemClick(tableviewrow) {
    var content = tableviewrow.moreItem.content;
    if (content) {
      var form = tableviewrow.getForm();
      var cxt = new ViewContext(form);
      if (form) {
        return form.asyncEval(content, cxt);
      }
    }
  }
  /**
   * 删除ListView数据行
    */
  static deleteData(tableRow, row, rowIndex) {
    var form = tableRow.getForm();
    var doc = form.getDocument(), tableKey = tableRow.tableKey;
    var table = doc.getByKey(tableKey);
    table.setByBkmk(row.bkmkRow.getBookmark());
    deleteSubDetailData$2(form, table);
    table.delRow();
  }
  static async rowDelete(grid, rowIndex) {
    grid.rowCountChanged(true);
    var form = grid.getForm();
    await form.getUIProcess().doPostDeleteRow(grid, !grid.getMetaObj().onRowDelete, true);
    if (grid.serialSeq) {
      this.dealWithSequence(form, grid, rowIndex);
    }
    var rowDelete = grid.rowDelete;
    if (rowDelete) {
      return form.__eval(rowDelete);
    }
  }
  static async rowInsert(grid, rowIndex) {
    grid.rowCountChanged();
    var row = grid.getRowDataAt(rowIndex);
    if (row.rowType != RowType.STR_DETAIL) {
      return;
    }
    var form = grid.getForm();
    await form.getUIProcess().doCalcOneRow(grid, rowIndex);
    var rowInsert = grid.rowInsert;
    if (rowInsert) {
      var cxt = new ViewContext(form);
      cxt.updateLocation(grid.key, rowIndex, -1);
      return form.__eval(rowInsert, cxt);
    }
  }
  // 刷新动态单元格,加载时,根据数据中的typeDefKey
  static checkError(grid) {
    var checkRowError = function(ri2) {
      var rowData = grid.getRowDataAt(ri2);
      if (!rowData) {
        return;
      }
      if (!rowData.isFix && !rowData.isDetail)
        return;
      if (rowData.isDetail && !rowData.bkmkRow)
        return;
      let exception2;
      for (var ci = 0, length2 = rowData.data.length; ci < length2; ci++) {
        var cell = rowData.data[ci];
        if (cell.error) {
          exception2 = GRID_CELL_ERROR(grid.caption, ri2 + 1, cell.meta.caption, cell.errMsg);
        } else if (cell.required) {
          exception2 = GRID_CELL_REQUIRED(grid.caption, ri2 + 1, cell.meta.caption);
        }
        if (exception2) {
          return exception2.setSourceComponent({ key: grid.key, ri: ri2, ci, cellError: true });
        }
      }
      if (rowData.error.isError()) {
        return GRID_ROW_ERROR(grid.caption, ri2 + 1, rowData.error.getErrorMsg()).setSourceComponent({ key: grid.key, ri: ri2, rowError: true });
      }
      return exception2;
    };
    var focusRowIndex = grid.getFocusRowIndex();
    let exception;
    if (focusRowIndex !== -1) {
      exception = checkRowError(focusRowIndex);
      if (typeof exception !== "undefined" && exception !== null) {
        return exception;
      }
    }
    for (var ri = 0, size2 = grid.getRowCount(); ri < size2; ri++) {
      if (ri === focusRowIndex) {
        continue;
      }
      exception = checkRowError(ri);
      if (typeof exception !== "undefined" && exception !== null) {
        return exception;
      }
    }
  }
  static async doOnFixRowClick(fixrow) {
    var rowClick = fixrow.rowClick;
    if (rowClick) {
      var form = fixrow.getForm();
      var cxt = new ViewContext(form);
      if (form) {
        return await form.asyncEval(rowClick, cxt);
      }
    }
  }
  static doOnFixRowDblClick(fixrow) {
    var rowDblClick = fixrow.rowDblClick;
    if (rowDblClick) {
      var form = fixrow.getForm();
      var cxt = new ViewContext(form);
      if (form) {
        return form.asyncEval(rowDblClick, cxt);
      }
    }
  }
  static dependValueChange(grid, target, depend) {
    var form = grid.getForm();
    var loc = form.getCellLocation(target);
    if (loc) {
      if (loc.row == null || loc.row == -1) {
        return grid.getDatas().reduce(async (prev, row, index) => {
          await prev;
          if (row.rowType == RowType.STR_DETAIL) {
            return depValChanged$1(form, grid, loc, index, depend, !!row.bkmkRow);
          }
        }, true);
      } else {
        return depValChanged$1(form, grid, loc, loc.row, depend, true);
      }
    } else {
      return grid.load(true, true, true);
    }
  }
  static dependCellValueChange(tablerow, rowIndex, target, depend) {
    var form = tablerow.getForm();
    var loc = form.getCellLocation(target);
    return depValChanged$1(form, tablerow, loc, rowIndex, depend, true);
  }
  static async fireEvent(form, tbview, editOpt, rowIndex, newValue) {
    var rowData = tbview.getRowDataAt(rowIndex);
    if (!rowData || rowData.rowType != "Detail") {
      return;
    }
    if (tbview.hasSubDetail && tbview.getFocusRowIndex() == rowIndex) {
      await SubDetailUtil.doChain(form, tbview, false);
    }
  }
  // 增加了对方法setSeqInGridFromDtl的调用
  static dealWithSequence(form, tbview, rowIndex) {
    const SYS_SEQUENCE = SystemField.SEQUENCE_FIELD_KEY;
    const dataTable = form.getDocument().getByKey(tbview.tableKey);
    if (dataTable.size() == 0) {
      return;
    }
    const seqIndex = dataTable.indexByKey(SYS_SEQUENCE);
    if (seqIndex === null) {
      return;
    }
    let curSeq = 0;
    for (let i2 = rowIndex - 1; i2 >= 0; --i2) {
      const row = tbview.dataModel.data[i2];
      if (!row.isDetail || !row.bkmkRow) {
        continue;
      }
      const bkmk = row.bkmkRow;
      if (tbview.hasColumnExpand()) {
        dataTable.setByBkmk(bkmk.getAt(0).getBookmark());
      } else {
        dataTable.setByBkmk(bkmk.getBookmark());
      }
      curSeq = parseInt(dataTable.getByKey(SYS_SEQUENCE));
      break;
    }
    if (tbview.getMetaObj().serialSeq) {
      for (let i2 = rowIndex, len = tbview.dataModel.data.length; i2 < len; i2++) {
        const row = tbview.dataModel.data[i2];
        if (!row.isDetail || !row.bkmkRow)
          continue;
        const bkmk = row.bkmkRow;
        if (tbview.hasColumnExpand()) {
          dataTable.setByBkmk(bkmk.getAt(0).getBookmark());
          const seq = ++curSeq;
          for (let j = 0, jlen = bkmk.size(); j < jlen; j++) {
            dataTable.setByBkmk(bkmk.getAt(j).getBookmark());
            dataTable.set(seqIndex, seq);
          }
        } else {
          dataTable.setByBkmk(bkmk.getBookmark());
          dataTable.set(seqIndex, ++curSeq);
        }
      }
      this.setSeqInGridFromDtl(tbview);
    } else {
      for (let i2 = rowIndex, len = tbview.dataModel.data.length; i2 < len; i2++) {
        const row = tbview.dataModel.data[i2];
        if (!row.isDetail || !row.bkmkRow) {
          continue;
        }
        let seq;
        const bkmk = row.bkmkRow;
        if (tbview.hasColumnExpand()) {
          dataTable.setByBkmk(bkmk.getAt(0).getBookmark());
          seq = parseInt(dataTable.getByKey(SYS_SEQUENCE));
          if (seq == void 0 || seq == null || seq <= curSeq) {
            seq = curSeq + 1;
            for (let j = 0, jlen = bkmk.size(); j < jlen; j++) {
              dataTable.setByBkmk(bkmk.getAt(j).getBookmark());
              dataTable.set(seqIndex, seq);
            }
          } else {
            break;
          }
        } else {
          dataTable.setByBkmk(bkmk.getBookmark());
          seq = parseInt(dataTable.getByKey(SYS_SEQUENCE));
          if (seq == void 0 || seq == null || seq <= curSeq) {
            seq = curSeq + 1;
            dataTable.set(seqIndex, seq);
          } else {
            break;
          }
        }
        curSeq = seq;
      }
    }
  }
  // 使界面中DBColumnName为“Sequence”的组件显示DataTable中Sequence的值
  static setSeqInGridFromDtl(grid) {
    const form = grid.getForm(), SYS_SEQUENCE = SystemField.SEQUENCE_FIELD_KEY, dataTable = form == null ? void 0 : form.getDocument().getByKey(grid.tableKey), seqIndex = dataTable.indexByKey(SYS_SEQUENCE);
    if (seqIndex === null) {
      return;
    }
    const cell = grid.getMetaCellByColumnKey(SYS_SEQUENCE);
    if (!cell) {
      return;
    }
    for (let i2 = 0, len = grid.dataModel.data.length; i2 < len; i2++) {
      const row = grid.dataModel.data[i2];
      let newValue;
      if (dataTable.size() > 0) {
        if (!row.bkmkRow) {
          if (grid.parentGridKey != "") {
            var pGrid = form == null ? void 0 : form.getComponent(grid.parentGridKey);
            const subTables = form == null ? void 0 : form.getDocument().getByParentKey(pGrid.tableKey);
            if ((subTables == null ? void 0 : subTables.length) == 0) {
              newValue = 1;
            } else {
              newValue = dataTable.get(seqIndex) + 1;
            }
          } else {
            newValue = dataTable.get(seqIndex) + 1;
          }
        } else {
          const bkmk = row.bkmkRow;
          if (grid.hasColumnExpand()) {
            dataTable.setByBkmk(bkmk.getAt(0).getBookmark());
            newValue = dataTable.get(SYS_SEQUENCE);
          } else {
            dataTable.setByBkmk(bkmk.getBookmark());
            newValue = dataTable.get(seqIndex);
          }
        }
      } else {
        newValue = 1;
      }
      const cellKey = cell.key;
      grid.setValueByKey(i2, cellKey, newValue, false, false);
    }
  }
  static async showRowData(form, tbview, rowIndex, metaRow, loading = true) {
    let rowData = tbview.getRowDataAt(rowIndex);
    switch (metaRow.rowType) {
      case RowType.STR_FIXED:
        await this.showFixRowData(form, tbview, rowIndex, rowData, metaRow, loading);
        break;
      default:
        if (tbview.editPop && tbview.editPop.focusRowIndex == rowIndex) {
          tbview.editPop.resetRowData(rowData);
        }
        await this.showDetailRowData(form, tbview, rowIndex, rowData, metaRow, loading);
        break;
    }
  }
  static async showDetailRowData(form, tbview, rowIndex, rowData, metaRow, loading = true) {
    var doc = form.getDocument();
    if (doc == null)
      return;
    var dataTable = doc.getByKey(tbview.tableKey);
    if (dataTable == null || rowData == null)
      return;
    var rowbkmk = rowData.bkmkRow, firstRow = rowbkmk;
    if (rowbkmk.getRowType() == BkmkType.Expand) {
      firstRow = rowbkmk.getAt(0);
    }
    dataTable.setByBkmk(firstRow.getBookmark());
    let metaCell, cellData, columnKey;
    for (var i2 = 0, length2 = metaRow.cells.length; i2 < length2; i2++) {
      metaCell = metaRow.cells[i2];
      cellData = rowData.data[i2];
      columnKey = metaCell.columnKey;
      if (!columnKey)
        continue;
      var value = UIUtil.getCellValue(metaCell, dataTable, form);
      tbview.__setValueAt(rowIndex, i2, value, cellData, metaCell, loading);
    }
  }
  static showFixRowData(form, tbview, rowIndex, rowData, metaRow, loading = true) {
    var document2 = form.getDocument(), table, value, bkmkRow = rowData.bkmkRow, metaCell, tableKey, cellData, columnKey;
    for (var i2 = 0; metaCell = metaRow.cells[i2]; i2++) {
      cellData = rowData.data[i2];
      tableKey = metaCell.tableKey;
      columnKey = metaCell.tableKey;
      table = document2.getByKey(tableKey);
      if (!columnKey || !table)
        continue;
      if (table.first()) {
        if (bkmkRow == null) {
          bkmkRow = new DetailRowBkmk(table.getBkmk());
        }
        value = UIUtil.getCellValue(metaCell, table, form);
        tbview.__setValueAt(rowIndex, i2, value, cellData, metaCell, loading);
        cellData.bkmkRow = bkmkRow;
      }
    }
  }
  static locateCellError(grid, rowIndex, colIndex, rowData, cellData) {
    rowData = rowData || grid.getRowDataAt(rowIndex);
    cellData = cellData || (rowData == null ? void 0 : rowData.data[colIndex]);
    if (!cellData)
      return;
    let column = grid.getColumnAt(colIndex);
    if (!column.visible && (cellData.error || cellData.required)) {
      if (cellData.error) {
        grid.setRowError(rowIndex, true, cellData.errMsg, cellData.key);
      }
      if (cellData.required) {
        grid.setRowError(rowIndex, true, cellData.caption + " " + I18N.getString("CONTROL_REQUIRED", "-必须填写-"), cellData.key);
      }
    } else {
      if (rowData.error.hasError(cellData.key)) {
        grid.setRowError(rowIndex, false, null, cellData.key);
      }
    }
  }
}
class TabPanelHandler extends BaseHandler {
  static doActiveEvent(com) {
    return com.getForm().asyncEval(com.activate);
  }
  static doItemChanged(tabPanel) {
    return tabPanel.getForm().asyncEval(tabPanel.itemChanged);
  }
}
var __defProp$5 = Object.defineProperty;
var __getOwnPropDesc$5 = Object.getOwnPropertyDescriptor;
var __decorateClass$5 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$5(target, key) : target;
  for (var i2 = decorators.length - 1, decorator; i2 >= 0; i2--)
    if (decorator = decorators[i2])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$5(target, key, result);
  return result;
};
class TextEditorHandler extends BaseHandler {
  static doEnterPress(textEditor, keyEnter) {
    return textEditor.getForm().asyncEval(keyEnter);
  }
  static doOnFocus(textEditor, focus) {
    return textEditor.getForm().asyncEval(focus);
  }
  static doTextChanged(textEditor, textChanged) {
    return textEditor.getForm().asyncEval(textChanged);
  }
  static doOnClick(textBtn, formula) {
    var form = textBtn.getForm();
    var cxt = new ViewContext(form);
    var params = textBtn.getCompData();
    cxt.setCompData(params);
    cxt.setClickButtonKey(textBtn.key);
    return form.asyncEval(formula, cxt);
  }
}
__decorateClass$5([
  CompEventListener()
], TextEditorHandler, "doOnClick", 1);
class PasswordEditorHandler extends BaseHandler {
  static doEnterPress(passwordEditor, keyEnter) {
    return passwordEditor.getForm().asyncEval(keyEnter);
  }
  static doOnFocus(passwordEditor, focus) {
    return passwordEditor.getForm().asyncEval(focus);
  }
  static doTextChanged(passwordEditor, textChanged) {
    return passwordEditor.getForm().asyncEval(textChanged);
  }
}
let TextAreaHandler$1 = class TextAreaHandler extends BaseHandler {
  static doEnterPress(textArea, keyEnter) {
    return textArea.getForm().asyncEval(keyEnter);
  }
  static doOnFocus(textArea, focus) {
    return textArea.getForm().asyncEval(focus);
  }
  static doTextChanged(textArea, textChanged) {
    return textArea.getForm().asyncEval(textChanged);
  }
};
class TimeCountDownHandler extends BaseHandler {
  static doOnFinish(timeDownView, content) {
    var form = timeDownView.getForm();
    return form.asyncEval(content);
  }
}
class OperationType {
}
OperationType.OPERATION = 0;
OperationType.OPERATIONCOLLECTION = 1;
class InplaceToolbarItemAction {
  static async processAction(form, item) {
    let action;
    if (this.processor) {
      action = await this.processor.processAction(form, item);
    } else {
      action = item.action;
    }
    return action;
  }
  static setImpl(impl) {
    this.processor = impl;
  }
}
const data$2 = new HashMap();
class InplaceToolBar {
  static reg(key, inplaceToolbar) {
    if (inplaceToolbar) {
      data$2.put(key, inplaceToolbar);
    }
  }
  static get(key) {
    return data$2.get(key);
  }
}
const HEAD_ENABLE = "headEnableItems";
const HEAD_VISIBLE = "headVisibleItems";
const HEAD_CHECK = "headCheckRuleItems";
const HEAD_REQUIRED = "headRequiredItems";
class HeadCache {
  constructor(rawCache) {
    this.headEnableCache = new HashMap();
    this.headVisibleCache = new HashMap();
    this.headCheckCache = new HashMap();
    this.headRequiredCache = new HashMap();
    if (rawCache) {
      this.doInit(rawCache);
    }
  }
  doInit(rawCache) {
    this.reset();
    this.doMerge(rawCache);
  }
  doMerge(rawCache) {
    const enableItems = rawCache[HEAD_ENABLE] || {};
    for (let key in enableItems) {
      this.headEnableCache.put(key, enableItems[key]);
    }
    const visibleItems = rawCache[HEAD_VISIBLE] || {};
    for (let key in visibleItems) {
      this.headVisibleCache.put(key, visibleItems[key]);
    }
    const checkItems = rawCache[HEAD_CHECK] || {};
    for (let key in checkItems) {
      this.headCheckCache.put(key, checkItems[key]);
    }
    const requiredItems = rawCache[HEAD_REQUIRED] || {};
    for (let key in requiredItems) {
      this.headRequiredCache.put(key, requiredItems[key]);
    }
  }
  reset() {
    this.headEnableCache.clear();
    this.headVisibleCache.clear();
    this.headCheckCache.clear();
    this.headRequiredCache.clear();
  }
  getHeadEnableCache() {
    return this.headEnableCache;
  }
  getHeadVisibleCache() {
    return this.headVisibleCache;
  }
  getHeadCheckCache() {
    return this.headCheckCache;
  }
  getHeadRequiredCache() {
    return this.headRequiredCache;
  }
  deleteEnableCache(key) {
    this.headEnableCache.remove(key);
  }
  deleteVisibleCache(key) {
    this.headVisibleCache.remove(key);
  }
  deleteCheckCache(key) {
    this.headCheckCache.remove(key);
  }
  deleteRequiredCache(key) {
    this.headRequiredCache.remove(key);
  }
}
const CELL_ENABLE = "gridCellEnableItems";
const CELL_CHECK = "gridCellCheckRuleItems";
const CELL_REQUIRED = "gridCellRequiredItems";
class GridCellCache {
  constructor(rawCache) {
    this.cellCacheMap = new HashMap();
    if (rawCache) {
      this.doInit(rawCache);
    }
  }
  doInit(rawCache) {
    this.reset();
    this.doMerge(rawCache);
  }
  doMerge(rawCache) {
    const cellEnableItems = rawCache[CELL_ENABLE] || {};
    for (let [gridKey, enableCache] of Object.entries(cellEnableItems)) {
      let cellCache = this.cellCacheMap.get(gridKey);
      if (!cellCache)
        cellCache = new CellCache(gridKey);
      cellCache.initEnableCache(enableCache);
      this.cellCacheMap.put(gridKey, cellCache);
    }
    const cellCheckItems = rawCache[CELL_CHECK] || {};
    for (let [gridKey, checkCache] of Object.entries(cellCheckItems)) {
      let cellCache = this.cellCacheMap.get(gridKey);
      if (!cellCache)
        cellCache = new CellCache(gridKey);
      cellCache.initCheckCache(checkCache);
      this.cellCacheMap.put(gridKey, cellCache);
    }
    const cellRequireItems = rawCache[CELL_REQUIRED] || {};
    for (let [gridKey, requiredCache] of Object.entries(cellRequireItems)) {
      let cellCache = this.cellCacheMap.get(gridKey);
      if (!cellCache)
        cellCache = new CellCache(gridKey);
      cellCache.initRequiredCache(requiredCache);
      this.cellCacheMap.put(gridKey, cellCache);
    }
  }
  reset() {
    this.cellCacheMap.clear();
  }
  getMap() {
    return this.cellCacheMap;
  }
  getRowEnableCache(gridKey, bkmk) {
    var cellCache = this.cellCacheMap.get(gridKey);
    return cellCache ? cellCache.getEnableCache(bkmk) : null;
  }
  getRowCheckCache(gridKey, bkmk) {
    var cellCache = this.cellCacheMap.get(gridKey);
    return cellCache ? cellCache.getCheckCache(bkmk) : null;
  }
  getRowRequired(gridKey, bkmk) {
    var cellCache = this.cellCacheMap.get(gridKey);
    return cellCache ? cellCache.getRequiredCache(bkmk) : null;
  }
  deleteCellEnableCache(gridKey, cellKey) {
    var _a;
    (_a = this.cellCacheMap.get(gridKey)) == null ? void 0 : _a.deleteEnableCache(cellKey);
  }
  deleteCellCheckCache(gridKey, cellKey) {
    var _a;
    (_a = this.cellCacheMap.get(gridKey)) == null ? void 0 : _a.deleteCheckCache(cellKey);
  }
  deleteCellRequiredCache(gridKey, cellKey) {
    var _a;
    (_a = this.cellCacheMap.get(gridKey)) == null ? void 0 : _a.deleteRequiredCache(cellKey);
  }
}
class CellCache {
  constructor(gridKey) {
    this.gridKey = "";
    this.cellEnableMap = new HashMap();
    this.cellCheckMap = new HashMap();
    this.cellRequiredMap = new HashMap();
    this.gridKey = gridKey;
  }
  initEnableCache(rawCache) {
    for (let [bkmk, cache2] of Object.entries(rawCache)) {
      let enableMap = this.cellEnableMap.get(bkmk);
      if (!enableMap)
        enableMap = new HashMap();
      for (let [cellKey, enableValue] of Object.entries(cache2)) {
        enableMap.put(cellKey, enableValue);
      }
      this.cellEnableMap.put(bkmk, enableMap);
    }
  }
  initCheckCache(rawCache) {
    for (let [bkmk, cache2] of Object.entries(rawCache)) {
      let checkMap = this.cellCheckMap.get(bkmk);
      if (!checkMap)
        checkMap = new HashMap();
      for (let [cellKey, checkValue] of Object.entries(cache2)) {
        if (checkValue == null || checkValue === "true") {
          checkValue = true;
        }
        checkMap.put(cellKey, checkValue);
      }
      this.cellCheckMap.put(bkmk, checkMap);
    }
  }
  initRequiredCache(rawCache) {
    for (let [bkmk, cache2] of Object.entries(rawCache)) {
      let requiredMap = this.cellRequiredMap.get(bkmk);
      if (!requiredMap)
        requiredMap = new HashMap();
      for (let [cellKey, requiredValue] of Object.entries(cache2)) {
        requiredMap.put(cellKey, requiredValue);
      }
      this.cellRequiredMap.put(bkmk, requiredMap);
    }
  }
  getKey() {
    return this.gridKey;
  }
  getEnableMap() {
    return this.cellEnableMap;
  }
  getCheckMap() {
    return this.cellCheckMap;
  }
  getRequiredMap() {
    return this.cellRequiredMap;
  }
  getEnableCache(bkmk) {
    return this.cellEnableMap.get(bkmk);
  }
  getCheckCache(bkmk) {
    return this.cellCheckMap.get(bkmk);
  }
  getRequiredCache(bkmk) {
    return this.cellRequiredMap.get(bkmk);
  }
  deleteEnableCache(cellKey) {
    this.cellEnableMap.keys().forEach((bkmk) => this.cellEnableMap.get(bkmk).remove(cellKey));
  }
  deleteCheckCache(cellKey) {
    this.cellCheckMap.keys().forEach((bkmk) => this.cellCheckMap.get(bkmk).remove(cellKey));
  }
  deleteRequiredCache(cellKey) {
    this.cellRequiredMap.keys().forEach((bkmk) => this.cellRequiredMap.get(bkmk).remove(cellKey));
  }
}
class GridRowCache {
  constructor(rawCache) {
    this.rowCacheMap = new HashMap();
    if (rawCache) {
      this.doInit(rawCache);
    }
  }
  doInit(rawCache) {
    this.reset();
    this.doMerge(rawCache);
  }
  doMerge(rawCache) {
    for (let [gridKey, checkCache] of Object.entries(rawCache)) {
      let rowCache = this.rowCacheMap.get(gridKey);
      if (!rowCache)
        rowCache = new RowCache(gridKey);
      rowCache.initCheckCache(checkCache);
      this.rowCacheMap.put(gridKey, rowCache);
    }
  }
  reset() {
    this.rowCacheMap.clear();
  }
  getRowCheckCache(gridKey) {
    var rowCache = this.rowCacheMap.get(gridKey);
    return rowCache ? rowCache.getCheckCache() : null;
  }
  getEmptyRowCheckCache(gridKey) {
    return null;
  }
  deleteRowCheckCache(gridKey, bkmk) {
    var _a;
    (_a = this.getRowCheckCache(gridKey)) == null ? void 0 : _a.remove(bkmk);
  }
  deleteEmptyRowCheckCache(gridKey) {
  }
}
class RowCache {
  constructor(gridKey) {
    this.gridKey = "";
    this.rowCheckMap = new HashMap();
    this.gridKey = gridKey;
  }
  initCheckCache(rawCache) {
    for (let [bkmk, checkValue] of Object.entries(rawCache)) {
      if (checkValue == null || checkValue === "true") {
        checkValue = true;
      }
      this.rowCheckMap.put(bkmk, checkValue);
    }
  }
  getKey() {
    return this.gridKey;
  }
  getCheckCache() {
    return this.rowCheckMap;
  }
}
const COLUMN_ENABLE = "gridColumnEnableItems";
const COLUMN_VISIBLE = "gridColumnVisibleItems";
class GridColumnCache {
  constructor(rawCache) {
    this.columnCacheMap = new HashMap();
    if (rawCache) {
      this.doInit(rawCache);
    }
  }
  doInit(rawCache) {
    this.reset();
    this.doMerge(rawCache);
  }
  doMerge(rawCache) {
    const columnEnableItems = rawCache[COLUMN_ENABLE] || {};
    for (let [gridKey, enableCache] of Object.entries(columnEnableItems)) {
      let columnCache = this.columnCacheMap.get(gridKey);
      if (!columnCache)
        columnCache = new ColumnCache(gridKey);
      columnCache.initEnableCache(enableCache);
      this.columnCacheMap.put(gridKey, columnCache);
    }
    const columnVisibleItems = rawCache[COLUMN_VISIBLE] || {};
    for (let [gridKey, visibleCache] of Object.entries(columnVisibleItems)) {
      let columnCache = this.columnCacheMap.get(gridKey);
      if (!columnCache)
        columnCache = new ColumnCache(gridKey);
      columnCache.initVisibleCache(visibleCache);
      this.columnCacheMap.put(gridKey, columnCache);
    }
  }
  reset() {
    this.columnCacheMap.clear();
  }
  getColumnEnableCache(gridKey) {
    var cellCache = this.columnCacheMap.get(gridKey);
    return cellCache ? cellCache.getEnableCache() : null;
  }
  getColumnVisibleCache(gridKey) {
    var cellCache = this.columnCacheMap.get(gridKey);
    return cellCache ? cellCache.getVisibleCache() : null;
  }
  deleteVisibleCache(gridKey, colKey) {
    var _a;
    (_a = this.getColumnVisibleCache(gridKey)) == null ? void 0 : _a.remove(colKey);
  }
  deleteEnableCache(gridKey, colKey) {
    var _a;
    (_a = this.getColumnEnableCache(gridKey)) == null ? void 0 : _a.remove(colKey);
  }
}
class ColumnCache {
  constructor(gridKey) {
    this.gridKey = "";
    this.columnEnableMap = new HashMap();
    this.columnVisibleMap = new HashMap();
    this.gridKey = gridKey;
  }
  initEnableCache(rawCache) {
    for (let [colKey, enableValue] of Object.entries(rawCache)) {
      this.columnEnableMap.put(colKey, enableValue);
    }
  }
  initVisibleCache(rawCache) {
    for (let [colKey, visibleValue] of Object.entries(rawCache)) {
      this.columnVisibleMap.put(colKey, visibleValue);
    }
  }
  getKey() {
    return this.gridKey;
  }
  getEnableCache() {
    return this.columnEnableMap;
  }
  getVisibleCache() {
    return this.columnVisibleMap;
  }
}
const EMPTYROW_ENABLE = "gridEmptyRowEnableItems";
const EMPTYROW_CHECK = "gridEmptyRowCheckRuleItems";
const EMPTYROW_REQUIRED = "gridEmptyRowRequiredItems";
class GridEmptyRowCache {
  constructor(rawCache) {
    this.emptyRowCacheMap = new HashMap();
    if (rawCache) {
      this.doInit(rawCache);
    }
  }
  doInit(rawCache) {
    this.reset();
    this.doMerge(rawCache);
  }
  doMerge(rawCache) {
    const emptyRowEnableItems = rawCache[EMPTYROW_ENABLE] || {};
    for (let [gridKey, enableCache] of Object.entries(emptyRowEnableItems)) {
      let emptyRowCache = this.emptyRowCacheMap.get(gridKey);
      if (!emptyRowCache)
        emptyRowCache = new EmptyRowCellCache(gridKey);
      emptyRowCache.initEnableCache(enableCache);
      this.emptyRowCacheMap.put(gridKey, emptyRowCache);
    }
    const emptyRowCheckItems = rawCache[EMPTYROW_CHECK] || {};
    for (let [gridKey, checkCache] of Object.entries(emptyRowCheckItems)) {
      let emptyRowCache = this.emptyRowCacheMap.get(gridKey);
      if (!emptyRowCache)
        emptyRowCache = new EmptyRowCellCache(gridKey);
      emptyRowCache.initCheckCache(checkCache);
      this.emptyRowCacheMap.put(gridKey, emptyRowCache);
    }
    const emptyRowRequiredItems = rawCache[EMPTYROW_REQUIRED] || {};
    for (let [gridKey, requiredCache] of Object.entries(emptyRowRequiredItems)) {
      let emptyRowCache = this.emptyRowCacheMap.get(gridKey);
      if (!emptyRowCache)
        emptyRowCache = new EmptyRowCellCache(gridKey);
      emptyRowCache.initRequiredCache(requiredCache);
      this.emptyRowCacheMap.put(gridKey, emptyRowCache);
    }
  }
  reset() {
    this.emptyRowCacheMap.clear();
  }
  getEmptyRowEnableCache(gridKey) {
    var cellCache = this.emptyRowCacheMap.get(gridKey);
    return cellCache ? cellCache.getEnableCache() : null;
  }
  getEmptyRowCheckCache(gridKey) {
    var cellCache = this.emptyRowCacheMap.get(gridKey);
    return cellCache ? cellCache.getCheckCache() : null;
  }
  getEmptyRowRequiredCache(gridKey) {
    var cellCache = this.emptyRowCacheMap.get(gridKey);
    return cellCache ? cellCache.getRequiredCache() : null;
  }
  deleteEmptyRowEnableCache(gridKey, cellKey) {
    var _a;
    (_a = this.getEmptyRowEnableCache(gridKey)) == null ? void 0 : _a.remove(cellKey);
  }
  deleteEmptyRowCheckCache(gridKey, cellKey) {
    var _a;
    (_a = this.getEmptyRowCheckCache(gridKey)) == null ? void 0 : _a.remove(cellKey);
  }
  deleteEmptyRowRequiredCache(gridKey, cellKey) {
    var _a;
    (_a = this.getEmptyRowRequiredCache(gridKey)) == null ? void 0 : _a.remove(cellKey);
  }
}
class EmptyRowCellCache {
  constructor(gridKey) {
    this.gridKey = "";
    this.cellEnableMap = new HashMap();
    this.cellCheckMap = new HashMap();
    this.cellRequiredMap = new HashMap();
    this.gridKey = gridKey;
  }
  initEnableCache(rawCache) {
    for (let [cellKey, enableValue] of Object.entries(rawCache)) {
      this.cellEnableMap.put(cellKey, enableValue);
    }
  }
  initRequiredCache(rawCache) {
    for (let [cellKey, requiredCache] of Object.entries(rawCache)) {
      this.cellRequiredMap.put(cellKey, requiredCache);
    }
  }
  initCheckCache(rawCache) {
    for (let [cellKey, checkValue] of Object.entries(rawCache)) {
      if (checkValue == null || checkValue === "true") {
        checkValue = true;
      }
      this.cellCheckMap.put(cellKey, checkValue);
    }
  }
  getKey() {
    return this.gridKey;
  }
  getEnableCache() {
    return this.cellEnableMap;
  }
  getCheckCache() {
    return this.cellCheckMap;
  }
  getRequiredCache() {
    return this.cellRequiredMap;
  }
}
const OPERATION_ENABLE = "enableCache";
const OPERATION_VISIBLE = "visibleCache";
class OperationCache {
  constructor(rawCache) {
    this.optEnableCache = new HashMap();
    this.optVisibleCache = new HashMap();
    if (rawCache) {
      this.doInit(rawCache);
    }
  }
  doInit(rawCache) {
    this.reset();
    this.doMerge(rawCache);
  }
  doMerge(rawCache) {
    var optEnableItems = rawCache[OPERATION_ENABLE] || {};
    for (let [optKey, enableValue] of Object.entries(optEnableItems)) {
      this.optEnableCache.put(optKey, enableValue);
    }
    var optVisibleItems = rawCache[OPERATION_VISIBLE] || {};
    for (let [optKey, visibleValue] of Object.entries(optVisibleItems)) {
      this.optVisibleCache.put(optKey, visibleValue);
    }
  }
  reset() {
    this.optEnableCache.clear();
    this.optVisibleCache.clear();
  }
  getEnableCache() {
    return this.optEnableCache;
  }
  getVisibleCache() {
    return this.optVisibleCache;
  }
  deleteEnableCache(optKey) {
    this.optEnableCache.remove(optKey);
  }
  deleteVisibleCache(optKey) {
    this.optVisibleCache.remove(optKey);
  }
}
const HEAD$1 = "headItems";
const GRIDCELL$1 = "gridCellItems";
class UIVariantCache {
  constructor(rawCache) {
    this.headCache = new HeadCache();
    this.cellCache = new GridCellCache();
    if (rawCache) {
      this.doInit(rawCache);
    }
  }
  doInit(rawCache) {
    const rawHeadCache = rawCache[HEAD$1];
    if (rawHeadCache) {
      this.headCache.doMerge(rawHeadCache);
    }
    const rawGridCellCache = rawCache[GRIDCELL$1];
    if (rawGridCellCache) {
      this.cellCache.doMerge(rawGridCellCache);
    }
  }
  getHeadCache() {
    return this.headCache;
  }
  getCellCache() {
    return this.cellCache;
  }
  getHeadEnableCache() {
    return this.headCache.getHeadEnableCache();
  }
  getHeadVisibleCache() {
    return this.headCache.getHeadVisibleCache();
  }
  getHeadCheckCache() {
    return this.headCache.getHeadCheckCache();
  }
  getHeadRequiredCache() {
    return this.headCache.getHeadRequiredCache();
  }
  getRowCellEnableCache(gridKey, bkmk) {
    return this.cellCache.getRowEnableCache(gridKey, bkmk);
  }
  getRowCellCheckCache(gridKey, bkmk) {
    return this.cellCache.getRowCheckCache(gridKey, bkmk);
  }
  getRowCellRequiredCache(gridKey, bkmk) {
    return this.cellCache.getRowRequired(gridKey, bkmk);
  }
}
const HEAD = "headItems";
const GRIDCELL = "gridCellItems";
const GRIDROW = "gridRowCheckRuleItems";
const GRIDCOLUMN = "gridColumnItems";
const GRIDEMPTYROW = "gridEmptyRowItems";
const OPERATION = "operationItems";
const GRIDOPERATION = "gridoperationItems";
const VARIANTCACHE = "variantCache";
class UIProcessCache {
  constructor(rawCache) {
    this.headCache = new HeadCache();
    this.rowCache = new GridRowCache();
    this.cellCache = new GridCellCache();
    this.columnCache = new GridColumnCache();
    this.operationCache = new OperationCache();
    this.gridOperationCache = new OperationCache();
    this.emptyRowCache = new GridEmptyRowCache();
    if (rawCache) {
      this.doInit(rawCache);
    }
  }
  doInit(rawCache) {
    this.resetUICache();
    this.doMerge(rawCache);
  }
  doMerge(rawCache) {
    const rawHeadCache = rawCache[HEAD];
    if (rawHeadCache) {
      this.headCache.doMerge(rawHeadCache);
    }
    const rawGridRowCache = rawCache[GRIDROW];
    if (rawGridRowCache) {
      this.rowCache.doMerge(rawGridRowCache);
    }
    const rawGridCellCache = rawCache[GRIDCELL];
    if (rawGridCellCache) {
      this.cellCache.doMerge(rawGridCellCache);
    }
    const rawGridColumnCache = rawCache[GRIDCOLUMN];
    if (rawGridColumnCache) {
      this.columnCache.doMerge(rawGridColumnCache);
    }
    const rawGridEmptyRowCache = rawCache[GRIDEMPTYROW];
    if (rawGridEmptyRowCache) {
      this.emptyRowCache.doMerge(rawGridEmptyRowCache);
    }
    const rawOperationCache = rawCache[OPERATION];
    if (rawOperationCache) {
      this.operationCache.doMerge(rawOperationCache);
    }
    const rawGridOperationCache = rawCache[GRIDOPERATION];
    if (rawGridOperationCache) {
      this.gridOperationCache.doMerge(rawGridOperationCache);
    }
    const rawVariantCache = rawCache[VARIANTCACHE];
    if (rawVariantCache) {
      this.variantCache = new UIVariantCache(rawVariantCache);
    }
  }
  getVariantCache() {
    return this.variantCache;
  }
  getHeadCache() {
    return this.headCache;
  }
  getRowCache() {
    return this.rowCache;
  }
  getCellCache() {
    return this.cellCache;
  }
  getColumnCache() {
    return this.columnCache;
  }
  getEmptyRowCache() {
    return this.emptyRowCache;
  }
  getOperationCache() {
    return this.operationCache;
  }
  getGridOperationCache() {
    return this.gridOperationCache;
  }
  getHeadEnableCache() {
    return this.headCache.getHeadEnableCache();
  }
  getHeadVisibleCache() {
    return this.headCache.getHeadVisibleCache();
  }
  getHeadCheckCache() {
    return this.headCache.getHeadCheckCache();
  }
  getHeadRequiredCache() {
    return this.headCache.getHeadRequiredCache();
  }
  getColumnEnableCache(gridKey) {
    return this.columnCache.getColumnEnableCache(gridKey);
  }
  getColumnVisibleCache(gridKey) {
    return this.columnCache.getColumnVisibleCache(gridKey);
  }
  getRowCellEnableCache(gridKey, bkmk) {
    return this.cellCache.getRowEnableCache(gridKey, bkmk);
  }
  getRowCellCheckCache(gridKey, bkmk) {
    return this.cellCache.getRowCheckCache(gridKey, bkmk);
  }
  getRowCellRequiredCache(gridKey, bkmk) {
    return this.cellCache.getRowRequired(gridKey, bkmk);
  }
  getEmptyRowCellEnableCache(gridKey) {
    return this.emptyRowCache.getEmptyRowEnableCache(gridKey);
  }
  getEmptyRowCellCheckCache(gridKey) {
    return this.emptyRowCache.getEmptyRowCheckCache(gridKey);
  }
  getEmptyRowCellRequiredCache(gridKey) {
    return this.emptyRowCache.getEmptyRowRequiredCache(gridKey);
  }
  getRowCheckCache(gridKey) {
    return this.rowCache.getRowCheckCache(gridKey);
  }
  getEmptyRowCheckCache(gridKey) {
    return this.rowCache.getEmptyRowCheckCache(gridKey);
  }
  getOperationEnableCache() {
    return this.operationCache.getEnableCache();
  }
  getOperationVisibleCache() {
    return this.operationCache.getVisibleCache();
  }
  getGridOperationEnableCache() {
    return this.gridOperationCache.getEnableCache();
  }
  getGridOperationVisibleCache() {
    return this.gridOperationCache.getVisibleCache();
  }
  deleteVariantCache() {
    this.variantCache = null;
  }
  deleteHeadEnableCache(key) {
    this.headCache.deleteEnableCache(key);
  }
  deleteHeadVisibleCache(key) {
    this.headCache.deleteVisibleCache(key);
  }
  deleteHeadCheckCache(key) {
    this.headCache.deleteCheckCache(key);
  }
  deleteHeadRequiredCache(key) {
    this.headCache.deleteRequiredCache(key);
  }
  deleteColumnEnableCache(gridKey, colKey) {
    this.columnCache.deleteEnableCache(gridKey, colKey);
  }
  deleteColumnVisibleCache(gridKey, colKey) {
    this.columnCache.deleteVisibleCache(gridKey, colKey);
  }
  deleteCellEnableCache(gridKey, cellKey) {
    this.cellCache.deleteCellEnableCache(gridKey, cellKey);
  }
  deleteCellCheckCache(gridKey, cellKey) {
    this.cellCache.deleteCellCheckCache(gridKey, cellKey);
  }
  deleteCellRequiredCache(gridKey, cellKey) {
    this.cellCache.deleteCellRequiredCache(gridKey, cellKey);
  }
  deleteOperationEnableCache(optKey) {
    this.operationCache.deleteEnableCache(optKey);
  }
  deleteOperationVisibleCache(optKey) {
    this.operationCache.deleteVisibleCache(optKey);
  }
  deleteGridOperationEnableCache(optKey) {
    this.gridOperationCache.deleteEnableCache(optKey);
  }
  deleteGridOperationCellCheckCache(optKey) {
    this.gridOperationCache.deleteVisibleCache(optKey);
  }
  deleteRowCheckCache(gridKey, bkmk) {
    this.rowCache.deleteRowCheckCache(gridKey, bkmk);
  }
  resetUICache() {
    this.headCache.reset();
    this.rowCache.reset();
    this.cellCache.reset();
    this.columnCache.reset();
    this.emptyRowCache.reset();
    this.operationCache.reset();
    this.gridOperationCache.reset();
  }
}
class FormUICache {
  static resetUICache(form) {
    const uiProcessCache = form.getUICache();
    if (!uiProcessCache) {
      return;
    }
    uiProcessCache.getHeadCache().reset();
    uiProcessCache.getRowCache().reset();
    uiProcessCache.getCellCache().reset();
    uiProcessCache.getOperationCache().reset();
    uiProcessCache.getGridOperationCache().reset();
  }
  static merge(form, uiRawCache) {
    const uiProcessCache = form.getUICache();
    if (uiProcessCache) {
      uiProcessCache.doMerge(uiRawCache);
    } else {
      form.setUICache(new UIProcessCache(uiRawCache));
    }
  }
  // 根据字段移除对应缓存
  // 这个方法存在的意义参考变更#88407,#88412, 当使用SetValue(Key, Value, false) 公式进行赋值时 enable,visible, checkRule 需要重新计算
  static deleteUICacheByComp(form, compKey) {
    const depend = form.getDepend();
    if (!depend) {
      return;
    }
    const uiCache = form.getUICache();
    if (!uiCache) {
      return;
    }
    let affectItems = depend.enableTree.affectItems[compKey];
    if (affectItems && affectItems.items) {
      const length2 = affectItems.items.length;
      for (let i2 = 0; i2 < length2; i2++) {
        const affectItem = affectItems.items[i2];
        switch (affectItem.objectType) {
          case ExprItemType.Item:
            uiCache.deleteHeadEnableCache(affectItem.target);
            uiCache.deleteOperationEnableCache(affectItem.target);
            break;
          case ExprItemType.Set: {
            if (!affectItem.items) {
              continue;
            }
            const gridKey = affectItem.source;
            for (let i22 = 0, item; item = affectItem.items[i22]; i22++) {
              const cellKey = item.target;
              uiCache.deleteCellEnableCache(gridKey, cellKey);
            }
            break;
          }
        }
      }
    }
    affectItems = depend.visibleTree.affectItems[compKey];
    if (affectItems && affectItems.items) {
      const length2 = affectItems.items.length;
      for (let i2 = 0; i2 < length2; i2++) {
        const affectItem = affectItems.items[i2];
        switch (affectItem.objectType) {
          case ExprItemType.Item:
            uiCache.deleteHeadVisibleCache(affectItem.target);
            uiCache.deleteOperationVisibleCache(affectItem.target);
            break;
          case ExprItemType.Set: {
            if (!affectItem.items) {
              continue;
            }
            const gridKey = affectItem.source;
            for (let i22 = 0, item; item = affectItem.items[i22]; i22++) {
              const columnKey = item.target;
              uiCache.deleteColumnVisibleCache(gridKey, columnKey);
            }
            break;
          }
        }
      }
    }
    affectItems = depend.checkTree.affectItems[compKey];
    if (affectItems && affectItems.items) {
      const length2 = affectItems.items.length;
      for (let i2 = 0; i2 < length2; i2++) {
        const affectItem = affectItems.items[i2];
        switch (affectItem.objectType) {
          case ExprItemType.Item:
            uiCache.deleteHeadCheckCache(affectItem.target);
            break;
          case ExprItemType.Set: {
            if (!affectItem.items) {
              continue;
            }
            const gridKey = affectItem.source;
            for (let i22 = 0, item; item = affectItem.items[i22]; i22++) {
              const cellKey = item.target;
              uiCache.deleteCellCheckCache(gridKey, cellKey);
            }
            break;
          }
        }
      }
    }
  }
  static deleteSubDetailCache(form, comKey) {
    const depend = form.getDepend();
    if (!depend) {
      return;
    }
    const uiCache = form.getUICache();
    if (!uiCache) {
      return;
    }
    const subDetails = form.getSubDetail(comKey);
    if (!subDetails || subDetails.length == 0) {
      return;
    }
    const enableTree = depend.enableTree;
    const visibleTree = depend.visibleTree;
    const checkTree = depend.checkTree;
    enableTree.items.reduce((prev, enableItem) => {
      let com = form.getComponent(enableItem.source);
      if (com && subDetails.includes(com)) {
        switch (enableItem.objectType) {
          case ExprItemType.Item:
            uiCache.deleteHeadEnableCache(enableItem.target);
            break;
          case ExprItemType.Set: {
            const gridKey = enableItem.source;
            for (let i2 = 0, item; item = enableItem.items[i2]; i2++) {
              const cellKey = item.target;
              uiCache.deleteCellEnableCache(gridKey, cellKey);
            }
          }
        }
      }
    }, true);
    visibleTree.items.reduce((prev, visibleItem) => {
      let com = form.getComponent(visibleItem.source);
      if (com && subDetails.includes(com)) {
        switch (visibleItem.objectType) {
          case ExprItemType.Item:
            uiCache.deleteHeadVisibleCache(visibleItem.target);
            break;
          case ExprItemType.Set: {
            const gridKey = visibleItem.source;
            for (let i2 = 0, item; item = visibleItem.items[i2]; i2++) {
              const columnKey = item.target;
              uiCache.deleteColumnVisibleCache(gridKey, columnKey);
            }
          }
        }
      }
    }, true);
    checkTree.items.reduce(async (prev, checkItem) => {
      let com = form.getComponent(checkItem.source);
      if (com && subDetails.includes(com)) {
        switch (checkItem.objectType) {
          case ExprItemType.Item:
            uiCache.deleteHeadCheckCache(checkItem.target);
            break;
          case ExprItemType.Set: {
            const gridKey = checkItem.source;
            for (let i2 = 0, item; item = checkItem.items[i2]; i2++) {
              const cellKey = item.target;
              uiCache.deleteCellCheckCache(gridKey, cellKey);
            }
          }
        }
      }
    }, true);
  }
  static async updateEnableUICache(form, key, enable) {
    const uiCache = {
      headItems: {
        headEnableItems: {
          key: enable
        }
      }
    };
    FormUICache.merge(form, uiCache);
  }
  static updateVisibleUICache(form, key, visible) {
    const uiCache = {
      headItems: {
        headVisibleItems: {
          key: visible
        }
      }
    };
    FormUICache.merge(form, uiCache);
  }
  static updateColumnVisibleUICache(form, gridKey, columnKey, visible) {
    const uiCache = {
      gridColumnItems: {
        gridColumnVisibleItems: {
          gridKey: {
            columnKey: visible
          }
        }
      }
    };
    FormUICache.merge(form, uiCache);
  }
  // 批量计算行切换
  static async batchCalcRowChanged(form, grid) {
    if (grid.getFocusRowIndex() == -1) {
      return;
    }
    return new RichDocService(form).batchCalcGridRowChanged(grid);
  }
  static async batchCalcAllItems(form, calcEnable, calcVisible, calcCheckRule, calcOperation) {
    return new RichDocService(form).batchCalcAllUIProcess(calcEnable, calcVisible, calcCheckRule, calcOperation);
  }
  static async batchCalcValueChanged(form, component) {
    return new RichDocService(form).BatchCalcValueChanged(component);
  }
  static async batchCalcSubDetail(form, gridKey) {
    return new RichDocService(form).batchCalcSubDetail(gridKey);
  }
  static async batchCalcGridUIProcess(form, grid, startIndex, endIndex) {
    return new RichDocService(form).batchCalcGridUIProcess(grid, startIndex, endIndex);
  }
  static async batchCalcOperationItems(form) {
    return new RichDocService(form).batchCalcOperationUIProcess();
  }
  static async needCalcUICache(form, component) {
    const depend = form.getDepend();
    if (!depend) {
      return true;
    }
    const uiCache = form.getUICache();
    if (!uiCache) {
      return true;
    }
    const enableAffectItems = depend.enableTree.affectItems[component.key];
    let item;
    if (enableAffectItems && enableAffectItems.items) {
      const enableItems = enableAffectItems.items;
      for (let i2 = 0; item = enableItems[i2]; i2++) {
        if (item.items.length == 0) {
          continue;
        }
        if (item.type == EnableItemType.OPERATION) {
          continue;
        }
        if (item.type == EnableItemType.GRIDOPERATION) {
          const scopeKey = item.target + ".ExtOpt.EnableScope";
          const scope = form.formulaScope[scopeKey];
          if (!scope || !scope.includeERPMidFunction) {
            continue;
          }
          const gridOperationEnableCache = uiCache.getGridOperationEnableCache();
          if (!gridOperationEnableCache || !gridOperationEnableCache.containsKey(item.source)) {
            return true;
          }
        } else {
          const scope = form.formulaScope[item.source + ".EnableScope"];
          if (!scope || !scope.includeERPMidFunction) {
            continue;
          }
          const headEnableItems = uiCache.getHeadEnableCache();
          if (!headEnableItems || !headEnableItems.containsKey(item.source)) {
            return true;
          }
        }
      }
    }
    const visibleAffectItems = depend.visibleTree.affectItems[component.key];
    if (visibleAffectItems && visibleAffectItems.items) {
      const visibleItems = visibleAffectItems.items;
      for (let i2 = 0; item = visibleItems[i2]; i2++) {
        if (item.items.length == 0) {
          continue;
        }
        if (item.type == VisibleItemType.OPERATION) {
          continue;
        }
        if (item.type == VisibleItemType.GRIDOPERATION) {
          const scopeKey = item.target + ".ExtOpt.VisibleScope";
          const scope = form.formulaScope[scopeKey];
          if (!scope || !scope.includeERPMidFunction) {
            continue;
          }
          const gridOperationVisibleCache = uiCache.getGridOperationVisibleCache();
          if (!gridOperationVisibleCache || !gridOperationVisibleCache.containsKey(item.source)) {
            return true;
          }
        } else {
          const scope = form.formulaScope[item.source + ".VisibleScope"];
          if (!scope || !scope.includeERPMidFunction) {
            continue;
          }
          const headVisibleItems = uiCache.getHeadVisibleCache();
          if (!headVisibleItems || !headVisibleItems.containsKey(item.source)) {
            return true;
          }
        }
      }
    }
    const checkRuleAffectItems = depend.checkTree.affectItems[component.key];
    if (checkRuleAffectItems && checkRuleAffectItems.items) {
      const checkRuleItems = checkRuleAffectItems.items;
      for (let i2 = 0; item = checkRuleItems[i2]; i2++) {
        if (item.items.length == 0) {
          continue;
        }
        const scope = form.formulaScope[item.source + ".CheckRuleScope"];
        if (!scope || !scope.includeERPMidFunction) {
          continue;
        }
        const headCheckRuleItems = uiCache.getHeadCheckCache();
        if (!headCheckRuleItems || !headCheckRuleItems.containsKey(item.source)) {
          return true;
        }
      }
    }
    return false;
  }
  // 获取关联表(父表/子表/头表)
  static getRelationTableKeys(form, doc, bookMarks) {
    const tableKeys = bookMarks.keys();
    for (let keyIndex = 0; keyIndex < tableKeys.length; keyIndex++) {
      const key = tableKeys[keyIndex];
      const grid = this.getGridByTableKey(form, key);
      if (grid == null) {
        continue;
      }
      const subComList = form.getSubDetail(grid.key);
      if (subComList == null || subComList == void 0) {
        continue;
      }
      for (let subComIndex = 0; subComIndex < subComList.length; subComIndex++) {
        const tmpCom = subComList[subComIndex];
        const subCom = Utils.isString(tmpCom) ? form.getComponent(tmpCom) : tmpCom;
        if (subCom.type != ControlType.GRID && subCom.type != ControlType.TABLEVIEW && subCom.type != ControlType.EDITVIEW) {
          continue;
        }
        const tmp = bookMarks.get(key);
        const subDataTable = doc.getByKey(subCom.tableKey);
        if (!subDataTable) {
          return false;
        }
        const allRows = subDataTable.allRows;
        const bkmkArray = new Array();
        if (Array.isArray(tmp)) {
          for (let j = 0, len = allRows.length; j < len; j++) {
            const row = allRows[j];
            if (tmp.includes(row.parentBkmk)) {
              bkmkArray.push(row.bkmk);
            }
          }
          this.getSubTableKeys(doc, subCom.tableKey, bkmkArray, bookMarks, form);
        } else if (tmp >= 0) {
          for (let j = 0, len = allRows.length; j < len; j++) {
            const row = allRows[j];
            if (tmp == row.parentBkmk) {
              bkmkArray.push(row.bkmk);
            }
          }
          this.getSubTableKeys(doc, subCom.tableKey, bkmkArray, bookMarks, form);
        }
      }
    }
    for (let keyIndex = 0; keyIndex < tableKeys.length; keyIndex++) {
      const key = tableKeys[keyIndex];
      const dataTable = doc.getByKey(key);
      if (dataTable && dataTable.parentKey != "" && dataTable.size() > 0) {
        const tmp = bookMarks.get(key);
        if (Array.isArray(tmp)) {
          for (let bkmkIndex = 0; bkmkIndex < tmp.length; bkmkIndex++) {
            const bkmk = tmp[bkmkIndex];
            if (dataTable.bkmks.get(bkmk) != null && dataTable.bkmks.get(bkmk) != void 0) {
              const parentBkmk = dataTable.rows[dataTable.bkmks.get(bkmk)].parentBkmk;
              this.getParentTableKeys(doc, dataTable.parentKey, parentBkmk, bookMarks);
            }
          }
        } else if (tmp >= 0) {
          if (dataTable.bkmks.get(tmp) != null && dataTable.bkmks.get(tmp) != void 0) {
            const parentBkmk = dataTable.rows[dataTable.bkmks.get(tmp)].parentBkmk;
            this.getParentTableKeys(doc, dataTable.parentKey, parentBkmk, bookMarks);
          }
        }
      }
    }
    const tbls = doc.tbls;
    const size2 = doc.tbls.length;
    for (let keyIndex = 0; keyIndex < size2; keyIndex++) {
      const dataTable = tbls[keyIndex];
      const key = dataTable.key;
      if (dataTable.size() != 1) {
        continue;
      }
      if (dataTable.tableMode == TableMode.HEAD) {
        if (!bookMarks.containsKey(key)) {
          bookMarks.put(key, dataTable.rows[0].bkmk);
        }
      } else if (dataTable.tableMode == TableMode.DETAIL) {
        const grid = this.getGridByTableKey(form, key);
        if (grid) {
          continue;
        }
        if (grid == null && bookMarks.containsKey(key)) {
          bookMarks.remove(key);
        }
        bookMarks.put(key, dataTable.rows[0].bkmk);
      }
    }
    return bookMarks;
  }
  static getSubTableKeys(doc, tableKey, bkmkArray, bookMarks, form) {
    const tmp = bookMarks.get(tableKey);
    if (tmp == bkmkArray) {
      return;
    }
    if (tmp === null || tmp === void 0 || tmp == -1) {
      bookMarks.put(tableKey, bkmkArray);
    } else {
      bookMarks.remove(tableKey);
      bookMarks.put(tableKey, bkmkArray);
    }
    const grid = this.getGridByTableKey(form, tableKey);
    const subComList = form.getSubDetail(grid.key);
    if (subComList == null || subComList == void 0) {
      return;
    }
    for (let subComIndex = 0; subComIndex < subComList.length; subComIndex++) {
      const tmpCom = subComList[subComIndex];
      const subCom = Utils.isString(tmpCom) ? form.getComponent(tmpCom) : tmpCom;
      if (subCom.type != ControlType.GRID) {
        continue;
      }
      const tmpSub = bkmkArray;
      const subDataTable = doc.getByKey(subCom.tableKey);
      const allRows = subDataTable.allRows;
      const bkmkArraySub = new Array();
      if (Array.isArray(tmpSub)) {
        for (let j = 0, len = allRows.length; j < len; j++) {
          const row = allRows[j];
          if (tmpSub.includes(row.parentBkmk)) {
            bkmkArraySub.push(row.bkmk);
          }
        }
        this.getSubTableKeys(doc, subCom.tableKey, bkmkArraySub, bookMarks, form);
      }
    }
  }
  static getParentTableKeys(doc, tableKey, parentBkmk, bookMarks) {
    const tmp = bookMarks.get(tableKey);
    if (tmp == parentBkmk) {
      return;
    }
    if (tmp === null || tmp === void 0 || tmp == -1) {
      bookMarks.put(tableKey, parentBkmk);
    } else if (Array.isArray(tmp)) {
      if (tmp.indexOf(parentBkmk) >= 0) {
        return;
      }
      tmp.push(parentBkmk);
    } else {
      const bkmkArray = new Array();
      bkmkArray.push(tmp);
      bkmkArray.push(parentBkmk);
      bookMarks.put(tableKey, bkmkArray);
    }
    const dataTable = doc.getByKey(tableKey);
    if (dataTable && dataTable.parentKey != "" && dataTable.size() > 0) {
      if (dataTable.bkmks.get(parentBkmk) != null && dataTable.bkmks.get(parentBkmk) != void 0) {
        const parentParentBkmk = dataTable.rows[dataTable.bkmks.get(parentBkmk)].parentBkmk;
        this.getParentTableKeys(doc, dataTable.parentKey, parentParentBkmk, bookMarks);
      }
    }
  }
  static getGridByTableKey(form, tableKey) {
    const grids = form.getGridArray();
    for (let i2 = 0; i2 < grids.length; i2++) {
      if (grids[i2].tableKey == tableKey) {
        return form.getComponent(grids[i2].key);
      }
    }
    const lists = form.getListArray();
    for (let i2 = 0; i2 < lists.length; i2++) {
      if (lists[i2].type == ControlType.EDITVIEW && lists[i2].tableKey == tableKey) {
        return form.getComponent(lists[i2].key);
      }
    }
  }
}
const FormUICache$1 = FormUICache;
var __defProp$4 = Object.defineProperty;
var __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor;
var __decorateClass$4 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target;
  for (var i2 = decorators.length - 1, decorator; i2 >= 0; i2--)
    if (decorator = decorators[i2])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$4(target, key, result);
  return result;
};
const initRecorder = (item) => {
  var shortcuts = item.shortcuts;
  if (!shortcuts) {
    return;
  }
  var keys = shortcuts.split("+");
  var r = {}, key;
  for (var i2 = 0, length2 = keys.length; i2 < length2; i2++) {
    key = keys[i2].trim().toLowerCase();
    if (key) {
      switch (key) {
        case "shift":
          r.shift = true;
          break;
        case "ctrl":
          r.ctrl = true;
          break;
        case "alt":
          r.alt = true;
          break;
        case "meta":
          r.meta = true;
          break;
        default:
          r.code = key;
          break;
      }
    }
  }
  item.recorder = r;
};
const replaceInplaceToolBar = async (form, item) => {
  var inplaceToolbar = InplaceToolBar.get(item.tag);
  var items = [];
  if (inplaceToolbar) {
    var opts = await inplaceToolbar.replace(form, item);
    if (opts) {
      for (var n = 0, length2 = opts.length; n < length2; n++) {
        items.push({
          type: OperationType.OPERATION,
          key: opts[n].key,
          caption: opts[n].caption,
          action: opts[n].action,
          preAction: opts[n].preAction,
          managed: true,
          // 受管理,有权限
          enableCnt: opts[n].enable,
          visibleCnt: opts[n].visible,
          formID: item.formID,
          cssClass: opts[n].cssClass,
          tcode: opts[n].tcode,
          activity: opts[n].activity
        });
      }
    }
    return items;
  }
  return items;
};
const calcOperationStatus = async (form, item) => {
  item.visible = await form.getUIProcess().calcOperationVisible(item);
  item.enable = await form.getUIProcess().calcOperationEnable(item);
  item.formID = form.formID;
  initRecorder(item);
  return item;
};
const addOneOperation = async (form, ret, item) => {
  var op = await calcOperationStatus(form, item);
  if (op) {
    ret.push(op);
  }
};
const addOneMenuOperation = async (form, ret, op) => {
  var item = await calcOperationStatus(form, op);
  if (item && item.items) {
    var offset = 0;
    await item.items.reduce(async (prev, _item, i2) => {
      await prev;
      var items_dp = _item.items;
      if (items_dp && items_dp.length > 0) {
        items_dp.forEach(async (item_dp) => {
          await calcOperationStatus(form, item_dp);
        });
      }
      var cItem = await calcOperationStatus(form, _item);
      if (cItem) {
        if (cItem.expand) {
          var expandSource = cItem.expandSource;
          if (expandSource) {
            var source = await form.asyncEval(expandSource, new ViewContext(form));
            var v = source.split(";");
            for (var j = 0, len = v.length; j < len; j++) {
              var s = v[j].split(",");
              if (s.length == 2) {
                var tmp = Object.assign({}, cItem);
                tmp.tag = s[0], tmp.caption = s[1], tmp.expand = false, tmp.expandSource = null, item.items[i2 + offset] = tmp;
                offset++;
              }
            }
          }
        } else {
          item.items[i2 + offset] = cItem;
        }
      }
    }, true);
    ret.push(item);
  }
};
class ToolBarHandler extends BaseHandler {
  static async doOnClick(formID2, item, toolbar, event2) {
    let id = formID2;
    if (item.formID) {
      id = item.formID;
    }
    const form = FormStack.getForm(id);
    HeadInfoUtil.put(item, HeadInfoOptType.STR_TOOLBAR, id);
    const cxt = new ViewContext(form);
    const preAction = item.preAction;
    const excpAction = item.excpAction;
    cxt.setTag((event2 == null ? void 0 : event2.tag) || item.tag);
    cxt.setExpAction(excpAction);
    cxt.setTarget(event2 == null ? void 0 : event2.target);
    var curTCode = form.TCode;
    try {
      if (item.tcode) {
        var tcode = await form.asyncEval(item.tcode, cxt);
        if (tcode && tcode != "") {
          form.TCode = tcode;
        }
      }
      if (item.activity || item.tcode) {
        await form.checkDataAuthority(item.activity);
      }
      if (preAction) {
        await form.asyncEval(preAction, cxt);
      }
      let action = await InplaceToolbarItemAction.processAction(form, item);
      if (!action) {
        return;
      }
      form.isWillAddOperation = true;
      await form.asyncEval(action, cxt);
      if (!form.isDestroyed) {
        await form.addOperation();
      }
    } catch (e) {
      if (form.TCode != curTCode) {
        form.TCode = curTCode;
      }
      console.log(e.stack);
      if (excpAction) {
        await form.asyncEval(excpAction);
      }
      throw e;
    } finally {
      HeadInfoUtil.clear();
    }
  }
  static async calcOperation(form) {
    await FormUICache$1.batchCalcOperationItems(form);
    var ret = [];
    await form.operations.reduce(async (prev, operation) => {
      await prev;
      var item = Object.assign({}, operation);
      if (item.type == OperationType.OPERATION) {
        if (item.tag) {
          var items = await replaceInplaceToolBar(form, item);
          return items.reduce(async (prev2, item2) => {
            await prev2;
            return await addOneOperation(form, ret, item2);
          }, true);
        } else {
          return await addOneOperation(form, ret, item);
        }
      } else {
        if (item.items.length > 0) {
          return await addOneMenuOperation(form, ret, item);
        } else {
          return await addOneOperation(form, ret, item);
        }
      }
    }, true);
    return ret;
  }
  static async addOperation(form, toolbar) {
    var self = this;
    if (toolbar && !toolbar.isDestroyed) {
      var ret = await self.calcOperation(form);
      if (toolbar.isDestroyed)
        return;
      var container = form.getContainer();
      if (!container || !container.mergeOperation) {
        toolbar.clearOperation();
      }
      toolbar.addOperation(ret);
      var moc = form.getMergeOptContainer();
      if (moc) {
        var ctn = form.getComponent(moc);
        var activePane = ctn.getActivePane();
        if (activePane) {
          return await activePane.addOperation(toolbar);
        }
      } else {
        if (!container)
          return;
        if (toolbar.ofFormKey != container.ofFormKey) {
          if (container.mergeOperation) {
            toolbar.clearOperation();
          }
        }
      }
      toolbar.repaint();
    }
  }
}
__decorateClass$4([
  CompEventListener()
], ToolBarHandler, "doOnClick", 1);
const WizardListItemType = Object.freeze({
  DATA: 0,
  Formula: 1
});
const cache$a = new LRUCache(20);
const getCacheKey$2 = async (form, prop, cxt) => {
  if (prop.cache) {
    var data2 = {};
    data2.key = prop.key;
    data2.formKey = form.getFormKey();
    var dependency = prop.dependency;
    if (dependency) {
      await dependency.split(",").reduce(async (prev, field) => {
        await prev;
        var value = await form.__eval(field, cxt);
        data2[field] = value;
      }, true);
      return JSON.stringify(data2);
    }
    return JSON.stringify(data2);
  }
  return null;
};
var getDataItems = function(form, prop) {
  return new Promise((resolve2, reject) => {
    var data2 = [], item = {};
    var document2 = form.getDocument();
    var table = document2.getByKey(prop.itemList.tableKey);
    if (!table)
      return;
    table.beforeFirst();
    for (var i2 = 0; i2 < prop.items.length; i2++) {
      table.setByBkmk(-1);
      while (table.next()) {
        item = Object.assign({}, prop.items[i2]);
        if (prop.items[i2 - 1]) {
          item["pvalue"] = table.getByKey(prop.items[i2 - 1].valueFieldKey);
          item["pkey"] = prop.items[i2 - 1].key;
        }
        if (prop.items[i2 + 1]) {
          item["zvalue"] = table.getByKey(prop.items[i2 + 1].valueFieldKey);
          item["zkey"] = prop.items[i2 + 1].key;
        }
        var value = table.getByKey(item.valueFieldKey);
        item["caption"] = table.getByKey(item.captionFieldKey);
        item["value"] = value;
        if (data2[data2.length - 1] && data2[data2.length - 1]["value"] == value)
          ;
        else {
          data2.push(item);
        }
      }
    }
    resolve2(data2);
  });
};
const getFormulaItems$1 = function(form, wizard, cxt) {
  return new Promise((resolve2, reject) => {
    var itemList = wizard.itemList, tableItems = wizard.items, items = [];
    if (itemList.formulaItems) {
      form.asyncEval(itemList.formulaItems, cxt).then(function(rs) {
        if (typeof rs === "string") {
          var item_Arr = rs.split(";");
          for (var i2 = 0, len = item_Arr.length; i2 < len; i2++) {
            var item_obj = item_Arr[i2].split(",");
            var i1 = item_obj[0];
            var i22 = "";
            if (item_obj.length > 1) {
              i22 = item_obj[1];
            } else {
              i22 = i1;
            }
            var item = {
              value: i1,
              caption: i22
            };
            items.push(item);
          }
          resolve2(items);
        } else if (rs instanceof DataTable) {
          for (var i2 = 0; i2 < tableItems.length; i2++) {
            rs.setByBkmk(-1);
            while (rs.next()) {
              item = Object.assign({}, tableItems[i2]);
              if (tableItems[i2 - 1]) {
                item["pvalue"] = rs.getByKey(tableItems[i2 - 1].valueFieldKey);
                item["pkey"] = tableItems[i2 - 1].key;
              }
              if (tableItems[i2 + 1]) {
                item["zvalue"] = rs.getByKey(tableItems[i2 + 1].valueFieldKey);
                item["zkey"] = tableItems[i2 + 1].key;
              }
              var value = rs.getByKey(item.valueFieldKey);
              item["caption"] = rs.getByKey(item.captionFieldKey);
              item["value"] = value;
              if (items[items.length - 1] && items[items.length - 1]["value"] == value)
                ;
              else {
                items.push(item);
              }
            }
          }
          resolve2(items);
        } else if (Utils.isArray(rs)) {
          resolve2(items.concat(rs));
        } else if (rs && Utils.isArray(rs.items)) {
          resolve2(items.concat(rs.items));
        } else {
          resolve2(items);
        }
      });
    } else {
      resolve2(items);
    }
  });
};
class WizardListHandler extends BaseHandler {
  static async getItems(control, prop, loc) {
    var form = control.getForm();
    var sourceType = prop.itemList.sourceType;
    var cxt;
    if (loc) {
      cxt = new ViewContext(form);
      cxt.updateLocation(loc.getKey(), loc.getRow(), -1);
    }
    var cacheKey = await getCacheKey$2(form, prop, cxt);
    if (cacheKey) {
      var items = cache$a.get(cacheKey);
      if (items) {
        return items;
      }
    }
    if (sourceType == WizardListItemType.DATA) {
      var items = await getDataItems(form, prop);
      if (prop.cache && cacheKey) {
        cache$a.set(cacheKey, items);
      }
      return items;
    } else if (sourceType == WizardListItemType.Formula) {
      var items = await getFormulaItems$1(form, prop, cxt);
      if (cacheKey) {
        cache$a.set(cacheKey, items);
      }
      return items;
    } else {
      return prop.items;
    }
  }
}
var __defProp$3 = Object.defineProperty;
var __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor;
var __decorateClass$3 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target;
  for (var i2 = decorators.length - 1, decorator; i2 >= 0; i2--)
    if (decorator = decorators[i2])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$3(target, key, result);
  return result;
};
class ToggleButtonHandler extends BaseHandler {
  static doOnClick(btn, formula, key, eventTarget) {
    var form = btn.getForm();
    var click = function() {
      var key2 = btn.key;
      HeadInfoUtil.put(btn, HeadInfoOptType.STR_BUTTON, form.formID);
      if (form.getEvent(key2)) {
        return form.doEvent(key2).always(function() {
          HeadInfoUtil.clear();
        });
      } else {
        var cxt = new ViewContext(form);
        eventTarget && (cxt.eventTarget = eventTarget);
        return form.asyncEval(formula, cxt).then(function(ret) {
          return ret;
        }).finally(function() {
          HeadInfoUtil.clear();
        });
      }
    };
    return click();
  }
}
__decorateClass$3([
  CompEventListener()
], ToggleButtonHandler, "doOnClick", 1);
class CollapsePanelHandler {
  static async doOnExpand(control, index) {
    var onExpand = control.items[index].onExpand;
    if (onExpand) {
      var form = control.getForm();
      var cxt = new ViewContext(form);
      return form.asyncEval(onExpand, cxt);
    } else {
      return null;
    }
  }
  static async doOnCollapse(control, index) {
    var onCollapse = control.items[index].onCollapse;
    if (onCollapse) {
      var form = control.getForm();
      var cxt = new ViewContext(form);
      return form.asyncEval(onCollapse, cxt);
    } else {
      return null;
    }
  }
}
class DictPaneHandler extends DictHandler {
}
class DictSearchBoxHandler extends DictHandler {
}
class AttachField {
}
AttachField.PATH = "Path";
AttachField.NAME = "Name";
AttachField.UPLOAD_TIME = "UploadTime";
AttachField.UPLOAD_OPERATOR = "UploadOperator";
AttachField.FILE_SIZE = "FileSize";
AttachField.UPLOAD_OPERATOR_ID = "UploadOperatorID";
class UploadFileHandler extends BaseHandler {
  static async uploadFile(formParam, $file, params) {
    var form;
    if (typeof formParam == "object") {
      form = formParam;
    } else {
      form = FormStack.getForm(formParam);
    }
    var tableKey = params.tableKey;
    if (!tableKey) {
      var loc = params && params.loc;
      if (loc) {
        tableKey = form.getComponent(loc.key).tableKey;
      } else {
        tableKey = form.mainTableKey;
      }
    }
    var doc = form.getDocument(), table;
    if (doc) {
      table = doc.getByKey(tableKey);
    }
    var oid = form.getOID();
    if (oid == -1) {
      oid = form.getPara("OID") || -1;
    }
    var grid;
    if (tableKey) {
      grid = form.getGrid(tableKey);
    }
    var path = "", rowIndex = -1;
    if (grid) {
      rowIndex = grid.getFocusRowIndex();
      var row = grid.getRowDataAt(rowIndex);
      if (row.bkmkRow) {
        table.setByBkmk(row.bkmkRow.getBookmark());
        if (table.indexByKey(AttachField.PATH) != null) {
          path = TypeConvertor.toString(table.getByKey(AttachField.PATH));
        }
      }
    } else {
      if (table) {
        table.first();
        if (table.indexByKey(AttachField.PATH) != null) {
          path = TypeConvertor.toString(table.getByKey(AttachField.PATH));
        }
      }
    }
    try {
      var info = FileUtil.checkFile({
        maxSize: params.maxSize,
        types: params.types && params.types.split(";"),
        file: $file
      });
    } catch (error) {
      throw error;
    }
    var paras = {
      file: $file,
      path: encodeURIComponent(path),
      fileName: info.fileName,
      fieldKey: params.fieldKey,
      deleteOld: params.deleteOld,
      processKey: params.processKey,
      provider: params.provider,
      parameters: form.getParas().toJSON()
    };
    var self = this;
    var o = await new RemoteService().uploadFile(form.formKey, oid, paras);
    if (params.processKey && o.isDoc) {
      var doc1 = DataUtil$1.fromJSONDoc(o);
      form.setDocument(doc1);
      await form.showDocument();
      await self.doCallBack(form, grid, params, o, rowIndex);
    } else if (params.processKey) {
      await self.doCallBack(form, grid, params, o, rowIndex);
    } else {
      var keys = Object.keys(AttachField);
      for (var i2 = 0; i2 < keys.length; i2++) {
        var key = keys[i2];
        var field = AttachField[key];
        if (field === AttachField.UPLOAD_OPERATOR_ID) {
          continue;
        }
        if (grid) {
          var cell = form.getCellByDataBinding(tableKey, field);
          if (cell == null && field === AttachField.UPLOAD_OPERATOR) {
            cell = form.getCellByDataBinding(tableKey, AttachField.UPLOAD_OPERATOR_ID);
          }
          if (cell) {
            await grid.setValueByKey(rowIndex, cell.key, o[field], true, true, true);
          }
        } else {
          var comp = form.getCompByDataBinding(tableKey, field);
          if (comp == null && field === AttachField.UPLOAD_OPERATOR) {
            comp = form.getCompByDataBinding(tableKey, AttachField.UPLOAD_OPERATOR_ID);
          }
          if (comp) {
            await comp.setValue(o[field], true, true, true);
          }
        }
      }
      await self.doCallBack(form, grid, params, o, rowIndex);
    }
  }
  static doCallBack(form, grid, params, o, rowIndex) {
    if (params.callback) {
      if (params.processKey) {
        if (!o.isDoc) {
          form.setPara("Return", o);
        }
      } else {
        Object.keys(o).forEach((key) => {
          form.setPara(key, o[key]);
        });
      }
    }
    var cxt = null;
    if (grid) {
      cxt = new ViewContext(form);
      cxt.updateLocation(grid.key, rowIndex, -1);
    }
    return form.asyncEval(params.callback, cxt).then(function() {
      Object.keys(o).forEach((key) => {
        form.rmvPara(o[key]);
      });
      form.rmvPara("Return");
    }).catch(function(e) {
      throw e;
    });
  }
  static deleteFile() {
  }
  static filterFileType(ofFormID, allowedTypesFormula) {
    var form = FormStack.getForm(ofFormID);
    var cxt = new ViewContext(form);
    return form == null ? void 0 : form.asyncEval(allowedTypesFormula, cxt).then(function(ret) {
      return ret;
    }).catch(function(e) {
      throw e;
    });
  }
}
class BarCoderHandler extends BaseHandler {
}
class PopViewHandler extends BaseHandler {
  static doShowEvent(popv, formula) {
    var form = popv.getForm();
    var cxt = new ViewContext(form);
    return form.asyncEval(formula, cxt);
  }
  static doCloseEvent(popv, formula) {
    var form = popv.getForm();
    var cxt = new ViewContext(form);
    return form.asyncEval(formula, cxt);
  }
}
class RefreshControlHandler extends BaseHandler {
  static footerScriptEvent(rfc, formula) {
    var form = rfc.getForm();
    var cxt = new ViewContext(form);
    return form.asyncEval(formula, cxt);
  }
  static headerScriptEvent(rfc, formula) {
    var form = rfc.getForm();
    var cxt = new ViewContext(form);
    return form.asyncEval(formula, cxt);
  }
}
class BatchImageUploaderHandler extends BaseHandler {
  static uploadImage(control, batchImageUpload, params) {
    var form = control.getForm();
    FileUtil.checkFile({
      maxSize: control.maxSize,
      types: ImageTypes,
      file: batchImageUpload
    });
    var params = Object.assign({
      file: batchImageUpload
    }, params);
    return new RemoteService().batchImageUpload(form.formKey, form.getOID(), params);
  }
  static deleteImg(control, filePath) {
    return new RemoteService().deleteImage(control.getForm().formKey, filePath);
  }
  static downloadImg(control, filePath) {
    var form = control.getForm();
    var options2 = {
      formKey: form.formKey,
      path: filePath,
      provider: "",
      service: "DownloadAttachment",
      tableKey: form.mainTableKey || form.formKey
    };
    FileUtil.downLoadFile(options2);
  }
}
class TextAreaHandler2 extends BaseHandler {
  static getMobileFile(path) {
    return new RemoteService().getMobileFile(path);
  }
}
class CollectionViewHandler extends Utils.mix(BaseHandler, PageHandler, SelectHandler) {
  static async doOnRowClick(collecionView) {
    var rowClick = collecionView.rowClick;
    if (rowClick) {
      var form = collecionView.getForm();
      var cxt = new ViewContext(form);
      return form.asyncEval(rowClick, cxt);
    }
  }
  static async doOnRowDblClick(collecionView) {
    var rowDblClick = collecionView.rowDblClick;
    if (rowDblClick) {
      var form = collecionView.getForm();
      var cxt = new ViewContext(form);
      return form.asyncEval(rowDblClick, cxt);
    }
  }
}
class ChartHandler extends BaseHandler {
  static async doOnClick(chart2, formula) {
    var form = chart2.getForm();
    var cxt = new ViewContext(form);
    var params = chart2.getCompData();
    cxt.setCompData(params);
    await form.asyncEval(formula, cxt);
  }
}
const cache$9 = new LRUCache(20);
const getCacheKey$1 = async (form, prop, cxt) => {
  if (prop.cache) {
    var data2 = {};
    data2["key"] = prop.key;
    data2["formKey"] = form.getFormKey();
    var dependency = prop.dependency;
    if (dependency) {
      await dependency.split(",").reduce(async (prev, field) => {
        await prev;
        var value = await form.__eval(field, cxt);
        data2[field] = value;
      }, true);
      return JSON.stringify(data2);
    }
    return JSON.stringify(data2);
  }
  return null;
};
const createFixedGetID = function(items) {
  let _items = [];
  if (items && items.length > 0) {
    for (var i2 = 0; i2 < items.length; i2++) {
      _items[i2] = items[i2];
      _items[i2]["getId"] = function() {
        return this.key;
      };
      if (items[i2].imageScaleType && Object.prototype.toString.call(items[i2].imageScaleType) == "[object String]") {
        var type = items[i2].imageScaleType.toLocaleUpperCase();
        _items[i2].imageScaleType = ImageScaleType[type];
      }
    }
  }
  return _items;
};
const getFormulaItems = function(form, prop, cxt) {
  var items = [];
  if (prop.formula) {
    return form.asyncEval(prop.formula, cxt).then(function(rs) {
      if (typeof rs === "string") {
        var item_Arr = rs.split(";");
        for (var i2 = 0, len = item_Arr.length; i2 < len; i2++) {
          var item_obj = item_Arr[i2].split(",");
          var item = {
            key: item_obj[0],
            caption: item_obj[1],
            image: item_obj[2],
            imageScaleType: item_obj[3]
          };
          items.push(item);
        }
        return items;
      } else if (rs instanceof DataTable) {
        rs.beforeFirst();
        if (rs.cols.length > 0) {
          while (rs.next()) {
            var item1 = {
              key: TypeConvertor.toString(rs.get(0)),
              caption: TypeConvertor.toString(rs.get(1)),
              image: TypeConvertor.toString(rs.get(2)),
              imageScaleType: TypeConvertor.toString(rs.get(3))
            };
            items.push(item1);
          }
          return items;
        }
      } else if (Utils.isArray(rs)) {
        for (var i2 = 0, len2 = rs.length; i2 < len2; i2++) {
          var item2 = {
            key: rs[i2].Key,
            caption: rs[i2].Caption,
            image: rs[i2].Image,
            imageScaleType: rs[i2].ImageScaleType
          };
          items.push(item2);
        }
        return items;
      } else if (rs && Utils.isArray(rs.items)) {
        return items.concat(rs.items);
      } else {
        return items;
      }
    });
  } else {
    return items;
  }
};
const getQueryItems = async (form, prop, cxt, defKey) => {
  var queryDef = prop.queryDef;
  var queryParas = queryDef && queryDef.queryParas;
  var paras = [];
  if (queryParas) {
    await queryParas.reduce(async (prev, para) => {
      await prev;
      var v;
      switch (para.sourceType) {
        case ComboboxParameterSourceType.CONST:
          v = para.value;
          break;
        case ComboboxParameterSourceType.FORMULA:
          v = await form.asyncEval(para.formula, cxt);
          break;
        case ComboboxParameterSourceType.FIELD:
          v = await form.asyncEval(para.fieldKey, cxt);
          break;
      }
      if (v instanceof Date) {
        v = v.getTime();
      }
      paras.push(v);
    }, true);
  }
  return new DataService(form).getQueryItems(form.formKey, prop.key, defKey, paras);
};
const deleteSubDetailData$1 = function(form, table) {
  let bookmark = table.getBkmk();
  if (bookmark == null || bookmark < 0) {
    return;
  }
  var subTables = form.getDocument().getByParentKey(table.key), subTable;
  for (var i2 = 0, size2 = subTables.length; i2 < size2; i2++) {
    subTable = subTables[i2];
    subTable.afterLast();
    while (subTable.previous()) {
      var POID = subTable.getByKey("POID");
      if (POID > 0 && table.getByKey("OID") === POID || subTable.getParentBkmk() == table.getBkmk()) {
        deleteSubDetailData$1(form, subTable);
        subTable.delRow();
      }
    }
  }
};
const setSystemColumIfNull = async function(doc, table, parentTable) {
  const oid = TypeConvertor.toLong(table.getByKey(SystemField.OID_SYS_KEY));
  const soid = TypeConvertor.toLong(table.getByKey(SystemField.SOID_SYS_KEY));
  const poid = TypeConvertor.toLong(table.getByKey(SystemField.POID_SYS_KEY));
  if (oid <= 0) {
    table.setByKey(SystemField.OID_SYS_KEY, await NewOIDCache.applyNewOID());
  }
  if (soid <= 0) {
    table.setByKey(SystemField.SOID_SYS_KEY, doc.oid);
  }
  if (parentTable && poid <= 0) {
    const parentOID = TypeConvertor.toLong(parentTable.getByKey(SystemField.OID_SYS_KEY));
    if (parentOID > 0) {
      table.setByKey(SystemField.POID_SYS_KEY, parentOID);
    }
  }
};
var depValChanged = function(form, editrow, loc, rowIndex, depend, fire) {
  return _depChanged(form, editrow, rowIndex, loc.column, depend, fire);
};
const _depChanged = async (form, editrow, rowIndex, colIndex, depend, fire) => {
  const editOpt = editrow.getCellDataAt(rowIndex, colIndex);
  if (editOpt.type == ControlType.DICT || editOpt.type == ControlType.DYNAMICDICT) {
    await dict_dependedValueChanged(form, editrow, rowIndex, editOpt.key, editOpt.value, editOpt, fire);
  } else {
    await editrow.__setValueAtImpl(rowIndex, editOpt.colkey, null, fire, fire, fire);
  }
};
const dict_dependedValueChanged = async (form, editrow, rowIndex, colkey, value, editOpt, fire) => {
  const cellDataValue = value && Utils.isArray(value) ? value[0] : value;
  if (!cellDataValue || cellDataValue.getOID() <= 0) {
    await editrow.setValueAt(rowIndex, colkey, null, fire, fire, fire);
    return;
  }
  let properties = editOpt.meta.properties;
  let itemKey = properties.itemKey;
  const stateMask = properties.stateMask;
  const cxt = new ViewContext(form);
  cxt.updateLocation(editrow.key, rowIndex, colkey);
  let handler = HandlerProvider.get(ControlType.DICT);
  if (editOpt.type == ControlType.DYNAMICDICT) {
    let location2 = new LocationInfo(editrow.key, rowIndex, colkey);
    if (properties.refDataElementKey) {
      itemKey = await handler.getItemKey(form, properties.refDataElementKey, location2);
    } else {
      itemKey = await handler.getItemKey(form, properties.refKey, location2);
    }
  }
  let dictFilter = await handler.getDictFilter(form, editOpt.meta, itemKey);
  let ret = await handler.createRoot(form, itemKey, properties.root, cxt);
  const item = await new DictService(form).getItemByOID(
    itemKey,
    0,
    10,
    3,
    cellDataValue.getOID(),
    stateMask,
    dictFilter,
    ret.root,
    form.formKey,
    editOpt.key
  );
  if (item && item != null) {
    await editrow.setValueAt(rowIndex, colkey, cellDataValue, fire, fire, fire);
  } else {
    await editrow.setValueAt(rowIndex, colkey, null, fire, fire, fire);
  }
};
class EditViewHandler extends Utils.mix(BaseHandler, PageHandler, SelectHandler) {
  /**
   * 处理值变化的后续逻辑
   */
  static async doValueChanged(editView, rowIndex, colkey, value, commitValue, editing, fireEvent) {
    var self = this, form = editView.getForm(), column = editView.columnMap[colkey], monitor = form.getViewDataMonitor();
    let colIndex = editView.indexMap[colkey];
    if (commitValue) {
      await self.setValueToDocument(form, editView, column, rowIndex, value);
    }
    await monitor.preCellValueChanged(editView, rowIndex, colIndex, column);
    if (editing) {
      await monitor.cellValueChanged(editView, rowIndex, colIndex, column);
    }
    if (fireEvent) {
      await self.fireEvent(form, editView, column, rowIndex, value);
    }
    return monitor.postCellValueChanged(editView, rowIndex, colIndex, column);
  }
  static setValueToDocument(form, editView, column, rowIndex, value) {
    var doc = form.getDocument();
    if (!doc)
      return;
    var table = doc.getByKey(editView.tableKey);
    if (!table)
      return;
    let rowData = editView.getRowDataAt(rowIndex);
    table.setByBkmk(rowData.bkmkRow.getBookmark());
    this.setValueToDataTable(form, table, column, value);
    UIDictRelationProcess.processGridCell(form, editView, rowIndex, editView.indexMap[column.key], editView.columnMap[column.key], true);
  }
  static setValueToDataTable(form, table, column, newValue) {
    var columnKey = column.columnKey, itemKey = "", dataElementKey = "";
    if (!columnKey)
      return;
    var cellType = column.type;
    switch (cellType) {
      case ControlType.DYNAMICDICT:
      case ControlType.DICT:
        var prop = column.properties;
        if (newValue == null) {
          if (prop.multiSelect) {
            table.setByKey(columnKey, null);
          } else {
            table.setByKey(columnKey, 0);
          }
          break;
        }
        if (prop.multiSelect) {
          var oids = [];
          for (var i2 = 0, len = newValue.length; i2 < len; i2++) {
            oids.push(newValue[i2].oid);
            oids.push(",");
          }
          if (oids && oids.length > 0) {
            oids.pop();
            itemKey = newValue[0].itemKey;
          }
          dataElementKey = newValue[0].dataElementKey;
          table.setByKey(columnKey, oids.join(""));
        } else {
          table.setByKey(columnKey, newValue.oid);
          if (cellType == ControlType.COMPDICT) {
            table.setByKey(columnKey + "ItemKey", newValue.itemKey);
          }
          dataElementKey = newValue.dataElementKey;
          itemKey = newValue.itemKey;
        }
        if (cellType == ControlType.DYNAMICDICT) {
          let refDataElementKey = prop.refDataElementKey;
          if (refDataElementKey) {
            let dataElementCmp = form.getCellLocation(refDataElementKey);
            if (!dataElementCmp) {
              throw COMPONENT_NOT_EXISTS(refDataElementKey);
            }
            refDataElementKey = dataElementCmp.columnKey;
            table.setByKey(refDataElementKey, dataElementKey);
          } else {
            table.setByKey(columnKey + "ItemKey", itemKey);
          }
        }
        break;
      default:
        var tableColumn = table.getColByKey(columnKey);
        var val = HandlerProvider.get().convertValue(newValue, tableColumn.type);
        table.setByKey(columnKey, val);
        break;
    }
  }
  static flushRow(editView, detailRow) {
    var columnInfo = editView.columnInfo, column;
    let form = editView.getForm();
    let document2 = form.getDocument();
    if (!document2)
      return;
    let table = document2.getByKey(editView.tableKey);
    if (!table)
      return;
    table.addRow(true);
    detailRow.setBkmkRow(new DetailRowBkmk(table.getBkmk()));
    var parentBkmk = null;
    if (editView.isSubDetail) {
      var parentIndex = editView.contextHook ? editView.contextHook().rowIndex : -1;
      if (parentIndex == -1) {
        return false;
      }
      var parentRow = editView.parentGrid.getRowDataAt(parentIndex);
      if (parentRow) {
        if (!parentRow.bkmkRow) {
          return false;
        }
        parentBkmk = parentRow.bkmkRow.getBookmark();
        if (parentBkmk != null) {
          table.setParentBkmk(parentBkmk);
        }
      }
    }
    for (var k = 0, len = columnInfo.length; k < len; k++) {
      column = columnInfo[k];
      if (column.columnKey) {
        this.setValueToDataTable(form, table, column, detailRow.getValueAt(column.key));
      }
    }
    let pTable;
    if (editView.isSubDetail) {
      const pGrid = editView.parentGrid, parentRow2 = pGrid.getRowDataAt(pGrid.getFocusRowIndex());
      pTable = document2.getByKey(pGrid.tableKey);
      if (!parentRow2) {
        table.rows[table.pos].parentBkmk = pTable.pos;
        pTable.setByBkmk(pTable.pos);
      } else {
        table.rows[table.pos].parentBkmk = parentRow2.bkmkRow.getBookmark();
        pTable.setByBkmk(parentRow2.bkmkRow.getBookmark());
      }
    }
    setSystemColumIfNull(document2, table, pTable);
  }
  static dependCellValueChange(editView, rowIndex, target, depend) {
    var form = editView.getForm();
    var loc = form.getCellLocation(target);
    return depValChanged(form, editView, loc, rowIndex, depend, true);
  }
  static async doOnRowActionClick(editView, actionIndex) {
    var rowInfo = editView.rowInfo;
    if (!rowInfo) {
      return null;
    }
    var actions = rowInfo.actionCollection;
    if (!actions) {
      return null;
    }
    var content = actions[actionIndex] && actions[actionIndex].content;
    if (content) {
      var form = editView.getForm();
      var cxt = new ViewContext(form);
      return await form.asyncEval(content, cxt);
    }
  }
  static async doOnMoreItemClick(editView) {
    var content = editView.moreItem && editView.moreItem.content;
    if (content) {
      var form = editView.getForm();
      var cxt = new ViewContext(form);
      return await form.asyncEval(content, cxt);
    }
    return null;
  }
  /**
   * action点击
   */
  static async doOnNactionBarClick(editView, rowIndex, colIndex) {
    var form = editView.getForm();
    var column = editView.columnInfo[colIndex];
    var clickContent = column.properties.action;
    if (clickContent) {
      var cxt = new ViewContext(form);
      cxt.updateLocation(editView.key, rowIndex, -1);
      return await form.asyncEval(clickContent, cxt);
    }
    return null;
  }
  /**
   * Image点击
   */
  static async doOnImageClick(editView, rowIndex, colIndex) {
    var form = editView.getForm();
    var column = editView.columnInfo[colIndex];
    var clickContent = column.properties.onClick;
    if (clickContent) {
      var cxt = new ViewContext(form);
      cxt.updateLocation(editView.key, rowIndex, -1);
      return await form.asyncEval(clickContent, cxt);
    }
    return null;
  }
  // 获取当前tablerow总行数
  static getTotalCount(editView) {
    var form = editView.getForm();
    var doc = form.getDocument();
    if (editView.pageLoadType != PageLoadType.DB) {
      return doc.getByKey(editView.tableKey).size();
    }
    return RowCountUtil.getTotalRowCount(doc, editView.tableKey);
  }
  static doGoToPage(control, nextPage) {
    if (control.pageLoadType != PageLoadType.DB) {
      return control.load(false, null, true);
    } else {
      var form = control.getForm(), filterMap = form.getFilterMap(), filterType = filterMap.getType(), pageSize = control.pageRowCount, startRi = nextPage * pageSize, tableKey = control.tableKey;
      filterMap.setOID(form.getOID());
      filterMap.setType(DocumentType.DETAIL);
      filterMap.getTblFilter(tableKey).startRow = startRi;
      filterMap.getTblFilter(tableKey).maxRows = pageSize;
      return new DocService(form).loadFormData(form).then(function(doc) {
        var document2 = form.getDocument(), dataTable = doc == null ? void 0 : doc.getByKey(tableKey), oldTable = document2.getByKey(tableKey);
        if (dataTable.size() > 0) {
          dataTable.beforeFirst();
          while (dataTable.next()) {
            oldTable.addRow(true);
            for (let index = 0; index < oldTable.getColumnCount(); index++) {
              let newValue = dataTable.get(index);
              oldTable.set(index, newValue);
            }
          }
          return control.load(false, null, true);
        } else {
          control.setNeedLoad(false);
        }
      }).finally(function() {
        filterMap.setType(filterType);
        filterMap.getTblFilter(tableKey).startRow = 0;
      });
    }
  }
  /**
   * 显示一行明细(同步)
   */
  static showDetailRow(form, editView, rowIndex) {
    var document2 = form.getDocument();
    var tableKey = editView.tableKey;
    if (!tableKey)
      return;
    var table = document2.getByKey(tableKey);
    for (var m = 0, size2 = editView.columnInfo.length; m < size2; m++) {
      var column = editView.columnInfo[m];
      var columnKey = column.columnKey;
      var value = null;
      if (columnKey) {
        value = table.getByKey(columnKey);
      } else if (m == editView.selectFieldIndex) {
        if (editView.pageLoadType == PageLoadType.DB) {
          if (ViewUtil.findShadowBkmk(document2, editView.tableKey) != -1) {
            value = true;
          }
        } else {
          value = table.getByKey(SystemField.SELECT_FIELD_KEY);
        }
      } else {
        if (column.columnType == ControlType.HYPERLINK || column.columnType == ControlType.BUTTON || column.columnType == ControlType.LABEL) {
          value = column.caption;
        } else if (column.columnType == ControlType.HYPERLINK) {
          value = false;
        }
      }
      editView.__setValueAt(rowIndex, m, value);
    }
  }
  static checkError(editView) {
    var focusRowIndex = editView.getFocusRowIndex();
    if (focusRowIndex !== -1) {
      var exception = this.checkRowError(editView, focusRowIndex);
      if (typeof exception !== "undefined" && exception !== null) {
        return exception;
      }
    }
    for (var ri = 0, size2 = editView.getRowCount(); ri < size2; ri++) {
      var exception = this.checkRowError(editView, ri);
      if (typeof exception !== "undefined" && exception !== null) {
        return exception;
      }
    }
  }
  static checkRowError(editView, rowIndex) {
    let rowData = editView.getRowDataAt(rowIndex);
    if (!rowData)
      return;
    if (!rowData.bkmkRow)
      return null;
    let exception, ci = 0;
    for (let key in rowData.comsMap) {
      let cellData = rowData.comsMap[key];
      if (cellData.errorInfo.error) {
        exception = this.getCellError(editView, cellData, rowIndex + 1);
      } else if (cellData.required) {
        exception = this.getCellReq(editView, cellData, rowIndex + 1);
      }
      if (typeof exception !== "undefined" && exception !== null) {
        return exception.setSourceComponent({ key: editView.key, rowIndex, ci, cellError: true });
      }
    }
  }
  static getCellReq(editView, cell, lineNo) {
    return GRID_CELL_REQUIRED(editView.caption, lineNo, cell.meta.caption);
  }
  static getCellError(editView, cell, lineNo) {
    let msg = cell.errorInfo.errorMsg;
    if (msg) {
      msg = GRID_CELL_ERROR(editView.caption, lineNo, cell.meta.caption, cell.getErrorMsg());
    }
    return msg;
  }
  /**
   * 新增行事件
   */
  static rowInsert(editView, rowIndex) {
    return editView.getForm().getUIProcess().doCalcOneRow(editView, rowIndex);
  }
  /**
   * 删除行事件
   */
  static rowDelete(editView, rowIndex) {
    return editView.getForm().getUIProcess().doPostDeleteRow(editView);
  }
  /** 
   * 固定项相关
   * 与下拉框一致，这里用下拉框判断
   *
   */
  static async getItems(editView, prop, loc, defKey) {
    var form = editView.getForm();
    var sourceType, items;
    if (prop.formula) {
      sourceType = 1;
    } else {
      sourceType = 0;
    }
    var cxt;
    if (loc) {
      cxt = new ViewContext(form);
      cxt.updateLocation(loc.getKey(), loc.getRow(), -1);
    }
    switch (sourceType) {
      case ComboboxSourceType.ITEMS:
      case ComboboxSourceType.STATUS:
      case ComboboxSourceType.PARAGROUP:
        return createFixedGetID(prop.items);
      case ComboboxSourceType.FORMULA:
        var cacheKey = await getCacheKey$1(form, prop, cxt);
        if (cacheKey) {
          var items = cache$9.get(cacheKey);
          if (items) {
            return createFixedGetID(items);
          }
        }
        var items = await getFormulaItems(form, prop, cxt);
        if (cacheKey) {
          cache$9.set(cacheKey, items);
        }
        return createFixedGetID(items);
      case ComboboxSourceType.QUERY:
        var cacheKey = await getCacheKey$1(form, prop, cxt);
        if (cacheKey) {
          var items = cache$9.get(cacheKey);
          if (items) {
            return createFixedGetID(items);
          }
        }
        var items = await getQueryItems(form, prop, cxt);
        if (prop.cache && cacheKey) {
          cache$9.set(cacheKey, items);
        }
        return createFixedGetID(items);
    }
    return createFixedGetID(items);
  }
  static getShowCaption(sourceType, items, value, multiSelect, editable) {
    if (!items)
      return "";
    var getItemCaption = function(v) {
      for (var i22 = 0, item; item = items[i22]; i22++) {
        if (item.value == v) {
          return item.caption || "";
        }
      }
      return "";
    };
    var caption = "";
    if (value != null && value !== "") {
      switch (sourceType) {
        case ComboboxSourceType.QUERY:
          caption = value;
          break;
        default:
          if (multiSelect) {
            value = TypeConvertor.toString(value);
            var values = value.split(",");
            for (var i2 = 0, len = values.length; i2 < len; i2++) {
              if (i2 > 0) {
                caption += ",";
              }
              caption += getItemCaption(values[i2]);
            }
          } else {
            caption = getItemCaption(value);
          }
          break;
      }
    }
    if (!caption && editable) {
      caption = TypeConvertor.toString(value);
    }
    return caption;
  }
  static getValByCaption(items, caption) {
    var getItemVal2 = function(text) {
      for (var i2 = 0, item; item = items[i2]; i2++) {
        if (item.caption == text) {
          return item.value;
        }
      }
      return "";
    };
    var texts = caption.split(","), v;
    for (var k = 0, size2 = texts.length; k < size2; k++) {
      if (!v) {
        v = getItemVal2(texts[k]);
      } else {
        v += "," + getItemVal2(texts[k]);
      }
    }
    return v;
  }
  static async doOnClick(formID2, formula) {
    var form = FormStack.getForm(formID2);
    return await (form == null ? void 0 : form.asyncEval(formula));
  }
  static async doOnTailClick(editView, formula) {
    return await editView.getForm().asyncEval(formula);
  }
  /**
  * ListView行点击
  */
  static async doOnRowClick(editView, rowIndex) {
    var rowClick = editView.rowClick;
    if (rowClick) {
      try {
        LoadingUtil.show();
        var form = editView.getForm();
        var cxt = new ViewContext(form);
        cxt.updateLocation(editView.key, rowIndex, -1);
        await form.asyncEval(rowClick, cxt);
      } finally {
        LoadingUtil.hide();
      }
    }
  }
  /**
   * ListView行双击
   */
  static async doOnRowDblClick(editView, rowIndex) {
    var rowDblClick = editView.rowDblClick;
    if (rowDblClick) {
      try {
        LoadingUtil.show();
        var form = editView.getForm();
        var cxt = new ViewContext(form);
        cxt.updateLocation(editView.key, rowIndex, -1);
        await form.asyncEval(rowDblClick, cxt);
      } finally {
        LoadingUtil.hide();
      }
    }
  }
  /**
   * ListView焦点切换
   */
  static async doOnRowChanged(editView, rowIndex) {
    var form = editView.getForm();
    if (!form) {
      return;
    }
    await form.getUIProcess().doAfterRowChanged(editView);
    let subdetails = form.getSubDetail(editView.key);
    if (subdetails) {
      var rowData = editView.getRowDataAt(rowIndex);
      let contextHook = null;
      if (rowData) {
        contextHook = ((rowData2) => {
          return () => {
            return {
              key: editView.key,
              rowIndex: editView.getRowIndex(rowData2)
            };
          };
        })(rowData);
      }
      subdetails.forEach((sub) => sub.contextHook = contextHook);
    }
    if (editView.hasSubDetail) {
      await SubDetailUtil.doChain(form, editView, true);
    }
    var focusRowChanged = editView.focusRowChanged;
    if (focusRowChanged) {
      var cxt = new ViewContext(form);
      cxt.updateLocation(editView.key, rowIndex, -1);
      return await form.asyncEval(focusRowChanged, cxt);
    }
  }
  /**
   * Button点击
   */
  static async doOnBtnClick(editView, rowIndex, colIndex) {
    var form = editView.getForm();
    var column = editView.columnInfo[colIndex];
    var clickContent = column.properties.onClick;
    if (clickContent) {
      var cxt = new ViewContext(form);
      cxt.updateLocation(editView.key, rowIndex, -1);
      return await form.asyncEval(clickContent, cxt);
    }
  }
  /**
   * HyperLink点击
   */
  static async doOnHlkClick(editView, rowIndex, colIndex) {
    var form = editView.getForm();
    var column = editView.columnInfo[colIndex];
    var p2 = column.properties, url = p2.url;
    if (p2.formulaURL) {
      await form.asyncEval(p2.formulaURL);
    }
    if (url) {
      if (p2.targetType == HyperLinkShowType.NEW) {
        window.open(url, HyperLinkTarget.NEW, "alwaysRaised=yes");
      } else if (p2.targetType == HyperLinkShowType.NEWTAB) {
        window.open(url);
      } else if (p2.targetType == HyperLinkShowType.CURRENT) {
        window.open(url, HyperLinkTarget.CURRENT);
      }
    } else {
      if (p2.onClick) {
        var cxt = new ViewContext(form);
        cxt.updateLocation(editView.key, rowIndex);
        return await form.asyncEval(p2.onClick, cxt);
      }
    }
  }
  //TODO
  static doOnChkClick(editView, rowIndex, colIndex, value, shiftDown) {
    var column = editView.columnInfo[colIndex];
    if (shiftDown && !column.singleSelect) {
      var focusIndex = editView.getFocusRowIndex();
      focusIndex = focusIndex == -1 ? rowIndex : focusIndex;
      var start = Math.min(focusIndex, rowIndex);
      var end = Math.max(focusIndex, rowIndex);
      return this.selectMulti(editView, start, end + 1, colIndex, value);
    } else {
      return editView.setValueAt(rowIndex, colIndex, value, true);
    }
  }
  /**
   * 删除ListView数据行
   */
  static deleteData(editView, rowData) {
    var form = editView.getForm();
    var doc = form.getDocument(), tableKey = editView.tableKey;
    var shadowTbl = doc.getShadow(tableKey);
    var table = doc.getByKey(tableKey);
    table.setByBkmk(rowData.bkmkRow.getBookmark());
    if (shadowTbl) {
      var bookmark = ViewUtil.findShadowBkmk(doc, tableKey);
      if (bookmark != -1) {
        shadowTbl.setState(DataDef.R_New);
        shadowTbl.delRow();
        editView.selectCount--;
      }
    } else {
      var index = table.indexByKey(SystemField.SELECT_FIELD_KEY);
      if (index != null) {
        var selValue = table.get(index);
        if (selValue) {
          editView.selectCount--;
        }
      }
    }
    deleteSubDetailData$1(form, table);
    table.delRow();
  }
  static sort(editView, index, order) {
    var column = editView.columnInfo[index], key = column.key;
    if (editView.sortType == MapDrawType$1.ALLPAGES) {
      var columnKey = column.dataBinding && column.dataBinding.columnKey;
      this.sortColumn(editView, columnKey, order);
    } else {
      editView.data.sort(function(row1, row2) {
        var v1 = row1[key].value;
        var v2 = row2[key].value;
        if (v1 == null && v2 == null) {
          return 0;
        }
        if (v1 !== null && v2 == null) {
          return order === "asc" ? -1 : 1;
        }
        if (v1 == null && v2 != null) {
          return order === "asc" ? 1 : -1;
        }
        switch (column.columnType) {
          case ControlType.DATEPICKER:
            var d1 = v1.getTime(), d2 = v2.getTime();
            return order === "asc" ? d1 - d2 : d2 - d1;
          case ControlType.DICT:
            var o1 = typeof v1.getOID == "function" ? v1.getOID() : v1, o2 = typeof v2.getOID == "function" ? v2.getOID() : v2;
            return order === "asc" ? o1 - o2 : o2 - o1;
          case ControlType.NUMBEREDITOR:
            return order === "asc" ? v1 - v2 : v2 - v1;
          default:
            var s1 = v1 + "", s2 = v2 + "";
            return order === "asc" ? s1.localeCompare(s2) : s2.localeCompare(s1);
        }
      });
      editView.repaintRows();
    }
  }
  static async sortColumn(control, columnKey, order) {
    var tableKey = control.tableKey, form = control.getForm();
    var filterMap = form.getFilterMap();
    var asc = true;
    if (order == "desc") {
      asc = false;
    }
    if (control.pageLoadType == PageLoadType.UI) {
      var document2 = form.getDocument();
      var dataTable = document2.getByKey(tableKey);
      dataTable.clearCriteria();
      dataTable.setSort(columnKey, asc);
      dataTable.sort();
      document2.setByKey(tableKey, dataTable);
      control.load();
    } else {
      filterMap.getTblFilter(tableKey).addOrderField(columnKey, asc);
      let doc = await new DocService(form).loadFormData(form);
      var document2 = form.getDocument();
      var dataTable = doc == null ? void 0 : doc.getByKey(tableKey);
      document2.setByKey(tableKey, dataTable);
      return control.load();
    }
  }
  static async fireEvent(form, grid, editOpt, rowIndex, newValue) {
    var rowData = grid.getRowDataAt(rowIndex);
    if (rowData.rowType != "Detail") {
      return;
    }
    if (grid.hasSubDetail && grid.getFocusRowIndex() == rowIndex) {
      var coms = form.getSubDetail(editOpt.key);
      if (coms) {
        coms.forEach((com) => com.__setValueImpl(newValue, false, true, false));
      }
    }
  }
  // 全选
  static async selectAll(editView, value) {
    var selectIndex = editView.selectFieldIndex;
    await editView.getDatas(true).reduce(async (prev, row, i2) => {
      await prev;
      if (row.isDetail && row.bkmkRow && editView.isCellEnable(i2, selectIndex)) {
        return editView.setValueAt(i2, selectIndex, value, true, true, true);
      }
    }, true);
  }
  static dealWithSequence(form, grid, rowIndex) {
    var SYS_SEQUENCE = SystemField.SEQUENCE_FIELD_KEY;
    var dataTable = form.getDocument().getByKey(grid.tableKey);
    if (dataTable.size() == 0) {
      return;
    }
    var seqIndex = dataTable.indexByKey(SYS_SEQUENCE);
    if (seqIndex == null) {
      return;
    }
    var bkmk, seq, curSeq = 0;
    if (rowIndex > 0) {
      bkmk = grid.data[rowIndex - 1].bkmkRow.bookmark;
      dataTable.setByBkmk(bkmk);
      curSeq = TypeConvertor.toInt(dataTable.getByKey(SYS_SEQUENCE));
    }
    for (var i2 = rowIndex, len = grid.data.length; i2 < len; i2++) {
      bkmk = grid.data[i2].bkmkRow.bookmark;
      dataTable.setByBkmk(bkmk);
      seq = TypeConvertor.toInt(dataTable.getByKey(SYS_SEQUENCE));
      if (seq == void 0 || seq == null || seq <= curSeq) {
        seq = curSeq + 1;
        dataTable.setByKey(SYS_SEQUENCE, seq);
      }
      curSeq = seq;
    }
  }
}
class VideoPlayerHandler extends BaseHandler {
  static getVideoPlayer(control, path) {
    if (path == "")
      return "";
    var _path = window.location.origin + "/" + ServletURL.split("/")[3] + "/";
    _path += "attach?service=DownloadAttachment&cmd=DownloadAttachment&formKey=" + control.ofFormKey + "&path=" + path + "&mode=" + Request$1.mode + "&sourceType=" + control.sourceType;
    return _path;
  }
  static selectVideo(control) {
    return InterActiveFactory.Interactive.selectVideoForUpload(control.ofFormKey, control.getForm().getOID(), "");
  }
  static takeVideo(control) {
    return InterActiveFactory.Interactive.takeVideoForUpload(control.ofFormKey, control.getForm().getOID(), "");
  }
  static uploadVideo(control, $videofile, params) {
    var form = control.getForm();
    var params = Object.assign({
      file: $videofile,
      deleteOld: true
    }, params);
    return new RemoteService(form).uploadAttachment(form.formKey, form.getOID(), params);
  }
}
class HoverButtonHandler extends ButtonHandler {
}
class ValidateBoxHandler extends BaseHandler {
  static getValidateImage() {
    return new RemoteService().queryValidateImage().then(function(validate) {
      if (validate && validate.result) {
        CookiesUtil.set("tmpClientID", validate.tempClinentID);
        return "data:image/png;base64," + validate.result.replace(/\s/g, encodeURIComponent(" "));
      }
    });
  }
}
class NavigationListHandler extends BaseHandler {
  static doItemOnClick(nav, _item) {
    var form = nav.getForm();
    var cxt = new ViewContext(form);
    return form.asyncEval(_item.onClick, cxt);
  }
  static async getItems(nav) {
    var cxt = new ViewContext(nav.getForm());
    var items = nav.items;
    if (nav.source == 1) {
      items = await new MetaService(cxt.form).getEntry(nav.entryPath, "");
    }
    return items;
  }
  static async goEntryPath(nav, entryPath) {
    var cxt = new ViewContext(nav.getForm());
    return await new MetaService(cxt.form).getEntry(entryPath, "");
  }
}
class CompDictHandler extends DictHandler {
  constructor() {
    super();
  }
  static async createRoot(form, itemKey, rootKey, cxt) {
    var rootItem = await this.getRoot(form, itemKey, rootKey, cxt);
    return new MetaService(form, false).getDataObject(itemKey).then((dataObj) => {
      var _a;
      var ret = {};
      rootItem.itemKey = (_a = dataObj.relation) == null ? void 0 : _a.items[0].itemKey;
      ret.root = rootItem;
      ret.secondaryType = dataObj.secondaryType;
      if (rootItem.getOID() == 0) {
        ret.rootCaption = dataObj.caption;
      } else if (rootItem.hasCaption()) {
        ret.rootCaption = rootItem.getCaption();
      } else {
        return new DictCacheProxy(form).getCaption(itemKey, rootItem.oid).then((caption) => {
          rootItem.caption = caption;
          ret.root = rootItem;
          ret.rootCaption = caption;
          return ret;
        });
      }
      return ret;
    });
  }
}
var __defProp$2 = Object.defineProperty;
var __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor;
var __decorateClass$2 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target;
  for (var i2 = decorators.length - 1, decorator; i2 >= 0; i2--)
    if (decorator = decorators[i2])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$2(target, key, result);
  return result;
};
class ImageListHandler extends BaseHandler {
  static doOnClick(formID2, formula, ...args) {
    return super.doOnClick(formID2, formula, ...args);
  }
}
__decorateClass$2([
  CompEventListener()
], ImageListHandler, "doOnClick", 1);
var __defProp$1 = Object.defineProperty;
var __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor;
var __decorateClass$1 = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target;
  for (var i2 = decorators.length - 1, decorator; i2 >= 0; i2--)
    if (decorator = decorators[i2])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result)
    __defProp$1(target, key, result);
  return result;
};
class NoticeBarHandler extends BaseHandler {
  static doOnClick(formID2, formula, ...args) {
    return super.doOnClick(formID2, formula, ...args);
  }
}
__decorateClass$1([
  CompEventListener()
], NoticeBarHandler, "doOnClick", 1);
HandlerProvider.reg(-1, BaseHandler);
HandlerProvider.reg(ControlType.BUTTON, ButtonHandler);
HandlerProvider.reg(ControlType.CHECKBOX, CheckBoxHandler);
HandlerProvider.reg(ControlType.HYPERLINK, HyperLinkHandler);
HandlerProvider.reg(ControlType.TEXTEDITOR, TextEditorHandler);
HandlerProvider.reg(ControlType.TEXTBUTTON, TextEditorHandler);
HandlerProvider.reg(ControlType.PASSWORDEDITOR, PasswordEditorHandler);
HandlerProvider.reg(ControlType.TEXTAREA, TextAreaHandler$1);
HandlerProvider.reg(ControlType.NUMBEREDITOR, NumberEditorHandler);
HandlerProvider.reg(ControlType.SPLITBUTTON, SplitButtonHandler);
HandlerProvider.reg(ControlType.TOOLBAR, ToolBarHandler);
HandlerProvider.reg(ControlType.DATEPICKER, DatePickerHandler);
HandlerProvider.reg(ControlType.COMBOBOX, ComboBoxHandler);
HandlerProvider.reg(ControlType.CHECKLISTBOX, CheckListBoxHandler);
HandlerProvider.reg(ControlType.DICT, DictHandler);
HandlerProvider.reg(ControlType.DYNAMICDICT, DictHandler);
HandlerProvider.reg(ControlType.COMPDICT, CompDictHandler);
HandlerProvider.reg(ControlType.DICTPANE, DictPaneHandler);
HandlerProvider.reg(ControlType.DICTSEARCHBOX, DictSearchBoxHandler);
HandlerProvider.reg(ControlType.DROPDOWNBUTTON, DropdownButtonHandler);
HandlerProvider.reg(ControlType.IMAGE, ImageHandler);
HandlerProvider.reg(ControlType.IMAGELIST, ImageListHandler);
HandlerProvider.reg(ControlType.MULTISTATEBUTTON, MultiStateButtonHandler);
HandlerProvider.reg(ControlType.DIALOG, DialogHandler);
HandlerProvider.reg(ControlType.TOGGLEBUTTON, ToggleButtonHandler);
HandlerProvider.reg(ControlType.UPLOADBUTTON, UploadFileHandler);
HandlerProvider.reg(ControlType.BATCHIMAGEUPLOADER, BatchImageUploaderHandler);
HandlerProvider.reg(ControlType.WEBBROWSER, TextAreaHandler2);
HandlerProvider.reg(ControlType.NOTICEBAR, NoticeBarHandler);
HandlerProvider.reg(ControlType.NAVIGATIONBAR, NavigationBarHandler);
HandlerProvider.reg(ControlType.DICTVIEW, DictViewHandler);
HandlerProvider.reg(ControlType.GRID, GridHandler);
HandlerProvider.reg(ControlType.LISTVIEW, ListViewHandler);
HandlerProvider.reg(ControlType.TABPANEL, TabPanelHandler);
HandlerProvider.reg(ControlType.WIZARDLIST, WizardListHandler);
HandlerProvider.reg(ControlType.PROGRESSINDICATOR, ProgressIndicatorHandler);
HandlerProvider.reg(ControlType.COUNTDOWNVIEW, CountDownViewHandler);
HandlerProvider.reg(ControlType.TIMECOUNTDOWN, TimeCountDownHandler);
HandlerProvider.reg(ControlType.CAROUSEL, CarouselHandler);
HandlerProvider.reg(ControlType.TABGROUP, TabGroupHandler);
HandlerProvider.reg(ControlType.MODULEEDITOR, ModuleEditorHandler);
HandlerProvider.reg(ControlType.TABLEVIEW, TableViewHandler);
HandlerProvider.reg(ControlType.COLLECTIONVIEW, CollectionViewHandler);
HandlerProvider.reg(ControlType.COLLAPSEPANEL, CollapsePanelHandler);
HandlerProvider.reg(ControlType.BARCODER, BarCoderHandler);
HandlerProvider.reg(ControlType.POPVIEW, PopViewHandler);
HandlerProvider.reg(ControlType.REFRESHCONTROL, RefreshControlHandler);
HandlerProvider.reg(ControlType.VIDEOPLAYER, VideoPlayerHandler);
HandlerProvider.reg(ControlType.HOVERBUTTON, HoverButtonHandler);
HandlerProvider.reg(ControlType.VALIDATEBOX, ValidateBoxHandler);
HandlerProvider.reg(ControlType.NAVIGATIONLIST, NavigationListHandler);
HandlerProvider.reg(ControlType.EDITVIEW, EditViewHandler);
HandlerProvider.reg(ControlType.TILEDLIST, EditViewHandler);
HandlerProvider.reg(ControlType.ROTATOR, EditViewHandler);
HandlerProvider.reg(ControlType.ROTATORLIST, EditViewHandler);
HandlerProvider.reg(ControlType.WATERFALL, EditViewHandler);
HandlerProvider.reg(ControlType.GALLERY, EditViewHandler);
HandlerProvider.reg(ControlType.CHART, ChartHandler);
class BasePanel extends BaseComponent {
  constructor(meta) {
    super(meta);
    this.defaultType = "component";
    this.overflowX = "visible";
    this.overflowY = "visible";
    this.backImage = "";
    this.backImagePosition = "";
    this.isBackImageRepeatX = false;
    this.isBackImageRepeatY = false;
    this.isPanel = true;
    this.items = [];
    this.layoutItems = null;
  }
  needClean() {
    return false;
  }
  isDataBinding() {
    return false;
  }
  setBackImage(backImage) {
    this.backImage = backImage;
    console.log("panel.setBackImage...............");
    this.impl && this.impl.setBackImage(backImage);
  }
  setBackImagePosition(backImagePosition) {
    if (backImagePosition >= 0) {
      this.backImagePosition = backImagePosition;
      console.log("pabel.setBackImagePosition..................");
      this.impl && this.impl.backgroundPosition(backImagePosition);
    }
  }
  setBackImageRepeat(backImageRepeat) {
    this.backImageRepeat = backImageRepeat;
    this.impl && this.impl.backgroundRepeat(backImageRepeat);
  }
  add(comp) {
    this.initItems();
    if (comp && this.beforeAdd(comp) !== false) {
      this.items.push(comp);
      comp.ownerCt = this;
      this.afterAdd(comp);
    }
  }
  beforeAdd(comp) {
    return true;
  }
  afterAdd(comp) {
  }
  reduceVisible(visible, comp) {
  }
  changeCaption(...args) {
  }
  /**
   * 获取某个item
   * @param comp 可能是控件id， 也可能是控件在items中的index
   */
  get(comp) {
    if (Utils.isNumeric(comp)) {
      return this.items[comp];
    } else if (Utils.isString(comp)) {
      var items = this.items, item;
      for (var i2 = 0, len = items.length; i2 < len; i2++) {
        item = items[i2];
        if (item && item.key === comp) {
          return item;
        }
      }
    }
    console.error("comp:" + comp + " not exists");
    return null;
  }
  /**
   * 控件在items中的位置
   * @param comp
   */
  indexOf(comp) {
    console.log("panel.indexof........");
    var items = this.items;
    for (var i2 = 0, len = items.length; i2 < len; i2++) {
      if (items[i2] === comp) {
        return i2;
      }
    }
    return -1;
  }
  /**
   * 从面板中删除控件
   * @param comp 将要删除的控件
   * @param autoDestroy 是否要销毁控件，如果此参数不提供，默认为销毁
   */
  remove(comp, autoDestroy) {
    var index = this.indexOf(comp);
    if (index === -1) {
      return;
    }
    if (autoDestroy === false) {
      comp.getEl().$remove();
    } else {
      comp.destroy();
    }
    this.items.splice(index, 1);
    return comp;
  }
  doActive() {
    if (this.items && this.items.length > 0) {
      for (var i2 = 0, len = this.items.length; i2 < len; i2++) {
        this.items[i2].doActive();
      }
    }
  }
  setTip() {
  }
  /** 确保包含items */
  initItems() {
    if (!this.items) {
      this.items = [];
    }
  }
  /**
   * 先destroy所有items
   */
  beforeDestroy() {
    var items = this.items;
    if (items) {
      let item;
      for (var i2 = items.length - 1; i2 >= 0; i2--) {
        item = items[i2];
        if (item && !item.isDestroyed) {
          item.destroy();
        }
        delete items[i2];
      }
    }
    delete this.items;
    super.beforeDestroy();
  }
  /**
   * 获取面板宽度。
   * @return Number。
   */
  getWidth() {
    if (this.rendered)
      ;
    return this.width;
  }
  /**
   * 获取面板高度。
   * @return Number。
   */
  getHeight() {
    if (this.rendered)
      ;
    return this.height;
  }
  /**
   * 面板不可见,不render
   */
  setVisible(visible) {
    this.needRender = visible;
    return super.setVisible(visible);
  }
  needTip() {
    return false;
  }
  getImageBase64URL(icon) {
    return new Base64ImageService(this.getForm()).loadBase64Image(icon);
  }
  reLayout() {
  }
  calcAutoHeight() {
    var items = this.items, item;
    var autoHeight = 0;
    for (var i2 = 0, len = items.length; i2 < len; i2++) {
      item = items[i2];
      autoHeight += item.calcAutoHeight() ? item.calcAutoHeight() : 0;
    }
    return autoHeight;
  }
  setTitleIcon(icon) {
    this.titleIcon = icon;
  }
}
class BorderLayoutPanel extends BasePanel {
  constructor(meta) {
    super(meta);
  }
  add(comp) {
    if (comp) {
      this.items.push(comp);
    }
  }
  get(i2) {
    return this.items[i2];
  }
}
class CollapsePanel extends BasePanel {
  constructor(meta) {
    super(meta);
  }
  doOnCollapse(index) {
    if (this.enable) {
      return this.handler.doOnCollapse(this, index);
    }
  }
  doOnExpand(index) {
    if (this.enable) {
      return this.handler.doOnExpand(this, index);
    }
  }
  reduceVisible(visible, comp) {
    this.impl && this.impl.reduceVisible(visible, comp);
  }
  beforeDestroy() {
    this.impl && this.impl.destroy();
  }
  collapseSwitch() {
    this.impl && this.impl.collapseSwitch();
  }
}
class ColumnLayoutPanel extends BasePanel {
  constructor(meta) {
    super(meta);
  }
}
class FlexFlowLayoutPanel extends BasePanel {
  constructor(meta) {
    super(meta);
    this.key = meta.key;
    this.type = meta.type;
    this.meta = meta;
    this.items = [];
  }
  add(comp) {
    if (comp) {
      comp.ownerCt = this;
      this.items.push(comp);
    }
  }
  get(i2) {
    return this.items[i2];
  }
  getPlaceholderSize() {
    var placeholderSize = 0, items = this.items, item;
    for (var i2 = 0, len = items.length; i2 < len; i2++) {
      item = items[i2].el;
      if (!Utils.isPercentage(item.getAttribute("height"))) {
        placeholderSize += item.height();
      }
    }
    return placeholderSize;
  }
}
class FlexGridLayoutPanel extends BasePanel {
  constructor(meta) {
    super(meta);
  }
}
class FlowLayoutPanel extends BasePanel {
  constructor(meta) {
    super(meta);
  }
}
class FluidTableLayoutPanel extends BasePanel {
  constructor(meta) {
    super(meta);
    this.settings = Object.assign({
      widths: [],
      rowGap: 0,
      columnGap: 0,
      repeatCount: 1,
      repeatGap: 0,
      rowHeight: 30
    }, meta);
    this.widths = meta.layout.widths;
    var widths = this.widths;
    if (!widths) {
      throw "widths is undefined";
    }
  }
  reduceVisible(visible, comp) {
    this.impl && this.impl.reduceVisible(visible, comp);
  }
}
class SizeUtil {
  static getSize(size2) {
    var v = size2;
    if (Utils.isPercentage(size2))
      ;
    else if (Utils.isNumeric(size2))
      ;
    else if (size2 == "auto")
      ;
    else if (size2 == "pref")
      ;
    else {
      v = parseInt(size2);
    }
    return v;
  }
}
class GridLayoutPanel extends BasePanel {
  constructor(meta) {
    super(meta);
    this.extraLayout = meta.extraLayout;
  }
  doRender(container) {
    const extraLayoutType = this.getExtraLayoutType();
    if (extraLayoutType == "Property" && false)
      ;
    else if (extraLayoutType == "Collapsible") {
      super.doRender(container);
    } else {
      return super.doRender(container);
    }
  }
  doLayout(panelWidth, panelHeight) {
    console.log("gridpanel---doLayout");
    super.doLayout(panelWidth, panelHeight);
    this.impl && this.impl.layout1 && this.impl.layout1(panelWidth, panelHeight);
    this.customLayoutRender && this.customLayoutRender.resize(panelWidth, panelHeight);
  }
  async doPostShow() {
    let form = this.getForm();
    if (this.extraLayout) {
      let extraLayout = { ...this.extraLayout };
      let groupCollection = extraLayout.groupCollection;
      if (Array.isArray(groupCollection)) {
        for (let i2 = 0, group, expanded; i2 < groupCollection.length; i2++) {
          group = groupCollection[i2];
          if (group.expanded) {
            expanded = TypeConvertor.toString(group.expanded);
            const result = await form.asyncEval(expanded, new ViewContext(form));
            group.expanded = result;
          } else {
            group.expanded = true;
          }
        }
      } else {
        extraLayout.groupCollection = [];
      }
      this.extraLayout = extraLayout;
    }
  }
  setHeight(height) {
    super.setHeight(height);
    this.customLayoutRender && this.customLayoutRender.resize(this.getWidth(), height);
  }
  afterRender() {
    !this.isPropertyLayout() && super.afterRender();
  }
  getExtraLayoutType() {
    return this.meta.extraLayout ? this.meta.extraLayout.type : "";
  }
  isPropertyLayout() {
    const customLayoutType = this.getExtraLayoutType();
    return customLayoutType == "Property";
  }
  calcAutoHeight() {
    if (!this.impl)
      return 0;
    let autoHeight = 16;
    let heights = this.impl.heights;
    let sGridTemplateRows = this.impl.getEl().getStyle("grid-template-rows");
    if (sGridTemplateRows) {
      sGridTemplateRows = sGridTemplateRows.trim();
      heights = sGridTemplateRows.split(" ");
    }
    for (let i2 = 0, len = heights.length; i2 < len; i2++) {
      var rowHeight = SizeUtil.getSize(heights[i2]);
      autoHeight += rowHeight + (this.impl.rowGap ? this.impl.rowGap : 0);
    }
    return autoHeight;
  }
  reduceVisible(visible, comp) {
    this.impl && this.impl.reduceVisible(visible, comp);
  }
}
class LinearLayoutPanel extends BasePanel {
  constructor(meta) {
    super(meta);
    this.key = meta.key;
    this.type = meta.type;
    this.meta = meta;
    this.items = [];
  }
  // add(comp) {
  //     if (comp) {
  //         this.items.push(comp);
  //     }
  // }
  get(i2) {
    return this.items[i2];
  }
  getPlaceholderSize() {
    var placeholderSize = 0, items = this.items, item;
    for (var i2 = 0, len = items.length; i2 < len; i2++) {
      item = items[i2].el;
      if (!Utils.isPercentage(item.getAttribute("height"))) {
        placeholderSize += item.height();
      }
    }
    return placeholderSize;
  }
}
class SlidingLayoutPanel extends BasePanel {
  constructor(meta) {
    super(meta);
  }
  slidingPanelBykey(position, key) {
    return this.impl && this.impl.setSlidingPanel(position, key);
  }
  destroy() {
    this.firstPanel && this.firstPanel.destroy();
    this.secondPanel && this.secondPanel.destroy();
    super.destroy();
  }
}
class SplitLayoutPanel extends BasePanel {
  constructor(meta) {
    super(meta);
  }
  setOrientation(orientation) {
    this.orientation = orientation;
  }
  showItem(key) {
    if (this.impl) {
      this.impl.showItem(key);
    } else {
      this.layouts && this.layouts.forEach((item) => {
        if (item.key == key) {
          item.needShow = true;
          return;
        }
      });
    }
  }
  hideItem(key) {
    if (this.impl) {
      this.impl.hideItem(key);
    } else {
      this.layouts && this.layouts.forEach((item) => {
        if (item.key == key) {
          item.needHide = true;
          return;
        }
      });
    }
  }
  isCollapased(key) {
    return this.impl && this.impl.isCollapased(key);
  }
  doLayout(panelWidth, panelHeight) {
  }
}
class StackContainer extends BasePanel {
  constructor(meta) {
    super(meta);
    this.isReplace = false;
    this.formID = -1;
    this.defaultFormKey = "";
    this.formulaFormKey = "";
    this.mergeOperation = null;
    this.builder = null;
    this.formList = [];
  }
  add(form) {
    if (this.formList.length > 0) {
      let f = this.formList.shift();
      if (f && f.formID != form.formID) {
        f.destroy();
        FormStack.removeForm(f.formID);
      }
    }
    if (this.impl) {
      if (!this.isReplace) {
        if (this.formID && this.formID != form.formID) {
          FormStack.removeForm(this.formID);
          this.isReplace = false;
        }
      }
    }
    this.form = form;
    this.formID = form.formID;
    this.formList.push(form);
    this.impl.add(form);
  }
  /** 删除当前form，并取出之前缓存的form，并显示 */
  remove(comp, autoDestroy) {
    super.remove(comp, autoDestroy);
  }
  async render(target) {
    super.render(target);
    var formKey = this.defaultFormKey;
    var form = this.getForm();
    if (this.formulaFormKey) {
      var cxt = new ViewContext(form);
      formKey = await form.eval(this.formulaFormKey, cxt);
    }
    if (formKey) {
      var container = this;
      var builder = new FormBuilder(formKey);
      builder.setContainer(container);
      builder.setParentForm(form);
      container.builder = builder;
      return builder.newEmpty().then(function(emptyForm) {
        if (!emptyForm)
          return;
        container.form = emptyForm;
        container.formID = emptyForm.formID;
        try {
          if (container.parameters) {
            var containerParas = container.parameters.split(";");
            for (var i2 = 0, len = containerParas.length; i2 < len; i2++) {
              const para = containerParas[i2];
              const keyCaptionPair = para.split("=");
              if (keyCaptionPair.length > 1) {
                emptyForm.setPara(keyCaptionPair[0], keyCaptionPair[1]);
              }
            }
          }
        } catch (e) {
          console.error(e);
        }
        return builder.build(emptyForm);
      }).then(function() {
        if (container.mergeOperation) {
          return form.resetUIStatus(FormUIStatusMask.OPERATION);
        }
      });
    }
  }
  close(form) {
    this.remove(form.getRoot(), false);
    form && FormStack.removeForm(form.formID);
  }
  indexOf(comp) {
    console.log("panel.indexof........");
    var items = this.formList;
    for (var i2 = 0, len = items.length; i2 < len; i2++) {
      if (items[i2].getRoot() === comp) {
        return i2;
      }
    }
    return -1;
  }
  getActivePane() {
    return FormStack.getForm(this.formID);
  }
  removeForm(form) {
  }
  doActiveEvent() {
    if (this.form && this.form.formID != this.ofFormID) {
      this.form.doActiveEvent();
    }
  }
  destroy() {
    try {
      if (this.form && !this.form.isDestroyed) {
        this.close(this.form);
      }
    } finally {
      this.form && FormStack.removeForm(this.form.formID);
    }
    super.destroy();
  }
  isShow(formid) {
    var _a;
    return (_a = FormStack.getForm(this.ofFormID)) == null ? void 0 : _a.isShow();
  }
  getIsModal() {
    return false;
  }
}
class DirectionType {
  static parse(v) {
    if (!v) {
      return -1;
    }
    v = v.toUpperCase();
    var ret = this[v];
    return typeof ret == "undefined" ? -1 : ret;
  }
  static toString(v) {
    return v == this.TOP && this.STR_TOP || v == this.BOTTOM && this.STR_BOTTOM || v == this.LEFT && this.STR_LEFT || v == this.RIGHT && this.STR_RIGHT || v == this.CENTER && this.STR_CENTER || "";
  }
}
DirectionType.TOP = 0;
DirectionType.STR_TOP = "top";
DirectionType.BOTTOM = 1;
DirectionType.STR_BOTTOM = "bottom";
DirectionType.LEFT = 2;
DirectionType.STR_LEFT = "left";
DirectionType.RIGHT = 3;
DirectionType.STR_RIGHT = "right";
DirectionType.CENTER = 4;
DirectionType.STR_CENTER = "center";
class TabPanel extends BasePanel {
  constructor(meta) {
    super(meta);
    this.tabPosition = meta.tabPosition || DirectionType.TOP;
    this.zoom = true;
  }
  getComByKey(compKey) {
    var items = this.items, item;
    for (var i2 = 0, len = items.length; i2 < len; i2++) {
      item = items[i2];
      if (item && item.key === compKey) {
        return item;
      }
    }
    console.error("comp:" + compKey + " not exists");
    return null;
  }
  setTabPosition(tabPosition) {
    this.tabPosition = tabPosition;
  }
  doActiveEvent(com) {
    com.doActive();
    return this.handler.doActiveEvent(com);
  }
  doItemChanged() {
    return this.handler.doItemChanged(this);
  }
  changeCaption(comp) {
    this.impl && this.impl.changeCaption(comp);
  }
  reduceVisible(visible, comp) {
    this.impl && this.impl.reduceVisible(visible, comp);
  }
  setActiveTab(activeTabKey) {
    this.impl && this.impl.selectTab(activeTabKey);
  }
  getActiveTab() {
    return this.impl && this.impl.selectedTabKey();
  }
  setSelectTabIndex(tabIndex) {
    if (this.items[tabIndex] && this.items[tabIndex].visible) {
      this.impl && this.impl.selectTab(this.items[tabIndex].key);
    }
  }
  getSelectTabIndex() {
    return this.impl && this.impl.getTabIndex();
  }
  doLayout(panelWidth, panelHeight) {
  }
  isMax() {
    return this.impl && this.impl.isMax();
  }
  doRevert() {
    return this.impl && this.impl.doRevert();
  }
  doUpdateItem(key) {
    this.impl && this.impl.doUpdateItem(key);
  }
}
class DictTraceHandler {
  constructor(options2) {
    this.init(options2);
  }
  async init(options2) {
    options2.form;
    const meta = options2.meta;
    this.meta = meta;
    options2.itemKey;
  }
  async isDictValueCanPopup(form, meta, value) {
    if (!meta) {
      meta = this.meta;
    }
    if (form.getContainer() instanceof StackContainer && form.getContainer().getForm().getContainer() instanceof ModalContainer || form.getContainer() instanceof ModalContainer) {
      return false;
    }
    if (!value) {
      return false;
    }
    const oid = value.oid;
    if (oid <= 0) {
      return false;
    }
    const type = meta.cellType || meta.type;
    if (ControlType.DYNAMICDICT == type) {
      const itemKey = value.itemKey;
      if (itemKey && itemKey.indexOf("__Dic") > 0) {
        const popDictOID = await form.asyncEval("Macro_getPopupDictOIDByItemKey('" + itemKey + "','" + oid + "')");
        return popDictOID > 0;
      }
      return true;
    }
    return true;
  }
  async dictTracePopup(form, metaKey, value) {
    const itemKey = value == null ? void 0 : value.itemKey;
    if (!itemKey) {
      return;
    }
    var oid = value.oid;
    if (itemKey.indexOf("__Dic") > 0) {
      oid = await form.asyncEval("Macro_getPopupDictOIDByItemKey('" + itemKey + "','" + oid + "')");
    }
    if (oid > 0) {
      const formulaText = "OpenDictTrace('" + itemKey + "','" + oid + "','" + metaKey + "')";
      await form.asyncEval(formulaText);
    } else {
      console.warn("请选择当前字典值进行追溯");
    }
  }
  getControlValue(form, fieldKey, ri = NaN, ci = NaN) {
    const loc = form.getCellLocation(fieldKey);
    const cxt = new ViewContext(form);
    if (loc) {
      cxt.updateLocation(loc.key, ri, ci);
      const com = form.getComponent(loc.key);
      if (com && ri < com.getRowCount()) {
        return form.getValue(fieldKey, cxt);
      } else {
        return null;
      }
    } else {
      return form.getValue(fieldKey, cxt);
    }
  }
}
class Dict extends BaseControl {
  constructor(meta) {
    super(meta);
    this.itemKey = meta.properties.itemKey;
    this.cacheData = null;
    this.isEditValue = meta.properties.isEditValue;
    this.stateMask = meta.properties.stateMask;
  }
  setShowText(text) {
    if (this.impl._textBtn) {
      this.impl._textBtn.$setInputValue(text);
    }
  }
  async calcNeedRebuildBase(targetField, dependedField) {
    const form = this.getForm();
    const meta = this.getMetaObj();
    const properties = meta.properties;
    if (meta.type == ControlType.DYNAMICDICT) {
      const refDataElementKey = properties.refDataElementKey;
      if (refDataElementKey) {
        if (refDataElementKey && refDataElementKey == dependedField) {
          this.needRebuild = true;
        }
      } else {
        const refKey = properties.refKey;
        if (refKey && refKey == dependedField) {
          this.needRebuild = true;
        }
      }
    }
    if (!this.needRebuild) {
      const rt = properties.root;
      if (rt && rt.length > 0) {
        if (rt == dependedField) {
          this.needRebuild = true;
        }
      }
    }
    if (!this.needRebuild) {
      const metaFilter = await this.handler.getMetaFilter(form, meta.properties, this.itemKey, meta.typeDefKey);
      if (metaFilter) {
        if (metaFilter.dependency) {
          const str = "," + metaFilter.dependency + ",";
          if (str.indexOf("," + dependedField + ",") >= 0) {
            this.needRebuild = true;
          }
        }
      } else if (this.dictFilter) {
        this.needRebuild = true;
      }
    }
    return this.needRebuild;
  }
  // 计算是否需要重置字典及清除字段值
  async calcNeedRebuild(targetField, dependedField) {
    const needResetValue = await this.calcNeedRebuildBase(targetField, dependedField);
    const oldValue = this.getValue();
    const oids = TypeConvertor.toSafeDataType(DataType.STRING, oldValue);
    if (!oids || oids == "" || oids <= 0) {
      return needResetValue;
    }
    const form = this.getForm();
    const meta = this.getMetaObj();
    if (meta.type == ControlType.DYNAMICDICT) {
      this.itemKey = await this.calcItemKey();
    }
    const dictFilter = await this.handler.getDictFilter(form, this.getMetaObj(), this.itemKey, this.typeDefKey);
    const ret = await this.handler.createRoot(form, this.itemKey, this.root, new ViewContext(form));
    const rootValue = ret.root;
    var dictService = this.DictService;
    if (!dictService) {
      dictService = new DictService(form);
    }
    const itemDatas = await dictService.getItemByOID(
      this.itemKey,
      0,
      10,
      3,
      oids,
      this.stateMask,
      dictFilter,
      rootValue,
      form.formKey,
      this.key
    );
    if (itemDatas && itemDatas != null) {
      return false;
    } else {
      return true;
    }
  }
  beforeDestroy() {
    this.impl && this.impl.destroy();
  }
  isNull() {
    return this.handler.isNullValue(this.value);
  }
  async calcShowText(form) {
    var handler = this.handler;
    if (this.formulaText && this.value) {
      var text = await form.asyncEval(this.formulaText);
      if (text && !this.value)
        return;
      this.showText = text;
      this.setTip(text);
      if (this.impl) {
        this.impl.setShowText(text);
      }
    } else if (this.isEditValue) {
      let value = this.value;
      let text2 = "";
      if (value) {
        if (this.multiSelect) {
          if (Utils.isArray(value)) {
            var include = false;
            for (let i2 = value.length - 1; i2 >= 0; i2--) {
              if (value[i2].editValue.includes("*") || value[i2].editValue.includes("+") || value[i2].editValue.includes("？") || value[i2].editValue.includes("_") || value[i2].editValue.includes("%")) {
                text2 = value[i2].editValue;
                include = true;
                break;
              }
            }
            if (!include) {
              if (value.length > 1) {
                var c = "";
                for (let i2 = 0; i2 < value.length; i2++) {
                  c = c + "," + value[i2].editValue;
                }
                if (c.length > 0) {
                  c = c.substring(1);
                }
                text2 = c;
              } else {
                text2 = value[0].editValue;
              }
            }
          } else {
            text2 = value;
          }
        } else {
          text2 = value;
          if (value instanceof ItemData) {
            text2 = value.editValue;
          }
        }
      }
      this.showText = text2;
      this.impl.setShowText(text2);
      this.setTip(text2);
      this.impl.setPromptText(this.promptText);
    } else {
      var text = await handler.getShowCaption(form, this.value, this.multiSelect, this.independent, this.isEditValue, this.textField, this.key);
      if (text && !this.value)
        return;
      this.showText = text;
      this.setTip(text);
      if (this.impl) {
        this.impl.setShowText(text);
      }
    }
  }
  async checkEnd(value) {
    this.value = value;
    this.impl.setValue(value);
    let form = this.getForm();
    try {
      this.calcShowText(form);
    } catch (e) {
      if (this.isDestroyed) {
        throw new Exception(e.code, e.message, true);
      } else {
        throw e;
      }
    }
  }
  getDictTree() {
    return this.impl.dictTree;
  }
  getDictFilter() {
    return this.dictFilter;
  }
  //TODO 抽动态字典模型
  async calcItemKey() {
    return this.handler.calcItemKey(this);
  }
  async getDictChildren(pItemData) {
    await this.calcItemKey();
    return this.handler.getDictChildren(this, pItemData);
  }
  async getTreePath(nodes, rootId) {
    await this.calcItemKey();
    return this.handler.getTreePath(this, nodes, rootId);
  }
  async getShowCaption(value) {
    await this.calcItemKey();
    return this.handler.getShowCaption(this.getForm(), value);
  }
  async getQueryData(startRow, maxRows, pageIndicatorCount, fuzzyValue, root) {
    var result = await this.handler.getQueryData(this, startRow, maxRows, pageIndicatorCount, fuzzyValue, root);
    return result;
  }
  async locate(value, field) {
    return this.handler.locate(this, field, value);
  }
  async getDisplayCols() {
    await this.calcItemKey();
    return this.handler.getDisplayCols(this);
  }
  getDropCols() {
    return this.dropCols;
  }
  async getQueryCols() {
    await this.calcItemKey();
    return this.handler.getQueryCols(this);
  }
  getDisplayColKey() {
    return this.displayCols[0].key;
  }
  setCacheData(data2) {
    var leve = [];
    for (var i2 = 0; i2 < data2.length; i2++) {
      var node = data2[i2];
      var parentid = node.itemKey + "_" + node.ParentID;
      leve.push(node);
      if (!this.cacheData) {
        this.cacheData = {};
      }
      this.cacheData[parentid] = leve;
      if (node.items && node.items.length > 0) {
        this.setCacheData(node.items);
      }
    }
  }
  clearCacheData() {
    this.cacheData = null;
  }
  resetStatus() {
    super.resetStatus();
    this.needRebuild = true;
  }
  async dependedValueChange(targetField, dependedField) {
    const self = this;
    const needResetValue = await self.calcNeedRebuild(targetField, dependedField);
    if (needResetValue) {
      if (!self.isSubDetail && !self.getMetaObj().properties.isEditValue) {
        await self.setValue(null, true, true, true);
      }
      if (self.impl) {
        self.impl.startRow = 0;
        self.impl.resetDropViewClass();
      }
    }
    return true;
  }
  async checkDict() {
    var _this = this;
    if (!_this.needRebuild && typeof _this.needRebuild != "undefined") {
      return false;
    }
    _this.impl.reset();
    if (_this.needRebuild) {
      _this.clearCacheData();
    }
    var result = await _this.handler.checkDict(_this);
    if (result) {
      _this.itemKey = result.itemKey;
      _this.dictFilter = result.dictFilter;
      _this.secondaryType = result.secondaryType;
      _this.needRebuild = false;
    }
    return result;
  }
  getItemKey() {
    return this.itemKey;
  }
  render(container) {
    const canPopup = this.handler.canPopupDict(this, this.getForm(), this.itemKey);
    if (canPopup) {
      const opts = {
        form: this.getForm(),
        meta: this.meta,
        itemKey: this.itemKey
      };
      this.traceHandler = new DictTraceHandler(opts);
    }
    super.render(container);
  }
  canPopupDict() {
    const form = this.getForm();
    if (form.getContainer() instanceof StackContainer && form.getContainer().getForm().getContainer() instanceof ModalContainer || form.getContainer() instanceof ModalContainer) {
      return false;
    }
    return this.handler.canPopupDict(this, form, this.itemKey);
  }
  getTraceHandler() {
    return this.traceHandler;
  }
}
class CompDict extends Dict {
  constructor(meta) {
    super(meta);
  }
}
class CountDownView extends BaseControl {
  constructor(meta) {
    super(meta);
    this.maxTime = 60;
    this.countviewstyle = "Rectangle";
  }
  checkEnd(value) {
    this.value = value;
    this.impl && this.impl.setValue(value);
  }
  async doOnClick() {
    return this.handler.doOnClick(this.ofFormID, this.onClick);
  }
  doOnFinish() {
    return this.handler.doOnFinish(this, this.onFinish);
  }
  startCountDown() {
    this.impl && this.impl.setStartCountDown();
  }
  resumeCountDown() {
    this.impl && this.impl.setResumeCountDown();
  }
  pauseCountDown() {
    this.impl && this.impl.setPauseCountDown();
  }
}
class CountUp extends BaseControl {
  checkEnd(value) {
    this.value = value;
    this.impl && this.impl.setValue(value);
  }
  doRender(ct) {
    super.doRender(ct);
    this.checkEnd(this.value);
  }
  async doOnClick() {
    return this.handler.doOnClick(this.ofFormID, this.onClick);
  }
}
class Custom extends BaseControl {
  constructor(meta) {
    super(meta);
  }
}
class DatePicker extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  isValidDate(date) {
    return date instanceof Date && !isNaN(date.getTime());
  }
  /** 有el时调用*/
  checkEnd(value) {
    this.value = value;
    var text = "";
    if (this.isValidDate(value)) {
      text = DateFormat.format(this.value, this.onlyDate, this.formatStr);
    }
    this.showText = text;
    if (this.impl) {
      this.impl.setShowText(text);
      this.impl.setTip(text);
    }
  }
}
class DateRangePicker extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  checkEnd(value) {
    this.value = value;
    this.impl.setShowText(value);
  }
}
class DictPane extends Dict {
  async dependedValueChange(targetField, dependedField) {
    await super.dependedValueChange(targetField, dependedField);
    this.impl && this.impl.repaint();
    return;
  }
}
class DictSearchBox extends Dict {
}
class DictView extends BaseControl {
  constructor(meta) {
    super(meta);
    this.data = [];
    this.fuzzyValue = "";
    this.cacheData = null;
    this.loadType = DictLoadType.R2L;
  }
  setCacheData(data2) {
    var leve = [];
    for (var i2 = 0; i2 < data2.length; i2++) {
      var node = data2[i2];
      var parentid = node.itemKey + "_" + node.ParentID;
      leve.push(node);
      if (!this.cacheData) {
        this.cacheData = {};
      }
      this.cacheData[parentid] = leve;
      if (node.items && node.items.length > 0) {
        this.setCacheData(node.items);
      }
    }
  }
  clearCacheData() {
    this.cacheData = null;
  }
  expandNode(id, reload2, expandAll) {
    this.impl && this.impl.expandNode(id, reload2, expandAll);
  }
  collapseNode(id, collapseAll) {
    this.impl && this.impl.collapseNode(id, collapseAll);
  }
  parseColumns() {
    var columns = [];
    var assign = function(column, m_Column) {
      column.key = m_Column.key;
      column.title = m_Column.caption;
      column.width = m_Column.width;
      column.align = "center";
    };
    this.columns.forEach((m_Column) => {
      var column = {};
      assign(column, m_Column);
      columns.push(column);
    });
    if (this.dictType == SecondaryType.DICT) {
      columns[0].type = "tree";
    }
    return columns;
  }
  async refresh() {
    if (!this.impl) {
      return;
    }
    this.impl.reloadData(this.data);
    this.impl.reloadPager(this.pageInfo);
  }
  loadData() {
  }
  getFocusRowIndex() {
    return this.selection.getFocusRow();
  }
  getFocusColIndex() {
    return this.selection.getFocusCol();
  }
  getOldFocusRowIndex() {
    return this.selection.getOldFocusRow();
  }
  getOldFocusColIndex() {
    return this.selection.getOldFocusCol();
  }
  addNode(itemData) {
    if (this.impl) {
      return this.impl.addNode(itemData);
    }
  }
  focusNode(itemData) {
    if (this.impl) {
      var id = itemData.itemKey + "_" + itemData.oid;
      return this.impl.focusNode(id);
    }
  }
  removeNode(itemData) {
    if (this.impl) {
      var id = itemData.itemKey + "_" + itemData.oid;
      return this.impl.removeNode(id);
    }
  }
  //更新节点　图标　及　显示字段
  refreshNode(itemData) {
    if (this.impl) {
      return this.impl.refreshNode(itemData);
    }
  }
  //更新当前节点图标及显示字段
  refreshNodeByItem(item) {
    if (this.impl) {
      return this.impl.refreshNodeByItem(item);
    }
  }
  async getQueryData(startRow, maxRows, pageIndicatorCount, fuzzyValue) {
    var filter = await this.getDictFilter();
    if (this.isChainDict()) {
      return await this.handler.getOrgQueryData(this, this.itemKey, startRow, maxRows, pageIndicatorCount, fuzzyValue, null, filter, null, this.getForm());
    }
    return this.handler.getQueryData(this, this.itemKey, startRow, maxRows, pageIndicatorCount, fuzzyValue, null, filter, null);
  }
  async getDictFilter() {
    const filter = this.handler.getDictFilter(this);
    this.dictFilter = filter;
    return filter;
  }
  async doOnRowClick(colKey) {
    var formID2 = this.ofFormID, rowClick = this.getMetaObj().rowClick;
    if (rowClick) {
      return this.handler.doOnRowClick(formID2, rowClick);
    } else {
      return false;
    }
  }
  async doOnFocusRowChange() {
    this.ofFormID;
    var focusRowChanged = this.getMetaObj().focusRowChanged;
    if (focusRowChanged) {
      return this.handler.doOnFocusRowChange(this);
    } else {
      return false;
    }
  }
  async getItem(itemKey, oid) {
    const item = await this.getDictService().getItem(itemKey, oid);
    return item;
  }
  getQueryValue() {
    return this.fuzzyValue;
  }
  getValueAt(rowIndex, colIndex) {
    if (rowIndex == -1 || colIndex == -1) {
      return null;
    }
    return this.data[rowIndex].data[colIndex].value;
  }
  getDatas() {
    if (this.impl && !this.loading) {
      return this.impl.data;
    }
    return this.data;
  }
  getRowDataAt(rowIndex) {
    return this.getDatas()[rowIndex];
  }
  getCellDataAt(rowIndex, colIndex) {
    return this.getRowDataAt(rowIndex).data[colIndex];
  }
  setValueAt(rowIndex, colIndex, value) {
    var cellData = this.getCellDataAt(rowIndex, colIndex);
    cellData.value = value;
    cellData.caption = TypeConvertor.toString(value);
  }
  __insertRow(rowIndex, oid, nodeType, parentRow) {
    var rowData = {
      data: [],
      oid,
      treeLevel: 0,
      children: [],
      parentRow
    };
    if (parentRow) {
      rowData.treeLevel = parentRow.treeLevel + 1;
    }
    if (this.dictType == SecondaryType.DICT) {
      rowData.isLeaf = nodeType == 0;
    }
    this.columns.forEach(function(column) {
      rowData.data.push({
        value: null,
        caption: "",
        enable: false,
        type: ControlType.LABEL,
        meta: column
      });
    });
    var data2 = this.data, index;
    if (rowIndex >= 0) {
      index = rowIndex;
      data2.splice(rowIndex, 0, rowData);
    } else {
      index = data2.length;
      data2.push(rowData);
    }
    return index;
  }
  insertRow(idx, oid, nodeType, parentRow) {
    return this.__insertRow(idx, oid, nodeType, parentRow);
  }
  getSelection() {
    return this.selection;
  }
  getHandler() {
    return this.handler;
  }
  getColumns() {
    return this.columns;
  }
  clearSelection() {
    if (this.impl) {
      return this.impl.clearSelection && this.impl.clearSelection();
    }
  }
  show(data2) {
    this.data.length = 0;
    this.handler.showData(this, data2);
    this.refresh();
  }
  isChainDict() {
    return this.dictType == SecondaryType.CHAINDICT;
  }
  getSelectedItemData() {
    return this.impl && this.impl.getSelectedItemData.apply(this.impl, arguments);
  }
  dependedValueChange(targetField, dependedField) {
    this.cacheData = null;
    if (!this.impl) {
      return;
    }
    var isSame = function(filter1, filter2) {
      if (filter2 == null) {
        return false;
      }
      if (filter1.itemKey != filter2.itemKey) {
        return false;
      }
      if (filter1.formKey != filter2.formKey) {
        return false;
      }
      if (filter1.fieldKey != filter2.fieldKey) {
        return false;
      }
      if (filter1.filterIndex != filter2.filterIndex) {
        return false;
      }
      if (JSON.stringify(filter1.values) != JSON.stringify(filter2.values)) {
        return false;
      }
      if (filter1.dependency != filter2.dependency) {
        return false;
      }
      return true;
    };
    var isSame_comp = function(filters1, filters2) {
      return false;
    };
    var dictFilter = this.dictFilter;
    var self = this, form = self.getForm();
    if (this.dictType == SecondaryType.COMPDICT) {
      this.dictFilters;
      return self.handler.getCompDictFilter(self).then(function(filters) {
        var refresh = false;
        if (filters.length != 0 && !isSame_comp()) {
          refresh = true;
        } else if (filters.length != 0)
          ;
        else if (self.dictFilters != null) {
          refresh = true;
        }
        if (!refresh) {
          return;
        }
        if (!self.impl) {
          return;
        }
        self.impl.loadData();
      });
    } else {
      return self.handler.getDictFilterImpl(form, self.getMetaObj(), self.itemKey).then(function(filter) {
        var refresh = false;
        if (filter != null && !isSame(filter, dictFilter)) {
          self.dictFilter = filter;
          refresh = true;
        } else if (filter != null)
          ;
        else if (self.dictFilter != null) {
          self.dictFilter = null;
          refresh = true;
        }
        if (!refresh) {
          return;
        }
        if (!self.impl) {
          return;
        }
        self.impl.loadData();
      });
    }
  }
  async updateDictView(nodeJson) {
    if (this.impl && typeof this.impl.updateDictView == "function") {
      await this.impl.updateDictView(nodeJson);
    }
  }
  async updateRowFieldData(itemKey, oid, colKey, value) {
    if (!this.impl || typeof this.impl.updateRowFieldData != "function") {
      return;
    }
    this.impl.updateRowFieldData(itemKey, oid, colKey, value);
  }
  getDictService() {
    if (!this.dictService) {
      this.dictService = new DictService(this.getForm());
    }
    return this.dictService;
  }
  getParentPath(itemData) {
    return this.getDictService().getParentPath(this.itemKey, itemData);
  }
  getDataObject() {
    return this.handler.getDVInfo(this.getForm(), this.getMetaObj());
  }
  getSelectedValue(colKey) {
    return this.impl && this.impl.getSelectedValue(colKey);
  }
}
class DrawerBox extends BaseControl {
  constructor(meta) {
    super(meta);
  }
}
class DropDownButton extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  async doOnClick(e, item) {
    return this.handler.doOnClick(this.ofFormID, item.formula);
  }
}
class DynamicDict extends Dict {
  constructor(meta) {
    super(meta);
  }
  async checkDict() {
    const result = await super.checkDict();
    if (!this.dataElementKey) {
      this.dataElementKey = result.dataElementKey;
    }
    this.impl.setBrowserFormKey(result.browserFormKey);
    this.impl.setQueryFormKey(result.queryFormKey);
    return result;
  }
}
class GIFImage extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  checkEnd(value) {
    switch (this.sourceType) {
      case ImageSourceType.DATA:
      case ImageSourceType.URL:
        value = this.value;
        break;
      case ImageSourceType.RESOURCE:
        value = this.image;
        break;
    }
    this.value = value;
    this.impl.setValue(value);
  }
  setControlValue(value) {
    if (this.sourceType == ImageSourceType.RESOURCE) {
      return;
    }
    super.setControlValue(value);
  }
  onRender(ct) {
  }
  async doOnClick() {
    return this.handler.doOnClick(this.ofFormID, this.onClick);
  }
}
class HyperLink extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  checkEnd(value) {
    this.value = value;
    var caption = this.caption;
    if (this.value != null) {
      caption = this.value.toString();
    } else {
      if (this.hasDataBinding()) {
        caption = "";
      }
    }
    this.showText = caption;
    this.impl.setShowText(caption);
    this.impl.setTip(caption);
  }
  async doOnClick() {
    var self = this;
    if (self.enable) {
      self.focusManager && (self.focusManager.focusOwner = self);
      var url = await self.handler.resolveURL(self);
      if (url) {
        return self.handler.openURL(self, url);
      } else {
        return self.handler.doOnClick(self, self.onClick);
      }
    }
  }
}
class Icon extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  checkEnd(value) {
    this.value = value || this.icon || this.url;
    if (this.dataBinding) {
      this.impl.setValue(this.value);
    } else {
      this.impl.setValue(this.icon || this.url);
    }
  }
}
let Image$1 = class Image2 extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  setControlValue(value) {
    if (this.sourceType == ImageSourceType.RESOURCE) {
      return;
    }
    super.setControlValue(value);
  }
  uploadImg($file, paras) {
    var self = this;
    return this.handler.uploadImage(self, $file, paras).then(function(data2) {
      return self.commitValue(data2.replace(/\\/g, "/")).then(function(isChanged) {
        isChanged !== false && self.getForm().getUIOptTracer().traceOnValueChanged(self, self.value);
        return isChanged;
      });
    });
  }
  uploadFileData($file, paras) {
    var self = this;
    return this.handler.uploadFileData(self, $file, paras).then(function(data2) {
      return self.commitValue(data2.replace(/\\/g, "/"));
    });
  }
  clearImage(path) {
    var self = this;
    return self.handler.deleteImg(self, path).then(function() {
      return self.setValue("", true, true, true);
    });
  }
  downloadImg(path) {
    return this.handler.downloadImg(this, path);
  }
  downloadURLImg(url) {
    return this.handler.downloadURLImg(this, url);
  }
  async doOnClick() {
    return this.handler.doOnClick(this.ofFormID, this.onClick);
  }
  checkEnd(value) {
    this.value = this.image || value;
    this.impl.setValue(this.value);
  }
  async takePhotoBymobile() {
    var form = this.getForm();
    var document2 = form && form.getDocument();
    var formKey = form.formKey;
    var oid = document2.oid || -1;
    var self = this;
    var fileName = this.fileName;
    const result_1 = await InterActiveFactory.Interactive.takePhotoForUpload(formKey, oid, this.maxSize, "", fileName);
    if (result_1) {
      self.commitValue(result_1);
    }
  }
  async selectPhotoBymobile() {
    var form = this.getForm();
    var document2 = form && form.getDocument();
    var formKey = form.formKey;
    var oid = document2.oid || -1;
    var self = this;
    var fileName = this.fileName;
    return InterActiveFactory.Interactive.selectPhotoForUpload(formKey, oid, this.maxSize, "", fileName).then(function(result) {
      if (result) {
        self.commitValue(result);
      }
    });
  }
};
class ImageList extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  checkEnd(value) {
    var path = this.getPath(value);
    this.impl.setValue(path);
  }
  getPath(value) {
    var items = this.items;
    if (value == null || !items) {
      return "";
    }
    for (var i2 = 0, len = this.items.length; i2 < len; i2++) {
      if (this.items[i2].value == value) {
        return this.items[i2].image;
      }
    }
    return "";
  }
  onRender(ct) {
    super.onRender(ct);
    this.checkEnd(this.value);
  }
  async doOnClick() {
    return this.handler.doOnClick(this.ofFormID, this.onClick);
  }
}
class Label extends BaseControl {
  constructor(meta) {
    super(meta);
    this.key = meta.key;
    this.type = meta.type;
  }
  setText(s) {
    this.impl.setText(s);
  }
  needClean() {
    return false;
  }
  checkEnd(value) {
    this.value = value;
    var caption = this.caption;
    if (this.value != null) {
      caption = this.value.toString();
    } else {
      if (this.hasDataBinding()) {
        caption = "";
      }
    }
    this.showText = caption;
    this.impl.setShowText(caption);
    this.impl.setTip(this.tip || caption);
  }
}
class MapDraw extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  isDataBinding() {
    return false;
  }
  clear() {
    this.impl && this.impl.clearMap();
  }
  setDriveRoute(start, end, waypoints, path) {
    this.impl && this.impl.setDriveRoute(start, end, waypoints, path);
  }
  drawMarker(marker) {
    this.impl && this.impl.drawMarker(marker);
  }
  drawPolyline(polyline) {
    this.impl && this.impl.drawPolyline(polyline);
  }
  drawPolygon(polygon) {
    this.impl && this.impl.drawPolygon(polygon);
  }
  getMapInfo() {
    return this.impl && this.impl.getMapInfo();
  }
  showMapInfo(mapInfo) {
    this.impl && this.impl.showMapInfo(mapInfo);
  }
  beforeDestroy() {
    this.impl && this.impl.beforeDestroy();
  }
}
class ModuleEditor extends BaseControl {
  constructor(meta) {
    super(meta);
    this.showImage = false;
    this.needRebuild = true;
    this.moduleDataObj = {};
    this.dataObj = {};
  }
  isNull() {
    if (this.integerValue) {
      return super.isNull() || parseFloat(this.value) == 0;
    }
    return super.isNull();
  }
  dependedValueChange() {
    this.needRebuild = true;
  }
  checkItems() {
    var self = this;
    if (this.needRebuild) {
      let table = this.handler.getItems(this);
      let sourceTable = this.handler.getItems(this, true);
      return Promise.all([table, sourceTable]).then((res) => {
        self.needRebuild = false;
        return res;
      });
    }
  }
  getItemKey() {
    return this.getValue();
  }
  resetStatus() {
    this.needRebuild = true;
  }
  getShowCaption(value) {
    var _this = this;
    var caption = _this.handler.getShowCaption(_this.sourceType, _this.impl.items, value, _this.multiSelect, _this.editable);
    return caption;
  }
  beforeDestroy() {
    this.impl && this.impl.destroy();
  }
  getValue() {
    return this.impl && this.impl.getValue();
  }
  async doOnClick() {
    if (this.enable) {
      return this.handler.doOnClick(this.ofFormID, this.onClick);
    }
  }
  setItem(control, sorce, key, title, image, groupValue, groupCaption, userID) {
    var pobj = {};
    pobj.title = title;
    pobj.key = key;
    pobj.image = image;
    pobj.groupValue = groupValue || "group-md1";
    pobj.groupCaption = groupCaption;
    pobj.userID = userID;
    if (image) {
      control.isImage = true;
    }
    if (sorce) {
      control.moduleDataObj[key] = pobj;
    } else {
      control.dataObj[key] = pobj;
    }
    return pobj;
  }
  clearData() {
    this.handler.clearDataTable(this);
  }
  addData(newItems) {
    this.handler.addDataTable(this, newItems);
  }
}
class MonthPicker extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  checkEnd(value) {
    this.value = value;
    var text = "";
    if (value) {
      text = DateFormat.monthsFormat(value, this.formatStr);
    }
    this.showText = text;
    this.impl.setShowText(text);
    this.impl.setTip(text);
  }
}
class MultiStateButton extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  checkEnd(value) {
    this.value = value;
    var index = this.handler.getShowIndex(this.stateItem, value);
    this.impl.setValue(value);
    this.impl.setItemLoad(index);
    this.impl.setTip(value);
  }
  async doOnClick(eventTarget) {
    if (this.enable) {
      return this.handler.doOnClick(this, this.onClick, null, eventTarget);
    }
  }
}
class NoticeBar extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  checkEnd(value) {
    this.value = value;
    var caption = this.caption;
    if (this.value != null && this.value != "") {
      caption = this.value.toString();
    }
    this.showText = caption;
    this.impl.setShowText(caption);
  }
  async doOnClick() {
    if (this.enable) {
      return this.handler.doOnClick(this.ofFormID, this.action);
    }
  }
}
class NumberEditor extends BaseControl {
  constructor(meta) {
    super(meta);
    this.value = new Decimal(0);
  }
  isNull() {
    if (this.allowNull) {
      return this.value == null;
    }
    return this.value.isZero();
  }
  checkEnd(value) {
    this.value = value;
    this.impl.setValue(value);
    var caption = "";
    if (this.infinity) {
      caption = "#DIV/0";
    } else {
      caption = DecimalFormat.format(value, this);
    }
    this.impl.setNormalCaption(caption);
    if (this.formulaText) {
      var self = this;
      var form = this.getForm();
      var cxt = new ViewContext(form);
      form.asyncEval(this.formulaText, cxt).then(function(text) {
        self.showText = text;
        self.impl.setShowText(text);
        self.impl.setTip(text);
        self.impl.setIsEmpty(text);
      });
    } else {
      this.showText = caption;
      this.impl.setShowText(caption);
      this.impl.setTip(caption);
      this.impl.setIsEmpty(caption);
    }
  }
  onRender(parent2) {
    this.checkEnd(this.value);
  }
  doOnFocus() {
    if (this.enable) {
      return this.handler.doOnFocus(this, this.onFocus);
    }
  }
  doTextChanged(textChanged) {
    this.handler.doTextChanged(this, textChanged);
  }
  getNowShowText() {
    return this.impl && this.impl.getShowText();
  }
}
class TextEditor extends BaseControl {
  constructor(meta) {
    super(meta);
    this.keyEnter = "";
    this.onFocus = "";
    this.textChanged = "";
  }
  checkEnd(value) {
    this.showText = value;
    this.value = value;
    this.impl.setValue(value);
    this.impl.setShowText(value);
    this.impl.setTip(value);
  }
  onRender(parent2) {
    this.checkEnd(this.value);
  }
  doEnterPress() {
    this.handler.doEnterPress(this, this.keyEnter);
  }
  doOnFocus() {
    if (this.enable) {
      return this.handler.doOnFocus(this, this.onFocus);
    }
  }
  doTextChanged() {
    if (this.enable) {
      this.handler.doTextChanged(this, this.textChanged);
    }
  }
  getNowShowText() {
    return this.impl && this.impl.getShowText();
  }
}
class PasswordEditor extends TextEditor {
  checkEnd(value) {
    this.value = value;
    this.showText = value;
    this.impl.setShowText(value);
  }
}
let PopView$1 = class PopView extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  /**
   * 控件渲染到界面，不包含items的渲染。
   */
  onRender(ct) {
  }
  // 渲染container中的所有控件
  renderChildren(ct) {
  }
  destroy() {
    if (this.root) {
      this.root.destroy();
    }
    super.destroy();
  }
};
class PriceLabel extends BaseControl {
  constructor(meta) {
    super(meta);
    this.value = 0;
  }
  isNull() {
    return this.value == null || this.value == "" || this.value === "0";
  }
  checkEnd(value) {
    this.value = value || "0.00";
    this.impl.setValue(this.value);
  }
}
class ProgressBar extends BaseControl {
  constructor(meta) {
    super(meta);
    this.progressstyle = "Horizontal";
    this.minPos = 0;
    this.maxPos = 100;
    this.items = [];
  }
  checkEnd(value) {
    !this.isNull() && this.impl && this.impl.setValue(value);
  }
  isNull() {
    return this.value == null || this.value == "" || TypeConvertor.toDecimal(this.value) == 0;
  }
}
class Progressindicator extends BaseControl {
  constructor(meta) {
    super(meta);
    this.items = [];
    this.needRebuild = true;
  }
  isNull() {
    if (this.integerValue) {
      return super.isNull() || parseFloat(this.value) == 0;
    }
    return super.isNull();
  }
  dependedValueChange() {
    this.needRebuild = true;
    return this.setValue(null, true, true, true);
  }
  checkItems(keepRebuild) {
    return new Promise((resolve2, reject) => {
      var metaObj = this.getMetaObj();
      var prop = metaObj.properties;
      var self = this;
      if (self.needRebuild || !prop.cache) {
        self.handler.getItems(self, prop).then(function(items) {
          self.items = items;
          !keepRebuild && (self.needRebuild = false);
          resolve2(items, true);
        });
      } else {
        resolve2(self.items, false);
      }
    });
  }
  checkEnd(value) {
    this.value = value;
    this.impl && this.impl.setValue(value);
  }
  checkItem(value) {
    this.impl.checkItem(value);
  }
  beforeDestroy() {
    this.impl && this.impl.destroy();
  }
  getValue() {
    return this.integerValue ? TypeConvertor.toInt(this.value) : this.value;
  }
  onRender(ct) {
    super.onRender(ct);
    this.checkEnd(this.value || 0);
  }
}
class RadioButton extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  async setValue(value, commit, editing, fireEvent) {
    if (!this.isGroupHead)
      return;
    return super.setValue(value, commit, editing, fireEvent);
  }
  async __setValue(value) {
    if (!this.isGroupHead)
      return;
    return super.__setValue(value);
  }
  checkEnd(value) {
    if (!this.isGroupHead)
      return;
    this.value = value;
    if (!value)
      return;
    var radioMap = this.getForm().formAdapt.radioMap[this.groupKey];
    radioMap.forEach((radio) => {
      radio.impl && radio.impl.setChecked(radio.metaValue == value);
    });
  }
  getGroupValue() {
    if (!this.isGroupHead) {
      return this.getForm().getComponent(this.headKey).getValue();
    }
    return this.value;
  }
  async commitValue() {
    if (this.enable) {
      let target = this;
      if (!this.isGroupHead) {
        target = this.getForm().getComponent(this.headKey);
      }
      return target.setValue(this.metaValue, true, true, true);
    }
  }
}
let RefreshControl$1 = class RefreshControl extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  needClean() {
    return false;
  }
  footerScriptEvent(eventTarget) {
    if (this.footerScript && this.footerScript.content) {
      return this.handler.footerScriptEvent(this, this.footerScript.content, null, eventTarget);
    }
  }
  headerScriptEvent(eventTarget) {
    if (this.headerScript && this.headerScript.content) {
      return this.handler.headerScriptEvent(this, this.headerScript.content, null, eventTarget);
    }
  }
  /**
     * 先destroy所有items
     */
  beforeDestroy() {
    this.root && this.root.destroy();
    super.beforeDestroy();
  }
};
class RelativeTime extends BaseControl {
  constructor(meta) {
    super(meta);
    this.interval = 60;
  }
  isValidDate(date) {
    return date instanceof Date && !isNaN(date.getTime());
  }
  checkEnd(value) {
    this.value = value;
    var text = "";
    if (this.isValidDate(value)) {
      text = DateFormat.format(this.value, this.onlyDate);
    }
    this.showText = text;
    this.impl.setShowText(text);
  }
}
let $customConfigs = [];
const $customHandlers = {};
const data$1 = {};
class RichEditorProvider {
  static regCustomOperator(key, options2) {
    data$1[key] = options2;
  }
  static getOperator(key) {
    return data$1[key];
  }
  static getCustomOperators() {
    return data$1;
  }
  static getCustomConfigs() {
    return $customConfigs;
  }
  static getCustomHandlers() {
    return $customHandlers;
  }
}
class RichEditor extends BaseControl {
  constructor(meta) {
    super(meta);
    this.customOperators = {};
    this.customOperators = RichEditorProvider.getCustomOperators();
  }
  checkEnd(value) {
    this.value = value;
    this.impl.setValue(value);
  }
  onRender(ct) {
    super.onRender(ct);
    this.checkEnd(this.value);
  }
  getCustomConfigEl(key) {
    this.impl && this.impl.getCustomConfigEl(key);
  }
  // doLayout(width, height) {
  //     this.impl && this.impl.doLayout(width, height);
  // }
}
class ScoreBar extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  checkEnd(value) {
    this.value = value;
    this.impl.setValue(value);
  }
  isNull() {
    return this.value == null || this.value == "" || this.value === "0";
  }
}
class Separator extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  //特意重写，不设置高度，css控制1px
  onSetHeight(height) {
  }
}
class Slider extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  checkEnd(value) {
    this.value = value;
    this.impl.setValue(value);
  }
  isNull() {
    return this.value == null || this.value == "" || this.value === "0";
  }
}
class SplitButton extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  rightClick(e) {
  }
  itemClick(item) {
    alert(item.text);
  }
  isDataBinding() {
    return false;
  }
  async doOnClick(eventTarget, item) {
    if (this.enable) {
      return this.handler.doOnClick(this.ofFormID, item.formula, null, eventTarget);
    }
  }
}
class StepEditor extends BaseControl {
  constructor(meta) {
    super(meta);
    if (this.value == null) {
      this.value = new Decimal(meta.properties.minvalue);
    }
  }
  checkEnd(value) {
    this.value = value;
    this.impl.setValue(value);
    this.showText = value.toFixed(this.scale);
    this.impl.setTip(value.toFixed(this.scale));
  }
  isNull() {
    return this.value.isZero();
  }
  //控件处理本身的渲染形成一个完整的控件Dom对象，添加到传入的父亲Dom对象，返回该控件Dom对象的ID
  onRender(ct) {
    super.onRender(ct);
    this.showText = this.value.toFixed(this.scale);
  }
}
class Switch extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  checkEnd(value) {
    this.value = value;
    this.impl.setValue(value);
  }
  // onRender(ct) {
  //     this.checkEnd(this.value);
  //     var buddKey = this.getForm().getComponent(this.buddyKey);
  //     if (buddKey) {
  //         buddKey.cssClass += "switchLbr";
  //         buddKey.impl && buddKey.impl.el.addClass("switchLbr");
  //     }
  // }
}
let TabContainer$1 = class TabContainer extends BaseControl {
  constructor(meta) {
    super(meta);
    this.add = (form) => {
      let containerForm = form.getParentForm();
      if (containerForm && containerForm.containerFormKey) {
        form.setContainer(this.getForm().getContainer());
        form.getContainer().addFormByContainer(form);
      } else {
        this.curFormKey = form.formKey;
        this.impl && this.impl.add(form, this.getForm());
      }
    };
    this.backForm = () => {
      for (const key in this.itemRender) {
        if (this.itemRender[key]) {
          FormStack.removeForm(this.itemRender[key]["formID"]);
        }
      }
    };
    this.close = () => {
      FormStack.removeForm(this["formID"]);
      this.getForm().fireClose();
    };
    this.changeContainer = (formKey) => {
      if (this.itemRender[formKey]) {
        this.impl.showContent(formKey, this.itemRender[formKey], this.getForm());
      } else {
        if (formKey) {
          if (this.curFormKey) {
            if (this.curFormKey != formKey) {
              this.curFormKey = formKey;
              this.renderForm();
            }
          } else {
            this.curFormKey = formKey;
            this.renderForm();
          }
        } else {
          this.curFormKey = "";
          this.impl.hideContent(this.getForm());
        }
      }
    };
    this.key = meta.key;
    this.type = meta.type;
    this.curFormKey = "";
    this.itemRender = {};
  }
  getGroupItem(key) {
    if (this.tabGroup) {
      return this.tabGroup.items.filter((item) => item.key == key)[0];
    } else {
      return false;
    }
  }
  setTabGropuItemVisible(key, visible) {
    var item = this.getGroupItem(key);
    if (item) {
      item.visible = visible;
      this.tabGroup.impl && this.tabGroup.impl.setItemVisible(key, visible);
    }
  }
  async render(target) {
    super.render(target);
    if (!this.tabGroup) {
      this.renderForm();
    }
  }
  renderForm() {
    let formKey;
    var form = this.getForm();
    if (this.curFormKey) {
      formKey = this.curFormKey;
    } else if (this.formulaFormKey) {
      var cxt = new ViewContext(form);
      formKey = form.eval(this.formulaFormKey, cxt, null);
    } else {
      formKey = this.defaultFormKey;
    }
    let self = this;
    if (formKey) {
      var container = this;
      var builder = new FormBuilder(formKey);
      builder.setContainer(container);
      container["builder"] = builder;
      return builder.newEmpty().then(function(emptyForm) {
        if (!emptyForm)
          return;
        container["form"] = emptyForm;
        container["formID"] = emptyForm["formID"];
        if (emptyForm) {
          emptyForm.containerFormKey = self.getForm().formKey;
          emptyForm.containerForm = self.getForm();
          self.itemRender[formKey] = emptyForm;
        }
        return builder.build(emptyForm);
      }).then(function() {
        if (container["mergeOperation"]) {
          return form.resetUIStatus(FormUIStatusMask.OPERATION);
        }
      });
    }
  }
  setSelectTabIndex(tabIndex) {
    if (this.tabGroup.items[tabIndex] && this.tabGroup.items[tabIndex].visible) {
      this.tabGroup.impl && this.tabGroup.impl.setTabContainerByKey(this.tabGroup.items[tabIndex].key);
    }
  }
  getSelectTabIndex() {
    return this.tabGroup.impl && this.tabGroup.impl.getTabContainer();
  }
};
class TabGroup extends BaseControl {
  constructor(meta) {
    super(meta);
    this.items = [];
    this.tabContainer = null;
    this.items = [];
  }
  async doOnClick(key) {
    let onClick = this.getGroupItem(key).onClick;
    return this.handler.doOnClick(this.ofFormID, onClick);
  }
  doOnAction(key) {
    let action = this.getGroupItem(key).action;
    return this.handler.doOnAction(this, action);
  }
  setVisible(key, visible) {
    if (this.getGroupItem(key)) {
      this.getGroupItem(key).visible = visible;
      this.impl && this.impl.setItemVisible(key, visible);
      return true;
    } else {
      return super.setVisible(visible);
    }
  }
  getGroupItem(key) {
    function _getItem(item) {
      return item.key == key;
    }
    return this.items.filter(_getItem)[0];
  }
  addBadge(badge) {
    if (badge[0].indexOf(".") > -1 && badge[0].split(".")[1]) {
      for (var i2 = 0; i2 < this.items.length; i2++) {
        var item = this.items[i2];
        if (badge[0].split(".")[1] == item.key) {
          item["badge"] = badge[1];
        }
      }
    } else {
      this.items[badge[2]] && (this.items[badge[2]]["badge"] = badge[1]);
    }
    this.impl && this.impl.addViewBadge(badge);
  }
  removeBadge(badge) {
    if (badge[0].indexOf(".") > -1 && badge[0].split(".")[1]) {
      for (var i2 = 0; i2 < this.items.length; i2++) {
        var item = this.items[i2];
        if (badge[0].split(".")[1] == item.key) {
          delete item.badge;
        }
      }
    } else {
      this.items[badge[1]] && delete this.items[badge[1]].badge;
    }
    this.impl && this.impl.removeViewBadge(badge);
  }
  async doItemOnClick(key, type) {
    if (type == "onClick") {
      return this.doOnClick(key);
    } else {
      key && this.doOnAction(key);
      this.tabContainer && this.changeGroup(key);
    }
  }
  changeGroup(key) {
    if (key) {
      let formKey = this.getGroupItem(key).formKey;
      this.tabContainer.changeContainer(formKey);
    } else {
      this.tabContainer.changeContainer();
    }
  }
  setSelectTabIndex(tabIndex) {
    if (this.items[tabIndex] && this.items[tabIndex].visible) {
      this.impl && this.impl.setTabContainerByKey(this.items[tabIndex].key);
    }
  }
  getSelectTabIndex() {
    return this.impl && this.impl.getTabContainer();
  }
}
class TextArea extends BaseControl {
  constructor(meta) {
    super(meta);
  }
  checkEnd(value) {
    this.showT