import { ExtendedFieldsParas } from "../fieldparas.js";
/**
 * 扩展字段，基础类型
 */
export default class Control {
    constructor(options) {
        this.options = options;
        this.key = options.key;
        this.tabIndex = options.tabIndex;
        this.container = options.container;
        this.subbtn = options.subbtn;
        this.caption = options.caption;
        this.defaultValue = options.defaultValue;
        this.placeholder = options.placeholder;
        this.visible = options.visible;
    }
    render() {
        this.createHtml();
        this.createInfoHtml();
        this.setPlaceholder();
        this.setDefaultValue();
        this.afterRender();
        this.setVisible();
        this.install();
    }
    createInfoHtml() {
        this.info = document.createElement("div");
        this.info.classList.add('login-info', `login-${this.key}-info`);
    }
    afterRender() {
        if (this.el) {
            this.el.remove();
            this.container.insertBefore(this.el, this.subbtn);
            if (this.info) {
                this.info.remove();
                this.container.insertBefore(this.info, this.subbtn);
            }
            this.el.setAttribute("tabindex", this.tabIndex);
        }
    }
    setVisible() {
        // 处理可见性，如果空的话，不做任何处理
        if (this.el && this.visible !== null && this.visible !== undefined) {
            if (this.visible) {
                this.el.classList.remove("ui-hidden");
                this.info && this.info.classList.remove("ui-hidden");
            } else {
                this.el.classList.add("ui-hidden");
                this.info && this.info.classList.add("ui-hidden");
            }
        }
    }
    commitValue(key, value) {
        ExtendedFieldsParas.setExtendedFieldsParas(key, value);
    }
    setPlaceholder() {
        this.placeholder && this.$inp && this.$inp.setAttribute("placeholder", this.placeholder);
    }
    setDefaultValue() {
        if (this.defaultValue && this.$inp) {
            this.$inp.value = this.defaultValue;
        }
    }
    createHtml() {
    }
    install() {
    }
}