
(function () {
    let path = "";
    class YesRightsSet extends YIUI.YesBaseComponent {
        url;
        iframe;

        constructor(options) {
            super(options);
            this.userID = YIUI.SessionInfo.getUserID();
            this.url = "/" + YIUI.webRoot  + "extension/yescomponent/rights/rightsset.html";
        }

        createHtml() {
            const tempSetting = { ...this.owner.meta };
            tempSetting.userID = this.userID;
            delete tempSetting.el;
            delete tempSetting.constructor;
            var url =
                this.url + "?data=" + encodeURIComponent(JSON.stringify(tempSetting)) + "&r=" + Math.random();
                this.iframe = document.createElement("iframe");
                this.iframe.setAttribute("src", url);
                this.iframe.setAttribute("frmeBorder", 0);
                this.el.addPostpatchHook(() => {
                    this.el.getElm()?.appendChild(this.iframe);
                })

            const self = this;
            window['Service'] = YIUI.RTS_Service;
            window['I18N'] = YIUI.I18N;
        }

        getInput() {}
        getClearBtn() {}

        setHeight(height) {
            if (height == "pref" || height == "auto") {
                height = "100%";
                this.iframe.style.height = height;
            } else if(height.indexOf("%")) {
                this.iframe.style.height = height;
            } else {
                this.iframe.style.height = height + "px";
            }
            if (!this.el.getHeight()) {
                this.el.$setHeight(height);
            }
        }

        setWidth(width) {
            if (width == "pref" || width == "auto") {
                width = "100%";
                this.iframe.style.width = width;
            } else if(width.indexOf("%")) {
                this.iframe.style.width = width;
            } else {
                this.iframe.style.width = width + "px";
            }
        }

        render(ct) {
            super.render(ct);
        }

        afterRender() {
            super.afterRender();
        }
    }
    var yesCustomBuilder = YIUI.BuilderMap.getInstance().get(YIUI.ControlType.CUSTOM);
    if(!yesCustomBuilder) {
        yesCustomBuilder = YIUI.YesCustomBuilder;
    }
    yesCustomBuilder.reg('OperatorRights', YesRightsSet);
    yesCustomBuilder.reg('RoleRights', YesRightsSet);

})();