/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.mid.filter;

import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.mid.auth.IAuthenticationHandler;
import com.bokesoft.yigo.mid.auth.ISSOInfoProvider;
import com.bokesoft.yigo.mid.auth.ISSOLoginProvider;
import com.bokesoft.yigo.mid.auth.SSOLoginInfo;
import com.bokesoft.yigo.mid.filter.c;
import com.bokesoft.yigo.mid.init.YigoAppState;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import com.bokesoft.yigo.mid.session.ISessionInfoMap;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import com.bokesoft.yigo.session.SessionUtils;
import com.bokesoft.yigo.session.YigoClientContextWrapper;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.date.ExceptionUtils;

public class LoginFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(LoginFilter.class);
    private static final Class<ISSOLoginProvider> DEPRECATED_INTERFACE = ISSOLoginProvider.class;
    protected FilterConfig filterConfig;
    protected String loginPage = null;
    private String handler = null;

    public void doFilter(ServletRequest object, ServletResponse servletResponse, FilterChain object2) throws IOException, ServletException {
        boolean bl;
        YigoAppState.checkState();
        object = (HttpServletRequest)object;
        servletResponse = (HttpServletResponse)servletResponse;
        object2 = this.getCookieValue((HttpServletRequest)object, "clientID");
        if (object2 == null || ((String)object2).isEmpty()) {
            object2 = object.getParameter("clientID");
        }
        ISessionInfoMap iSessionInfoMap = SessionInfoProviderHolder.getSimpleProvider().getSessionInfoMap();
        Object object3 = null;
        if (object2 != null && !((String)object2).isEmpty()) {
            object3 = iSessionInfoMap.get((String)object2);
        }
        iSessionInfoMap = this.getSsoInfoProvider();
        object2 = null;
        if (iSessionInfoMap != null) {
            object2 = iSessionInfoMap.parseToken((HttpServletRequest)object);
        }
        if (!(bl = this.doHandleSsoLogin((ISessionInfo)object3, (SSOLoginInfo)object2, (HttpServletRequest)object, (HttpServletResponse)servletResponse)) && this.handler != null) {
            object3 = null;
            try {
                object3 = (IAuthenticationHandler)Class.forName(this.handler).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                ExceptionUtils.rethrow((Throwable)exception);
            }
            if (object3 != null) {
                bl = object3.authenticate((HttpServletRequest)object, (HttpServletResponse)servletResponse);
            }
        }
        if (!bl) {
            if (iSessionInfoMap != null) {
                object3 = this.getSourceUrl((HttpServletRequest)object);
                object = iSessionInfoMap.buildLoginPage((String)object3);
                servletResponse.sendRedirect((String)object);
                return;
            }
            object.getRequestDispatcher(this.loginPage).forward(object, servletResponse);
            return;
        }
        object3 = this.getCookieValue((HttpServletRequest)object, "servletPath");
        if (!object.getServletPath().equals(this.loginPage)) {
            if (object3 == null) {
                object3 = object.getServletPath();
            }
            object.getRequestDispatcher((String)object3).forward(object, servletResponse);
            return;
        }
        if (object3 == null) {
            object = object.getRequestURL().toString().replace(this.loginPage, "");
            servletResponse.sendRedirect((String)object);
        }
    }

    private String getSourceUrl(HttpServletRequest object) {
        String string = CoreSetting.getInstance().getExternalBaseUrl();
        if (StringUtils.isBlank((CharSequence)string)) {
            String string2 = object.getHeader("X-Forwarded-Proto");
            if (string2 == null) {
                string2 = object.getScheme();
            }
            string = object.getHeader("Host");
            String string3 = object.getHeader("X-Original-URL");
            if (string3 == null) {
                string3 = object.getContextPath();
                if ((object = object.getQueryString()) != null) {
                    string3 = string3 + "?" + (String)object;
                }
            }
            return string2 + "://" + string + string3;
        }
        string = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
        String string4 = object.getServletPath();
        string = string + string4;
        String string5 = object.getQueryString();
        if (string5 != null) {
            string = string + "?" + string5;
        }
        return string;
    }

    private String getCookieValue(HttpServletRequest cookieArray, String string) {
        String string2 = null;
        if ((cookieArray = cookieArray.getCookies()) != null) {
            for (int i = 0; i < cookieArray.length; ++i) {
                Cookie cookie = cookieArray[i];
                if (!cookie.getName().equalsIgnoreCase(string)) continue;
                string2 = cookie.getValue();
                break;
            }
        }
        return string2;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.loginPage = filterConfig.getInitParameter("loginpage");
        this.handler = filterConfig.getInitParameter("AuthenticationHandler");
    }

    public void destroy() {
    }

    private ISSOInfoProvider getSsoInfoProvider() {
        ISSOInfoProvider iSSOInfoProvider = null;
        Object object = MetaFactory.getGlobalInstance().getSetting().getLogin();
        if (object != null && !StringUtils.isBlank((CharSequence)(object = object.getSSOProvider()))) {
            try {
                iSSOInfoProvider = Class.forName((String)object);
                if (DEPRECATED_INTERFACE.isAssignableFrom((Class<?>)iSSOInfoProvider)) {
                    log.warn("\u5f53\u524d Class {} \u5b9e\u73b0\u7684\u63a5\u53e3 {} \u5df2\u8fc7\u65f6, \u5efa\u8bae\u6539\u4e3a\u5b9e\u73b0 {} \u63a5\u53e3", new Object[]{DEPRECATED_INTERFACE, iSSOInfoProvider, ISSOInfoProvider.class});
                    return null;
                }
                iSSOInfoProvider = (ISSOInfoProvider)iSSOInfoProvider.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                return (ISSOInfoProvider)ExceptionUtils.rethrow((Throwable)exception);
            }
        }
        return iSSOInfoProvider;
    }

    private boolean doHandleSsoLogin(ISessionInfo object, SSOLoginInfo sSOLoginInfo, HttpServletRequest object2, HttpServletResponse object3) {
        if (object == null && sSOLoginInfo == null) {
            return false;
        }
        if (object != null && sSOLoginInfo == null) {
            return true;
        }
        object3 = new c(this, (HttpServletRequest)object2, (HttpServletResponse)object3);
        if (object == null && sSOLoginInfo != null) {
            object = sSOLoginInfo.getUserCode();
            Map map = sSOLoginInfo.getParams();
            if (StringUtils.isNotBlank((CharSequence)(object2 = object2.getLocale().toLanguageTag()))) {
                sSOLoginInfo.putParam("locale", object2);
            }
            return SessionUtils.ssoLogin((String)object, (Map)map, (YigoClientContextWrapper)object3) != null;
        }
        if (object != null && sSOLoginInfo != null) {
            if (this.needRelogin((ISessionInfo)object, sSOLoginInfo)) {
                SessionUtils.logout((String)object.getClientID());
                object = sSOLoginInfo.getUserCode();
                Map map = sSOLoginInfo.getParams();
                object2 = object2.getLocale().toLanguageTag();
                if (StringUtils.isNotBlank((CharSequence)object2)) {
                    sSOLoginInfo.putParam("locale", object2);
                }
                return SessionUtils.ssoLogin((String)object, (Map)map, (YigoClientContextWrapper)object3) != null;
            }
            return true;
        }
        return false;
    }

    private boolean needRelogin(ISessionInfo object, SSOLoginInfo object2) {
        if (!StringUtils.equalsIgnoreCase((CharSequence)object.getUserCode(), (CharSequence)object2.getUserCode())) {
            return true;
        }
        if ((object2 = object2.getParams()) != null) {
            object = object.getSessionParas();
            for (Map.Entry entry : object2.entrySet()) {
                String string = (String)entry.getKey();
                entry = entry.getValue();
                string = object.get(string);
                if (entry == null || ((Object)entry).equals(string)) continue;
                return true;
            }
        }
        return false;
    }
}

