/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.web.util;

import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONObject;

public class YigoGridVariantUtil {
    private static final String QueryVariantList = "Select * from YES_Core_Grid_FV where (OperatorID = ? or IsGlobal = ?)  and VariantPrefix=? ORDER BY IsGlobal, IsDefault desc";
    private static final String QueryDefaultVariantByForm = "Select * from YES_Core_Grid_FV where VariantType=? and  (OperatorID = ? or IsGlobal = ?) and IsDefault = ? and FormKey=? ORDER BY VariantPrefix,IsGlobal";
    private static final String UpdateVariantDefault = "UPDATE YES_Core_Grid_FV SET IsDefault=? WHERE VariantPrefix=? and OperatorID=? and IsGlobal=?";
    private static final String UpdateVariantDefault4Global = "UPDATE YES_Core_Grid_FV SET IsDefault=? WHERE VariantPrefix=? and IsGlobal=?";
    private static final String UpdateVariant = "UPDATE YES_Core_Grid_FV SET Name=?, OperatorID=?, VariantType=?, VariantPrefix=?, FormKey=?, IsDefault=?, IsGlobal=?, Content=? WHERE oid=?";
    private static final String InsertVariant = "INSERT INTO YES_Core_Grid_FV(OID, SOID, Code, Name, UseCode, OperatorID, FormKey, IsDefault, IsGlobal, VariantType, VariantPrefix, Content, CreateTime) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String QueryVariantByCode = "Select * from YES_Core_Grid_FV where (OperatorID = ? or IsGlobal = ?) and formKey = ? and UseCode=? and VariantPrefix=?";

    public static JSONArray LoadVariantList(DefaultContext defaultContext, String string) throws Throwable {
        long l = defaultContext.getUserID();
        defaultContext = defaultContext.getDBManager().execPrepareQuery(QueryVariantList, new Object[]{l, 1, string});
        string = new JSONArray();
        defaultContext.beforeFirst();
        while (defaultContext.next()) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("Code", (Object)defaultContext.getString("UseCode"));
            jSONObject.put("Description", (Object)defaultContext.getString("Name"));
            jSONObject.put("IsDefault", (Object)defaultContext.getInt("IsDefault"));
            if (defaultContext.getInt("IsGlobal") == 0) {
                jSONObject.put("IsPersonal", 1);
            } else {
                jSONObject.put("IsPersonal", 0);
            }
            string.put((Object)jSONObject);
        }
        return string;
    }

    public static JSONObject LoadVariantByForm(DefaultContext defaultContext, String stringArray) throws Throwable {
        long l = defaultContext.getUserID();
        JSONObject jSONObject = new JSONObject();
        defaultContext = defaultContext.getDBManager().execPrepareQuery(QueryDefaultVariantByForm, new Object[]{"GridSetting", l, 1, 1, stringArray});
        defaultContext.beforeFirst();
        while (defaultContext.next()) {
            stringArray = defaultContext.getString("VariantPrefix").split("\\.");
            if (jSONObject.has(stringArray[2])) continue;
            JSONObject jSONObject2 = new JSONObject(defaultContext.getString("Content"));
            jSONObject2.put("variantCode", (Object)defaultContext.getString("UseCode"));
            jSONObject2.put("variantName", (Object)defaultContext.getString("Name"));
            jSONObject.put(stringArray[2], (Object)jSONObject2);
        }
        return jSONObject;
    }

    public static JSONObject LoadVariantByCode(DefaultContext defaultContext, String string, String string2, String string3, String string4) throws Throwable {
        long l = defaultContext.getUserID();
        string2 = new JSONObject();
        if ((defaultContext = defaultContext.getDBManager().execPrepareQuery(QueryVariantByCode, new Object[]{l, 1, string, string3, string4})).first()) {
            string2 = new JSONObject(defaultContext.getString("Content"));
        }
        return string2;
    }

    private static void clearDefaultVariant(IDBManager iDBManager, String string, int n, long l) throws Throwable {
        if (n == 0) {
            iDBManager.execPrepareUpdate(UpdateVariantDefault, new Object[]{0, string, l, 0});
            return;
        }
        iDBManager.execPrepareUpdate(UpdateVariantDefault4Global, new Object[]{0, string, 1});
    }

    public static void SaveVariant(DefaultContext defaultContext, String string, String string2, String string3, String string4, String string5, int n, int n2) throws Throwable {
        String[] stringArray = string5.split("\\.");
        long l = defaultContext.getUserID();
        IDBManager iDBManager = defaultContext.getDBManager();
        if (n2 == 1) {
            YigoGridVariantUtil.clearDefaultVariant(iDBManager, string5, n, l);
        }
        String string6 = string5 + "." + string2 + "." + l;
        DataTable dataTable = iDBManager.execPrepareQuery(QueryVariantByCode, new Object[]{l, 1, string, string2, string5});
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (dataTable.first()) {
            long l2 = dataTable.getLong("OID");
            arrayList.add(string3);
            arrayList.add(l);
            arrayList.add(stringArray[0]);
            arrayList.add(string5);
            arrayList.add(stringArray[1]);
            arrayList.add(n2);
            arrayList.add(n);
            arrayList.add(string4);
            arrayList.add(l2);
            iDBManager.execPrepareUpdate(UpdateVariant, arrayList);
            return;
        }
        long l3 = defaultContext.applyNewOID();
        arrayList.add(l3);
        arrayList.add(l3);
        arrayList.add(string6);
        arrayList.add(string3);
        arrayList.add(string2);
        arrayList.add(l);
        arrayList.add(string);
        arrayList.add(n2);
        arrayList.add(n);
        arrayList.add(stringArray[0]);
        arrayList.add(string5);
        arrayList.add(string4);
        arrayList.add(new Date());
        iDBManager.execPrepareUpdate(InsertVariant, arrayList);
    }
}

