/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.web.util;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.mid.web.util.GetMetaReportsUtil;
import com.bokesoft.yes.mid.web.util.PdfUtil;
import com.bokesoft.yes.mid.web.util.PrintUtil;
import com.bokesoft.yes.report.MidBatchReportFill;
import com.bokesoft.yes.report.MidQueryProxy;
import com.bokesoft.yes.report.MidReportResourceResolver;
import com.bokesoft.yes.report.ReportDataSource;
import com.bokesoft.yes.report.datasource.IImplReportDataSource;
import com.bokesoft.yes.report.fill.FillPolicy;
import com.bokesoft.yes.report.gridreport.GridFillPageSplit;
import com.bokesoft.yes.report.gridreport.GridReportProperty;
import com.bokesoft.yes.report.output.OutputPageSet;
import com.bokesoft.yes.report.output.OutputSection;
import com.bokesoft.yes.report.print.pdfexport.IPDFUnitTrans;
import com.bokesoft.yes.report.print.pdfexport.PDFReportExport;
import com.bokesoft.yes.report.print.pdfexport.PDFTransContext;
import com.bokesoft.yes.report.print.pdfexport.PDFUnitTrans;
import com.bokesoft.yes.report.print.transform.IReportExport;
import com.bokesoft.yes.report.print.transform.ITransformContext;
import com.bokesoft.yes.report.print.transform.ReportTransform;
import com.bokesoft.yes.report.proxy.IQueryProxy;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.ui.AbstractRuntimeUIConfig;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.report.delegate.IResourceResolver;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.tools.ve.VE;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class PrintPDF {
    private String formKey;
    private List<MetaReport> metaReports;
    private boolean fillEmptyPrint = false;
    private boolean printSelect = false;

    public PrintPDF(String string, boolean bl) {
        this(string, new ArrayList<MetaReport>(), bl);
    }

    public PrintPDF(String string, MetaReport metaReport, boolean bl) {
        this(string, Arrays.asList(metaReport), bl);
    }

    public PrintPDF(String string, MetaReport metaReport, boolean bl, boolean bl2) {
        this(string, Arrays.asList(metaReport), bl, bl2);
    }

    public PrintPDF(String string, List<MetaReport> list, boolean bl) {
        this.formKey = string;
        this.metaReports = list;
        this.fillEmptyPrint = bl;
    }

    public PrintPDF(String string, List<MetaReport> list, boolean bl, boolean bl2) {
        this.formKey = string;
        this.metaReports = list;
        this.fillEmptyPrint = bl;
        this.printSelect = bl2;
    }

    public ByteArrayOutputStream printPDF(DefaultContext defaultContext, Document document) throws Throwable {
        return this.printPDF(defaultContext, document, null);
    }

    public ByteArrayOutputStream printPDF(DefaultContext defaultContext, Document document, AbstractRuntimeUIConfig abstractRuntimeUIConfig) throws Throwable {
        ArrayList<ByteArrayOutputStream> arrayList = new ArrayList<ByteArrayOutputStream>();
        for (Object object : this.metaReports) {
            object = this.printPDF(defaultContext, document, (MetaReport)object, abstractRuntimeUIConfig);
            arrayList.add((ByteArrayOutputStream)object);
        }
        if (arrayList.size() > 1) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PdfUtil.compressPdf(arrayList, byteArrayOutputStream);
            return byteArrayOutputStream;
        }
        if (arrayList.size() == 1) {
            return (ByteArrayOutputStream)arrayList.get(0);
        }
        return new ByteArrayOutputStream();
    }

    public ByteArrayOutputStream printPDF(DefaultContext defaultContext, Document document, MetaReport metaReport, AbstractRuntimeUIConfig object) throws Throwable {
        OutputPageSet outputPageSet = new OutputPageSet();
        MidQueryProxy midQueryProxy = new MidQueryProxy(defaultContext, this.formKey);
        document = PrintUtil.checkTableReload(this.formKey, document, defaultContext, this.printSelect);
        document = new ReportDataSource((VE)defaultContext.getVE(), (IQueryProxy)midQueryProxy, document, defaultContext.getParas(), this.formKey, object);
        new FillPolicy(metaReport, (IImplReportDataSource)document, defaultContext.getParas()).fill(outputPageSet);
        document = new PDFReportExport((IPDFUnitTrans)new PDFUnitTrans());
        document = new ReportTransform((IReportExport)document);
        object = new ByteArrayOutputStream();
        defaultContext = new PDFTransContext((IResourceResolver)new MidReportResourceResolver((VE)defaultContext.getVE(), this.formKey, metaReport.getProjectKey()), (OutputStream)object);
        defaultContext.setOnlyFillEmptyContent(this.fillEmptyPrint);
        document.export((ITransformContext)defaultContext, outputPageSet, 0, outputPageSet.size() - 1);
        return object;
    }

    public ByteArrayOutputStream batchPrintPdf(DefaultContext defaultContext, LinkedList<Long> linkedList) throws Throwable {
        ArrayList<ByteArrayOutputStream> arrayList = new ArrayList<ByteArrayOutputStream>();
        for (Object object : this.metaReports) {
            object = this.batchPrintPdf(defaultContext, linkedList, (MetaReport)object);
            arrayList.add((ByteArrayOutputStream)object);
        }
        if (arrayList.size() > 1) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PdfUtil.compressPdf(arrayList, byteArrayOutputStream);
            return byteArrayOutputStream;
        }
        if (arrayList.size() == 1) {
            return (ByteArrayOutputStream)arrayList.get(0);
        }
        return new ByteArrayOutputStream();
    }

    public ByteArrayOutputStream batchPrintPdf(DefaultContext defaultContext, LinkedList<Long> outputPageSet, MetaReport metaReport) throws Throwable {
        outputPageSet = new MidBatchReportFill((VE)defaultContext.getVE(), metaReport, this.formKey, outputPageSet, defaultContext.getParas()).fill(defaultContext);
        PDFReportExport pDFReportExport = new PDFReportExport((IPDFUnitTrans)new PDFUnitTrans());
        pDFReportExport = new ReportTransform((IReportExport)pDFReportExport);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        defaultContext = new PDFTransContext((IResourceResolver)new MidReportResourceResolver((VE)defaultContext.getVE(), this.formKey, metaReport.getProjectKey()), (OutputStream)byteArrayOutputStream);
        defaultContext.setOnlyFillEmptyContent(this.fillEmptyPrint);
        pDFReportExport.export((ITransformContext)defaultContext, outputPageSet, 0, outputPageSet.size() - 1);
        return byteArrayOutputStream;
    }

    public ByteArrayOutputStream printGridPdf(DefaultContext defaultContext, OutputSection outputSection) throws Throwable {
        OutputPageSet outputPageSet = new OutputPageSet();
        outputSection = new GridFillPageSplit(new GridReportProperty(), outputSection);
        outputSection.vertSplit(outputPageSet);
        outputSection.horzSplit(outputPageSet);
        outputSection = new PDFReportExport((IPDFUnitTrans)new PDFUnitTrans());
        outputSection = new ReportTransform((IReportExport)outputSection);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        defaultContext = new PDFTransContext((IResourceResolver)new MidReportResourceResolver((VE)defaultContext.getVE(), this.formKey, ""), (OutputStream)byteArrayOutputStream);
        outputSection.export((ITransformContext)defaultContext, outputPageSet, 0, outputPageSet.size() - 1);
        return byteArrayOutputStream;
    }

    public static List<String> transReportKeyList(String stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (StringUtil.instr((String)stringArray, (String)"|", (String)"")) {
            stringArray = StringUtil.split((String)stringArray, (String)"|");
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String string = stringArray[j].trim();
                if (StringUtil.isBlankOrNull((String)string)) continue;
                arrayList.add(string);
            }
        } else {
            arrayList.add((String)stringArray);
        }
        return arrayList;
    }

    public static List<MetaReport> getMetaReports(String string, List<String> list, DefaultContext defaultContext) throws Throwable {
        if ((list = GetMetaReportsUtil.getMetaReports(string, list, defaultContext)).size() == 0) {
            throw new MetaException(87, SimpleStringFormat.format((String)StringTable.getString((ILocale)defaultContext.getEnv(), (String)"", (String)"NoPrintTemplateDefined"), (Object[])new Object[]{string}));
        }
        return list;
    }
}

