/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.web.cmd.imge;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.web.cmd.imge.MobileImageDpiUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.util.MetaResolverUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.file.util.AttachmentUtil;
import com.bokesoft.yigo.tools.ve.VE;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.swing.ImageIcon;

public class DownloadBase64ImageCmd
extends DefaultServiceCmd {
    private String formKey = "";
    private String path = "";
    private String project = "";
    private int sourceType = -1;
    private int dpi = -1;
    private int deviceType = -1;
    private boolean isThumbnail = false;

    public DownloadBase64ImageCmd() {
    }

    public DownloadBase64ImageCmd(String string, String string2) {
        this.formKey = string;
        this.path = string2;
    }

    public DownloadBase64ImageCmd(String string, String string2, int n, int n2, int n3) {
        this.formKey = string;
        this.path = string2;
        this.sourceType = n;
        this.dpi = n2;
        this.deviceType = n3;
    }

    public void dealArguments(DefaultContext defaultContext, StringHashMap<Object> stringHashMap) throws Throwable {
        this.path = TypeConvertor.toString((Object)stringHashMap.get((Object)"path"));
        this.formKey = TypeConvertor.toString((Object)stringHashMap.get((Object)"formKey"));
        if (stringHashMap.get((Object)"sourceType") != null) {
            this.sourceType = TypeConvertor.toInteger((Object)stringHashMap.get((Object)"sourceType"));
        }
        if (stringHashMap.containsKey((Object)"dpi")) {
            this.dpi = TypeConvertor.toInteger((Object)stringHashMap.get((Object)"dpi"));
        }
        if (stringHashMap.containsKey((Object)"deviceType")) {
            this.deviceType = TypeConvertor.toInteger((Object)stringHashMap.get((Object)"deviceType"));
        }
        if (stringHashMap.containsKey((Object)"thumbnail")) {
            this.isThumbnail = TypeConvertor.toBoolean((Object)stringHashMap.get((Object)"thumbnail"));
        }
        if (stringHashMap.containsKey((Object)"project")) {
            this.project = TypeConvertor.toString((Object)stringHashMap.get((Object)"project"));
        }
    }

    public Object doCmd(DefaultContext defaultContext) throws Throwable {
        Object object;
        this.path = this.path.replace("\\", "/");
        this.path = MobileImageDpiUtil.getdpiPathForDevice(defaultContext, this.path, this.sourceType, this.dpi, this.deviceType, this.formKey);
        if (!(this.sourceType != 1 && this.sourceType != -1 || this.formKey == null || this.formKey.isEmpty())) {
            byte[] byArray = (byte[])AttachmentUtil.newProvider((String)"", (VE)defaultContext.getVE()).download(defaultContext, this.formKey, this.path);
            object = byArray;
            if (byArray != null) {
                return new ByteArrayInputStream((byte[])object);
            }
        }
        defaultContext = defaultContext.getVE().getMetaFactory();
        if (this.project == null || this.project.isEmpty()) {
            object = defaultContext.getMetaForm(this.formKey);
            this.project = object.getProject().getKey();
        }
        return MetaResolverUtil.loadResourceInputStream((IMetaFactory)defaultContext, (String)this.formKey, (String)("/Resource/" + this.path));
    }

    private InputStream compressFile(InputStream object) {
        if (this.sourceType != 1) {
            return object;
        }
        if (!this.isThumbnail) {
            return object;
        }
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            object = ImageIO.read((InputStream)object);
            ((Image)object).flush();
            object = DownloadBase64ImageCmd.toBufferedImage((Image)object);
            if (object != null) {
                ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("jpeg").next();
                ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
                imageWriteParam.setCompressionMode(2);
                imageWriteParam.setCompressionQuality(0.1f);
                imageWriteParam.setProgressiveMode(0);
                Object object2 = ColorModel.getRGBdefault();
                ColorModel colorModel = object2;
                imageWriteParam.setDestinationType(new ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(16, 16)));
                object2 = new ByteArrayOutputStream();
                object = new IIOImage((RenderedImage)object, null, null);
                imageWriter.setOutput(ImageIO.createImageOutputStream(object2));
                imageWriter.write(null, (IIOImage)object, imageWriteParam);
                object = ((ByteArrayOutputStream)object2).toByteArray();
                byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayInputStream;
    }

    public IServiceCmd<DefaultContext> newInstance() {
        return new DownloadBase64ImageCmd();
    }

    public String getCmd() {
        return "DownloadBase64Image";
    }

    public boolean getNeedServiceRight() {
        return true;
    }

    private static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        ImageIcon imageIcon = new ImageIcon(image);
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 9);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.drawImage(image, 0, 0, imageIcon.getImageObserver());
        for (int j = 0; j < bufferedImage.getWidth(null); ++j) {
            for (int k = 0; k < bufferedImage.getHeight(null); ++k) {
                if (bufferedImage.getRGB(j, k) != -16777216) continue;
                bufferedImage.setRGB(j, k, 0xFFFFFF);
            }
        }
        graphics2D.drawImage(image, 0, 0, imageIcon.getImageObserver());
        graphics2D.dispose();
        return bufferedImage;
    }
}

